/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.features;

import com.google.common.net.InternetDomainName;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.OwnerReference;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodFluentImpl;
import io.fabric8.kubernetes.api.model.Quantity;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.spark.SecurityManager;
import org.apache.spark.SecurityManager$;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkConf$;
import org.apache.spark.SparkException;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesExecutorConf;
import org.apache.spark.deploy.k8s.KubernetesTestConf$;
import org.apache.spark.deploy.k8s.SecretVolumeUtils$;
import org.apache.spark.deploy.k8s.SparkPod;
import org.apache.spark.deploy.k8s.SparkPod$;
import org.apache.spark.deploy.k8s.features.BasicExecutorFeatureStep;
import org.apache.spark.deploy.k8s.features.KubernetesFeaturesTestUtils;
import org.apache.spark.deploy.k8s.features.KubernetesFeaturesTestUtils$;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.internal.config.Python$;
import org.apache.spark.internal.config.package$;
import org.apache.spark.resource.ExecutorResourceRequests;
import org.apache.spark.resource.ResourceID;
import org.apache.spark.resource.ResourceProfile;
import org.apache.spark.resource.ResourceProfile$;
import org.apache.spark.resource.ResourceProfileBuilder;
import org.apache.spark.resource.ResourceUtils$;
import org.apache.spark.resource.TaskResourceRequests;
import org.apache.spark.resource.TestResourceIDs$;
import org.apache.spark.rpc.RpcEndpointAddress;
import org.apache.spark.rpc.RpcEndpointAddress$;
import org.apache.spark.scheduler.cluster.CoarseGrainedSchedulerBackend$;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfter;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Status;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005eg\u0001B\u0013'\u0001MBQA\u0010\u0001\u0005\u0002}BqA\u0011\u0001C\u0002\u0013%1\t\u0003\u0004M\u0001\u0001\u0006I\u0001\u0012\u0005\b\u001b\u0002\u0011\r\u0011\"\u0003O\u0011\u0019)\u0006\u0001)A\u0005\u001f\"9a\u000b\u0001b\u0001\n\u00139\u0006B\u00020\u0001A\u0003%\u0001\fC\u0004`\u0001\t\u0007I\u0011B\"\t\r\u0001\u0004\u0001\u0015!\u0003E\u0011\u001d\t\u0007A1A\u0005\n\rCaA\u0019\u0001!\u0002\u0013!\u0005bB2\u0001\u0005\u0004%Ia\u0011\u0005\u0007I\u0002\u0001\u000b\u0011\u0002#\t\u000f\u0015\u0004!\u0019!C\u0005\u0007\"1a\r\u0001Q\u0001\n\u0011Cqa\u001a\u0001C\u0002\u0013%\u0001\u000e\u0003\u0004r\u0001\u0001\u0006I!\u001b\u0005\ne\u0002\u0001\r\u00111A\u0005\nMD\u0011B\u001f\u0001A\u0002\u0003\u0007I\u0011B>\t\u0015\u0005\r\u0001\u00011A\u0001B\u0003&A\u000fC\u0005\u0002\u0006\u0001\u0011\r\u0011\"\u0003\u0002\b!A\u0011\u0011\u0003\u0001!\u0002\u0013\tI\u0001C\u0005\u0002\u0014\u0001\u0011\r\u0011\"\u0003\u0002\u0016!A\u0011Q\u0007\u0001!\u0002\u0013\t9\u0002C\u0005\u00028\u0001\u0011\r\u0011\"\u0003\u0002:!A\u0011\u0011\t\u0001!\u0002\u0013\tY\u0004C\u0006\u0002D\u0001\u0001\r\u00111A\u0005\n\u0005\u0015\u0003bCA'\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u001fB1\"a\u0015\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002H!9\u0011Q\u000b\u0001\u0005\n\u0005]\u0003\"CA?\u0001E\u0005I\u0011BA@\u0011\u001d\t)\n\u0001C\u0005\u0003/Cq!a'\u0001\t\u0003\ti\nC\u0004\u0002*\u0002!I!a+\t\u000f\u0005U\u0006\u0001\"\u0003\u00028\"9\u00111\u001a\u0001\u0005\n\u00055'!\b\"bg&\u001cW\t_3dkR|'OR3biV\u0014Xm\u0015;faN+\u0018\u000e^3\u000b\u0005\u001dB\u0013\u0001\u00034fCR,(/Z:\u000b\u0005%R\u0013aA69g*\u00111\u0006L\u0001\u0007I\u0016\u0004Hn\\=\u000b\u00055r\u0013!B:qCJ\\'BA\u00181\u0003\u0019\t\u0007/Y2iK*\t\u0011'A\u0002pe\u001e\u001c\u0001aE\u0002\u0001ia\u0002\"!\u000e\u001c\u000e\u00031J!a\u000e\u0017\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f!\tID(D\u0001;\u0015\tY\u0004'A\u0005tG\u0006d\u0017\r^3ti&\u0011QH\u000f\u0002\u000f\u0005\u00164wN]3B]\u0012\fe\r^3s\u0003\u0019a\u0014N\\5u}Q\t\u0001\t\u0005\u0002B\u00015\ta%A\bE%&3VIU0I\u001fN#f*Q'F+\u0005!\u0005CA#K\u001b\u00051%BA$I\u0003\u0011a\u0017M\\4\u000b\u0003%\u000bAA[1wC&\u00111J\u0012\u0002\u0007'R\u0014\u0018N\\4\u0002!\u0011\u0013\u0016JV#S?\"{5\u000b\u0016(B\u001b\u0016\u0003\u0013a\u0003#S\u0013Z+%k\u0018)P%R+\u0012a\u0014\t\u0003!Nk\u0011!\u0015\u0006\u0002%\u0006)1oY1mC&\u0011A+\u0015\u0002\u0004\u0013:$\u0018\u0001\u0004#S\u0013Z+%k\u0018)P%R\u0003\u0013A\u0004#S\u0013Z+%kX!E\tJ+5kU\u000b\u00021B\u0011\u0011\fX\u0007\u00025*\u00111\fL\u0001\u0004eB\u001c\u0017BA/[\u0005I\u0011\u0006oY#oIB|\u0017N\u001c;BI\u0012\u0014Xm]:\u0002\u001f\u0011\u0013\u0016JV#S?\u0006#EIU#T'\u0002\nq\u0002\u0012*J-\u0016\u0013v\fU(E?:\u000bU*R\u0001\u0011\tJKe+\u0012*`!>#uLT!N\u000b\u0002\na\u0002\u0012*J-\u0016\u0013v\fU(E?VKE)A\bE%&3VIU0Q\u001f\u0012{V+\u0013#!\u0003Q\u0011ViU(V%\u000e+uLT!N\u000b~\u0003&+\u0012$J1\u0006)\"+R*P+J\u001bUi\u0018(B\u001b\u0016{\u0006KU#G\u0013b\u0003\u0013AD#Y\u000b\u000e+Fk\u0014*`\u00136\u000bu)R\u0001\u0010\u000bb+5)\u0016+P%~KU*Q$FA\u000512)V*U\u001f6{V\tW#D+R{%k\u0018'B\u0005\u0016c5+F\u0001j!\u0011Qw\u000e\u0012#\u000e\u0003-T!\u0001\\7\u0002\u0013%lW.\u001e;bE2,'B\u00018R\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003a.\u00141!T1q\u0003]\u0019Uk\u0015+P\u001b~+\u0005,R\"V)>\u0013v\fT!C\u000b2\u001b\u0006%\u0001\beK\u001a\fW\u000f\u001c;Qe>4\u0017\u000e\\3\u0016\u0003Q\u0004\"!\u001e=\u000e\u0003YT!a\u001e\u0017\u0002\u0011I,7o\\;sG\u0016L!!\u001f<\u0003\u001fI+7o\\;sG\u0016\u0004&o\u001c4jY\u0016\f!\u0003Z3gCVdG\u000f\u0015:pM&dWm\u0018\u0013fcR\u0011Ap \t\u0003!vL!A`)\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003\u0003\u0019\u0012\u0011!a\u0001i\u0006\u0019\u0001\u0010J\u0019\u0002\u001f\u0011,g-Y;miB\u0013xNZ5mK\u0002\nq\u0003V#T)~KU*Q$F?B+F\nT0T\u000b\u000e\u0013V\tV*\u0016\u0005\u0005%\u0001#BA\u0006\u0003\u001b!U\"A7\n\u0007\u0005=QNA\u0002TKF\f\u0001\u0004V#T)~KU*Q$F?B+F\nT0T\u000b\u000e\u0013V\tV*!\u0003y!Vi\u0015+`\u00136\u000bu)R0Q+2culU#D%\u0016#vl\u0014\"K\u000b\u000e#6+\u0006\u0002\u0002\u0018A1\u00111BA\u0007\u00033\u0001B!a\u0007\u000225\u0011\u0011Q\u0004\u0006\u0005\u0003?\t\t#A\u0003n_\u0012,GN\u0003\u0003\u0002$\u0005\u0015\u0012aA1qS*!\u0011qEA\u0015\u0003)YWOY3s]\u0016$Xm\u001d\u0006\u0005\u0003W\ti#A\u0004gC\n\u0014\u0018n\u0019\u001d\u000b\u0005\u0005=\u0012AA5p\u0013\u0011\t\u0019$!\b\u0003)1{7-\u00197PE*,7\r\u001e*fM\u0016\u0014XM\\2f\u0003}!Vi\u0015+`\u00136\u000bu)R0Q+2culU#D%\u0016#vl\u0014\"K\u000b\u000e#6\u000bI\u0001\u000b\tJKe+\u0012*`!>#UCAA\u001e!\u0011\tY\"!\u0010\n\t\u0005}\u0012Q\u0004\u0002\u0004!>$\u0017a\u0003#S\u0013Z+%k\u0018)P\t\u0002\n\u0001BY1tK\u000e{gNZ\u000b\u0003\u0003\u000f\u00022!NA%\u0013\r\tY\u0005\f\u0002\n'B\f'o[\"p]\u001a\fABY1tK\u000e{gNZ0%KF$2\u0001`A)\u0011%\t\t\u0001HA\u0001\u0002\u0004\t9%A\u0005cCN,7i\u001c8gA\u0005ya.Z<Fq\u0016\u001cW\u000f^8s\u0007>tg\r\u0006\u0003\u0002Z\u0005\u0005\u0004\u0003BA.\u0003;j\u0011\u0001K\u0005\u0004\u0003?B#AF&vE\u0016\u0014h.\u001a;fg\u0016CXmY;u_J\u001cuN\u001c4\t\u0013\u0005\rd\u0004%AA\u0002\u0005\u0015\u0014aC3om&\u0014xN\\7f]R\u0004\u0002\"a\u001a\u0002v\u0005e\u0014\u0011\u0010\b\u0005\u0003S\n\t\bE\u0002\u0002lEk!!!\u001c\u000b\u0007\u0005=$'\u0001\u0004=e>|GOP\u0005\u0004\u0003g\n\u0016A\u0002)sK\u0012,g-C\u0002q\u0003oR1!a\u001dR!\u0011\t9'a\u001f\n\u0007-\u000b9(A\roK^,\u00050Z2vi>\u00148i\u001c8gI\u0011,g-Y;mi\u0012\nTCAAAU\u0011\t)'a!,\u0005\u0005\u0015\u0005\u0003BAD\u0003#k!!!#\u000b\t\u0005-\u0015QR\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a$R\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003'\u000bIIA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f!#\u001b8ji\u0012+g-Y;miB\u0013xNZ5mKR\u0019A0!'\t\u000f\u0005\r\u0003\u00051\u0001\u0002H\u0005\tr/\u001b;i!>$g*Y7f!J,g-\u001b=\u0015\u0007q\fy\n\u0003\u0005\u0002\"\u0006\"\t\u0019AAR\u0003\u00051\u0007\u0003\u0002)\u0002&rL1!a*R\u0005!a$-\u001f8b[\u0016t\u0014\u0001F2iK\u000e\\wj\u001e8feJ+g-\u001a:f]\u000e,7\u000fF\u0003}\u0003[\u000b\t\fC\u0004\u00020\n\u0002\r!a\u000f\u0002\u0011\u0015DXmY;u_JDq!a-#\u0001\u0004\tI(\u0001\u0007ee&4XM\u001d)pIVKG-\u0001\u0005dQ\u0016\u001c7.\u00128w)\u001da\u0018\u0011XAb\u0003\u000fDq!a/$\u0001\u0004\ti,A\u0006fq\u0016\u001cW\u000f^8s!>$\u0007\u0003BA.\u0003\u007fK1!!1)\u0005!\u0019\u0006/\u0019:l!>$\u0007bBAcG\u0001\u0007\u0011qI\u0001\u0005G>tg\rC\u0004\u0002J\u000e\u0002\r!!\u001a\u0002#\u0005$G-\u001b;j_:\fG.\u00128w-\u0006\u00148/A\bb[>,h\u000e^!oI\u001a{'/\\1u)\u0011\tI(a4\t\u000f\u0005EG\u00051\u0001\u0002T\u0006A\u0011/^1oi&$\u0018\u0010\u0005\u0003\u0002\u001c\u0005U\u0017\u0002BAl\u0003;\u0011\u0001\"U;b]RLG/\u001f")
public class BasicExecutorFeatureStepSuite
extends SparkFunSuite
implements BeforeAndAfter {
    private final String DRIVER_HOSTNAME;
    private final int DRIVER_PORT;
    private final RpcEndpointAddress DRIVER_ADDRESS;
    private final String DRIVER_POD_NAME;
    private final String DRIVER_POD_UID;
    private final String RESOURCE_NAME_PREFIX;
    private final String EXECUTOR_IMAGE;
    private final scala.collection.immutable.Map<String, String> CUSTOM_EXECUTOR_LABELS;
    private ResourceProfile defaultProfile;
    private final Seq<String> TEST_IMAGE_PULL_SECRETS;
    private final Seq<LocalObjectReference> TEST_IMAGE_PULL_SECRET_OBJECTS;
    private final Pod DRIVER_POD;
    private SparkConf baseConf;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return BeforeAndAfterEach.runTest$((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return BeforeAndAfterAll.run$((BeforeAndAfterAll)this, (Option)testName, (Args)args);
    }

    public void before(Function0<Object> fun, Position pos) {
        BeforeAndAfter.before$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public void after(Function0<Object> fun, Position pos) {
        BeforeAndAfter.after$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.runTest$((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.run$((BeforeAndAfter)this, testName, (Args)args);
    }

    public final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    private String DRIVER_HOSTNAME() {
        return this.DRIVER_HOSTNAME;
    }

    private int DRIVER_PORT() {
        return this.DRIVER_PORT;
    }

    private RpcEndpointAddress DRIVER_ADDRESS() {
        return this.DRIVER_ADDRESS;
    }

    private String DRIVER_POD_NAME() {
        return this.DRIVER_POD_NAME;
    }

    private String DRIVER_POD_UID() {
        return this.DRIVER_POD_UID;
    }

    private String RESOURCE_NAME_PREFIX() {
        return this.RESOURCE_NAME_PREFIX;
    }

    private String EXECUTOR_IMAGE() {
        return this.EXECUTOR_IMAGE;
    }

    private scala.collection.immutable.Map<String, String> CUSTOM_EXECUTOR_LABELS() {
        return this.CUSTOM_EXECUTOR_LABELS;
    }

    private ResourceProfile defaultProfile() {
        return this.defaultProfile;
    }

    private void defaultProfile_$eq(ResourceProfile x$1) {
        this.defaultProfile = x$1;
    }

    private Seq<String> TEST_IMAGE_PULL_SECRETS() {
        return this.TEST_IMAGE_PULL_SECRETS;
    }

    private Seq<LocalObjectReference> TEST_IMAGE_PULL_SECRET_OBJECTS() {
        return this.TEST_IMAGE_PULL_SECRET_OBJECTS;
    }

    private Pod DRIVER_POD() {
        return this.DRIVER_POD;
    }

    private SparkConf baseConf() {
        return this.baseConf;
    }

    private void baseConf_$eq(SparkConf x$1) {
        this.baseConf = x$1;
    }

    private KubernetesExecutorConf newExecutorConf(scala.collection.immutable.Map<String, String> environment) {
        return KubernetesTestConf$.MODULE$.createExecutorConf(this.baseConf(), (Option<Pod>)new Some((Object)this.DRIVER_POD()), this.CUSTOM_EXECUTOR_LABELS(), environment, KubernetesTestConf$.MODULE$.createExecutorConf$default$5(), KubernetesTestConf$.MODULE$.createExecutorConf$default$6(), KubernetesTestConf$.MODULE$.createExecutorConf$default$7(), KubernetesTestConf$.MODULE$.createExecutorConf$default$8());
    }

    private scala.collection.immutable.Map<String, String> newExecutorConf$default$1() {
        return Predef$.MODULE$.Map().empty();
    }

    private void initDefaultProfile(SparkConf baseConf) {
        ResourceProfile$.MODULE$.clearDefaultProfile();
        this.defaultProfile_$eq(ResourceProfile$.MODULE$.getOrCreateDefaultProfile(baseConf));
    }

    public void withPodNamePrefix(Function0<BoxedUnit> f) {
        Option namePrefixOld = (Option)this.baseConf().get((ConfigEntry)Config$.MODULE$.KUBERNETES_EXECUTOR_POD_NAME_PREFIX());
        try {
            f.apply$mcV$sp();
        }
        finally {
            namePrefixOld.foreach((Function1 & Serializable & scala.Serializable)x$1 -> this.baseConf().set(Config$.MODULE$.KUBERNETES_EXECUTOR_POD_NAME_PREFIX(), x$1));
        }
    }

    private void checkOwnerReferences(Pod executor, String driverPodUid) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)executor.getMetadata().getOwnerReferences().size()));
        int $org_scalatest_assert_macro_right = 1;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 521));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(((OwnerReference)executor.getMetadata().getOwnerReferences().get(0)).getUid());
        String $org_scalatest_assert_macro_right2 = driverPodUid;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 522));
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.Boolean2boolean(((OwnerReference)executor.getMetadata().getOwnerReferences().get(0)).getController()), "scala.Predef.Boolean2boolean(executor.getMetadata().getOwnerReferences().get(0).getController())", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 523));
    }

    private void checkEnv(SparkPod executorPod, SparkConf conf, scala.collection.immutable.Map<String, String> additionalEnvVars) {
        scala.collection.immutable.Map defaultEnvs = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.ENV_EXECUTOR_ID()), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.ENV_DRIVER_URL()), (Object)this.DRIVER_ADDRESS().toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.ENV_EXECUTOR_CORES()), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.ENV_EXECUTOR_MEMORY()), (Object)"1024m"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.ENV_APPLICATION_ID()), (Object)KubernetesTestConf$.MODULE$.APP_ID()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.ENV_SPARK_CONF_DIR()), (Object)Constants$.MODULE$.SPARK_CONF_DIR_INTERNAL()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.ENV_SPARK_USER()), (Object)Utils$.MODULE$.getCurrentUserName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.ENV_RESOURCE_PROFILE_ID()), (Object)"0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.ENV_EXECUTOR_POD_IP()), null), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.ENV_EXECUTOR_POD_NAME()), null)}));
        int extraJavaOptsStart = additionalEnvVars.keys().count((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.startsWith(Constants$.MODULE$.ENV_JAVA_OPT_PREFIX())));
        Seq extraJavaOpts = Utils$.MODULE$.sparkJavaOpts(conf, (Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)SparkConf$.MODULE$.isExecutorStartupConf(name)));
        scala.collection.immutable.Map extraJavaOptsEnvs = ((TraversableOnce)((TraversableLike)extraJavaOpts.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String opt = (String)tuple2._1();
            int ind = tuple2._2$mcI$sp();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(0).append(Constants$.MODULE$.ENV_JAVA_OPT_PREFIX()).append(ind + extraJavaOptsStart).toString()), (Object)opt);
            return tuple22;
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map containerEnvs = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(executorPod.container().getEnv()).asScala()).map((Function1 & Serializable & scala.Serializable)x -> new Tuple2((Object)x.getName(), (Object)x.getValue()), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map expectedEnvs = defaultEnvs.$plus$plus(additionalEnvVars).$plus$plus((GenTraversableOnce)extraJavaOptsEnvs);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(containerEnvs);
        scala.collection.immutable.Map $org_scalatest_assert_macro_right = expectedEnvs;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 555));
    }

    private String amountAndFormat(Quantity quantity) {
        return new StringBuilder(0).append(quantity.getAmount()).append(quantity.getFormat()).toString();
    }

    public BasicExecutorFeatureStepSuite() {
        BeforeAndAfter.$init$((BeforeAndAfter)this);
        this.DRIVER_HOSTNAME = "localhost";
        this.DRIVER_PORT = 7098;
        this.DRIVER_ADDRESS = RpcEndpointAddress$.MODULE$.apply(this.DRIVER_HOSTNAME(), this.DRIVER_PORT(), CoarseGrainedSchedulerBackend$.MODULE$.ENDPOINT_NAME());
        this.DRIVER_POD_NAME = "driver-pod";
        this.DRIVER_POD_UID = "driver-uid";
        this.RESOURCE_NAME_PREFIX = "base";
        this.EXECUTOR_IMAGE = "executor-image";
        this.CUSTOM_EXECUTOR_LABELS = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"label1key"), (Object)"label1value")}));
        this.TEST_IMAGE_PULL_SECRETS = (Seq)new .colon.colon((Object)"my-1secret-1", (List)new .colon.colon((Object)"my-secret-2", (List)Nil$.MODULE$));
        this.TEST_IMAGE_PULL_SECRET_OBJECTS = (Seq)this.TEST_IMAGE_PULL_SECRETS().map((Function1 & Serializable & scala.Serializable)secret -> ((LocalObjectReferenceBuilder)new LocalObjectReferenceBuilder().withName(secret)).build(), Seq$.MODULE$.canBuildFrom());
        this.DRIVER_POD = ((PodBuilder)((PodFluent.StatusNested)((PodFluentImpl)((PodFluent.SpecNested)((PodFluentImpl)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName(this.DRIVER_POD_NAME()).withUid(this.DRIVER_POD_UID())).endMetadata()).withNewSpec().withNodeName("some-node")).endSpec()).withNewStatus().withHostIP("192.168.99.100")).endStatus()).build();
        this.before((Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.baseConf_$eq(new SparkConf(false).set(Config$.MODULE$.KUBERNETES_DRIVER_POD_NAME(), (Object)this.DRIVER_POD_NAME()).set(Config$.MODULE$.KUBERNETES_EXECUTOR_POD_NAME_PREFIX(), (Object)this.RESOURCE_NAME_PREFIX()).set(Config$.MODULE$.CONTAINER_IMAGE(), (Object)this.EXECUTOR_IMAGE()).set(Config$.MODULE$.KUBERNETES_DRIVER_SUBMIT_CHECK(), (Object)BoxesRunTime.boxToBoolean((boolean)true)).set(package$.MODULE$.DRIVER_HOST_ADDRESS(), (Object)this.DRIVER_HOSTNAME()).set(package$.MODULE$.DRIVER_PORT(), (Object)BoxesRunTime.boxToInteger((int)this.DRIVER_PORT())).set(Config$.MODULE$.IMAGE_PULL_SECRETS(), this.TEST_IMAGE_PULL_SECRETS()).set("spark.kubernetes.resource.type", "java"));
            this.initDefaultProfile(this.baseConf());
        }, new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
        this.test("test spark resource missing vendor", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String error;
            this.baseConf().set(TestResourceIDs$.MODULE$.EXECUTOR_GPU_ID().amountConf(), "2");
            String $org_scalatest_assert_macro_left = error = ((Throwable)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.initDefaultProfile(this.baseConf());
                BasicExecutorFeatureStep step = new BasicExecutorFeatureStep(this.newExecutorConf(this.newExecutorConf$default$1()), new SecurityManager(this.baseConf(), SecurityManager$.MODULE$.$lessinit$greater$default$2(), SecurityManager$.MODULE$.$lessinit$greater$default$3()), this.defaultProfile());
                SparkPod sparkPod = step.configurePod(SparkPod$.MODULE$.initialPod());
            }, ClassTag$.MODULE$.apply(SparkException.class), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107))).getMessage();
            String $org_scalatest_assert_macro_right = "Resource: gpu was requested, but vendor was not specified";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113));
        }, new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
        this.test("test spark resource missing amount", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String error;
            this.baseConf().set(TestResourceIDs$.MODULE$.EXECUTOR_GPU_ID().vendorConf(), "nvidia.com");
            String $org_scalatest_assert_macro_left = error = ((Throwable)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.initDefaultProfile(this.baseConf());
                BasicExecutorFeatureStep step = new BasicExecutorFeatureStep(this.newExecutorConf(this.newExecutorConf$default$1()), new SecurityManager(this.baseConf(), SecurityManager$.MODULE$.$lessinit$greater$default$2(), SecurityManager$.MODULE$.$lessinit$greater$default$3()), this.defaultProfile());
                SparkPod sparkPod = step.configurePod(SparkPod$.MODULE$.initialPod());
            }, ClassTag$.MODULE$.apply(SparkException.class), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118))).getMessage();
            String $org_scalatest_assert_macro_right = "You must specify an amount for gpu";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
        }, new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 116));
        this.test("basic executor pod with resources", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ResourceID fpgaResourceID = new ResourceID(package$.MODULE$.SPARK_EXECUTOR_PREFIX(), ResourceUtils$.MODULE$.FPGA());
            ResourceID gpuExecutorResourceID = new ResourceID(package$.MODULE$.SPARK_EXECUTOR_PREFIX(), ResourceUtils$.MODULE$.GPU());
            scala.collection.immutable.Map gpuResources = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"nvidia.com/gpu"), (Object)new KubernetesFeaturesTestUtils.TestResourceInformation(gpuExecutorResourceID, "2", "nvidia.com")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"foo.com/fpga"), (Object)new KubernetesFeaturesTestUtils.TestResourceInformation(fpgaResourceID, "1", "foo.com"))}));
            gpuResources.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                KubernetesFeaturesTestUtils.TestResourceInformation testRInfo = (KubernetesFeaturesTestUtils.TestResourceInformation)tuple2._2();
                this.baseConf().set(testRInfo.rId().amountConf(), testRInfo.count());
                SparkConf sparkConf = this.baseConf().set(testRInfo.rId().vendorConf(), testRInfo.vendor());
                return sparkConf;
            });
            this.initDefaultProfile(this.baseConf());
            BasicExecutorFeatureStep step = new BasicExecutorFeatureStep(this.newExecutorConf(this.newExecutorConf$default$1()), new SecurityManager(this.baseConf(), SecurityManager$.MODULE$.$lessinit$greater$default$2(), SecurityManager$.MODULE$.$lessinit$greater$default$3()), this.defaultProfile());
            SparkPod executor = step.configurePod(SparkPod$.MODULE$.initialPod());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)executor.container().getResources().getLimits().size()));
            int $org_scalatest_assert_macro_right = 3;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 142));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(this.amountAndFormat((Quantity)executor.container().getResources().getLimits().get("memory")));
            String $org_scalatest_assert_macro_right2 = "1408Mi";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143));
            gpuResources.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String k8sName = (String)tuple2._1();
                KubernetesFeaturesTestUtils.TestResourceInformation testRInfo = (KubernetesFeaturesTestUtils.TestResourceInformation)tuple2._2();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.amountAndFormat((Quantity)executor.container().getResources().getLimits().get(k8sName)));
                String $org_scalatest_assert_macro_right = testRInfo.count();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertion assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 146));
                return assertion;
            });
        }, new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
        this.test("basic executor pod has reasonable defaults", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            KubernetesExecutorConf conf = this.newExecutorConf(this.newExecutorConf$default$1());
            BasicExecutorFeatureStep step = new BasicExecutorFeatureStep(conf, new SecurityManager(this.baseConf(), SecurityManager$.MODULE$.$lessinit$greater$default$2(), SecurityManager$.MODULE$.$lessinit$greater$default$3()), this.defaultProfile());
            SparkPod executor = step.configurePod(SparkPod$.MODULE$.initialPod());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(executor.pod().getMetadata().getName());
            String $org_scalatest_assert_macro_right = new StringBuilder(7).append(this.RESOURCE_NAME_PREFIX()).append("-exec-1").toString();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 158));
            this.CUSTOM_EXECUTOR_LABELS().foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
                Tuple2 tuple2 = x0$3;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(executor.pod().getMetadata().getLabels().get(k));
                String $org_scalatest_assert_macro_right = v;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertion assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
                return assertion;
            });
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(executor.pod().getMetadata().getLabels());
            java.util.Map $org_scalatest_assert_macro_right2 = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)conf.labels()).asJava();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 164));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(JavaConverters$.MODULE$.asScalaBufferConverter(executor.pod().getSpec().getImagePullSecrets()).asScala());
            Seq<LocalObjectReference> $org_scalatest_assert_macro_right3 = this.TEST_IMAGE_PULL_SECRET_OBJECTS();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", $org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq($org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 166));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(executor.container().getImage());
            String $org_scalatest_assert_macro_right4 = this.EXECUTOR_IMAGE();
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 170));
            java.util.List $org_scalatest_assert_macro_left5 = executor.container().getVolumeMounts();
            int $org_scalatest_assert_macro_right5 = 1;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left5, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 171));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)executor.container().getResources().getLimits().size()));
            int $org_scalatest_assert_macro_right6 = 1;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 172));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(this.amountAndFormat((Quantity)executor.container().getResources().getLimits().get("memory")));
            String $org_scalatest_assert_macro_right7 = "1408Mi";
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 173));
            java.util.Map $org_scalatest_assert_macro_left8 = executor.pod().getSpec().getNodeSelector();
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left8, "isEmpty", $org_scalatest_assert_macro_left8.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 177));
            java.util.List $org_scalatest_assert_macro_left9 = executor.pod().getSpec().getVolumes();
            int $org_scalatest_assert_macro_right8 = 1;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left9, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left9.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 178));
            this.checkEnv(executor, this.baseConf(), (scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
            this.checkOwnerReferences(executor.pod(), this.DRIVER_POD_UID());
        }, new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 151));
        this.test("executor pod hostnames get truncated to 63 characters", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withPodNamePrefix((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String longPodNamePrefix = "loremipsumdolorsitametvimatelitrefficiendisuscipianturvixlegeresple";
            this.baseConf().remove((ConfigEntry)Config$.MODULE$.KUBERNETES_EXECUTOR_POD_NAME_PREFIX());
            this.baseConf().set("spark.app.name", longPodNamePrefix);
            this.initDefaultProfile(this.baseConf());
            BasicExecutorFeatureStep step = new BasicExecutorFeatureStep(this.newExecutorConf(this.newExecutorConf$default$1()), new SecurityManager(this.baseConf(), SecurityManager$.MODULE$.$lessinit$greater$default$2(), SecurityManager$.MODULE$.$lessinit$greater$default$3()), this.defaultProfile());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)step.configurePod(SparkPod$.MODULE$.initialPod()).pod().getSpec().getHostname().length()));
            int $org_scalatest_assert_macro_right = Config$.MODULE$.KUBERNETES_DNS_LABEL_NAME_MAX_LENGTH();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 201));
        }), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 193));
        this.test("SPARK-35460: invalid PodNamePrefixes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withPodNamePrefix((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)"_123", (List)new .colon.colon((Object)"spark_exec", (List)new .colon.colon((Object)"spark@", (List)new .colon.colon((Object)new StringOps(Predef$.MODULE$.augmentString("a")).$times(238), (List)Nil$.MODULE$))))).foreach((Function1 & Serializable & scala.Serializable)invalid -> {
            this.baseConf().set(Config$.MODULE$.KUBERNETES_EXECUTOR_POD_NAME_PREFIX(), invalid);
            IllegalArgumentException e = (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> this.newExecutorConf(this.newExecutorConf$default$1()), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 210));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(e.getMessage());
            String $org_scalatest_assert_macro_right = new StringBuilder(191).append("'").append((String)invalid).append("' in spark.kubernetes.executor.podNamePrefix is").append(" invalid. must conform https://kubernetes.io/docs/concepts/overview/").append("working-with-objects/names/#dns-subdomain-names and the value length <= 237").toString();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 211));
        })), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 206));
        this.test("hostname truncation generates valid host names", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withPodNamePrefix((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String invalidPrefix = "abcdef-*_/[]{}+==.,;'\"-----------------------------------------------";
            this.baseConf().remove((ConfigEntry)Config$.MODULE$.KUBERNETES_EXECUTOR_POD_NAME_PREFIX());
            this.baseConf().set("spark.app.name", invalidPrefix);
            this.initDefaultProfile(this.baseConf());
            BasicExecutorFeatureStep step = new BasicExecutorFeatureStep(this.newExecutorConf(this.newExecutorConf$default$1()), new SecurityManager(this.baseConf(), SecurityManager$.MODULE$.$lessinit$greater$default$2(), SecurityManager$.MODULE$.$lessinit$greater$default$3()), this.defaultProfile());
            String hostname = step.configurePod(SparkPod$.MODULE$.initialPod()).pod().getSpec().getHostname();
            int $org_scalatest_assert_macro_left = hostname.length();
            int $org_scalatest_assert_macro_right = Config$.MODULE$.KUBERNETES_DNS_LABEL_NAME_MAX_LENGTH();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "<=", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left <= $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 227));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(InternetDomainName.isValid((String)hostname), "com.google.common.net.InternetDomainName.isValid(hostname)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 228));
        }), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 218));
        this.test("classpath and extra java options get translated into environment variables", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.baseConf().set(package$.MODULE$.EXECUTOR_JAVA_OPTIONS(), (Object)"foo=bar");
            this.baseConf().set(package$.MODULE$.EXECUTOR_CLASS_PATH(), (Object)"bar=baz");
            this.initDefaultProfile(this.baseConf());
            KubernetesExecutorConf kconf = this.newExecutorConf((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"qux"), (Object)"quux")}))));
            BasicExecutorFeatureStep step = new BasicExecutorFeatureStep(kconf, new SecurityManager(this.baseConf(), SecurityManager$.MODULE$.$lessinit$greater$default$2(), SecurityManager$.MODULE$.$lessinit$greater$default$3()), this.defaultProfile());
            SparkPod executor = step.configurePod(SparkPod$.MODULE$.initialPod());
            this.checkEnv(executor, this.baseConf(), (scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SPARK_JAVA_OPT_0"), (Object)"foo=bar"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.ENV_CLASSPATH()), (Object)"bar=baz"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"qux"), (Object)"quux")}))));
            this.checkOwnerReferences(executor.pod(), this.DRIVER_POD_UID());
        }, new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 232));
        this.test("SPARK-32655 Support appId/execId placeholder in SPARK_EXECUTOR_DIRS", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            KubernetesExecutorConf kconf = this.newExecutorConf((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.ENV_EXECUTOR_DIRS()), (Object)"/p1/SPARK_APPLICATION_ID/SPARK_EXECUTOR_ID,/p2/SPARK_APPLICATION_ID/SPARK_EXECUTOR_ID")}))));
            BasicExecutorFeatureStep step = new BasicExecutorFeatureStep(kconf, new SecurityManager(this.baseConf(), SecurityManager$.MODULE$.$lessinit$greater$default$2(), SecurityManager$.MODULE$.$lessinit$greater$default$3()), this.defaultProfile());
            SparkPod executor = step.configurePod(SparkPod$.MODULE$.initialPod());
            this.checkEnv(executor, this.baseConf(), (scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.ENV_EXECUTOR_DIRS()), (Object)new StringBuilder(13).append("/p1/").append(KubernetesTestConf$.MODULE$.APP_ID()).append("/1,/p2/").append(KubernetesTestConf$.MODULE$.APP_ID()).append("/1").toString())}))));
        }, new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 248));
        this.test("test executor pyspark memory", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.baseConf().set("spark.kubernetes.resource.type", "python");
            this.baseConf().set(Python$.MODULE$.PYSPARK_EXECUTOR_MEMORY(), (Object)BoxesRunTime.boxToLong((long)42L));
            this.initDefaultProfile(this.baseConf());
            BasicExecutorFeatureStep step = new BasicExecutorFeatureStep(this.newExecutorConf(this.newExecutorConf$default$1()), new SecurityManager(this.baseConf(), SecurityManager$.MODULE$.$lessinit$greater$default$2(), SecurityManager$.MODULE$.$lessinit$greater$default$3()), this.defaultProfile());
            SparkPod executor = step.configurePod(SparkPod$.MODULE$.initialPod());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.amountAndFormat((Quantity)executor.container().getResources().getRequests().get("memory")));
            String $org_scalatest_assert_macro_right = "1450Mi";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 267));
        }, new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 259));
        this.test("auth secret propagation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SparkConf conf = this.baseConf().clone().set(package$.MODULE$.NETWORK_AUTH_ENABLED(), (Object)BoxesRunTime.boxToBoolean((boolean)true)).set("spark.master", "k8s://127.0.0.1");
            SecurityManager secMgr = new SecurityManager(conf, SecurityManager$.MODULE$.$lessinit$greater$default$2(), SecurityManager$.MODULE$.$lessinit$greater$default$3());
            secMgr.initializeAuth();
            BasicExecutorFeatureStep step = new BasicExecutorFeatureStep(KubernetesTestConf$.MODULE$.createExecutorConf(conf, KubernetesTestConf$.MODULE$.createExecutorConf$default$2(), KubernetesTestConf$.MODULE$.createExecutorConf$default$3(), KubernetesTestConf$.MODULE$.createExecutorConf$default$4(), KubernetesTestConf$.MODULE$.createExecutorConf$default$5(), KubernetesTestConf$.MODULE$.createExecutorConf$default$6(), KubernetesTestConf$.MODULE$.createExecutorConf$default$7(), KubernetesTestConf$.MODULE$.createExecutorConf$default$8()), secMgr, this.defaultProfile());
            SparkPod executor = step.configurePod(SparkPod$.MODULE$.initialPod());
            this.checkEnv(executor, conf, (scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SecurityManager$.MODULE$.ENV_AUTH_SECRET()), (Object)secMgr.getSecretKey())}))));
        }, new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 270));
        this.test("Auth secret shouldn't propagate if files are loaded.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            File secretDir = Utils$.MODULE$.createTempDir("temp-secret", Utils$.MODULE$.createTempDir$default$2());
            File secretFile = new File(secretDir, "secret-file.txt");
            Files.write(secretFile.toPath(), "some-secret".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            SparkConf conf = this.baseConf().clone().set(package$.MODULE$.NETWORK_AUTH_ENABLED(), (Object)BoxesRunTime.boxToBoolean((boolean)true)).set(package$.MODULE$.AUTH_SECRET_FILE(), (Object)secretFile.getAbsolutePath()).set("spark.master", "k8s://127.0.0.1");
            SecurityManager secMgr = new SecurityManager(conf, SecurityManager$.MODULE$.$lessinit$greater$default$2(), SecurityManager$.MODULE$.$lessinit$greater$default$3());
            secMgr.initializeAuth();
            BasicExecutorFeatureStep step = new BasicExecutorFeatureStep(KubernetesTestConf$.MODULE$.createExecutorConf(conf, KubernetesTestConf$.MODULE$.createExecutorConf$default$2(), KubernetesTestConf$.MODULE$.createExecutorConf$default$3(), KubernetesTestConf$.MODULE$.createExecutorConf$default$4(), KubernetesTestConf$.MODULE$.createExecutorConf$default$5(), KubernetesTestConf$.MODULE$.createExecutorConf$default$6(), KubernetesTestConf$.MODULE$.createExecutorConf$default$7(), KubernetesTestConf$.MODULE$.createExecutorConf$default$8()), secMgr, this.defaultProfile());
            SparkPod executor = step.configurePod(SparkPod$.MODULE$.initialPod());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(KubernetesFeaturesTestUtils$.MODULE$.containerHasEnvVar(executor.container(), SecurityManager$.MODULE$.ENV_AUTH_SECRET()), "KubernetesFeaturesTestUtils.containerHasEnvVar(executor.container, org.apache.spark.SecurityManager.ENV_AUTH_SECRET)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 299));
        }, new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 285));
        this.test("SPARK-32661 test executor offheap memory", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.baseConf().set(package$.MODULE$.MEMORY_OFFHEAP_ENABLED(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
            this.baseConf().set("spark.memory.offHeap.size", "42m");
            this.initDefaultProfile(this.baseConf());
            BasicExecutorFeatureStep step = new BasicExecutorFeatureStep(this.newExecutorConf(this.newExecutorConf$default$1()), new SecurityManager(this.baseConf(), SecurityManager$.MODULE$.$lessinit$greater$default$2(), SecurityManager$.MODULE$.$lessinit$greater$default$3()), this.defaultProfile());
            SparkPod executor = step.configurePod(SparkPod$.MODULE$.initialPod());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.amountAndFormat((Quantity)executor.container().getResources().getRequests().get("memory")));
            String $org_scalatest_assert_macro_right = "1450Mi";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 312));
        }, new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 303));
        this.test("basic resourceprofile", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.baseConf().set("spark.kubernetes.resource.type", "python");
            this.initDefaultProfile(this.baseConf());
            ResourceProfileBuilder rpb = new ResourceProfileBuilder();
            ExecutorResourceRequests ereq = new ExecutorResourceRequests();
            TaskResourceRequests treq = new TaskResourceRequests();
            ereq.cores(4).memory("2g").memoryOverhead("1g").pysparkMemory("3g");
            treq.cpus(2);
            rpb.require(ereq).require(treq);
            ResourceProfile rp = rpb.build();
            BasicExecutorFeatureStep step = new BasicExecutorFeatureStep(this.newExecutorConf(this.newExecutorConf$default$1()), new SecurityManager(this.baseConf(), SecurityManager$.MODULE$.$lessinit$greater$default$2(), SecurityManager$.MODULE$.$lessinit$greater$default$3()), rp);
            SparkPod executor = step.configurePod(SparkPod$.MODULE$.initialPod());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.amountAndFormat((Quantity)executor.container().getResources().getRequests().get("cpu")));
            String $org_scalatest_assert_macro_right = "4";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 328));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(this.amountAndFormat((Quantity)executor.container().getResources().getLimits().get("memory")));
            String $org_scalatest_assert_macro_right2 = "6144Mi";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 330));
        }, new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 315));
        this.test("resourceprofile with gpus", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            ResourceProfileBuilder rpb = new ResourceProfileBuilder();
            ExecutorResourceRequests ereq = new ExecutorResourceRequests();
            TaskResourceRequests treq = new TaskResourceRequests();
            ereq.cores(2).resource("gpu", 2L, "/path/getGpusResources.sh", "nvidia.com");
            treq.cpus(1);
            rpb.require(ereq).require(treq);
            ResourceProfile rp = rpb.build();
            BasicExecutorFeatureStep step = new BasicExecutorFeatureStep(this.newExecutorConf(this.newExecutorConf$default$1()), new SecurityManager(this.baseConf(), SecurityManager$.MODULE$.$lessinit$greater$default$2(), SecurityManager$.MODULE$.$lessinit$greater$default$3()), rp);
            SparkPod executor = step.configurePod(SparkPod$.MODULE$.initialPod());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.amountAndFormat((Quantity)executor.container().getResources().getLimits().get("memory")));
            String $org_scalatest_assert_macro_right = "1408Mi";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 345));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(this.amountAndFormat((Quantity)executor.container().getResources().getRequests().get("cpu")));
            String $org_scalatest_assert_macro_right2 = "2";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 347));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)executor.container().getResources().getLimits().size()));
            int $org_scalatest_assert_macro_right3 = 2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 350));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(this.amountAndFormat((Quantity)executor.container().getResources().getLimits().get("nvidia.com/gpu")));
            String $org_scalatest_assert_macro_right4 = "2";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 351));
        }, new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 334));
        this.test("Verify spark conf dir is mounted as configmap volume on executor pod's container.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparkPod baseDriverPod = SparkPod$.MODULE$.initialPod();
            BasicExecutorFeatureStep step = new BasicExecutorFeatureStep(this.newExecutorConf(this.newExecutorConf$default$1()), new SecurityManager(this.baseConf(), SecurityManager$.MODULE$.$lessinit$greater$default$2(), SecurityManager$.MODULE$.$lessinit$greater$default$3()), this.defaultProfile());
            SparkPod podConfigured = step.configurePod(baseDriverPod);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(SecretVolumeUtils$.MODULE$.containerHasVolume(podConfigured.container(), Constants$.MODULE$.SPARK_CONF_VOLUME_EXEC(), Constants$.MODULE$.SPARK_CONF_DIR_INTERNAL()), "org.apache.spark.deploy.k8s.SecretVolumeUtils.containerHasVolume(podConfigured.container, org.apache.spark.deploy.k8s.Constants.SPARK_CONF_VOLUME_EXEC, org.apache.spark.deploy.k8s.Constants.SPARK_CONF_DIR_INTERNAL)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 359));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(SecretVolumeUtils$.MODULE$.podHasVolume(podConfigured.pod(), Constants$.MODULE$.SPARK_CONF_VOLUME_EXEC()), "org.apache.spark.deploy.k8s.SecretVolumeUtils.podHasVolume(podConfigured.pod, org.apache.spark.deploy.k8s.Constants.SPARK_CONF_VOLUME_EXEC)", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 361));
        }, new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 354));
        this.test("SPARK-34316 Disable configmap volume on executor pod's container", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.baseConf().set(Config$.MODULE$.KUBERNETES_EXECUTOR_DISABLE_CONFIGMAP(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
            SparkPod baseDriverPod = SparkPod$.MODULE$.initialPod();
            BasicExecutorFeatureStep step = new BasicExecutorFeatureStep(this.newExecutorConf(this.newExecutorConf$default$1()), new SecurityManager(this.baseConf(), SecurityManager$.MODULE$.$lessinit$greater$default$2(), SecurityManager$.MODULE$.$lessinit$greater$default$3()), this.defaultProfile());
            SparkPod podConfigured = step.configurePod(baseDriverPod);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(SecretVolumeUtils$.MODULE$.containerHasVolume(podConfigured.container(), Constants$.MODULE$.SPARK_CONF_VOLUME_EXEC(), Constants$.MODULE$.SPARK_CONF_DIR_INTERNAL()), "org.apache.spark.deploy.k8s.SecretVolumeUtils.containerHasVolume(podConfigured.container, org.apache.spark.deploy.k8s.Constants.SPARK_CONF_VOLUME_EXEC, org.apache.spark.deploy.k8s.Constants.SPARK_CONF_DIR_INTERNAL)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 370));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(SecretVolumeUtils$.MODULE$.podHasVolume(podConfigured.pod(), Constants$.MODULE$.SPARK_CONF_VOLUME_EXEC()), "org.apache.spark.deploy.k8s.SecretVolumeUtils.podHasVolume(podConfigured.pod, org.apache.spark.deploy.k8s.Constants.SPARK_CONF_VOLUME_EXEC)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 372));
        }, new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 364));
        this.test("SPARK-40065 Mount configmap on executors with non-default profile as well", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparkPod baseDriverPod = SparkPod$.MODULE$.initialPod();
            ResourceProfile rp = new ResourceProfileBuilder().build();
            BasicExecutorFeatureStep step = new BasicExecutorFeatureStep(this.newExecutorConf(this.newExecutorConf$default$1()), new SecurityManager(this.baseConf(), SecurityManager$.MODULE$.$lessinit$greater$default$2(), SecurityManager$.MODULE$.$lessinit$greater$default$3()), rp);
            SparkPod podConfigured = step.configurePod(baseDriverPod);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(SecretVolumeUtils$.MODULE$.containerHasVolume(podConfigured.container(), Constants$.MODULE$.SPARK_CONF_VOLUME_EXEC(), Constants$.MODULE$.SPARK_CONF_DIR_INTERNAL()), "org.apache.spark.deploy.k8s.SecretVolumeUtils.containerHasVolume(podConfigured.container, org.apache.spark.deploy.k8s.Constants.SPARK_CONF_VOLUME_EXEC, org.apache.spark.deploy.k8s.Constants.SPARK_CONF_DIR_INTERNAL)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 380));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(SecretVolumeUtils$.MODULE$.podHasVolume(podConfigured.pod(), Constants$.MODULE$.SPARK_CONF_VOLUME_EXEC()), "org.apache.spark.deploy.k8s.SecretVolumeUtils.podHasVolume(podConfigured.pod, org.apache.spark.deploy.k8s.Constants.SPARK_CONF_VOLUME_EXEC)", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 382));
        }, new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 375));
        this.test("SPARK-40065 Disable configmap volume on executor pod's container (non-default profile)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.baseConf().set(Config$.MODULE$.KUBERNETES_EXECUTOR_DISABLE_CONFIGMAP(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
            SparkPod baseDriverPod = SparkPod$.MODULE$.initialPod();
            ResourceProfile rp = new ResourceProfileBuilder().build();
            BasicExecutorFeatureStep step = new BasicExecutorFeatureStep(this.newExecutorConf(this.newExecutorConf$default$1()), new SecurityManager(this.baseConf(), SecurityManager$.MODULE$.$lessinit$greater$default$2(), SecurityManager$.MODULE$.$lessinit$greater$default$3()), rp);
            SparkPod podConfigured = step.configurePod(baseDriverPod);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(SecretVolumeUtils$.MODULE$.containerHasVolume(podConfigured.container(), Constants$.MODULE$.SPARK_CONF_VOLUME_EXEC(), Constants$.MODULE$.SPARK_CONF_DIR_INTERNAL()), "org.apache.spark.deploy.k8s.SecretVolumeUtils.containerHasVolume(podConfigured.container, org.apache.spark.deploy.k8s.Constants.SPARK_CONF_VOLUME_EXEC, org.apache.spark.deploy.k8s.Constants.SPARK_CONF_DIR_INTERNAL)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 391));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(SecretVolumeUtils$.MODULE$.podHasVolume(podConfigured.pod(), Constants$.MODULE$.SPARK_CONF_VOLUME_EXEC()), "org.apache.spark.deploy.k8s.SecretVolumeUtils.podHasVolume(podConfigured.pod, org.apache.spark.deploy.k8s.Constants.SPARK_CONF_VOLUME_EXEC)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 393));
        }, new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 385));
        this.test("SPARK-35482: user correct block manager port for executor pods", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Assertion assertion;
            try {
                SparkPod initPod = SparkPod$.MODULE$.initialPod();
                SecurityManager sm = new SecurityManager(this.baseConf(), SecurityManager$.MODULE$.$lessinit$greater$default$2(), SecurityManager$.MODULE$.$lessinit$greater$default$3());
                BasicExecutorFeatureStep step1 = new BasicExecutorFeatureStep(this.newExecutorConf(this.newExecutorConf$default$1()), sm, this.defaultProfile());
                ContainerPort containerPort1 = (ContainerPort)step1.configurePod(initPod).container().getPorts().get(0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(containerPort1.getContainerPort());
                int $org_scalatest_assert_macro_right = Constants$.MODULE$.DEFAULT_BLOCKMANAGER_PORT();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(31).append("should use port no. ").append(Constants$.MODULE$.DEFAULT_BLOCKMANAGER_PORT()).append(" as default").toString(), Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 403));
                this.baseConf().set(package$.MODULE$.BLOCK_MANAGER_PORT(), (Object)BoxesRunTime.boxToInteger((int)12345));
                BasicExecutorFeatureStep step2 = new BasicExecutorFeatureStep(this.newExecutorConf(this.newExecutorConf$default$1()), sm, this.defaultProfile());
                ContainerPort containerPort2 = (ContainerPort)step2.configurePod(initPod).container().getPorts().get(0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(containerPort2.getContainerPort());
                int $org_scalatest_assert_macro_right2 = 12345;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 409));
                this.baseConf().set(package$.MODULE$.BLOCK_MANAGER_PORT(), (Object)BoxesRunTime.boxToInteger((int)1000));
                IllegalArgumentException e = (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> new BasicExecutorFeatureStep(this.newExecutorConf(this.newExecutorConf$default$1()), sm, this.defaultProfile()), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 412));
                String $org_scalatest_assert_macro_left3 = e.getMessage();
                String $org_scalatest_assert_macro_right3 = "port number must be 0 or in [1024, 65535]";
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 415));
                this.baseConf().set(package$.MODULE$.BLOCK_MANAGER_PORT(), (Object)BoxesRunTime.boxToInteger((int)0));
                BasicExecutorFeatureStep step3 = new BasicExecutorFeatureStep(this.newExecutorConf(this.newExecutorConf$default$1()), sm, this.defaultProfile());
                java.util.List $org_scalatest_assert_macro_left4 = step3.configurePod(initPod).container().getPorts();
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left4, "isEmpty", $org_scalatest_assert_macro_left4.isEmpty(), Prettifier$.MODULE$.default());
                assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"random port", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 419));
            }
            finally {
                this.baseConf().remove(package$.MODULE$.BLOCK_MANAGER_PORT());
            }
            return assertion;
        }, new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 396));
        this.test("SPARK-35969: Make the pod prefix more readable and tallied with K8S DNS Label Names", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.baseConf().remove((ConfigEntry)Config$.MODULE$.KUBERNETES_EXECUTOR_POD_NAME_PREFIX());
            this.baseConf().set("spark.app.name", "xyz.abc _i_am_a_app_name_w/_some_abbrs");
            SparkPod baseDriverPod = SparkPod$.MODULE$.initialPod();
            BasicExecutorFeatureStep step1 = new BasicExecutorFeatureStep(this.newExecutorConf(this.newExecutorConf$default$1()), new SecurityManager(this.baseConf(), SecurityManager$.MODULE$.$lessinit$greater$default$2(), SecurityManager$.MODULE$.$lessinit$greater$default$3()), this.defaultProfile());
            SparkPod podConfigured1 = step1.configurePod(baseDriverPod);
            String $org_scalatest_assert_macro_left = podConfigured1.pod().getMetadata().getName();
            String $org_scalatest_assert_macro_right = "xyz-abc-i-am-a-app-name-w-some-abbrs";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "startsWith", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.startsWith($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 432));
            this.baseConf().set("spark.app.name", "time.is the#most\uffe5valuable_\u2014thing\u3002it's&about?time.");
            BasicExecutorFeatureStep step2 = new BasicExecutorFeatureStep(this.newExecutorConf(this.newExecutorConf$default$1()), new SecurityManager(this.baseConf(), SecurityManager$.MODULE$.$lessinit$greater$default$2(), SecurityManager$.MODULE$.$lessinit$greater$default$3()), this.defaultProfile());
            SparkPod podConfigured2 = step2.configurePod(baseDriverPod);
            String $org_scalatest_assert_macro_left2 = podConfigured2.pod().getMetadata().getName();
            String $org_scalatest_assert_macro_right2 = "time-is-the-most-valuable-thing-it-s-about-time-";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "startsWith", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.startsWith($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 443));
        }, new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 425));
        this.test("SPARK-36075: Check executor pod respects nodeSelector/executorNodeSelector", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparkPod initPod = SparkPod$.MODULE$.initialPod();
            SparkConf sparkConf = new SparkConf().set(Config$.MODULE$.CONTAINER_IMAGE(), (Object)"spark-driver:latest").set(new StringBuilder(12).append(Config$.MODULE$.KUBERNETES_NODE_SELECTOR_PREFIX()).append("nodeLabelKey").toString(), "nodeLabelValue").set(new StringBuilder(16).append(Config$.MODULE$.KUBERNETES_EXECUTOR_NODE_SELECTOR_PREFIX()).append("execNodeLabelKey").toString(), "execNodeLabelValue").set(new StringBuilder(18).append(Config$.MODULE$.KUBERNETES_DRIVER_NODE_SELECTOR_PREFIX()).append("driverNodeLabelKey").toString(), "driverNodeLabelValue");
            KubernetesExecutorConf executorConf = KubernetesTestConf$.MODULE$.createExecutorConf(sparkConf, KubernetesTestConf$.MODULE$.createExecutorConf$default$2(), KubernetesTestConf$.MODULE$.createExecutorConf$default$3(), KubernetesTestConf$.MODULE$.createExecutorConf$default$4(), KubernetesTestConf$.MODULE$.createExecutorConf$default$5(), KubernetesTestConf$.MODULE$.createExecutorConf$default$6(), KubernetesTestConf$.MODULE$.createExecutorConf$default$7(), KubernetesTestConf$.MODULE$.createExecutorConf$default$8());
            SparkPod executor = new BasicExecutorFeatureStep(executorConf, new SecurityManager(this.baseConf(), SecurityManager$.MODULE$.$lessinit$greater$default$2(), SecurityManager$.MODULE$.$lessinit$greater$default$3()), this.defaultProfile()).configurePod(initPod);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(JavaConverters$.MODULE$.mapAsScalaMapConverter(executor.pod().getSpec().getNodeSelector()).asScala());
            scala.collection.immutable.Map $org_scalatest_assert_macro_right = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"nodeLabelKey"), (Object)"nodeLabelValue"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"execNodeLabelKey"), (Object)"execNodeLabelValue")}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 459));
        }, new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 448));
        this.test("SPARK-38194: memory overhead factor precendence", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            double defaultFactor = BoxesRunTime.unboxToDouble((Object)package$.MODULE$.EXECUTOR_MEMORY_OVERHEAD_FACTOR().defaultValue().get());
            double executorMem = (double)ResourceProfile$.MODULE$.MEMORY_OVERHEAD_MIN_MIB() / defaultFactor * (double)2;
            SparkConf sparkConf = new SparkConf(false).set(Config$.MODULE$.CONTAINER_IMAGE(), (Object)"spark-driver:latest").set(package$.MODULE$.EXECUTOR_MEMORY().key(), new StringBuilder(1).append((int)executorMem).append("m").toString());
            double expectedFactor = 0.2;
            sparkConf.set(package$.MODULE$.EXECUTOR_MEMORY_OVERHEAD_FACTOR(), (Object)BoxesRunTime.boxToDouble((double)expectedFactor));
            sparkConf.set(Config$.MODULE$.MEMORY_OVERHEAD_FACTOR(), (Object)BoxesRunTime.boxToDouble((double)0.3));
            KubernetesExecutorConf conf = KubernetesTestConf$.MODULE$.createExecutorConf(sparkConf, KubernetesTestConf$.MODULE$.createExecutorConf$default$2(), KubernetesTestConf$.MODULE$.createExecutorConf$default$3(), KubernetesTestConf$.MODULE$.createExecutorConf$default$4(), KubernetesTestConf$.MODULE$.createExecutorConf$default$5(), KubernetesTestConf$.MODULE$.createExecutorConf$default$6(), KubernetesTestConf$.MODULE$.createExecutorConf$default$7(), KubernetesTestConf$.MODULE$.createExecutorConf$default$8());
            ResourceProfile$.MODULE$.clearDefaultProfile();
            ResourceProfile resourceProfile = ResourceProfile$.MODULE$.getOrCreateDefaultProfile(sparkConf);
            BasicExecutorFeatureStep step = new BasicExecutorFeatureStep(conf, new SecurityManager(this.baseConf(), SecurityManager$.MODULE$.$lessinit$greater$default$2(), SecurityManager$.MODULE$.$lessinit$greater$default$3()), resourceProfile);
            SparkPod pod = step.configurePod(SparkPod$.MODULE$.initialPod());
            String mem = this.amountAndFormat((Quantity)pod.container().getResources().getRequests().get("memory"));
            int expected = (int)(executorMem + executorMem * expectedFactor);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(mem);
            String $org_scalatest_assert_macro_right = new StringBuilder(2).append(expected).append("Mi").toString();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 489));
        }, new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 465));
        this.test("SPARK-38194: old memory factor settings is applied if new one isn't given", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            double defaultFactor = BoxesRunTime.unboxToDouble((Object)package$.MODULE$.EXECUTOR_MEMORY_OVERHEAD_FACTOR().defaultValue().get());
            double executorMem = (double)ResourceProfile$.MODULE$.MEMORY_OVERHEAD_MIN_MIB() / defaultFactor * (double)2;
            SparkConf sparkConf = new SparkConf(false).set(Config$.MODULE$.CONTAINER_IMAGE(), (Object)"spark-driver:latest").set(package$.MODULE$.EXECUTOR_MEMORY().key(), new StringBuilder(1).append((int)executorMem).append("m").toString());
            double expectedFactor = 0.3;
            sparkConf.set(Config$.MODULE$.MEMORY_OVERHEAD_FACTOR(), (Object)BoxesRunTime.boxToDouble((double)expectedFactor));
            KubernetesExecutorConf conf = KubernetesTestConf$.MODULE$.createExecutorConf(sparkConf, KubernetesTestConf$.MODULE$.createExecutorConf$default$2(), KubernetesTestConf$.MODULE$.createExecutorConf$default$3(), KubernetesTestConf$.MODULE$.createExecutorConf$default$4(), KubernetesTestConf$.MODULE$.createExecutorConf$default$5(), KubernetesTestConf$.MODULE$.createExecutorConf$default$6(), KubernetesTestConf$.MODULE$.createExecutorConf$default$7(), KubernetesTestConf$.MODULE$.createExecutorConf$default$8());
            ResourceProfile$.MODULE$.clearDefaultProfile();
            ResourceProfile resourceProfile = ResourceProfile$.MODULE$.getOrCreateDefaultProfile(sparkConf);
            BasicExecutorFeatureStep step = new BasicExecutorFeatureStep(conf, new SecurityManager(this.baseConf(), SecurityManager$.MODULE$.$lessinit$greater$default$2(), SecurityManager$.MODULE$.$lessinit$greater$default$3()), resourceProfile);
            SparkPod pod = step.configurePod(SparkPod$.MODULE$.initialPod());
            String mem = this.amountAndFormat((Quantity)pod.container().getResources().getRequests().get("memory"));
            int expected = (int)(executorMem + executorMem * expectedFactor);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(mem);
            String $org_scalatest_assert_macro_right = new StringBuilder(2).append(expected).append("Mi").toString();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 515));
        }, new Position("BasicExecutorFeatureStepSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 492));
    }
}

