/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.k8s;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.spark.SecurityManager;
import org.apache.spark.SecurityManager$;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkConf$;
import org.apache.spark.SparkEnv;
import org.apache.spark.SparkEnv$;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.deploy.worker.WorkerWatcher;
import org.apache.spark.deploy.worker.WorkerWatcher$;
import org.apache.spark.executor.CoarseGrainedExecutorBackend;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.package$;
import org.apache.spark.resource.ResourceProfile;
import org.apache.spark.resource.ResourceProfile$;
import org.apache.spark.rpc.RpcEndpoint;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.rpc.RpcEnv;
import org.apache.spark.rpc.RpcEnv$;
import org.apache.spark.scheduler.cluster.CoarseGrainedClusterMessages;
import org.apache.spark.scheduler.cluster.k8s.GenerateExecID;
import org.apache.spark.scheduler.cluster.k8s.KubernetesExecutorBackend;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function5;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class KubernetesExecutorBackend$
implements Logging {
    public static KubernetesExecutorBackend$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new KubernetesExecutorBackend$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public void main(String[] args) {
        Function5 & Serializable & scala.Serializable createFn = (Function5 & Serializable & scala.Serializable)(x0$1, x1$1, x2$1, x3$1, x4$1) -> {
            Tuple5 tuple5 = new Tuple5(x0$1, x1$1, x2$1, x3$1, x4$1);
            if (tuple5 != null) {
                RpcEnv rpcEnv = (RpcEnv)tuple5._1();
                KubernetesExecutorBackend.Arguments arguments = (KubernetesExecutorBackend.Arguments)tuple5._2();
                SparkEnv env = (SparkEnv)tuple5._3();
                ResourceProfile resourceProfile = (ResourceProfile)tuple5._4();
                String execId = (String)tuple5._5();
                return new CoarseGrainedExecutorBackend(rpcEnv, arguments.driverUrl(), execId, arguments.bindAddress(), arguments.hostname(), arguments.cores(), env, arguments.resourcesFileOpt(), resourceProfile);
            }
            throw new MatchError((Object)tuple5);
        };
        this.run(this.parseArguments(args, new StringOps(Predef$.MODULE$.augmentString(this.getClass().getCanonicalName())).stripSuffix("$")), (Function5<RpcEnv, KubernetesExecutorBackend.Arguments, SparkEnv, ResourceProfile, String, CoarseGrainedExecutorBackend>)createFn);
        System.exit(0);
    }

    public void run(KubernetesExecutorBackend.Arguments arguments, Function5<RpcEnv, KubernetesExecutorBackend.Arguments, SparkEnv, ResourceProfile, String, CoarseGrainedExecutorBackend> backendCreateFn) {
        Utils$.MODULE$.initDaemon(this.log());
        SparkHadoopUtil$.MODULE$.get().runAsSparkUser((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.assert(arguments.hostname() != null && (arguments.hostname().indexOf(58) == -1 || arguments.hostname().split(":").length > 2));
            SparkConf executorConf = new SparkConf();
            RpcEnv fetcher = RpcEnv$.MODULE$.create("driverPropsFetcher", arguments.bindAddress(), arguments.hostname(), -1, executorConf, new SecurityManager(executorConf, SecurityManager$.MODULE$.$lessinit$greater$default$2(), SecurityManager$.MODULE$.$lessinit$greater$default$3()), 0, true);
            ObjectRef driver = ObjectRef.create(null);
            int nTries = 3;
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), nTries).withFilter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)i -> (RpcEndpointRef)driver$1.elem == null).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                block2: {
                    try {
                        driver$1.elem = fetcher.setupEndpointRefByURI(arguments.driverUrl());
                    }
                    catch (Throwable e) {
                        if (i != nTries - 1) break block2;
                        throw e;
                    }
                }
            });
            CoarseGrainedClusterMessages.SparkAppConfig cfg = (CoarseGrainedClusterMessages.SparkAppConfig)((RpcEndpointRef)driver.elem).askSync((Object)new CoarseGrainedClusterMessages.RetrieveSparkAppConfig(arguments.resourceProfileId()), ClassTag$.MODULE$.apply(CoarseGrainedClusterMessages.SparkAppConfig.class));
            Seq props = (Seq)cfg.sparkProperties().$plus$plus((GenTraversableOnce)new .colon.colon((Object)new Tuple2((Object)"spark.app.id", (Object)arguments.appId()), (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom());
            String string = arguments.executorId();
            String execId = (string == null ? true : ("EXECID".equals(string) ? true : "".equals(string))) ? (String)((RpcEndpointRef)driver.elem).askSync((Object)new GenerateExecID(arguments.podName()), ClassTag$.MODULE$.apply(String.class)) : string;
            fetcher.shutdown();
            SparkConf driverConf = new SparkConf();
            props.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)KubernetesExecutorBackend$.$anonfun$run$4(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    String value = (String)tuple2._2();
                    if (SparkConf$.MODULE$.isExecutorStartupConf(key)) {
                        return driverConf.setIfMissing(key, value);
                    }
                    return driverConf.set(key, value);
                }
                throw new MatchError((Object)tuple2);
            });
            cfg.hadoopDelegationCreds().foreach((Function1 & Serializable & scala.Serializable)tokens -> {
                KubernetesExecutorBackend$.$anonfun$run$6(driverConf, tokens);
                return BoxedUnit.UNIT;
            });
            driverConf.set(package$.MODULE$.EXECUTOR_ID(), (Object)execId);
            SparkEnv env = SparkEnv$.MODULE$.createExecutorEnv(driverConf, execId, arguments.bindAddress(), arguments.hostname(), arguments.cores(), cfg.ioEncryptionKey(), false);
            CoarseGrainedExecutorBackend backend = (CoarseGrainedExecutorBackend)backendCreateFn.apply((Object)env.rpcEnv(), (Object)arguments, (Object)env, (Object)cfg.resourceProfile(), (Object)execId);
            env.rpcEnv().setupEndpoint("Executor", (RpcEndpoint)backend);
            arguments.workerUrl().foreach((Function1 & Serializable & scala.Serializable)url -> {
                RpcEnv x$1 = env.rpcEnv();
                String x$2 = url;
                AtomicBoolean x$3 = backend.stopping();
                boolean x$4 = WorkerWatcher$.MODULE$.$lessinit$greater$default$3();
                return env.rpcEnv().setupEndpoint("WorkerWatcher", (RpcEndpoint)new WorkerWatcher(x$1, x$2, x$4, x$3));
            });
            env.rpcEnv().awaitTermination();
        });
    }

    public KubernetesExecutorBackend.Arguments parseArguments(String[] args, String classNameForEntry) {
        String driverUrl = null;
        String executorId = null;
        String bindAddress = null;
        String hostname = null;
        int cores = 0;
        None$ resourcesFileOpt = None$.MODULE$;
        String appId = null;
        None$ workerUrl = None$.MODULE$;
        int resourceProfileId = ResourceProfile$.MODULE$.DEFAULT_RESOURCE_PROFILE_ID();
        String podName = null;
        List argv = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).toList();
        while (!argv.isEmpty()) {
            boolean bl = false;
            .colon.colon colon2 = null;
            List list = argv;
            if (list instanceof .colon.colon) {
                bl = true;
                colon2 = (.colon.colon)list;
                String string = (String)colon2.head();
                List list2 = colon2.tl$access$1();
                if ("--driver-url".equals(string) && list2 instanceof .colon.colon) {
                    .colon.colon colon3 = (.colon.colon)list2;
                    String value = (String)colon3.head();
                    List tail = colon3.tl$access$1();
                    driverUrl = value;
                    argv = tail;
                    continue;
                }
            }
            if (bl) {
                String string = (String)colon2.head();
                List list3 = colon2.tl$access$1();
                if ("--executor-id".equals(string) && list3 instanceof .colon.colon) {
                    .colon.colon colon4 = (.colon.colon)list3;
                    String value = (String)colon4.head();
                    List tail = colon4.tl$access$1();
                    executorId = value;
                    argv = tail;
                    continue;
                }
            }
            if (bl) {
                String string = (String)colon2.head();
                List list4 = colon2.tl$access$1();
                if ("--bind-address".equals(string) && list4 instanceof .colon.colon) {
                    .colon.colon colon5 = (.colon.colon)list4;
                    String value = (String)colon5.head();
                    List tail = colon5.tl$access$1();
                    bindAddress = value;
                    argv = tail;
                    continue;
                }
            }
            if (bl) {
                String string = (String)colon2.head();
                List list5 = colon2.tl$access$1();
                if ("--hostname".equals(string) && list5 instanceof .colon.colon) {
                    .colon.colon colon6 = (.colon.colon)list5;
                    String value = (String)colon6.head();
                    List tail = colon6.tl$access$1();
                    hostname = value;
                    argv = tail;
                    continue;
                }
            }
            if (bl) {
                String string = (String)colon2.head();
                List list6 = colon2.tl$access$1();
                if ("--cores".equals(string) && list6 instanceof .colon.colon) {
                    .colon.colon colon7 = (.colon.colon)list6;
                    String value = (String)colon7.head();
                    List tail = colon7.tl$access$1();
                    cores = new StringOps(Predef$.MODULE$.augmentString(value)).toInt();
                    argv = tail;
                    continue;
                }
            }
            if (bl) {
                String string = (String)colon2.head();
                List list7 = colon2.tl$access$1();
                if ("--resourcesFile".equals(string) && list7 instanceof .colon.colon) {
                    .colon.colon colon8 = (.colon.colon)list7;
                    String value = (String)colon8.head();
                    List tail = colon8.tl$access$1();
                    resourcesFileOpt = new Some((Object)value);
                    argv = tail;
                    continue;
                }
            }
            if (bl) {
                String string = (String)colon2.head();
                List list8 = colon2.tl$access$1();
                if ("--app-id".equals(string) && list8 instanceof .colon.colon) {
                    .colon.colon colon9 = (.colon.colon)list8;
                    String value = (String)colon9.head();
                    List tail = colon9.tl$access$1();
                    appId = value;
                    argv = tail;
                    continue;
                }
            }
            if (bl) {
                String string = (String)colon2.head();
                List list9 = colon2.tl$access$1();
                if ("--worker-url".equals(string) && list9 instanceof .colon.colon) {
                    .colon.colon colon10 = (.colon.colon)list9;
                    String value = (String)colon10.head();
                    List tail = colon10.tl$access$1();
                    workerUrl = new Some((Object)value);
                    argv = tail;
                    continue;
                }
            }
            if (bl) {
                String string = (String)colon2.head();
                List list10 = colon2.tl$access$1();
                if ("--resourceProfileId".equals(string) && list10 instanceof .colon.colon) {
                    .colon.colon colon11 = (.colon.colon)list10;
                    String value = (String)colon11.head();
                    List tail = colon11.tl$access$1();
                    resourceProfileId = new StringOps(Predef$.MODULE$.augmentString(value)).toInt();
                    argv = tail;
                    continue;
                }
            }
            if (bl) {
                String string = (String)colon2.head();
                List list11 = colon2.tl$access$1();
                if ("--podName".equals(string) && list11 instanceof .colon.colon) {
                    .colon.colon colon12 = (.colon.colon)list11;
                    String value = (String)colon12.head();
                    List tail = colon12.tl$access$1();
                    podName = value;
                    argv = tail;
                    continue;
                }
            }
            if (Nil$.MODULE$.equals(list)) {
                continue;
            }
            System.err.println(new StringBuilder(22).append("Unrecognized options: ").append(list.mkString(" ")).toString());
            this.printUsageAndExit(classNameForEntry);
        }
        if (hostname == null) {
            hostname = Utils$.MODULE$.localHostName();
            this.log().info(new StringBuilder(66).append("Executor hostname is not provided, will use '").append(hostname).append("' to advertise itself").toString());
        }
        if (driverUrl == null || executorId == null || cores <= 0 || appId == null) {
            this.printUsageAndExit(classNameForEntry);
        }
        if (bindAddress == null) {
            bindAddress = hostname;
        }
        return new KubernetesExecutorBackend.Arguments(driverUrl, executorId, bindAddress, hostname, cores, appId, (Option<String>)workerUrl, (Option<String>)resourcesFileOpt, resourceProfileId, podName);
    }

    private void printUsageAndExit(String classNameForEntry) {
        System.err.println(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(418).append("\n      |Usage: ").append(classNameForEntry).append(" [options]\n      |\n      | Options are:\n      |   --driver-url <driverUrl>\n      |   --executor-id <executorId>\n      |   --bind-address <bindAddress>\n      |   --hostname <hostname>\n      |   --cores <cores>\n      |   --resourcesFile <fileWithJSONResourceInformation>\n      |   --app-id <appid>\n      |   --worker-url <workerUrl>\n      |   --resourceProfileId <id>\n      |   --podName <podName>\n      |").toString())).stripMargin());
        System.exit(1);
    }

    public static final /* synthetic */ boolean $anonfun$run$4(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ void $anonfun$run$6(SparkConf driverConf$1, byte[] tokens) {
        SparkHadoopUtil$.MODULE$.get().addDelegationTokens(tokens, driverConf$1);
    }

    private KubernetesExecutorBackend$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

