/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.k8s;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimList;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.Filterable;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.Listable;
import io.fabric8.kubernetes.client.dsl.Waitable;
import java.io.Serializable;
import java.time.Instant;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesConf$;
import org.apache.spark.deploy.k8s.KubernetesExecutorConf;
import org.apache.spark.deploy.k8s.KubernetesExecutorSpec;
import org.apache.spark.deploy.k8s.KubernetesUtils$;
import org.apache.spark.deploy.k8s.SparkPod;
import org.apache.spark.internal.Logging;
import org.apache.spark.resource.ResourceProfile;
import org.apache.spark.resource.ResourceProfile$;
import org.apache.spark.scheduler.cluster.k8s.AbstractPodsAllocator;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodState;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsAllocator$;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshot;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshot$;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshotsStore;
import org.apache.spark.scheduler.cluster.k8s.KubernetesClusterSchedulerBackend;
import org.apache.spark.scheduler.cluster.k8s.KubernetesExecutorBuilder;
import org.apache.spark.scheduler.cluster.k8s.PodPending;
import org.apache.spark.scheduler.cluster.k8s.PodRunning;
import org.apache.spark.util.Clock;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.LinkedHashMap$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\rEa\u0001\u0002!B\u00019C\u0001\"\u0017\u0001\u0003\u0002\u0003\u0006IA\u0017\u0005\t=\u0002\u0011\t\u0011)A\u0005?\"A!\r\u0001B\u0001B\u0003%1\r\u0003\u0005g\u0001\t\u0005\t\u0015!\u0003h\u0011!\u0019\bA!A!\u0002\u0013!\b\u0002C<\u0001\u0005\u0003\u0005\u000b\u0011\u0002=\t\u000by\u0004A\u0011A@\t\u0013\u0005=\u0001A1A\u0005\n\u0005E\u0001\u0002CA\u0015\u0001\u0001\u0006I!a\u0005\t\u0013\u0005-\u0002A1A\u0005\n\u00055\u0002\u0002CA\"\u0001\u0001\u0006I!a\f\t\u0013\u0005\u0015\u0003A1A\u0005\n\u0005\u001d\u0003\u0002CA3\u0001\u0001\u0006I!!\u0013\t\u0013\u0005\u001d\u0004A1A\u0005\n\u0005%\u0004\u0002CA6\u0001\u0001\u0006I!a\u000e\t\u0013\u00055\u0004A1A\u0005\n\u0005=\u0004\u0002CA<\u0001\u0001\u0006I!!\u001d\t\u0013\u0005e\u0004A1A\u0005\n\u0005%\u0004\u0002CA>\u0001\u0001\u0006I!a\u000e\t\u0013\u0005u\u0004A1A\u0005\n\u0005=\u0004\u0002CA@\u0001\u0001\u0006I!!\u001d\t\u0013\u0005\u0005\u0005A1A\u0005\n\u0005=\u0004\u0002CAB\u0001\u0001\u0006I!!\u001d\t\u0013\u0005\u0015\u0005A1A\u0005\n\u0005=\u0004\u0002CAD\u0001\u0001\u0006I!!\u001d\t\u0013\u0005%\u0005A1A\u0005\n\u0005-\u0005\u0002CAR\u0001\u0001\u0006I!!$\t\u0013\u0005\u0015\u0006A1A\u0005\n\u0005\u001d\u0006\u0002CAX\u0001\u0001\u0006I!!+\t\u0013\u0005E\u0006A1A\u0005\n\u0005M\u0006\u0002CA^\u0001\u0001\u0006I!!.\t\u0013\u0005u\u0006A1A\u0005\u0002\u0005}\u0006\u0002CAj\u0001\u0001\u0006I!!1\t\u0013\u0005U\u0007A1A\u0005\n\u0005]\u0007\u0002CAs\u0001\u0001\u0006I!!7\t\u0013\u0005\u001d\bA1A\u0005\n\u0005%\b\u0002CAw\u0001\u0001\u0006I!a;\t\u0013\u0005=\bA1A\u0005\n\u0005M\u0006\u0002CAy\u0001\u0001\u0006I!!.\t\u0015\u0005M\bA1A\u0005\u0002\u0005\u000b\t\u0002\u0003\u0005\u0002v\u0002\u0001\u000b\u0011BA\n\u0011%\t9\u0010\u0001a\u0001\n\u0013\tI\u0010C\u0005\u0003\u0002\u0001\u0001\r\u0011\"\u0003\u0003\u0004!A!q\u0002\u0001!B\u0013\tY\u0010C\u0006\u0003\u0012\u0001\u0001\r\u00111A\u0005\n\u0005-\u0005b\u0003B\n\u0001\u0001\u0007\t\u0019!C\u0005\u0005+A1B!\u0007\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002\u000e\"I!1\u0004\u0001A\u0002\u0013%!Q\u0004\u0005\n\u0005W\u0001\u0001\u0019!C\u0005\u0005[A\u0001B!\r\u0001A\u0003&!q\u0004\u0005\b\u0005w\u0001A\u0011\u0001B\u001f\u0011\u001d\u0011i\u0005\u0001C\u0001\u0005\u001fBqAa\u0017\u0001\t\u0003\u0011i\u0006C\u0004\u0003d\u0001!IA!\u001a\t\u000f\t\u0005\u0005\u0001\"\u0003\u0003\u0004\"9!\u0011\u0014\u0001\u0005\n\tm\u0005b\u0002BU\u0001\u0011%!1\u0016\u0005\b\u0005\u0003\u0004A\u0011\u0002Bb\u0011\u001d\u0011\u0019\u000e\u0001C!\u0005+<\u0001B!7B\u0011\u00039%1\u001c\u0004\b\u0001\u0006C\ta\u0012Bo\u0011\u0019qX\b\"\u0001\u0003f\"9!q]\u001f\u0005\u0002\t%(!F#yK\u000e,Ho\u001c:Q_\u0012\u001c\u0018\t\u001c7pG\u0006$xN\u001d\u0006\u0003\u0005\u000e\u000b1a\u001b\u001dt\u0015\t!U)A\u0004dYV\u001cH/\u001a:\u000b\u0005\u0019;\u0015!C:dQ\u0016$W\u000f\\3s\u0015\tA\u0015*A\u0003ta\u0006\u00148N\u0003\u0002K\u0017\u00061\u0011\r]1dQ\u0016T\u0011\u0001T\u0001\u0004_J<7\u0001A\n\u0004\u0001=\u001b\u0006C\u0001)R\u001b\u0005\t\u0015B\u0001*B\u0005U\t%m\u001d;sC\u000e$\bk\u001c3t\u00032dwnY1u_J\u0004\"\u0001V,\u000e\u0003US!AV$\u0002\u0011%tG/\u001a:oC2L!\u0001W+\u0003\u000f1{wmZ5oO\u0006!1m\u001c8g!\tYF,D\u0001H\u0013\tivIA\u0005Ta\u0006\u00148nQ8oM\u000611/Z2NOJ\u0004\"a\u00171\n\u0005\u0005<%aD*fGV\u0014\u0018\u000e^=NC:\fw-\u001a:\u0002\u001f\u0015DXmY;u_J\u0014U/\u001b7eKJ\u0004\"\u0001\u00153\n\u0005\u0015\f%!G&vE\u0016\u0014h.\u001a;fg\u0016CXmY;u_J\u0014U/\u001b7eKJ\f\u0001c[;cKJtW\r^3t\u00072LWM\u001c;\u0011\u0005!\fX\"A5\u000b\u0005)\\\u0017AB2mS\u0016tGO\u0003\u0002m[\u0006Q1.\u001e2fe:,G/Z:\u000b\u00059|\u0017a\u00024bEJL7\r\u000f\u0006\u0002a\u0006\u0011\u0011n\\\u0005\u0003e&\u0014\u0001cS;cKJtW\r^3t\u00072LWM\u001c;\u0002\u001dMt\u0017\r]:i_R\u001c8\u000b^8sKB\u0011\u0001+^\u0005\u0003m\u0006\u0013!$\u0012=fGV$xN\u001d)pIN\u001cf.\u00199tQ>$8o\u0015;pe\u0016\fQa\u00197pG.\u0004\"!\u001f?\u000e\u0003iT!a_$\u0002\tU$\u0018\u000e\\\u0005\u0003{j\u0014Qa\u00117pG.\fa\u0001P5oSRtDCDA\u0001\u0003\u0007\t)!a\u0002\u0002\n\u0005-\u0011Q\u0002\t\u0003!\u0002AQ!W\u0004A\u0002iCQAX\u0004A\u0002}CQAY\u0004A\u0002\rDQAZ\u0004A\u0002\u001dDQa]\u0004A\u0002QDQa^\u0004A\u0002a\f1#\u0012-F\u0007V#vJU0J\t~\u001bu*\u0016(U\u000bJ+\"!a\u0005\u0011\t\u0005U\u0011QE\u0007\u0003\u0003/QA!!\u0007\u0002\u001c\u00051\u0011\r^8nS\u000eTA!!\b\u0002 \u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0007m\f\tC\u0003\u0002\u0002$\u0005!!.\u0019<b\u0013\u0011\t9#a\u0006\u0003\u001b\u0005#x.\\5d\u0013:$XmZ3s\u0003Q)\u0005,R\"V)>\u0013v,\u0013#`\u0007>+f\nV#SA\u0005QCo\u001c;bY\u0016C\b/Z2uK\u0012,\u00050Z2vi>\u00148\u000fU3s%\u0016\u001cx.\u001e:dKB\u0013xNZ5mK&#WCAA\u0018!!\t\t$a\r\u00028\u0005]RBAA\u000e\u0013\u0011\t)$a\u0007\u0003#\r{gnY;se\u0016tG\u000fS1tQ6\u000b\u0007\u000f\u0005\u0003\u0002:\u0005}RBAA\u001e\u0015\t\ti$A\u0003tG\u0006d\u0017-\u0003\u0003\u0002B\u0005m\"aA%oi\u0006YCo\u001c;bY\u0016C\b/Z2uK\u0012,\u00050Z2vi>\u00148\u000fU3s%\u0016\u001cx.\u001e:dKB\u0013xNZ5mK&#\u0007%A\u000bsa&#Gk\u001c*fg>,(oY3Qe>4\u0017\u000e\\3\u0016\u0005\u0005%\u0003\u0003CA&\u0003+\n9$!\u0017\u000e\u0005\u00055#\u0002BA(\u0003#\nq!\\;uC\ndWM\u0003\u0003\u0002T\u0005m\u0012AC2pY2,7\r^5p]&!\u0011qKA'\u0005\u001dA\u0015m\u001d5NCB\u0004B!a\u0017\u0002b5\u0011\u0011Q\f\u0006\u0004\u0003?:\u0015\u0001\u0003:fg>,(oY3\n\t\u0005\r\u0014Q\f\u0002\u0010%\u0016\u001cx.\u001e:dKB\u0013xNZ5mK\u00061\"\u000f]%e)>\u0014Vm]8ve\u000e,\u0007K]8gS2,\u0007%A\tq_\u0012\fE\u000e\\8dCRLwN\\*ju\u0016,\"!a\u000e\u0002%A|G-\u00117m_\u000e\fG/[8o'&TX\rI\u0001\u0013a>$\u0017\t\u001c7pG\u0006$\u0018n\u001c8EK2\f\u00170\u0006\u0002\u0002rA!\u0011\u0011HA:\u0013\u0011\t)(a\u000f\u0003\t1{gnZ\u0001\u0014a>$\u0017\t\u001c7pG\u0006$\u0018n\u001c8EK2\f\u0017\u0010I\u0001\u000f[\u0006D\b+\u001a8eS:<\u0007k\u001c3t\u0003=i\u0017\r\u001f)f]\u0012Lgn\u001a)pIN\u0004\u0013A\u00059pI\u000e\u0013X-\u0019;j_:$\u0016.\\3pkR\f1\u0003]8e\u0007J,\u0017\r^5p]RKW.Z8vi\u0002\n\u0011\u0004\u001a:jm\u0016\u0014\bk\u001c3SK\u0006$\u0017N\\3tgRKW.Z8vi\u0006QBM]5wKJ\u0004v\u000e\u001a*fC\u0012Lg.Z:t)&lWm\\;uA\u0005\u0019R\r_3dkR|'/\u00133mKRKW.Z8vi\u0006!R\r_3dkR|'/\u00133mKRKW.Z8vi\u0002\n\u0011B\\1nKN\u0004\u0018mY3\u0016\u0005\u00055\u0005\u0003BAH\u0003;sA!!%\u0002\u001aB!\u00111SA\u001e\u001b\t\t)JC\u0002\u0002\u00186\u000ba\u0001\u0010:p_Rt\u0014\u0002BAN\u0003w\ta\u0001\u0015:fI\u00164\u0017\u0002BAP\u0003C\u0013aa\u0015;sS:<'\u0002BAN\u0003w\t!B\\1nKN\u0004\u0018mY3!\u0003]YWOY3s]\u0016$Xm\u001d#sSZ,'\u000fU8e\u001d\u0006lW-\u0006\u0002\u0002*B1\u0011\u0011HAV\u0003\u001bKA!!,\u0002<\t1q\n\u001d;j_:\f\u0001d[;cKJtW\r^3t\tJLg/\u001a:Q_\u0012t\u0015-\\3!\u0003U\u0019\bn\\;mI\u0012+G.\u001a;f\u000bb,7-\u001e;peN,\"!!.\u0011\t\u0005e\u0012qW\u0005\u0005\u0003s\u000bYDA\u0004C_>dW-\u00198\u0002-MDw.\u001e7e\t\u0016dW\r^3Fq\u0016\u001cW\u000f^8sg\u0002\n\u0011\u0002\u001a:jm\u0016\u0014\bk\u001c3\u0016\u0005\u0005\u0005\u0007CBA\u001d\u0003W\u000b\u0019\r\u0005\u0003\u0002F\u0006=WBAAd\u0015\u0011\tI-a3\u0002\u000b5|G-\u001a7\u000b\u0007\u000557.A\u0002ba&LA!!5\u0002H\n\u0019\u0001k\u001c3\u0002\u0015\u0011\u0014\u0018N^3s!>$\u0007%A\u000boK^d\u0017p\u0011:fCR,G-\u0012=fGV$xN]:\u0016\u0005\u0005e\u0007\u0003CA&\u00037\f\t(a8\n\t\u0005u\u0017Q\n\u0002\u000e\u0019&t7.\u001a3ICNDW*\u00199\u0011\u0011\u0005e\u0012\u0011]A\u001c\u0003cJA!a9\u0002<\t1A+\u001e9mKJ\naC\\3xYf\u001c%/Z1uK\u0012,\u00050Z2vi>\u00148\u000fI\u0001 g\u000eDW\rZ;mKJ\\en\\<o\u001d\u0016<H._\"sK\u0006$X\rZ#yK\u000e\u001cXCAAv!!\tY%a7\u0002r\u0005]\u0012\u0001I:dQ\u0016$W\u000f\\3s\u0017:|wO\u001c(fo2L8I]3bi\u0016$W\t_3dg\u0002\n\u0001\u0004Z=oC6L7-\u00117m_\u000e\fG/[8o\u000b:\f'\r\\3e\u0003e!\u0017P\\1nS\u000e\fE\u000e\\8dCRLwN\\#oC\ndW\r\u001a\u0011\u0002%9,XnT;ugR\fg\u000eZ5oOB{Gm]\u0001\u0014]Vlw*\u001e;ti\u0006tG-\u001b8h!>$7\u000fI\u0001\rY\u0006\u001cHo\u00158baNDw\u000e^\u000b\u0003\u0003w\u00042\u0001UA\u007f\u0013\r\ty0\u0011\u0002\u0015\u000bb,7-\u001e;peB{Gm]*oCB\u001c\bn\u001c;\u0002!1\f7\u000f^*oCB\u001c\bn\u001c;`I\u0015\fH\u0003\u0002B\u0003\u0005\u0017\u0001B!!\u000f\u0003\b%!!\u0011BA\u001e\u0005\u0011)f.\u001b;\t\u0013\t51&!AA\u0002\u0005m\u0018a\u0001=%c\u0005iA.Y:u':\f\u0007o\u001d5pi\u0002\nQ!\u00199q\u0013\u0012\f\u0011\"\u00199q\u0013\u0012|F%Z9\u0015\t\t\u0015!q\u0003\u0005\n\u0005\u001bq\u0013\u0011!a\u0001\u0003\u001b\u000ba!\u00199q\u0013\u0012\u0004\u0013A\u00053fY\u0016$X\rZ#yK\u000e,Ho\u001c:JIN,\"Aa\b\u0011\r\t\u0005\"qEA9\u001b\t\u0011\u0019C\u0003\u0003\u0003&\u0005E\u0013!C5n[V$\u0018M\u00197f\u0013\u0011\u0011ICa\t\u0003\u0007M+G/\u0001\feK2,G/\u001a3Fq\u0016\u001cW\u000f^8s\u0013\u0012\u001cx\fJ3r)\u0011\u0011)Aa\f\t\u0013\t5\u0011'!AA\u0002\t}\u0011a\u00053fY\u0016$X\rZ#yK\u000e,Ho\u001c:JIN\u0004\u0003f\u0001\u001a\u00036A!\u0011\u0011\bB\u001c\u0013\u0011\u0011I$a\u000f\u0003\u0011Y|G.\u0019;jY\u0016\fQa\u001d;beR$bA!\u0002\u0003@\t\r\u0003b\u0002B!g\u0001\u0007\u0011QR\u0001\u000eCB\u0004H.[2bi&|g.\u00133\t\u000f\t\u00153\u00071\u0001\u0003H\u0005\u00012o\u00195fIVdWM\u001d\"bG.,g\u000e\u001a\t\u0004!\n%\u0013b\u0001B&\u0003\n\t3*\u001e2fe:,G/Z:DYV\u001cH/\u001a:TG\",G-\u001e7fe\n\u000b7m[3oI\u0006I2/\u001a;U_R\fG.\u0012=qK\u000e$X\rZ#yK\u000e,Ho\u001c:t)\u0011\u0011)A!\u0015\t\u000f\tMC\u00071\u0001\u0003V\u0005Y\"/Z:pkJ\u001cW\r\u0015:pM&dW\rV8U_R\fG.\u0012=fGN\u0004\u0002\"a$\u0003X\u0005e\u0013qG\u0005\u0005\u00053\n\tKA\u0002NCB\f\u0011\"[:EK2,G/\u001a3\u0015\t\u0005U&q\f\u0005\b\u0005C*\u0004\u0019AAG\u0003))\u00070Z2vi>\u0014\u0018\nZ\u0001\u000f_:tUm^*oCB\u001c\bn\u001c;t)!\u0011)Aa\u001a\u0003j\t-\u0004b\u0002B!m\u0001\u0007\u0011Q\u0012\u0005\b\u0005\u000b2\u0004\u0019\u0001B$\u0011\u001d\u0011iG\u000ea\u0001\u0005_\n\u0011b\u001d8baNDw\u000e^:\u0011\r\tE$1PA~\u001d\u0011\u0011\u0019Ha\u001e\u000f\t\u0005M%QO\u0005\u0003\u0003{IAA!\u001f\u0002<\u00059\u0001/Y2lC\u001e,\u0017\u0002\u0002B?\u0005\u007f\u00121aU3r\u0015\u0011\u0011I(a\u000f\u0002\u001f\u001d,GOU3vg\u0006\u0014G.\u001a)W\u0007N$bA!\"\u0003\u0012\nM\u0005CBA&\u0005\u000f\u0013Y)\u0003\u0003\u0003\n\u00065#A\u0002\"vM\u001a,'\u000f\u0005\u0003\u0002F\n5\u0015\u0002\u0002BH\u0003\u000f\u0014Q\u0003U3sg&\u001cH/\u001a8u->dW/\\3DY\u0006LW\u000eC\u0004\u0003B]\u0002\r!!$\t\u000f\tUu\u00071\u0001\u0003\u0018\u0006I\u0001O^2t\u0013:,6/\u001a\t\u0007\u0005c\u0012Y(!$\u0002'I,\u0017/^3ti:+w/\u0012=fGV$xN]:\u0015\u0015\t\u0015!Q\u0014BQ\u0005G\u00139\u000bC\u0004\u0003 b\u0002\r!a\u000e\u0002-9,X.\u0012=fGV$xN]:U_\u0006cGn\\2bi\u0016DqA!\u00119\u0001\u0004\ti\tC\u0004\u0003&b\u0002\r!a\u000e\u0002#I,7o\\;sG\u0016\u0004&o\u001c4jY\u0016LE\rC\u0004\u0003\u0016b\u0002\rAa&\u0002'I,\u0007\u000f\\1dKB36i]%g\u001d\u0016,G-\u001a3\u0015\u0011\t5&Q\u0017B]\u0005{\u0003bA!\u001d\u0003|\t=\u0006\u0003BAc\u0005cKAAa-\u0002H\nY\u0001*Y:NKR\fG-\u0019;b\u0011\u001d\u00119,\u000fa\u0001\u0003\u0007\f1\u0001]8e\u0011\u001d\u0011Y,\u000fa\u0001\u0005[\u000b\u0011B]3t_V\u00148-Z:\t\u000f\t}\u0016\b1\u0001\u0003\u0006\u0006a!/Z;tC\ndW\r\u0015,Dg\u00061\u0012n]#yK\u000e,Ho\u001c:JI2,G+[7fI>+H\u000f\u0006\u0004\u00026\n\u0015'q\u001a\u0005\b\u0005\u000fT\u0004\u0019\u0001Be\u0003\u0015\u0019H/\u0019;f!\r\u0001&1Z\u0005\u0004\u0005\u001b\f%\u0001E#yK\u000e,Ho\u001c:Q_\u0012\u001cF/\u0019;f\u0011\u001d\u0011\tN\u000fa\u0001\u0003c\n1bY;se\u0016tG\u000fV5nK\u0006!1\u000f^8q)\u0011\u0011)Aa6\t\u000f\t\u00053\b1\u0001\u0002\u000e\u0006)R\t_3dkR|'\u000fU8eg\u0006cGn\\2bi>\u0014\bC\u0001)>'\ri$q\u001c\t\u0005\u0003s\u0011\t/\u0003\u0003\u0003d\u0006m\"AB!osJ+g\r\u0006\u0002\u0003\\\u0006Q1\u000f\u001d7jiNcw\u000e^:\u0016\t\t-(Q\u001f\u000b\u0007\u0005[\u001c9a!\u0004\u0011\r\tE$1\u0010Bx!!\tI$!9\u0003r\u0006]\u0002\u0003\u0002Bz\u0005kd\u0001\u0001B\u0004\u0003x~\u0012\rA!?\u0003\u0003Q\u000bBAa?\u0004\u0002A!\u0011\u0011\bB\u007f\u0013\u0011\u0011y0a\u000f\u0003\u000f9{G\u000f[5oOB!\u0011\u0011HB\u0002\u0013\u0011\u0019)!a\u000f\u0003\u0007\u0005s\u0017\u0010C\u0004\u0004\n}\u0002\raa\u0003\u0002\u0013\r|gn];nKJ\u001c\bC\u0002B9\u0005w\u0012\t\u0010C\u0004\u0004\u0010}\u0002\r!a\u000e\u0002\u000bMdw\u000e^:")
public class ExecutorPodsAllocator
extends AbstractPodsAllocator
implements Logging {
    private final SparkConf conf;
    private final SecurityManager secMgr;
    private final KubernetesExecutorBuilder executorBuilder;
    private final KubernetesClient kubernetesClient;
    private final ExecutorPodsSnapshotsStore snapshotsStore;
    private final Clock clock;
    private final AtomicInteger EXECUTOR_ID_COUNTER;
    private final ConcurrentHashMap<Object, Object> totalExpectedExecutorsPerResourceProfileId;
    private final HashMap<Object, ResourceProfile> rpIdToResourceProfile;
    private final int podAllocationSize;
    private final long podAllocationDelay;
    private final int maxPendingPods;
    private final long podCreationTimeout;
    private final long driverPodReadinessTimeout;
    private final long executorIdleTimeout;
    private final String namespace;
    private final Option<String> kubernetesDriverPodName;
    private final boolean shouldDeleteExecutors;
    private final Option<Pod> driverPod;
    private final LinkedHashMap<Object, Tuple2<Object, Object>> newlyCreatedExecutors;
    private final LinkedHashMap<Object, Object> schedulerKnownNewlyCreatedExecs;
    private final boolean dynamicAllocationEnabled;
    private final AtomicInteger numOutstandingPods;
    private ExecutorPodsSnapshot lastSnapshot;
    private String appId;
    private volatile scala.collection.immutable.Set<Object> deletedExecutorIds;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static <T> Seq<Tuple2<T, Object>> splitSlots(Seq<T> seq, int n) {
        return ExecutorPodsAllocator$.MODULE$.splitSlots(seq, n);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private AtomicInteger EXECUTOR_ID_COUNTER() {
        return this.EXECUTOR_ID_COUNTER;
    }

    private ConcurrentHashMap<Object, Object> totalExpectedExecutorsPerResourceProfileId() {
        return this.totalExpectedExecutorsPerResourceProfileId;
    }

    private HashMap<Object, ResourceProfile> rpIdToResourceProfile() {
        return this.rpIdToResourceProfile;
    }

    private int podAllocationSize() {
        return this.podAllocationSize;
    }

    private long podAllocationDelay() {
        return this.podAllocationDelay;
    }

    private int maxPendingPods() {
        return this.maxPendingPods;
    }

    private long podCreationTimeout() {
        return this.podCreationTimeout;
    }

    private long driverPodReadinessTimeout() {
        return this.driverPodReadinessTimeout;
    }

    private long executorIdleTimeout() {
        return this.executorIdleTimeout;
    }

    private String namespace() {
        return this.namespace;
    }

    private Option<String> kubernetesDriverPodName() {
        return this.kubernetesDriverPodName;
    }

    private boolean shouldDeleteExecutors() {
        return this.shouldDeleteExecutors;
    }

    @Override
    public Option<Pod> driverPod() {
        return this.driverPod;
    }

    private LinkedHashMap<Object, Tuple2<Object, Object>> newlyCreatedExecutors() {
        return this.newlyCreatedExecutors;
    }

    private LinkedHashMap<Object, Object> schedulerKnownNewlyCreatedExecs() {
        return this.schedulerKnownNewlyCreatedExecs;
    }

    private boolean dynamicAllocationEnabled() {
        return this.dynamicAllocationEnabled;
    }

    public AtomicInteger numOutstandingPods() {
        return this.numOutstandingPods;
    }

    private ExecutorPodsSnapshot lastSnapshot() {
        return this.lastSnapshot;
    }

    private void lastSnapshot_$eq(ExecutorPodsSnapshot x$1) {
        this.lastSnapshot = x$1;
    }

    private String appId() {
        return this.appId;
    }

    private void appId_$eq(String x$1) {
        this.appId = x$1;
    }

    private scala.collection.immutable.Set<Object> deletedExecutorIds() {
        return this.deletedExecutorIds;
    }

    private void deletedExecutorIds_$eq(scala.collection.immutable.Set<Object> x$1) {
        this.deletedExecutorIds = x$1;
    }

    @Override
    public void start(String applicationId, KubernetesClusterSchedulerBackend schedulerBackend) {
        this.appId_$eq(applicationId);
        this.driverPod().foreach((Function1 & Serializable & scala.Serializable)pod -> {
            Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((Waitable)this.kubernetesClient.pods().withName(pod.getMetadata().getName())).waitUntilReady(this.driverPodReadinessTimeout(), TimeUnit.SECONDS));
            return BoxedUnit.UNIT;
        });
        this.snapshotsStore.addSubscriber(this.podAllocationDelay(), (Function1<Seq<ExecutorPodsSnapshot>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x$1 -> {
            this.onNewSnapshots(applicationId, schedulerBackend, (Seq<ExecutorPodsSnapshot>)x$1);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void setTotalExpectedExecutors(Map<ResourceProfile, Object> resourceProfileToTotalExecs) {
        resourceProfileToTotalExecs.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)ExecutorPodsAllocator.$anonfun$setTotalExpectedExecutors$1(this, x0$1)));
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Set total expected execs to ").append(this.totalExpectedExecutorsPerResourceProfileId()).toString());
        if (this.numOutstandingPods().get() == 0) {
            this.snapshotsStore.notifySubscribers();
            return;
        }
    }

    @Override
    public boolean isDeleted(String executorId) {
        return this.deletedExecutorIds().contains((Object)BoxesRunTime.boxToLong((long)new StringOps(Predef$.MODULE$.augmentString(executorId)).toLong()));
    }

    private void onNewSnapshots(String applicationId, KubernetesClusterSchedulerBackend schedulerBackend, Seq<ExecutorPodsSnapshot> snapshots) {
        Seq k8sKnownExecIds = (Seq)snapshots.flatMap((Function1 & Serializable & scala.Serializable)x$2 -> x$2.executorPods().keys(), Seq$.MODULE$.canBuildFrom());
        this.newlyCreatedExecutors().$minus$minus$eq((TraversableOnce)k8sKnownExecIds);
        this.schedulerKnownNewlyCreatedExecs().$minus$minus$eq((TraversableOnce)k8sKnownExecIds);
        Seq k8sKnownPVCNames = (Seq)((TraversableLike)snapshots.flatMap((Function1 & Serializable & scala.Serializable)x$3 -> (Iterable)x$3.executorPods().values().map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.pod(), Iterable$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)pod -> (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pod.getSpec().getVolumes()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)v -> Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)v.getPersistentVolumeClaim()).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.getClaimName())), Buffer$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        scala.collection.immutable.Set schedulerKnownExecs = ((TraversableOnce)schedulerBackend.getExecutorIds().map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)ExecutorPodsAllocator.$anonfun$onNewSnapshots$7(x$6)), Seq$.MODULE$.canBuildFrom())).toSet();
        this.schedulerKnownNewlyCreatedExecs().$plus$plus$eq((TraversableOnce)this.newlyCreatedExecutors().filterKeys((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$7 -> schedulerKnownExecs.contains((Object)BoxesRunTime.boxToLong((long)x$7))).mapValues((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToInteger((int)x$8._1$mcI$sp())));
        this.newlyCreatedExecutors().$minus$minus$eq((TraversableOnce)this.schedulerKnownNewlyCreatedExecs().keySet());
        long currentTime = this.clock.getTimeMillis();
        scala.collection.mutable.Iterable timedOut = (scala.collection.mutable.Iterable)this.newlyCreatedExecutors().flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                long execId = tuple2._1$mcJ$sp();
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                if (tuple22 != null) {
                    long timeCreated = tuple22._2$mcJ$sp();
                    if (currentTime - timeCreated > this.podCreationTimeout()) {
                        return Option$.MODULE$.option2Iterable((Option)new Some((Object)BoxesRunTime.boxToLong((long)execId)));
                    }
                    this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(97).append("Executor with id ").append(execId).append(" was not found in the Kubernetes cluster since it").append(" was created ").append(currentTime - timeCreated).append(" milliseconds ago.").toString());
                    return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                }
            }
            throw new MatchError((Object)tuple2);
        }, scala.collection.mutable.Iterable$.MODULE$.canBuildFrom());
        if (timedOut.nonEmpty()) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(230).append("Executors with ids ").append(timedOut.mkString(",")).append(" were not detected in the").append(" Kubernetes cluster after ").append(this.podCreationTimeout()).append(" ms despite the fact that a previous").append(" allocation attempt tried to create them. The executors may have been deleted but the").append(" application missed the deletion event.").toString());
            this.newlyCreatedExecutors().$minus$minus$eq((TraversableOnce)timedOut);
            if (this.shouldDeleteExecutors()) {
                Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((Deletable)((Filterable)((Filterable)$this.kubernetesClient.pods().withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), applicationId)).withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).withLabelIn(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL(), (String[])((TraversableOnce)timedOut.toSeq().map((Function1 & Serializable & scala.Serializable)x$9 -> ExecutorPodsAllocator.$anonfun$onNewSnapshots$14(BoxesRunTime.unboxToLong((Object)x$9)), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class)))).delete());
            }
        }
        if (snapshots.nonEmpty()) {
            this.lastSnapshot_$eq((ExecutorPodsSnapshot)snapshots.last());
        }
        ObjectRef _deletedExecutorIds = ObjectRef.create(this.deletedExecutorIds());
        if (snapshots.nonEmpty()) {
            scala.collection.immutable.Set existingExecs = this.lastSnapshot().executorPods().keySet();
            _deletedExecutorIds.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)_deletedExecutorIds.elem).intersect((GenSet)existingExecs);
        }
        Map notDeletedPods = this.lastSnapshot().executorPods().filterKeys((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$10 -> !((scala.collection.immutable.Set)_deletedExecutorIds$1.elem).contains((Object)BoxesRunTime.boxToLong((long)x$10)));
        HashMap rpIdToExecsAndPodState = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        if (this.totalExpectedExecutorsPerResourceProfileId().size() <= 1) {
            rpIdToExecsAndPodState.update((Object)BoxesRunTime.boxToInteger((int)ResourceProfile$.MODULE$.DEFAULT_RESOURCE_PROFILE_ID()), (Object)HashMap$.MODULE$.empty().$plus$plus$eq((TraversableOnce)notDeletedPods));
        } else {
            notDeletedPods.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                ExecutorPodsAllocator.$anonfun$onNewSnapshots$16(rpIdToExecsAndPodState, x0$2);
                return BoxedUnit.UNIT;
            });
        }
        IntRef totalPendingCount = IntRef.create((int)0);
        IntRef totalNotRunningPodCount = IntRef.create((int)0);
        Seq podsToAllocateWithRpId = (Seq)((TraversableLike)((scala.collection.mutable.MapLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.totalExpectedExecutorsPerResourceProfileId()).asScala()).toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToInteger((int)x$11._1$mcI$sp()), (Ordering)Ordering.Int$.MODULE$)).flatMap((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 != null) {
                int rpId = tuple2._1$mcI$sp();
                int targetNum = tuple2._2$mcI$sp();
                HashMap podsForRpId = (HashMap)rpIdToExecsAndPodState.getOrElse((Object)BoxesRunTime.boxToInteger((int)rpId), (Function0 & Serializable & scala.Serializable)() -> HashMap$.MODULE$.empty());
                int currentRunningCount = podsForRpId.values().count((Function1 & Serializable & scala.Serializable)x0$4 -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsAllocator.$anonfun$onNewSnapshots$21(x0$4)));
                Tuple2 tuple22 = ((TraversableLike)podsForRpId.filter((Function1 & Serializable & scala.Serializable)x0$5 -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsAllocator.$anonfun$onNewSnapshots$22(x0$5)))).partition((Function1 & Serializable & scala.Serializable)x0$6 -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsAllocator.$anonfun$onNewSnapshots$23(schedulerKnownExecs, x0$6)));
                if (tuple22 == null) {
                    throw new MatchError((Object)tuple22);
                }
                HashMap schedulerKnownPendingExecsForRpId = (HashMap)tuple22._1();
                HashMap currentPendingExecutorsForRpId = (HashMap)tuple22._2();
                Tuple2 tuple23 = new Tuple2((Object)schedulerKnownPendingExecsForRpId, (Object)currentPendingExecutorsForRpId);
                HashMap schedulerKnownPendingExecsForRpId2 = (HashMap)tuple23._1();
                HashMap currentPendingExecutorsForRpId2 = (HashMap)tuple23._2();
                IntRef pendingCountForRpId = IntRef.create((int)currentPendingExecutorsForRpId2.size());
                LinkedHashMap newlyCreatedExecutorsForRpId = (LinkedHashMap)this.newlyCreatedExecutors().filter((Function1 & Serializable & scala.Serializable)x0$7 -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsAllocator.$anonfun$onNewSnapshots$24(rpId, x0$7)));
                LinkedHashMap schedulerKnownNewlyCreatedExecsForRpId = (LinkedHashMap)this.schedulerKnownNewlyCreatedExecs().filter((Function1 & Serializable & scala.Serializable)x0$8 -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsAllocator.$anonfun$onNewSnapshots$25(rpId, x0$8)));
                if (podsForRpId.nonEmpty()) {
                    this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(170).append("ResourceProfile Id: ").append(rpId).append(" (").append("pod allocation status: ").append(currentRunningCount).append(" running, ").append(currentPendingExecutorsForRpId2.size()).append(" unknown pending, ").append(schedulerKnownPendingExecsForRpId2.size()).append(" scheduler backend known pending, ").append(newlyCreatedExecutorsForRpId.size()).append(" unknown newly created, ").append(schedulerKnownNewlyCreatedExecsForRpId.size()).append(" scheduler backend known newly created)").toString());
                }
                IntRef notRunningPodCountForRpId = IntRef.create((int)(currentPendingExecutorsForRpId2.size() + schedulerKnownPendingExecsForRpId2.size() + newlyCreatedExecutorsForRpId.size() + schedulerKnownNewlyCreatedExecsForRpId.size()));
                int podCountForRpId = currentRunningCount + notRunningPodCountForRpId.elem;
                if (podCountForRpId > targetNum) {
                    scala.collection.mutable.Iterable pendingToDelete;
                    int excess = podCountForRpId - targetNum;
                    List newlyCreatedToDelete = ((TraversableOnce)((MapLike)newlyCreatedExecutorsForRpId.filter((Function1 & Serializable & scala.Serializable)x0$9 -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsAllocator.$anonfun$onNewSnapshots$27(this, currentTime, x0$9)))).keys().take(excess)).toList();
                    List toDelete = (List)newlyCreatedToDelete.$plus$plus((GenTraversableOnce)(pendingToDelete = (scala.collection.mutable.Iterable)((TraversableLike)((IterableLike)currentPendingExecutorsForRpId2.filter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)this.isExecutorIdleTimedOut((ExecutorPodState)x._2(), currentTime)))).take(excess - newlyCreatedToDelete.size())).map((Function1 & Serializable & scala.Serializable)x0$10 -> BoxesRunTime.boxToLong((long)ExecutorPodsAllocator.$anonfun$onNewSnapshots$29(x0$10)), scala.collection.mutable.Iterable$.MODULE$.canBuildFrom())), List$.MODULE$.canBuildFrom());
                    if (toDelete.nonEmpty()) {
                        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Deleting ").append(toDelete.size()).append(" excess pod requests (").append(toDelete.mkString(",")).append(").").toString());
                        _deletedExecutorIds$1.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)_deletedExecutorIds$1.elem).$plus$plus((GenTraversableOnce)toDelete);
                        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                            ((Deletable)((Filterable)((Filterable)((Filterable)$this.kubernetesClient.pods().withField("status.phase", "Pending")).withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), applicationId)).withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).withLabelIn(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL(), (String[])((TraversableOnce)((List)toDelete.sorted((Ordering)Ordering.Long$.MODULE$)).map((Function1 & Serializable & scala.Serializable)x$13 -> ExecutorPodsAllocator.$anonfun$onNewSnapshots$32(BoxesRunTime.unboxToLong((Object)x$13)), List$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class)))).delete();
                            this.newlyCreatedExecutors().$minus$minus$eq((TraversableOnce)newlyCreatedToDelete);
                            pendingCountForRpId$1.elem -= pendingToDelete.size();
                            notRunningPodCountForRpId$1.elem -= toDelete.size();
                        });
                    }
                }
                totalPendingCount$1.elem += pendingCountForRpId.elem;
                totalNotRunningPodCount$1.elem += notRunningPodCountForRpId.elem;
                if (this.log().isDebugEnabled() && snapshots.nonEmpty()) {
                    int outstanding = pendingCountForRpId.elem + newlyCreatedExecutorsForRpId.size();
                    if (currentRunningCount >= targetNum && !this.dynamicAllocationEnabled()) {
                        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(130).append("Current number of running executors for ResourceProfile Id ").append(rpId).append(" is ").append("equal to the number of requested executors. Not scaling up further.").toString());
                    } else if (newlyCreatedExecutorsForRpId.nonEmpty()) {
                        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(76).append("Still waiting for ").append(newlyCreatedExecutorsForRpId.size()).append(" executors for ").append("ResourceProfile Id ").append(rpId).append(" before requesting more.").toString());
                    }
                }
                if (newlyCreatedExecutorsForRpId.isEmpty() && podCountForRpId < targetNum) {
                    return Option$.MODULE$.option2Iterable((Option)new Some((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)rpId), (Object)BoxesRunTime.boxToInteger((int)podCountForRpId), (Object)BoxesRunTime.boxToInteger((int)targetNum))));
                }
                return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom());
        int remainingSlotFromPendingPods = this.maxPendingPods() - totalNotRunningPodCount.elem;
        if (remainingSlotFromPendingPods > 0 && podsToAllocateWithRpId.size() > 0) {
            ExecutorPodsAllocator$.MODULE$.splitSlots(podsToAllocateWithRpId, remainingSlotFromPendingPods).foreach((Function1 & Serializable & scala.Serializable)x0$11 -> {
                ExecutorPodsAllocator.$anonfun$onNewSnapshots$35(this, applicationId, k8sKnownPVCNames, x0$11);
                return BoxedUnit.UNIT;
            });
        }
        this.deletedExecutorIds_$eq((scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)_deletedExecutorIds.elem));
        this.numOutstandingPods().set(totalPendingCount.elem + this.newlyCreatedExecutors().size());
    }

    private Buffer<PersistentVolumeClaim> getReusablePVCs(String applicationId, Seq<String> pvcsInUse) {
        if (BoxesRunTime.unboxToBoolean((Object)this.conf.get(Config$.MODULE$.KUBERNETES_DRIVER_OWN_PVC())) && BoxesRunTime.unboxToBoolean((Object)this.conf.get(Config$.MODULE$.KUBERNETES_DRIVER_REUSE_PVC())) && this.driverPod().nonEmpty()) {
            Buffer createdPVCs = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(((PersistentVolumeClaimList)((Listable)this.kubernetesClient.persistentVolumeClaims().withLabel("spark-app-selector", applicationId)).list()).getItems()).asScala();
            long now = Instant.now().toEpochMilli();
            Buffer reusablePVCs = (Buffer)((TraversableLike)createdPVCs.filterNot((Function1 & Serializable & scala.Serializable)pvc -> BoxesRunTime.boxToBoolean((boolean)pvcsInUse.contains((Object)pvc.getMetadata().getName())))).filter((Function1 & Serializable & scala.Serializable)pvc -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsAllocator.$anonfun$getReusablePVCs$2(this, now, pvc)));
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Found ").append(reusablePVCs.size()).append(" reusable PVCs from ").append(createdPVCs.size()).append(" PVCs").toString());
            return reusablePVCs;
        }
        return (Buffer)Buffer$.MODULE$.empty();
    }

    private void requestNewExecutors(int numExecutorsToAllocate, String applicationId, int resourceProfileId, Seq<String> pvcsInUse) {
        Buffer<PersistentVolumeClaim> reusablePVCs = this.getReusablePVCs(applicationId, pvcsInUse);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numExecutorsToAllocate).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            int newExecutorId = this.EXECUTOR_ID_COUNTER().incrementAndGet();
            KubernetesExecutorConf executorConf = KubernetesConf$.MODULE$.createExecutorConf($this.conf, Integer.toString(newExecutorId), applicationId, this.driverPod(), resourceProfileId);
            KubernetesExecutorSpec resolvedExecutorSpec = $this.executorBuilder.buildFromFeatures(executorConf, $this.secMgr, $this.kubernetesClient, (ResourceProfile)this.rpIdToResourceProfile().apply((Object)BoxesRunTime.boxToInteger((int)resourceProfileId)));
            SparkPod executorPod = resolvedExecutorSpec.pod();
            Pod podWithAttachedContainer = ((PodBuilder)((PodFluent.SpecNested)new PodBuilder(executorPod.pod()).editOrNewSpec().addToContainers(new Container[]{executorPod.container()})).endSpec()).build();
            Seq<HasMetadata> resources = this.replacePVCsIfNeeded(podWithAttachedContainer, resolvedExecutorSpec.executorKubernetesResources(), reusablePVCs);
            Pod createdExecutorPod = (Pod)$this.kubernetesClient.pods().create((Object)podWithAttachedContainer);
            try {
                KubernetesUtils$.MODULE$.addOwnerReference(createdExecutorPod, resources);
                ((IterableLike)resources.filter((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsAllocator.$anonfun$requestNewExecutors$2(x$14)))).foreach((Function1 & Serializable & scala.Serializable)resource -> {
                    if (BoxesRunTime.unboxToBoolean((Object)$this.conf.get(Config$.MODULE$.KUBERNETES_DRIVER_OWN_PVC())) && this.driverPod().nonEmpty()) {
                        KubernetesUtils$.MODULE$.addOwnerReference((Pod)this.driverPod().get(), (Seq<HasMetadata>)((Seq)new .colon.colon(resource, (List)Nil$.MODULE$)));
                    }
                    PersistentVolumeClaim pvc = (PersistentVolumeClaim)resource;
                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(58).append("Trying to create PersistentVolumeClaim ").append(pvc.getMetadata().getName()).append(" with ").append("StorageClass ").append(pvc.getSpec().getStorageClassName()).toString());
                    return (PersistentVolumeClaim)$this.kubernetesClient.persistentVolumeClaims().create((Object)pvc);
                });
                this.newlyCreatedExecutors().update((Object)BoxesRunTime.boxToLong((long)newExecutorId), (Object)new Tuple2.mcIJ.sp(resourceProfileId, $this.clock.getTimeMillis()));
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Requested executor with id ").append(newExecutorId).append(" from Kubernetes.").toString());
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    $this.kubernetesClient.pods().delete((Object[])new Pod[]{createdExecutorPod});
                    throw e;
                }
                throw throwable;
            }
        });
    }

    private Seq<HasMetadata> replacePVCsIfNeeded(Pod pod, Seq<HasMetadata> resources, Buffer<PersistentVolumeClaim> reusablePVCs) {
        Set replacedResources = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        resources.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ExecutorPodsAllocator.$anonfun$replacePVCsIfNeeded$1(this, reusablePVCs, pod, replacedResources, x0$1);
            return BoxedUnit.UNIT;
        });
        return (Seq)resources.filterNot((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)replacedResources.contains((Object)elem)));
    }

    private boolean isExecutorIdleTimedOut(ExecutorPodState state, long currentTime) {
        boolean bl;
        block3: {
            try {
                long creationTime = Instant.parse(state.pod().getMetadata().getCreationTimestamp()).toEpochMilli();
                if (currentTime - creationTime > this.executorIdleTimeout()) {
                    bl = true;
                    break block3;
                }
                bl = false;
            }
            catch (Exception e) {
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Cannot get the creationTimestamp of the pod: ").append(state.pod()).toString(), e);
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public void stop(String applicationId) {
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((Deletable)((Filterable)$this.kubernetesClient.pods().withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), applicationId)).withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).delete());
    }

    public static final /* synthetic */ int $anonfun$setTotalExpectedExecutors$1(ExecutorPodsAllocator $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            ResourceProfile rp = (ResourceProfile)tuple2._1();
            int numExecs = tuple2._2$mcI$sp();
            $this.rpIdToResourceProfile().getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)rp.id()), (Function0 & Serializable & scala.Serializable)() -> rp);
            return BoxesRunTime.unboxToInt((Object)$this.totalExpectedExecutorsPerResourceProfileId().put(BoxesRunTime.boxToInteger((int)rp.id()), BoxesRunTime.boxToInteger((int)numExecs)));
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ long $anonfun$onNewSnapshots$7(String x$6) {
        return new StringOps(Predef$.MODULE$.augmentString(x$6)).toLong();
    }

    public static final /* synthetic */ String $anonfun$onNewSnapshots$14(long x$9) {
        return Long.toString(x$9);
    }

    public static final /* synthetic */ void $anonfun$onNewSnapshots$16(HashMap rpIdToExecsAndPodState$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            long execId = tuple2._1$mcJ$sp();
            ExecutorPodState execPodState = (ExecutorPodState)tuple2._2();
            int rpId = new StringOps(Predef$.MODULE$.augmentString((String)execPodState.pod().getMetadata().getLabels().get(Constants$.MODULE$.SPARK_RESOURCE_PROFILE_ID_LABEL()))).toInt();
            HashMap execPods = (HashMap)rpIdToExecsAndPodState$1.getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)rpId), (Function0 & Serializable & scala.Serializable)() -> (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$));
            execPods.update((Object)BoxesRunTime.boxToLong((long)execId), (Object)execPodState);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$onNewSnapshots$21(ExecutorPodState x0$4) {
        ExecutorPodState executorPodState = x0$4;
        return executorPodState instanceof PodRunning;
    }

    public static final /* synthetic */ boolean $anonfun$onNewSnapshots$22(Tuple2 x0$5) {
        ExecutorPodState executorPodState;
        Tuple2 tuple2 = x0$5;
        return tuple2 != null && (executorPodState = (ExecutorPodState)tuple2._2()) instanceof PodPending;
    }

    public static final /* synthetic */ boolean $anonfun$onNewSnapshots$23(scala.collection.immutable.Set schedulerKnownExecs$1, Tuple2 x0$6) {
        Tuple2 tuple2 = x0$6;
        if (tuple2 != null) {
            long k = tuple2._1$mcJ$sp();
            return schedulerKnownExecs$1.contains((Object)BoxesRunTime.boxToLong((long)k));
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$onNewSnapshots$24(int rpId$1, Tuple2 x0$7) {
        Tuple2 tuple2;
        Tuple2 tuple22 = x0$7;
        if (tuple22 != null && (tuple2 = (Tuple2)tuple22._2()) != null) {
            int waitingRpId = tuple2._1$mcI$sp();
            return rpId$1 == waitingRpId;
        }
        throw new MatchError((Object)tuple22);
    }

    public static final /* synthetic */ boolean $anonfun$onNewSnapshots$25(int rpId$1, Tuple2 x0$8) {
        Tuple2 tuple2 = x0$8;
        if (tuple2 != null) {
            int waitingRpId = tuple2._2$mcI$sp();
            return rpId$1 == waitingRpId;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$onNewSnapshots$27(ExecutorPodsAllocator $this, long currentTime$1, Tuple2 x0$9) {
        Tuple2 tuple2;
        Tuple2 tuple22 = x0$9;
        if (tuple22 != null && (tuple2 = (Tuple2)tuple22._2()) != null) {
            long createTime = tuple2._2$mcJ$sp();
            return currentTime$1 - createTime > $this.executorIdleTimeout();
        }
        throw new MatchError((Object)tuple22);
    }

    public static final /* synthetic */ long $anonfun$onNewSnapshots$29(Tuple2 x0$10) {
        Tuple2 tuple2 = x0$10;
        if (tuple2 != null) {
            long id = tuple2._1$mcJ$sp();
            return id;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ String $anonfun$onNewSnapshots$32(long x$13) {
        return Long.toString(x$13);
    }

    public static final /* synthetic */ void $anonfun$onNewSnapshots$35(ExecutorPodsAllocator $this, String applicationId$2, Seq k8sKnownPVCNames$1, Tuple2 x0$11) {
        Tuple2 tuple2 = x0$11;
        if (tuple2 != null) {
            Tuple3 tuple3 = (Tuple3)tuple2._1();
            int sharedSlotFromPendingPods = tuple2._2$mcI$sp();
            if (tuple3 != null) {
                int rpId = BoxesRunTime.unboxToInt((Object)tuple3._1());
                int podCountForRpId = BoxesRunTime.unboxToInt((Object)tuple3._2());
                int targetNum = BoxesRunTime.unboxToInt((Object)tuple3._3());
                int numMissingPodsForRpId = targetNum - podCountForRpId;
                int numExecutorsToAllocate = package$.MODULE$.min(package$.MODULE$.min(numMissingPodsForRpId, $this.podAllocationSize()), sharedSlotFromPendingPods);
                $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(117).append("Going to request ").append(numExecutorsToAllocate).append(" executors from Kubernetes for ").append("ResourceProfile Id: ").append(rpId).append(", target: ").append(targetNum).append(", known: ").append(podCountForRpId).append(", ").append("sharedSlotFromPendingPods: ").append(sharedSlotFromPendingPods).append(".").toString());
                $this.requestNewExecutors(numExecutorsToAllocate, applicationId$2, rpId, (Seq<String>)k8sKnownPVCNames$1);
                return;
            }
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$getReusablePVCs$2(ExecutorPodsAllocator $this, long now$1, PersistentVolumeClaim pvc) {
        return now$1 - Instant.parse(pvc.getMetadata().getCreationTimestamp()).toEpochMilli() > $this.podAllocationDelay();
    }

    public static final /* synthetic */ boolean $anonfun$requestNewExecutors$2(HasMetadata x$14) {
        String string = x$14.getKind();
        String string2 = "PersistentVolumeClaim";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$replacePVCsIfNeeded$2(PersistentVolumeClaim x2$1, PersistentVolumeClaim p) {
        String string = p.getSpec().getStorageClassName();
        String string2 = x2$1.getSpec().getStorageClassName();
        return !(string != null ? !string.equals(string2) : string2 != null) && BoxesRunTime.equals(p.getSpec().getResources().getRequests().get("storage"), x2$1.getSpec().getResources().getRequests().get("storage"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$replacePVCsIfNeeded$3(PersistentVolumeClaim x2$1, Volume v) {
        if (v.getPersistentVolumeClaim() == null) return false;
        String string = v.getPersistentVolumeClaim().getClaimName();
        String string2 = x2$1.getMetadata().getName();
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    public static final /* synthetic */ void $anonfun$replacePVCsIfNeeded$1(ExecutorPodsAllocator $this, Buffer reusablePVCs$3, Pod pod$2, Set replacedResources$1, HasMetadata x0$1) {
        HasMetadata hasMetadata = x0$1;
        if (hasMetadata instanceof PersistentVolumeClaim) {
            PersistentVolumeClaim persistentVolumeClaim = (PersistentVolumeClaim)hasMetadata;
            int index = reusablePVCs$3.indexWhere((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsAllocator.$anonfun$replacePVCsIfNeeded$2(persistentVolumeClaim, p)));
            if (index >= 0) {
                Option volume = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pod$2.getSpec().getVolumes()).asScala()).find((Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsAllocator.$anonfun$replacePVCsIfNeeded$3(persistentVolumeClaim, v)));
                if (volume.nonEmpty()) {
                    PersistentVolumeClaim matchedPVC = (PersistentVolumeClaim)reusablePVCs$3.remove(index);
                    replacedResources$1.add((Object)persistentVolumeClaim);
                    $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Reuse PersistentVolumeClaim ").append(matchedPVC.getMetadata().getName()).toString());
                    ((Volume)volume.get()).getPersistentVolumeClaim().setClaimName(matchedPVC.getMetadata().getName());
                    return;
                }
                return;
            }
            return;
        }
    }

    public ExecutorPodsAllocator(SparkConf conf, SecurityManager secMgr, KubernetesExecutorBuilder executorBuilder, KubernetesClient kubernetesClient, ExecutorPodsSnapshotsStore snapshotsStore, Clock clock) {
        this.conf = conf;
        this.secMgr = secMgr;
        this.executorBuilder = executorBuilder;
        this.kubernetesClient = kubernetesClient;
        this.snapshotsStore = snapshotsStore;
        this.clock = clock;
        Logging.$init$((Logging)this);
        this.EXECUTOR_ID_COUNTER = new AtomicInteger(0);
        this.totalExpectedExecutorsPerResourceProfileId = new ConcurrentHashMap();
        this.rpIdToResourceProfile = new HashMap();
        this.podAllocationSize = BoxesRunTime.unboxToInt((Object)conf.get(Config$.MODULE$.KUBERNETES_ALLOCATION_BATCH_SIZE()));
        this.podAllocationDelay = BoxesRunTime.unboxToLong((Object)conf.get(Config$.MODULE$.KUBERNETES_ALLOCATION_BATCH_DELAY()));
        this.maxPendingPods = BoxesRunTime.unboxToInt((Object)conf.get(Config$.MODULE$.KUBERNETES_MAX_PENDING_PODS()));
        this.podCreationTimeout = package$.MODULE$.max(this.podAllocationDelay() * 5L, BoxesRunTime.unboxToLong((Object)conf.get(Config$.MODULE$.KUBERNETES_ALLOCATION_EXECUTOR_TIMEOUT())));
        this.driverPodReadinessTimeout = BoxesRunTime.unboxToLong((Object)conf.get(Config$.MODULE$.KUBERNETES_ALLOCATION_DRIVER_READINESS_TIMEOUT()));
        this.executorIdleTimeout = BoxesRunTime.unboxToLong((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.DYN_ALLOCATION_EXECUTOR_IDLE_TIMEOUT())) * 1000L;
        this.namespace = (String)conf.get(Config$.MODULE$.KUBERNETES_NAMESPACE());
        this.kubernetesDriverPodName = (Option)conf.get(Config$.MODULE$.KUBERNETES_DRIVER_POD_NAME());
        this.shouldDeleteExecutors = BoxesRunTime.unboxToBoolean((Object)conf.get(Config$.MODULE$.KUBERNETES_DELETE_EXECUTORS()));
        this.driverPod = this.kubernetesDriverPodName().map((Function1 & Serializable & scala.Serializable)name -> (Pod)Option$.MODULE$.apply(((Gettable)$this.kubernetesClient.pods().withName(name)).get()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new SparkException(new StringBuilder(99).append("No pod was found named ").append((String)name).append(" in the cluster in the ").append("namespace ").append(this.namespace()).append(" (this was supposed to be the driver pod.).").toString());
        }));
        this.newlyCreatedExecutors = LinkedHashMap$.MODULE$.empty();
        this.schedulerKnownNewlyCreatedExecs = LinkedHashMap$.MODULE$.empty();
        this.dynamicAllocationEnabled = Utils$.MODULE$.isDynamicAllocationEnabled(conf);
        this.numOutstandingPods = new AtomicInteger();
        this.lastSnapshot = ExecutorPodsSnapshot$.MODULE$.apply();
        this.deletedExecutorIds = Predef$.MODULE$.Set().empty();
    }
}

