/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.k8s;

import io.fabric8.kubernetes.api.model.ListOptionsBuilder;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.PodListBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.Listable;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import java.io.Serializable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.scheduler.cluster.k8s.ExecutorLifecycleTestUtils$;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsPollingSnapshotSource;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshotsStore;
import org.jmock.lib.concurrent.DeterministicScheduler;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfter;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Status;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005ud\u0001\u0002\u0010 \u00011BQa\u000e\u0001\u0005\u0002aBqa\u000f\u0001C\u0002\u0013%A\b\u0003\u0004A\u0001\u0001\u0006I!\u0010\u0005\b\u0003\u0002\u0011\r\u0011\"\u0003C\u0011\u0019I\u0005\u0001)A\u0005\u0007\"I!\n\u0001a\u0001\u0002\u0004%Ia\u0013\u0005\n1\u0002\u0001\r\u00111A\u0005\neC\u0011b\u0018\u0001A\u0002\u0003\u0005\u000b\u0015\u0002'\t\u0013\u001d\u0004\u0001\u0019!a\u0001\n\u0013A\u0007bCA\u0001\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u0007A!\"a\u0002\u0001\u0001\u0004\u0005\t\u0015)\u0003j\u0011-\tY\u0001\u0001a\u0001\u0002\u0004%I!!\u0004\t\u0017\u0005U\u0001\u00011AA\u0002\u0013%\u0011q\u0003\u0005\f\u00037\u0001\u0001\u0019!A!B\u0013\ty\u0001C\u0006\u0002 \u0001\u0001\r\u00111A\u0005\n\u00055\u0001bCA\u0011\u0001\u0001\u0007\t\u0019!C\u0005\u0003GA1\"a\n\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002\u0010!Y\u00111\u0006\u0001A\u0002\u0003\u0007I\u0011BA\u0007\u0011-\ti\u0003\u0001a\u0001\u0002\u0004%I!a\f\t\u0017\u0005M\u0002\u00011A\u0001B\u0003&\u0011q\u0002\u0005\f\u0003o\u0001\u0001\u0019!a\u0001\n\u0013\tI\u0004C\u0006\u0002B\u0001\u0001\r\u00111A\u0005\n\u0005\r\u0003bCA$\u0001\u0001\u0007\t\u0011)Q\u0005\u0003wA1\"a\u0013\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002N!Y\u00111\r\u0001A\u0002\u0003\u0007I\u0011BA3\u0011-\tI\u0007\u0001a\u0001\u0002\u0003\u0006K!a\u0014\t\u0017\u0005-\u0004\u00011AA\u0002\u0013%\u0011Q\u000e\u0005\f\u0003k\u0002\u0001\u0019!a\u0001\n\u0013\t9\bC\u0006\u0002|\u0001\u0001\r\u0011!Q!\n\u0005=$AJ#yK\u000e,Ho\u001c:Q_\u0012\u001c\bk\u001c7mS:<7K\\1qg\"|GoU8ve\u000e,7+^5uK*\u0011\u0001%I\u0001\u0004Wb\u001a(B\u0001\u0012$\u0003\u001d\u0019G.^:uKJT!\u0001J\u0013\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014(B\u0001\u0014(\u0003\u0015\u0019\b/\u0019:l\u0015\tA\u0013&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002U\u0005\u0019qN]4\u0004\u0001M\u0019\u0001!L\u0019\u0011\u00059zS\"A\u0013\n\u0005A*#!D*qCJ\\g)\u001e8Tk&$X\r\u0005\u00023k5\t1G\u0003\u00025S\u0005I1oY1mCR,7\u000f^\u0005\u0003mM\u0012aBQ3g_J,\u0017I\u001c3BMR,'/\u0001\u0004=S:LGO\u0010\u000b\u0002sA\u0011!\bA\u0007\u0002?\u0005I1\u000f]1sW\u000e{gNZ\u000b\u0002{A\u0011aFP\u0005\u0003\u007f\u0015\u0012\u0011b\u00159be.\u001cuN\u001c4\u0002\u0015M\u0004\u0018M]6D_:4\u0007%A\bq_2d\u0017N\\4J]R,'O^1m+\u0005\u0019\u0005C\u0001#H\u001b\u0005)%\"\u0001$\u0002\u000bM\u001c\u0017\r\\1\n\u0005!+%\u0001\u0002'p]\u001e\f\u0001\u0003]8mY&tw-\u00138uKJ4\u0018\r\u001c\u0011\u0002!-,(-\u001a:oKR,7o\u00117jK:$X#\u0001'\u0011\u000553V\"\u0001(\u000b\u0005=\u0003\u0016AB2mS\u0016tGO\u0003\u0002R%\u0006Q1.\u001e2fe:,G/Z:\u000b\u0005M#\u0016a\u00024bEJL7\r\u000f\u0006\u0002+\u0006\u0011\u0011n\\\u0005\u0003/:\u0013\u0001cS;cKJtW\r^3t\u00072LWM\u001c;\u0002)-,(-\u001a:oKR,7o\u00117jK:$x\fJ3r)\tQV\f\u0005\u0002E7&\u0011A,\u0012\u0002\u0005+:LG\u000fC\u0004_\u000f\u0005\u0005\t\u0019\u0001'\u0002\u0007a$\u0013'A\tlk\n,'O\\3uKN\u001cE.[3oi\u0002B#\u0001C1\u0011\u0005\t,W\"A2\u000b\u0005\u0011L\u0013aB7pG.LGo\\\u0005\u0003M\u000e\u0014A!T8dW\u0006i\u0001o\u001c3Pa\u0016\u0014\u0018\r^5p]N,\u0012!\u001b\t\u0003Uvt!a\u001b>\u000f\u00051DhBA7w\u001d\tqWO\u0004\u0002pi:\u0011\u0001o]\u0007\u0002c*\u0011!oK\u0001\u0007yI|w\u000e\u001e \n\u0003)J!\u0001K\u0015\n\u0005\u0019:\u0013BA<&\u0003\u0019!W\r\u001d7ps&\u0011\u0001%\u001f\u0006\u0003o\u0016J!a\u001f?\u0002\u001d\u0019\u000b'M]5dq\u0005c\u0017.Y:fg*\u0011\u0001%_\u0005\u0003}~\u0014A\u0001U(E'*\u00111\u0010`\u0001\u0012a>$w\n]3sCRLwN\\:`I\u0015\fHc\u0001.\u0002\u0006!9aLCA\u0001\u0002\u0004I\u0017A\u00049pI>\u0003XM]1uS>t7\u000f\t\u0015\u0003\u0017\u0005\f\u0001#\u00199q\u0013\u0012d\u0015MY3mK\u0012\u0004v\u000eZ:\u0016\u0005\u0005=\u0001c\u00016\u0002\u0012%\u0019\u00111C@\u0003\u00191\u000b%)\u0012'F\t~\u0003v\nR*\u0002)\u0005\u0004\b/\u00133MC\n,G.\u001a3Q_\u0012\u001cx\fJ3r)\rQ\u0016\u0011\u0004\u0005\t=6\t\t\u00111\u0001\u0002\u0010\u0005\t\u0012\r\u001d9JI2\u000b'-\u001a7fIB{Gm\u001d\u0011)\u00059\t\u0017aF3yK\u000e,Ho\u001c:S_2,G*\u00192fY\u0016$\u0007k\u001c3t\u0003m)\u00070Z2vi>\u0014(k\u001c7f\u0019\u0006\u0014W\r\\3e!>$7o\u0018\u0013fcR\u0019!,!\n\t\u0011y\u0003\u0012\u0011!a\u0001\u0003\u001f\t\u0001$\u001a=fGV$xN\u001d*pY\u0016d\u0015MY3mK\u0012\u0004v\u000eZ:!Q\t\t\u0012-\u0001\nbGRLg/Z#yK\u000e,Ho\u001c:Q_\u0012\u001c\u0018AF1di&4X-\u0012=fGV$xN\u001d)pIN|F%Z9\u0015\u0007i\u000b\t\u0004\u0003\u0005_'\u0005\u0005\t\u0019AA\b\u0003M\t7\r^5wK\u0016CXmY;u_J\u0004v\u000eZ:!Q\t!\u0012-\u0001\u0006fm\u0016tG/U;fk\u0016,\"!a\u000f\u0011\u0007i\ni$C\u0002\u0002@}\u0011!$\u0012=fGV$xN\u001d)pIN\u001cf.\u00199tQ>$8o\u0015;pe\u0016\fa\"\u001a<f]R\fV/Z;f?\u0012*\u0017\u000fF\u0002[\u0003\u000bB\u0001B\u0018\f\u0002\u0002\u0003\u0007\u00111H\u0001\fKZ,g\u000e^)vKV,\u0007\u0005\u000b\u0002\u0018C\u0006y\u0001o\u001c7mS:<W\t_3dkR|'/\u0006\u0002\u0002PA!\u0011\u0011KA0\u001b\t\t\u0019F\u0003\u0003\u0002V\u0005]\u0013AC2p]\u000e,(O]3oi*!\u0011\u0011LA.\u0003\ra\u0017N\u0019\u0006\u0004\u0003;J\u0013!\u00026n_\u000e\\\u0017\u0002BA1\u0003'\u0012a\u0003R3uKJl\u0017N\\5ti&\u001c7k\u00195fIVdWM]\u0001\u0014a>dG.\u001b8h\u000bb,7-\u001e;pe~#S-\u001d\u000b\u00045\u0006\u001d\u0004\u0002\u00030\u001a\u0003\u0003\u0005\r!a\u0014\u0002!A|G\u000e\\5oO\u0016CXmY;u_J\u0004\u0013A\u00069pY2LgnZ*pkJ\u001cW-\u00168eKJ$Vm\u001d;\u0016\u0005\u0005=\u0004c\u0001\u001e\u0002r%\u0019\u00111O\u0010\u0003C\u0015CXmY;u_J\u0004v\u000eZ:Q_2d\u0017N\\4T]\u0006\u00048\u000f[8u'>,(oY3\u00025A|G\u000e\\5oON{WO]2f+:$WM\u001d+fgR|F%Z9\u0015\u0007i\u000bI\b\u0003\u0005_9\u0005\u0005\t\u0019AA8\u0003]\u0001x\u000e\u001c7j]\u001e\u001cv.\u001e:dKVsG-\u001a:UKN$\b\u0005")
public class ExecutorPodsPollingSnapshotSourceSuite
extends SparkFunSuite
implements BeforeAndAfter {
    private final SparkConf sparkConf;
    private final long pollingInterval;
    @Mock
    private KubernetesClient kubernetesClient;
    @Mock
    private MixedOperation<Pod, PodList, PodResource<Pod>> podOperations;
    @Mock
    private FilterWatchListDeletable<Pod, PodList> appIdLabeledPods;
    @Mock
    private FilterWatchListDeletable<Pod, PodList> executorRoleLabeledPods;
    @Mock
    private FilterWatchListDeletable<Pod, PodList> activeExecutorPods;
    @Mock
    private ExecutorPodsSnapshotsStore eventQueue;
    private DeterministicScheduler pollingExecutor;
    private ExecutorPodsPollingSnapshotSource pollingSourceUnderTest;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return BeforeAndAfterEach.runTest$((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return BeforeAndAfterAll.run$((BeforeAndAfterAll)this, (Option)testName, (Args)args);
    }

    public void before(Function0<Object> fun, Position pos) {
        BeforeAndAfter.before$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public void after(Function0<Object> fun, Position pos) {
        BeforeAndAfter.after$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.runTest$((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.run$((BeforeAndAfter)this, testName, (Args)args);
    }

    public final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    private SparkConf sparkConf() {
        return this.sparkConf;
    }

    private long pollingInterval() {
        return this.pollingInterval;
    }

    private KubernetesClient kubernetesClient() {
        return this.kubernetesClient;
    }

    private void kubernetesClient_$eq(KubernetesClient x$1) {
        this.kubernetesClient = x$1;
    }

    private MixedOperation<Pod, PodList, PodResource<Pod>> podOperations() {
        return this.podOperations;
    }

    private void podOperations_$eq(MixedOperation<Pod, PodList, PodResource<Pod>> x$1) {
        this.podOperations = x$1;
    }

    private FilterWatchListDeletable<Pod, PodList> appIdLabeledPods() {
        return this.appIdLabeledPods;
    }

    private void appIdLabeledPods_$eq(FilterWatchListDeletable<Pod, PodList> x$1) {
        this.appIdLabeledPods = x$1;
    }

    private FilterWatchListDeletable<Pod, PodList> executorRoleLabeledPods() {
        return this.executorRoleLabeledPods;
    }

    private void executorRoleLabeledPods_$eq(FilterWatchListDeletable<Pod, PodList> x$1) {
        this.executorRoleLabeledPods = x$1;
    }

    private FilterWatchListDeletable<Pod, PodList> activeExecutorPods() {
        return this.activeExecutorPods;
    }

    private void activeExecutorPods_$eq(FilterWatchListDeletable<Pod, PodList> x$1) {
        this.activeExecutorPods = x$1;
    }

    private ExecutorPodsSnapshotsStore eventQueue() {
        return this.eventQueue;
    }

    private void eventQueue_$eq(ExecutorPodsSnapshotsStore x$1) {
        this.eventQueue = x$1;
    }

    private DeterministicScheduler pollingExecutor() {
        return this.pollingExecutor;
    }

    private void pollingExecutor_$eq(DeterministicScheduler x$1) {
        this.pollingExecutor = x$1;
    }

    private ExecutorPodsPollingSnapshotSource pollingSourceUnderTest() {
        return this.pollingSourceUnderTest;
    }

    private void pollingSourceUnderTest_$eq(ExecutorPodsPollingSnapshotSource x$1) {
        this.pollingSourceUnderTest = x$1;
    }

    public static final /* synthetic */ PodList $anonfun$new$4(ExecutorPodsPollingSnapshotSourceSuite $this, boolean value) {
        ExecutorPodsPollingSnapshotSource source = new ExecutorPodsPollingSnapshotSource($this.sparkConf().set(Config$.MODULE$.KUBERNETES_EXECUTOR_API_POLLING_WITH_RESOURCE_VERSION(), (Object)BoxesRunTime.boxToBoolean((boolean)value)), $this.kubernetesClient(), $this.eventQueue(), (ScheduledExecutorService)$this.pollingExecutor());
        $this.pollingExecutor().tick($this.pollingInterval(), TimeUnit.MILLISECONDS);
        if (value) {
            return (PodList)((Listable)Mockito.verify($this.activeExecutorPods())).list(((ListOptionsBuilder)new ListOptionsBuilder().withResourceVersion("0")).build());
        }
        return (PodList)((Listable)Mockito.verify($this.activeExecutorPods())).list();
    }

    public ExecutorPodsPollingSnapshotSourceSuite() {
        BeforeAndAfter.$init$((BeforeAndAfter)this);
        this.sparkConf = new SparkConf();
        this.pollingInterval = BoxesRunTime.unboxToLong((Object)this.sparkConf().get(Config$.MODULE$.KUBERNETES_EXECUTOR_API_POLLING_INTERVAL()));
        this.before((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            MockitoAnnotations.openMocks((Object)((Object)this)).close();
            this.pollingExecutor_$eq(new DeterministicScheduler());
            this.pollingSourceUnderTest_$eq(new ExecutorPodsPollingSnapshotSource(this.sparkConf(), this.kubernetesClient(), this.eventQueue(), (ScheduledExecutorService)this.pollingExecutor()));
            this.pollingSourceUnderTest().start(ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID());
            Mockito.when((Object)this.kubernetesClient().pods()).thenReturn(this.podOperations());
            Mockito.when((Object)this.podOperations().withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), ExecutorLifecycleTestUtils$.MODULE$.TEST_SPARK_APP_ID())).thenReturn(this.appIdLabeledPods());
            Mockito.when((Object)this.appIdLabeledPods().withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).thenReturn(this.executorRoleLabeledPods());
            return Mockito.when((Object)this.executorRoleLabeledPods().withoutLabel(Constants$.MODULE$.SPARK_EXECUTOR_INACTIVE_LABEL(), "true")).thenReturn(this.activeExecutorPods());
        }, new Position("ExecutorPodsPollingSnapshotSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
        this.test("Items returned by the API should be pushed to the event queue", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Pod exec1 = ExecutorLifecycleTestUtils$.MODULE$.runningExecutor(1L, ExecutorLifecycleTestUtils$.MODULE$.runningExecutor$default$2());
            Pod exec2 = ExecutorLifecycleTestUtils$.MODULE$.runningExecutor(2L, ExecutorLifecycleTestUtils$.MODULE$.runningExecutor$default$2());
            Mockito.when((Object)this.activeExecutorPods().list()).thenReturn((Object)((PodListBuilder)new PodListBuilder().addToItems(new Pod[]{exec1, exec2})).build());
            this.pollingExecutor().tick(this.pollingInterval(), TimeUnit.MILLISECONDS);
            ((ExecutorPodsSnapshotsStore)Mockito.verify((Object)this.eventQueue())).replaceSnapshot((Seq)new .colon.colon((Object)exec1, (List)new .colon.colon((Object)exec2, (List)Nil$.MODULE$)));
        }, new Position("ExecutorPodsPollingSnapshotSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
        this.test("SPARK-36334: Support pod listing with resource version", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, false}))).foreach((Function1 & Serializable & scala.Serializable)value -> ExecutorPodsPollingSnapshotSourceSuite.$anonfun$new$4(this, BoxesRunTime.unboxToBoolean((Object)value))), new Position("ExecutorPodsPollingSnapshotSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92));
    }
}

