/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.submit;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.ContainerFluentImpl;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KeyToPath;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodFluentImpl;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretBuilder;
import io.fabric8.kubernetes.api.model.SecretFluent;
import io.fabric8.kubernetes.api.model.VolumeFluent;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinition;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionBuilder;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionFluent;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.dsl.InOutCreateable;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.client.dsl.PodResource;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesDriverConf;
import org.apache.spark.deploy.k8s.KubernetesDriverSpec;
import org.apache.spark.deploy.k8s.KubernetesTestConf$;
import org.apache.spark.deploy.k8s.KubernetesVolumeSpec;
import org.apache.spark.deploy.k8s.SparkPod;
import org.apache.spark.deploy.k8s.submit.Client;
import org.apache.spark.deploy.k8s.submit.KubernetesClientUtils$;
import org.apache.spark.deploy.k8s.submit.KubernetesDriverBuilder;
import org.apache.spark.deploy.k8s.submit.LoggingPodStatusWatcher;
import org.apache.spark.deploy.k8s.submit.MainAppResource;
import org.apache.spark.util.Utils$;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.stubbing.Stubber;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfter;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Status;
import org.scalatest.Tag;
import org.scalatestplus.mockito.MockitoSugar$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\tMg\u0001\u0002#F\u0001ICQ!\u0018\u0001\u0005\u0002yCQ!\u0019\u0001\u0005\n\tDqa\u001d\u0001C\u0002\u0013%A\u000f\u0003\u0004~\u0001\u0001\u0006I!\u001e\u0005\b}\u0002\u0011\r\u0011\"\u0003u\u0011\u0019y\b\u0001)A\u0005k\"A\u0011\u0011\u0001\u0001C\u0002\u0013%A\u000fC\u0004\u0002\u0004\u0001\u0001\u000b\u0011B;\t\u0011\u0005\u0015\u0001A1A\u0005\nQDq!a\u0002\u0001A\u0003%Q\u000f\u0003\u0005\u0002\n\u0001\u0011\r\u0011\"\u0003u\u0011\u001d\tY\u0001\u0001Q\u0001\nUD\u0001\"!\u0004\u0001\u0005\u0004%I\u0001\u001e\u0005\b\u0003\u001f\u0001\u0001\u0015!\u0003v\u0011%\t\t\u0002\u0001b\u0001\n\u0013\t\u0019\u0002\u0003\u0005\u0002&\u0001\u0001\u000b\u0011BA\u000b\u0011%\t9\u0003\u0001b\u0001\n\u0013\tI\u0003\u0003\u0005\u0002H\u0001\u0001\u000b\u0011BA\u0016\u0011%\tI\u0005\u0001b\u0001\n\u0013\tY\u0005\u0003\u0005\u0002T\u0001\u0001\u000b\u0011BA'\u0011%\t)\u0006\u0001b\u0001\n\u0013\t9\u0006\u0003\u0005\u0002h\u0001\u0001\u000b\u0011BA-\u0011%\tI\u0007\u0001b\u0001\n\u0013\tY\u0007\u0003\u0005\u0002\u0000\u0001\u0001\u000b\u0011BA7\u0011%\t\t\t\u0001b\u0001\n\u0013\t\u0019\t\u0003\u0005\u0002\u000e\u0002\u0001\u000b\u0011BAC\u0011%\ty\t\u0001b\u0001\n\u0013\t\u0019\t\u0003\u0005\u0002\u0012\u0002\u0001\u000b\u0011BAC\u0011%\t\u0019\n\u0001b\u0001\n\u0013\tY\u0005\u0003\u0005\u0002\u0016\u0002\u0001\u000b\u0011BA'\u0011%\t9\n\u0001b\u0001\n\u0013\tI\n\u0003\u0005\u0002\"\u0002\u0001\u000b\u0011BAN\u0011\u001d\t\u0019\u000b\u0001C\u0005\u0003KC\u0011\"a1\u0001#\u0003%I!!2\t\u000f\u0005m\u0007\u0001\"\u0003\u0002^\"I\u0011\u0011\u001d\u0001\u0012\u0002\u0013%\u0011Q\u0019\u0005\n\u0003G\u0004!\u0019!C\u0005\u0003/B\u0001\"!:\u0001A\u0003%\u0011\u0011\f\u0005\n\u0003O\u0004!\u0019!C\u0005\u0003WB\u0001\"!;\u0001A\u0003%\u0011Q\u000e\u0005\f\u0003W\u0004\u0001\u0019!a\u0001\n\u0013\ti\u000fC\u0006\u0002|\u0002\u0001\r\u00111A\u0005\n\u0005u\bb\u0003B\u0005\u0001\u0001\u0007\t\u0011)Q\u0005\u0003_D1B!\u0006\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0003\u0018!Y!1\b\u0001A\u0002\u0003\u0007I\u0011\u0002B\u001f\u0011-\u0011\t\u0005\u0001a\u0001\u0002\u0003\u0006KA!\u0007\t\u0017\t\u0015\u0003\u00011AA\u0002\u0013%!q\t\u0005\f\u0005+\u0002\u0001\u0019!a\u0001\n\u0013\u00119\u0006C\u0006\u0003\\\u0001\u0001\r\u0011!Q!\n\t%\u0003b\u0003B0\u0001\u0001\u0007\t\u0019!C\u0005\u0005CB1B!\u001b\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0003l!Y!q\u000e\u0001A\u0002\u0003\u0005\u000b\u0015\u0002B2\u0011-\u0011\u0019\b\u0001a\u0001\u0002\u0004%IA!\u001e\t\u0017\tu\u0004\u00011AA\u0002\u0013%!q\u0010\u0005\f\u0005\u0007\u0003\u0001\u0019!A!B\u0013\u00119\bC\u0006\u0003\b\u0002\u0001\r\u00111A\u0005\n\t%\u0005b\u0003BI\u0001\u0001\u0007\t\u0019!C\u0005\u0005'C1Ba&\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0003\f\"Y!1\u0014\u0001A\u0002\u0003\u0007I\u0011\u0002BO\u0011-\u0011)\u000b\u0001a\u0001\u0002\u0004%IAa*\t\u0017\t-\u0006\u00011A\u0001B\u0003&!q\u0014\u0005\f\u0005[\u0003\u0001\u0019!a\u0001\n\u0013\u0011y\u000bC\u0006\u00038\u0002\u0001\r\u00111A\u0005\n\te\u0006b\u0003B_\u0001\u0001\u0007\t\u0011)Q\u0005\u0005cC1Ba0\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0003B\"Y!1\u001a\u0001A\u0002\u0003\u0007I\u0011\u0002Bg\u0011-\u0011\t\u000e\u0001a\u0001\u0002\u0003\u0006KAa1\u0003\u0017\rc\u0017.\u001a8u'VLG/\u001a\u0006\u0003\r\u001e\u000baa];c[&$(B\u0001%J\u0003\rY\u0007h\u001d\u0006\u0003\u0015.\u000ba\u0001Z3qY>L(B\u0001'N\u0003\u0015\u0019\b/\u0019:l\u0015\tqu*\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002!\u0006\u0019qN]4\u0004\u0001M\u0019\u0001aU,\u0011\u0005Q+V\"A&\n\u0005Y[%!D*qCJ\\g)\u001e8Tk&$X\r\u0005\u0002Y76\t\u0011L\u0003\u0002[\u001f\u0006I1oY1mCR,7\u000f^\u0005\u00039f\u0013aBQ3g_J,\u0017I\u001c3BMR,'/\u0001\u0004=S:LGO\u0010\u000b\u0002?B\u0011\u0001\rA\u0007\u0002\u000b\u0006AAm\u001c*fiV\u0014h\u000e\u0006\u0002dWB\u0011A-[\u0007\u0002K*\u0011amZ\u0001\tgR,(MY5oO*\u0011\u0001nT\u0001\b[>\u001c7.\u001b;p\u0013\tQWMA\u0004TiV\u0014'-\u001a:\t\u000b1\u0014\u0001\u0019A7\u0002\u000bY\fG.^3\u0011\u00059\fX\"A8\u000b\u0003A\fQa]2bY\u0006L!A]8\u0003\u0007\u0005s\u00170\u0001\bE%&3VIU0Q\u001f\u0012{V+\u0013#\u0016\u0003U\u0004\"A^>\u000e\u0003]T!\u0001_=\u0002\t1\fgn\u001a\u0006\u0002u\u0006!!.\u0019<b\u0013\taxO\u0001\u0004TiJLgnZ\u0001\u0010\tJKe+\u0012*`!>#u,V%EA\u00051BIU%W\u000bJ{\u0006k\u0014#`\u0003BKuLV#S'&{e*A\fE%&3VIU0Q\u001f\u0012{\u0016\tU%`-\u0016\u00136+S(OA\u0005yAIU%W\u000bJ{\u0006k\u0014#`\u0017&sE)\u0001\tE%&3VIU0Q\u001f\u0012{6*\u0013(EA\u0005Q2*\u0016\"F%:+E+R*`%\u0016\u001bv*\u0016*D\u000b~\u0003&+\u0012$J1\u0006Y2*\u0016\"F%:+E+R*`%\u0016\u001bv*\u0016*D\u000b~\u0003&+\u0012$J1\u0002\n\u0001\u0002U(E?:\u000bU*R\u0001\n!>#uLT!N\u000b\u0002\nabQ(O)\u0006Ke*\u0012*`\u001d\u0006kU)A\bD\u001f:#\u0016)\u0013(F%~s\u0015)T#!\u0003U\u0011ViU(M-\u0016#uLS!W\u0003~{\u0005\u000bV%P\u001dN+\"!!\u0006\u0011\r\u0005]\u0011\u0011E;v\u001b\t\tIB\u0003\u0003\u0002\u001c\u0005u\u0011!C5n[V$\u0018M\u00197f\u0015\r\tyb\\\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\u0012\u00033\u00111!T1q\u0003Y\u0011ViU(M-\u0016#uLS!W\u0003~{\u0005\u000bV%P\u001dN\u0003\u0013\u0001\u0005\"V\u00132#v\f\u0012*J-\u0016\u0013v\fU(E+\t\tY\u0003\u0005\u0003\u0002.\u0005\rSBAA\u0018\u0015\u0011\t\t$a\r\u0002\u000b5|G-\u001a7\u000b\t\u0005U\u0012qG\u0001\u0004CBL'\u0002BA\u001d\u0003w\t!b[;cKJtW\r^3t\u0015\u0011\ti$a\u0010\u0002\u000f\u0019\f'M]5dq)\u0011\u0011\u0011I\u0001\u0003S>LA!!\u0012\u00020\t\u0019\u0001k\u001c3\u0002#\t+\u0016\n\u0014+`\tJKe+\u0012*`!>#\u0005%\u0001\fC+&cEk\u0018#S\u0013Z+%kX\"P\u001dR\u000b\u0015JT#S+\t\ti\u0005\u0005\u0003\u0002.\u0005=\u0013\u0002BA)\u0003_\u0011\u0011bQ8oi\u0006Lg.\u001a:\u0002/\t+\u0016\n\u0014+`\tJKe+\u0012*`\u0007>sE+Q%O\u000bJ\u0003\u0013\u0001F!E\t&#\u0016j\u0014(B\u0019~\u0013ViU(V%\u000e+5+\u0006\u0002\u0002ZA1\u00111LA/\u0003Cj!!!\b\n\t\u0005}\u0013Q\u0004\u0002\u0004'\u0016\f\b\u0003BA\u0017\u0003GJA!!\u001a\u00020\t11+Z2sKR\fQ#\u0011#E\u0013RKuJT!M?J+5kT+S\u0007\u0016\u001b\u0006%A\u0007Q%\u0016{&+R*P+J\u001bUiU\u000b\u0003\u0003[\u0002b!a\u0017\u0002^\u0005=\u0004\u0003BA9\u0003wj!!a\u001d\u000b\t\u0005U\u0014qO\u0001\u0003mFRA!!\u001f\u00020\u0005i\u0011\r]5fqR,gn]5p]NLA!! \u0002t\tA2)^:u_6\u0014Vm]8ve\u000e,G)\u001a4j]&$\u0018n\u001c8\u0002\u001dA\u0013Vi\u0018*F'>+&kQ#TA\u0005)\")V%M)~[UKQ#S\u001d\u0016#ViU0T!\u0016\u001bUCAAC!\u0011\t9)!#\u000e\u0003\u001dK1!a#H\u0005QYUOY3s]\u0016$Xm\u001d#sSZ,'o\u00159fG\u00061\")V%M)~[UKQ#S\u001d\u0016#ViU0T!\u0016\u001b\u0005%A\u0011C+&cEkX&V\u0005\u0016\u0013f*\u0012+F'~\u001b\u0006+R\"`/&#\u0006j\u0018)S\u000bJ+5+\u0001\u0012C+&cEkX&V\u0005\u0016\u0013f*\u0012+F'~\u001b\u0006+R\"`/&#\u0006j\u0018)S\u000bJ+5\u000bI\u0001\u0018\rVcEjX#Y!\u0016\u001bE+\u0012#`\u0007>sE+Q%O\u000bJ\u000b\u0001DR+M\u0019~+\u0005\fU#D)\u0016#ulQ(O)\u0006Ke*\u0012*!\u0003-YU)W0U\u001f~\u0003\u0016\t\u0016%\u0016\u0005\u0005m\u0005\u0003BA\u0017\u0003;KA!a(\u00020\tI1*Z=U_B\u000bG\u000f[\u0001\r\u0017\u0016Kv\fV(`!\u0006#\u0006\nI\u0001\u0010MVdG.\u0012=qK\u000e$X\r\u001a)pIR!\u00111FAT\u0011%\tI+\tI\u0001\u0002\u0004\tY+\u0001\u0006lKf$v\u000eU1uQN\u0004b!!,\u0002>\u0006me\u0002BAX\u0003ssA!!-\u000286\u0011\u00111\u0017\u0006\u0004\u0003k\u000b\u0016A\u0002\u001fs_>$h(C\u0001q\u0013\r\tYl\\\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ty,!1\u0003\t1K7\u000f\u001e\u0006\u0004\u0003w{\u0017!\u00074vY2,\u0005\u0010]3di\u0016$\u0007k\u001c3%I\u00164\u0017-\u001e7uIE*\"!a2+\t\u0005-\u0016\u0011Z\u0016\u0003\u0003\u0017\u0004B!!4\u0002X6\u0011\u0011q\u001a\u0006\u0005\u0003#\f\u0019.A\u0005v]\u000eDWmY6fI*\u0019\u0011Q[8\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002Z\u0006='!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006)\u0002o\u001c3XSRDwj\u001e8feJ+g-\u001a:f]\u000e,G\u0003BA\u0016\u0003?D\u0011\"!+$!\u0003\u0005\r!a+\u0002?A|GmV5uQ>;h.\u001a:SK\u001a,'/\u001a8dK\u0012\"WMZ1vYR$\u0013'\u0001\u0016B\t\u0012KE+S(O\u00032{&+R*P+J\u001bUiU0X\u0013RCulT,O\u000bJ{&+\u0012$F%\u0016s5)R*\u0002W\u0005#E)\u0013+J\u001f:\u000bEj\u0018*F'>+&kQ#T?^KE\u000bS0P/:+%k\u0018*F\r\u0016\u0013VIT\"F'\u0002\na\u0006\u0015*F?\u0006#E)\u0013+J\u001f:\u000bEj\u0018*F'>+&kQ#T?^KE\u000bS0P/:+%k\u0018*F\r\u0016\u0013VIT\"F'\u0006y\u0003KU#`\u0003\u0012#\u0015\nV%P\u001d\u0006cuLU#T\u001fV\u00136)R*`/&#\u0006jX(X\u001d\u0016\u0013vLU#G\u000bJ+ejQ#TA\u0005\u00012.\u001e2fe:,G/Z:DY&,g\u000e^\u000b\u0003\u0003_\u0004B!!=\u0002x6\u0011\u00111\u001f\u0006\u0005\u0003k\f9$\u0001\u0004dY&,g\u000e^\u0005\u0005\u0003s\f\u0019P\u0001\tLk\n,'O\\3uKN\u001cE.[3oi\u0006!2.\u001e2fe:,G/Z:DY&,g\u000e^0%KF$B!a@\u0003\u0006A\u0019aN!\u0001\n\u0007\t\rqN\u0001\u0003V]&$\b\"\u0003B\u0004U\u0005\u0005\t\u0019AAx\u0003\rAH%M\u0001\u0012WV\u0014WM\u001d8fi\u0016\u001c8\t\\5f]R\u0004\u0003fA\u0016\u0003\u000eA!!q\u0002B\t\u001b\u00059\u0017b\u0001B\nO\n!Qj\\2l\u00035\u0001x\u000eZ(qKJ\fG/[8ogV\u0011!\u0011\u0004\t\u0005\u00057\u0011)D\u0004\u0003\u0003\u001e\tEb\u0002\u0002B\u0010\u0005_qAA!\t\u0003.9!!1\u0005B\u0016\u001d\u0011\u0011)C!\u000b\u000f\t\u0005E&qE\u0005\u0002!&\u0011ajT\u0005\u0003\u00196K!AS&\n\u0005!K\u0015b\u0001B\u001a\u000f\u0006qa)\u00192sS\u000eD\u0014\t\\5bg\u0016\u001c\u0018\u0002\u0002B\u001c\u0005s\u0011A\u0001U(E'*\u0019!1G$\u0002#A|Gm\u00149fe\u0006$\u0018n\u001c8t?\u0012*\u0017\u000f\u0006\u0003\u0002\u0000\n}\u0002\"\u0003B\u0004[\u0005\u0005\t\u0019\u0001B\r\u00039\u0001x\u000eZ(qKJ\fG/[8og\u0002B3A\fB\u0007\u0003%q\u0017-\\3e!>$7/\u0006\u0002\u0003JA1!1\nB)\u0003Wi!A!\u0014\u000b\t\t=\u00131_\u0001\u0004INd\u0017\u0002\u0002B*\u0005\u001b\u00121\u0002U8e%\u0016\u001cx.\u001e:dK\u0006ia.Y7fIB{Gm]0%KF$B!a@\u0003Z!I!q\u0001\u0019\u0002\u0002\u0003\u0007!\u0011J\u0001\u000b]\u0006lW\r\u001a)pIN\u0004\u0003fA\u0019\u0003\u000e\u00059Bn\\4hS:<\u0007k\u001c3Ti\u0006$Xo],bi\u000eDWM]\u000b\u0003\u0005G\u00022\u0001\u0019B3\u0013\r\u00119'\u0012\u0002\u0018\u0019><w-\u001b8h!>$7\u000b^1ukN<\u0016\r^2iKJ\f1\u0004\\8hO&tw\rU8e'R\fG/^:XCR\u001c\u0007.\u001a:`I\u0015\fH\u0003BA\u0000\u0005[B\u0011Ba\u00024\u0003\u0003\u0005\rAa\u0019\u000211|wmZ5oOB{Gm\u0015;biV\u001cx+\u0019;dQ\u0016\u0014\b\u0005K\u00025\u0005\u001b\tQ\u0002\u001a:jm\u0016\u0014()^5mI\u0016\u0014XC\u0001B<!\r\u0001'\u0011P\u0005\u0004\u0005w*%aF&vE\u0016\u0014h.\u001a;fg\u0012\u0013\u0018N^3s\u0005VLG\u000eZ3s\u0003E!'/\u001b<fe\n+\u0018\u000e\u001c3fe~#S-\u001d\u000b\u0005\u0003\u007f\u0014\t\tC\u0005\u0003\bY\n\t\u00111\u0001\u0003x\u0005qAM]5wKJ\u0014U/\u001b7eKJ\u0004\u0003fA\u001c\u0003\u000e\u0005a!/Z:pkJ\u001cW\rT5tiV\u0011!1\u0012\t\u0005\u00057\u0011i)\u0003\u0003\u0003\u0010\ne\"!\u0004*F'>+&kQ#`\u0019&\u001bF+\u0001\tsKN|WO]2f\u0019&\u001cHo\u0018\u0013fcR!\u0011q BK\u0011%\u00119!OA\u0001\u0002\u0004\u0011Y)A\u0007sKN|WO]2f\u0019&\u001cH\u000f\t\u0015\u0004u\t5\u0011!B6d_:4WC\u0001BP!\u0011\t9I!)\n\u0007\t\rvI\u0001\u000bLk\n,'O\\3uKN$%/\u001b<fe\u000e{gNZ\u0001\nW\u000e|gNZ0%KF$B!a@\u0003*\"I!q\u0001\u001f\u0002\u0002\u0003\u0007!qT\u0001\u0007W\u000e|gN\u001a\u0011\u00021\r\u0014X-\u0019;fIB{G-\u0011:hk6,g\u000e^\"baR|'/\u0006\u0002\u00032B1!q\u0002BZ\u0003WI1A!.h\u00059\t%oZ;nK:$8)\u00199u_J\fAd\u0019:fCR,G\rU8e\u0003J<W/\\3oi\u000e\u000b\u0007\u000f^8s?\u0012*\u0017\u000f\u0006\u0003\u0002\u0000\nm\u0006\"\u0003B\u0004\u007f\u0005\u0005\t\u0019\u0001BY\u0003e\u0019'/Z1uK\u0012\u0004v\u000eZ!sOVlWM\u001c;DCB$xN\u001d\u0011\u0002=\r\u0014X-\u0019;fIJ+7o\\;sG\u0016\u001c\u0018I]4v[\u0016tGoQ1qi>\u0014XC\u0001Bb!\u0019\u0011yAa-\u0003FB!\u0011Q\u0006Bd\u0013\u0011\u0011I-a\f\u0003\u0017!\u000b7/T3uC\u0012\fG/Y\u0001#GJ,\u0017\r^3e%\u0016\u001cx.\u001e:dKN\f%oZ;nK:$8)\u00199u_J|F%Z9\u0015\t\u0005}(q\u001a\u0005\n\u0005\u000f\u0011\u0015\u0011!a\u0001\u0005\u0007\fqd\u0019:fCR,GMU3t_V\u00148-Z:Be\u001e,X.\u001a8u\u0007\u0006\u0004Ho\u001c:!\u0001")
public class ClientSuite
extends SparkFunSuite
implements BeforeAndAfter {
    private final String DRIVER_POD_UID;
    private final String DRIVER_POD_API_VERSION;
    private final String DRIVER_POD_KIND;
    private final String KUBERNETES_RESOURCE_PREFIX;
    private final String POD_NAME;
    private final String CONTAINER_NAME;
    private final Map<String, String> RESOLVED_JAVA_OPTIONS;
    private final Pod BUILT_DRIVER_POD;
    private final Container BUILT_DRIVER_CONTAINER;
    private final Seq<Secret> ADDITIONAL_RESOURCES;
    private final Seq<CustomResourceDefinition> PRE_RESOURCES;
    private final KubernetesDriverSpec BUILT_KUBERNETES_SPEC;
    private final KubernetesDriverSpec BUILT_KUBERNETES_SPEC_WITH_PRERES;
    private final Container FULL_EXPECTED_CONTAINER;
    private final KeyToPath KEY_TO_PATH;
    private final Seq<Secret> ADDITIONAL_RESOURCES_WITH_OWNER_REFERENCES;
    private final Seq<CustomResourceDefinition> PRE_ADDITIONAL_RESOURCES_WITH_OWNER_REFERENCES;
    @Mock
    private KubernetesClient kubernetesClient;
    @Mock
    private MixedOperation<Pod, PodList, PodResource<Pod>> podOperations;
    @Mock
    private PodResource<Pod> namedPods;
    @Mock
    private LoggingPodStatusWatcher loggingPodStatusWatcher;
    @Mock
    private KubernetesDriverBuilder driverBuilder;
    @Mock
    private NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> resourceList;
    private KubernetesDriverConf kconf;
    private ArgumentCaptor<Pod> createdPodArgumentCaptor;
    private ArgumentCaptor<HasMetadata> createdResourcesArgumentCaptor;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return BeforeAndAfterEach.runTest$((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return BeforeAndAfterAll.run$((BeforeAndAfterAll)this, (Option)testName, (Args)args);
    }

    public void before(Function0<Object> fun, Position pos) {
        BeforeAndAfter.before$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public void after(Function0<Object> fun, Position pos) {
        BeforeAndAfter.after$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.runTest$((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.run$((BeforeAndAfter)this, testName, (Args)args);
    }

    public final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    private Stubber doReturn(Object value) {
        return Mockito.doReturn((Object)value, (Object[])ScalaRunTime$.MODULE$.toObjectArray(((TraversableOnce)Nil$.MODULE$).toArray(ClassTag$.MODULE$.Any())));
    }

    private String DRIVER_POD_UID() {
        return this.DRIVER_POD_UID;
    }

    private String DRIVER_POD_API_VERSION() {
        return this.DRIVER_POD_API_VERSION;
    }

    private String DRIVER_POD_KIND() {
        return this.DRIVER_POD_KIND;
    }

    private String KUBERNETES_RESOURCE_PREFIX() {
        return this.KUBERNETES_RESOURCE_PREFIX;
    }

    private String POD_NAME() {
        return this.POD_NAME;
    }

    private String CONTAINER_NAME() {
        return this.CONTAINER_NAME;
    }

    private Map<String, String> RESOLVED_JAVA_OPTIONS() {
        return this.RESOLVED_JAVA_OPTIONS;
    }

    private Pod BUILT_DRIVER_POD() {
        return this.BUILT_DRIVER_POD;
    }

    private Container BUILT_DRIVER_CONTAINER() {
        return this.BUILT_DRIVER_CONTAINER;
    }

    private Seq<Secret> ADDITIONAL_RESOURCES() {
        return this.ADDITIONAL_RESOURCES;
    }

    private Seq<CustomResourceDefinition> PRE_RESOURCES() {
        return this.PRE_RESOURCES;
    }

    private KubernetesDriverSpec BUILT_KUBERNETES_SPEC() {
        return this.BUILT_KUBERNETES_SPEC;
    }

    private KubernetesDriverSpec BUILT_KUBERNETES_SPEC_WITH_PRERES() {
        return this.BUILT_KUBERNETES_SPEC_WITH_PRERES;
    }

    private Container FULL_EXPECTED_CONTAINER() {
        return this.FULL_EXPECTED_CONTAINER;
    }

    private KeyToPath KEY_TO_PATH() {
        return this.KEY_TO_PATH;
    }

    private Pod fullExpectedPod(List<KeyToPath> keyToPaths) {
        return ((PodBuilder)((PodFluent.SpecNested)((PodSpecFluent.VolumesNested)((VolumeFluent.ConfigMapNested)new PodBuilder(this.BUILT_DRIVER_POD()).editSpec().addToContainers(new Container[]{this.FULL_EXPECTED_CONTAINER()}).addNewVolume().withName(Constants$.MODULE$.SPARK_CONF_VOLUME_DRIVER()).withNewConfigMap().withItems((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(keyToPaths).asJava()).withName(KubernetesClientUtils$.MODULE$.configMapNameDriver())).endConfigMap()).endVolume()).endSpec()).build();
    }

    private List<KeyToPath> fullExpectedPod$default$1() {
        return new .colon.colon((Object)this.KEY_TO_PATH(), (List)Nil$.MODULE$);
    }

    private Pod podWithOwnerReference(List<KeyToPath> keyToPaths) {
        return ((PodBuilder)((PodFluentImpl)((PodFluentImpl)((PodFluent.MetadataNested)new PodBuilder(this.fullExpectedPod(keyToPaths)).editMetadata().withUid(this.DRIVER_POD_UID())).endMetadata()).withApiVersion(this.DRIVER_POD_API_VERSION())).withKind(this.DRIVER_POD_KIND())).build();
    }

    private List<KeyToPath> podWithOwnerReference$default$1() {
        return new .colon.colon((Object)this.KEY_TO_PATH(), (List)Nil$.MODULE$);
    }

    private Seq<Secret> ADDITIONAL_RESOURCES_WITH_OWNER_REFERENCES() {
        return this.ADDITIONAL_RESOURCES_WITH_OWNER_REFERENCES;
    }

    private Seq<CustomResourceDefinition> PRE_ADDITIONAL_RESOURCES_WITH_OWNER_REFERENCES() {
        return this.PRE_ADDITIONAL_RESOURCES_WITH_OWNER_REFERENCES;
    }

    private KubernetesClient kubernetesClient() {
        return this.kubernetesClient;
    }

    private void kubernetesClient_$eq(KubernetesClient x$1) {
        this.kubernetesClient = x$1;
    }

    private MixedOperation<Pod, PodList, PodResource<Pod>> podOperations() {
        return this.podOperations;
    }

    private void podOperations_$eq(MixedOperation<Pod, PodList, PodResource<Pod>> x$1) {
        this.podOperations = x$1;
    }

    private PodResource<Pod> namedPods() {
        return this.namedPods;
    }

    private void namedPods_$eq(PodResource<Pod> x$1) {
        this.namedPods = x$1;
    }

    private LoggingPodStatusWatcher loggingPodStatusWatcher() {
        return this.loggingPodStatusWatcher;
    }

    private void loggingPodStatusWatcher_$eq(LoggingPodStatusWatcher x$1) {
        this.loggingPodStatusWatcher = x$1;
    }

    private KubernetesDriverBuilder driverBuilder() {
        return this.driverBuilder;
    }

    private void driverBuilder_$eq(KubernetesDriverBuilder x$1) {
        this.driverBuilder = x$1;
    }

    private NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> resourceList() {
        return this.resourceList;
    }

    private void resourceList_$eq(NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> x$1) {
        this.resourceList = x$1;
    }

    private KubernetesDriverConf kconf() {
        return this.kconf;
    }

    private void kconf_$eq(KubernetesDriverConf x$1) {
        this.kconf = x$1;
    }

    private ArgumentCaptor<Pod> createdPodArgumentCaptor() {
        return this.createdPodArgumentCaptor;
    }

    private void createdPodArgumentCaptor_$eq(ArgumentCaptor<Pod> x$1) {
        this.createdPodArgumentCaptor = x$1;
    }

    private ArgumentCaptor<HasMetadata> createdResourcesArgumentCaptor() {
        return this.createdResourcesArgumentCaptor;
    }

    private void createdResourcesArgumentCaptor_$eq(ArgumentCaptor<HasMetadata> x$1) {
        this.createdResourcesArgumentCaptor = x$1;
    }

    public static final /* synthetic */ boolean $anonfun$new$4(Object x$1) {
        return x$1 instanceof Secret;
    }

    public static final /* synthetic */ boolean $anonfun$new$5(Object x$2) {
        return x$2 instanceof ConfigMap;
    }

    public static final /* synthetic */ boolean $anonfun$new$8(Object x$4) {
        return x$4 instanceof CustomResourceDefinition;
    }

    public static final /* synthetic */ boolean $anonfun$new$9(Object x$5) {
        return x$5 instanceof Secret;
    }

    public static final /* synthetic */ boolean $anonfun$new$10(Object x$6) {
        return x$6 instanceof ConfigMap;
    }

    public static final /* synthetic */ String $anonfun$new$13(int i) {
        return new StringBuilder(9).append("testConf.").append(i).toString();
    }

    private static final Tuple2 testSetup$1() {
        File tempDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
        SparkConf sparkConf = new SparkConf(false).setSparkHome(tempDir.getAbsolutePath());
        File tempConfDir = new File(new StringBuilder(5).append(tempDir.getAbsolutePath()).append("/conf").toString());
        tempConfDir.mkdir();
        Set filteredConfFileNames = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"spark-env.sh.template", "spark.properties", "spark-defaults.conf", "test.gz", "test2.jar", "non_utf8.txt"}));
        IndexedSeq confFileNames = (IndexedSeq)((TraversableLike)((TraversableLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 5).map((Function1 & Serializable & scala.Serializable)i -> ClientSuite.$anonfun$new$13(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)new .colon.colon((Object)"spark-env.sh", (List)Nil$.MODULE$), IndexedSeq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)filteredConfFileNames, IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq testConfFiles = (IndexedSeq)confFileNames.map((Function1 & Serializable & scala.Serializable)i -> {
            File file = new File(new StringBuilder(1).append(tempConfDir.getAbsolutePath()).append("/").append((String)i).toString());
            Path path = i.startsWith("non_utf8") ? Files.write(file.toPath(), (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{(byte)0, (byte)161}), ClassTag$.MODULE$.Byte()), new OpenOption[0]) : Files.write(file.toPath(), "conf1key=conf1value".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            return file.getName();
        }, IndexedSeq$.MODULE$.canBuildFrom());
        File[] $org_scalatest_assert_macro_left = tempConfDir.listFiles();
        int $org_scalatest_assert_macro_right = confFileNames.length();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 291));
        Seq expectedConfFiles = (Seq)testConfFiles.filterNot((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)filteredConfFileNames.contains((Object)elem)));
        return new Tuple2((Object)sparkConf, (Object)expectedConfFiles);
    }

    public static final /* synthetic */ boolean $anonfun$new$18(Object x$9) {
        return x$9 instanceof ConfigMap;
    }

    public ClientSuite() {
        BeforeAndAfter.$init$((BeforeAndAfter)this);
        this.DRIVER_POD_UID = "pod-id";
        this.DRIVER_POD_API_VERSION = "v1";
        this.DRIVER_POD_KIND = "pod";
        this.KUBERNETES_RESOURCE_PREFIX = "resource-example";
        this.POD_NAME = "driver";
        this.CONTAINER_NAME = "container";
        this.RESOLVED_JAVA_OPTIONS = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"conf1key"), (Object)"conf1value"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"conf2key"), (Object)"conf2value")}));
        this.BUILT_DRIVER_POD = ((PodBuilder)((PodFluent.SpecNested)((PodFluentImpl)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName(this.POD_NAME())).endMetadata()).withNewSpec().withHostname("localhost")).endSpec()).build();
        this.BUILT_DRIVER_CONTAINER = ((ContainerBuilder)new ContainerBuilder().withName(this.CONTAINER_NAME())).build();
        this.ADDITIONAL_RESOURCES = (Seq)new .colon.colon((Object)((SecretBuilder)((SecretFluent.MetadataNested)new SecretBuilder().withNewMetadata().withName("secret")).endMetadata()).build(), (List)Nil$.MODULE$);
        this.PRE_RESOURCES = (Seq)new .colon.colon((Object)((CustomResourceDefinitionBuilder)((CustomResourceDefinitionFluent.MetadataNested)new CustomResourceDefinitionBuilder().withNewMetadata().withName("preCRD")).endMetadata()).build(), (List)Nil$.MODULE$);
        this.BUILT_KUBERNETES_SPEC = new KubernetesDriverSpec(new SparkPod(this.BUILT_DRIVER_POD(), this.BUILT_DRIVER_CONTAINER()), (Seq)Nil$.MODULE$, this.ADDITIONAL_RESOURCES(), this.RESOLVED_JAVA_OPTIONS());
        this.BUILT_KUBERNETES_SPEC_WITH_PRERES = new KubernetesDriverSpec(new SparkPod(this.BUILT_DRIVER_POD(), this.BUILT_DRIVER_CONTAINER()), this.PRE_RESOURCES(), this.ADDITIONAL_RESOURCES(), this.RESOLVED_JAVA_OPTIONS());
        this.FULL_EXPECTED_CONTAINER = ((ContainerBuilder)((ContainerFluent.VolumeMountsNested)((ContainerFluentImpl)((ContainerFluent.EnvNested)new ContainerBuilder(this.BUILT_DRIVER_CONTAINER()).addNewEnv().withName(Constants$.MODULE$.ENV_SPARK_CONF_DIR()).withValue(Constants$.MODULE$.SPARK_CONF_DIR_INTERNAL())).endEnv()).addNewVolumeMount().withName(Constants$.MODULE$.SPARK_CONF_VOLUME_DRIVER()).withMountPath(Constants$.MODULE$.SPARK_CONF_DIR_INTERNAL())).endVolumeMount()).build();
        this.KEY_TO_PATH = new KeyToPath(Constants$.MODULE$.SPARK_CONF_FILE_NAME(), Predef$.MODULE$.int2Integer(420), Constants$.MODULE$.SPARK_CONF_FILE_NAME());
        this.ADDITIONAL_RESOURCES_WITH_OWNER_REFERENCES = (Seq)this.ADDITIONAL_RESOURCES().map((Function1 & Serializable & scala.Serializable)secret -> ((SecretBuilder)((SecretFluent.MetadataNested)((ObjectMetaFluent.OwnerReferencesNested)new SecretBuilder(secret).editMetadata().addNewOwnerReference().withName(this.POD_NAME()).withApiVersion(this.DRIVER_POD_API_VERSION()).withKind(this.DRIVER_POD_KIND()).withController(Predef$.MODULE$.boolean2Boolean(true)).withUid(this.DRIVER_POD_UID())).endOwnerReference()).endMetadata()).build(), Seq$.MODULE$.canBuildFrom());
        this.PRE_ADDITIONAL_RESOURCES_WITH_OWNER_REFERENCES = (Seq)this.PRE_RESOURCES().map((Function1 & Serializable & scala.Serializable)crd -> ((CustomResourceDefinitionBuilder)((CustomResourceDefinitionFluent.MetadataNested)((ObjectMetaFluent.OwnerReferencesNested)new CustomResourceDefinitionBuilder(crd).editMetadata().addNewOwnerReference().withName(this.POD_NAME()).withApiVersion(this.DRIVER_POD_API_VERSION()).withKind(this.DRIVER_POD_KIND()).withController(Predef$.MODULE$.boolean2Boolean(true)).withUid(this.DRIVER_POD_UID())).endOwnerReference()).endMetadata()).build(), Seq$.MODULE$.canBuildFrom());
        this.before((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            MockitoAnnotations.openMocks((Object)((Object)this)).close();
            Some x$1 = new Some((Object)this.KUBERNETES_RESOURCE_PREFIX());
            SparkConf x$2 = KubernetesTestConf$.MODULE$.createDriverConf$default$1();
            String x$3 = KubernetesTestConf$.MODULE$.createDriverConf$default$2();
            MainAppResource x$4 = KubernetesTestConf$.MODULE$.createDriverConf$default$3();
            String x$5 = KubernetesTestConf$.MODULE$.createDriverConf$default$4();
            String[] x$6 = KubernetesTestConf$.MODULE$.createDriverConf$default$5();
            Map<String, String> x$7 = KubernetesTestConf$.MODULE$.createDriverConf$default$7();
            Map<String, String> x$8 = KubernetesTestConf$.MODULE$.createDriverConf$default$8();
            Map<String, String> x$9 = KubernetesTestConf$.MODULE$.createDriverConf$default$9();
            Map<String, String> x$10 = KubernetesTestConf$.MODULE$.createDriverConf$default$10();
            Map<String, String> x$11 = KubernetesTestConf$.MODULE$.createDriverConf$default$11();
            Map<String, String> x$12 = KubernetesTestConf$.MODULE$.createDriverConf$default$12();
            Seq<KubernetesVolumeSpec> x$13 = KubernetesTestConf$.MODULE$.createDriverConf$default$13();
            Option<String> x$14 = KubernetesTestConf$.MODULE$.createDriverConf$default$14();
            this.kconf_$eq(KubernetesTestConf$.MODULE$.createDriverConf(x$2, x$3, x$4, x$5, x$6, (Option<String>)x$1, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14));
            Mockito.when((Object)this.driverBuilder().buildFromFeatures(this.kconf(), this.kubernetesClient())).thenReturn((Object)this.BUILT_KUBERNETES_SPEC());
            Mockito.when((Object)this.kubernetesClient().pods()).thenReturn(this.podOperations());
            Mockito.when((Object)this.podOperations().withName(this.POD_NAME())).thenReturn(this.namedPods());
            this.createdPodArgumentCaptor_$eq((ArgumentCaptor<Pod>)ArgumentCaptor.forClass(Pod.class));
            this.createdResourcesArgumentCaptor_$eq((ArgumentCaptor<HasMetadata>)ArgumentCaptor.forClass(HasMetadata.class));
            Mockito.when((Object)this.podOperations().create((Object)this.fullExpectedPod(this.fullExpectedPod$default$1()))).thenReturn((Object)this.podWithOwnerReference(this.podWithOwnerReference$default$1()));
            Mockito.when((Object)this.namedPods().watch((Object)this.loggingPodStatusWatcher())).thenReturn(MockitoSugar$.MODULE$.mock(ClassTag$.MODULE$.apply(Watch.class)));
            Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.loggingPodStatusWatcher().watchOrStop(new StringBuilder(1).append(this.kconf().namespace()).append(":").append(this.POD_NAME()).toString()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
            return ((KubernetesClient)this.doReturn(this.resourceList()).when((Object)this.kubernetesClient())).resourceList(new HasMetadata[]{(HasMetadata)this.createdResourcesArgumentCaptor().capture()});
        }, new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 167));
        this.test("The client should configure the pod using the builder.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Client submissionClient = new Client(this.kconf(), this.driverBuilder(), this.kubernetesClient(), this.loggingPodStatusWatcher());
            submissionClient.run();
            return (Pod)((InOutCreateable)Mockito.verify(this.podOperations())).create((Object)this.fullExpectedPod(this.fullExpectedPod$default$1()));
        }, new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 185));
        this.test("The client should create Kubernetes resources", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Client submissionClient = new Client(this.kconf(), this.driverBuilder(), this.kubernetesClient(), this.loggingPodStatusWatcher());
            submissionClient.run();
            java.util.List otherCreatedResources = this.createdResourcesArgumentCaptor().getAllValues();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)otherCreatedResources.size()));
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 203));
            Seq secrets = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(otherCreatedResources.toArray())).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ClientSuite.$anonfun$new$4(x$1))))).toSeq();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(secrets);
            Seq<Secret> $org_scalatest_assert_macro_right2 = this.ADDITIONAL_RESOURCES_WITH_OWNER_REFERENCES();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", $org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq($org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 205));
            ConfigMap[] configMaps = (ConfigMap[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(otherCreatedResources.toArray())).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ClientSuite.$anonfun$new$5(x$2))))).map((Function1 & Serializable & scala.Serializable)x$3 -> (ConfigMap)x$3, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ConfigMap.class)));
            Seq $org_scalatest_assert_macro_left3 = secrets;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "nonEmpty", $org_scalatest_assert_macro_left3.nonEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 208));
            Object[] $org_scalatest_assert_macro_left4 = Predef$.MODULE$.refArrayOps((Object[])configMaps);
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left4), "nonEmpty", new ArrayOps.ofRef($org_scalatest_assert_macro_left4).nonEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 209));
            ConfigMap configMap = (ConfigMap)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])configMaps)).head();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(configMap.getMetadata().getName());
            String $org_scalatest_assert_macro_right3 = KubernetesClientUtils$.MODULE$.configMapNameDriver();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 211));
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.Boolean2boolean(configMap.getImmutable()), "scala.Predef.Boolean2boolean(configMap.getImmutable())", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 213));
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(configMap.getData().containsKey(Constants$.MODULE$.SPARK_CONF_FILE_NAME()), "configMap.getData().containsKey(org.apache.spark.deploy.k8s.Constants.SPARK_CONF_FILE_NAME)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 214));
            String $org_scalatest_assert_macro_left6 = (String)configMap.getData().get(Constants$.MODULE$.SPARK_CONF_FILE_NAME());
            String $org_scalatest_assert_macro_right4 = "conf1key=conf1value";
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "contains", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left6.contains($org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 215));
            String $org_scalatest_assert_macro_left7 = (String)configMap.getData().get(Constants$.MODULE$.SPARK_CONF_FILE_NAME());
            String $org_scalatest_assert_macro_right5 = "conf2key=conf2value";
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "contains", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left7.contains($org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 216));
        }, new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 195));
        this.test("SPARK-37331: The client should create Kubernetes resources with pre resources", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparkConf sparkConf;
            SparkConf x$15 = sparkConf = new SparkConf(false).set(Config$.MODULE$.CONTAINER_IMAGE(), (Object)"spark-executor:latest").set(Config$.MODULE$.KUBERNETES_DRIVER_POD_FEATURE_STEPS().key(), "org.apache.spark.deploy.k8s.TestStepTwo,org.apache.spark.deploy.k8s.TestStep");
            Some x$16 = new Some((Object)this.KUBERNETES_RESOURCE_PREFIX());
            String x$17 = KubernetesTestConf$.MODULE$.createDriverConf$default$2();
            MainAppResource x$18 = KubernetesTestConf$.MODULE$.createDriverConf$default$3();
            String x$19 = KubernetesTestConf$.MODULE$.createDriverConf$default$4();
            String[] x$20 = KubernetesTestConf$.MODULE$.createDriverConf$default$5();
            Map<String, String> x$21 = KubernetesTestConf$.MODULE$.createDriverConf$default$7();
            Map<String, String> x$22 = KubernetesTestConf$.MODULE$.createDriverConf$default$8();
            Map<String, String> x$23 = KubernetesTestConf$.MODULE$.createDriverConf$default$9();
            Map<String, String> x$24 = KubernetesTestConf$.MODULE$.createDriverConf$default$10();
            Map<String, String> x$25 = KubernetesTestConf$.MODULE$.createDriverConf$default$11();
            Map<String, String> x$26 = KubernetesTestConf$.MODULE$.createDriverConf$default$12();
            Seq<KubernetesVolumeSpec> x$27 = KubernetesTestConf$.MODULE$.createDriverConf$default$13();
            Option<String> x$28 = KubernetesTestConf$.MODULE$.createDriverConf$default$14();
            KubernetesDriverConf preResKconf = KubernetesTestConf$.MODULE$.createDriverConf(x$15, x$17, x$18, x$19, x$20, (Option<String>)x$16, x$21, x$22, x$23, x$24, x$25, x$26, x$27, x$28);
            Mockito.when((Object)this.driverBuilder().buildFromFeatures(preResKconf, this.kubernetesClient())).thenReturn((Object)this.BUILT_KUBERNETES_SPEC_WITH_PRERES());
            Client submissionClient = new Client(preResKconf, this.driverBuilder(), this.kubernetesClient(), this.loggingPodStatusWatcher());
            submissionClient.run();
            java.util.List otherCreatedResources = this.createdResourcesArgumentCaptor().getAllValues();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)otherCreatedResources.size()));
            int $org_scalatest_assert_macro_right = 4;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 241));
            Seq preRes = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(otherCreatedResources.toArray())).filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ClientSuite.$anonfun$new$8(x$4))))).toSeq();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)preRes.size()));
            int $org_scalatest_assert_macro_right2 = 2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 246));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(preRes.last());
            CustomResourceDefinition $org_scalatest_assert_macro_right3 = (CustomResourceDefinition)this.PRE_ADDITIONAL_RESOURCES_WITH_OWNER_REFERENCES().head();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 247));
            Seq secrets = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(otherCreatedResources.toArray())).filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ClientSuite.$anonfun$new$9(x$5))))).toSeq();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(secrets);
            Seq<Secret> $org_scalatest_assert_macro_right4 = this.ADDITIONAL_RESOURCES_WITH_OWNER_REFERENCES();
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", $org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq($org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 251));
            ConfigMap[] configMaps = (ConfigMap[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(otherCreatedResources.toArray())).filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ClientSuite.$anonfun$new$10(x$6))))).map((Function1 & Serializable & scala.Serializable)x$7 -> (ConfigMap)x$7, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ConfigMap.class)));
            Seq $org_scalatest_assert_macro_left5 = secrets;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left5, "nonEmpty", $org_scalatest_assert_macro_left5.nonEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 254));
            Object[] $org_scalatest_assert_macro_left6 = Predef$.MODULE$.refArrayOps((Object[])configMaps);
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left6), "nonEmpty", new ArrayOps.ofRef($org_scalatest_assert_macro_left6).nonEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 255));
            ConfigMap configMap = (ConfigMap)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])configMaps)).head();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(configMap.getMetadata().getName());
            String $org_scalatest_assert_macro_right5 = KubernetesClientUtils$.MODULE$.configMapNameDriver();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 257));
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.Boolean2boolean(configMap.getImmutable()), "scala.Predef.Boolean2boolean(configMap.getImmutable())", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 259));
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.simpleMacroBool(configMap.getData().containsKey(Constants$.MODULE$.SPARK_CONF_FILE_NAME()), "configMap.getData().containsKey(org.apache.spark.deploy.k8s.Constants.SPARK_CONF_FILE_NAME)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 260));
            String $org_scalatest_assert_macro_left8 = (String)configMap.getData().get(Constants$.MODULE$.SPARK_CONF_FILE_NAME());
            String $org_scalatest_assert_macro_right6 = "conf1key=conf1value";
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "contains", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left8.contains($org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 261));
            String $org_scalatest_assert_macro_left9 = (String)configMap.getData().get(Constants$.MODULE$.SPARK_CONF_FILE_NAME());
            String $org_scalatest_assert_macro_right7 = "conf2key=conf2value";
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "contains", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left9.contains($org_scalatest_assert_macro_right7), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 262));
        }, new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 219));
        this.test("All files from SPARK_CONF_DIR, except templates, spark config, binary files and are within size limit, should be populated to pod's configMap.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SparkConf sparkConf;
            Seq expectedConfFiles;
            block3: {
                Tuple2 tuple2;
                block2: {
                    tuple2 = ClientSuite.testSetup$1();
                    if (tuple2 == null) break block2;
                    SparkConf sparkConf2 = (SparkConf)tuple2._1();
                    expectedConfFiles = (Seq)tuple2._2();
                    if (sparkConf2 == null) break block2;
                    sparkConf = sparkConf2;
                    if (expectedConfFiles != null) break block3;
                }
                throw new MatchError((Object)tuple2);
            }
            Seq seq = expectedConfFiles;
            Tuple2 tuple2 = new Tuple2((Object)sparkConf, (Object)seq);
            SparkConf sparkConf3 = (SparkConf)tuple2._1();
            Seq expectedConfFiles2 = (Seq)tuple2._2();
            List expectedKeyToPaths = (List)((SeqLike)((TraversableOnce)expectedConfFiles2.map((Function1 & Serializable & scala.Serializable)x -> new KeyToPath(x, Predef$.MODULE$.int2Integer(420), x), Seq$.MODULE$.canBuildFrom())).toList().$plus$plus((GenTraversableOnce)new .colon.colon((Object)this.KEY_TO_PATH(), (List)Nil$.MODULE$), List$.MODULE$.canBuildFrom())).sortBy((Function1 & Serializable & scala.Serializable)x -> x.getKey(), (Ordering)Ordering.String$.MODULE$);
            Mockito.when((Object)this.podOperations().create((Object)this.fullExpectedPod((List<KeyToPath>)expectedKeyToPaths))).thenReturn((Object)this.podWithOwnerReference((List<KeyToPath>)expectedKeyToPaths));
            SparkConf x$29 = sparkConf3;
            Some x$30 = new Some((Object)this.KUBERNETES_RESOURCE_PREFIX());
            String x$31 = KubernetesTestConf$.MODULE$.createDriverConf$default$2();
            MainAppResource x$32 = KubernetesTestConf$.MODULE$.createDriverConf$default$3();
            String x$33 = KubernetesTestConf$.MODULE$.createDriverConf$default$4();
            String[] x$34 = KubernetesTestConf$.MODULE$.createDriverConf$default$5();
            Map<String, String> x$35 = KubernetesTestConf$.MODULE$.createDriverConf$default$7();
            Map<String, String> x$36 = KubernetesTestConf$.MODULE$.createDriverConf$default$8();
            Map<String, String> x$37 = KubernetesTestConf$.MODULE$.createDriverConf$default$9();
            Map<String, String> x$38 = KubernetesTestConf$.MODULE$.createDriverConf$default$10();
            Map<String, String> x$39 = KubernetesTestConf$.MODULE$.createDriverConf$default$11();
            Map<String, String> x$40 = KubernetesTestConf$.MODULE$.createDriverConf$default$12();
            Seq<KubernetesVolumeSpec> x$41 = KubernetesTestConf$.MODULE$.createDriverConf$default$13();
            Option<String> x$42 = KubernetesTestConf$.MODULE$.createDriverConf$default$14();
            this.kconf_$eq(KubernetesTestConf$.MODULE$.createDriverConf(x$29, x$31, x$32, x$33, x$34, (Option<String>)x$30, x$35, x$36, x$37, x$38, x$39, x$40, x$41, x$42));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.kconf().sparkConf().getOption("spark.home").isDefined(), "ClientSuite.this.kconf.sparkConf.getOption(\"spark.home\").isDefined", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 307));
            Mockito.when((Object)this.driverBuilder().buildFromFeatures(this.kconf(), this.kubernetesClient())).thenReturn((Object)this.BUILT_KUBERNETES_SPEC());
            Client submissionClient = new Client(this.kconf(), this.driverBuilder(), this.kubernetesClient(), this.loggingPodStatusWatcher());
            submissionClient.run();
            java.util.List otherCreatedResources = this.createdResourcesArgumentCaptor().getAllValues();
            ConfigMap[] configMaps = (ConfigMap[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(otherCreatedResources.toArray())).filter((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)ClientSuite.$anonfun$new$18(x$9))))).map((Function1 & Serializable & scala.Serializable)x$10 -> (ConfigMap)x$10, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ConfigMap.class)));
            Object[] $org_scalatest_assert_macro_left = Predef$.MODULE$.refArrayOps((Object[])configMaps);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left), "nonEmpty", new ArrayOps.ofRef($org_scalatest_assert_macro_left).nonEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 320));
            String configMapName = KubernetesClientUtils$.MODULE$.configMapNameDriver();
            ConfigMap configMap = (ConfigMap)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])configMaps)).head();
            String $org_scalatest_assert_macro_left2 = configMap.getMetadata().getName();
            String $org_scalatest_assert_macro_right = configMapName;
            String string = $org_scalatest_assert_macro_left2;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 323));
            Set configMapLoadedFiles = (Set)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(configMap.getData().keySet()).asScala()).toSet().$minus((Object)Config$.MODULE$.KUBERNETES_NAMESPACE().key());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(configMapLoadedFiles);
            Set $org_scalatest_assert_macro_right2 = (Set)expectedConfFiles2.toSet().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{Constants$.MODULE$.SPARK_CONF_FILE_NAME()})));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 326));
            configMapLoadedFiles.foreach((Function1 & Serializable & scala.Serializable)f -> {
                String $org_scalatest_assert_macro_left = (String)configMap.getData().get(f);
                String $org_scalatest_assert_macro_right = "conf1key=conf1value";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 328));
            });
        }, new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 267));
        this.test("Waiting for app completion should stall on the watcher", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Client submissionClient = new Client(this.kconf(), this.driverBuilder(), this.kubernetesClient(), this.loggingPodStatusWatcher());
            submissionClient.run();
            return ((LoggingPodStatusWatcher)Mockito.verify((Object)this.loggingPodStatusWatcher())).watchOrStop(new StringBuilder(7).append(this.kconf().namespace()).append(":driver").toString());
        }, new Position("ClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 332));
    }
}

