/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.HostAlias;
import io.fabric8.kubernetes.api.model.HostAliasBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.OwnerReference;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodFluentImpl;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.Toleration;
import io.fabric8.kubernetes.api.model.TolerationBuilder;
import io.fabric8.kubernetes.api.model.TolerationFluentImpl;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeFluent;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.fabric8.kubernetes.api.model.VolumeMountBuilder;
import io.fabric8.kubernetes.api.model.VolumeMountFluentImpl;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import java.io.File;
import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.SparkPod;
import org.apache.spark.internal.config.ConfigEntry;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005eb!B\t\u0013\u0003\u0003i\u0002\"\u0002\u0012\u0001\t\u0003\u0019\u0003b\u0002\u0014\u0001\u0005\u00045\ta\n\u0005\bk\u0001\u0011\rQ\"\u0001(\u0011\u001d1\u0004A1A\u0007\u0002\u001dBQa\u000e\u0001\u0007\u0012aBQA\u0014\u0001\u0007\u0012=CQ!\u0016\u0001\u0007\u0012YCQ\u0001\u0018\u0001\u0007\u0012uCQ!\u0019\u0001\u0007\u0012\u001dBQA\u0019\u0001\u0007\u0012\rDq!\u001f\u0001C\u0002\u0013E!\u0010\u0003\u0004|\u0001\u0001\u0006I!\u001b\u0005\u0006y\u0002!\t\" \u0005\n\u0003#\u0001\u0011\u0013!C\t\u0003'Aq!!\u000b\u0001\t\u0013\tY\u0003C\u0004\u00026\u0001!I!a\u000e\u0003\u001fA{GMQ;jY\u0012,'oU;ji\u0016T!a\u0005\u000b\u0002\u0007-D4O\u0003\u0002\u0016-\u00051A-\u001a9m_fT!a\u0006\r\u0002\u000bM\u0004\u0018M]6\u000b\u0005eQ\u0012AB1qC\u000eDWMC\u0001\u001c\u0003\ry'oZ\u0002\u0001'\t\u0001a\u0004\u0005\u0002 A5\ta#\u0003\u0002\"-\ti1\u000b]1sW\u001a+hnU;ji\u0016\fa\u0001P5oSRtD#\u0001\u0013\u0011\u0005\u0015\u0002Q\"\u0001\n\u0002\u0011A{Ei\u0018*P\u0019\u0016+\u0012\u0001\u000b\t\u0003SIr!A\u000b\u0019\u0011\u0005-rS\"\u0001\u0017\u000b\u00055b\u0012A\u0002\u001fs_>$hHC\u00010\u0003\u0015\u00198-\u00197b\u0013\t\td&\u0001\u0004Qe\u0016$WMZ\u0005\u0003gQ\u0012aa\u0015;sS:<'BA\u0019/\u0003M!Vi\u0015+`\u0003:su\nV!U\u0013>sulS#Z\u0003U!Vi\u0015+`\u0003:su\nV!U\u0013>suLV!M+\u0016\u000b\u0001\u0003^3na2\fG/\u001a$jY\u0016\u001cuN\u001c4\u0016\u0003e\u0002$A\u000f#\u0011\u0007m\u0002%)D\u0001=\u0015\tid(\u0001\u0004d_:4\u0017n\u001a\u0006\u0003\u007fY\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003\u0003r\u00121bQ8oM&<WI\u001c;ssB\u00111\t\u0012\u0007\u0001\t%)U!!A\u0001\u0002\u000b\u0005aIA\u0002`IE\n\"aR&\u0011\u0005!KU\"\u0001\u0018\n\u0005)s#a\u0002(pi\"Lgn\u001a\t\u0003\u00112K!!\u0014\u0018\u0003\u0007\u0005s\u00170A\u000fs_2,7\u000b]3dS\u001aL7mU2iK\u0012,H.\u001a:OC6,7i\u001c8g+\u0005\u0001\u0006GA)T!\rY\u0004I\u0015\t\u0003\u0007N#\u0011\u0002\u0016\u0004\u0002\u0002\u0003\u0005)\u0011\u0001$\u0003\u0007}##'\u0001\u000bvg\u0016\u0014h)Z1ukJ,7\u000b^3qg\u000e{gNZ\u000b\u0002/B\u0012\u0001L\u0017\t\u0004w\u0001K\u0006CA\"[\t%Yv!!A\u0001\u0002\u000b\u0005aIA\u0002`IM\nQ%^:fe\u001a+\u0017\r^;sKN#X\r],ji\",\u0005\u0010]3di\u0016$\u0017I\u001c8pi\u0006$\u0018n\u001c8\u0016\u0003y\u0003B\u0001S0)Q%\u0011\u0001M\f\u0002\u0007)V\u0004H.\u001a\u001a\u0002)]\u0014xN\\4UsB,g)Z1ukJ,7\u000b^3q\u0003!\u0011W/\u001b7e!>$Gc\u00013hYB\u0011Q%Z\u0005\u0003MJ\u0011\u0001b\u00159be.\u0004v\u000e\u001a\u0005\u0006Q*\u0001\r![\u0001\ngB\f'o[\"p]\u001a\u0004\"a\b6\n\u0005-4\"!C*qCJ\\7i\u001c8g\u0011\u0015i'\u00021\u0001o\u0003\u0019\u0019G.[3oiB\u0011qn^\u0007\u0002a*\u0011Q.\u001d\u0006\u0003eN\f!b[;cKJtW\r^3t\u0015\t!X/A\u0004gC\n\u0014\u0018n\u0019\u001d\u000b\u0003Y\f!![8\n\u0005a\u0004(\u0001E&vE\u0016\u0014h.\u001a;fg\u000ec\u0017.\u001a8u\u0003!\u0011\u0017m]3D_:4W#A5\u0002\u0013\t\f7/Z\"p]\u001a\u0004\u0013\u0001F7pG.\\UOY3s]\u0016$Xm]\"mS\u0016tG\u000f\u0006\u0002o}\"Aq0\u0004I\u0001\u0002\u0004\t\t!A\u0002q_\u0012\u0004B!a\u0001\u0002\u000e5\u0011\u0011Q\u0001\u0006\u0005\u0003\u000f\tI!A\u0003n_\u0012,GNC\u0002\u0002\fE\f1!\u00199j\u0013\u0011\ty!!\u0002\u0003\u0007A{G-\u0001\u0010n_\u000e\\7*\u001e2fe:,G/Z:DY&,g\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011Q\u0003\u0016\u0005\u0003\u0003\t9b\u000b\u0002\u0002\u001aA!\u00111DA\u0013\u001b\t\tiB\u0003\u0003\u0002 \u0005\u0005\u0012!C;oG\",7m[3e\u0015\r\t\u0019CL\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u0014\u0003;\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003%1XM]5gsB{G\r\u0006\u0003\u0002.\u0005M\u0002c\u0001%\u00020%\u0019\u0011\u0011\u0007\u0018\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u007f>\u0001\r\u0001Z\u0001\u0019a>$w+\u001b;i'V\u0004\bo\u001c:uK\u00124U-\u0019;ve\u0016\u001cHCAA\u0001\u0001")
public abstract class PodBuilderSuite
extends SparkFunSuite {
    private final SparkConf baseConf = new SparkConf(false).set(Config$.MODULE$.CONTAINER_IMAGE(), (Object)"spark-executor:latest");

    public abstract String POD_ROLE();

    public abstract String TEST_ANNOTATION_KEY();

    public abstract String TEST_ANNOTATION_VALUE();

    public abstract ConfigEntry<?> templateFileConf();

    public abstract ConfigEntry<?> roleSpecificSchedulerNameConf();

    public abstract ConfigEntry<?> userFeatureStepsConf();

    public abstract Tuple2<String, String> userFeatureStepWithExpectedAnnotation();

    public abstract String wrongTypeFeatureStep();

    public abstract SparkPod buildPod(SparkConf var1, KubernetesClient var2);

    public SparkConf baseConf() {
        return this.baseConf;
    }

    public KubernetesClient mockKubernetesClient(Pod pod) {
        KubernetesClient kubernetesClient = (KubernetesClient)Mockito.mock(KubernetesClient.class);
        MixedOperation pods = (MixedOperation)Mockito.mock(MixedOperation.class);
        PodResource podResource = (PodResource)Mockito.mock(PodResource.class);
        Mockito.when((Object)kubernetesClient.pods()).thenReturn((Object)pods);
        Mockito.when((Object)pods.load((File)ArgumentMatchers.any(File.class))).thenReturn((Object)podResource);
        Mockito.when((Object)podResource.get()).thenReturn((Object)pod);
        return kubernetesClient;
    }

    public Pod mockKubernetesClient$default$1() {
        return this.podWithSupportedFeatures();
    }

    private void verifyPod(SparkPod pod) {
        ObjectMeta metadata = pod.pod().getMetadata();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(metadata.getLabels().containsKey("test-label-key"), "metadata.getLabels().containsKey(\"test-label-key\")", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PodBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 170));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(metadata.getAnnotations().containsKey("test-annotation-key"), "metadata.getAnnotations().containsKey(\"test-annotation-key\")", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PodBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 171));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(metadata.getNamespace());
        String $org_scalatest_assert_macro_right = "namespace";
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("PodBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 172));
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(metadata.getOwnerReferences()).asScala()).exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)PodBuilderSuite.$anonfun$verifyPod$1(x$4))), "scala.collection.JavaConverters.asScalaBufferConverter[io.fabric8.kubernetes.api.model.OwnerReference](metadata.getOwnerReferences()).asScala.exists(((x$4: io.fabric8.kubernetes.api.model.OwnerReference) => x$4.getName().==(\"owner-reference\")))", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("PodBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 173));
        PodSpec spec = pod.pod().getSpec();
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(spec.getContainers()).asScala()).exists((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)PodBuilderSuite.$anonfun$verifyPod$2(x$5))), "scala.collection.JavaConverters.asScalaBufferConverter[io.fabric8.kubernetes.api.model.Container](spec.getContainers()).asScala.exists(((x$5: io.fabric8.kubernetes.api.model.Container) => x$5.getName().==(\"executor-container\")))", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("PodBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 175));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(spec.getDnsPolicy());
        String $org_scalatest_assert_macro_right2 = "dns-policy";
        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("PodBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 176));
        Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(spec.getHostAliases()).asScala()).exists((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)PodBuilderSuite.$anonfun$verifyPod$3(x$6))), "scala.collection.JavaConverters.asScalaBufferConverter[io.fabric8.kubernetes.api.model.HostAlias](spec.getHostAliases()).asScala.exists(((x$6: io.fabric8.kubernetes.api.model.HostAlias) => scala.collection.JavaConverters.asScalaBufferConverter[String](x$6.getHostnames()).asScala.exists(((x$7: String) => x$7.==(\"hostname\")))))", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("PodBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 177));
        Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(spec.getImagePullSecrets()).asScala()).exists((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)PodBuilderSuite.$anonfun$verifyPod$5(x$8))), "scala.collection.JavaConverters.asScalaBufferConverter[io.fabric8.kubernetes.api.model.LocalObjectReference](spec.getImagePullSecrets()).asScala.exists(((x$8: io.fabric8.kubernetes.api.model.LocalObjectReference) => x$8.getName().==(\"local-reference\")))", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("PodBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 178));
        Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.simpleMacroBool(((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(spec.getInitContainers()).asScala()).exists((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)PodBuilderSuite.$anonfun$verifyPod$6(x$9))), "scala.collection.JavaConverters.asScalaBufferConverter[io.fabric8.kubernetes.api.model.Container](spec.getInitContainers()).asScala.exists(((x$9: io.fabric8.kubernetes.api.model.Container) => x$9.getName().==(\"init-container\")))", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("PodBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 179));
        String $org_scalatest_assert_macro_left3 = spec.getNodeName();
        String $org_scalatest_assert_macro_right3 = "node-name";
        String string = $org_scalatest_assert_macro_left3;
        String string2 = $org_scalatest_assert_macro_right3;
        Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("PodBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 180));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(spec.getNodeSelector().get("node-selector-key"));
        String $org_scalatest_assert_macro_right4 = "node-selector-value";
        Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("PodBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 181));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(spec.getSchedulerName());
        String $org_scalatest_assert_macro_right5 = "scheduler";
        Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("PodBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 182));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(spec.getSecurityContext().getRunAsUser());
        long $org_scalatest_assert_macro_right6 = 1000L;
        Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("PodBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 183));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(spec.getServiceAccount());
        String $org_scalatest_assert_macro_right7 = "service-account";
        Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("PodBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 184));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(spec.getSubdomain());
        String $org_scalatest_assert_macro_right8 = "subdomain";
        Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("PodBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 185));
        Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.simpleMacroBool(((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(spec.getTolerations()).asScala()).exists((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)PodBuilderSuite.$anonfun$verifyPod$7(x$10))), "scala.collection.JavaConverters.asScalaBufferConverter[io.fabric8.kubernetes.api.model.Toleration](spec.getTolerations()).asScala.exists(((x$10: io.fabric8.kubernetes.api.model.Toleration) => x$10.getKey().==(\"toleration-key\")))", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"", Prettifier$.MODULE$.default(), new Position("PodBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 186));
        Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.simpleMacroBool(((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(spec.getVolumes()).asScala()).exists((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)PodBuilderSuite.$anonfun$verifyPod$8(x$11))), "scala.collection.JavaConverters.asScalaBufferConverter[io.fabric8.kubernetes.api.model.Volume](spec.getVolumes()).asScala.exists(((x$11: io.fabric8.kubernetes.api.model.Volume) => x$11.getName().==(\"test-volume\")))", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"", Prettifier$.MODULE$.default(), new Position("PodBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 187));
        Container container = pod.container();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.convertToEqualizer(container.getName());
        String $org_scalatest_assert_macro_right9 = "executor-container";
        Bool $org_scalatest_assert_macro_expr18 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)$org_scalatest_assert_macro_right9, $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)$org_scalatest_assert_macro_right9, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr18, (Object)"", Prettifier$.MODULE$.default(), new Position("PodBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 189));
        java.util.List $org_scalatest_assert_macro_left10 = container.getArgs();
        String $org_scalatest_assert_macro_right10 = "arg";
        Bool $org_scalatest_assert_macro_expr19 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "contains", (Object)$org_scalatest_assert_macro_right10, $org_scalatest_assert_macro_left10.contains($org_scalatest_assert_macro_right10), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr19, (Object)"", Prettifier$.MODULE$.default(), new Position("PodBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 190));
        Bool $org_scalatest_assert_macro_expr20 = Bool$.MODULE$.simpleMacroBool(((Object)container.getCommand()).equals(JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)"command", (List)Nil$.MODULE$)).asJava()), "container.getCommand().equals(scala.collection.JavaConverters.seqAsJavaListConverter[String](scala.collection.immutable.List.apply[String](\"command\")).asJava)", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr20, (Object)"", Prettifier$.MODULE$.default(), new Position("PodBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 191));
        Bool $org_scalatest_assert_macro_expr21 = Bool$.MODULE$.simpleMacroBool(((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(container.getEnv()).asScala()).exists((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)PodBuilderSuite.$anonfun$verifyPod$9(x$12))), "scala.collection.JavaConverters.asScalaBufferConverter[io.fabric8.kubernetes.api.model.EnvVar](container.getEnv()).asScala.exists(((x$12: io.fabric8.kubernetes.api.model.EnvVar) => x$12.getName().==(\"env-key\")))", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr21, (Object)"", Prettifier$.MODULE$.default(), new Position("PodBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 192));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = this.convertToEqualizer(container.getResources().getLimits().get("gpu"));
        Quantity $org_scalatest_assert_macro_right11 = new Quantity("1");
        Bool $org_scalatest_assert_macro_expr22 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "===", (Object)$org_scalatest_assert_macro_right11, $org_scalatest_assert_macro_left11.$eq$eq$eq((Object)$org_scalatest_assert_macro_right11, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr22, (Object)"", Prettifier$.MODULE$.default(), new Position("PodBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 193));
        Bool $org_scalatest_assert_macro_expr23 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.Boolean2boolean(container.getSecurityContext().getRunAsNonRoot()), "scala.Predef.Boolean2boolean(container.getSecurityContext().getRunAsNonRoot())", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr23, (Object)"", Prettifier$.MODULE$.default(), new Position("PodBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 194));
        Bool $org_scalatest_assert_macro_expr24 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.Boolean2boolean(container.getStdin()), "scala.Predef.Boolean2boolean(container.getStdin())", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr24, (Object)"", Prettifier$.MODULE$.default(), new Position("PodBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 195));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left12 = this.convertToEqualizer(container.getTerminationMessagePath());
        String $org_scalatest_assert_macro_right12 = "termination-message-path";
        Bool $org_scalatest_assert_macro_expr25 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "===", (Object)$org_scalatest_assert_macro_right12, $org_scalatest_assert_macro_left12.$eq$eq$eq((Object)$org_scalatest_assert_macro_right12, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr25, (Object)"", Prettifier$.MODULE$.default(), new Position("PodBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 196));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left13 = this.convertToEqualizer(container.getTerminationMessagePolicy());
        String $org_scalatest_assert_macro_right13 = "termination-message-policy";
        Bool $org_scalatest_assert_macro_expr26 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left13, "===", (Object)$org_scalatest_assert_macro_right13, $org_scalatest_assert_macro_left13.$eq$eq$eq((Object)$org_scalatest_assert_macro_right13, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr26, (Object)"", Prettifier$.MODULE$.default(), new Position("PodBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 197));
        Bool $org_scalatest_assert_macro_expr27 = Bool$.MODULE$.simpleMacroBool(((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pod.container().getVolumeMounts()).asScala()).exists((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)PodBuilderSuite.$anonfun$verifyPod$10(x$13))), "scala.collection.JavaConverters.asScalaBufferConverter[io.fabric8.kubernetes.api.model.VolumeMount](pod.container.getVolumeMounts()).asScala.exists(((x$13: io.fabric8.kubernetes.api.model.VolumeMount) => x$13.getName().==(\"test-volume\")))", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr27, (Object)"", Prettifier$.MODULE$.default(), new Position("PodBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 198));
    }

    private Pod podWithSupportedFeatures() {
        return ((PodBuilder)((PodFluent.SpecNested)((PodSpecFluent.ContainersNested)((ContainerFluent)((ContainerFluent.SecurityContextNested)((ContainerFluent)((ContainerFluent.ResourcesNested)((ContainerFluent)((ContainerFluent.EnvNested)((PodSpecFluent)((PodSpecFluent.VolumesNested)((VolumeFluent)((VolumeFluent.HostPathNested)((PodSpecFluent)((PodSpecFluent.SecurityContextNested)((PodFluentImpl)((PodFluent.MetadataNested)((ObjectMetaFluent.OwnerReferencesNested)new PodBuilder().withNewMetadata().addToLabels("test-label-key", "test-label-value").addToAnnotations("test-annotation-key", "test-annotation-value").withNamespace("namespace").addNewOwnerReference().withController(Predef$.MODULE$.boolean2Boolean(true)).withName("owner-reference")).endOwnerReference()).endMetadata()).withNewSpec().withDnsPolicy("dns-policy").withHostAliases(new HostAlias[]{((HostAliasBuilder)new HostAliasBuilder().withHostnames(new String[]{"hostname"})).build()}).withImagePullSecrets(new LocalObjectReference[]{((LocalObjectReferenceBuilder)new LocalObjectReferenceBuilder().withName("local-reference")).build()}).withInitContainers(new Container[]{((ContainerBuilder)new ContainerBuilder().withName("init-container")).build()}).withNodeName("node-name").withNodeSelector((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"node-selector-key"), (Object)"node-selector-value")}))).asJava()).withSchedulerName("scheduler").withNewSecurityContext().withRunAsUser(Predef$.MODULE$.long2Long(1000L))).endSecurityContext()).withServiceAccount("service-account").withSubdomain("subdomain").withTolerations(new Toleration[]{((TolerationBuilder)((TolerationFluentImpl)((TolerationFluentImpl)new TolerationBuilder().withKey("toleration-key")).withOperator("Equal")).withEffect("NoSchedule")).build()}).addNewVolume().withNewHostPath().withPath("/test")).endHostPath()).withName("test-volume")).endVolume()).addNewContainer().withArgs(new String[]{"arg"}).withCommand(new String[]{"command"}).addNewEnv().withName("env-key").withValue("env-value")).endEnv()).withImagePullPolicy("Always").withName("executor-container").withNewResources().withLimits((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"gpu"), (Object)new Quantity("1"))}))).asJava())).endResources()).withNewSecurityContext().withRunAsNonRoot(Predef$.MODULE$.boolean2Boolean(true))).endSecurityContext()).withStdin(Predef$.MODULE$.boolean2Boolean(true)).withTerminationMessagePath("termination-message-path").withTerminationMessagePolicy("termination-message-policy").addToVolumeMounts(new VolumeMount[]{((VolumeMountBuilder)((VolumeMountFluentImpl)new VolumeMountBuilder().withName("test-volume")).withMountPath("/test")).build()})).endContainer()).endSpec()).build();
    }

    public static final /* synthetic */ boolean $anonfun$new$5(VolumeMount x$1) {
        String string = x$1.getName();
        String string2 = "so_long";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$new$6(VolumeMount x$2) {
        String string = x$2.getName();
        String string2 = "so_long_two";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$verifyPod$1(OwnerReference x$4) {
        String string = x$4.getName();
        String string2 = "owner-reference";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$verifyPod$2(Container x$5) {
        String string = x$5.getName();
        String string2 = "executor-container";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$verifyPod$4(String x$7) {
        String string = x$7;
        String string2 = "hostname";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$verifyPod$3(HostAlias x$6) {
        return ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(x$6.getHostnames()).asScala()).exists((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)PodBuilderSuite.$anonfun$verifyPod$4(x$7)));
    }

    public static final /* synthetic */ boolean $anonfun$verifyPod$5(LocalObjectReference x$8) {
        String string = x$8.getName();
        String string2 = "local-reference";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$verifyPod$6(Container x$9) {
        String string = x$9.getName();
        String string2 = "init-container";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$verifyPod$7(Toleration x$10) {
        String string = x$10.getKey();
        String string2 = "toleration-key";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$verifyPod$8(Volume x$11) {
        String string = x$11.getName();
        String string2 = "test-volume";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$verifyPod$9(EnvVar x$12) {
        String string = x$12.getName();
        String string2 = "env-key";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$verifyPod$10(VolumeMount x$13) {
        String string = x$13.getName();
        String string2 = "test-volume";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public PodBuilderSuite() {
        this.test("use empty initial pod if template is not specified", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            KubernetesClient client = (KubernetesClient)Mockito.mock(KubernetesClient.class);
            this.buildPod(this.baseConf().clone(), client);
            return ((KubernetesClient)Mockito.verify((Object)client, (VerificationMode)Mockito.never())).pods();
        }, new Position("PodBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 52));
        this.test("SPARK-36059: set custom scheduler", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            KubernetesClient client = this.mockKubernetesClient(this.mockKubernetesClient$default$1());
            SparkConf conf1 = this.baseConf().clone().set(this.templateFileConf().key(), "template-file.yaml").set(Config$.MODULE$.KUBERNETES_SCHEDULER_NAME().key(), "custom");
            SparkPod pod1 = this.buildPod(conf1, client);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(pod1.pod().getSpec().getSchedulerName());
            String $org_scalatest_assert_macro_right = "custom";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PodBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
            SparkConf conf2 = this.baseConf().clone().set(this.templateFileConf().key(), "template-file.yaml").set(Config$.MODULE$.KUBERNETES_SCHEDULER_NAME().key(), "custom").set(this.roleSpecificSchedulerNameConf().key(), "rolescheduler");
            SparkPod pod2 = this.buildPod(conf2, client);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(pod2.pod().getSpec().getSchedulerName());
            String $org_scalatest_assert_macro_right2 = "rolescheduler";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PodBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
        }, new Position("PodBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58));
        this.test("load pod template if specified", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            KubernetesClient client = this.mockKubernetesClient(this.mockKubernetesClient$default$1());
            SparkConf sparkConf = this.baseConf().clone().set(this.templateFileConf().key(), "template-file.yaml");
            SparkPod pod = this.buildPod(sparkConf, client);
            this.verifyPod(pod);
        }, new Position("PodBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
        this.test("configure a custom test step", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            KubernetesClient client = this.mockKubernetesClient(this.mockKubernetesClient$default$1());
            SparkConf sparkConf = this.baseConf().clone().set(this.userFeatureStepsConf().key(), "org.apache.spark.deploy.k8s.TestStepTwo,org.apache.spark.deploy.k8s.TestStep").set(this.templateFileConf().key(), "template-file.yaml");
            SparkPod pod = this.buildPod(sparkConf, client);
            this.verifyPod(pod);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pod.container().getVolumeMounts()).asScala()).exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)PodBuilderSuite.$anonfun$new$5(x$1))), "scala.collection.JavaConverters.asScalaBufferConverter[io.fabric8.kubernetes.api.model.VolumeMount](pod.container.getVolumeMounts()).asScala.exists(((x$1: io.fabric8.kubernetes.api.model.VolumeMount) => x$1.getName().==(\"so_long\")))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PodBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pod.container().getVolumeMounts()).asScala()).exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)PodBuilderSuite.$anonfun$new$6(x$2))), "scala.collection.JavaConverters.asScalaBufferConverter[io.fabric8.kubernetes.api.model.VolumeMount](pod.container.getVolumeMounts()).asScala.exists(((x$2: io.fabric8.kubernetes.api.model.VolumeMount) => x$2.getName().==(\"so_long_two\")))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PodBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
        }, new Position("PodBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
        this.test("SPARK-37145: configure a custom test step with base config", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            KubernetesClient client = this.mockKubernetesClient(this.mockKubernetesClient$default$1());
            SparkConf sparkConf = this.baseConf().clone().set(this.userFeatureStepsConf().key(), "org.apache.spark.deploy.k8s.TestStepWithConf").set(this.templateFileConf().key(), "template-file.yaml").set("test-features-key", "test-features-value");
            SparkPod pod = this.buildPod(sparkConf, client);
            this.verifyPod(pod);
            ObjectMeta metadata = pod.pod().getMetadata();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(metadata.getAnnotations().containsKey("test-features-key"), "metadata.getAnnotations().containsKey(\"test-features-key\")", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PodBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(metadata.getAnnotations().get("test-features-key"));
            String $org_scalatest_assert_macro_right = "test-features-value";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PodBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
        }, new Position("PodBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92));
        this.test("SPARK-37145: configure a custom test step with driver or executor config", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            KubernetesClient client = this.mockKubernetesClient(this.mockKubernetesClient$default$1());
            Tuple2<String, String> tuple2 = this.userFeatureStepWithExpectedAnnotation();
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String featureSteps = (String)tuple2._1();
            String annotation = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)featureSteps, (Object)annotation);
            String featureSteps2 = (String)tuple22._1();
            String annotation2 = (String)tuple22._2();
            SparkConf sparkConf = this.baseConf().clone().set(this.templateFileConf().key(), "template-file.yaml").set(this.userFeatureStepsConf().key(), featureSteps2).set(this.TEST_ANNOTATION_KEY(), annotation2);
            SparkPod pod = this.buildPod(sparkConf, client);
            this.verifyPod(pod);
            ObjectMeta metadata = pod.pod().getMetadata();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(metadata.getAnnotations().containsKey(this.TEST_ANNOTATION_KEY()), "metadata.getAnnotations().containsKey(PodBuilderSuite.this.TEST_ANNOTATION_KEY)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PodBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 116));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(metadata.getAnnotations().get(this.TEST_ANNOTATION_KEY()));
            String $org_scalatest_assert_macro_right = annotation2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PodBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117));
        }, new Position("PodBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
        this.test("SPARK-37145: configure a custom test step with wrong type config", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            KubernetesClient client = this.mockKubernetesClient(this.mockKubernetesClient$default$1());
            SparkConf sparkConf = this.baseConf().clone().set(this.templateFileConf().key(), "template-file.yaml").set(this.userFeatureStepsConf().key(), this.wrongTypeFeatureStep());
            SparkException e = (SparkException)this.intercept((Function0 & Serializable & scala.Serializable)() -> this.buildPod(sparkConf, client), ClassTag$.MODULE$.apply(SparkException.class), new Position("PodBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 125));
            String $org_scalatest_assert_macro_left = e.getMessage();
            String $org_scalatest_assert_macro_right = new StringBuilder(41).append("please make sure your ").append(this.POD_ROLE()).append(" side feature steps").toString();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PodBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 128));
        }, new Position("PodBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
        this.test("SPARK-37145: configure a custom test step with wrong name", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            KubernetesClient client = this.mockKubernetesClient(this.mockKubernetesClient$default$1());
            String featureSteps = "unknow.class";
            SparkConf sparkConf = this.baseConf().clone().set(this.templateFileConf().key(), "template-file.yaml").set(this.userFeatureStepsConf().key(), featureSteps);
            ClassNotFoundException e = (ClassNotFoundException)this.intercept((Function0 & Serializable & scala.Serializable)() -> this.buildPod(sparkConf, client), ClassTag$.MODULE$.apply(ClassNotFoundException.class), new Position("PodBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137));
            String $org_scalatest_assert_macro_left = e.getMessage();
            String $org_scalatest_assert_macro_right = "unknow.class";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PodBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 140));
        }, new Position("PodBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 131));
        this.test("complain about misconfigured pod template", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            KubernetesClient client = this.mockKubernetesClient(((PodBuilder)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().addToLabels("test-label-key", "test-label-value")).endMetadata()).build());
            SparkConf sparkConf = this.baseConf().clone().set(this.templateFileConf().key(), "template-file.yaml");
            SparkException exception = (SparkException)this.intercept((Function0 & Serializable & scala.Serializable)() -> this.buildPod(sparkConf, client), ClassTag$.MODULE$.apply(SparkException.class), new Position("PodBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 151));
            String $org_scalatest_assert_macro_left = exception.getMessage();
            String $org_scalatest_assert_macro_right = "Could not load pod from template file.";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PodBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154));
        }, new Position("PodBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143));
    }
}

