/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s;

import io.fabric8.kubernetes.api.model.Pod;
import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.KubernetesDriverConf;
import org.apache.spark.deploy.k8s.KubernetesEmptyDirVolumeConf;
import org.apache.spark.deploy.k8s.KubernetesExecutorConf;
import org.apache.spark.deploy.k8s.KubernetesExecutorConf$;
import org.apache.spark.deploy.k8s.KubernetesHostPathVolumeConf;
import org.apache.spark.deploy.k8s.KubernetesNFSVolumeConf;
import org.apache.spark.deploy.k8s.KubernetesPVCVolumeConf;
import org.apache.spark.deploy.k8s.KubernetesVolumeSpec;
import org.apache.spark.deploy.k8s.KubernetesVolumeSpecificConf;
import org.apache.spark.deploy.k8s.submit.JavaMainAppResource;
import org.apache.spark.deploy.k8s.submit.MainAppResource;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;

public final class KubernetesTestConf$ {
    public static KubernetesTestConf$ MODULE$;
    private final String APP_ID;
    private final String MAIN_CLASS;
    private final String RESOURCE_PREFIX;
    private final String EXECUTOR_ID;
    private final SparkConf DEFAULT_CONF;

    static {
        new KubernetesTestConf$();
    }

    public String APP_ID() {
        return this.APP_ID;
    }

    public String MAIN_CLASS() {
        return this.MAIN_CLASS;
    }

    public String RESOURCE_PREFIX() {
        return this.RESOURCE_PREFIX;
    }

    public String EXECUTOR_ID() {
        return this.EXECUTOR_ID;
    }

    private SparkConf DEFAULT_CONF() {
        return this.DEFAULT_CONF;
    }

    public KubernetesDriverConf createDriverConf(SparkConf sparkConf, String appId, MainAppResource mainAppResource, String mainClass, String[] appArgs, Option<String> resourceNamePrefix, Map<String, String> labels, Map<String, String> environment, Map<String, String> annotations, Map<String, String> serviceAnnotations, Map<String, String> secretEnvNamesToKeyRefs, Map<String, String> secretNamesToMountPaths, Seq<KubernetesVolumeSpec> volumes, Option<String> proxyUser) {
        SparkConf conf = sparkConf.clone();
        resourceNamePrefix.foreach((Function1 & Serializable & scala.Serializable)prefix -> conf.set(Config$.MODULE$.KUBERNETES_DRIVER_POD_NAME_PREFIX(), prefix));
        this.setPrefixedConfigs(conf, Config$.MODULE$.KUBERNETES_DRIVER_LABEL_PREFIX(), labels);
        this.setPrefixedConfigs(conf, Config$.MODULE$.KUBERNETES_DRIVER_ENV_PREFIX(), environment);
        this.setPrefixedConfigs(conf, Config$.MODULE$.KUBERNETES_DRIVER_ANNOTATION_PREFIX(), annotations);
        this.setPrefixedConfigs(conf, Config$.MODULE$.KUBERNETES_DRIVER_SERVICE_ANNOTATION_PREFIX(), serviceAnnotations);
        this.setPrefixedConfigs(conf, Config$.MODULE$.KUBERNETES_DRIVER_SECRETS_PREFIX(), secretNamesToMountPaths);
        this.setPrefixedConfigs(conf, Config$.MODULE$.KUBERNETES_DRIVER_SECRET_KEY_REF_PREFIX(), secretEnvNamesToKeyRefs);
        this.setVolumeSpecs(conf, Config$.MODULE$.KUBERNETES_DRIVER_VOLUMES_PREFIX(), volumes);
        return new KubernetesDriverConf(conf, appId, mainAppResource, mainClass, appArgs, proxyUser);
    }

    public SparkConf createDriverConf$default$1() {
        return this.DEFAULT_CONF();
    }

    public String createDriverConf$default$2() {
        return this.APP_ID();
    }

    public MainAppResource createDriverConf$default$3() {
        return new JavaMainAppResource((Option)None$.MODULE$);
    }

    public String createDriverConf$default$4() {
        return this.MAIN_CLASS();
    }

    public String[] createDriverConf$default$5() {
        return (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class));
    }

    public Option<String> createDriverConf$default$6() {
        return None$.MODULE$;
    }

    public Map<String, String> createDriverConf$default$7() {
        return Predef$.MODULE$.Map().empty();
    }

    public Map<String, String> createDriverConf$default$8() {
        return Predef$.MODULE$.Map().empty();
    }

    public Map<String, String> createDriverConf$default$9() {
        return Predef$.MODULE$.Map().empty();
    }

    public Map<String, String> createDriverConf$default$10() {
        return Predef$.MODULE$.Map().empty();
    }

    public Map<String, String> createDriverConf$default$11() {
        return Predef$.MODULE$.Map().empty();
    }

    public Map<String, String> createDriverConf$default$12() {
        return Predef$.MODULE$.Map().empty();
    }

    public Seq<KubernetesVolumeSpec> createDriverConf$default$13() {
        return (Seq)Nil$.MODULE$;
    }

    public Option<String> createDriverConf$default$14() {
        return None$.MODULE$;
    }

    public KubernetesExecutorConf createExecutorConf(SparkConf sparkConf, Option<Pod> driverPod, Map<String, String> labels, Map<String, String> environment, Map<String, String> annotations, Map<String, String> secretEnvNamesToKeyRefs, Map<String, String> secretNamesToMountPaths, Seq<KubernetesVolumeSpec> volumes) {
        SparkConf conf = sparkConf.clone();
        this.setPrefixedConfigs(conf, Config$.MODULE$.KUBERNETES_EXECUTOR_LABEL_PREFIX(), labels);
        this.setPrefixedConfigs(conf, "spark.executorEnv.", environment);
        this.setPrefixedConfigs(conf, Config$.MODULE$.KUBERNETES_EXECUTOR_ANNOTATION_PREFIX(), annotations);
        this.setPrefixedConfigs(conf, Config$.MODULE$.KUBERNETES_EXECUTOR_SECRETS_PREFIX(), secretNamesToMountPaths);
        this.setPrefixedConfigs(conf, Config$.MODULE$.KUBERNETES_EXECUTOR_SECRET_KEY_REF_PREFIX(), secretEnvNamesToKeyRefs);
        this.setVolumeSpecs(conf, Config$.MODULE$.KUBERNETES_EXECUTOR_VOLUMES_PREFIX(), volumes);
        return new KubernetesExecutorConf(conf, this.APP_ID(), this.EXECUTOR_ID(), driverPod, KubernetesExecutorConf$.MODULE$.$lessinit$greater$default$5());
    }

    public SparkConf createExecutorConf$default$1() {
        return this.DEFAULT_CONF();
    }

    public Option<Pod> createExecutorConf$default$2() {
        return None$.MODULE$;
    }

    public Map<String, String> createExecutorConf$default$3() {
        return Predef$.MODULE$.Map().empty();
    }

    public Map<String, String> createExecutorConf$default$4() {
        return Predef$.MODULE$.Map().empty();
    }

    public Map<String, String> createExecutorConf$default$5() {
        return Predef$.MODULE$.Map().empty();
    }

    public Map<String, String> createExecutorConf$default$6() {
        return Predef$.MODULE$.Map().empty();
    }

    public Map<String, String> createExecutorConf$default$7() {
        return Predef$.MODULE$.Map().empty();
    }

    public Seq<KubernetesVolumeSpec> createExecutorConf$default$8() {
        return (Seq)Nil$.MODULE$;
    }

    private void setPrefixedConfigs(SparkConf conf, String prefix, Map<String, String> values) {
        values.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return conf.set(new StringBuilder(0).append(prefix).append(k).toString(), v);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private void setVolumeSpecs(SparkConf conf, String prefix, Seq<KubernetesVolumeSpec> volumes) {
        volumes.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            KubernetesTestConf$.$anonfun$setVolumeSpecs$1(conf, prefix, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private static final String key$1(String vtype, String vname, String subkey, String prefix$2) {
        return new StringBuilder(2).append(prefix$2).append(vtype).append(".").append(vname).append(".").append(subkey).toString();
    }

    public static final /* synthetic */ void $anonfun$setVolumeSpecs$1(SparkConf conf$3, String prefix$2, KubernetesVolumeSpec x0$1) {
        Tuple2 tuple2;
        KubernetesVolumeSpec kubernetesVolumeSpec = x0$1;
        KubernetesVolumeSpecificConf kubernetesVolumeSpecificConf = kubernetesVolumeSpec.volumeConf();
        if (kubernetesVolumeSpecificConf instanceof KubernetesHostPathVolumeConf) {
            KubernetesHostPathVolumeConf kubernetesHostPathVolumeConf = (KubernetesHostPathVolumeConf)kubernetesVolumeSpecificConf;
            String path = kubernetesHostPathVolumeConf.hostPath();
            tuple2 = new Tuple2((Object)Config$.MODULE$.KUBERNETES_VOLUMES_HOSTPATH_TYPE(), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Config$.MODULE$.KUBERNETES_VOLUMES_OPTIONS_PATH_KEY()), (Object)path)})));
        } else if (kubernetesVolumeSpecificConf instanceof KubernetesPVCVolumeConf) {
            KubernetesPVCVolumeConf kubernetesPVCVolumeConf = (KubernetesPVCVolumeConf)kubernetesVolumeSpecificConf;
            String claimName = kubernetesPVCVolumeConf.claimName();
            Option storageClass = kubernetesPVCVolumeConf.storageClass();
            Option sizeLimit = kubernetesPVCVolumeConf.size();
            Map sconf = Option$.MODULE$.option2Iterable(storageClass.map((Function1 & Serializable & scala.Serializable)s -> new Tuple2((Object)Config$.MODULE$.KUBERNETES_VOLUMES_OPTIONS_CLAIM_STORAGE_CLASS_KEY(), s))).toMap(Predef$.MODULE$.$conforms());
            Map lconf = Option$.MODULE$.option2Iterable(sizeLimit.map((Function1 & Serializable & scala.Serializable)l -> new Tuple2((Object)Config$.MODULE$.KUBERNETES_VOLUMES_OPTIONS_SIZE_LIMIT_KEY(), l))).toMap(Predef$.MODULE$.$conforms());
            tuple2 = new Tuple2((Object)Config$.MODULE$.KUBERNETES_VOLUMES_PVC_TYPE(), (Object)((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Config$.MODULE$.KUBERNETES_VOLUMES_OPTIONS_CLAIM_NAME_KEY()), (Object)claimName)}))).$plus$plus((GenTraversableOnce)sconf).$plus$plus((GenTraversableOnce)lconf));
        } else if (kubernetesVolumeSpecificConf instanceof KubernetesEmptyDirVolumeConf) {
            KubernetesEmptyDirVolumeConf kubernetesEmptyDirVolumeConf = (KubernetesEmptyDirVolumeConf)kubernetesVolumeSpecificConf;
            Option medium = kubernetesEmptyDirVolumeConf.medium();
            Option sizeLimit = kubernetesEmptyDirVolumeConf.sizeLimit();
            Map mconf = Option$.MODULE$.option2Iterable(medium.map((Function1 & Serializable & scala.Serializable)m -> new Tuple2((Object)Config$.MODULE$.KUBERNETES_VOLUMES_OPTIONS_MEDIUM_KEY(), m))).toMap(Predef$.MODULE$.$conforms());
            Map lconf = Option$.MODULE$.option2Iterable(sizeLimit.map((Function1 & Serializable & scala.Serializable)l -> new Tuple2((Object)Config$.MODULE$.KUBERNETES_VOLUMES_OPTIONS_SIZE_LIMIT_KEY(), l))).toMap(Predef$.MODULE$.$conforms());
            tuple2 = new Tuple2((Object)Config$.MODULE$.KUBERNETES_VOLUMES_EMPTYDIR_TYPE(), (Object)mconf.$plus$plus((GenTraversableOnce)lconf));
        } else if (kubernetesVolumeSpecificConf instanceof KubernetesNFSVolumeConf) {
            KubernetesNFSVolumeConf kubernetesNFSVolumeConf = (KubernetesNFSVolumeConf)kubernetesVolumeSpecificConf;
            String path = kubernetesNFSVolumeConf.path();
            String server = kubernetesNFSVolumeConf.server();
            tuple2 = new Tuple2((Object)Config$.MODULE$.KUBERNETES_VOLUMES_NFS_TYPE(), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Config$.MODULE$.KUBERNETES_VOLUMES_OPTIONS_PATH_KEY()), (Object)path), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Config$.MODULE$.KUBERNETES_VOLUMES_OPTIONS_SERVER_KEY()), (Object)server)})));
        } else {
            throw new MatchError((Object)kubernetesVolumeSpecificConf);
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        String vtype = (String)tuple22._1();
        Map configs = (Map)tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)vtype, (Object)configs);
        String vtype2 = (String)tuple23._1();
        Map configs2 = (Map)tuple23._2();
        conf$3.set(KubernetesTestConf$.key$1(vtype2, kubernetesVolumeSpec.volumeName(), Config$.MODULE$.KUBERNETES_VOLUMES_MOUNT_PATH_KEY(), prefix$2), kubernetesVolumeSpec.mountPath());
        Object object = new StringOps(Predef$.MODULE$.augmentString(kubernetesVolumeSpec.mountSubPath())).nonEmpty() ? conf$3.set(KubernetesTestConf$.key$1(vtype2, kubernetesVolumeSpec.volumeName(), Config$.MODULE$.KUBERNETES_VOLUMES_MOUNT_SUBPATH_KEY(), prefix$2), kubernetesVolumeSpec.mountSubPath()) : BoxedUnit.UNIT;
        conf$3.set(KubernetesTestConf$.key$1(vtype2, kubernetesVolumeSpec.volumeName(), Config$.MODULE$.KUBERNETES_VOLUMES_MOUNT_READONLY_KEY(), prefix$2), Boolean.toString(kubernetesVolumeSpec.mountReadOnly()));
        configs2.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return conf$3.set(KubernetesTestConf$.key$1(vtype2, kubernetesVolumeSpec.volumeName(), k, prefix$2), v);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private KubernetesTestConf$() {
        MODULE$ = this;
        this.APP_ID = "appId";
        this.MAIN_CLASS = "mainClass";
        this.RESOURCE_PREFIX = "prefix";
        this.EXECUTOR_ID = "1";
        this.DEFAULT_CONF = new SparkConf(false);
    }
}

