/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s;

import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesConf$;
import org.apache.spark.deploy.k8s.KubernetesDriverConf;
import org.apache.spark.deploy.k8s.KubernetesExecutorConf;
import org.apache.spark.deploy.k8s.KubernetesTestConf$;
import org.apache.spark.deploy.k8s.submit.JavaMainAppResource;
import org.apache.spark.deploy.k8s.submit.MainAppResource;
import org.apache.spark.package$;
import org.apache.spark.resource.ResourceProfile$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001=4AAG\u000e\u0001M!)1\u0006\u0001C\u0001Y!9q\u0006\u0001b\u0001\n\u0013\u0001\u0004BB \u0001A\u0003%\u0011\u0007C\u0004A\u0001\t\u0007I\u0011B!\t\r)\u0003\u0001\u0015!\u0003C\u0011\u001dY\u0005A1A\u0005\n\u0005Ca\u0001\u0014\u0001!\u0002\u0013\u0011\u0005bB'\u0001\u0005\u0004%I!\u0011\u0005\u0007\u001d\u0002\u0001\u000b\u0011\u0002\"\t\u000f=\u0003!\u0019!C\u0005\u0003\"1\u0001\u000b\u0001Q\u0001\n\tCq!\u0015\u0001C\u0002\u0013%\u0011\t\u0003\u0004S\u0001\u0001\u0006IA\u0011\u0005\b'\u0002\u0011\r\u0011\"\u0003B\u0011\u0019!\u0006\u0001)A\u0005\u0005\"9Q\u000b\u0001b\u0001\n\u0013\t\u0005B\u0002,\u0001A\u0003%!\tC\u0004X\u0001\t\u0007I\u0011B!\t\ra\u0003\u0001\u0015!\u0003C\u0011\u001dI\u0006A1A\u0005\niCa!\u001b\u0001!\u0002\u0013Y\u0006b\u00026\u0001\u0005\u0004%Ia\u001b\u0005\u0007Y\u0002\u0001\u000b\u0011B\u001c\t\u000f5\u0004!\u0019!C\u0005\u0003\"1a\u000e\u0001Q\u0001\n\t\u00131cS;cKJtW\r^3t\u0007>tgmU;ji\u0016T!\u0001H\u000f\u0002\u0007-D4O\u0003\u0002\u001f?\u00051A-\u001a9m_fT!\u0001I\u0011\u0002\u000bM\u0004\u0018M]6\u000b\u0005\t\u001a\u0013AB1qC\u000eDWMC\u0001%\u0003\ry'oZ\u0002\u0001'\t\u0001q\u0005\u0005\u0002)S5\tq$\u0003\u0002+?\ti1\u000b]1sW\u001a+hnU;ji\u0016\fa\u0001P5oSRtD#A\u0017\u0011\u00059\u0002Q\"A\u000e\u0002\u0011\u0005\u0003\u0006kX!S\u000fN+\u0012!\r\t\u0004eU:T\"A\u001a\u000b\u0003Q\nQa]2bY\u0006L!AN\u001a\u0003\u000b\u0005\u0013(/Y=\u0011\u0005ajT\"A\u001d\u000b\u0005iZ\u0014\u0001\u00027b]\u001eT\u0011\u0001P\u0001\u0005U\u00064\u0018-\u0003\u0002?s\t11\u000b\u001e:j]\u001e\f\u0011\"\u0011)Q?\u0006\u0013vi\u0015\u0011\u0002)\r+6\u000bV(N?:{E)R0T\u000b2+5\tV(S+\u0005\u0011\u0005\u0003B\"Io]j\u0011\u0001\u0012\u0006\u0003\u000b\u001a\u000b\u0011\"[7nkR\f'\r\\3\u000b\u0005\u001d\u001b\u0014AC2pY2,7\r^5p]&\u0011\u0011\n\u0012\u0002\u0004\u001b\u0006\u0004\u0018!F\"V'R{Uj\u0018(P\t\u0016{6+\u0012'F\u0007R{%\u000bI\u0001\u001c\u0007V\u001bFkT'`\tJKe+\u0012*`\u001d>#UiX*F\u0019\u0016\u001bEk\u0014*\u00029\r+6\u000bV(N?\u0012\u0013\u0016JV#S?:{E)R0T\u000b2+5\tV(SA\u0005i2)V*U\u001f6{V\tW#D+R{%k\u0018(P\t\u0016{6+\u0012'F\u0007R{%+\u0001\u0010D+N#v*T0F1\u0016\u001bU\u000bV(S?:{E)R0T\u000b2+5\tV(SA\u0005i1)V*U\u001f6{F*\u0011\"F\u0019N\u000babQ+T)>ku\fT!C\u000b2\u001b\u0006%\u0001\nD+N#v*T0B\u001d:{E+\u0011+J\u001f:\u001b\u0016aE\"V'R{UjX!O\u001d>#\u0016\tV%P\u001dN\u0003\u0013aG*F\u0007J+Ek\u0018(B\u001b\u0016\u001bv\fV(`\u001b>+f\nV0Q\u0003RC5+\u0001\u000fT\u000b\u000e\u0013V\tV0O\u00036+5k\u0018+P?6{UK\u0014+`!\u0006#\u0006j\u0015\u0011\u0002\u001fM+5IU#U?\u0016sek\u0018,B%N\u000b\u0001cU#D%\u0016#v,\u0012(W?Z\u000b%k\u0015\u0011\u0002\u0017\r+6\u000bV(N?\u0016sekU\u0001\r\u0007V\u001bFkT'`\u000b:36\u000bI\u0001\u000b\tJKe+\u0012*`!>#U#A.\u0011\u0005q;W\"A/\u000b\u0005y{\u0016!B7pI\u0016d'B\u00011b\u0003\r\t\u0007/\u001b\u0006\u0003E\u000e\f!b[;cKJtW\r^3t\u0015\t!W-A\u0004gC\n\u0014\u0018n\u0019\u001d\u000b\u0003\u0019\f!![8\n\u0005!l&a\u0001)pI\u0006YAIU%W\u000bJ{\u0006k\u0014#!\u0003-)\u0005,R\"V)>\u0013v,\u0013#\u0016\u0003]\nA\"\u0012-F\u0007V#vJU0J\t\u0002\n\u0011#\u0012-F\u0007V#vJU0F\u001dZ{f+\u0011*T\u0003I)\u0005,R\"V)>\u0013v,\u0012(W?Z\u000b%k\u0015\u0011")
public class KubernetesConfSuite
extends SparkFunSuite {
    private final String[] APP_ARGS = (String[])((Object[])new String[]{"arg1", "arg2"});
    private final Map<String, String> CUSTOM_NODE_SELECTOR = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"nodeSelectorKey1"), (Object)"nodeSelectorValue1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"nodeSelectorKey2"), (Object)"nodeSelectorValue2")}));
    private final Map<String, String> CUSTOM_DRIVER_NODE_SELECTOR = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"driverNodeSelectorKey1"), (Object)"driverNodeSelectorValue1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"driverNodeSelectorKey2"), (Object)"driverNodeSelectorValue2")}));
    private final Map<String, String> CUSTOM_EXECUTOR_NODE_SELECTOR = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"execNodeSelectorKey1"), (Object)"execNodeSelectorValue1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"execNodeSelectorKey2"), (Object)"execNodeSelectorValue2")}));
    private final Map<String, String> CUSTOM_LABELS = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"customLabel1Key"), (Object)"customLabel1Value"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"customLabel2Key"), (Object)"customLabel2Value")}));
    private final Map<String, String> CUSTOM_ANNOTATIONS = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"customAnnotation1Key"), (Object)"customAnnotation1Value"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"customAnnotation2Key"), (Object)"customAnnotation2Value")}));
    private final Map<String, String> SECRET_NAMES_TO_MOUNT_PATHS = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"secret1"), (Object)"/mnt/secrets/secret1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"secret2"), (Object)"/mnt/secrets/secret2")}));
    private final Map<String, String> SECRET_ENV_VARS = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"envName1"), (Object)"name1:key1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"envName2"), (Object)"name2:key2")}));
    private final Map<String, String> CUSTOM_ENVS = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"customEnvKey1"), (Object)"customEnvValue1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"customEnvKey2"), (Object)"customEnvValue2")}));
    private final Pod DRIVER_POD = new PodBuilder().build();
    private final String EXECUTOR_ID;
    private final Map<String, String> EXECUTOR_ENV_VARS = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.executorEnv.1executorEnvVars1/var1"), (Object)"executorEnvVars1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.executorEnv.executorEnvVars2*var2"), (Object)"executorEnvVars2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.executorEnv.executorEnvVars3_var3"), (Object)"executorEnvVars3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.executorEnv.executorEnvVars4-var4"), (Object)"executorEnvVars4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.executorEnv.executorEnvVars5-var5"), (Object)"executorEnvVars5/var5")}));

    private String[] APP_ARGS() {
        return this.APP_ARGS;
    }

    private Map<String, String> CUSTOM_NODE_SELECTOR() {
        return this.CUSTOM_NODE_SELECTOR;
    }

    private Map<String, String> CUSTOM_DRIVER_NODE_SELECTOR() {
        return this.CUSTOM_DRIVER_NODE_SELECTOR;
    }

    private Map<String, String> CUSTOM_EXECUTOR_NODE_SELECTOR() {
        return this.CUSTOM_EXECUTOR_NODE_SELECTOR;
    }

    private Map<String, String> CUSTOM_LABELS() {
        return this.CUSTOM_LABELS;
    }

    private Map<String, String> CUSTOM_ANNOTATIONS() {
        return this.CUSTOM_ANNOTATIONS;
    }

    private Map<String, String> SECRET_NAMES_TO_MOUNT_PATHS() {
        return this.SECRET_NAMES_TO_MOUNT_PATHS;
    }

    private Map<String, String> SECRET_ENV_VARS() {
        return this.SECRET_ENV_VARS;
    }

    private Map<String, String> CUSTOM_ENVS() {
        return this.CUSTOM_ENVS;
    }

    private Pod DRIVER_POD() {
        return this.DRIVER_POD;
    }

    private String EXECUTOR_ID() {
        return this.EXECUTOR_ID;
    }

    private Map<String, String> EXECUTOR_ENV_VARS() {
        return this.EXECUTOR_ENV_VARS;
    }

    public KubernetesConfSuite() {
        this.EXECUTOR_ID = "executor-id";
        this.test("Resolve driver labels, annotations, secret mount paths, envs, and memory overhead", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparkConf sparkConf = new SparkConf(false).set(Config$.MODULE$.MEMORY_OVERHEAD_FACTOR(), (Object)BoxesRunTime.boxToDouble((double)0.3));
            this.CUSTOM_LABELS().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    String value = (String)tuple2._2();
                    return sparkConf.set(new StringBuilder(0).append(Config$.MODULE$.KUBERNETES_DRIVER_LABEL_PREFIX()).append(key).toString(), value);
                }
                throw new MatchError((Object)tuple2);
            });
            this.CUSTOM_ANNOTATIONS().foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    String value = (String)tuple2._2();
                    return sparkConf.set(new StringBuilder(0).append(Config$.MODULE$.KUBERNETES_DRIVER_ANNOTATION_PREFIX()).append(key).toString(), value);
                }
                throw new MatchError((Object)tuple2);
            });
            this.SECRET_NAMES_TO_MOUNT_PATHS().foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
                Tuple2 tuple2 = x0$3;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    String value = (String)tuple2._2();
                    return sparkConf.set(new StringBuilder(0).append(Config$.MODULE$.KUBERNETES_DRIVER_SECRETS_PREFIX()).append(key).toString(), value);
                }
                throw new MatchError((Object)tuple2);
            });
            this.SECRET_ENV_VARS().foreach((Function1 & Serializable & scala.Serializable)x0$4 -> {
                Tuple2 tuple2 = x0$4;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    String value = (String)tuple2._2();
                    return sparkConf.set(new StringBuilder(0).append(Config$.MODULE$.KUBERNETES_DRIVER_SECRET_KEY_REF_PREFIX()).append(key).toString(), value);
                }
                throw new MatchError((Object)tuple2);
            });
            this.CUSTOM_ENVS().foreach((Function1 & Serializable & scala.Serializable)x0$5 -> {
                Tuple2 tuple2 = x0$5;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    String value = (String)tuple2._2();
                    return sparkConf.set(new StringBuilder(0).append(Config$.MODULE$.KUBERNETES_DRIVER_ENV_PREFIX()).append(key).toString(), value);
                }
                throw new MatchError((Object)tuple2);
            });
            KubernetesDriverConf conf = KubernetesConf$.MODULE$.createDriverConf(sparkConf, KubernetesTestConf$.MODULE$.APP_ID(), (MainAppResource)new JavaMainAppResource((Option)None$.MODULE$), KubernetesTestConf$.MODULE$.MAIN_CLASS(), this.APP_ARGS(), (Option)None$.MODULE$);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(conf.labels());
            Map $org_scalatest_assert_macro_right = ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.SPARK_VERSION_LABEL()), (Object)package$.MODULE$.SPARK_VERSION()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.SPARK_APP_ID_LABEL()), (Object)KubernetesTestConf$.MODULE$.APP_ID()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.SPARK_APP_NAME_LABEL()), (Object)KubernetesConf$.MODULE$.getAppNameLabel(conf.appName())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.SPARK_ROLE_LABEL()), (Object)Constants$.MODULE$.SPARK_POD_DRIVER_ROLE())}))).$plus$plus(this.CUSTOM_LABELS());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(conf.annotations());
            Map<String, String> $org_scalatest_assert_macro_right2 = this.CUSTOM_ANNOTATIONS();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", $org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq($org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(conf.secretNamesToMountPaths());
            Map<String, String> $org_scalatest_assert_macro_right3 = this.SECRET_NAMES_TO_MOUNT_PATHS();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", $org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq($org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(conf.secretEnvNamesToKeyRefs());
            Map<String, String> $org_scalatest_assert_macro_right4 = this.SECRET_ENV_VARS();
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", $org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq($org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(conf.environment());
            Map<String, String> $org_scalatest_assert_macro_right5 = this.CUSTOM_ENVS();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", $org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq($org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(conf.sparkConf().get(Config$.MODULE$.MEMORY_OVERHEAD_FACTOR()));
            double $org_scalatest_assert_macro_right6 = 0.3;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
        }, new Position("KubernetesConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
        this.test("Basic executor translated fields.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            KubernetesExecutorConf conf = KubernetesConf$.MODULE$.createExecutorConf(new SparkConf(false), this.EXECUTOR_ID(), KubernetesTestConf$.MODULE$.APP_ID(), (Option)new Some((Object)this.DRIVER_POD()), KubernetesConf$.MODULE$.createExecutorConf$default$5());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(conf.executorId());
            String $org_scalatest_assert_macro_right = this.EXECUTOR_ID();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(conf.driverPod().get());
            Pod $org_scalatest_assert_macro_right2 = this.DRIVER_POD();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)conf.resourceProfileId()));
            int $org_scalatest_assert_macro_right3 = ResourceProfile$.MODULE$.DEFAULT_RESOURCE_PROFILE_ID();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111));
        }, new Position("KubernetesConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
        this.test("resource profile not default.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            KubernetesExecutorConf conf = KubernetesConf$.MODULE$.createExecutorConf(new SparkConf(false), this.EXECUTOR_ID(), KubernetesTestConf$.MODULE$.APP_ID(), (Option)new Some((Object)this.DRIVER_POD()), 10);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)conf.resourceProfileId()));
            int $org_scalatest_assert_macro_right = 10;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 121));
        }, new Position("KubernetesConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114));
        this.test("Image pull secrets.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            KubernetesExecutorConf conf = KubernetesConf$.MODULE$.createExecutorConf(new SparkConf(false).set(Config$.MODULE$.IMAGE_PULL_SECRETS(), (Object)new .colon.colon((Object)"my-secret-1", (List)new .colon.colon((Object)"my-secret-2 ", (List)Nil$.MODULE$))), this.EXECUTOR_ID(), KubernetesTestConf$.MODULE$.APP_ID(), (Option)new Some((Object)this.DRIVER_POD()), KubernetesConf$.MODULE$.createExecutorConf$default$5());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(conf.imagePullSecrets());
            Seq $org_scalatest_assert_macro_right = (Seq)new .colon.colon((Object)((LocalObjectReferenceBuilder)new LocalObjectReferenceBuilder().withName("my-secret-1")).build(), (List)new .colon.colon((Object)((LocalObjectReferenceBuilder)new LocalObjectReferenceBuilder().withName("my-secret-2")).build(), (List)Nil$.MODULE$));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 131));
        }, new Position("KubernetesConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
        this.test("Set executor labels, annotations, and secrets", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparkConf sparkConf = new SparkConf(false);
            this.CUSTOM_LABELS().foreach((Function1 & Serializable & scala.Serializable)x0$6 -> {
                Tuple2 tuple2 = x0$6;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    String value = (String)tuple2._2();
                    return sparkConf.set(new StringBuilder(0).append(Config$.MODULE$.KUBERNETES_EXECUTOR_LABEL_PREFIX()).append(key).toString(), value);
                }
                throw new MatchError((Object)tuple2);
            });
            this.CUSTOM_ANNOTATIONS().foreach((Function1 & Serializable & scala.Serializable)x0$7 -> {
                Tuple2 tuple2 = x0$7;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    String value = (String)tuple2._2();
                    return sparkConf.set(new StringBuilder(0).append(Config$.MODULE$.KUBERNETES_EXECUTOR_ANNOTATION_PREFIX()).append(key).toString(), value);
                }
                throw new MatchError((Object)tuple2);
            });
            this.SECRET_ENV_VARS().foreach((Function1 & Serializable & scala.Serializable)x0$8 -> {
                Tuple2 tuple2 = x0$8;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    String value = (String)tuple2._2();
                    return sparkConf.set(new StringBuilder(0).append(Config$.MODULE$.KUBERNETES_EXECUTOR_SECRET_KEY_REF_PREFIX()).append(key).toString(), value);
                }
                throw new MatchError((Object)tuple2);
            });
            this.SECRET_NAMES_TO_MOUNT_PATHS().foreach((Function1 & Serializable & scala.Serializable)x0$9 -> {
                Tuple2 tuple2 = x0$9;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    String value = (String)tuple2._2();
                    return sparkConf.set(new StringBuilder(0).append(Config$.MODULE$.KUBERNETES_EXECUTOR_SECRETS_PREFIX()).append(key).toString(), value);
                }
                throw new MatchError((Object)tuple2);
            });
            KubernetesExecutorConf conf = KubernetesConf$.MODULE$.createExecutorConf(sparkConf, this.EXECUTOR_ID(), KubernetesTestConf$.MODULE$.APP_ID(), (Option)new Some((Object)this.DRIVER_POD()), KubernetesConf$.MODULE$.createExecutorConf$default$5());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(conf.labels());
            Map $org_scalatest_assert_macro_right = ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.SPARK_VERSION_LABEL()), (Object)package$.MODULE$.SPARK_VERSION()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL()), (Object)this.EXECUTOR_ID()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.SPARK_APP_ID_LABEL()), (Object)KubernetesTestConf$.MODULE$.APP_ID()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.SPARK_APP_NAME_LABEL()), (Object)KubernetesConf$.MODULE$.getAppNameLabel(conf.appName())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.SPARK_ROLE_LABEL()), (Object)Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.SPARK_RESOURCE_PROFILE_ID_LABEL()), (Object)Integer.toString(ResourceProfile$.MODULE$.DEFAULT_RESOURCE_PROFILE_ID()))}))).$plus$plus(this.CUSTOM_LABELS());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 157));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(conf.annotations());
            Map<String, String> $org_scalatest_assert_macro_right2 = this.CUSTOM_ANNOTATIONS();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", $org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq($org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 164));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(conf.secretNamesToMountPaths());
            Map<String, String> $org_scalatest_assert_macro_right3 = this.SECRET_NAMES_TO_MOUNT_PATHS();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", $org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq($org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 165));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(conf.secretEnvNamesToKeyRefs());
            Map<String, String> $org_scalatest_assert_macro_right4 = this.SECRET_ENV_VARS();
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", $org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq($org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 166));
        }, new Position("KubernetesConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137));
        this.test("Verify that executorEnv key conforms to the regular specification", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparkConf sparkConf = new SparkConf(false);
            this.EXECUTOR_ENV_VARS().foreach((Function1 & Serializable & scala.Serializable)x0$10 -> {
                Tuple2 tuple2 = x0$10;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    String value = (String)tuple2._2();
                    return sparkConf.set(key, value);
                }
                throw new MatchError((Object)tuple2);
            });
            KubernetesExecutorConf conf = KubernetesConf$.MODULE$.createExecutorConf(sparkConf, this.EXECUTOR_ID(), KubernetesTestConf$.MODULE$.APP_ID(), (Option)new Some((Object)this.DRIVER_POD()), KubernetesConf$.MODULE$.createExecutorConf$default$5());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(conf.environment());
            Map $org_scalatest_assert_macro_right = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"executorEnvVars3_var3"), (Object)"executorEnvVars3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"executorEnvVars4-var4"), (Object)"executorEnvVars4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"executorEnvVars5-var5"), (Object)"executorEnvVars5/var5")}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 180));
        }, new Position("KubernetesConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 169));
        this.test("SPARK-36075: Set nodeSelector, driverNodeSelector, executorNodeSelect", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparkConf sparkConf = new SparkConf(false);
            this.CUSTOM_NODE_SELECTOR().foreach((Function1 & Serializable & scala.Serializable)x0$11 -> {
                Tuple2 tuple2 = x0$11;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    String value = (String)tuple2._2();
                    return sparkConf.set(new StringBuilder(0).append(Config$.MODULE$.KUBERNETES_NODE_SELECTOR_PREFIX()).append(key).toString(), value);
                }
                throw new MatchError((Object)tuple2);
            });
            this.CUSTOM_DRIVER_NODE_SELECTOR().foreach((Function1 & Serializable & scala.Serializable)x0$12 -> {
                Tuple2 tuple2 = x0$12;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    String value = (String)tuple2._2();
                    return sparkConf.set(new StringBuilder(0).append(Config$.MODULE$.KUBERNETES_DRIVER_NODE_SELECTOR_PREFIX()).append(key).toString(), value);
                }
                throw new MatchError((Object)tuple2);
            });
            this.CUSTOM_EXECUTOR_NODE_SELECTOR().foreach((Function1 & Serializable & scala.Serializable)x0$13 -> {
                Tuple2 tuple2 = x0$13;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    String value = (String)tuple2._2();
                    return sparkConf.set(new StringBuilder(0).append(Config$.MODULE$.KUBERNETES_EXECUTOR_NODE_SELECTOR_PREFIX()).append(key).toString(), value);
                }
                throw new MatchError((Object)tuple2);
            });
            KubernetesExecutorConf execConf = KubernetesTestConf$.MODULE$.createExecutorConf(sparkConf, KubernetesTestConf$.MODULE$.createExecutorConf$default$2(), KubernetesTestConf$.MODULE$.createExecutorConf$default$3(), KubernetesTestConf$.MODULE$.createExecutorConf$default$4(), KubernetesTestConf$.MODULE$.createExecutorConf$default$5(), KubernetesTestConf$.MODULE$.createExecutorConf$default$6(), KubernetesTestConf$.MODULE$.createExecutorConf$default$7(), KubernetesTestConf$.MODULE$.createExecutorConf$default$8());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(execConf.nodeSelector());
            Map<String, String> $org_scalatest_assert_macro_right = this.CUSTOM_NODE_SELECTOR();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 199));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(execConf.executorNodeSelector());
            Map<String, String> $org_scalatest_assert_macro_right2 = this.CUSTOM_EXECUTOR_NODE_SELECTOR();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", $org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq($org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 200));
            KubernetesDriverConf driverConf = KubernetesTestConf$.MODULE$.createDriverConf(sparkConf, KubernetesTestConf$.MODULE$.createDriverConf$default$2(), KubernetesTestConf$.MODULE$.createDriverConf$default$3(), KubernetesTestConf$.MODULE$.createDriverConf$default$4(), KubernetesTestConf$.MODULE$.createDriverConf$default$5(), KubernetesTestConf$.MODULE$.createDriverConf$default$6(), KubernetesTestConf$.MODULE$.createDriverConf$default$7(), KubernetesTestConf$.MODULE$.createDriverConf$default$8(), KubernetesTestConf$.MODULE$.createDriverConf$default$9(), KubernetesTestConf$.MODULE$.createDriverConf$default$10(), KubernetesTestConf$.MODULE$.createDriverConf$default$11(), KubernetesTestConf$.MODULE$.createDriverConf$default$12(), KubernetesTestConf$.MODULE$.createDriverConf$default$13(), KubernetesTestConf$.MODULE$.createDriverConf$default$14());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(driverConf.nodeSelector());
            Map<String, String> $org_scalatest_assert_macro_right3 = this.CUSTOM_NODE_SELECTOR();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", $org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq($org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 202));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(driverConf.driverNodeSelector());
            Map<String, String> $org_scalatest_assert_macro_right4 = this.CUSTOM_DRIVER_NODE_SELECTOR();
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", $org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq($org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 203));
        }, new Position("KubernetesConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 187));
        this.test("SPARK-36059: Set driver.scheduler and executor.scheduler", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparkConf sparkConf = new SparkConf(false);
            KubernetesExecutorConf execUnsetConf = KubernetesTestConf$.MODULE$.createExecutorConf(sparkConf, KubernetesTestConf$.MODULE$.createExecutorConf$default$2(), KubernetesTestConf$.MODULE$.createExecutorConf$default$3(), KubernetesTestConf$.MODULE$.createExecutorConf$default$4(), KubernetesTestConf$.MODULE$.createExecutorConf$default$5(), KubernetesTestConf$.MODULE$.createExecutorConf$default$6(), KubernetesTestConf$.MODULE$.createExecutorConf$default$7(), KubernetesTestConf$.MODULE$.createExecutorConf$default$8());
            KubernetesDriverConf driverUnsetConf = KubernetesTestConf$.MODULE$.createDriverConf(sparkConf, KubernetesTestConf$.MODULE$.createDriverConf$default$2(), KubernetesTestConf$.MODULE$.createDriverConf$default$3(), KubernetesTestConf$.MODULE$.createDriverConf$default$4(), KubernetesTestConf$.MODULE$.createDriverConf$default$5(), KubernetesTestConf$.MODULE$.createDriverConf$default$6(), KubernetesTestConf$.MODULE$.createDriverConf$default$7(), KubernetesTestConf$.MODULE$.createDriverConf$default$8(), KubernetesTestConf$.MODULE$.createDriverConf$default$9(), KubernetesTestConf$.MODULE$.createDriverConf$default$10(), KubernetesTestConf$.MODULE$.createDriverConf$default$11(), KubernetesTestConf$.MODULE$.createDriverConf$default$12(), KubernetesTestConf$.MODULE$.createDriverConf$default$13(), KubernetesTestConf$.MODULE$.createDriverConf$default$14());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(execUnsetConf.schedulerName());
            None$ $org_scalatest_assert_macro_right = None$.MODULE$;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 210));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(driverUnsetConf.schedulerName());
            None$ $org_scalatest_assert_macro_right2 = None$.MODULE$;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 211));
            sparkConf.set(Config$.MODULE$.KUBERNETES_SCHEDULER_NAME(), (Object)"sameScheduler");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(KubernetesTestConf$.MODULE$.createDriverConf(sparkConf, KubernetesTestConf$.MODULE$.createDriverConf$default$2(), KubernetesTestConf$.MODULE$.createDriverConf$default$3(), KubernetesTestConf$.MODULE$.createDriverConf$default$4(), KubernetesTestConf$.MODULE$.createDriverConf$default$5(), KubernetesTestConf$.MODULE$.createDriverConf$default$6(), KubernetesTestConf$.MODULE$.createDriverConf$default$7(), KubernetesTestConf$.MODULE$.createDriverConf$default$8(), KubernetesTestConf$.MODULE$.createDriverConf$default$9(), KubernetesTestConf$.MODULE$.createDriverConf$default$10(), KubernetesTestConf$.MODULE$.createDriverConf$default$11(), KubernetesTestConf$.MODULE$.createDriverConf$default$12(), KubernetesTestConf$.MODULE$.createDriverConf$default$13(), KubernetesTestConf$.MODULE$.createDriverConf$default$14()).schedulerName());
            Some $org_scalatest_assert_macro_right3 = new Some((Object)"sameScheduler");
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 215));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(KubernetesTestConf$.MODULE$.createExecutorConf(sparkConf, KubernetesTestConf$.MODULE$.createExecutorConf$default$2(), KubernetesTestConf$.MODULE$.createExecutorConf$default$3(), KubernetesTestConf$.MODULE$.createExecutorConf$default$4(), KubernetesTestConf$.MODULE$.createExecutorConf$default$5(), KubernetesTestConf$.MODULE$.createExecutorConf$default$6(), KubernetesTestConf$.MODULE$.createExecutorConf$default$7(), KubernetesTestConf$.MODULE$.createExecutorConf$default$8()).schedulerName());
            Some $org_scalatest_assert_macro_right4 = new Some((Object)"sameScheduler");
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 216));
            sparkConf.set(Config$.MODULE$.KUBERNETES_DRIVER_SCHEDULER_NAME(), (Object)"");
            sparkConf.set(Config$.MODULE$.KUBERNETES_EXECUTOR_SCHEDULER_NAME(), (Object)"");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(KubernetesTestConf$.MODULE$.createDriverConf(sparkConf, KubernetesTestConf$.MODULE$.createDriverConf$default$2(), KubernetesTestConf$.MODULE$.createDriverConf$default$3(), KubernetesTestConf$.MODULE$.createDriverConf$default$4(), KubernetesTestConf$.MODULE$.createDriverConf$default$5(), KubernetesTestConf$.MODULE$.createDriverConf$default$6(), KubernetesTestConf$.MODULE$.createDriverConf$default$7(), KubernetesTestConf$.MODULE$.createDriverConf$default$8(), KubernetesTestConf$.MODULE$.createDriverConf$default$9(), KubernetesTestConf$.MODULE$.createDriverConf$default$10(), KubernetesTestConf$.MODULE$.createDriverConf$default$11(), KubernetesTestConf$.MODULE$.createDriverConf$default$12(), KubernetesTestConf$.MODULE$.createDriverConf$default$13(), KubernetesTestConf$.MODULE$.createDriverConf$default$14()).schedulerName());
            Some $org_scalatest_assert_macro_right5 = new Some((Object)"");
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 221));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(KubernetesTestConf$.MODULE$.createExecutorConf(sparkConf, KubernetesTestConf$.MODULE$.createExecutorConf$default$2(), KubernetesTestConf$.MODULE$.createExecutorConf$default$3(), KubernetesTestConf$.MODULE$.createExecutorConf$default$4(), KubernetesTestConf$.MODULE$.createExecutorConf$default$5(), KubernetesTestConf$.MODULE$.createExecutorConf$default$6(), KubernetesTestConf$.MODULE$.createExecutorConf$default$7(), KubernetesTestConf$.MODULE$.createExecutorConf$default$8()).schedulerName());
            Some $org_scalatest_assert_macro_right6 = new Some((Object)"");
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 222));
            sparkConf.set(Config$.MODULE$.KUBERNETES_DRIVER_SCHEDULER_NAME(), (Object)"driverScheduler");
            sparkConf.set(Config$.MODULE$.KUBERNETES_EXECUTOR_SCHEDULER_NAME(), (Object)"executorScheduler");
            KubernetesExecutorConf execConf = KubernetesTestConf$.MODULE$.createExecutorConf(sparkConf, KubernetesTestConf$.MODULE$.createExecutorConf$default$2(), KubernetesTestConf$.MODULE$.createExecutorConf$default$3(), KubernetesTestConf$.MODULE$.createExecutorConf$default$4(), KubernetesTestConf$.MODULE$.createExecutorConf$default$5(), KubernetesTestConf$.MODULE$.createExecutorConf$default$6(), KubernetesTestConf$.MODULE$.createExecutorConf$default$7(), KubernetesTestConf$.MODULE$.createExecutorConf$default$8());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(execConf.schedulerName());
            Some $org_scalatest_assert_macro_right7 = new Some((Object)"executorScheduler");
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 228));
            KubernetesDriverConf driverConf = KubernetesTestConf$.MODULE$.createDriverConf(sparkConf, KubernetesTestConf$.MODULE$.createDriverConf$default$2(), KubernetesTestConf$.MODULE$.createDriverConf$default$3(), KubernetesTestConf$.MODULE$.createDriverConf$default$4(), KubernetesTestConf$.MODULE$.createDriverConf$default$5(), KubernetesTestConf$.MODULE$.createDriverConf$default$6(), KubernetesTestConf$.MODULE$.createDriverConf$default$7(), KubernetesTestConf$.MODULE$.createDriverConf$default$8(), KubernetesTestConf$.MODULE$.createDriverConf$default$9(), KubernetesTestConf$.MODULE$.createDriverConf$default$10(), KubernetesTestConf$.MODULE$.createDriverConf$default$11(), KubernetesTestConf$.MODULE$.createDriverConf$default$12(), KubernetesTestConf$.MODULE$.createDriverConf$default$13(), KubernetesTestConf$.MODULE$.createDriverConf$default$14());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(driverConf.schedulerName());
            Some $org_scalatest_assert_macro_right8 = new Some((Object)"driverScheduler");
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 230));
        }, new Position("KubernetesConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 206));
        this.test("SPARK-37735: access appId in KubernetesConf", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparkConf sparkConf = new SparkConf(false);
            KubernetesDriverConf driverConf = KubernetesTestConf$.MODULE$.createDriverConf(sparkConf, KubernetesTestConf$.MODULE$.createDriverConf$default$2(), KubernetesTestConf$.MODULE$.createDriverConf$default$3(), KubernetesTestConf$.MODULE$.createDriverConf$default$4(), KubernetesTestConf$.MODULE$.createDriverConf$default$5(), KubernetesTestConf$.MODULE$.createDriverConf$default$6(), KubernetesTestConf$.MODULE$.createDriverConf$default$7(), KubernetesTestConf$.MODULE$.createDriverConf$default$8(), KubernetesTestConf$.MODULE$.createDriverConf$default$9(), KubernetesTestConf$.MODULE$.createDriverConf$default$10(), KubernetesTestConf$.MODULE$.createDriverConf$default$11(), KubernetesTestConf$.MODULE$.createDriverConf$default$12(), KubernetesTestConf$.MODULE$.createDriverConf$default$13(), KubernetesTestConf$.MODULE$.createDriverConf$default$14());
            KubernetesExecutorConf execConf = KubernetesTestConf$.MODULE$.createExecutorConf(sparkConf, KubernetesTestConf$.MODULE$.createExecutorConf$default$2(), KubernetesTestConf$.MODULE$.createExecutorConf$default$3(), KubernetesTestConf$.MODULE$.createExecutorConf$default$4(), KubernetesTestConf$.MODULE$.createExecutorConf$default$5(), KubernetesTestConf$.MODULE$.createExecutorConf$default$6(), KubernetesTestConf$.MODULE$.createExecutorConf$default$7(), KubernetesTestConf$.MODULE$.createExecutorConf$default$8());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(driverConf.appId());
            String $org_scalatest_assert_macro_right = KubernetesTestConf$.MODULE$.APP_ID();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 237));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(execConf.appId());
            String $org_scalatest_assert_macro_right2 = KubernetesTestConf$.MODULE$.APP_ID();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 238));
        }, new Position("KubernetesConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 233));
        this.test("SPARK-36566: get app name label", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(KubernetesConf$.MODULE$.getAppNameLabel(" Job+Spark-Pi 2021"));
            String $org_scalatest_assert_macro_right = "job-spark-pi-2021";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 242));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(KubernetesConf$.MODULE$.getAppNameLabel(new StringOps(Predef$.MODULE$.augmentString("a")).$times(63)));
            String $org_scalatest_assert_macro_right2 = new StringOps(Predef$.MODULE$.augmentString("a")).$times(63);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 243));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(KubernetesConf$.MODULE$.getAppNameLabel(new StringOps(Predef$.MODULE$.augmentString("a")).$times(64)));
            String $org_scalatest_assert_macro_right3 = new StringOps(Predef$.MODULE$.augmentString("a")).$times(63);
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 244));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(KubernetesConf$.MODULE$.getAppNameLabel(new StringOps(Predef$.MODULE$.augmentString("a")).$times(253)));
            String $org_scalatest_assert_macro_right4 = new StringOps(Predef$.MODULE$.augmentString("a")).$times(63);
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 245));
        }, new Position("KubernetesConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 241));
        this.test("SPARK-38630: K8s label value should start and end with alphanumeric", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(KubernetesConf$.MODULE$.getAppNameLabel("-hello-"));
            String $org_scalatest_assert_macro_right = "hello";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 249));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(KubernetesConf$.MODULE$.getAppNameLabel(new StringBuilder(4).append(new StringOps(Predef$.MODULE$.augmentString("a")).$times(62)).append("-aaa").toString()));
            String $org_scalatest_assert_macro_right2 = new StringOps(Predef$.MODULE$.augmentString("a")).$times(62);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 250));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(KubernetesConf$.MODULE$.getAppNameLabel(new StringBuilder(1).append("-").append(new StringOps(Predef$.MODULE$.augmentString("a")).$times(63)).toString()));
            String $org_scalatest_assert_macro_right3 = new StringOps(Predef$.MODULE$.augmentString("a")).$times(62);
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 251));
        }, new Position("KubernetesConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 248));
        this.test("SPARK-40869: Resource name prefix should not start with a hyphen", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String $org_scalatest_assert_macro_left = KubernetesConf$.MODULE$.getResourceNamePrefix("_hello_");
            String $org_scalatest_assert_macro_right = "hello";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "startsWith", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.startsWith($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 255));
        }, new Position("KubernetesConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 254));
        this.test("SPARK-42906: Resource name prefix should start with an alphabetic character", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)"\u4f60\u597d-123", (List)new .colon.colon((Object)"---123", (List)new .colon.colon((Object)"123---", (List)new .colon.colon((Object)"------", (List)new .colon.colon((Object)"123456", (List)Nil$.MODULE$)))))).foreach((Function1 & Serializable & scala.Serializable)appName -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(KubernetesConf$.MODULE$.getResourceNamePrefix(appName).matches("[a-z]([-a-z0-9]*[a-z0-9])?"), "KubernetesConf.getResourceNamePrefix(appName).matches(\"[a-z]([-a-z0-9]*[a-z0-9])?\")", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KubernetesConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 262));
        }), new Position("KubernetesConfSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 258));
    }
}

