/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.k8s;

import com.google.common.primitives.UnsignedLong;
import io.fabric8.kubernetes.api.model.ListOptionsBuilder;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.Filterable;
import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.spark.SparkConf;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.annotation.Stable;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshotsStore;
import org.apache.spark.util.ThreadUtils$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@Stable
@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001\u0005\u0005e\u0001\u0002\u000b\u0016\u0001\tB\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\ti\u0001\u0011\t\u0011)A\u0005k!A\u0011\t\u0001B\u0001B\u0003%!\t\u0003\u0005G\u0001\t\u0005\t\u0015!\u0003H\u0011\u0015\t\u0006\u0001\"\u0001S\u0011\u001dA\u0006A1A\u0005\neCa!\u0018\u0001!\u0002\u0013Q\u0006\"\u00030\u0001\u0001\u0004\u0005\r\u0011\"\u0003`\u0011%\u0001\b\u00011AA\u0002\u0013%\u0011\u000fC\u0005i\u0001\u0001\u0007\t\u0011)Q\u0005A\")1\u0010\u0001C\u0001y\"9\u0011q\u0005\u0001\u0005\u0002\u0005%bABA\u0017\u0001\u0011\ty\u0003\u0003\u0005\u007f\u001b\t\u0005\t\u0015!\u0003\u0000\u0011\u0019\tV\u0002\"\u0001\u0002D!Y\u00111J\u0007A\u0002\u0003\u0007I\u0011BA'\u0011-\t9'\u0004a\u0001\u0002\u0004%I!!\u001b\t\u0017\u00055T\u00021A\u0001B\u0003&\u0011q\n\u0005\b\u0003_jA\u0011IA\u0015\u0005\u0005*\u00050Z2vi>\u0014\bk\u001c3t!>dG.\u001b8h':\f\u0007o\u001d5piN{WO]2f\u0015\t1r#A\u0002lqMT!\u0001G\r\u0002\u000f\rdWo\u001d;fe*\u0011!dG\u0001\ng\u000eDW\rZ;mKJT!\u0001H\u000f\u0002\u000bM\u0004\u0018M]6\u000b\u0005yy\u0012AB1qC\u000eDWMC\u0001!\u0003\ry'oZ\u0002\u0001'\r\u00011%\u000b\t\u0003I\u001dj\u0011!\n\u0006\u0002M\u0005)1oY1mC&\u0011\u0001&\n\u0002\u0007\u0003:L(+\u001a4\u0011\u0005)jS\"A\u0016\u000b\u00051Z\u0012\u0001C5oi\u0016\u0014h.\u00197\n\u00059Z#a\u0002'pO\u001eLgnZ\u0001\u0005G>tg\r\u0005\u00022e5\t1$\u0003\u000247\tI1\u000b]1sW\u000e{gNZ\u0001\u0011WV\u0014WM\u001d8fi\u0016\u001c8\t\\5f]R\u0004\"AN \u000e\u0003]R!\u0001O\u001d\u0002\r\rd\u0017.\u001a8u\u0015\tQ4(\u0001\u0006lk\n,'O\\3uKNT!\u0001P\u001f\u0002\u000f\u0019\f'M]5dq)\ta(\u0001\u0002j_&\u0011\u0001i\u000e\u0002\u0011\u0017V\u0014WM\u001d8fi\u0016\u001c8\t\\5f]R\fab\u001d8baNDw\u000e^:Ti>\u0014X\r\u0005\u0002D\t6\tQ#\u0003\u0002F+\tQR\t_3dkR|'\u000fU8egNs\u0017\r]:i_R\u001c8\u000b^8sK\u0006y\u0001o\u001c7mS:<W\t_3dkR|'\u000f\u0005\u0002I\u001f6\t\u0011J\u0003\u0002K\u0017\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u00051k\u0015\u0001B;uS2T\u0011AT\u0001\u0005U\u00064\u0018-\u0003\u0002Q\u0013\nA2k\u00195fIVdW\rZ#yK\u000e,Ho\u001c:TKJ4\u0018nY3\u0002\rqJg.\u001b;?)\u0015\u0019F+\u0016,X!\t\u0019\u0005\u0001C\u00030\u000b\u0001\u0007\u0001\u0007C\u00035\u000b\u0001\u0007Q\u0007C\u0003B\u000b\u0001\u0007!\tC\u0003G\u000b\u0001\u0007q)A\bq_2d\u0017N\\4J]R,'O^1m+\u0005Q\u0006C\u0001\u0013\\\u0013\taVE\u0001\u0003M_:<\u0017\u0001\u00059pY2LgnZ%oi\u0016\u0014h/\u00197!\u00035\u0001x\u000e\u001c7j]\u001e4U\u000f^;sKV\t\u0001\r\r\u0002bMB\u0019\u0001J\u00193\n\u0005\rL%A\u0002$viV\u0014X\r\u0005\u0002fM2\u0001A!C4\u000b\u0003\u0003\u0005\tQ!\u0001j\u0005\ryF%M\u0001\u000fa>dG.\u001b8h\rV$XO]3!#\tQW\u000e\u0005\u0002%W&\u0011A.\n\u0002\b\u001d>$\b.\u001b8h!\t!c.\u0003\u0002pK\t\u0019\u0011I\\=\u0002#A|G\u000e\\5oO\u001a+H/\u001e:f?\u0012*\u0017\u000f\u0006\u0002skB\u0011Ae]\u0005\u0003i\u0016\u0012A!\u00168ji\"9a/CA\u0001\u0002\u00049\u0018a\u0001=%cA\u0012\u0001P\u001f\t\u0004\u0011\nL\bCA3{\t%9W/!A\u0001\u0002\u000b\u0005\u0011.A\u0003ti\u0006\u0014H\u000f\u0006\u0002s{\")ap\u0003a\u0001\u007f\u0006i\u0011\r\u001d9mS\u000e\fG/[8o\u0013\u0012\u0004B!!\u0001\u0002\u00109!\u00111AA\u0006!\r\t)!J\u0007\u0003\u0003\u000fQ1!!\u0003\"\u0003\u0019a$o\\8u}%\u0019\u0011QB\u0013\u0002\rA\u0013X\rZ3g\u0013\u0011\t\t\"a\u0005\u0003\rM#(/\u001b8h\u0015\r\ti!\n\u0015\u0006\u0017\u0005]\u00111\u0005\t\u0005\u00033\ty\"\u0004\u0002\u0002\u001c)\u0019\u0011QD\u000e\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\"\u0005m!!B*j]\u000e,\u0017EAA\u0013\u0003\u0015\u0019d&\r\u00184\u0003\u0011\u0019Ho\u001c9\u0015\u0003IDS\u0001DA\f\u0003G\u0011A\u0002U8mYJ+hN\\1cY\u0016\u001cR!DA\u0019\u0003{\u0001B!a\r\u0002:5\u0011\u0011Q\u0007\u0006\u0004\u0003oi\u0015\u0001\u00027b]\u001eLA!a\u000f\u00026\t1qJ\u00196fGR\u0004B!a\r\u0002@%!\u0011\u0011IA\u001b\u0005!\u0011VO\u001c8bE2,G\u0003BA#\u0003\u0013\u00022!a\u0012\u000e\u001b\u0005\u0001\u0001\"\u0002@\u0010\u0001\u0004y\u0018a\u0004:fg>,(oY3WKJ\u001c\u0018n\u001c8\u0016\u0005\u0005=\u0003\u0003BA)\u0003Gj!!a\u0015\u000b\t\u0005U\u0013qK\u0001\u000baJLW.\u001b;jm\u0016\u001c(\u0002BA-\u00037\naaY8n[>t'\u0002BA/\u0003?\naaZ8pO2,'BAA1\u0003\r\u0019w.\\\u0005\u0005\u0003K\n\u0019F\u0001\u0007V]NLwM\\3e\u0019>tw-A\nsKN|WO]2f-\u0016\u00148/[8o?\u0012*\u0017\u000fF\u0002s\u0003WB\u0001B^\t\u0002\u0002\u0003\u0007\u0011qJ\u0001\u0011e\u0016\u001cx.\u001e:dKZ+'o]5p]\u0002\n1A];oQ\r\u0001\u00111\u000f\t\u0005\u00033\t)(\u0003\u0003\u0002x\u0005m!\u0001\u0004#fm\u0016dw\u000e]3s\u0003BL\u0007f\u0001\u0001\u0002|A!\u0011\u0011DA?\u0013\u0011\ty(a\u0007\u0003\rM#\u0018M\u00197f\u0001")
public class ExecutorPodsPollingSnapshotSource
implements Logging {
    public final SparkConf org$apache$spark$scheduler$cluster$k8s$ExecutorPodsPollingSnapshotSource$$conf;
    public final KubernetesClient org$apache$spark$scheduler$cluster$k8s$ExecutorPodsPollingSnapshotSource$$kubernetesClient;
    public final ExecutorPodsSnapshotsStore org$apache$spark$scheduler$cluster$k8s$ExecutorPodsPollingSnapshotSource$$snapshotsStore;
    private final ScheduledExecutorService pollingExecutor;
    private final long pollingInterval;
    private Future<?> pollingFuture;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private long pollingInterval() {
        return this.pollingInterval;
    }

    private Future<?> pollingFuture() {
        return this.pollingFuture;
    }

    private void pollingFuture_$eq(Future<?> x$1) {
        this.pollingFuture = x$1;
    }

    public void start(String applicationId) {
        Predef$.MODULE$.require(this.pollingFuture() == null, (Function0 & Serializable & scala.Serializable)() -> "Cannot start polling more than once.");
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Starting to check for executor pod state every ").append(this.pollingInterval()).append(" ms.").toString());
        this.pollingFuture_$eq(this.pollingExecutor.scheduleWithFixedDelay(new PollRunnable(this, applicationId), this.pollingInterval(), this.pollingInterval(), TimeUnit.MILLISECONDS));
    }

    public void stop() {
        if (this.pollingFuture() != null) {
            this.pollingFuture().cancel(true);
            this.pollingFuture_$eq(null);
        }
        ThreadUtils$.MODULE$.shutdown((ExecutorService)this.pollingExecutor, ThreadUtils$.MODULE$.shutdown$default$2());
    }

    public ExecutorPodsPollingSnapshotSource(SparkConf conf, KubernetesClient kubernetesClient, ExecutorPodsSnapshotsStore snapshotsStore, ScheduledExecutorService pollingExecutor) {
        this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsPollingSnapshotSource$$conf = conf;
        this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsPollingSnapshotSource$$kubernetesClient = kubernetesClient;
        this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsPollingSnapshotSource$$snapshotsStore = snapshotsStore;
        this.pollingExecutor = pollingExecutor;
        Logging.$init$((Logging)this);
        this.pollingInterval = BoxesRunTime.unboxToLong((Object)conf.get(Config$.MODULE$.KUBERNETES_EXECUTOR_API_POLLING_INTERVAL()));
    }

    private class PollRunnable
    implements Runnable {
        private final String applicationId;
        private UnsignedLong resourceVersion;
        public final /* synthetic */ ExecutorPodsPollingSnapshotSource $outer;

        private UnsignedLong resourceVersion() {
            return this.resourceVersion;
        }

        private void resourceVersion_$eq(UnsignedLong x$1) {
            this.resourceVersion = x$1;
        }

        @Override
        public void run() {
            Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsPollingSnapshotSource$PollRunnable$$$outer().logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Resynchronizing full executor pod state from Kubernetes.");
                FilterWatchListDeletable pods = (FilterWatchListDeletable)((Filterable)((Filterable)$this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsPollingSnapshotSource$PollRunnable$$$outer().org$apache$spark$scheduler$cluster$k8s$ExecutorPodsPollingSnapshotSource$$kubernetesClient.pods().withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), $this.applicationId)).withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).withoutLabel(Constants$.MODULE$.SPARK_EXECUTOR_INACTIVE_LABEL(), "true");
                if (BoxesRunTime.unboxToBoolean((Object)$this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsPollingSnapshotSource$PollRunnable$$$outer().org$apache$spark$scheduler$cluster$k8s$ExecutorPodsPollingSnapshotSource$$conf.get(Config$.MODULE$.KUBERNETES_EXECUTOR_API_POLLING_WITH_RESOURCE_VERSION()))) {
                    PodList list = (PodList)pods.list(((ListOptionsBuilder)new ListOptionsBuilder().withResourceVersion("0")).build());
                    UnsignedLong newResourceVersion = UnsignedLong.valueOf((String)list.getMetadata().getResourceVersion());
                    if (this.resourceVersion() == null || newResourceVersion.compareTo(this.resourceVersion()) >= 0) {
                        this.resourceVersion_$eq(newResourceVersion);
                        $this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsPollingSnapshotSource$PollRunnable$$$outer().org$apache$spark$scheduler$cluster$k8s$ExecutorPodsPollingSnapshotSource$$snapshotsStore.replaceSnapshot((Seq<Pod>)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(list.getItems()).asScala()).toSeq());
                    }
                } else {
                    $this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsPollingSnapshotSource$PollRunnable$$$outer().org$apache$spark$scheduler$cluster$k8s$ExecutorPodsPollingSnapshotSource$$snapshotsStore.replaceSnapshot((Seq<Pod>)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(((PodList)pods.list()).getItems()).asScala()).toSeq());
                }
            });
        }

        public /* synthetic */ ExecutorPodsPollingSnapshotSource org$apache$spark$scheduler$cluster$k8s$ExecutorPodsPollingSnapshotSource$PollRunnable$$$outer() {
            return this.$outer;
        }

        public PollRunnable(ExecutorPodsPollingSnapshotSource $outer, String applicationId) {
            this.applicationId = applicationId;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

