/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.k8s;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.Patchable;
import io.fabric8.kubernetes.client.dsl.PodResource;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesUtils$;
import org.apache.spark.scheduler.ExecutorExited;
import org.apache.spark.scheduler.ExecutorLossReason;
import org.apache.spark.scheduler.cluster.k8s.DeterministicExecutorPodsSnapshotsStore;
import org.apache.spark.scheduler.cluster.k8s.ExecutorLifecycleTestUtils$;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsLifecycleManager;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsLifecycleManager$;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshotsStore;
import org.apache.spark.scheduler.cluster.k8s.KubernetesClusterSchedulerBackend;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfter;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Status;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005%e\u0001\u0002\f\u0018\u0001\u0011BQa\f\u0001\u0005\u0002AB\u0011b\r\u0001A\u0002\u0003\u0007I\u0011\u0002\u001b\t\u0013\u0001\u0004\u0001\u0019!a\u0001\n\u0013\t\u0007\"\u00035\u0001\u0001\u0004\u0005\t\u0015)\u00036\u0011%I\u0007\u00011AA\u0002\u0013%!\u000eC\u0005p\u0001\u0001\u0007\t\u0019!C\u0005a\"I!\u000f\u0001a\u0001\u0002\u0003\u0006Ka\u001b\u0005\nu\u0002\u0001\r\u00111A\u0005\nmD1\"!\t\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002$!Q\u0011q\u0005\u0001A\u0002\u0003\u0005\u000b\u0015\u0002?\t\u0017\u0005-\u0002\u00011AA\u0002\u0013%\u0011Q\u0006\u0005\f\u0003k\u0001\u0001\u0019!a\u0001\n\u0013\t9\u0004C\u0006\u0002<\u0001\u0001\r\u0011!Q!\n\u0005=\u0002bCA \u0001\u0001\u0007\t\u0019!C\u0005\u0003\u0003B1\"!\u0013\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002L!Y\u0011q\n\u0001A\u0002\u0003\u0005\u000b\u0015BA\"\u0011-\t\t\u0006\u0001a\u0001\u0002\u0004%I!a\u0015\t\u0017\u0005m\u0003\u00011AA\u0002\u0013%\u0011Q\f\u0005\f\u0003C\u0002\u0001\u0019!A!B\u0013\t)\u0006C\u0004\u0002d\u0001!I!!\u001a\t\u000f\u0005e\u0004\u0001\"\u0003\u0002|\t\tS\t_3dkR|'\u000fU8eg2Kg-Z2zG2,W*\u00198bO\u0016\u00148+^5uK*\u0011\u0001$G\u0001\u0004Wb\u001a(B\u0001\u000e\u001c\u0003\u001d\u0019G.^:uKJT!\u0001H\u000f\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014(B\u0001\u0010 \u0003\u0015\u0019\b/\u0019:l\u0015\t\u0001\u0013%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002E\u0005\u0019qN]4\u0004\u0001M\u0019\u0001!J\u0015\u0011\u0005\u0019:S\"A\u000f\n\u0005!j\"!D*qCJ\\g)\u001e8Tk&$X\r\u0005\u0002+[5\t1F\u0003\u0002-C\u0005I1oY1mCR,7\u000f^\u0005\u0003]-\u0012aBQ3g_J,\u0017I\u001c3BMR,'/\u0001\u0004=S:LGO\u0010\u000b\u0002cA\u0011!\u0007A\u0007\u0002/\u0005\tb.Y7fI\u0016CXmY;u_J\u0004v\u000eZ:\u0016\u0003U\u0002BAN\u001f@\u00156\tqG\u0003\u00029s\u00059Q.\u001e;bE2,'B\u0001\u001e<\u0003)\u0019w\u000e\u001c7fGRLwN\u001c\u0006\u0002y\u0005)1oY1mC&\u0011ah\u000e\u0002\u0004\u001b\u0006\u0004\bC\u0001!H\u001d\t\tU\t\u0005\u0002Cw5\t1I\u0003\u0002EG\u00051AH]8pizJ!AR\u001e\u0002\rA\u0013X\rZ3g\u0013\tA\u0015J\u0001\u0004TiJLgn\u001a\u0006\u0003\rn\u00022a\u0013,Y\u001b\u0005a%BA'O\u0003\r!7\u000f\u001c\u0006\u0003\u001fB\u000baa\u00197jK:$(BA)S\u0003)YWOY3s]\u0016$Xm\u001d\u0006\u0003'R\u000bqAZ1ce&\u001c\u0007HC\u0001V\u0003\tIw.\u0003\u0002X\u0019\nY\u0001k\u001c3SKN|WO]2f!\tIf,D\u0001[\u0015\tYF,A\u0003n_\u0012,GN\u0003\u0002^!\u0006\u0019\u0011\r]5\n\u0005}S&a\u0001)pI\u0006)b.Y7fI\u0016CXmY;u_J\u0004v\u000eZ:`I\u0015\fHC\u00012g!\t\u0019G-D\u0001<\u0013\t)7H\u0001\u0003V]&$\bbB4\u0004\u0003\u0003\u0005\r!N\u0001\u0004q\u0012\n\u0014A\u00058b[\u0016$W\t_3dkR|'\u000fU8eg\u0002\n\u0001c[;cKJtW\r^3t\u00072LWM\u001c;\u0016\u0003-\u0004\"\u0001\\7\u000e\u00039K!A\u001c(\u0003!-+(-\u001a:oKR,7o\u00117jK:$\u0018\u0001F6vE\u0016\u0014h.\u001a;fg\u000ec\u0017.\u001a8u?\u0012*\u0017\u000f\u0006\u0002cc\"9qMBA\u0001\u0002\u0004Y\u0017!E6vE\u0016\u0014h.\u001a;fg\u000ec\u0017.\u001a8uA!\u0012q\u0001\u001e\t\u0003kbl\u0011A\u001e\u0006\u0003o\u0006\nq!\\8dW&$x.\u0003\u0002zm\n!Qj\\2l\u00035\u0001x\u000eZ(qKJ\fG/[8ogV\tA\u0010E\u0002~\u00037q1A`A\u000b\u001d\ry\u0018\u0011\u0003\b\u0005\u0003\u0003\tiA\u0004\u0003\u0002\u0004\u0005-a\u0002BA\u0003\u0003\u0013q1AQA\u0004\u0013\u0005\u0011\u0013B\u0001\u0011\"\u0013\tqr$C\u0002\u0002\u0010u\ta\u0001Z3qY>L\u0018b\u0001\r\u0002\u0014)\u0019\u0011qB\u000f\n\t\u0005]\u0011\u0011D\u0001\u000f\r\u0006\u0014'/[29\u00032L\u0017m]3t\u0015\rA\u00121C\u0005\u0005\u0003;\tyB\u0001\u0003Q\u001f\u0012\u001b&\u0002BA\f\u00033\t\u0011\u0003]8e\u001fB,'/\u0019;j_:\u001cx\fJ3r)\r\u0011\u0017Q\u0005\u0005\bO&\t\t\u00111\u0001}\u00039\u0001x\u000eZ(qKJ\fG/[8og\u0002B#A\u0003;\u0002!M\u001c\u0007.\u001a3vY\u0016\u0014()Y2lK:$WCAA\u0018!\r\u0011\u0014\u0011G\u0005\u0004\u0003g9\"!I&vE\u0016\u0014h.\u001a;fg\u000ecWo\u001d;feN\u001b\u0007.\u001a3vY\u0016\u0014()Y2lK:$\u0017\u0001F:dQ\u0016$W\u000f\\3s\u0005\u0006\u001c7.\u001a8e?\u0012*\u0017\u000fF\u0002c\u0003sA\u0001b\u001a\u0007\u0002\u0002\u0003\u0007\u0011qF\u0001\u0012g\u000eDW\rZ;mKJ\u0014\u0015mY6f]\u0012\u0004\u0003FA\u0007u\u00039\u0019h.\u00199tQ>$8o\u0015;pe\u0016,\"!a\u0011\u0011\u0007I\n)%C\u0002\u0002H]\u0011q\u0005R3uKJl\u0017N\\5ti&\u001cW\t_3dkR|'\u000fU8egNs\u0017\r]:i_R\u001c8\u000b^8sK\u0006\u00112O\\1qg\"|Go]*u_J,w\fJ3r)\r\u0011\u0017Q\n\u0005\tO>\t\t\u00111\u0001\u0002D\u0005y1O\\1qg\"|Go]*u_J,\u0007%A\u000bfm\u0016tG\u000fS1oI2,'/\u00168eKJ$Vm\u001d;\u0016\u0005\u0005U\u0003c\u0001\u001a\u0002X%\u0019\u0011\u0011L\f\u00039\u0015CXmY;u_J\u0004v\u000eZ:MS\u001a,7-_2mK6\u000bg.Y4fe\u0006IRM^3oi\"\u000bg\u000e\u001a7feVsG-\u001a:UKN$x\fJ3r)\r\u0011\u0017q\f\u0005\tOJ\t\t\u00111\u0001\u0002V\u00051RM^3oi\"\u000bg\u000e\u001a7feVsG-\u001a:UKN$\b%A\tfq&$(+Z1t_:lUm]:bO\u0016$raPA4\u0003c\n)\bC\u0004\u0002jQ\u0001\r!a\u001b\u0002\r\u0015DXmY%e!\r\u0019\u0017QN\u0005\u0004\u0003_Z$aA%oi\"1\u00111\u000f\u000bA\u0002a\u000b\u0011BZ1jY\u0016$\u0007k\u001c3\t\u000f\u0005]D\u00031\u0001\u0002l\u0005AQ\r_5u\u0007>$W-A\boC6,G\rU8eg\u0006s7o^3s)\t\ti\bE\u0003\u0002\u0000\u0005\u0015%*\u0004\u0002\u0002\u0002*\u0019\u00111\u0011<\u0002\u0011M$XO\u00192j]\u001eLA!a\"\u0002\u0002\n1\u0011I\\:xKJ\u0004")
public class ExecutorPodsLifecycleManagerSuite
extends SparkFunSuite
implements BeforeAndAfter {
    private Map<String, PodResource<Pod>> namedExecutorPods;
    @Mock
    private KubernetesClient kubernetesClient;
    @Mock
    private MixedOperation<Pod, PodList, PodResource<Pod>> podOperations;
    @Mock
    private KubernetesClusterSchedulerBackend schedulerBackend;
    private DeterministicExecutorPodsSnapshotsStore snapshotsStore;
    private ExecutorPodsLifecycleManager eventHandlerUnderTest;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return BeforeAndAfterEach.runTest$((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return BeforeAndAfterAll.run$((BeforeAndAfterAll)this, (Option)testName, (Args)args);
    }

    public void before(Function0<Object> fun, Position pos) {
        BeforeAndAfter.before$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public void after(Function0<Object> fun, Position pos) {
        BeforeAndAfter.after$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.runTest$((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.run$((BeforeAndAfter)this, testName, (Args)args);
    }

    public final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    private Map<String, PodResource<Pod>> namedExecutorPods() {
        return this.namedExecutorPods;
    }

    private void namedExecutorPods_$eq(Map<String, PodResource<Pod>> x$1) {
        this.namedExecutorPods = x$1;
    }

    private KubernetesClient kubernetesClient() {
        return this.kubernetesClient;
    }

    private void kubernetesClient_$eq(KubernetesClient x$1) {
        this.kubernetesClient = x$1;
    }

    private MixedOperation<Pod, PodList, PodResource<Pod>> podOperations() {
        return this.podOperations;
    }

    private void podOperations_$eq(MixedOperation<Pod, PodList, PodResource<Pod>> x$1) {
        this.podOperations = x$1;
    }

    private KubernetesClusterSchedulerBackend schedulerBackend() {
        return this.schedulerBackend;
    }

    private void schedulerBackend_$eq(KubernetesClusterSchedulerBackend x$1) {
        this.schedulerBackend = x$1;
    }

    private DeterministicExecutorPodsSnapshotsStore snapshotsStore() {
        return this.snapshotsStore;
    }

    private void snapshotsStore_$eq(DeterministicExecutorPodsSnapshotsStore x$1) {
        this.snapshotsStore = x$1;
    }

    private ExecutorPodsLifecycleManager eventHandlerUnderTest() {
        return this.eventHandlerUnderTest;
    }

    private void eventHandlerUnderTest_$eq(ExecutorPodsLifecycleManager x$1) {
        this.eventHandlerUnderTest = x$1;
    }

    private String exitReasonMessage(int execId, Pod failedPod, int exitCode) {
        Option reason = Option$.MODULE$.apply((Object)failedPod.getStatus().getReason());
        Option message = Option$.MODULE$.apply((Object)failedPod.getStatus().getMessage());
        String explained = ExecutorPodsLifecycleManager$.MODULE$.describeExitCode(exitCode);
        String exitMsg = new StringBuilder(45).append("The executor with id ").append(execId).append(" exited with exit code ").append(explained).append(".").toString();
        Option reasonStr = reason.map((Function1 & Serializable & scala.Serializable)r -> new StringBuilder(41).append("The API gave the following brief reason: ").append((String)r).toString());
        Option msgStr = message.map((Function1 & Serializable & scala.Serializable)m -> new StringBuilder(36).append("The API gave the following message: ").append((String)m).toString());
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(116).append("\n       |").append(exitMsg).append("\n       |").append(reasonStr.getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append("\n       |").append(msgStr.getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append("\n       |\n       |The API gave the following container statuses:\n       |\n       |").append(KubernetesUtils$.MODULE$.containersDescription(failedPod, KubernetesUtils$.MODULE$.containersDescription$default$2())).append("\n      ").toString())).stripMargin();
    }

    private Answer<PodResource<Pod>> namedPodsAnswer() {
        return invocation -> {
            String podName = (String)invocation.getArgument(0);
            return (PodResource)this.namedExecutorPods().getOrElseUpdate((Object)podName, (Function0 & Serializable & scala.Serializable)() -> (PodResource)Mockito.mock(PodResource.class));
        };
    }

    public ExecutorPodsLifecycleManagerSuite() {
        BeforeAndAfter.$init$((BeforeAndAfter)this);
        this.before((Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            MockitoAnnotations.openMocks((Object)((Object)this)).close();
            this.snapshotsStore_$eq(new DeterministicExecutorPodsSnapshotsStore());
            this.namedExecutorPods_$eq((Map<String, PodResource<Pod>>)Map$.MODULE$.empty());
            Mockito.when((Object)this.schedulerBackend().getExecutorsWithRegistrationTs()).thenReturn((Object)Predef$.MODULE$.Map().empty());
            Mockito.when((Object)this.kubernetesClient().pods()).thenReturn(this.podOperations());
            Mockito.when((Object)this.podOperations().withName((String)ArgumentMatchers.any(String.class))).thenAnswer(this.namedPodsAnswer());
            this.eventHandlerUnderTest_$eq(new ExecutorPodsLifecycleManager(new SparkConf(), this.kubernetesClient(), (ExecutorPodsSnapshotsStore)this.snapshotsStore()));
            this.eventHandlerUnderTest().start(this.schedulerBackend());
        }, new Position("ExecutorPodsLifecycleManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54));
        this.test("When an executor reaches error states immediately, remove from the scheduler backend.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Pod failedPod = ExecutorLifecycleTestUtils$.MODULE$.failedExecutorWithoutDeletion(1L, ExecutorLifecycleTestUtils$.MODULE$.failedExecutorWithoutDeletion$default$2());
            this.snapshotsStore().updatePod(failedPod);
            this.snapshotsStore().notifySubscribers();
            String msg = this.exitReasonMessage(1, failedPod, 1);
            ExecutorExited expectedLossReason = new ExecutorExited(1, true, msg);
            ((KubernetesClusterSchedulerBackend)Mockito.verify((Object)this.schedulerBackend())).doRemoveExecutor("1", (ExecutorLossReason)expectedLossReason);
            return ((Deletable)Mockito.verify((Object)this.namedExecutorPods().apply((Object)failedPod.getMetadata().getName()))).delete();
        }, new Position("ExecutorPodsLifecycleManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
        this.test("Don't remove executors twice from Spark but remove from K8s repeatedly.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Pod failedPod = ExecutorLifecycleTestUtils$.MODULE$.failedExecutorWithoutDeletion(1L, ExecutorLifecycleTestUtils$.MODULE$.failedExecutorWithoutDeletion$default$2());
            this.snapshotsStore().updatePod(failedPod);
            this.snapshotsStore().notifySubscribers();
            this.snapshotsStore().updatePod(failedPod);
            this.snapshotsStore().notifySubscribers();
            String msg = this.exitReasonMessage(1, failedPod, 1);
            ExecutorExited expectedLossReason = new ExecutorExited(1, true, msg);
            ((KubernetesClusterSchedulerBackend)Mockito.verify((Object)this.schedulerBackend(), (VerificationMode)Mockito.times((int)1))).doRemoveExecutor("1", (ExecutorLossReason)expectedLossReason);
            return ((Deletable)Mockito.verify((Object)this.namedExecutorPods().apply((Object)failedPod.getMetadata().getName()), (VerificationMode)Mockito.times((int)2))).delete();
        }, new Position("ExecutorPodsLifecycleManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
        this.test("When the scheduler backend lists executor ids that aren't present in the cluster, remove those executors from Spark.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Mockito.when((Object)this.schedulerBackend().getExecutorsWithRegistrationTs()).thenReturn((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"1"), (Object)BoxesRunTime.boxToLong((long)7L))})));
            long missingPodDelta = BoxesRunTime.unboxToLong((Object)this.eventHandlerUnderTest().conf().get(Config$.MODULE$.KUBERNETES_EXECUTOR_MISSING_POD_DETECT_DELTA()));
            this.snapshotsStore().clock().advance(missingPodDelta + 7L);
            this.snapshotsStore().replaceSnapshot((Seq<Pod>)((Seq)Nil$.MODULE$));
            this.snapshotsStore().notifySubscribers();
            ((KubernetesClusterSchedulerBackend)Mockito.verify((Object)this.schedulerBackend(), (VerificationMode)Mockito.never())).doRemoveExecutor((String)ArgumentMatchers.any(), (ExecutorLossReason)ArgumentMatchers.any());
            this.snapshotsStore().clock().advance(1L);
            this.snapshotsStore().replaceSnapshot((Seq<Pod>)((Seq)Nil$.MODULE$));
            this.snapshotsStore().notifySubscribers();
            String msg = "The executor with ID 1 (registered at 7 ms) was not found in the cluster at the polling time (30008 ms) which is after the accepted detect delta time (30000 ms) configured by `spark.kubernetes.executor.missingPodDetectDelta`. The executor may have been deleted but the driver missed the deletion event. Marking this executor as failed.";
            ExecutorExited expectedLossReason = new ExecutorExited(-1, false, msg);
            ((KubernetesClusterSchedulerBackend)Mockito.verify((Object)this.schedulerBackend())).doRemoveExecutor("1", (ExecutorLossReason)expectedLossReason);
        }, new Position("ExecutorPodsLifecycleManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
        this.test("Keep executor pods in k8s if configured.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Pod failedPod = ExecutorLifecycleTestUtils$.MODULE$.failedExecutorWithoutDeletion(1L, ExecutorLifecycleTestUtils$.MODULE$.failedExecutorWithoutDeletion$default$2());
            this.eventHandlerUnderTest().conf().set(Config$.MODULE$.KUBERNETES_DELETE_EXECUTORS(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
            this.snapshotsStore().updatePod(failedPod);
            this.snapshotsStore().notifySubscribers();
            String msg = this.exitReasonMessage(1, failedPod, 1);
            ExecutorExited expectedLossReason = new ExecutorExited(1, true, msg);
            ((KubernetesClusterSchedulerBackend)Mockito.verify((Object)this.schedulerBackend())).doRemoveExecutor("1", (ExecutorLossReason)expectedLossReason);
            ((Deletable)Mockito.verify((Object)this.namedExecutorPods().apply((Object)failedPod.getMetadata().getName()), (VerificationMode)Mockito.never())).delete();
            ArgumentCaptor podCaptor = ArgumentCaptor.forClass(Pod.class);
            ((Patchable)Mockito.verify((Object)this.namedExecutorPods().apply((Object)failedPod.getMetadata().getName()))).patch(podCaptor.capture());
            Pod pod = (Pod)podCaptor.getValue();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(pod.getMetadata().getLabels().get(Constants$.MODULE$.SPARK_EXECUTOR_INACTIVE_LABEL()));
            String $org_scalatest_assert_macro_right = "true";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorPodsLifecycleManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 126));
        }, new Position("ExecutorPodsLifecycleManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
    }
}

