/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.guava.collect;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sparkproject.guava.annotations.GwtCompatible;
import org.sparkproject.guava.base.Preconditions;
import org.sparkproject.guava.collect.ImmutableCollection;
import org.sparkproject.guava.collect.ImmutableList;
import org.sparkproject.guava.collect.ImmutableMap;
import org.sparkproject.guava.collect.ImmutableMapEntrySet;
import org.sparkproject.guava.collect.ImmutableMapKeySet;
import org.sparkproject.guava.collect.ImmutableMapValues;
import org.sparkproject.guava.collect.ImmutableSet;
import org.sparkproject.guava.collect.Maps;
import org.sparkproject.guava.collect.RegularImmutableMap;

@GwtCompatible(emulated=true)
final class JdkBackedImmutableMap<K, V>
extends ImmutableMap<K, V> {
    private final transient Map<K, V> delegateMap;
    private final transient ImmutableList<Map.Entry<K, V>> entries;

    static <K, V> ImmutableMap<K, V> create(int n, Map.Entry<K, V>[] entryArray) {
        HashMap<K, V> delegateMap = Maps.newHashMapWithExpectedSize(n);
        for (int i = 0; i < n; ++i) {
            entryArray[i] = RegularImmutableMap.makeImmutable(entryArray[i]);
            V oldValue = delegateMap.putIfAbsent(entryArray[i].getKey(), entryArray[i].getValue());
            if (oldValue == null) continue;
            throw JdkBackedImmutableMap.conflictException("key", entryArray[i], entryArray[i].getKey() + "=" + oldValue);
        }
        return new JdkBackedImmutableMap(delegateMap, ImmutableList.asImmutableList(entryArray, n));
    }

    JdkBackedImmutableMap(Map<K, V> delegateMap, ImmutableList<Map.Entry<K, V>> entries) {
        this.delegateMap = delegateMap;
        this.entries = entries;
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public V get(@Nullable Object key) {
        return this.delegateMap.get(key);
    }

    @Override
    ImmutableSet<Map.Entry<K, V>> createEntrySet() {
        return new ImmutableMapEntrySet.RegularEntrySet<K, V>(this, this.entries);
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        Preconditions.checkNotNull(action);
        this.entries.forEach((Consumer<Map.Entry<K, V>>)((Consumer<Map.Entry>)e -> action.accept((Object)e.getKey(), (Object)e.getValue())));
    }

    @Override
    ImmutableSet<K> createKeySet() {
        return new ImmutableMapKeySet(this);
    }

    @Override
    ImmutableCollection<V> createValues() {
        return new ImmutableMapValues(this);
    }

    @Override
    boolean isPartialView() {
        return false;
    }
}

