/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.URI;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.HiveTableRelation;
import org.apache.spark.sql.catalyst.plans.logical.InsertIntoDir;
import org.apache.spark.sql.catalyst.plans.logical.InsertIntoStatement;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.execution.command.CreateTableCommand;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.datasources.CreateTable;
import org.apache.spark.sql.hive.execution.CreateHiveTableAsSelectCommand;
import org.apache.spark.sql.hive.execution.InsertIntoHiveDirCommand;
import org.apache.spark.sql.hive.execution.InsertIntoHiveTable;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.runtime.LambdaDeserialize;

public final class HiveAnalysis$
extends Rule<LogicalPlan> {
    public static HiveAnalysis$ MODULE$;

    static {
        new HiveAnalysis$();
    }

    public LogicalPlan apply(LogicalPlan plan) {
        return plan.resolveOperators((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                boolean bl = false;
                CreateTable createTable = null;
                A1 A1 = x1;
                if (A1 instanceof InsertIntoStatement) {
                    HiveTableRelation hiveTableRelation;
                    InsertIntoStatement insertIntoStatement = (InsertIntoStatement)A1;
                    LogicalPlan r = insertIntoStatement.table();
                    Map partSpec = insertIntoStatement.partitionSpec();
                    LogicalPlan query = insertIntoStatement.query();
                    boolean overwrite = insertIntoStatement.overwrite();
                    boolean ifPartitionNotExists = insertIntoStatement.ifPartitionNotExists();
                    if (r instanceof HiveTableRelation && DDLUtils$.MODULE$.isHiveTable((hiveTableRelation = (HiveTableRelation)r).tableMeta())) {
                        return (B1)new InsertIntoHiveTable(hiveTableRelation.tableMeta(), (Map<String, Option<String>>)partSpec, query, overwrite, ifPartitionNotExists, (Seq<String>)((Seq)query.output().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.name(), Seq$.MODULE$.canBuildFrom())));
                    }
                }
                if (A1 instanceof CreateTable) {
                    bl = true;
                    createTable = (CreateTable)A1;
                    CatalogTable tableDesc = createTable.tableDesc();
                    SaveMode mode = createTable.mode();
                    Option option = createTable.query();
                    if (None$.MODULE$.equals(option) && DDLUtils$.MODULE$.isHiveTable(tableDesc)) {
                        SaveMode saveMode = mode;
                        SaveMode saveMode2 = SaveMode.Ignore;
                        return (B1)new CreateTableCommand(tableDesc, !(saveMode != null ? !saveMode.equals(saveMode2) : saveMode2 != null));
                    }
                }
                if (bl) {
                    CatalogTable tableDesc = createTable.tableDesc();
                    SaveMode mode = createTable.mode();
                    Option option = createTable.query();
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        LogicalPlan query = (LogicalPlan)some.value();
                        if (DDLUtils$.MODULE$.isHiveTable(tableDesc) && query.resolved()) {
                            return (B1)new CreateHiveTableAsSelectCommand(tableDesc, query, (Seq<String>)((Seq)query.output().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.name(), Seq$.MODULE$.canBuildFrom())), mode);
                        }
                    }
                }
                if (A1 instanceof InsertIntoDir) {
                    InsertIntoDir insertIntoDir = (InsertIntoDir)A1;
                    boolean isLocal = insertIntoDir.isLocal();
                    CatalogStorageFormat storage = insertIntoDir.storage();
                    Option provider = insertIntoDir.provider();
                    LogicalPlan child = insertIntoDir.child();
                    boolean overwrite = insertIntoDir.overwrite();
                    if (DDLUtils$.MODULE$.isHiveTable(provider) && child.resolved()) {
                        Path outputPath = new Path((URI)storage.locationUri().get());
                        if (overwrite) {
                            DDLUtils$.MODULE$.verifyNotReadPath(child, outputPath);
                        }
                        return (B1)new InsertIntoHiveDirCommand(isLocal, storage, child, overwrite, (Seq<String>)((Seq)child.output().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.name(), Seq$.MODULE$.canBuildFrom())));
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                HiveTableRelation hiveTableRelation;
                InsertIntoStatement insertIntoStatement;
                LogicalPlan r;
                boolean bl = false;
                CreateTable createTable = null;
                LogicalPlan logicalPlan = x1;
                if (logicalPlan instanceof InsertIntoStatement && (r = (insertIntoStatement = (InsertIntoStatement)logicalPlan).table()) instanceof HiveTableRelation && DDLUtils$.MODULE$.isHiveTable((hiveTableRelation = (HiveTableRelation)r).tableMeta())) {
                    return true;
                }
                if (logicalPlan instanceof CreateTable) {
                    bl = true;
                    createTable = (CreateTable)logicalPlan;
                    CatalogTable tableDesc = createTable.tableDesc();
                    Option option = createTable.query();
                    if (None$.MODULE$.equals(option) && DDLUtils$.MODULE$.isHiveTable(tableDesc)) {
                        return true;
                    }
                }
                if (bl) {
                    CatalogTable tableDesc = createTable.tableDesc();
                    Option option = createTable.query();
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        LogicalPlan query = (LogicalPlan)some.value();
                        if (DDLUtils$.MODULE$.isHiveTable(tableDesc) && query.resolved()) {
                            return true;
                        }
                    }
                }
                if (logicalPlan instanceof InsertIntoDir) {
                    InsertIntoDir insertIntoDir = (InsertIntoDir)logicalPlan;
                    Option provider = insertIntoDir.provider();
                    LogicalPlan child = insertIntoDir.child();
                    if (DDLUtils$.MODULE$.isHiveTable(provider) && child.resolved()) {
                        return true;
                    }
                }
                return false;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$2(org.apache.spark.sql.catalyst.expressions.Attribute ), $anonfun$applyOrElse$3(org.apache.spark.sql.catalyst.expressions.Attribute ), $anonfun$applyOrElse$4(org.apache.spark.sql.catalyst.expressions.Attribute )}, serializedLambda);
            }
        });
    }

    private HiveAnalysis$() {
        MODULE$ = this;
    }
}

