/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.orc;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Output;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Type;
import java.net.URI;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.hadoop.hive.ql.io.orc.SparkOrcNewRecordReader;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.orc.OrcConf;
import org.apache.spark.TaskContext$;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.RecordReaderIterator;
import org.apache.spark.sql.execution.datasources.SchemaMergeUtils$;
import org.apache.spark.sql.execution.datasources.orc.OrcFilters$;
import org.apache.spark.sql.execution.datasources.orc.OrcOptions;
import org.apache.spark.sql.execution.datasources.orc.OrcUtils$;
import org.apache.spark.sql.hive.HiveInspectors;
import org.apache.spark.sql.hive.orc.OrcFileFormat$;
import org.apache.spark.sql.hive.orc.OrcFileOperator$;
import org.apache.spark.sql.hive.orc.OrcOutputWriter;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.AnsiIntervalType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.util.SerializableConfiguration;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0001\tMa\u0001\u0002\n\u0014\u0001\u0001BQ\u0001\u000f\u0001\u0005\u0002eBQ\u0001\u0010\u0001\u0005BuBQ!\u0013\u0001\u0005BuBQA\u0013\u0001\u0005B-CQa\u001d\u0001\u0005BQDq!!\u0003\u0001\t\u0003\nY\u0001C\u0004\u0002\"\u0001!\t%a\t\t\u000f\u00055\u0004\u0001\"\u0011\u0002p!9\u00111\u0010\u0001\u0005\n\u0005ut\u0001CAL'!\u00051#!'\u0007\u000fI\u0019\u0002\u0012A\n\u0002\u001c\"1\u0001h\u0003C\u0001\u0003cC!\"a-\f\u0005\u0004%\taEA[\u0011!\t)m\u0003Q\u0001\n\u0005]\u0006bBAd\u0017\u0011\u0005\u0011\u0011\u001a\u0005\b\u0003o\\A\u0011AA}\u0011%\u0011IaCA\u0001\n\u0013\u0011YAA\u0007Pe\u000e4\u0015\u000e\\3G_Jl\u0017\r\u001e\u0006\u0003)U\t1a\u001c:d\u0015\t1r#\u0001\u0003iSZ,'B\u0001\r\u001a\u0003\r\u0019\u0018\u000f\u001c\u0006\u00035m\tQa\u001d9be.T!\u0001H\u000f\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005q\u0012aA8sO\u000e\u00011#\u0002\u0001\"O=*\u0004C\u0001\u0012&\u001b\u0005\u0019#\"\u0001\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001a#AB!osJ+g\r\u0005\u0002)[5\t\u0011F\u0003\u0002+W\u0005YA-\u0019;bg>,(oY3t\u0015\tas#A\u0005fq\u0016\u001cW\u000f^5p]&\u0011a&\u000b\u0002\u000b\r&dWMR8s[\u0006$\bC\u0001\u00194\u001b\u0005\t$B\u0001\u001a\u0018\u0003\u001d\u0019x.\u001e:dKNL!\u0001N\u0019\u0003%\u0011\u000bG/Y*pkJ\u001cWMU3hSN$XM\u001d\t\u0003EYJ!aN\u0012\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\rqJg.\u001b;?)\u0005Q\u0004CA\u001e\u0001\u001b\u0005\u0019\u0012!C:i_J$h*Y7f)\u0005q\u0004CA G\u001d\t\u0001E\t\u0005\u0002BG5\t!I\u0003\u0002D?\u00051AH]8pizJ!!R\u0012\u0002\rA\u0013X\rZ3g\u0013\t9\u0005J\u0001\u0004TiJLgn\u001a\u0006\u0003\u000b\u000e\n\u0001\u0002^8TiJLgnZ\u0001\fS:4WM]*dQ\u0016l\u0017\r\u0006\u0003M+n\u0003\u0007c\u0001\u0012N\u001f&\u0011aj\t\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005A\u001bV\"A)\u000b\u0005I;\u0012!\u0002;za\u0016\u001c\u0018B\u0001+R\u0005)\u0019FO];diRK\b/\u001a\u0005\u0006-\u0012\u0001\raV\u0001\rgB\f'o[*fgNLwN\u001c\t\u00031fk\u0011aF\u0005\u00035^\u0011Ab\u00159be.\u001cVm]:j_:DQ\u0001\u0018\u0003A\u0002u\u000bqa\u001c9uS>t7\u000f\u0005\u0003@=zr\u0014BA0I\u0005\ri\u0015\r\u001d\u0005\u0006C\u0012\u0001\rAY\u0001\u0006M&dWm\u001d\t\u0004G\"\\gB\u00013g\u001d\t\tU-C\u0001%\u0013\t97%A\u0004qC\u000e\\\u0017mZ3\n\u0005%T'aA*fc*\u0011qm\t\t\u0003YFl\u0011!\u001c\u0006\u0003]>\f!AZ:\u000b\u0005A\\\u0012A\u00025bI>|\u0007/\u0003\u0002s[\nQa)\u001b7f'R\fG/^:\u0002\u0019A\u0014X\r]1sK^\u0013\u0018\u000e^3\u0015\u000fUD\u00180a\u0001\u0002\u0006A\u0011\u0001F^\u0005\u0003o&\u00121cT;uaV$xK]5uKJ4\u0015m\u0019;pefDQAV\u0003A\u0002]CQA_\u0003A\u0002m\f1A[8c!\tax0D\u0001~\u0015\tqx.A\u0005nCB\u0014X\rZ;dK&\u0019\u0011\u0011A?\u0003\u0007){'\rC\u0003]\u000b\u0001\u0007Q\f\u0003\u0004\u0002\b\u0015\u0001\raT\u0001\u000bI\u0006$\u0018mU2iK6\f\u0017aC5t'Bd\u0017\u000e^1cY\u0016$\u0002\"!\u0004\u0002\u0014\u0005U\u0011q\u0003\t\u0004E\u0005=\u0011bAA\tG\t9!i\\8mK\u0006t\u0007\"\u0002,\u0007\u0001\u00049\u0006\"\u0002/\u0007\u0001\u0004i\u0006bBA\r\r\u0001\u0007\u00111D\u0001\u0005a\u0006$\b\u000eE\u0002m\u0003;I1!a\bn\u0005\u0011\u0001\u0016\r\u001e5\u0002\u0017\t,\u0018\u000e\u001c3SK\u0006$WM\u001d\u000b\u0011\u0003K\t\u0019%!\u0012\u0002H\u0005-\u0013qJA.\u0003;\u0002rAIA\u0014\u0003W\t\t$C\u0002\u0002*\r\u0012\u0011BR;oGRLwN\\\u0019\u0011\u0007!\ni#C\u0002\u00020%\u0012q\u0002U1si&$\u0018n\u001c8fI\u001aKG.\u001a\t\u0006G\u0006M\u0012qG\u0005\u0004\u0003kQ'\u0001C%uKJ\fGo\u001c:\u0011\t\u0005e\u0012qH\u0007\u0003\u0003wQ1!!\u0010\u0018\u0003!\u0019\u0017\r^1msN$\u0018\u0002BA!\u0003w\u00111\"\u00138uKJt\u0017\r\u001c*po\")ak\u0002a\u0001/\"1\u0011qA\u0004A\u0002=Ca!!\u0013\b\u0001\u0004y\u0015a\u00049beRLG/[8o'\u000eDW-\\1\t\r\u00055s\u00011\u0001P\u00039\u0011X-];je\u0016$7k\u00195f[\u0006Dq!!\u0015\b\u0001\u0004\t\u0019&A\u0004gS2$XM]:\u0011\t\rD\u0017Q\u000b\t\u0004a\u0005]\u0013bAA-c\t1a)\u001b7uKJDQ\u0001X\u0004A\u0002uCq!a\u0018\b\u0001\u0004\t\t'\u0001\u0006iC\u0012|w\u000e]\"p]\u001a\u0004B!a\u0019\u0002j5\u0011\u0011Q\r\u0006\u0004\u0003Oz\u0017\u0001B2p]\u001aLA!a\u001b\u0002f\ti1i\u001c8gS\u001e,(/\u0019;j_:\fqb];qa>\u0014H\u000fR1uCRK\b/\u001a\u000b\u0005\u0003\u001b\t\t\bC\u0004\u0002t!\u0001\r!!\u001e\u0002\u0011\u0011\fG/\u0019+za\u0016\u00042\u0001UA<\u0013\r\tI(\u0015\u0002\t\t\u0006$\u0018\rV=qK\u00061Ao\\&ss>$2APA@\u0011\u001d\t\t)\u0003a\u0001\u0003\u0007\u000bAa]1sOB!\u0011QQAJ\u001b\t\t9I\u0003\u0003\u0002\u0002\u0006%%\u0002BAF\u0003\u001b\u000b!![8\u000b\t\u0005=\u0015\u0011S\u0001\u0003c2T!AF8\n\t\u0005U\u0015q\u0011\u0002\u000f'\u0016\f'o\u00195Be\u001e,X.\u001a8u\u00035y%o\u0019$jY\u00164uN]7biB\u00111hC\n\b\u0017\u0005\ni*!*6!\u0011\ty*!)\u000e\u0003UI1!a)\u0016\u00059A\u0015N^3J]N\u0004Xm\u0019;peN\u0004B!a*\u0002.6\u0011\u0011\u0011\u0016\u0006\u0004\u0003WK\u0012\u0001C5oi\u0016\u0014h.\u00197\n\t\u0005=\u0016\u0011\u0016\u0002\b\u0019><w-\u001b8h)\t\tI*A\u0007T\u0003J;u\fU+T\u0011\u0012{uKT\u000b\u0003\u0003o\u0003B!!/\u0002D6\u0011\u00111\u0018\u0006\u0005\u0003{\u000by,\u0001\u0003mC:<'BAAa\u0003\u0011Q\u0017M^1\n\u0007\u001d\u000bY,\u0001\bT\u0003J;u\fU+T\u0011\u0012{uK\u0014\u0011\u0002!UtwO]1q\u001fJ\u001c7\u000b\u001e:vGR\u001cH\u0003DA\u0019\u0003\u0017\fi-a4\u0002R\u0006\u001d\bbBA4\u001f\u0001\u0007\u0011\u0011\r\u0005\u0007\u0003\u000fy\u0001\u0019A(\t\r\u00055s\u00021\u0001P\u0011\u001d\t\u0019n\u0004a\u0001\u0003+\fQ\"\\1zE\u0016\u001cFO];di>K\u0005\u0003\u0002\u0012N\u0003/\u0004B!!7\u0002d6\u0011\u00111\u001c\u0006\u0005\u0003;\fy.A\bpE*,7\r^5ogB,7\r^8s\u0015\u0011\t\t/!%\u0002\rM,'\u000fZ33\u0013\u0011\t)/a7\u0003+M#(/^2u\u001f\nTWm\u0019;J]N\u0004Xm\u0019;pe\"9\u0011\u0011^\bA\u0002\u0005-\u0018\u0001C5uKJ\fGo\u001c:\u0011\u000b\r\f\u0019$!<\u0011\t\u0005=\u00181_\u0007\u0003\u0003cT1!a#p\u0013\u0011\t)0!=\u0003\u0011]\u0013\u0018\u000e^1cY\u0016\f!c]3u%\u0016\fX/\u001b:fI\u000e{G.^7ogRA\u00111 B\u0001\u0005\u0007\u0011)\u0001E\u0002#\u0003{L1!a@$\u0005\u0011)f.\u001b;\t\u000f\u0005\u001d\u0004\u00031\u0001\u0002b!1\u0011q\u0001\tA\u0002=CaAa\u0002\u0011\u0001\u0004y\u0015a\u0004:fcV,7\u000f^3e'\u000eDW-\\1\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0005\u001b\u0001B!!/\u0003\u0010%!!\u0011CA^\u0005\u0019y%M[3di\u0002")
public class OrcFileFormat
implements FileFormat,
DataSourceRegister,
scala.Serializable {
    public static void setRequiredColumns(Configuration configuration, StructType structType, StructType structType2) {
        OrcFileFormat$.MODULE$.setRequiredColumns(configuration, structType, structType2);
    }

    public static Iterator<InternalRow> unwrapOrcStructs(Configuration configuration, StructType structType, StructType structType2, Option<StructObjectInspector> option, Iterator<Writable> iterator) {
        return OrcFileFormat$.MODULE$.unwrapOrcStructs(configuration, structType, structType2, option, iterator);
    }

    public static HiveInspectors.typeInfoConversions typeInfoConversions(DataType dataType) {
        return OrcFileFormat$.MODULE$.typeInfoConversions(dataType);
    }

    public static DataType inspectorToDataType(ObjectInspector objectInspector) {
        return OrcFileFormat$.MODULE$.inspectorToDataType(objectInspector);
    }

    public static ObjectInspector toInspector(Expression expression) {
        return OrcFileFormat$.MODULE$.toInspector(expression);
    }

    public static ObjectInspector toInspector(DataType dataType) {
        return OrcFileFormat$.MODULE$.toInspector(dataType);
    }

    public static Object[] wrap(Seq<Object> seq, Function1<Object, Object>[] function1Array, Object[] objectArray, DataType[] dataTypeArray) {
        return OrcFileFormat$.MODULE$.wrap(seq, function1Array, objectArray, dataTypeArray);
    }

    public static Object[] wrap(InternalRow internalRow, Function1<Object, Object>[] function1Array, Object[] objectArray, DataType[] dataTypeArray) {
        return OrcFileFormat$.MODULE$.wrap(internalRow, function1Array, objectArray, dataTypeArray);
    }

    public static Object wrap(Object object, ObjectInspector objectInspector, DataType dataType) {
        return OrcFileFormat$.MODULE$.wrap(object, objectInspector, dataType);
    }

    public static Function3<Object, InternalRow, Object, BoxedUnit> unwrapperFor(StructField structField) {
        return OrcFileFormat$.MODULE$.unwrapperFor(structField);
    }

    public static Function1<Object, Object> unwrapperFor(ObjectInspector objectInspector) {
        return OrcFileFormat$.MODULE$.unwrapperFor(objectInspector);
    }

    public static DataType javaTypeToDataType(Type type) {
        return OrcFileFormat$.MODULE$.javaTypeToDataType(type);
    }

    public boolean supportBatch(SparkSession sparkSession, StructType dataSchema) {
        return FileFormat.supportBatch$((FileFormat)this, (SparkSession)sparkSession, (StructType)dataSchema);
    }

    public Option<Seq<String>> vectorTypes(StructType requiredSchema, StructType partitionSchema, SQLConf sqlConf) {
        return FileFormat.vectorTypes$((FileFormat)this, (StructType)requiredSchema, (StructType)partitionSchema, (SQLConf)sqlConf);
    }

    public Function1<PartitionedFile, Iterator<InternalRow>> buildReaderWithPartitionValues(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        return FileFormat.buildReaderWithPartitionValues$((FileFormat)this, (SparkSession)sparkSession, (StructType)dataSchema, (StructType)partitionSchema, (StructType)requiredSchema, filters, options, (Configuration)hadoopConf);
    }

    public boolean supportFieldName(String name) {
        return FileFormat.supportFieldName$((FileFormat)this, (String)name);
    }

    public String shortName() {
        return "orc";
    }

    public String toString() {
        return "ORC";
    }

    public Option<StructType> inferSchema(SparkSession sparkSession, Map<String, String> options, Seq<FileStatus> files) {
        OrcOptions orcOptions = new OrcOptions(options, sparkSession.sessionState().conf());
        if (orcOptions.mergeSchema()) {
            return SchemaMergeUtils$.MODULE$.mergeSchemasInParallel(sparkSession, options, files, (Function3 & Serializable & scala.Serializable)(partFiles, conf, ignoreCorruptFiles) -> OrcFileOperator$.MODULE$.readOrcSchemasInParallel((Seq<FileStatus>)partFiles, conf, BoxesRunTime.unboxToBoolean((Object)ignoreCorruptFiles)));
        }
        boolean ignoreCorruptFiles2 = sparkSession.sessionState().conf().ignoreCorruptFiles();
        return OrcFileOperator$.MODULE$.readSchema((Seq<String>)((Seq)files.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getPath().toString(), Seq$.MODULE$.canBuildFrom())), (Option<Configuration>)new Some((Object)sparkSession.sessionState().newHadoopConfWithOptions(options)), ignoreCorruptFiles2);
    }

    public OutputWriterFactory prepareWrite(SparkSession sparkSession, Job job, Map<String, String> options, StructType dataSchema) {
        OrcOptions orcOptions = new OrcOptions(options, sparkSession.sessionState().conf());
        Configuration configuration = job.getConfiguration();
        configuration.set(OrcConf.COMPRESS.getAttribute(), orcOptions.compressionCodec());
        Configuration configuration2 = configuration;
        if (configuration2 instanceof JobConf) {
            JobConf jobConf = (JobConf)configuration2;
            jobConf.setOutputFormat(OrcOutputFormat.class);
        } else {
            configuration2.setClass("mapred.output.format.class", OrcOutputFormat.class, OutputFormat.class);
        }
        return new OutputWriterFactory(null){

            public OutputWriter newInstance(String path, StructType dataSchema, TaskAttemptContext context) {
                return new OrcOutputWriter(path, dataSchema, context);
            }

            public String getFileExtension(TaskAttemptContext context) {
                String name = context.getConfiguration().get(OrcConf.COMPRESS.getAttribute());
                String compressionExtension = (String)OrcUtils$.MODULE$.extensionsForCompressionCodecNames().getOrElse((Object)name, (Function0 & Serializable & scala.Serializable)() -> "");
                return new StringBuilder(4).append(compressionExtension).append(".orc").toString();
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$getFileExtension$1()}, serializedLambda);
            }
        };
    }

    public boolean isSplitable(SparkSession sparkSession, Map<String, String> options, Path path) {
        return true;
    }

    public Function1<PartitionedFile, Iterator<InternalRow>> buildReader(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        if (sparkSession.sessionState().conf().orcFilterPushDown()) {
            OrcFilters$.MODULE$.createFilter(requiredSchema, filters).foreach((Function1 & Serializable & scala.Serializable)f -> {
                OrcFileFormat.$anonfun$buildReader$1(this, hadoopConf, f);
                return BoxedUnit.UNIT;
            });
        }
        Broadcast broadcastedHadoopConf = sparkSession.sparkContext().broadcast((Object)new SerializableConfiguration(hadoopConf), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
        boolean ignoreCorruptFiles = sparkSession.sessionState().conf().ignoreCorruptFiles();
        return (Function1 & Serializable & scala.Serializable)file -> {
            Configuration conf = ((SerializableConfiguration)broadcastedHadoopConf.value()).value();
            Path filePath = new Path(new URI(file.filePath()));
            boolean isEmptyFile = OrcFileOperator$.MODULE$.readSchema((Seq<String>)((Seq)new .colon.colon((Object)filePath.toString(), (List)Nil$.MODULE$)), (Option<Configuration>)new Some((Object)conf), ignoreCorruptFiles).isEmpty();
            if (isEmptyFile) {
                return package$.MODULE$.Iterator().empty();
            }
            OrcFileFormat$.MODULE$.setRequiredColumns(conf, dataSchema, requiredSchema);
            Job job = Job.getInstance((Configuration)conf);
            FileInputFormat.setInputPaths((Job)job, (String)file.filePath());
            Reader orcReader = OrcFile.createReader((Path)filePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)conf));
            SparkOrcNewRecordReader orcRecordReader = new SparkOrcNewRecordReader(orcReader, conf, file.start(), file.length());
            RecordReaderIterator recordsIterator = new RecordReaderIterator((RecordReader)orcRecordReader);
            Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get()).foreach((Function1 & Serializable & scala.Serializable)x$2 -> x$2.addTaskCompletionListener((Function1 & Serializable & scala.Serializable)x$3 -> {
                recordsIterator.close();
                return BoxedUnit.UNIT;
            }));
            return OrcFileFormat$.MODULE$.unwrapOrcStructs(conf, dataSchema, requiredSchema, (Option<StructObjectInspector>)new Some((Object)((StructObjectInspector)orcRecordReader.getObjectInspector())), (Iterator<Writable>)recordsIterator);
        };
    }

    public boolean supportDataType(DataType dataType) {
        DataType dataType2 = dataType;
        if (dataType2 instanceof AnsiIntervalType) {
            return false;
        }
        if (dataType2 instanceof AtomicType) {
            return true;
        }
        if (dataType2 instanceof StructType) {
            StructType structType = (StructType)dataType2;
            return structType.forall((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)this.supportDataType(f.dataType())));
        }
        if (dataType2 instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType2;
            DataType elementType = arrayType.elementType();
            return this.supportDataType(elementType);
        }
        if (dataType2 instanceof MapType) {
            MapType mapType = (MapType)dataType2;
            DataType keyType = mapType.keyType();
            DataType valueType = mapType.valueType();
            return this.supportDataType(keyType) && this.supportDataType(valueType);
        }
        if (dataType2 instanceof UserDefinedType) {
            UserDefinedType userDefinedType = (UserDefinedType)dataType2;
            return this.supportDataType(userDefinedType.sqlType());
        }
        return false;
    }

    private String toKryo(SearchArgument sarg) {
        Kryo kryo = new Kryo();
        Output out = new Output(4096, 0xA00000);
        kryo.writeObject(out, (Object)sarg);
        out.close();
        return Base64.encodeBase64String((byte[])out.toBytes());
    }

    public static final /* synthetic */ void $anonfun$buildReader$1(OrcFileFormat $this, Configuration hadoopConf$1, SearchArgument f) {
        hadoopConf$1.set(OrcFileFormat$.MODULE$.SARG_PUSHDOWN(), $this.toKryo(f));
        hadoopConf$1.setBoolean(HiveConf.ConfVars.HIVEOPTINDEXFILTER.varname, true);
    }

    public OrcFileFormat() {
        FileFormat.$init$((FileFormat)this);
    }
}

