/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.test;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.serde2.thrift.ThriftDeserializer;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.spark.SparkContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.OneRowRelation;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.QueryExecution$;
import org.apache.spark.sql.execution.SQLExecution$;
import org.apache.spark.sql.hive.HiveExternalCatalog;
import org.apache.spark.sql.hive.HiveUtils$;
import org.apache.spark.sql.hive.client.HiveClient;
import org.apache.spark.sql.hive.test.TestHiveContext$;
import org.apache.spark.sql.hive.test.TestHiveQueryExecution;
import org.apache.spark.sql.hive.test.TestHiveSessionStateBuilder;
import org.apache.spark.sql.hive.test.TestHiveSharedState;
import org.apache.spark.sql.hive.test.TestHiveSharedState$;
import org.apache.spark.sql.hive.test.TestHiveSparkSession$TestTable$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SessionState;
import org.apache.spark.sql.internal.StaticSQLConf$;
import org.apache.spark.util.ShutdownHookManager$;
import org.apache.spark.util.Utils$;
import org.apache.thrift.protocol.TBinaryProtocol;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.sys.package$;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\t]h!\u0002!B\u0001\rk\u0005\u0002\u0003-\u0001\u0005\u000b\u0007I\u0011\u0002.\t\u0011}\u0003!\u0011!Q\u0001\nmC\u0001b\u001a\u0001\u0003\u0006\u0004%I\u0001\u001b\u0005\ta\u0002\u0011\t\u0011)A\u0005S\"A!\u000f\u0001BC\u0002\u0013%1\u000f\u0003\u0005{\u0001\t\u0005\t\u0015!\u0003u\u0011!a\bA!b\u0001\n\u0013i\b\"CA\u0002\u0001\t\u0005\t\u0015!\u0003\u007f\u0011\u001d\t)\u0001\u0001C\u0001\u0003\u000fAq!!\u0002\u0001\t\u0003\t\u0019\u0002C\u0004\u0002\u0006\u0001!\t!!\u0007\t\u0015\u0005=\u0002\u0001#b\u0001\n\u0003\n\t\u0004\u0003\u0006\u00026\u0001A)\u0019!C!\u0003oA!\"a\u000f\u0001\u0011\u000b\u0007I\u0011AA\u001f\u0011\u00191\u0005\u0001\"\u0011\u0002@!9\u0011\u0011\u0010\u0001\u0005B\u0005m\u0004bBA?\u0001\u0011\u0005\u0013q\u0010\u0005\t\u0003\u0003\u0003\u0001\u0019!C\u0005{\"I\u00111\u0011\u0001A\u0002\u0013%\u0011Q\u0011\u0005\b\u0003#\u0003\u0001\u0015)\u0003\u007f\u0011\u001d\t\u0019\n\u0001C\u0001\u0003+C!\"a'\u0001\u0011\u000b\u0007I\u0011AAO\u0011)\t\t\f\u0001EC\u0002\u0013\u0005\u0011Q\u0014\u0005\b\u0003g\u0003A\u0011BA[\u0011%\tY\f\u0001b\u0001\n\u0003\ti\f\u0003\u0005\u0002@\u0002\u0001\u000b\u0011BAQ\u0011\u001d\t\t\r\u0001C\u0001\u0003\u0007Dq!!3\u0001\t\u0013\tY\rC\u0004\u0002Z\u0002!\t!a7\t\u0013\u0005u\u0007A1A\u0005\u0002\u0005}\u0007\u0002CAy\u0001\u0001\u0006I!!9\u0007\r\u0005M\b\u0001QA{\u0011)\u0011I\u0001\tBK\u0002\u0013\u0005!1\u0002\u0005\u000b\u0005\u001b\u0001#\u0011#Q\u0001\n\u0005%\u0004B\u0003B\bA\tU\r\u0011\"\u0001\u0003\u0012!Q!q\u0004\u0011\u0003\u0012\u0003\u0006IAa\u0005\t\u000f\u0005\u0015\u0001\u0005\"\u0001\u0003\"!I!1\u0006\u0011\u0002\u0002\u0013\u0005#Q\u0006\u0005\n\u0005_\u0001\u0013\u0011!C\u0001\u0005cA\u0011B!\u000f!\u0003\u0003%\tAa\u000f\t\u0013\t\u0015\u0003%!A\u0005B\t\u001d\u0003\"\u0003B+A\u0005\u0005I\u0011\u0001B,\u0011%\u0011Y\u0006IA\u0001\n\u0003\u0012i\u0006C\u0005\u0003`\u0001\n\t\u0011\"\u0011\u0003b!I!1\r\u0011\u0002\u0002\u0013\u0005#QM\u0004\n\u0005S\u0002\u0011\u0011!E\u0001\u0005W2\u0011\"a=\u0001\u0003\u0003E\tA!\u001c\t\u000f\u0005\u0015q\u0006\"\u0001\u0003|!I!qL\u0018\u0002\u0002\u0013\u0015#\u0011\r\u0005\n\u0005{z\u0013\u0011!CA\u0005\u007fB\u0011B!\"0\u0003\u0003%\tIa\"\u0007\u000f\t\u0015\u0006!C\"\u0003(\"Ia\t\u000eB\u0001B\u0003%\u0011\u0011\u000e\u0005\b\u0003\u000b!D\u0011\u0001BU\u0011\u001d\u0011y\u000b\u000eC\u0001\u0005cC!Ba-\u0001\u0003\u0003%\u0019b\u0011B[\u0011)\u0011I\f\u0001EC\u0002\u0013\u0005!1\u0018\u0005\b\u0005\u0017\u0004A\u0011\u0001Bg\u0011\u001d\u0011\u0019\u000e\u0001C\u0001\u0005+DqA!8\u0001\t\u0003\u0011y\u000eC\u0005\u0003d\u0002\u0011\r\u0011\"\u0005\u0003f\"A!\u0011\u001f\u0001!\u0002\u0013\u00119\u000fC\u0004\u0003t\u0002!\tA!>\u0003)Q+7\u000f\u001e%jm\u0016\u001c\u0006/\u0019:l'\u0016\u001c8/[8o\u0015\t\u00115)\u0001\u0003uKN$(B\u0001#F\u0003\u0011A\u0017N^3\u000b\u0005\u0019;\u0015aA:rY*\u0011\u0001*S\u0001\u0006gB\f'o\u001b\u0006\u0003\u0015.\u000ba!\u00199bG\",'\"\u0001'\u0002\u0007=\u0014xmE\u0002\u0001\u001dJ\u0003\"a\u0014)\u000e\u0003\u0015K!!U#\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\u0011\u0005M3V\"\u0001+\u000b\u0005U;\u0015\u0001C5oi\u0016\u0014h.\u00197\n\u0005]#&a\u0002'pO\u001eLgnZ\u0001\u0003g\u000e\u001c\u0001!F\u0001\\!\taV,D\u0001H\u0013\tqvI\u0001\u0007Ta\u0006\u00148nQ8oi\u0016DH/A\u0002tG\u0002B#AA1\u0011\u0005\t,W\"A2\u000b\u0003\u0011\fQa]2bY\u0006L!AZ2\u0003\u0013Q\u0014\u0018M\\:jK:$\u0018aE3ySN$\u0018N\\4TQ\u0006\u0014X\rZ*uCR,W#A5\u0011\u0007\tTG.\u0003\u0002lG\n1q\n\u001d;j_:\u0004\"!\u001c8\u000e\u0003\u0005K!a\\!\u0003'Q+7\u000f\u001e%jm\u0016\u001c\u0006.\u0019:fIN#\u0018\r^3\u0002)\u0015D\u0018n\u001d;j]\u001e\u001c\u0006.\u0019:fIN#\u0018\r^3!Q\t!\u0011-\u0001\nqCJ,g\u000e^*fgNLwN\\*uCR,W#\u0001;\u0011\u0007\tTW\u000f\u0005\u0002wq6\tqO\u0003\u0002V\u000b&\u0011\u0011p\u001e\u0002\r'\u0016\u001c8/[8o'R\fG/Z\u0001\u0014a\u0006\u0014XM\u001c;TKN\u001c\u0018n\u001c8Ti\u0006$X\r\t\u0015\u0003\r\u0005\fa\u0002\\8bIR+7\u000f\u001e+bE2,7/F\u0001\u007f!\t\u0011w0C\u0002\u0002\u0002\r\u0014qAQ8pY\u0016\fg.A\bm_\u0006$G+Z:u)\u0006\u0014G.Z:!\u0003\u0019a\u0014N\\5u}QQ\u0011\u0011BA\u0006\u0003\u001b\ty!!\u0005\u0011\u00055\u0004\u0001\"\u0002-\n\u0001\u0004Y\u0006\"B4\n\u0001\u0004I\u0007\"\u0002:\n\u0001\u0004!\b\"\u0002?\n\u0001\u0004qHCBA\u0005\u0003+\t9\u0002C\u0003Y\u0015\u0001\u00071\fC\u0003}\u0015\u0001\u0007a\u0010\u0006\u0005\u0002\n\u0005m\u0011QDA\u0017\u0011\u0015A6\u00021\u0001\\\u0011\u001d\tyb\u0003a\u0001\u0003C\t!\u0002[5wK\u000ec\u0017.\u001a8u!\u0011\t\u0019#!\u000b\u000e\u0005\u0005\u0015\"bAA\u0014\u0007\u000611\r\\5f]RLA!a\u000b\u0002&\tQ\u0001*\u001b<f\u00072LWM\u001c;\t\u000bq\\\u0001\u0019\u0001@\u0002\u0017MD\u0017M]3e'R\fG/Z\u000b\u0002Y\"\u0012A\"Y\u0001\rg\u0016\u001c8/[8o'R\fG/Z\u000b\u0002k\"\u0012Q\"Y\u0001\r[\u0016$\u0018\rZ1uC\"Kg/Z\u000b\u0003\u0003C!B!!\u0011\u0002fA!\u00111IA0\u001d\u0011\t)%a\u0017\u000f\t\u0005\u001d\u0013\u0011\f\b\u0005\u0003\u0013\n9F\u0004\u0003\u0002L\u0005Uc\u0002BA'\u0003'j!!a\u0014\u000b\u0007\u0005E\u0013,\u0001\u0004=e>|GOP\u0005\u0002\u0019&\u0011!jS\u0005\u0003\u0011&K!AR$\n\u0007\u0005uS)A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\u0005\u00141\r\u0002\n\t\u0006$\u0018M\u0012:b[\u0016T1!!\u0018F\u0011\u001d\t9g\u0004a\u0001\u0003S\nqa]9m)\u0016DH\u000f\u0005\u0003\u0002l\u0005Md\u0002BA7\u0003_\u00022!!\u0014d\u0013\r\t\thY\u0001\u0007!J,G-\u001a4\n\t\u0005U\u0014q\u000f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005E4-\u0001\u0006oK^\u001cVm]:j_:$\"!!\u0003\u0002\u0019\rdwN\\3TKN\u001c\u0018n\u001c8\u0015\u00039\u000b1bY1dQ\u0016$\u0016M\u00197fg\u0006y1-Y2iKR\u000b'\r\\3t?\u0012*\u0017\u000f\u0006\u0003\u0002\b\u00065\u0005c\u00012\u0002\n&\u0019\u00111R2\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003\u001f\u001b\u0012\u0011!a\u0001}\u0006\u0019\u0001\u0010J\u0019\u0002\u0019\r\f7\r[3UC\ndWm\u001d\u0011\u0002\u001dM,GoQ1dQ\u0016$\u0016M\u00197fgR!\u0011qQAL\u0011\u0019\tI*\u0006a\u0001}\u0006\t1-\u0001\u0005iSZ,\u0007j\\7f+\t\ty\n\u0005\u0003cU\u0006\u0005\u0006\u0003BAR\u0003[k!!!*\u000b\t\u0005\u001d\u0016\u0011V\u0001\u0003S>T!!a+\u0002\t)\fg/Y\u0005\u0005\u0003_\u000b)K\u0001\u0003GS2,\u0017a\u00035jm\u0016$UM\u001e%p[\u0016\fA\"\u001a8w-\u0006\u0014Hk\u001c$jY\u0016$B!a(\u00028\"9\u0011\u0011\u0018\rA\u0002\u0005%\u0014AB3omZ\u000b'/A\u0007iSZ,g)\u001b7fgR+W\u000e]\u000b\u0003\u0003C\u000ba\u0002[5wK\u001aKG.Z:UK6\u0004\b%A\u0006hKRD\u0015N^3GS2,G\u0003BAQ\u0003\u000bDq!a2\u001c\u0001\u0004\tI'\u0001\u0003qCRD\u0017!D9v_R,\u0007*\u001b<f\r&dW\r\u0006\u0003\u0002N\u0006]\u0007\u0003BAh\u0003+l!!!5\u000b\t\u0005M\u0017\u0011V\u0001\u0005Y\u0006tw-\u0003\u0003\u0002v\u0005E\u0007bBAd9\u0001\u0007\u0011\u0011N\u0001\u0011O\u0016$x+\u0019:fQ>,8/\u001a)bi\"$\"!!\u001b\u0002\u001d\u0011,7o\u0019:jE\u0016$G+\u00192mKV\u0011\u0011\u0011\u001d\t\u0005\u0003G\fi/\u0004\u0002\u0002f*!\u0011q]Au\u0003!i\u0017\r^2iS:<'bAAvG\u0006!Q\u000f^5m\u0013\u0011\ty/!:\u0003\u000bI+w-\u001a=\u0002\u001f\u0011,7o\u0019:jE\u0016$G+\u00192mK\u0002\u0012\u0011\u0002V3tiR\u000b'\r\\3\u0014\u000f\u0001\n90!@\u0003\u0004A\u0019!-!?\n\u0007\u0005m8M\u0001\u0004B]f\u0014VM\u001a\t\u0004E\u0006}\u0018b\u0001B\u0001G\n9\u0001K]8ek\u000e$\bc\u00012\u0003\u0006%\u0019!qA2\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\t9\fW.Z\u000b\u0003\u0003S\nQA\\1nK\u0002\n\u0001bY8n[\u0006tGm]\u000b\u0003\u0005'\u0001RA\u0019B\u000b\u00053I1Aa\u0006d\u0005)a$/\u001a9fCR,GM\u0010\t\u0006E\nm\u0011qQ\u0005\u0004\u0005;\u0019'!\u0003$v]\u000e$\u0018n\u001c81\u0003%\u0019w.\\7b]\u0012\u001c\b\u0005\u0006\u0004\u0003$\t\u001d\"\u0011\u0006\t\u0004\u0005K\u0001S\"\u0001\u0001\t\u000f\t%Q\u00051\u0001\u0002j!9!qB\u0013A\u0002\tM\u0011!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002N\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011!1\u0007\t\u0004E\nU\u0012b\u0001B\u001cG\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!!Q\bB\"!\r\u0011'qH\u0005\u0004\u0005\u0003\u001a'aA!os\"I\u0011q\u0012\u0015\u0002\u0002\u0003\u0007!1G\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!\u0011\n\t\u0007\u0005\u0017\u0012\tF!\u0010\u000e\u0005\t5#b\u0001B(G\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\tM#Q\n\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000eF\u0002\u007f\u00053B\u0011\"a$+\u0003\u0003\u0005\rA!\u0010\u0002\u0011!\f7\u000f[\"pI\u0016$\"Aa\r\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!4\u0002\r\u0015\fX/\u00197t)\rq(q\r\u0005\n\u0003\u001fk\u0013\u0011!a\u0001\u0005{\t\u0011\u0002V3tiR\u000b'\r\\3\u0011\u0007\t\u0015rfE\u00030\u0005_\u0012\u0019\u0001\u0005\u0006\u0003r\t]\u0014\u0011\u000eB\n\u0005Gi!Aa\u001d\u000b\u0007\tU4-A\u0004sk:$\u0018.\\3\n\t\te$1\u000f\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014DC\u0001B6\u0003\u0015\t\u0007\u000f\u001d7z)\u0019\u0011\u0019C!!\u0003\u0004\"9!\u0011\u0002\u001aA\u0002\u0005%\u0004b\u0002B\be\u0001\u0007!1C\u0001\u000bk:\f\u0007\u000f\u001d7z'\u0016\fH\u0003\u0002BE\u0005C\u0003BA\u00196\u0003\fB9!M!$\u0002j\tE\u0015b\u0001BHG\n1A+\u001e9mKJ\u0002bAa%\u0003\u001c\nea\u0002\u0002BK\u00053sA!!\u0014\u0003\u0018&\tA-C\u0002\u0002^\rLAA!(\u0003 \n\u00191+Z9\u000b\u0007\u0005u3\rC\u0005\u0003$N\n\t\u00111\u0001\u0003$\u0005\u0019\u0001\u0010\n\u0019\u0003\rM\u000bHnQ7e'\r!\u0014q\u001f\u000b\u0005\u0005W\u0013i\u000bE\u0002\u0003&QBaA\u0012\u001cA\u0002\u0005%\u0014aA2nIV\u0011!\u0011D\u0001\u0007'Fd7)\u001c3\u0015\t\t-&q\u0017\u0005\u0007\rb\u0002\r!!\u001b\u0002\u0015Q,7\u000f\u001e+bE2,7/\u0006\u0002\u0003>BA!q\u0018Bc\u0003S\u0012\u0019#\u0004\u0002\u0003B*!!1\u0019B'\u0003\u001diW\u000f^1cY\u0016LAAa2\u0003B\n9\u0001*Y:i\u001b\u0006\u0004\bFA\u001db\u0003E\u0011XmZ5ti\u0016\u0014H+Z:u)\u0006\u0014G.\u001a\u000b\u0005\u0003\u000f\u0013y\rC\u0004\u0003Rj\u0002\rAa\t\u0002\u0013Q,7\u000f\u001e+bE2,\u0017aD4fi2{\u0017\rZ3e)\u0006\u0014G.Z:\u0016\u0005\t]\u0007C\u0002B`\u00053\fI'\u0003\u0003\u0003\\\n\u0005'a\u0002%bg\"\u001cV\r^\u0001\u000eY>\fG\rV3tiR\u000b'\r\\3\u0015\t\u0005\u001d%\u0011\u001d\u0005\b\u0005\u0013a\u0004\u0019AA5\u00031y'/[4j]\u0006dW\u000b\u0012$t+\t\u00119\u000f\u0005\u0004\u0003j\n5\u0018\u0011N\u0007\u0003\u0005WTA!a;\u0002*&!!q\u001eBv\u0005\r\u0019V\r^\u0001\u000e_JLw-\u001b8bYV#ei\u001d\u0011\u0002\u000bI,7/\u001a;\u0015\u0005\u0005\u001d\u0005")
public class TestHiveSparkSession
extends SparkSession {
    private transient TestHiveSharedState sharedState;
    private transient SessionState sessionState;
    private HiveClient metadataHive;
    private Option<File> hiveHome;
    private Option<File> hiveDevHome;
    private volatile TestHiveSparkSession$TestTable$ TestTable$module;
    private transient HashMap<String, TestTable> testTables;
    private final transient SparkContext sc;
    private transient Option<TestHiveSharedState> existingSharedState;
    private final transient Option<SessionState> parentSessionState;
    private final boolean loadTestTables;
    private boolean cacheTables;
    private final File hiveFilesTemp;
    private final Regex describedTable;
    private final Set<String> originalUDFs;
    private volatile transient byte bitmap$trans$0;
    private volatile byte bitmap$0;

    public TestHiveSparkSession$TestTable$ TestTable() {
        if (this.TestTable$module == null) {
            this.TestTable$lzycompute$1();
        }
        return this.TestTable$module;
    }

    private SparkContext sc() {
        return this.sc;
    }

    private Option<TestHiveSharedState> existingSharedState() {
        return this.existingSharedState;
    }

    private Option<SessionState> parentSessionState() {
        return this.parentSessionState;
    }

    private boolean loadTestTables() {
        return this.loadTestTables;
    }

    private TestHiveSharedState sharedState$lzycompute() {
        TestHiveSparkSession testHiveSparkSession = this;
        synchronized (testHiveSparkSession) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.sharedState = (TestHiveSharedState)((Object)this.existingSharedState().getOrElse((Function0 & Serializable & scala.Serializable)() -> new TestHiveSharedState(this.sc(), TestHiveSharedState$.MODULE$.$lessinit$greater$default$2())));
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        this.existingSharedState = null;
        return this.sharedState;
    }

    public TestHiveSharedState sharedState() {
        if ((byte)(this.bitmap$trans$0 & 1) == 0) {
            return this.sharedState$lzycompute();
        }
        return this.sharedState;
    }

    private SessionState sessionState$lzycompute() {
        TestHiveSparkSession testHiveSparkSession = this;
        synchronized (testHiveSparkSession) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.sessionState = new TestHiveSessionStateBuilder(this, this.parentSessionState()).build();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.sessionState;
    }

    public SessionState sessionState() {
        if ((byte)(this.bitmap$trans$0 & 2) == 0) {
            return this.sessionState$lzycompute();
        }
        return this.sessionState;
    }

    private HiveClient metadataHive$lzycompute() {
        TestHiveSparkSession testHiveSparkSession = this;
        synchronized (testHiveSparkSession) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.metadataHive = ((HiveExternalCatalog)this.sharedState().externalCatalog().unwrapped()).client().newSession();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.metadataHive;
    }

    public HiveClient metadataHive() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.metadataHive$lzycompute();
        }
        return this.metadataHive;
    }

    public Dataset<Row> sql(String sqlText) {
        return (Dataset)this.withActive((Function0 & Serializable & scala.Serializable)() -> {
            LogicalPlan plan = this.sessionState().sqlParser().parsePlan(sqlText);
            return Dataset$.MODULE$.ofRows((SparkSession)this, plan);
        });
    }

    public TestHiveSparkSession newSession() {
        return (TestHiveSparkSession)((Object)this.withActive((Function0 & Serializable & scala.Serializable)() -> new TestHiveSparkSession(this.sc(), (Option<TestHiveSharedState>)new Some((Object)this.sharedState()), (Option<SessionState>)None$.MODULE$, this.loadTestTables())));
    }

    public SparkSession cloneSession() {
        return (SparkSession)this.withActive((Function0 & Serializable & scala.Serializable)() -> {
            TestHiveSparkSession result = new TestHiveSparkSession(this.sparkContext(), (Option<TestHiveSharedState>)new Some((Object)this.sharedState()), (Option<SessionState>)new Some((Object)this.sessionState()), this.loadTestTables());
            result.sessionState();
            return result;
        });
    }

    private boolean cacheTables() {
        return this.cacheTables;
    }

    private void cacheTables_$eq(boolean x$1) {
        this.cacheTables = x$1;
    }

    public void setCacheTables(boolean c) {
        this.cacheTables_$eq(c);
    }

    private Option<File> hiveHome$lzycompute() {
        TestHiveSparkSession testHiveSparkSession = this;
        synchronized (testHiveSparkSession) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.hiveHome = this.envVarToFile("HIVE_HOME");
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.hiveHome;
    }

    public Option<File> hiveHome() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.hiveHome$lzycompute();
        }
        return this.hiveHome;
    }

    private Option<File> hiveDevHome$lzycompute() {
        TestHiveSparkSession testHiveSparkSession = this;
        synchronized (testHiveSparkSession) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.hiveDevHome = this.envVarToFile("HIVE_DEV_HOME");
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.hiveDevHome;
    }

    public Option<File> hiveDevHome() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.hiveDevHome$lzycompute();
        }
        return this.hiveDevHome;
    }

    private Option<File> envVarToFile(String envVar) {
        return Option$.MODULE$.apply((Object)System.getenv(envVar)).map((Function1 & Serializable & scala.Serializable)x$1 -> new File((String)x$1));
    }

    public File hiveFilesTemp() {
        return this.hiveFilesTemp;
    }

    public File getHiveFile(String path) {
        return new File(Thread.currentThread().getContextClassLoader().getResource(path).getFile());
    }

    private String quoteHiveFile(String path) {
        if (Utils$.MODULE$.isWindows()) {
            return this.getHiveFile(path).getPath().replace('\\', '/');
        }
        return this.getHiveFile(path).getPath();
    }

    public String getWarehousePath() {
        SQLConf tempConf = new SQLConf();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.sc().conf().getAll())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            TestHiveSparkSession.$anonfun$getWarehousePath$1(tempConf, x0$1);
            return BoxedUnit.UNIT;
        });
        return tempConf.warehousePath();
    }

    public Regex describedTable() {
        return this.describedTable;
    }

    public SqlCmd SqlCmd(String sql) {
        return new SqlCmd(this, sql);
    }

    private HashMap<String, TestTable> testTables$lzycompute() {
        TestHiveSparkSession testHiveSparkSession = this;
        synchronized (testHiveSparkSession) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.testTables = new HashMap();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.testTables;
    }

    public HashMap<String, TestTable> testTables() {
        if ((byte)(this.bitmap$trans$0 & 4) == 0) {
            return this.testTables$lzycompute();
        }
        return this.testTables;
    }

    public void registerTestTable(TestTable testTable) {
        this.testTables().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testTable.name()), (Object)testTable));
    }

    public HashSet<String> getLoadedTables() {
        return this.sharedState().loadedTables();
    }

    public void loadTestTable(String name) {
        if (this.sessionState().catalog().getTempView(name).isEmpty() && !this.sharedState().loadedTables().contains((Object)name)) {
            Object object;
            this.sharedState().loadedTables().$plus$eq((Object)name);
            this.logDebug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Loading test table ").append(name).toString());
            Seq createCmds = (Seq)this.testTables().get((Object)name).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.commands()).getOrElse((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.error(new StringBuilder(19).append("Unknown test table ").append(name).toString()));
            if (this.sparkContext().getLocalProperty(SQLExecution$.MODULE$.EXECUTION_ID_KEY()) == null) {
                object = SQLExecution$.MODULE$.withNewExecutionId(new QueryExecution((SparkSession)this, (LogicalPlan)new OneRowRelation(), QueryExecution$.MODULE$.$lessinit$greater$default$3(), QueryExecution$.MODULE$.$lessinit$greater$default$4()), SQLExecution$.MODULE$.withNewExecutionId$default$2(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> createCmds.foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                    x$3.apply$mcV$sp();
                    return BoxedUnit.UNIT;
                }));
            } else {
                createCmds.foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                    x$4.apply$mcV$sp();
                    return BoxedUnit.UNIT;
                });
                object = BoxedUnit.UNIT;
            }
            if (this.cacheTables()) {
                new SQLContext((SparkSession)this).cacheTable(name);
                return;
            }
            return;
        }
    }

    public Set<String> originalUDFs() {
        return this.originalUDFs;
    }

    public void reset() {
        try {
            ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(((LoggerContext)LogManager.getContext((boolean)false)).getConfiguration().getLoggers()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                TestHiveSparkSession.$anonfun$reset$1(x0$1);
                return BoxedUnit.UNIT;
            });
            File warehouseDir = new File(new URI(this.sparkContext().conf().get(StaticSQLConf$.MODULE$.WAREHOUSE_PATH().key())).getPath());
            Utils$.MODULE$.deleteRecursively(warehouseDir);
            warehouseDir.mkdir();
            this.sharedState().cacheManager().clearCache();
            this.sharedState().loadedTables().clear();
            this.sessionState().catalog().reset();
            this.metadataHive().reset();
            Configuration hadoopConf = this.sessionState().newHadoopConf();
            Path location = new Path(hadoopConf.get(HiveConf.ConfVars.SCRATCHDIR.varname));
            FileSystem fs = location.getFileSystem(hadoopConf);
            fs.delete(location, true);
            this.sessionState().conf().setConfString("fs.defaultFS", new File(".").toURI().toString());
            this.metadataHive().runSqlHive("RESET");
            this.metadataHive().runSqlHive("set hive.table.parameters.default=");
            this.metadataHive().runSqlHive("set hive.metastore.partition.name.whitelist.pattern=.*");
            this.sessionState().catalog().setCurrentDatabase("default");
        }
        catch (Exception e) {
            this.logError((Function0 & Serializable & scala.Serializable)() -> "FATAL ERROR: Failed to reset TestDB state.", e);
        }
    }

    private final void TestTable$lzycompute$1() {
        TestHiveSparkSession testHiveSparkSession = this;
        synchronized (testHiveSparkSession) {
            if (this.TestTable$module == null) {
                this.TestTable$module = new TestHiveSparkSession$TestTable$(this);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$new$2(TestHiveSparkSession $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            $this.sc().hadoopConfiguration().set(k, v);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$getWarehousePath$1(SQLConf tempConf$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            tempConf$1.setConfString(k, v);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private static final String createTableSQL$1(String tblName) {
        return new StringBuilder(56).append("CREATE TABLE ").append(tblName).append(" (key INT, value STRING) STORED AS textfile").toString();
    }

    public static final /* synthetic */ void $anonfun$new$5(TestHiveSparkSession $this, String ds$1, String hr) {
        $this.SqlCmd(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(118).append("\n             |LOAD DATA LOCAL INPATH '").append($this.quoteHiveFile("data/files/kv1.txt")).append("'\n             |OVERWRITE INTO TABLE srcpart PARTITION (ds='").append(ds$1).append("',hr='").append(hr).append("')\n          ").toString())).stripMargin()).cmd().apply$mcV$sp();
    }

    public static final /* synthetic */ void $anonfun$new$4(TestHiveSparkSession $this, String ds) {
        ((IterableLike)new .colon.colon((Object)"11", (List)new .colon.colon((Object)"12", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)hr -> {
            TestHiveSparkSession.$anonfun$new$5($this, ds, hr);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$7(TestHiveSparkSession $this, String ds) {
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(11), 12).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)hr -> $this.SqlCmd(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(119).append("\n             |LOAD DATA LOCAL INPATH '").append($this.quoteHiveFile("data/files/kv1.txt")).append("'\n             |OVERWRITE INTO TABLE srcpart1 PARTITION (ds='").append(ds).append("',hr='").append(hr).append("')\n          ").toString())).stripMargin()).cmd().apply$mcV$sp());
    }

    public static final /* synthetic */ void $anonfun$reset$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            LoggerConfig log = (LoggerConfig)tuple2._2();
            if (!log.getName().contains("org.apache.spark")) {
                log.setLevel(Level.WARN);
                return;
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public TestHiveSparkSession(SparkContext sc, Option<TestHiveSharedState> existingSharedState, Option<SessionState> parentSessionState, boolean loadTestTables) {
        this.sc = sc;
        this.existingSharedState = existingSharedState;
        this.parentSessionState = parentSessionState;
        this.loadTestTables = loadTestTables;
        super(sc);
        SparkSession$.MODULE$.setDefaultSession((SparkSession)this);
        SparkSession$.MODULE$.setActiveSession((SparkSession)this);
        Map metastoreTempConf = HiveUtils$.MODULE$.newTemporaryConfiguration(false).$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.METASTORE_INTEGER_JDO_PUSHDOWN.varname), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.SCRATCHDIR.varname), (Object)TestHiveContext$.MODULE$.makeScratchDir().toURI().toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.METASTORE_CLIENT_CONNECT_RETRY_DELAY.varname), (Object)"1")}))).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(existingSharedState.map((Function1 & Serializable & scala.Serializable)state -> {
            String connKey = state.sparkContext().hadoopConfiguration().get(HiveConf.ConfVars.METASTORECONNECTURLKEY.varname);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveConf.ConfVars.METASTORECONNECTURLKEY.varname), (Object)connKey);
        })));
        metastoreTempConf.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            TestHiveSparkSession.$anonfun$new$2(this, x0$1);
            return BoxedUnit.UNIT;
        });
        Object object = sc.conf().get(StaticSQLConf$.MODULE$.CATALOG_IMPLEMENTATION());
        String string = "hive";
        Predef$.MODULE$.assert(!(object != null ? !object.equals(string) : string != null));
        this.cacheTables = false;
        System.clearProperty("spark.hostPort");
        Object object2 = parentSessionState.isEmpty() ? System.setProperty("test.tmp.dir", Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()).toURI().getPath()) : BoxedUnit.UNIT;
        this.hiveFilesTemp = File.createTempFile("catalystHiveFiles", "");
        this.hiveFilesTemp().delete();
        this.hiveFilesTemp().mkdir();
        ShutdownHookManager$.MODULE$.registerShutdownDeleteDir(this.hiveFilesTemp());
        this.describedTable = new StringOps(Predef$.MODULE$.augmentString("DESCRIBE (\\w+)")).r();
        if (loadTestTables) {
            Seq hiveQTestUtilTables = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TestTable[]{new TestTable(this, "src", (Seq<Function0<BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function0[]{this.SqlCmd(TestHiveSparkSession.createTableSQL$1("src")).cmd(), this.SqlCmd(new StringBuilder(40).append("LOAD DATA LOCAL INPATH '").append(this.quoteHiveFile("data/files/kv1.txt")).append("' INTO TABLE src").toString()).cmd()})), new TestTable(this, "src1", (Seq<Function0<BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function0[]{this.SqlCmd(TestHiveSparkSession.createTableSQL$1("src1")).cmd(), this.SqlCmd(new StringBuilder(41).append("LOAD DATA LOCAL INPATH '").append(this.quoteHiveFile("data/files/kv3.txt")).append("' INTO TABLE src1").toString()).cmd()})), new TestTable(this, "srcpart", (Seq<Function0<BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function0[]{(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.SqlCmd(new StringBuilder(38).append(TestHiveSparkSession.createTableSQL$1("srcpart")).append(" PARTITIONED BY (ds STRING, hr STRING)").toString()).cmd().apply$mcV$sp();
                ((IterableLike)new .colon.colon((Object)"2008-04-08", (List)new .colon.colon((Object)"2008-04-09", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)ds -> {
                    TestHiveSparkSession.$anonfun$new$4(this, ds);
                    return BoxedUnit.UNIT;
                });
            }})), new TestTable(this, "srcpart1", (Seq<Function0<BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function0[]{(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.SqlCmd(new StringBuilder(35).append(TestHiveSparkSession.createTableSQL$1("srcpart1")).append(" PARTITIONED BY (ds STRING, hr INT)").toString()).cmd().apply$mcV$sp();
                ((IterableLike)new .colon.colon((Object)"2008-04-08", (List)new .colon.colon((Object)"2008-04-09", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)ds -> {
                    TestHiveSparkSession.$anonfun$new$7(this, ds);
                    return BoxedUnit.UNIT;
                });
            }})), new TestTable(this, "src_thrift", (Seq<Function0<BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function0[]{(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.SqlCmd(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(330).append("\n           |CREATE TABLE src_thrift(fake INT)\n           |ROW FORMAT SERDE '").append(ThriftDeserializer.class.getName()).append("'\n           |WITH SERDEPROPERTIES(\n           |  'serialization.class'='org.apache.spark.sql.hive.test.Complex',\n           |  'serialization.format'='").append(TBinaryProtocol.class.getName()).append("'\n           |)\n           |STORED AS\n           |INPUTFORMAT '").append(SequenceFileInputFormat.class.getName()).append("'\n           |OUTPUTFORMAT '").append(SequenceFileOutputFormat.class.getName()).append("'\n        ").toString())).stripMargin()).cmd().apply$mcV$sp();
                this.SqlCmd(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(81).append("\n           |LOAD DATA LOCAL INPATH '").append(this.quoteHiveFile("data/files/complex.seq")).append("'\n           |INTO TABLE src_thrift\n        ").toString())).stripMargin()).cmd().apply$mcV$sp();
            }})), new TestTable(this, "serdeins", (Seq<Function0<BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function0[]{this.SqlCmd(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(141).append("CREATE TABLE serdeins (key INT, value STRING)\n           |ROW FORMAT SERDE '").append(LazySimpleSerDe.class.getCanonicalName()).append("'\n           |WITH SERDEPROPERTIES ('field.delim'='\\t')\n         ").toString())).stripMargin()).cmd(), this.SqlCmd("INSERT OVERWRITE TABLE serdeins SELECT * FROM src").cmd()})), new TestTable(this, "episodes", (Seq<Function0<BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function0[]{this.SqlCmd(new StringOps(Predef$.MODULE$.augmentString("CREATE TABLE episodes (title STRING, air_date STRING, doctor INT)\n           |STORED AS avro\n           |TBLPROPERTIES (\n           |  'avro.schema.literal'='{\n           |    \"type\": \"record\",\n           |    \"name\": \"episodes\",\n           |    \"namespace\": \"testing.hive.avro.serde\",\n           |    \"fields\": [\n           |      {\n           |          \"name\": \"title\",\n           |          \"type\": \"string\",\n           |          \"doc\": \"episode title\"\n           |      },\n           |      {\n           |          \"name\": \"air_date\",\n           |          \"type\": \"string\",\n           |          \"doc\": \"initial date\"\n           |      },\n           |      {\n           |          \"name\": \"doctor\",\n           |          \"type\": \"int\",\n           |          \"doc\": \"main actor playing the Doctor in episode\"\n           |      }\n           |    ]\n           |  }'\n           |)\n         ")).stripMargin()).cmd(), this.SqlCmd(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(80).append("\n           |LOAD DATA LOCAL INPATH '").append(this.quoteHiveFile("data/files/episodes.avro")).append("'\n           |INTO TABLE episodes\n         ").toString())).stripMargin()).cmd()})), new TestTable(this, "episodes_part", (Seq<Function0<BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function0[]{this.SqlCmd(new StringOps(Predef$.MODULE$.augmentString("CREATE TABLE episodes_part (title STRING, air_date STRING, doctor INT)\n           |PARTITIONED BY (doctor_pt INT)\n           |STORED AS avro\n           |TBLPROPERTIES (\n           |  'avro.schema.literal'='{\n           |    \"type\": \"record\",\n           |    \"name\": \"episodes\",\n           |    \"namespace\": \"testing.hive.avro.serde\",\n           |    \"fields\": [\n           |      {\n           |          \"name\": \"title\",\n           |          \"type\": \"string\",\n           |          \"doc\": \"episode title\"\n           |      },\n           |      {\n           |          \"name\": \"air_date\",\n           |          \"type\": \"string\",\n           |          \"doc\": \"initial date\"\n           |      },\n           |      {\n           |          \"name\": \"doctor\",\n           |          \"type\": \"int\",\n           |          \"doc\": \"main actor playing the Doctor in episode\"\n           |      }\n           |    ]\n           |  }'\n           |)\n         ")).stripMargin()).cmd(), this.SqlCmd(new StringOps(Predef$.MODULE$.augmentString("\n           |ALTER TABLE episodes_part SET SERDEPROPERTIES (\n           |  'avro.schema.literal'='{\n           |    \"type\": \"record\",\n           |    \"name\": \"episodes\",\n           |    \"namespace\": \"testing.hive.avro.serde\",\n           |    \"fields\": [\n           |      {\n           |          \"name\": \"title\",\n           |          \"type\": \"string\",\n           |          \"doc\": \"episode title\"\n           |      },\n           |      {\n           |          \"name\": \"air_date\",\n           |          \"type\": \"string\",\n           |          \"doc\": \"initial date\"\n           |      },\n           |      {\n           |          \"name\": \"doctor\",\n           |          \"type\": \"int\",\n           |          \"doc\": \"main actor playing the Doctor in episode\"\n           |      }\n           |    ]\n           |  }'\n           |)\n          ")).stripMargin()).cmd(), this.SqlCmd("\n          INSERT OVERWRITE TABLE episodes_part PARTITION (doctor_pt=1)\n          SELECT title, air_date, doctor FROM episodes\n        ").cmd()})), new TestTable(this, "src_json", (Seq<Function0<BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function0[]{this.SqlCmd(new StringOps(Predef$.MODULE$.augmentString("CREATE TABLE src_json (json STRING) STORED AS TEXTFILE\n         ")).stripMargin()).cmd(), this.SqlCmd(new StringBuilder(45).append("LOAD DATA LOCAL INPATH '").append(this.quoteHiveFile("data/files/json.txt")).append("' INTO TABLE src_json").toString()).cmd()}))}));
            hiveQTestUtilTables.foreach((Function1 & Serializable & scala.Serializable)testTable -> {
                this.registerTestTable(testTable);
                return BoxedUnit.UNIT;
            });
        }
        this.originalUDFs = FunctionRegistry.getFunctionNames();
    }

    public TestHiveSparkSession(SparkContext sc, boolean loadTestTables) {
        this(sc, (Option<TestHiveSharedState>)None$.MODULE$, (Option<SessionState>)None$.MODULE$, loadTestTables);
    }

    public TestHiveSparkSession(SparkContext sc, HiveClient hiveClient, boolean loadTestTables) {
        this(sc, (Option<TestHiveSharedState>)new Some((Object)new TestHiveSharedState(sc, (Option<HiveClient>)new Some((Object)hiveClient))), (Option<SessionState>)None$.MODULE$, loadTestTables);
    }

    public class SqlCmd {
        private final String sql;
        public final /* synthetic */ TestHiveSparkSession $outer;

        public Function0<BoxedUnit> cmd() {
            return (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> new TestHiveQueryExecution($this.sql).executedPlan().executeCollect();
        }

        public /* synthetic */ TestHiveSparkSession org$apache$spark$sql$hive$test$TestHiveSparkSession$SqlCmd$$$outer() {
            return this.$outer;
        }

        public SqlCmd(TestHiveSparkSession $outer, String sql) {
            this.sql = sql;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }

    public class TestTable
    implements Product,
    scala.Serializable {
        private final String name;
        private final Seq<Function0<BoxedUnit>> commands;
        public final /* synthetic */ TestHiveSparkSession $outer;

        public String name() {
            return this.name;
        }

        public Seq<Function0<BoxedUnit>> commands() {
            return this.commands;
        }

        public String productPrefix() {
            return "TestTable";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.name();
                }
                case 1: {
                    return this.commands();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof TestTable;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof TestTable)) return false;
            if (((TestTable)object).org$apache$spark$sql$hive$test$TestHiveSparkSession$TestTable$$$outer() != this.org$apache$spark$sql$hive$test$TestHiveSparkSession$TestTable$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            TestTable testTable = (TestTable)x$1;
            String string = this.name();
            String string2 = testTable.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Seq<Function0<BoxedUnit>> seq = this.commands();
            Seq<Function0<BoxedUnit>> seq2 = testTable.commands();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            if (!testTable.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ TestHiveSparkSession org$apache$spark$sql$hive$test$TestHiveSparkSession$TestTable$$$outer() {
            return this.$outer;
        }

        public TestTable(TestHiveSparkSession $outer, String name, Seq<Function0<BoxedUnit>> commands) {
            this.name = name;
            this.commands = commands;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

