/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.execution;

import java.io.Serializable;
import org.apache.spark.metrics.source.HiveCatalogMetrics$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.QueryTest$;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.plans.logical.ColumnStat;
import org.apache.spark.sql.catalyst.plans.logical.ColumnStat$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.statsEstimation.LogicalPlanStats;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.datasources.PrunePartitionSuiteBase;
import org.apache.spark.sql.hive.client.HiveClient;
import org.apache.spark.sql.hive.execution.HiveTableScanExec;
import org.apache.spark.sql.hive.execution.PruneHiveTablePartitionsSuite$Optimize$;
import org.apache.spark.sql.hive.test.TestHiveContext;
import org.apache.spark.sql.hive.test.TestHiveSingleton;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.tags.SlowHiveTest;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@SlowHiveTest
@ScalaSignature(bytes="\u0006\u0001\u0005-a\u0001\u0002\u0006\f\u0001aAQA\n\u0001\u0005\u0002\u001dBQA\u000b\u0001\u0005B-:Q!\u000f\u0001\t\u0002i2Q\u0001\u0010\u0001\t\u0002uBQA\n\u0003\u0005\u00029Cqa\u0014\u0003C\u0002\u0013\u0005\u0001\u000b\u0003\u0004^\t\u0001\u0006I!\u0015\u0005\u0006=\u0002!\tb\u0018\u0005\u0006o\u0002!\t\u0005\u001f\u0002\u001e!J,h.\u001a%jm\u0016$\u0016M\u00197f!\u0006\u0014H/\u001b;j_:\u001c8+^5uK*\u0011A\"D\u0001\nKb,7-\u001e;j_:T!AD\b\u0002\t!Lg/\u001a\u0006\u0003!E\t1a]9m\u0015\t\u00112#A\u0003ta\u0006\u00148N\u0003\u0002\u0015+\u00051\u0011\r]1dQ\u0016T\u0011AF\u0001\u0004_J<7\u0001A\n\u0004\u0001e\u0001\u0003C\u0001\u000e\u001f\u001b\u0005Y\"B\u0001\u000f\u001e\u0003-!\u0017\r^1t_V\u00148-Z:\u000b\u00051y\u0011BA\u0010\u001c\u0005]\u0001&/\u001e8f!\u0006\u0014H/\u001b;j_:\u001cV/\u001b;f\u0005\u0006\u001cX\r\u0005\u0002\"I5\t!E\u0003\u0002$\u001b\u0005!A/Z:u\u0013\t)#EA\tUKN$\b*\u001b<f'&tw\r\\3u_:\fa\u0001P5oSRtD#\u0001\u0015\u0011\u0005%\u0002Q\"A\u0006\u0002\r\u0019|'/\\1u)\u0005a\u0003CA\u00177\u001d\tqC\u0007\u0005\u00020e5\t\u0001G\u0003\u00022/\u00051AH]8pizR\u0011aM\u0001\u0006g\u000e\fG.Y\u0005\u0003kI\na\u0001\u0015:fI\u00164\u0017BA\u001c9\u0005\u0019\u0019FO]5oO*\u0011QGM\u0001\t\u001fB$\u0018.\\5{KB\u00111\bB\u0007\u0002\u0001\tAq\n\u001d;j[&TXm\u0005\u0002\u0005}A\u0019q\b\u0012$\u000e\u0003\u0001S!!\u0011\"\u0002\u000bI,H.Z:\u000b\u0005\r{\u0011\u0001C2bi\u0006d\u0017p\u001d;\n\u0005\u0015\u0003%\u0001\u0004*vY\u0016,\u00050Z2vi>\u0014\bCA$M\u001b\u0005A%BA%K\u0003\u001dawnZ5dC2T!a\u0013\"\u0002\u000bAd\u0017M\\:\n\u00055C%a\u0003'pO&\u001c\u0017\r\u001c)mC:$\u0012AO\u0001\bE\u0006$8\r[3t+\u0005\t\u0006c\u0001*X36\t1K\u0003\u0002U+\u0006I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0003-J\n!bY8mY\u0016\u001cG/[8o\u0013\tA6K\u0001\u0003MSN$\bC\u0001.\\\u001b\u0005!\u0011B\u0001/E\u0005\u0015\u0011\u0015\r^2i\u0003!\u0011\u0017\r^2iKN\u0004\u0013!G2pY2,7\r\u001e)beRLG/[8o\r&dG/\u001a:t\r:$\u0012\u0001\u0019\t\u0005C\n$\u0007.D\u00013\u0013\t\u0019'GA\bQCJ$\u0018.\u00197Gk:\u001cG/[8o!\t)g-D\u0001\u001e\u0013\t9WDA\u0005Ta\u0006\u00148\u000e\u00157b]B\u0019\u0011N\\9\u000f\u0005)dgBA\u0018l\u0013\u0005\u0019\u0014BA73\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u001c9\u0003\u0007M+\u0017O\u0003\u0002neA\u0011!/^\u0007\u0002g*\u0011AOQ\u0001\fKb\u0004(/Z:tS>t7/\u0003\u0002wg\nQQ\t\u001f9sKN\u001c\u0018n\u001c8\u00021\u001d,GoU2b]\u0016CXm\u0019)beRLG/[8o'&TX\r\u0006\u0002zyB\u0011\u0011M_\u0005\u0003wJ\u0012A\u0001T8oO\")Q0\u0003a\u0001I\u0006!\u0001\u000f\\1oQ\t\u0001q\u0010\u0005\u0003\u0002\u0002\u0005\u001dQBAA\u0002\u0015\r\t)!E\u0001\u0005i\u0006<7/\u0003\u0003\u0002\n\u0005\r!\u0001D*m_^D\u0015N^3UKN$\b")
public class PruneHiveTablePartitionsSuite
extends PrunePartitionSuiteBase
implements TestHiveSingleton {
    private volatile PruneHiveTablePartitionsSuite$Optimize$ Optimize$module;
    private final boolean enableAutoThreadAudit;
    private final SparkSession spark;
    private final TestHiveContext hiveContext;
    private final HiveClient hiveClient;

    @Override
    public /* synthetic */ void org$apache$spark$sql$hive$test$TestHiveSingleton$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public void afterAll() {
        TestHiveSingleton.afterAll$(this);
    }

    public PruneHiveTablePartitionsSuite$Optimize$ Optimize() {
        if (this.Optimize$module == null) {
            this.Optimize$lzycompute$1();
        }
        return this.Optimize$module;
    }

    @Override
    public boolean enableAutoThreadAudit() {
        return this.enableAutoThreadAudit;
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public TestHiveContext hiveContext() {
        return this.hiveContext;
    }

    @Override
    public HiveClient hiveClient() {
        return this.hiveClient;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$enableAutoThreadAudit_$eq(boolean x$1) {
        this.enableAutoThreadAudit = x$1;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$hiveContext_$eq(TestHiveContext x$1) {
        this.hiveContext = x$1;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$hiveClient_$eq(HiveClient x$1) {
        this.hiveClient = x$1;
    }

    public String format() {
        return "hive";
    }

    public PartialFunction<SparkPlan, Seq<Expression>> collectPartitionFiltersFn() {
        return new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof HiveTableScanExec) {
                    HiveTableScanExec hiveTableScanExec = (HiveTableScanExec)A1;
                    return (B1)hiveTableScanExec.partitionPruningPred();
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(SparkPlan x1) {
                SparkPlan sparkPlan = x1;
                return sparkPlan instanceof HiveTableScanExec;
            }
        };
    }

    public long getScanExecPartitionSize(SparkPlan plan) {
        return ((HiveTableScanExec)plan.collectFirst((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof HiveTableScanExec) {
                    HiveTableScanExec hiveTableScanExec = (HiveTableScanExec)A1;
                    return (B1)hiveTableScanExec;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(SparkPlan x1) {
                SparkPlan sparkPlan = x1;
                return sparkPlan instanceof HiveTableScanExec;
            }
        }).get()).prunedPartitions().size();
    }

    private final void Optimize$lzycompute$1() {
        PruneHiveTablePartitionsSuite pruneHiveTablePartitionsSuite = this;
        synchronized (pruneHiveTablePartitionsSuite) {
            if (this.Optimize$module == null) {
                this.Optimize$module = new PruneHiveTablePartitionsSuite$Optimize$(this);
            }
        }
    }

    public static final /* synthetic */ Dataset $anonfun$new$3(PruneHiveTablePartitionsSuite $this, int part) {
        return (Dataset)$this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(92).append("\n            |INSERT OVERWRITE TABLE test PARTITION (p='").append(part).append("')\n            |select col from temp").toString())).stripMargin());
    }

    public static final /* synthetic */ Dataset $anonfun$new$7(PruneHiveTablePartitionsSuite $this, int part) {
        return (Dataset)$this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(103).append("\n               |INSERT OVERWRITE TABLE t PARTITION (p0='").append(part).append("', p1='").append(part).append("')\n               |SELECT col FROM temp").toString())).stripMargin());
    }

    public static final /* synthetic */ String $anonfun$new$8(int i) {
        return new StringBuilder(21).append("(p0 = '").append(i).append("' AND p1 = '").append(i).append("')").toString();
    }

    public PruneHiveTablePartitionsSuite() {
        TestHiveSingleton.$init$(this);
        this.test("SPARK-15616: statistics pruned after going through PruneHiveTablePartitions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test", "temp"}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString("\n          |CREATE TABLE test(i int)\n          |PARTITIONED BY (p int)\n          |STORED AS textfile")).stripMargin());
            this.spark().range(0L, 1000L, 1L).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id as col"})).createOrReplaceTempView("temp");
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4}))).foreach((Function1 & Serializable & scala.Serializable)part -> PruneHiveTablePartitionsSuite.$anonfun$new$3(this, BoxesRunTime.unboxToInt((Object)part)));
            LogicalPlan analyzed1 = ((Dataset)this.sql().apply((Object)"select i from test where p > 0")).queryExecution().analyzed();
            LogicalPlan analyzed2 = ((Dataset)this.sql().apply((Object)"select i from test where p = 1")).queryExecution().analyzed();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(((LogicalPlanStats)this.Optimize().execute((TreeNode)analyzed1)).stats().sizeInBytes().$div(BigInt$.MODULE$.int2bigInt(4)));
            BigInt $org_scalatest_assert_macro_right = ((LogicalPlanStats)this.Optimize().execute((TreeNode)analyzed2)).stats().sizeInBytes();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PruneHiveTablePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
        }), new Position("PruneHiveTablePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 44));
        this.test("Avoid generating too many predicates in partition pruning", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempView((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"temp"}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(111).append("\n             |CREATE TABLE t(i INT, p0 INT, p1 INT)\n             |USING ").append(this.format()).append("\n             |PARTITIONED BY (p0, p1)").toString())).stripMargin());
            this.spark().range(0L, 10L, 1L).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id as col"})).createOrReplaceTempView("temp");
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 25).foreach((Function1 & Serializable & scala.Serializable)part -> PruneHiveTablePartitionsSuite.$anonfun$new$7(this, BoxesRunTime.unboxToInt((Object)part)));
            int scale = 20;
            String predicate = ((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), scale).map((Function1 & Serializable & scala.Serializable)i -> PruneHiveTablePartitionsSuite.$anonfun$new$8(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).mkString(" OR ");
            String expectedStr = "(((((((p0 = 1) && (p1 = 1)) || ((p0 = 2) && (p1 = 2))) || ((p0 = 3) && (p1 = 3))) || (((p0 = 4) && (p1 = 4)) || ((p0 = 5) && (p1 = 5)))) || (((((p0 = 6) && (p1 = 6)) || ((p0 = 7) && (p1 = 7))) || ((p0 = 8) && (p1 = 8))) || (((p0 = 9) && (p1 = 9)) || ((p0 = 10) && (p1 = 10))))) || ((((((p0 = 11) && (p1 = 11)) || ((p0 = 12) && (p1 = 12))) || ((p0 = 13) && (p1 = 13))) || (((p0 = 14) && (p1 = 14)) || ((p0 = 15) && (p1 = 15)))) || (((((p0 = 16) && (p1 = 16)) || ((p0 = 17) && (p1 = 17))) || ((p0 = 18) && (p1 = 18))) || (((p0 = 19) && (p1 = 19)) || ((p0 = 20) && (p1 = 20))))))";
            this.assertPrunedPartitions(new StringBuilder(22).append("SELECT * FROM t WHERE ").append(predicate).toString(), scale, expectedStr);
        })), new Position("PruneHiveTablePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
        this.test("SPARK-34119: Keep necessary stats after PruneHiveTablePartitions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SPARK_34119"}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.CBO_ENABLED().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hive.exec.dynamic.partition.mode"), (Object)"nonstrict")}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)new StringBuilder(121).append("CREATE TABLE SPARK_34119 PARTITIONED BY (p) STORED AS textfile AS ").append("(SELECT id, CAST(id % 5 AS STRING) AS p FROM range(20))").toString());
            this.sql().apply((Object)"ANALYZE TABLE SPARK_34119 COMPUTE STATISTICS FOR ALL COLUMNS");
            this.checkOptimizedPlanStats((Dataset)this.sql().apply((Object)"SELECT id FROM SPARK_34119"), BigInt$.MODULE$.long2bigInt(320L), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(20)), (Seq)new .colon.colon((Object)new ColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(20)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)19)), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)LongType$.MODULE$.defaultSize())), (Option)new Some((Object)BoxesRunTime.boxToLong((long)LongType$.MODULE$.defaultSize())), ColumnStat$.MODULE$.apply$default$7(), ColumnStat$.MODULE$.apply$default$8()), (List)Nil$.MODULE$));
            this.checkOptimizedPlanStats((Dataset)this.sql().apply((Object)"SELECT id FROM SPARK_34119 WHERE p = '2'"), BigInt$.MODULE$.long2bigInt(64L), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(4)), (Seq)new .colon.colon((Object)new ColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(4)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)19)), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)LongType$.MODULE$.defaultSize())), (Option)new Some((Object)BoxesRunTime.boxToLong((long)LongType$.MODULE$.defaultSize())), ColumnStat$.MODULE$.apply$default$7(), ColumnStat$.MODULE$.apply$default$8()), (List)Nil$.MODULE$));
        })), new Position("PruneHiveTablePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
        this.test("SPARK-36128: spark.sql.hive.metastorePartitionPruning should work for file data sources", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, false}))).foreach((Function1 & Serializable & scala.Serializable)enablePruning -> {
            this.withTable((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tbl"}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.HIVE_METASTORE_PARTITION_PRUNING().key()), (Object)Boolean.toString(BoxesRunTime.unboxToBoolean((Object)enablePruning)))}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.spark().range(10L).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "id % 3 as p"})).write().partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"p"})).saveAsTable("tbl");
                HiveCatalogMetrics$.MODULE$.reset();
                QueryTest$.MODULE$.checkAnswer((Dataset)$this.sql().apply((Object)"SELECT id FROM tbl WHERE p = 1"), (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 4, 7}))).map((Function1 & Serializable & scala.Serializable)x$2 -> Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)x$2))})), Seq$.MODULE$.canBuildFrom()), false);
                int expectedCount = enablePruning ? 1 : 3;
                long $org_scalatest_assert_macro_left = HiveCatalogMetrics$.MODULE$.METRIC_PARTITIONS_FETCHED().getCount();
                int $org_scalatest_assert_macro_right = expectedCount;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PruneHiveTablePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 150));
            }));
            return BoxedUnit.UNIT;
        }), new Position("PruneHiveTablePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 141));
    }
}

