/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.client;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.net.URL;
import java.util.LinkedHashMap;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.SystemUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.FunctionIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier$;
import org.apache.spark.sql.catalyst.analysis.DatabaseAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.NoSuchDatabaseException;
import org.apache.spark.sql.catalyst.analysis.NoSuchPermanentFunctionException;
import org.apache.spark.sql.catalyst.analysis.PartitionsAlreadyExistException;
import org.apache.spark.sql.catalyst.catalog.CatalogDatabase;
import org.apache.spark.sql.catalyst.catalog.CatalogFunction;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTable$;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition$;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.EqualTo;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.hive.HiveExternalCatalog;
import org.apache.spark.sql.hive.client.HiveClient;
import org.apache.spark.sql.hive.client.HiveVersionSuite;
import org.apache.spark.sql.hive.test.TestHiveVersion;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.MutableURLClassLoader;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005Ec\u0001B\n\u0015\u0001\u0005B\u0001B\n\u0001\u0003\u0002\u0003\u0006Ia\n\u0005\ti\u0001\u0011\t\u0011)A\u0005k!)a\b\u0001C\u0001\u007f!91\t\u0001a\u0001\n\u0013!\u0005bB&\u0001\u0001\u0004%I\u0001\u0014\u0005\u0007'\u0002\u0001\u000b\u0015B#\t\u000fQ\u0003!\u0019!C\u0005+\"1Q\f\u0001Q\u0001\nYCQA\u0018\u0001\u0005\u0012}CQa\u001b\u0001\u0005\u00021DqA \u0001\u0012\u0002\u0013\u0005q\u0010C\u0005\u0002\u0016\u0001\u0011\r\u0011\"\u0003\u0002\u0018!A\u0011Q\u0005\u0001!\u0002\u0013\tI\u0002C\u0005\u0002(\u0001\u0011\r\u0011\"\u0003\u0002*!A\u0011\u0011\u0007\u0001!\u0002\u0013\tY\u0003C\u0005\u00024\u0001\u0011\r\u0011\"\u0001\u00026!A\u0011Q\b\u0001!\u0002\u0013\t9\u0004C\u0004\u0002@\u0001!\t!!\u0011\u0003\u001f!Kg/Z\"mS\u0016tGoU;ji\u0016T!!\u0006\f\u0002\r\rd\u0017.\u001a8u\u0015\t9\u0002$\u0001\u0003iSZ,'BA\r\u001b\u0003\r\u0019\u0018\u000f\u001c\u0006\u00037q\tQa\u001d9be.T!!\b\u0010\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0012aA8sO\u000e\u00011C\u0001\u0001#!\t\u0019C%D\u0001\u0015\u0013\t)CC\u0001\tISZ,g+\u001a:tS>t7+^5uK\u00069a/\u001a:tS>t\u0007C\u0001\u00152\u001d\tIs\u0006\u0005\u0002+[5\t1F\u0003\u0002-A\u00051AH]8pizR\u0011AL\u0001\u0006g\u000e\fG.Y\u0005\u0003a5\na\u0001\u0015:fI\u00164\u0017B\u0001\u001a4\u0005\u0019\u0019FO]5oO*\u0011\u0001'L\u0001\fC2dg+\u001a:tS>t7\u000fE\u00027w\u001dr!aN\u001d\u000f\u0005)B\u0014\"\u0001\u0018\n\u0005ij\u0013a\u00029bG.\fw-Z\u0005\u0003yu\u00121aU3r\u0015\tQT&\u0001\u0004=S:LGO\u0010\u000b\u0004\u0001\u0006\u0013\u0005CA\u0012\u0001\u0011\u001513\u00011\u0001(\u0011\u0015!4\u00011\u00016\u000311XM]:j_:\u001c\u0006/\u0019:l+\u0005)\u0005C\u0001$J\u001b\u00059%B\u0001%\u0017\u0003\u0011!Xm\u001d;\n\u0005);%a\u0004+fgRD\u0015N^3WKJ\u001c\u0018n\u001c8\u0002!Y,'o]5p]N\u0003\u0018M]6`I\u0015\fHCA'R!\tqu*D\u0001.\u0013\t\u0001VF\u0001\u0003V]&$\bb\u0002*\u0006\u0003\u0003\u0005\r!R\u0001\u0004q\u0012\n\u0014!\u0004<feNLwN\\*qCJ\\\u0007%\u0001\u0005f[B$\u0018\u0010R5s+\u00051\u0006CA,]\u001b\u0005A&BA-[\u0003\u0011a\u0017M\\4\u000b\u0003m\u000bAA[1wC&\u0011!\u0007W\u0001\nK6\u0004H/\u001f#je\u0002\n\u0011b^5uQR\u000b'\r\\3\u0015\u0005\u00014GCA'b\u0011\u0019\u0011\u0017\u0002\"a\u0001G\u0006\ta\rE\u0002OI6K!!Z\u0017\u0003\u0011q\u0012\u0017P\\1nKzBQaZ\u0005A\u0002!\f!\u0002^1cY\u0016t\u0015-\\3t!\rq\u0015nJ\u0005\u0003U6\u0012!\u0002\u0010:fa\u0016\fG/\u001a3?\u0003\u0015!\u0018M\u00197f)\u0011iWo^=\u0011\u00059\u001cX\"A8\u000b\u0005A\f\u0018aB2bi\u0006dwn\u001a\u0006\u0003eb\t\u0001bY1uC2L8\u000f^\u0005\u0003i>\u0014AbQ1uC2|w\rV1cY\u0016DQA\u001e\u0006A\u0002\u001d\n\u0001\u0002Z1uC\n\f7/\u001a\u0005\u0006q*\u0001\raJ\u0001\ni\u0006\u0014G.\u001a(b[\u0016DqA\u001f\u0006\u0011\u0002\u0003\u000710A\u0005uC\ndW\rV=qKB\u0011a\u000e`\u0005\u0003{>\u0014\u0001cQ1uC2|w\rV1cY\u0016$\u0016\u0010]3\u0002\u001fQ\f'\r\\3%I\u00164\u0017-\u001e7uIM*\"!!\u0001+\u0007m\f\u0019a\u000b\u0002\u0002\u0006A!\u0011qAA\t\u001b\t\tIA\u0003\u0003\u0002\f\u00055\u0011!C;oG\",7m[3e\u0015\r\ty!L\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\n\u0003\u0013\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003A!X-\u001c9ECR\f'-Y:f!\u0006$\b.\u0006\u0002\u0002\u001aA!\u00111DA\u0011\u001b\t\tiBC\u0002\u0002 i\u000b1A\\3u\u0013\u0011\t\u0019#!\b\u0003\u0007U\u0013\u0016*A\tuK6\u0004H)\u0019;bE\u0006\u001cX\rU1uQ\u0002\nQb\u001d;pe\u0006<WMR8s[\u0006$XCAA\u0016!\rq\u0017QF\u0005\u0004\u0003_y'\u0001F\"bi\u0006dwnZ*u_J\fw-\u001a$pe6\fG/\u0001\bti>\u0014\u0018mZ3G_Jl\u0017\r\u001e\u0011\u0002%Q,7\u000f\u001e)beRLG/[8o\u0007>,h\u000e^\u000b\u0003\u0003o\u00012ATA\u001d\u0013\r\tY$\f\u0002\u0004\u0013:$\u0018a\u0005;fgR\u0004\u0016M\u001d;ji&|gnQ8v]R\u0004\u0013\u0001\u00034v]\u000e$\u0018n\u001c8\u0015\r\u0005\r\u0013\u0011JA'!\rq\u0017QI\u0005\u0004\u0003\u000fz'aD\"bi\u0006dwn\u001a$v]\u000e$\u0018n\u001c8\t\r\u0005-#\u00031\u0001(\u0003\u0011q\u0017-\\3\t\r\u0005=#\u00031\u0001(\u0003%\u0019G.Y:t\u001d\u0006lW\r")
public class HiveClientSuite
extends HiveVersionSuite {
    private final String version;
    private final Seq<String> allVersions;
    private TestHiveVersion versionSpark;
    private final String emptyDir;
    private final URI tempDatabasePath;
    private final CatalogStorageFormat storageFormat;
    private final int testPartitionCount;

    private TestHiveVersion versionSpark() {
        return this.versionSpark;
    }

    private void versionSpark_$eq(TestHiveVersion x$1) {
        this.versionSpark = x$1;
    }

    private String emptyDir() {
        return this.emptyDir;
    }

    public void withTable(Seq<String> tableNames, Function0<BoxedUnit> f) {
        try {
            f.apply$mcV$sp();
        }
        finally {
            tableNames.foreach((Function1 & Serializable & scala.Serializable)name -> this.versionSpark().sql(new StringBuilder(21).append("DROP TABLE IF EXISTS ").append((String)name).toString()));
        }
    }

    public CatalogTable table(String database, String tableName, CatalogTableType tableType) {
        TableIdentifier x$1 = new TableIdentifier(tableName, (Option)new Some((Object)database));
        CatalogTableType x$2 = tableType;
        StructType x$3 = new StructType().add("key", "int");
        CatalogStorageFormat x$4 = new CatalogStorageFormat((Option)None$.MODULE$, (Option)new Some((Object)TextInputFormat.class.getName()), (Option)new Some((Object)HiveIgnoreKeyTextOutputFormat.class.getName()), (Option)new Some((Object)LazySimpleSerDe.class.getName()), false, Predef$.MODULE$.Map().empty());
        Option x$5 = CatalogTable$.MODULE$.apply$default$5();
        Seq x$6 = CatalogTable$.MODULE$.apply$default$6();
        Option x$7 = CatalogTable$.MODULE$.apply$default$7();
        String x$8 = CatalogTable$.MODULE$.apply$default$8();
        long x$9 = CatalogTable$.MODULE$.apply$default$9();
        long x$10 = CatalogTable$.MODULE$.apply$default$10();
        String x$11 = CatalogTable$.MODULE$.apply$default$11();
        Map x$12 = CatalogTable$.MODULE$.apply$default$12();
        Option x$13 = CatalogTable$.MODULE$.apply$default$13();
        Option x$14 = CatalogTable$.MODULE$.apply$default$14();
        Option x$15 = CatalogTable$.MODULE$.apply$default$15();
        Seq x$16 = CatalogTable$.MODULE$.apply$default$16();
        boolean x$17 = CatalogTable$.MODULE$.apply$default$17();
        boolean x$18 = CatalogTable$.MODULE$.apply$default$18();
        Map x$19 = CatalogTable$.MODULE$.apply$default$19();
        Option x$20 = CatalogTable$.MODULE$.apply$default$20();
        return new CatalogTable(x$1, x$2, x$4, x$3, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
    }

    public CatalogTableType table$default$3() {
        return CatalogTableType$.MODULE$.MANAGED();
    }

    private URI tempDatabasePath() {
        return this.tempDatabasePath;
    }

    private CatalogStorageFormat storageFormat() {
        return this.storageFormat;
    }

    public int testPartitionCount() {
        return this.testPartitionCount;
    }

    public CatalogFunction function(String name, String className) {
        return new CatalogFunction(new FunctionIdentifier(name, (Option)new Some((Object)"default")), className, (Seq)Nil$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$new$6(HiveClientSuite $this, File tmpDir) {
        CatalogDatabase dbWithNullDesc = new CatalogDatabase("dbWithNullDesc", null, tmpDir.toURI(), (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
        $this.client().createDatabase(dbWithNullDesc, true);
        String $org_scalatest_assert_macro_left = $this.client().getDatabase("dbWithNullDesc").description();
        String $org_scalatest_assert_macro_right = "";
        String string = $org_scalatest_assert_macro_left;
        String string2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139));
    }

    public static final /* synthetic */ boolean $anonfun$new$39(String x$4) {
        String string = x$4;
        String string2 = "0.14";
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ CatalogTablePartition $anonfun$new$42(HiveClientSuite $this, int key2) {
        return new CatalogTablePartition((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key1"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key2"), (Object)Integer.toString(key2))})), $this.storageFormat(), CatalogTablePartition$.MODULE$.apply$default$3(), CatalogTablePartition$.MODULE$.apply$default$4(), CatalogTablePartition$.MODULE$.apply$default$5(), CatalogTablePartition$.MODULE$.apply$default$6());
    }

    public static final /* synthetic */ String $anonfun$new$44(int key2) {
        return new StringBuilder(12).append("key1=1/key2=").append(key2).toString();
    }

    public static final /* synthetic */ boolean $anonfun$new$56(String x$5) {
        String string = x$5;
        String string2 = "1.2";
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ Bool $anonfun$new$76(Bool $org_scalatest_assert_macro_right$1) {
        return $org_scalatest_assert_macro_right$1;
    }

    public static final /* synthetic */ Row[] $anonfun$new$77(HiveClientSuite $this) {
        return (Row[])$this.versionSpark().table("mv1").collect();
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ Object $anonfun$new$75(HiveClientSuite $this) {
        block3: {
            block2: {
                v0 = $this.version;
                var1_1 = "2.3";
                if (!(v0 == null ? var1_1 != null : v0.equals(var1_1) == false)) break block2;
                v1 = $this.version;
                var2_2 = "3.0";
                if (!(v1 == null ? var2_2 != null : v1.equals(var2_2) == false)) break block2;
                v2 = $this.version;
                var3_3 = "3.1";
                if (v2 != null ? v2.equals(var3_3) == false : var3_3 != null) break block3;
            }
            $org_scalatest_assert_macro_left = $this.version;
            $org_scalatest_assert_macro_right = "2.3";
            v3 = $org_scalatest_assert_macro_left;
            var8_6 = $org_scalatest_assert_macro_right;
            $org_scalatest_assert_macro_left = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(v3 != null ? v3.equals(var8_6) == false : var8_6 != null), Prettifier$.MODULE$.default());
            $org_scalatest_assert_macro_right = $org_scalatest_assert_macro_left.value() != false ? Bool$.MODULE$.simpleMacroBool(true, "", Prettifier$.MODULE$.default()) : Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_9), "org.apache.commons.lang3.SystemUtils.isJavaVersionAtLeast(JAVA_9)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "||", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$bar$bar((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$new$76(org.scalactic.Bool ), ()Lorg/scalactic/Bool;)((Bool)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssume($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 663));
            v4 = $this.version;
            var11_10 = "2.3";
            if (!(v4 == null ? var11_10 != null : v4.equals(var11_10) == false)) ** GOTO lbl-1000
            v5 = $this.version;
            var12_11 = "3.0";
            if (!(v5 != null ? v5.equals(var12_11) == false : var12_11 != null)) lbl-1000:
            // 2 sources

            {
                v6 = "";
            } else {
                v6 = "DISABLE REWRITE";
            }
            disableRewrite = v6;
            $this.client().runSqlHive("CREATE TABLE materialized_view_tbl (c1 INT)");
            $this.client().runSqlHive(new StringBuilder(68).append("CREATE MATERIALIZED VIEW mv1 ").append(disableRewrite).append(" AS SELECT * FROM materialized_view_tbl").toString());
            $org_scalatest_assert_macro_left = e = ((AnalysisException)$this.intercept((Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$new$77(org.apache.spark.sql.hive.client.HiveClientSuite ), ()[Lorg/apache/spark/sql/Row;)((HiveClientSuite)$this), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 669))).getMessage();
            $org_scalatest_assert_macro_right = "Hive materialized view is not supported";
            $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 670));
        }
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ long $anonfun$new$93(String x$8) {
        return new StringOps(Predef$.MODULE$.augmentString(x$8)).toLong();
    }

    public static final /* synthetic */ long $anonfun$new$94(String x$9) {
        return new StringOps(Predef$.MODULE$.augmentString(x$9)).toLong();
    }

    public static final /* synthetic */ long $anonfun$new$97(String x$10) {
        return new StringOps(Predef$.MODULE$.augmentString(x$10)).toLong();
    }

    public static final /* synthetic */ long $anonfun$new$98(String x$11) {
        return new StringOps(Predef$.MODULE$.augmentString(x$11)).toLong();
    }

    public static final /* synthetic */ Dataset $anonfun$new$104(HiveClientSuite $this, int i) {
        return $this.versionSpark().sql(new StringBuilder(36).append("INSERT OVERWRITE TABLE tab SELECT '").append(i).append("'").toString());
    }

    private static final List listFiles$1(File path2) {
        File[] dir = path2.listFiles();
        List folders = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dir)).filter((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)x$12.isDirectory())))).toList();
        List filePaths = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dir)).map((Function1 & Serializable & scala.Serializable)x$13 -> x$13.getName(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toList();
        List list = (List)folders.flatMap((Function1 & Serializable & scala.Serializable)path -> HiveClientSuite.listFiles$1(path), List$.MODULE$.canBuildFrom());
        return (List)filePaths.$plus$plus$colon((Traversable)list, List$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ void $anonfun$new$110(HiveClientSuite $this, File dir) {
        String path = dir.toURI().toString();
        String tableName = "spark_13709";
        String tempTableName = "spark_13709_temp";
        new File(dir.getAbsolutePath(), tableName).mkdir();
        new File(dir.getAbsolutePath(), tempTableName).mkdir();
        String avroSchema = new StringOps(Predef$.MODULE$.augmentString("{\n          |  \"name\": \"test_record\",\n          |  \"type\": \"record\",\n          |  \"fields\": [ {\n          |    \"name\": \"f0\",\n          |    \"type\": \"int\"\n          |  }, {\n          |    \"name\": \"f1\",\n          |    \"type\": {\n          |      \"type\": \"record\",\n          |      \"name\": \"inner\",\n          |      \"fields\": [ {\n          |        \"name\": \"f10\",\n          |        \"type\": \"int\"\n          |      }, {\n          |        \"name\": \"f11\",\n          |        \"type\": \"double\"\n          |      } ]\n          |    }\n          |  } ]\n          |}\n          ")).stripMargin();
        $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tableName, tempTableName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.versionSpark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(441).append("CREATE EXTERNAL TABLE ").append(tableName).append("\n             |PARTITIONED BY (ds STRING)\n             |ROW FORMAT SERDE 'org.apache.hadoop.hive.serde2.avro.AvroSerDe'\n             |STORED AS\n             |  INPUTFORMAT 'org.apache.hadoop.hive.ql.io.avro.AvroContainerInputFormat'\n             |  OUTPUTFORMAT 'org.apache.hadoop.hive.ql.io.avro.AvroContainerOutputFormat'\n             |LOCATION '").append(path).append("/").append(tableName).append("'\n             |TBLPROPERTIES ('avro.schema.literal' = '").append(avroSchema).append("')\n           ").toString())).stripMargin());
            $this.versionSpark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(400).append("CREATE EXTERNAL TABLE ").append(tempTableName).append("\n             |ROW FORMAT SERDE 'org.apache.hadoop.hive.serde2.avro.AvroSerDe'\n             |STORED AS\n             |  INPUTFORMAT 'org.apache.hadoop.hive.ql.io.avro.AvroContainerInputFormat'\n             |  OUTPUTFORMAT 'org.apache.hadoop.hive.ql.io.avro.AvroContainerOutputFormat'\n             |LOCATION '").append(path).append("/").append(tempTableName).append("'\n             |TBLPROPERTIES ('avro.schema.literal' = '").append(avroSchema).append("')\n           ").toString())).stripMargin());
            $this.versionSpark().sql(new StringBuilder(48).append("INSERT OVERWRITE TABLE ").append(tempTableName).append(" SELECT 1, STRUCT(2, 2.5)").toString());
            $this.versionSpark().sql(new StringBuilder(52).append("ALTER TABLE ").append(tableName).append(" ADD PARTITION (ds = 'foo') LOCATION '").append(path).append("/").append(tempTableName).append("'").toString());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer($this.versionSpark().sql(new StringBuilder(14).append("SELECT * FROM ").append(tableName).toString()).collect());
            Row[] $org_scalatest_assert_macro_right = (Row[])((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)2.5)})), "foo"}))});
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 880));
        });
    }

    public static final /* synthetic */ void $anonfun$new$123(HiveClientSuite $this, File dir) {
        String avroSchema = new StringOps(Predef$.MODULE$.augmentString("\n          |{\n          |  \"name\": \"test_record\",\n          |  \"type\": \"record\",\n          |  \"fields\": [{\n          |    \"name\": \"f0\",\n          |    \"type\": [\n          |      \"null\",\n          |      {\n          |        \"precision\": 38,\n          |        \"scale\": 2,\n          |        \"type\": \"bytes\",\n          |        \"logicalType\": \"decimal\"\n          |      }\n          |    ]\n          |  }]\n          |}\n          ")).stripMargin();
        File schemaFile = new File(dir, "avroDecimal.avsc");
        Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> new PrintWriter(schemaFile), (Function1 & Serializable & scala.Serializable)writer -> {
            writer.write(avroSchema);
            return BoxedUnit.UNIT;
        });
        String schemaPath = schemaFile.toURI().toString();
        URL url = Thread.currentThread().getContextClassLoader().getResource("avroDecimal");
        String srcLocation = new File(url.getFile()).toURI().toString();
        String destTableName = "tab1";
        String srcTableName = "tab2";
        $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{srcTableName, destTableName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.versionSpark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(477).append("\n             |CREATE EXTERNAL TABLE ").append(srcTableName).append("\n             |ROW FORMAT SERDE 'org.apache.hadoop.hive.serde2.avro.AvroSerDe'\n             |WITH SERDEPROPERTIES ('respectSparkSchema' = 'true')\n             |STORED AS\n             |  INPUTFORMAT 'org.apache.hadoop.hive.ql.io.avro.AvroContainerInputFormat'\n             |  OUTPUTFORMAT 'org.apache.hadoop.hive.ql.io.avro.AvroContainerOutputFormat'\n             |LOCATION '").append(srcLocation).append("'\n             |TBLPROPERTIES ('avro.schema.url' = '").append(schemaPath).append("')\n           ").toString())).stripMargin());
            $this.versionSpark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(442).append("\n             |CREATE TABLE ").append(destTableName).append("\n             |ROW FORMAT SERDE 'org.apache.hadoop.hive.serde2.avro.AvroSerDe'\n             |WITH SERDEPROPERTIES ('respectSparkSchema' = 'true')\n             |STORED AS\n             |  INPUTFORMAT 'org.apache.hadoop.hive.ql.io.avro.AvroContainerInputFormat'\n             |  OUTPUTFORMAT 'org.apache.hadoop.hive.ql.io.avro.AvroContainerOutputFormat'\n             |TBLPROPERTIES ('avro.schema.url' = '").append(schemaPath).append("')\n           ").toString())).stripMargin());
            $this.versionSpark().sql(new StringBuilder(38).append("INSERT OVERWRITE TABLE ").append(destTableName).append(" SELECT * FROM ").append(srcTableName).toString());
            Row[] result = (Row[])$this.versionSpark().table(srcTableName).collect();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer($this.versionSpark().table(destTableName).collect());
            Row[] $org_scalatest_assert_macro_right = result;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1064));
            $this.versionSpark().sql(new StringBuilder(33).append("INSERT INTO TABLE ").append(destTableName).append(" SELECT * FROM ").append(srcTableName).toString());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.versionSpark().table(destTableName).collect())).toSeq());
            Row[] $org_scalatest_assert_macro_right2 = (Row[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])result)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])result)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Row.class)));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1067));
        });
    }

    public HiveClientSuite(String version, Seq<String> allVersions) {
        this.version = version;
        this.allVersions = allVersions;
        super(version);
        this.versionSpark = null;
        this.emptyDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()).getCanonicalPath();
        this.test("create client", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            this.client_$eq(null);
            System.gc();
            Configuration hadoopConf = new Configuration();
            hadoopConf.set("test", "success");
            this.client_$eq(this.buildClient(hadoopConf));
            if (this.versionSpark() != null) {
                this.versionSpark().reset();
            }
            this.versionSpark_$eq(new TestHiveVersion(this.client()));
            String $org_scalatest_assert_macro_left = ((HiveExternalCatalog)this.versionSpark().sharedState().externalCatalog().unwrapped()).client().version().fullVersion();
            String $org_scalatest_assert_macro_right = $this.version;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "startsWith", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.startsWith($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
        this.tempDatabasePath = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()).toURI();
        this.test("createDatabase", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            CatalogDatabase defaultDB = new CatalogDatabase("default", "desc", new URI("loc"), (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
            this.client().createDatabase(defaultDB, true);
            CatalogDatabase tempDB = new CatalogDatabase("temporary", "test create", this.tempDatabasePath(), (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
            this.client().createDatabase(tempDB, true);
            return (DatabaseAlreadyExistsException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.client().createDatabase(tempDB, false), ClassTag$.MODULE$.apply(DatabaseAlreadyExistsException.class), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94));
        this.test("create/get/alter database should pick right user name as owner", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            String string = $this.version;
            String string2 = "0.12";
            if (string == null ? string2 != null : !string.equals(string2)) {
                String currentUser = UserGroupInformation.getCurrentUser().getUserName();
                String ownerName = "SPARK_29425";
                String db1 = "SPARK_29425_1";
                String db2 = "SPARK_29425_2";
                Map ownerProps = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"owner"), (Object)ownerName)}));
                CatalogDatabase dbWithOwner = new CatalogDatabase(db1, "desc", Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()).toURI(), ownerProps);
                this.client().createDatabase(dbWithOwner, true);
                CatalogDatabase getDbWithOwner = this.client().getDatabase(db1);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(getDbWithOwner.properties().apply((Object)"owner"));
                String $org_scalatest_assert_macro_right = ownerName;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
                Map x$1 = (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
                String x$2 = getDbWithOwner.copy$default$1();
                String x$3 = getDbWithOwner.copy$default$2();
                URI x$4 = getDbWithOwner.copy$default$3();
                this.client().alterDatabase(getDbWithOwner.copy(x$2, x$3, x$4, x$1));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(this.client().getDatabase(db1).properties().apply((Object)"owner"));
                String $org_scalatest_assert_macro_right2 = "";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 121));
                CatalogDatabase dbWithoutOwner = new CatalogDatabase(db2, "desc", Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()).toURI(), (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
                this.client().createDatabase(dbWithoutOwner, true);
                CatalogDatabase getDbWithoutOwner = this.client().getDatabase(db2);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(getDbWithoutOwner.properties().apply((Object)"owner"));
                String $org_scalatest_assert_macro_right3 = currentUser;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
                Map x$5 = ownerProps;
                String x$6 = getDbWithoutOwner.copy$default$1();
                String x$7 = getDbWithoutOwner.copy$default$2();
                URI x$8 = getDbWithoutOwner.copy$default$3();
                this.client().alterDatabase(getDbWithoutOwner.copy(x$6, x$7, x$8, x$5));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(this.client().getDatabase(db2).properties().apply((Object)"owner"));
                String $org_scalatest_assert_macro_right4 = ownerName;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
            }
            return BoxedUnit.UNIT;
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
        this.test("createDatabase with null description", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1 & Serializable & scala.Serializable)tmpDir -> {
            HiveClientSuite.$anonfun$new$6(this, tmpDir);
            return BoxedUnit.UNIT;
        }), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 134));
        this.test("setCurrentDatabase", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.client().setCurrentDatabase("default"), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143));
        this.test("getDatabase", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            this.client().getDatabase("default");
            return (NoSuchDatabaseException)this.intercept((Function0 & Serializable & scala.Serializable)() -> this.client().getDatabase("nonexist"), ClassTag$.MODULE$.apply(NoSuchDatabaseException.class), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 150));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 147));
        this.test("databaseExists", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.client().databaseExists("default"), "HiveClientSuite.this.client.databaseExists(\"default\")", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.client().databaseExists("nonexist"), "HiveClientSuite.this.client.databaseExists(\"nonexist\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 155));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 153));
        this.test("listDatabases", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            Seq $org_scalatest_assert_macro_left = this.client().listDatabases("defau.*");
            Seq $org_scalatest_assert_macro_right = (Seq)new .colon.colon((Object)"default", (List)Nil$.MODULE$);
            Seq seq = $org_scalatest_assert_macro_left;
            Seq seq2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(seq != null ? !seq.equals(seq2) : seq2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 159));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 158));
        this.test("alterDatabase", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            URI tempDatabasePath2;
            CatalogDatabase database;
            block3: {
                block2: {
                    CatalogDatabase qual$1 = this.client().getDatabase("temporary");
                    Map x$9 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"flag"), (Object)"true")}));
                    String x$10 = qual$1.copy$default$1();
                    String x$11 = qual$1.copy$default$2();
                    URI x$12 = qual$1.copy$default$3();
                    database = qual$1.copy(x$10, x$11, x$12, x$9);
                    this.client().alterDatabase(database);
                    Map $org_scalatest_assert_macro_left = this.client().getDatabase("temporary").properties();
                    String $org_scalatest_assert_macro_right = "flag";
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 165));
                    tempDatabasePath2 = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()).toURI();
                    String string = $this.version;
                    String string2 = "3.0";
                    if (!(string == null ? string2 != null : !string.equals(string2))) break block2;
                    String string3 = $this.version;
                    String string4 = "3.1";
                    if (string3 != null ? !string3.equals(string4) : string4 != null) break block3;
                }
                URI x$13 = tempDatabasePath2;
                String x$14 = database.copy$default$1();
                String x$15 = database.copy$default$2();
                Map x$16 = database.copy$default$4();
                this.client().alterDatabase(database.copy(x$14, x$15, x$13, x$16));
                URI uriInCatalog = this.client().getDatabase("temporary").locationUri();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer("file");
                String $org_scalatest_assert_macro_right = uriInCatalog.getScheme();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 173));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(new Path(tempDatabasePath2.getPath()).toUri().getPath());
                String $org_scalatest_assert_macro_right2 = uriInCatalog.getPath();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"Failed to alter database location", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 174));
            }
            AnalysisException e = (AnalysisException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                URI x$17 = tempDatabasePath2;
                String x$18 = database.copy$default$1();
                String x$19 = database.copy$default$2();
                Map x$20 = database.copy$default$4();
                this.client().alterDatabase(database.copy(x$18, x$19, x$17, x$20));
            }, ClassTag$.MODULE$.apply(AnalysisException.class), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 177));
            String $org_scalatest_assert_macro_left = e.getMessage();
            String $org_scalatest_assert_macro_right = "does not support altering database location";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 180));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
        this.test("dropDatabase", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.client().databaseExists("temporary"), "HiveClientSuite.this.client.databaseExists(\"temporary\")", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 185));
            this.client().createTable(this.table("temporary", "tbl", this.table$default$3()), false);
            AnalysisException ex = (AnalysisException)this.intercept((Function0 & Serializable & scala.Serializable)() -> {
                this.client().dropDatabase("temporary", false, false);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"dropDatabase should throw HiveException", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 190));
            }, ClassTag$.MODULE$.apply(AnalysisException.class), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 188));
            String $org_scalatest_assert_macro_left = ex.message();
            String $org_scalatest_assert_macro_right = "Cannot drop a non-empty database: temporary.";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 192));
            this.client().dropDatabase("temporary", false, true);
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.client().databaseExists("temporary"), "HiveClientSuite.this.client.databaseExists(\"temporary\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 195));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 184));
        this.test("createTable", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.client().createTable(this.table("default", "src", this.table$default$3()), false);
            this.client().createTable(this.table("default", "temporary", this.table$default$3()), false);
            this.client().createTable(this.table("default", "view1", CatalogTableType$.MODULE$.VIEW()), false);
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 202));
        this.test("loadTable", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.client().loadTable(this.emptyDir(), "src", false, false), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 209));
        this.test("tableExists", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.client().tableExists("default", "src"), "HiveClientSuite.this.client.tableExists(\"default\", \"src\")", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 219));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.client().tableExists("default", "nonexistent"), "HiveClientSuite.this.client.tableExists(\"default\", \"nonexistent\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 220));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 217));
        this.test("getTable", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> this.client().getTable("default", "src"), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 223));
        this.test("getTableOption", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.client().getTableOption("default", "src").isDefined(), "HiveClientSuite.this.client.getTableOption(\"default\", \"src\").isDefined", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 229));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 228));
        this.test("getTablesByName", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            CatalogTable $org_scalatest_assert_macro_left = (CatalogTable)this.client().getTablesByName("default", (Seq)new .colon.colon((Object)"src", (List)Nil$.MODULE$)).head();
            CatalogTable $org_scalatest_assert_macro_right = (CatalogTable)this.client().getTableOption("default", "src").get();
            CatalogTable catalogTable = $org_scalatest_assert_macro_left;
            CatalogTable catalogTable2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(catalogTable != null ? !catalogTable.equals(catalogTable2) : catalogTable2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 233));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 232));
        this.test("getTablesByName when multiple tables", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            Seq $org_scalatest_assert_macro_left = (Seq)this.client().getTablesByName("default", (Seq)new .colon.colon((Object)"src", (List)new .colon.colon((Object)"temporary", (List)Nil$.MODULE$))).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.identifier().table(), Seq$.MODULE$.canBuildFrom());
            Seq $org_scalatest_assert_macro_right = (Seq)new .colon.colon((Object)"src", (List)new .colon.colon((Object)"temporary", (List)Nil$.MODULE$));
            Seq seq = $org_scalatest_assert_macro_left;
            Seq seq2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(seq != null ? !seq.equals(seq2) : seq2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 238));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 237));
        this.test("getTablesByName when some tables do not exist", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            Seq $org_scalatest_assert_macro_left = (Seq)this.client().getTablesByName("default", (Seq)new .colon.colon((Object)"src", (List)new .colon.colon((Object)"notexist", (List)Nil$.MODULE$))).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.identifier().table(), Seq$.MODULE$.canBuildFrom());
            Seq $org_scalatest_assert_macro_right = (Seq)new .colon.colon((Object)"src", (List)Nil$.MODULE$);
            Seq seq = $org_scalatest_assert_macro_left;
            Seq seq2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(seq != null ? !seq.equals(seq2) : seq2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 243));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 242));
        this.test("getTablesByName when contains invalid name", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            String name = "\u7816";
            Seq $org_scalatest_assert_macro_left = (Seq)this.client().getTablesByName("default", (Seq)new .colon.colon((Object)"src", (List)new .colon.colon((Object)name, (List)Nil$.MODULE$))).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.identifier().table(), Seq$.MODULE$.canBuildFrom());
            Seq $org_scalatest_assert_macro_right = (Seq)new .colon.colon((Object)"src", (List)Nil$.MODULE$);
            Seq seq = $org_scalatest_assert_macro_left;
            Seq seq2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(seq != null ? !seq.equals(seq2) : seq2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 251));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 247));
        this.test("getTablesByName when empty", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            Seq $org_scalatest_assert_macro_left = this.client().getTablesByName("default", (Seq)Nil$.MODULE$);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 256));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 255));
        this.test("alterTable(table: CatalogTable)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            CatalogTable qual$2 = this.client().getTable("default", "src");
            Map x$21 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"changed"), (Object)"")}));
            TableIdentifier x$22 = qual$2.copy$default$1();
            CatalogTableType x$23 = qual$2.copy$default$2();
            CatalogStorageFormat x$24 = qual$2.copy$default$3();
            StructType x$25 = qual$2.copy$default$4();
            Option x$26 = qual$2.copy$default$5();
            Seq x$27 = qual$2.copy$default$6();
            Option x$28 = qual$2.copy$default$7();
            String x$29 = qual$2.copy$default$8();
            long x$30 = qual$2.copy$default$9();
            long x$31 = qual$2.copy$default$10();
            String x$32 = qual$2.copy$default$11();
            Option x$33 = qual$2.copy$default$13();
            Option x$34 = qual$2.copy$default$14();
            Option x$35 = qual$2.copy$default$15();
            Seq x$36 = qual$2.copy$default$16();
            boolean x$37 = qual$2.copy$default$17();
            boolean x$38 = qual$2.copy$default$18();
            Map x$39 = qual$2.copy$default$19();
            Option x$40 = qual$2.copy$default$20();
            CatalogTable newTable = qual$2.copy(x$22, x$23, x$24, x$25, x$26, x$27, x$28, x$29, x$30, x$31, x$32, x$21, x$33, x$34, x$35, x$36, x$37, x$38, x$39, x$40);
            this.client().alterTable(newTable);
            Map $org_scalatest_assert_macro_left = this.client().getTable("default", "src").properties();
            String $org_scalatest_assert_macro_right = "changed";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 262));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 259));
        this.test("alterTable - should respect the original catalog table's owner name", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            String ownerName = "SPARK-29405";
            CatalogTable originalTable = this.client().getTable("default", "src");
            String x$41 = ownerName;
            TableIdentifier x$42 = originalTable.copy$default$1();
            CatalogTableType x$43 = originalTable.copy$default$2();
            CatalogStorageFormat x$44 = originalTable.copy$default$3();
            StructType x$45 = originalTable.copy$default$4();
            Option x$46 = originalTable.copy$default$5();
            Seq x$47 = originalTable.copy$default$6();
            Option x$48 = originalTable.copy$default$7();
            long x$49 = originalTable.copy$default$9();
            long x$50 = originalTable.copy$default$10();
            String x$51 = originalTable.copy$default$11();
            Map x$52 = originalTable.copy$default$12();
            Option x$53 = originalTable.copy$default$13();
            Option x$54 = originalTable.copy$default$14();
            Option x$55 = originalTable.copy$default$15();
            Seq x$56 = originalTable.copy$default$16();
            boolean x$57 = originalTable.copy$default$17();
            boolean x$58 = originalTable.copy$default$18();
            Map x$59 = originalTable.copy$default$19();
            Option x$60 = originalTable.copy$default$20();
            CatalogTable newTable = originalTable.copy(x$42, x$43, x$44, x$45, x$46, x$47, x$48, x$41, x$49, x$50, x$51, x$52, x$53, x$54, x$55, x$56, x$57, x$58, x$59, x$60);
            this.client().alterTable(newTable);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.client().getTable("default", "src").owner());
            String $org_scalatest_assert_macro_right = ownerName;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 271));
            String x$61 = "";
            TableIdentifier x$62 = originalTable.copy$default$1();
            CatalogTableType x$63 = originalTable.copy$default$2();
            CatalogStorageFormat x$64 = originalTable.copy$default$3();
            StructType x$65 = originalTable.copy$default$4();
            Option x$66 = originalTable.copy$default$5();
            Seq x$67 = originalTable.copy$default$6();
            Option x$68 = originalTable.copy$default$7();
            long x$69 = originalTable.copy$default$9();
            long x$70 = originalTable.copy$default$10();
            String x$71 = originalTable.copy$default$11();
            Map x$72 = originalTable.copy$default$12();
            Option x$73 = originalTable.copy$default$13();
            Option x$74 = originalTable.copy$default$14();
            Option x$75 = originalTable.copy$default$15();
            Seq x$76 = originalTable.copy$default$16();
            boolean x$77 = originalTable.copy$default$17();
            boolean x$78 = originalTable.copy$default$18();
            Map x$79 = originalTable.copy$default$19();
            Option x$80 = originalTable.copy$default$20();
            CatalogTable newTable2 = originalTable.copy(x$62, x$63, x$64, x$65, x$66, x$67, x$68, x$61, x$69, x$70, x$71, x$72, x$73, x$74, x$75, x$76, x$77, x$78, x$79, x$80);
            this.client().alterTable(newTable2);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(this.client().getTable("default", "src").owner());
            String $org_scalatest_assert_macro_right2 = this.client().userName();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 275));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 265));
        this.test("alterTable(dbName: String, tableName: String, table: CatalogTable)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            CatalogTable qual$3 = this.client().getTable("default", "src");
            Map x$81 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"changedAgain"), (Object)"")}));
            TableIdentifier x$82 = qual$3.copy$default$1();
            CatalogTableType x$83 = qual$3.copy$default$2();
            CatalogStorageFormat x$84 = qual$3.copy$default$3();
            StructType x$85 = qual$3.copy$default$4();
            Option x$86 = qual$3.copy$default$5();
            Seq x$87 = qual$3.copy$default$6();
            Option x$88 = qual$3.copy$default$7();
            String x$89 = qual$3.copy$default$8();
            long x$90 = qual$3.copy$default$9();
            long x$91 = qual$3.copy$default$10();
            String x$92 = qual$3.copy$default$11();
            Option x$93 = qual$3.copy$default$13();
            Option x$94 = qual$3.copy$default$14();
            Option x$95 = qual$3.copy$default$15();
            Seq x$96 = qual$3.copy$default$16();
            boolean x$97 = qual$3.copy$default$17();
            boolean x$98 = qual$3.copy$default$18();
            Map x$99 = qual$3.copy$default$19();
            Option x$100 = qual$3.copy$default$20();
            CatalogTable newTable = qual$3.copy(x$82, x$83, x$84, x$85, x$86, x$87, x$88, x$89, x$90, x$91, x$92, x$81, x$93, x$94, x$95, x$96, x$97, x$98, x$99, x$100);
            this.client().alterTable("default", "src", newTable);
            Map $org_scalatest_assert_macro_left = this.client().getTable("default", "src").properties();
            String $org_scalatest_assert_macro_right = "changedAgain";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 281));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 278));
        this.test("alterTable - rename", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            CatalogTable qual$4 = this.client().getTable("default", "src");
            TableIdentifier x$101 = new TableIdentifier("tgt", (Option)new Some((Object)"default"));
            CatalogTableType x$102 = qual$4.copy$default$2();
            CatalogStorageFormat x$103 = qual$4.copy$default$3();
            StructType x$104 = qual$4.copy$default$4();
            Option x$105 = qual$4.copy$default$5();
            Seq x$106 = qual$4.copy$default$6();
            Option x$107 = qual$4.copy$default$7();
            String x$108 = qual$4.copy$default$8();
            long x$109 = qual$4.copy$default$9();
            long x$110 = qual$4.copy$default$10();
            String x$111 = qual$4.copy$default$11();
            Map x$112 = qual$4.copy$default$12();
            Option x$113 = qual$4.copy$default$13();
            Option x$114 = qual$4.copy$default$14();
            Option x$115 = qual$4.copy$default$15();
            Seq x$116 = qual$4.copy$default$16();
            boolean x$117 = qual$4.copy$default$17();
            boolean x$118 = qual$4.copy$default$18();
            Map x$119 = qual$4.copy$default$19();
            Option x$120 = qual$4.copy$default$20();
            CatalogTable newTable = qual$4.copy(x$101, x$102, x$103, x$104, x$105, x$106, x$107, x$108, x$109, x$110, x$111, x$112, x$113, x$114, x$115, x$116, x$117, x$118, x$119, x$120);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.client().tableExists("default", "tgt"), "HiveClientSuite.this.client.tableExists(\"default\", \"tgt\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 287));
            this.client().alterTable("default", "src", newTable);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(this.client().tableExists("default", "tgt"), "HiveClientSuite.this.client.tableExists(\"default\", \"tgt\")", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 291));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.client().tableExists("default", "src"), "HiveClientSuite.this.client.tableExists(\"default\", \"src\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 292));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 284));
        this.test("alterTable - change database", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            CatalogDatabase tempDB = new CatalogDatabase("temporary", "test create", this.tempDatabasePath(), (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
            this.client().createDatabase(tempDB, true);
            CatalogTable qual$5 = this.client().getTable("default", "tgt");
            TableIdentifier x$121 = new TableIdentifier("tgt", (Option)new Some((Object)"temporary"));
            CatalogTableType x$122 = qual$5.copy$default$2();
            CatalogStorageFormat x$123 = qual$5.copy$default$3();
            StructType x$124 = qual$5.copy$default$4();
            Option x$125 = qual$5.copy$default$5();
            Seq x$126 = qual$5.copy$default$6();
            Option x$127 = qual$5.copy$default$7();
            String x$128 = qual$5.copy$default$8();
            long x$129 = qual$5.copy$default$9();
            long x$130 = qual$5.copy$default$10();
            String x$131 = qual$5.copy$default$11();
            Map x$132 = qual$5.copy$default$12();
            Option x$133 = qual$5.copy$default$13();
            Option x$134 = qual$5.copy$default$14();
            Option x$135 = qual$5.copy$default$15();
            Seq x$136 = qual$5.copy$default$16();
            boolean x$137 = qual$5.copy$default$17();
            boolean x$138 = qual$5.copy$default$18();
            Map x$139 = qual$5.copy$default$19();
            Option x$140 = qual$5.copy$default$20();
            CatalogTable newTable = qual$5.copy(x$121, x$122, x$123, x$124, x$125, x$126, x$127, x$128, x$129, x$130, x$131, x$132, x$133, x$134, x$135, x$136, x$137, x$138, x$139, x$140);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.client().tableExists("temporary", "tgt"), "HiveClientSuite.this.client.tableExists(\"temporary\", \"tgt\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 302));
            this.client().alterTable("default", "tgt", newTable);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(this.client().tableExists("temporary", "tgt"), "HiveClientSuite.this.client.tableExists(\"temporary\", \"tgt\")", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 306));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.client().tableExists("default", "tgt"), "HiveClientSuite.this.client.tableExists(\"default\", \"tgt\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 307));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 295));
        this.test("alterTable - change database and table names", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            CatalogTable qual$6 = this.client().getTable("temporary", "tgt");
            TableIdentifier x$141 = new TableIdentifier("src", (Option)new Some((Object)"default"));
            CatalogTableType x$142 = qual$6.copy$default$2();
            CatalogStorageFormat x$143 = qual$6.copy$default$3();
            StructType x$144 = qual$6.copy$default$4();
            Option x$145 = qual$6.copy$default$5();
            Seq x$146 = qual$6.copy$default$6();
            Option x$147 = qual$6.copy$default$7();
            String x$148 = qual$6.copy$default$8();
            long x$149 = qual$6.copy$default$9();
            long x$150 = qual$6.copy$default$10();
            String x$151 = qual$6.copy$default$11();
            Map x$152 = qual$6.copy$default$12();
            Option x$153 = qual$6.copy$default$13();
            Option x$154 = qual$6.copy$default$14();
            Option x$155 = qual$6.copy$default$15();
            Seq x$156 = qual$6.copy$default$16();
            boolean x$157 = qual$6.copy$default$17();
            boolean x$158 = qual$6.copy$default$18();
            Map x$159 = qual$6.copy$default$19();
            Option x$160 = qual$6.copy$default$20();
            CatalogTable newTable = qual$6.copy(x$141, x$142, x$143, x$144, x$145, x$146, x$147, x$148, x$149, x$150, x$151, x$152, x$153, x$154, x$155, x$156, x$157, x$158, x$159, x$160);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.client().tableExists("default", "src"), "HiveClientSuite.this.client.tableExists(\"default\", \"src\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 313));
            this.client().alterTable("temporary", "tgt", newTable);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(this.client().tableExists("default", "src"), "HiveClientSuite.this.client.tableExists(\"default\", \"src\")", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 317));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.client().tableExists("temporary", "tgt"), "HiveClientSuite.this.client.tableExists(\"temporary\", \"tgt\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 318));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 310));
        this.test("listTables(database)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.client().listTables("default"));
            Seq $org_scalatest_assert_macro_right = (Seq)new .colon.colon((Object)"src", (List)new .colon.colon((Object)"temporary", (List)new .colon.colon((Object)"view1", (List)Nil$.MODULE$)));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 322));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 321));
        this.test("listTables(database, pattern)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.client().listTables("default", "src"));
            Seq $org_scalatest_assert_macro_right = (Seq)new .colon.colon((Object)"src", (List)Nil$.MODULE$);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 326));
            Seq $org_scalatest_assert_macro_left2 = this.client().listTables("default", "nonexist");
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 327));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 325));
        this.test("listTablesByType(database, pattern, tableType)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.client().listTablesByType("default", "view1", CatalogTableType$.MODULE$.VIEW()));
            Seq $org_scalatest_assert_macro_right = (Seq)new .colon.colon((Object)"view1", (List)Nil$.MODULE$);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 331));
            Seq $org_scalatest_assert_macro_left2 = this.client().listTablesByType("default", "nonexist", CatalogTableType$.MODULE$.VIEW());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 333));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 330));
        this.test("dropTable", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            Assertion assertion;
            Nil$ versionsWithoutPurge = $this.allVersions.contains((Object)"0.14") ? (Seq)$this.allVersions.takeWhile((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)HiveClientSuite.$anonfun$new$39(x$4))) : Nil$.MODULE$;
            try {
                this.client().dropTable("default", "temporary", false, true);
                Nil$ $org_scalatest_assert_macro_left = versionsWithoutPurge;
                String $org_scalatest_assert_macro_right = $this.version;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 345));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                Nil$ $org_scalatest_assert_macro_left = versionsWithoutPurge;
                String $org_scalatest_assert_macro_right = $this.version;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 348));
                this.client().dropTable("default", "temporary", false, false);
                assertion = BoxedUnit.UNIT;
            }
            try {
                this.client().dropTable("default", "view1", false, true);
                Nil$ $org_scalatest_assert_macro_left = versionsWithoutPurge;
                String $org_scalatest_assert_macro_right = $this.version;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                boxedUnit = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 356));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                this.client().dropTable("default", "view1", false, false);
                boxedUnit = BoxedUnit.UNIT;
            }
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.client().listTables("default"));
            Seq $org_scalatest_assert_macro_right = (Seq)new .colon.colon((Object)"src", (List)Nil$.MODULE$);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 362));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 337));
        this.storageFormat = new CatalogStorageFormat((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, false, Predef$.MODULE$.Map().empty());
        this.test("sql create partitioned table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TableIdentifier x$161 = new TableIdentifier("src_part", (Option)new Some((Object)"default"));
            CatalogTableType x$162 = CatalogTableType$.MODULE$.MANAGED();
            StructType x$163 = new StructType().add("value", "int").add("key1", "int").add("key2", "int");
            Seq x$164 = (Seq)new .colon.colon((Object)"key1", (List)new .colon.colon((Object)"key2", (List)Nil$.MODULE$));
            CatalogStorageFormat x$165 = new CatalogStorageFormat((Option)None$.MODULE$, (Option)new Some((Object)TextInputFormat.class.getName()), (Option)new Some((Object)HiveIgnoreKeyTextOutputFormat.class.getName()), (Option)new Some((Object)LazySimpleSerDe.class.getName()), false, Predef$.MODULE$.Map().empty());
            Option x$166 = CatalogTable$.MODULE$.apply$default$5();
            Option x$167 = CatalogTable$.MODULE$.apply$default$7();
            String x$168 = CatalogTable$.MODULE$.apply$default$8();
            long x$169 = CatalogTable$.MODULE$.apply$default$9();
            long x$170 = CatalogTable$.MODULE$.apply$default$10();
            String x$171 = CatalogTable$.MODULE$.apply$default$11();
            Map x$172 = CatalogTable$.MODULE$.apply$default$12();
            Option x$173 = CatalogTable$.MODULE$.apply$default$13();
            Option x$174 = CatalogTable$.MODULE$.apply$default$14();
            Option x$175 = CatalogTable$.MODULE$.apply$default$15();
            Seq x$176 = CatalogTable$.MODULE$.apply$default$16();
            boolean x$177 = CatalogTable$.MODULE$.apply$default$17();
            boolean x$178 = CatalogTable$.MODULE$.apply$default$18();
            Map x$179 = CatalogTable$.MODULE$.apply$default$19();
            Option x$180 = CatalogTable$.MODULE$.apply$default$20();
            CatalogTable table = new CatalogTable(x$161, x$162, x$165, x$163, x$166, x$164, x$167, x$168, x$169, x$170, x$171, x$172, x$173, x$174, x$175, x$176, x$177, x$178, x$179, x$180);
            this.client().createTable(table, false);
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 377));
        this.testPartitionCount = 2;
        this.test("createPartitions", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            IndexedSeq partitions = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.testPartitionCount()).map((Function1 & Serializable & scala.Serializable)key2 -> HiveClientSuite.$anonfun$new$42(this, BoxesRunTime.unboxToInt((Object)key2)), IndexedSeq$.MODULE$.canBuildFrom());
            this.client().createPartitions("default", "src_part", (Seq)partitions, true);
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 396));
        this.test("getPartitionNames(catalogTable)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            IndexedSeq partitionNames;
            IndexedSeq $org_scalatest_assert_macro_left = partitionNames = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.testPartitionCount()).map((Function1 & Serializable & scala.Serializable)key2 -> HiveClientSuite.$anonfun$new$44(BoxesRunTime.unboxToInt((Object)key2)), IndexedSeq$.MODULE$.canBuildFrom());
            HiveClient qual$7 = this.client();
            CatalogTable x$181 = this.client().getTable("default", "src_part");
            Option x$182 = qual$7.getPartitionNames$default$2();
            Seq $org_scalatest_assert_macro_right = qual$7.getPartitionNames(x$181, x$182);
            IndexedSeq indexedSeq = $org_scalatest_assert_macro_left;
            Seq seq = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(indexedSeq != null ? !indexedSeq.equals(seq) : seq != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 406));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 404));
        this.test("getPartitions(db, table, spec)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            int $org_scalatest_assert_macro_left = this.testPartitionCount();
            int $org_scalatest_assert_macro_right = this.client().getPartitions("default", "src_part", (Option)None$.MODULE$).size();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 410));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 409));
        this.test("getPartitionsByFilter", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            String x$183 = "key2";
            IntegerType$ x$184 = IntegerType$.MODULE$;
            boolean x$185 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$186 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$187 = AttributeReference$.MODULE$.apply$default$5(x$183, (DataType)x$184, x$185, x$186);
            Seq x$188 = AttributeReference$.MODULE$.apply$default$6(x$183, (DataType)x$184, x$185, x$186);
            Seq result = this.client().getPartitionsByFilter(this.client().getRawHiveTable("default", "src_part"), (Seq)new .colon.colon((Object)new EqualTo((Expression)new AttributeReference(x$183, (DataType)x$184, x$185, x$186, x$187, x$188), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))), (List)Nil$.MODULE$));
            String string = $this.version;
            String string2 = "0.12";
            if (string == null ? string2 != null : !string.equals(string2)) {
                Seq $org_scalatest_assert_macro_left = result;
                int $org_scalatest_assert_macro_right = 1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 421));
            }
            Seq $org_scalatest_assert_macro_left = result;
            int $org_scalatest_assert_macro_right = this.testPartitionCount();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 423));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 414));
        this.test("getPartition", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> this.client().getPartition("default", "src_part", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key1"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key2"), (Object)"2")}))), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 427));
        this.test("getPartitionOption(db: String, table: String, spec: TablePartitionSpec)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            Option partition = this.client().getPartitionOption("default", "src_part", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key1"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key2"), (Object)"2")})));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(partition.isDefined(), "partition.isDefined", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 435));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 432));
        this.test("getPartitionOption(table: CatalogTable, spec: TablePartitionSpec)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            Option partition = this.client().getPartitionOption(this.client().getRawHiveTable("default", "src_part"), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key1"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key2"), (Object)"2")})));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(partition.isDefined(), "partition.isDefined", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 441));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 438));
        this.test("getPartitions(db: String, table: String)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            int $org_scalatest_assert_macro_left = this.testPartitionCount();
            int $org_scalatest_assert_macro_right = this.client().getPartitions("default", "src_part", (Option)None$.MODULE$).size();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 445));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 444));
        this.test("loadPartition", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LinkedHashMap<String, String> partSpec = new LinkedHashMap<String, String>();
            partSpec.put("key1", "1");
            partSpec.put("key2", "2");
            this.client().loadPartition(this.emptyDir(), "default", "src_part", partSpec, false, false, false);
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 448));
        this.test("loadDynamicPartitions", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LinkedHashMap<String, String> partSpec = new LinkedHashMap<String, String>();
            partSpec.put("key1", "1");
            partSpec.put("key2", "");
            this.client().loadDynamicPartitions(this.emptyDir(), "default", "src_part", partSpec, false, 1);
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 463));
        this.test("renamePartitions", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            Map oldSpec = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key1"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key2"), (Object)"1")}));
            Map newSpec = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key1"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key2"), (Object)"3")}));
            this.client().renamePartitions("default", "src_part", (Seq)new .colon.colon((Object)oldSpec, (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)newSpec, (List)Nil$.MODULE$));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.client().getPartitionOption("default", "src_part", newSpec).isDefined(), "HiveClientSuite.this.client.getPartitionOption(\"default\", \"src_part\", newSpec).isDefined", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 483));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 477));
        this.test("alterPartitions", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            Map spec = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key1"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key2"), (Object)"2")}));
            Map parameters = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"totalSize"), (Object)"0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numFiles"), (Object)"1")}));
            URI newLocation = new URI(new StringOps(Predef$.MODULE$.augmentString(Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()).toURI().toString())).stripSuffix("/"));
            Some x$189 = new Some((Object)newLocation);
            Some x$190 = new Some((Object)"org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe");
            Option x$191 = this.storageFormat().copy$default$2();
            Option x$192 = this.storageFormat().copy$default$3();
            boolean x$193 = this.storageFormat().copy$default$5();
            Map x$194 = this.storageFormat().copy$default$6();
            CatalogStorageFormat storage = this.storageFormat().copy((Option)x$189, x$191, x$192, (Option)x$190, x$193, x$194);
            CatalogTablePartition partition = new CatalogTablePartition(spec, storage, parameters, CatalogTablePartition$.MODULE$.apply$default$4(), CatalogTablePartition$.MODULE$.apply$default$5(), CatalogTablePartition$.MODULE$.apply$default$6());
            this.client().alterPartitions("default", "src_part", (Seq)new .colon.colon((Object)partition, (List)Nil$.MODULE$));
            Option $org_scalatest_assert_macro_left = this.client().getPartition("default", "src_part", spec).storage().locationUri();
            URI $org_scalatest_assert_macro_right = newLocation;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 496));
            Option $org_scalatest_assert_macro_left2 = this.client().getPartition("default", "src_part", spec).parameters().get((Object)"totalSize");
            String $org_scalatest_assert_macro_right2 = "0";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains((Object)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 498));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 486));
        this.test("dropPartitions", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            Assertion assertion;
            Map spec = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key1"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key2"), (Object)"3")}));
            Nil$ versionsWithoutPurge = $this.allVersions.contains((Object)"1.2") ? (Seq)$this.allVersions.takeWhile((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)HiveClientSuite.$anonfun$new$56(x$5))) : Nil$.MODULE$;
            try {
                this.client().dropPartitions("default", "src_part", (Seq)new .colon.colon((Object)spec, (List)Nil$.MODULE$), true, true, false);
                Nil$ $org_scalatest_assert_macro_left = versionsWithoutPurge;
                String $org_scalatest_assert_macro_right = $this.version;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 511));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                Nil$ $org_scalatest_assert_macro_left = versionsWithoutPurge;
                String $org_scalatest_assert_macro_right = $this.version;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 514));
                this.client().dropPartitions("default", "src_part", (Seq)new .colon.colon((Object)spec, (List)Nil$.MODULE$), true, false, false);
                assertion = BoxedUnit.UNIT;
            }
            Option $org_scalatest_assert_macro_left = this.client().getPartitionOption("default", "src_part", spec);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 519));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 502));
        this.test("createPartitions if already exists", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            Assertion assertion;
            Seq partitions = (Seq)new .colon.colon((Object)new CatalogTablePartition((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key1"), (Object)"101"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key2"), (Object)"102")})), this.storageFormat(), CatalogTablePartition$.MODULE$.apply$default$3(), CatalogTablePartition$.MODULE$.apply$default$4(), CatalogTablePartition$.MODULE$.apply$default$5(), CatalogTablePartition$.MODULE$.apply$default$6()), (List)Nil$.MODULE$);
            try {
                String errMsg;
                this.client().createPartitions("default", "src_part", partitions, false);
                String $org_scalatest_assert_macro_left = errMsg = ((AnalysisException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.client().createPartitions("default", "src_part", partitions, false), ClassTag$.MODULE$.apply(PartitionsAlreadyExistException.class), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 528))).getMessage();
                String $org_scalatest_assert_macro_right = "partitions already exists";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 531));
            }
            finally {
                this.client().dropPartitions("default", "src_part", (Seq)partitions.map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.spec(), Seq$.MODULE$.canBuildFrom()), true, false, false);
            }
            return assertion;
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 522));
        this.test("createFunction", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            String functionClass = "org.apache.spark.MyFunc1";
            String string = $this.version;
            String string2 = "0.12";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.client().createFunction("default", this.function("func1", functionClass)), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 556));
            }
            this.client().createFunction("default", this.function("func1", functionClass));
            return BoxedUnit.UNIT;
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 552));
        this.test("functionExists", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            String string = $this.version;
            String string2 = "0.12";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.client().functionExists("default", "func1"), "HiveClientSuite.this.client.functionExists(\"default\", \"func1\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 567));
            }
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.client().functionExists("default", "func1"), "HiveClientSuite.this.client.functionExists(\"default\", \"func1\")", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 569));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 564));
        this.test("renameFunction", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            String string = $this.version;
            String string2 = "0.12";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.client().renameFunction("default", "func1", "func2"), ClassTag$.MODULE$.apply(NoSuchPermanentFunctionException.class), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 576));
            }
            this.client().renameFunction("default", "func1", "func2");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.client().functionExists("default", "func2"), "HiveClientSuite.this.client.functionExists(\"default\", \"func2\")", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 581));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 573));
        this.test("alterFunction", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            String functionClass = "org.apache.spark.MyFunc2";
            String string = $this.version;
            String string2 = "0.12";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.client().alterFunction("default", this.function("func2", functionClass)), ClassTag$.MODULE$.apply(NoSuchPermanentFunctionException.class), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 589));
            }
            this.client().alterFunction("default", this.function("func2", functionClass));
            return BoxedUnit.UNIT;
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 585));
        this.test("getFunction", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            String string = $this.version;
            String string2 = "0.12";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return this.intercept((Function0 & Serializable & scala.Serializable)() -> this.client().getFunction("default", "func2"), ClassTag$.MODULE$.apply(NoSuchPermanentFunctionException.class), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 600));
            }
            CatalogFunction func = this.client().getFunction("default", "func2");
            String $org_scalatest_assert_macro_left = func.className();
            String $org_scalatest_assert_macro_right = "org.apache.spark.MyFunc2";
            String string3 = $org_scalatest_assert_macro_left;
            String string4 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 606));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 597));
        this.test("getFunctionOption", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            String string = $this.version;
            String string2 = "0.12";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                Option $org_scalatest_assert_macro_left = this.client().getFunctionOption("default", "func2");
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 613));
            }
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.client().getFunctionOption("default", "func2").isDefined(), "HiveClientSuite.this.client.getFunctionOption(\"default\", \"func2\").isDefined", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 615));
            Option $org_scalatest_assert_macro_left = this.client().getFunctionOption("default", "the_func_not_exists");
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 616));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 610));
        this.test("listFunctions", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            String string = $this.version;
            String string2 = "0.12";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                Seq $org_scalatest_assert_macro_left = this.client().listFunctions("default", "fun.*");
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 623));
            }
            Seq $org_scalatest_assert_macro_left = this.client().listFunctions("default", "fun.*");
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 625));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 620));
        this.test("dropFunction", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            String string = $this.version;
            String string2 = "0.12";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.client().dropFunction("default", "func2"), ClassTag$.MODULE$.apply(NoSuchPermanentFunctionException.class), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 632));
            }
            this.client().dropFunction("default", "func2");
            Seq $org_scalatest_assert_macro_left = this.client().listFunctions("default", "fun.*");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 638));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 629));
        this.test("sql set command", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> this.client().runSqlHive("SET spark.sql.test.key=1"), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 646));
        this.test("sql create index and reset", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            String string = $this.version;
            String string2 = "3.0";
            if (string == null ? string2 != null : !string.equals(string2)) {
                String string3 = $this.version;
                String string4 = "3.1";
                if (string3 == null ? string4 != null : !string3.equals(string4)) {
                    this.client().runSqlHive("CREATE TABLE indexed_table (key INT)");
                    return this.client().runSqlHive("CREATE INDEX index_1 ON TABLE indexed_table(key) as 'COMPACT' WITH DEFERRED REBUILD");
                }
            }
            return BoxedUnit.UNIT;
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 650));
        this.test("sql read hive materialized view", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)((Function0 & Serializable & scala.Serializable)() -> HiveClientSuite.$anonfun$new$75(this)), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 659));
        this.test("version", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            String $org_scalatest_assert_macro_left = this.client().version().fullVersion();
            String $org_scalatest_assert_macro_right = $this.version;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "startsWith", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.startsWith($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 679));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 678));
        this.test("getConf", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer("success");
            String $org_scalatest_assert_macro_right = this.client().getConf("test", null);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 683));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 682));
        this.test("setOut", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.client().setOut(new PrintStream(new ByteArrayOutputStream())), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 686));
        this.test("setInfo", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.client().setInfo(new PrintStream(new ByteArrayOutputStream())), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 690));
        this.test("setError", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.client().setError(new PrintStream(new ByteArrayOutputStream())), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 694));
        this.test("newSession", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            HiveClient newClient;
            HiveClient $org_scalatest_assert_macro_left = newClient = this.client().newSession();
            Object $org_scalatest_assert_macro_right = null;
            HiveClient hiveClient = $org_scalatest_assert_macro_left;
            Object var5_4 = null;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", null, hiveClient == null ? var5_4 != null : !hiveClient.equals(var5_4), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 700));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 698));
        this.test("withHiveState and addJar", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            String newClassPath = ".";
            this.client().addJar(newClassPath);
            return BoxesRunTime.unboxToBoolean((Object)this.client().withHiveState((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                MutableURLClassLoader classLoader = (MutableURLClassLoader)Thread.currentThread().getContextClassLoader();
                URL[] urls = classLoader.getURLs();
                return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])urls)).contains((Object)new File(newClassPath).toURI().toURL());
            }));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 703));
        this.test("reset", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            this.client().reset();
            Seq $org_scalatest_assert_macro_left = this.client().listTables("default");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 720));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 717));
        this.test("CREATE TABLE AS SELECT", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tbl"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Bool bool;
            this.versionSpark().sql("CREATE TABLE tbl AS SELECT 1 AS a");
            Seq $org_scalatest_assert_macro_left = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.versionSpark().table("tbl").collect())).toSeq();
            Seq $org_scalatest_assert_macro_right = (Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})), (List)Nil$.MODULE$);
            Seq seq = $org_scalatest_assert_macro_left;
            Seq seq2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(seq != null ? !seq.equals(seq2) : seq2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 730));
            CatalogTable tableMeta = this.versionSpark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply("tbl"));
            Option totalSize = tableMeta.stats().map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.sizeInBytes());
            String string = $this.version;
            String string2 = "0.12";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                Option $org_scalatest_assert_macro_left2 = totalSize;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 735));
                return;
            }
            Option $org_scalatest_assert_macro_left3 = totalSize;
            Bool $org_scalatest_assert_macro_left4 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "nonEmpty", $org_scalatest_assert_macro_left3.nonEmpty(), Prettifier$.MODULE$.default());
            if ($org_scalatest_assert_macro_left4.value()) {
                BigInt $org_scalatest_assert_macro_left5 = (BigInt)totalSize.get();
                BigInt $org_scalatest_assert_macro_right2 = BigInt$.MODULE$.int2bigInt(0);
                bool = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, ">", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left5.$greater((Object)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            } else {
                bool = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
            }
            Bool $org_scalatest_assert_macro_right3 = bool;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "&&", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left4.$amp$amp((Function0 & Serializable & scala.Serializable)() -> $org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 737));
        }), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 727));
        this.test("CREATE Partitioned TABLE AS SELECT", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tbl"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Bool bool;
            Assertion assertion;
            this.versionSpark().sql(new StringOps(Predef$.MODULE$.augmentString("\n          |CREATE TABLE tbl(c1 string)\n          |USING hive\n          |PARTITIONED BY (ds STRING)\n          ")).stripMargin());
            this.versionSpark().sql("INSERT OVERWRITE TABLE tbl partition (ds='2') SELECT '1'");
            Seq $org_scalatest_assert_macro_left = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.versionSpark().table("tbl").collect())).toSeq();
            Seq $org_scalatest_assert_macro_right = (Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1", "2"})), (List)Nil$.MODULE$);
            Seq seq = $org_scalatest_assert_macro_left;
            Seq seq2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(seq != null ? !seq.equals(seq2) : seq2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 752));
            Map partMeta = this.versionSpark().sessionState().catalog().getPartition(TableIdentifier$.MODULE$.apply("tbl"), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ds"), (Object)"2")}))).parameters();
            Option totalSize = partMeta.get((Object)"totalSize").map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToLong((long)HiveClientSuite.$anonfun$new$93(x$8)));
            Option numFiles = partMeta.get((Object)"numFiles").map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToLong((long)HiveClientSuite.$anonfun$new$94(x$9)));
            String string = $this.version;
            String string2 = "0.12";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                Bool bool2;
                Option $org_scalatest_assert_macro_left2 = totalSize;
                Bool $org_scalatest_assert_macro_left3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
                if ($org_scalatest_assert_macro_left3.value()) {
                    Option $org_scalatest_assert_macro_left4 = numFiles;
                    bool2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left4, "isEmpty", $org_scalatest_assert_macro_left4.isEmpty(), Prettifier$.MODULE$.default());
                } else {
                    bool2 = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
                }
                Bool $org_scalatest_assert_macro_right2 = bool2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "&&", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left3.$amp$amp((Function0 & Serializable & scala.Serializable)() -> $org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 759));
            } else {
                Bool bool3;
                Option $org_scalatest_assert_macro_left5 = totalSize;
                Bool $org_scalatest_assert_macro_left6 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left5, "nonEmpty", $org_scalatest_assert_macro_left5.nonEmpty(), Prettifier$.MODULE$.default());
                if ($org_scalatest_assert_macro_left6.value()) {
                    Option $org_scalatest_assert_macro_left7 = numFiles;
                    bool3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left7, "nonEmpty", $org_scalatest_assert_macro_left7.nonEmpty(), Prettifier$.MODULE$.default());
                } else {
                    bool3 = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
                }
                Bool $org_scalatest_assert_macro_right3 = bool3;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "&&", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left6.$amp$amp((Function0 & Serializable & scala.Serializable)() -> $org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
                assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 761));
            }
            this.versionSpark().sql(new StringOps(Predef$.MODULE$.augmentString("\n          |ALTER TABLE tbl PARTITION (ds='2')\n          |SET SERDEPROPERTIES ('newKey' = 'vvv')\n          ")).stripMargin());
            Map newPartMeta = this.versionSpark().sessionState().catalog().getPartition(TableIdentifier$.MODULE$.apply("tbl"), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ds"), (Object)"2")}))).parameters();
            Option newTotalSize = newPartMeta.get((Object)"totalSize").map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToLong((long)HiveClientSuite.$anonfun$new$97(x$10)));
            Option newNumFiles = newPartMeta.get((Object)"numFiles").map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToLong((long)HiveClientSuite.$anonfun$new$98(x$11)));
            String string3 = $this.version;
            String string4 = "0.12";
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                Bool bool4;
                Option $org_scalatest_assert_macro_left8 = newTotalSize;
                Bool $org_scalatest_assert_macro_left9 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left8, "isEmpty", $org_scalatest_assert_macro_left8.isEmpty(), Prettifier$.MODULE$.default());
                if ($org_scalatest_assert_macro_left9.value()) {
                    Option $org_scalatest_assert_macro_left10 = newNumFiles;
                    bool4 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left10, "isEmpty", $org_scalatest_assert_macro_left10.isEmpty(), Prettifier$.MODULE$.default());
                } else {
                    bool4 = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
                }
                Bool $org_scalatest_assert_macro_right4 = bool4;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "&&", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left9.$amp$amp((Function0 & Serializable & scala.Serializable)() -> $org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 776));
                return;
            }
            Option $org_scalatest_assert_macro_left11 = newTotalSize;
            Bool $org_scalatest_assert_macro_left12 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left11, "nonEmpty", $org_scalatest_assert_macro_left11.nonEmpty(), Prettifier$.MODULE$.default());
            if ($org_scalatest_assert_macro_left12.value()) {
                Option $org_scalatest_assert_macro_left13 = newNumFiles;
                bool = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left13, "nonEmpty", $org_scalatest_assert_macro_left13.nonEmpty(), Prettifier$.MODULE$.default());
            } else {
                bool = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
            }
            Bool $org_scalatest_assert_macro_right5 = bool;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "&&", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left12.$amp$amp((Function0 & Serializable & scala.Serializable)() -> $org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 778));
        }), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 742));
        this.test("Delete the temporary staging directory and files after each insert", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1 & Serializable & scala.Serializable)tmpDir -> {
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tab"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.versionSpark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(82).append("\n             |CREATE TABLE tab(c1 string)\n             |location '").append(tmpDir.toURI().toString()).append("'\n             ").toString())).stripMargin());
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 3).map((Function1 & Serializable & scala.Serializable)i -> HiveClientSuite.$anonfun$new$104($this, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
                Seq metadataFiles = (Seq)new .colon.colon((Object)"._SUCCESS.crc", (List)new .colon.colon((Object)"_SUCCESS", (List)Nil$.MODULE$));
                List $org_scalatest_assert_macro_left = (List)HiveClientSuite.listFiles$1(tmpDir).filterNot((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)metadataFiles.contains(elem)));
                int $org_scalatest_assert_macro_right = 2;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 804));
            });
            return BoxedUnit.UNIT;
        }), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 783));
        this.test("SPARK-13709: reading partitioned Avro table with nested schema", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1 & Serializable & scala.Serializable)dir -> {
            HiveClientSuite.$anonfun$new$110(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 809));
        this.test("CTAS for managed data source tables", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t", "t1"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.versionSpark().range(1L).write().saveAsTable("t");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.versionSpark().table("t").collect());
            Row[] $org_scalatest_assert_macro_right = (Row[])((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0)}))});
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 889));
            this.versionSpark().sql("create table t1 using parquet as select 2 as a");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(this.versionSpark().table("t1").collect());
            Row[] $org_scalatest_assert_macro_right2 = (Row[])((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2)}))});
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 891));
        }), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 886));
        this.test("Decimal support of Avro Hive serde", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String tableName = "tab1";
            String avroSchema = new StringOps(Predef$.MODULE$.augmentString("{\n      |  \"name\": \"test_record\",\n      |  \"type\": \"record\",\n      |  \"fields\": [ {\n      |    \"name\": \"f0\",\n      |    \"type\": [\n      |      \"null\",\n      |      {\n      |        \"precision\": 38,\n      |        \"scale\": 2,\n      |        \"type\": \"bytes\",\n      |        \"logicalType\": \"decimal\"\n      |      }\n      |    ]\n      |  } ]\n      |}\n        ")).stripMargin();
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, false}))).foreach((Function1 & Serializable & scala.Serializable)isPartitioned -> {
                this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tableName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    String insertStmt;
                    block8: {
                        String e;
                        String errorMsg;
                        block7: {
                            block4: {
                                String insertStmt2;
                                block6: {
                                    String e2;
                                    block5: {
                                        String partitionClause = isPartitioned ? "PARTITIONED BY (ds STRING)" : "";
                                        $this.versionSpark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(394).append("\n             |CREATE TABLE ").append(tableName$2).append("\n             |").append(partitionClause).append("\n             |ROW FORMAT SERDE 'org.apache.hadoop.hive.serde2.avro.AvroSerDe'\n             |STORED AS\n             |  INPUTFORMAT 'org.apache.hadoop.hive.ql.io.avro.AvroContainerInputFormat'\n             |  OUTPUTFORMAT 'org.apache.hadoop.hive.ql.io.avro.AvroContainerOutputFormat'\n             |TBLPROPERTIES ('avro.schema.literal' = '").append(avroSchema$2).append("')\n           ").toString())).stripMargin());
                                        errorMsg = "Cannot safely cast 'f0': decimal(2,1) to binary";
                                        if (!isPartitioned) break block4;
                                        insertStmt2 = new StringBuilder(53).append("INSERT OVERWRITE TABLE ").append(tableName$2).append(" partition (ds='a') SELECT 1.3").toString();
                                        String string = $this.version;
                                        String string2 = "0.12";
                                        if (!(string == null ? string2 != null : !string.equals(string2))) break block5;
                                        String string3 = $this.version;
                                        String string4 = "0.13";
                                        if (string3 != null ? !string3.equals(string4) : string4 != null) break block6;
                                    }
                                    String $org_scalatest_assert_macro_left = e2 = ((AnalysisException)$this.intercept((Function0 & Serializable & scala.Serializable)() -> $this.versionSpark().sql(insertStmt2), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 939))).getMessage();
                                    String $org_scalatest_assert_macro_right = errorMsg;
                                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 940));
                                    return;
                                }
                                $this.versionSpark().sql(insertStmt2);
                                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer($this.versionSpark().table(tableName$2).collect());
                                Row[] $org_scalatest_assert_macro_right = (Row[])$this.versionSpark().sql("SELECT 1.30, 'a'").collect();
                                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 943));
                                return;
                            }
                            insertStmt = new StringBuilder(34).append("INSERT OVERWRITE TABLE ").append(tableName$2).append(" SELECT 1.3").toString();
                            String string = $this.version;
                            String string5 = "0.12";
                            if (!(string == null ? string5 != null : !string.equals(string5))) break block7;
                            String string6 = $this.version;
                            String string7 = "0.13";
                            if (string6 != null ? !string6.equals(string7) : string7 != null) break block8;
                        }
                        String $org_scalatest_assert_macro_left = e = ((AnalysisException)$this.intercept((Function0 & Serializable & scala.Serializable)() -> $this.versionSpark().sql(insertStmt), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 949))).getMessage();
                        String $org_scalatest_assert_macro_right = errorMsg;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 950));
                        return;
                    }
                    $this.versionSpark().sql(insertStmt);
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer($this.versionSpark().table(tableName$2).collect());
                    Row[] $org_scalatest_assert_macro_right = (Row[])$this.versionSpark().sql("SELECT 1.30").collect();
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 953));
                });
                return BoxedUnit.UNIT;
            });
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 895));
        this.test("read avro file containing decimal", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            URL url = Thread.currentThread().getContextClassLoader().getResource("avroDecimal");
            String location = new File(url.getFile()).toURI().toString();
            String tableName = "tab1";
            String avroSchema = new StringOps(Predef$.MODULE$.augmentString("{\n        |  \"name\": \"test_record\",\n        |  \"type\": \"record\",\n        |  \"fields\": [ {\n        |    \"name\": \"f0\",\n        |    \"type\": [\n        |      \"null\",\n        |      {\n        |        \"precision\": 38,\n        |        \"scale\": 2,\n        |        \"type\": \"bytes\",\n        |        \"logicalType\": \"decimal\"\n        |      }\n        |    ]\n        |  } ]\n        |}\n        ")).stripMargin();
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tableName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.versionSpark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(456).append("\n           |CREATE TABLE ").append(tableName).append("\n           |ROW FORMAT SERDE 'org.apache.hadoop.hive.serde2.avro.AvroSerDe'\n           |WITH SERDEPROPERTIES ('respectSparkSchema' = 'true')\n           |STORED AS\n           |  INPUTFORMAT 'org.apache.hadoop.hive.ql.io.avro.AvroContainerInputFormat'\n           |  OUTPUTFORMAT 'org.apache.hadoop.hive.ql.io.avro.AvroContainerOutputFormat'\n           |LOCATION '").append(location).append("'\n           |TBLPROPERTIES ('avro.schema.literal' = '").append(avroSchema).append("')\n           ").toString())).stripMargin());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.versionSpark().table(tableName).collect());
                Row[] $org_scalatest_assert_macro_right = (Row[])this.versionSpark().sql("SELECT 1.30").collect();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 997));
            });
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 961));
        this.test("SPARK-17920: Insert into/overwrite avro table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Bool bool;
            Bool $org_scalatest_assert_macro_left = Bool$.MODULE$.simpleMacroBool(Utils$.MODULE$.isWindows(), "org.apache.spark.util.Utils.isWindows", Prettifier$.MODULE$.default());
            if ($org_scalatest_assert_macro_left.value()) {
                String $org_scalatest_assert_macro_left2 = $this.version;
                String $org_scalatest_assert_macro_right = "0.12";
                String string = $org_scalatest_assert_macro_left2;
                String string2 = $org_scalatest_assert_macro_right;
                bool = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            } else {
                bool = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
            }
            Bool $org_scalatest_assert_macro_right = bool;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "&&", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$amp$amp((Function0 & Serializable & scala.Serializable)() -> $org_scalatest_assert_macro_right), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssume($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1004));
            this.withTempDir((Function1 & Serializable & scala.Serializable)dir -> {
                HiveClientSuite.$anonfun$new$123(this, dir);
                return BoxedUnit.UNIT;
            });
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1002));
    }
}

