/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive;

import java.io.File;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.TestUtils$;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.UI$;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogUtils$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.hive.test.TestHiveContext;
import org.apache.spark.sql.hive.test.TestHiveContext$;
import org.apache.spark.sql.hive.test.TestHiveSparkSession;
import org.apache.spark.sql.internal.StaticSQLConf$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.runtime.BoxesRunTime;

public final class SetWarehouseLocationTest$
implements Logging {
    public static SetWarehouseLocationTest$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new SetWarehouseLocationTest$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public void main(String[] args) {
        URI actualLocation;
        URI actualLocation2;
        Tuple2 tuple2;
        Option providedExpectedWarehouseLocation;
        TestUtils$.MODULE$.configTestLog4j2("INFO");
        SparkConf sparkConf = new SparkConf(true).set(UI$.MODULE$.UI_ENABLED(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
        Option option = providedExpectedWarehouseLocation = sparkConf.getOption("spark.sql.test.expectedWarehouseDir");
        if (option instanceof Some) {
            Some some = (Some)option;
            String warehouseDir = (String)some.value();
            tuple2 = new Tuple2((Object)new TestHiveContext(new SparkContext(sparkConf), TestHiveContext$.MODULE$.$lessinit$greater$default$2()).sparkSession(), (Object)warehouseDir);
        } else if (None$.MODULE$.equals(option)) {
            File warehouseLocation = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
            warehouseLocation.delete();
            File hiveWarehouseLocation = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
            hiveWarehouseLocation.delete();
            TestHiveSparkSession session = new TestHiveContext(new SparkContext(sparkConf.set(StaticSQLConf$.MODULE$.WAREHOUSE_PATH().key(), warehouseLocation.toString()).set("hive.metastore.warehouse.dir", hiveWarehouseLocation.toString())), TestHiveContext$.MODULE$.$lessinit$greater$default$2()).sparkSession();
            tuple2 = new Tuple2((Object)session, (Object)warehouseLocation.toString());
        } else {
            throw new MatchError((Object)option);
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        TestHiveSparkSession sparkSession = (TestHiveSparkSession)((Object)tuple22._1());
        String expectedWarehouseLocation = (String)tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)sparkSession, (Object)expectedWarehouseLocation);
        TestHiveSparkSession sparkSession2 = (TestHiveSparkSession)((Object)tuple23._1());
        String expectedWarehouseLocation2 = (String)tuple23._2();
        String qualifiedWHPath = FileUtils.makeQualified((Path)new Path(expectedWarehouseLocation2), (Configuration)sparkSession2.sparkContext().hadoopConfiguration()).toString();
        String string = sparkSession2.conf().get(StaticSQLConf$.MODULE$.WAREHOUSE_PATH().key());
        String string2 = qualifiedWHPath;
        if (string == null ? string2 != null : !string.equals(string2)) {
            throw new Exception(new StringBuilder(48).append(StaticSQLConf$.MODULE$.WAREHOUSE_PATH().key()).append(" is not set to the expected warehouse location ").append(qualifiedWHPath).append(".").toString());
        }
        SessionCatalog catalog = sparkSession2.sessionState().catalog();
        sparkSession2.sql("drop table if exists testLocation");
        sparkSession2.sql("drop database if exists testLocationDB cascade");
        sparkSession2.sql("create table testLocation (a int)");
        CatalogTable tableMetadata = catalog.getTableMetadata(new TableIdentifier("testLocation", (Option)new Some((Object)"default")));
        URI expectedLocation = CatalogUtils$.MODULE$.stringToURI(new StringBuilder(13).append(qualifiedWHPath).append("/testlocation").toString());
        URI uRI = actualLocation2 = tableMetadata.location();
        URI uRI2 = expectedLocation;
        if (uRI == null ? uRI2 != null : !((Object)uRI).equals(uRI2)) {
            throw new Exception(new StringBuilder(49).append("Expected table location is ").append(expectedLocation).append(". But, it is actually ").append(actualLocation2).toString());
        }
        sparkSession2.sql("drop table testLocation");
        sparkSession2.sql("create database testLocationDB");
        sparkSession2.sql("use testLocationDB");
        sparkSession2.sql("create table testLocation (a int)");
        CatalogTable tableMetadata2 = catalog.getTableMetadata(new TableIdentifier("testLocation", (Option)new Some((Object)"testLocationDB")));
        URI expectedLocation2 = CatalogUtils$.MODULE$.stringToURI(new StringBuilder(31).append(qualifiedWHPath).append("/testlocationdb.db/testlocation").toString());
        URI uRI3 = actualLocation = tableMetadata2.location();
        URI uRI4 = expectedLocation2;
        if (uRI3 == null ? uRI4 != null : !((Object)uRI3).equals(uRI4)) {
            throw new Exception(new StringBuilder(49).append("Expected table location is ").append(expectedLocation2).append(". But, it is actually ").append(actualLocation).toString());
        }
        sparkSession2.sql("drop table testLocation");
        sparkSession2.sql("use default");
        sparkSession2.sql("drop database testLocationDB");
    }

    private SetWarehouseLocationTest$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

