/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.QueryTest;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.columnar.InMemoryRelation;
import org.apache.spark.sql.execution.columnar.InMemoryTableScanExec;
import org.apache.spark.sql.execution.datasources.CatalogFileIndex;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.FileIndex;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.datasources.LogicalRelation$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat;
import org.apache.spark.sql.hive.client.HiveClient;
import org.apache.spark.sql.hive.test.TestHiveContext;
import org.apache.spark.sql.hive.test.TestHiveSingleton;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.test.SQLTestData;
import org.apache.spark.sql.test.SQLTestData$internalImplicits$;
import org.apache.spark.sql.test.SQLTestUtils;
import org.apache.spark.sql.test.SQLTestUtilsBase;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.storage.BlockResult;
import org.apache.spark.storage.RDDBlockId;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import org.scalatest.concurrent.AbstractPatienceConfiguration;
import org.scalatest.concurrent.AbstractPatienceConfiguration$PatienceConfig$;
import org.scalatest.concurrent.Eventually;
import org.scalatest.concurrent.PatienceConfiguration;
import org.scalatest.concurrent.ScaledTimeSpans;
import org.scalatest.enablers.Retrying;
import org.scalatest.funsuite.AnyFunSuiteLike;
import org.scalatest.time.Span;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u001d3A!\u0002\u0004\u0001#!)\u0011\u0005\u0001C\u0001E!)Q\u0005\u0001C\u0001M!)!\b\u0001C\u0001w!)\u0011\t\u0001C\u0005\u0005\n\u00012)Y2iK\u0012$\u0016M\u00197f'VLG/\u001a\u0006\u0003\u000f!\tA\u0001[5wK*\u0011\u0011BC\u0001\u0004gFd'BA\u0006\r\u0003\u0015\u0019\b/\u0019:l\u0015\tia\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001f\u0005\u0019qN]4\u0004\u0001M!\u0001A\u0005\f\u001d!\t\u0019B#D\u0001\t\u0013\t)\u0002BA\u0005Rk\u0016\u0014\u0018\u0010V3tiB\u0011qCG\u0007\u00021)\u0011\u0011\u0004C\u0001\u0005i\u0016\u001cH/\u0003\u0002\u001c1\ta1+\u0015'UKN$X\u000b^5mgB\u0011QdH\u0007\u0002=)\u0011\u0011DB\u0005\u0003Ay\u0011\u0011\u0003V3ti\"Kg/Z*j]\u001edW\r^8o\u0003\u0019a\u0014N\\5u}Q\t1\u0005\u0005\u0002%\u00015\ta!A\u0004sI\u0012LEm\u00144\u0015\u0005\u001dj\u0003C\u0001\u0015,\u001b\u0005I#\"\u0001\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00051J#aA%oi\")aF\u0001a\u0001_\u0005IA/\u00192mK:\u000bW.\u001a\t\u0003a]r!!M\u001b\u0011\u0005IJS\"A\u001a\u000b\u0005Q\u0002\u0012A\u0002\u001fs_>$h(\u0003\u00027S\u00051\u0001K]3eK\u001aL!\u0001O\u001d\u0003\rM#(/\u001b8h\u0015\t1\u0014&\u0001\bjg6\u000bG/\u001a:jC2L'0\u001a3\u0015\u0005qz\u0004C\u0001\u0015>\u0013\tq\u0014FA\u0004C_>dW-\u00198\t\u000b\u0001\u001b\u0001\u0019A\u0014\u0002\u000bI$G-\u00133\u0002)\u001d,G\u000fU1si&$\u0018n\u001c8M_\u000e\fG/[8o)\ry3)\u0012\u0005\u0006\t\u0012\u0001\raL\u0001\u0002i\")a\t\u0002a\u0001_\u0005I\u0001/\u0019:uSRLwN\u001c")
public class CachedTableSuite
extends QueryTest
implements SQLTestUtils,
TestHiveSingleton {
    private final boolean enableAutoThreadAudit;
    private final SparkSession spark;
    private final TestHiveContext hiveContext;
    private final HiveClient hiveClient;
    private boolean org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests;
    private Function1<String, Dataset<Row>> sql;
    private volatile SQLTestUtilsBase.testImplicits$ testImplicits$module;
    private volatile SQLTestData$internalImplicits$ internalImplicits$module;
    private Dataset<Row> emptyTestData;
    private Dataset<Row> testData;
    private Dataset<Row> testData2;
    private Dataset<Row> testData3;
    private Dataset<Row> negativeData;
    private Dataset<Row> largeAndSmallInts;
    private Dataset<Row> decimalData;
    private Dataset<Row> binaryData;
    private Dataset<Row> upperCaseData;
    private Dataset<Row> lowerCaseData;
    private Dataset<Row> lowerCaseDataWithDuplicates;
    private RDD<SQLTestData.ArrayData> arrayData;
    private RDD<SQLTestData.MapData> mapData;
    private RDD<SQLTestData.IntervalData> calendarIntervalData;
    private RDD<SQLTestData.StringData> repeatedData;
    private RDD<SQLTestData.StringData> nullableRepeatedData;
    private Dataset<Row> nullInts;
    private Dataset<Row> allNulls;
    private Dataset<Row> nullStrings;
    private Dataset<Row> tableName;
    private RDD<String> unparsedStrings;
    private RDD<SQLTestData.IntField> withEmptyParts;
    private Dataset<Row> person;
    private Dataset<Row> salary;
    private Dataset<Row> complexData;
    private Dataset<Row> courseSales;
    private Dataset<Row> trainingSales;
    private Dataset<Row> intervalData;
    private final AbstractPatienceConfiguration.PatienceConfig org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig;
    private volatile AbstractPatienceConfiguration$PatienceConfig$ PatienceConfig$module;
    private volatile int bitmap$0;

    @Override
    public /* synthetic */ void org$apache$spark$sql$hive$test$TestHiveSingleton$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public void afterAll() {
        TestHiveSingleton.afterAll$(this);
    }

    public /* synthetic */ void org$apache$spark$sql$test$SQLTestUtils$$super$beforeAll() {
        super.beforeAll();
    }

    public /* synthetic */ void org$apache$spark$sql$test$SQLTestUtils$$super$withTempDir(Function1 f) {
        super.withTempDir(f);
    }

    public /* synthetic */ void org$apache$spark$sql$test$SQLTestUtils$$super$test(String testName, Seq testTags, Function0 testFun, Position pos) {
        AnyFunSuiteLike.test$((AnyFunSuiteLike)this, (String)testName, (Seq)testTags, (Function0)testFun, (Position)pos);
    }

    public void beforeAll() {
        SQLTestUtils.beforeAll$((SQLTestUtils)this);
    }

    public void withTempDir(Function1<File, BoxedUnit> f) {
        SQLTestUtils.withTempDir$((SQLTestUtils)this, f);
    }

    public void testWithWholeStageCodegenOnAndOff(String testName, Function1<String, BoxedUnit> f) {
        SQLTestUtils.testWithWholeStageCodegenOnAndOff$((SQLTestUtils)this, (String)testName, f);
    }

    public void setupTestData() {
        SQLTestUtils.setupTestData$((SQLTestUtils)this);
    }

    public void testQuietly(String name, Function0<BoxedUnit> f) {
        SQLTestUtils.testQuietly$((SQLTestUtils)this, (String)name, f);
    }

    public void test(String testName, Seq<Tag> testTags, Function0<Object> testFun, Position pos) {
        SQLTestUtils.test$((SQLTestUtils)this, (String)testName, testTags, testFun, (Position)pos);
    }

    public void testWithUninterruptibleThread(String name, boolean quietly, Function0<BoxedUnit> body) {
        SQLTestUtils.testWithUninterruptibleThread$((SQLTestUtils)this, (String)name, (boolean)quietly, body);
    }

    public boolean testWithUninterruptibleThread$default$2() {
        return SQLTestUtils.testWithUninterruptibleThread$default$2$((SQLTestUtils)this);
    }

    public void withResourceTempPath(String resourcePath, Function1<File, BoxedUnit> f) {
        SQLTestUtils.withResourceTempPath$((SQLTestUtils)this, (String)resourcePath, f);
    }

    public void waitForTasksToFinish() {
        SQLTestUtils.waitForTasksToFinish$((SQLTestUtils)this);
    }

    public void withTempPaths(int numPaths, Function1<Seq<File>, BoxedUnit> f) {
        SQLTestUtils.withTempPaths$((SQLTestUtils)this, (int)numPaths, f);
    }

    public /* synthetic */ void org$apache$spark$sql$test$SQLTestUtilsBase$$super$withSQLConf(Seq pairs, Function0 f) {
        SQLHelper.withSQLConf$((SQLHelper)this, (Seq)pairs, (Function0)f);
    }

    public SparkContext sparkContext() {
        return SQLTestUtilsBase.sparkContext$((SQLTestUtilsBase)this);
    }

    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withSQLConf$((SQLTestUtilsBase)this, pairs, f);
    }

    public void withUserDefinedFunction(Seq<Tuple2<String, Object>> functions2, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withUserDefinedFunction$((SQLTestUtilsBase)this, functions2, f);
    }

    public void withTempView(Seq<String> viewNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withTempView$((SQLTestUtilsBase)this, viewNames, f);
    }

    public void withGlobalTempView(Seq<String> viewNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withGlobalTempView$((SQLTestUtilsBase)this, viewNames, f);
    }

    public void withTable(Seq<String> tableNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withTable$((SQLTestUtilsBase)this, tableNames, f);
    }

    public void withView(Seq<String> viewNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withView$((SQLTestUtilsBase)this, viewNames, f);
    }

    public void withCache(Seq<String> cacheNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withCache$((SQLTestUtilsBase)this, cacheNames, f);
    }

    public void uncacheTable(String tableName) {
        SQLTestUtilsBase.uncacheTable$((SQLTestUtilsBase)this, (String)tableName);
    }

    public void withTempDatabase(Function1<String, BoxedUnit> f) {
        SQLTestUtilsBase.withTempDatabase$((SQLTestUtilsBase)this, f);
    }

    public void withDatabase(Seq<String> dbNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withDatabase$((SQLTestUtilsBase)this, dbNames, f);
    }

    public void withNamespace(Seq<String> namespaces, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withNamespace$((SQLTestUtilsBase)this, namespaces, f);
    }

    public void withCurrentCatalogAndNamespace(Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withCurrentCatalogAndNamespace$((SQLTestUtilsBase)this, f);
    }

    public void withLocale(String language, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withLocale$((SQLTestUtilsBase)this, (String)language, f);
    }

    public void activateDatabase(String db, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.activateDatabase$((SQLTestUtilsBase)this, (String)db, f);
    }

    public Dataset<Row> stripSparkFilter(Dataset<Row> df) {
        return SQLTestUtilsBase.stripSparkFilter$((SQLTestUtilsBase)this, df);
    }

    public Dataset<Row> logicalPlanToSparkQuery(LogicalPlan plan) {
        return SQLTestUtilsBase.logicalPlanToSparkQuery$((SQLTestUtilsBase)this, (LogicalPlan)plan);
    }

    public URI makeQualifiedPath(String path) {
        return SQLTestUtilsBase.makeQualifiedPath$((SQLTestUtilsBase)this, (String)path);
    }

    public String testFile(String fileName) {
        return SQLTestUtilsBase.testFile$((SQLTestUtilsBase)this, (String)fileName);
    }

    public long getLocalDirSize(File file) {
        return SQLTestUtilsBase.getLocalDirSize$((SQLTestUtilsBase)this, (File)file);
    }

    public void loadTestData() {
        SQLTestData.loadTestData$((SQLTestData)this);
    }

    public <T> T eventually(PatienceConfiguration.Timeout timeout, PatienceConfiguration.Interval interval, Function0<T> fun, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Timeout)timeout, (PatienceConfiguration.Interval)interval, fun, retrying, (Position)pos);
    }

    public <T> T eventually(PatienceConfiguration.Timeout timeout, Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Timeout)timeout, fun, (AbstractPatienceConfiguration.PatienceConfig)config, retrying, (Position)pos);
    }

    public <T> T eventually(PatienceConfiguration.Interval interval, Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Interval)interval, fun, (AbstractPatienceConfiguration.PatienceConfig)config, retrying, (Position)pos);
    }

    public <T> T eventually(Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, fun, (AbstractPatienceConfiguration.PatienceConfig)config, retrying, (Position)pos);
    }

    public AbstractPatienceConfiguration.PatienceConfig patienceConfig() {
        return PatienceConfiguration.patienceConfig$((PatienceConfiguration)this);
    }

    public PatienceConfiguration.Timeout timeout(Span value) {
        return PatienceConfiguration.timeout$((PatienceConfiguration)this, (Span)value);
    }

    public PatienceConfiguration.Interval interval(Span value) {
        return PatienceConfiguration.interval$((PatienceConfiguration)this, (Span)value);
    }

    public final Span scaled(Span span) {
        return ScaledTimeSpans.scaled$((ScaledTimeSpans)this, (Span)span);
    }

    public double spanScaleFactor() {
        return ScaledTimeSpans.spanScaleFactor$((ScaledTimeSpans)this);
    }

    @Override
    public boolean enableAutoThreadAudit() {
        return this.enableAutoThreadAudit;
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public TestHiveContext hiveContext() {
        return this.hiveContext;
    }

    @Override
    public HiveClient hiveClient() {
        return this.hiveClient;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$enableAutoThreadAudit_$eq(boolean x$1) {
        this.enableAutoThreadAudit = x$1;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$hiveContext_$eq(TestHiveContext x$1) {
        this.hiveContext = x$1;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$hiveClient_$eq(HiveClient x$1) {
        this.hiveClient = x$1;
    }

    public boolean org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests() {
        return this.org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests;
    }

    public void org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests_$eq(boolean x$1) {
        this.org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests = x$1;
    }

    private Function1<String, Dataset<Row>> sql$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 1) == 0) {
                this.sql = SQLTestUtilsBase.sql$((SQLTestUtilsBase)this);
                this.bitmap$0 |= 1;
            }
        }
        return this.sql;
    }

    public Function1<String, Dataset<Row>> sql() {
        if ((this.bitmap$0 & 1) == 0) {
            return this.sql$lzycompute();
        }
        return this.sql;
    }

    public SQLTestUtilsBase.testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    public SQLTestData$internalImplicits$ org$apache$spark$sql$test$SQLTestData$$internalImplicits() {
        if (this.internalImplicits$module == null) {
            this.org$apache$spark$sql$test$SQLTestData$$internalImplicits$lzycompute$1();
        }
        return this.internalImplicits$module;
    }

    private Dataset<Row> emptyTestData$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 2) == 0) {
                this.emptyTestData = SQLTestData.emptyTestData$((SQLTestData)this);
                this.bitmap$0 |= 2;
            }
        }
        return this.emptyTestData;
    }

    public Dataset<Row> emptyTestData() {
        if ((this.bitmap$0 & 2) == 0) {
            return this.emptyTestData$lzycompute();
        }
        return this.emptyTestData;
    }

    private Dataset<Row> testData$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 4) == 0) {
                this.testData = SQLTestData.testData$((SQLTestData)this);
                this.bitmap$0 |= 4;
            }
        }
        return this.testData;
    }

    public Dataset<Row> testData() {
        if ((this.bitmap$0 & 4) == 0) {
            return this.testData$lzycompute();
        }
        return this.testData;
    }

    private Dataset<Row> testData2$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 8) == 0) {
                this.testData2 = SQLTestData.testData2$((SQLTestData)this);
                this.bitmap$0 |= 8;
            }
        }
        return this.testData2;
    }

    public Dataset<Row> testData2() {
        if ((this.bitmap$0 & 8) == 0) {
            return this.testData2$lzycompute();
        }
        return this.testData2;
    }

    private Dataset<Row> testData3$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 0x10) == 0) {
                this.testData3 = SQLTestData.testData3$((SQLTestData)this);
                this.bitmap$0 |= 0x10;
            }
        }
        return this.testData3;
    }

    public Dataset<Row> testData3() {
        if ((this.bitmap$0 & 0x10) == 0) {
            return this.testData3$lzycompute();
        }
        return this.testData3;
    }

    private Dataset<Row> negativeData$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 0x20) == 0) {
                this.negativeData = SQLTestData.negativeData$((SQLTestData)this);
                this.bitmap$0 |= 0x20;
            }
        }
        return this.negativeData;
    }

    public Dataset<Row> negativeData() {
        if ((this.bitmap$0 & 0x20) == 0) {
            return this.negativeData$lzycompute();
        }
        return this.negativeData;
    }

    private Dataset<Row> largeAndSmallInts$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 0x40) == 0) {
                this.largeAndSmallInts = SQLTestData.largeAndSmallInts$((SQLTestData)this);
                this.bitmap$0 |= 0x40;
            }
        }
        return this.largeAndSmallInts;
    }

    public Dataset<Row> largeAndSmallInts() {
        if ((this.bitmap$0 & 0x40) == 0) {
            return this.largeAndSmallInts$lzycompute();
        }
        return this.largeAndSmallInts;
    }

    private Dataset<Row> decimalData$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 0x80) == 0) {
                this.decimalData = SQLTestData.decimalData$((SQLTestData)this);
                this.bitmap$0 |= 0x80;
            }
        }
        return this.decimalData;
    }

    public Dataset<Row> decimalData() {
        if ((this.bitmap$0 & 0x80) == 0) {
            return this.decimalData$lzycompute();
        }
        return this.decimalData;
    }

    private Dataset<Row> binaryData$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 0x100) == 0) {
                this.binaryData = SQLTestData.binaryData$((SQLTestData)this);
                this.bitmap$0 |= 0x100;
            }
        }
        return this.binaryData;
    }

    public Dataset<Row> binaryData() {
        if ((this.bitmap$0 & 0x100) == 0) {
            return this.binaryData$lzycompute();
        }
        return this.binaryData;
    }

    private Dataset<Row> upperCaseData$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 0x200) == 0) {
                this.upperCaseData = SQLTestData.upperCaseData$((SQLTestData)this);
                this.bitmap$0 |= 0x200;
            }
        }
        return this.upperCaseData;
    }

    public Dataset<Row> upperCaseData() {
        if ((this.bitmap$0 & 0x200) == 0) {
            return this.upperCaseData$lzycompute();
        }
        return this.upperCaseData;
    }

    private Dataset<Row> lowerCaseData$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 0x400) == 0) {
                this.lowerCaseData = SQLTestData.lowerCaseData$((SQLTestData)this);
                this.bitmap$0 |= 0x400;
            }
        }
        return this.lowerCaseData;
    }

    public Dataset<Row> lowerCaseData() {
        if ((this.bitmap$0 & 0x400) == 0) {
            return this.lowerCaseData$lzycompute();
        }
        return this.lowerCaseData;
    }

    private Dataset<Row> lowerCaseDataWithDuplicates$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 0x800) == 0) {
                this.lowerCaseDataWithDuplicates = SQLTestData.lowerCaseDataWithDuplicates$((SQLTestData)this);
                this.bitmap$0 |= 0x800;
            }
        }
        return this.lowerCaseDataWithDuplicates;
    }

    public Dataset<Row> lowerCaseDataWithDuplicates() {
        if ((this.bitmap$0 & 0x800) == 0) {
            return this.lowerCaseDataWithDuplicates$lzycompute();
        }
        return this.lowerCaseDataWithDuplicates;
    }

    private RDD<SQLTestData.ArrayData> arrayData$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 0x1000) == 0) {
                this.arrayData = SQLTestData.arrayData$((SQLTestData)this);
                this.bitmap$0 |= 0x1000;
            }
        }
        return this.arrayData;
    }

    public RDD<SQLTestData.ArrayData> arrayData() {
        if ((this.bitmap$0 & 0x1000) == 0) {
            return this.arrayData$lzycompute();
        }
        return this.arrayData;
    }

    private RDD<SQLTestData.MapData> mapData$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 0x2000) == 0) {
                this.mapData = SQLTestData.mapData$((SQLTestData)this);
                this.bitmap$0 |= 0x2000;
            }
        }
        return this.mapData;
    }

    public RDD<SQLTestData.MapData> mapData() {
        if ((this.bitmap$0 & 0x2000) == 0) {
            return this.mapData$lzycompute();
        }
        return this.mapData;
    }

    private RDD<SQLTestData.IntervalData> calendarIntervalData$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 0x4000) == 0) {
                this.calendarIntervalData = SQLTestData.calendarIntervalData$((SQLTestData)this);
                this.bitmap$0 |= 0x4000;
            }
        }
        return this.calendarIntervalData;
    }

    public RDD<SQLTestData.IntervalData> calendarIntervalData() {
        if ((this.bitmap$0 & 0x4000) == 0) {
            return this.calendarIntervalData$lzycompute();
        }
        return this.calendarIntervalData;
    }

    private RDD<SQLTestData.StringData> repeatedData$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 0x8000) == 0) {
                this.repeatedData = SQLTestData.repeatedData$((SQLTestData)this);
                this.bitmap$0 |= 0x8000;
            }
        }
        return this.repeatedData;
    }

    public RDD<SQLTestData.StringData> repeatedData() {
        if ((this.bitmap$0 & 0x8000) == 0) {
            return this.repeatedData$lzycompute();
        }
        return this.repeatedData;
    }

    private RDD<SQLTestData.StringData> nullableRepeatedData$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 0x10000) == 0) {
                this.nullableRepeatedData = SQLTestData.nullableRepeatedData$((SQLTestData)this);
                this.bitmap$0 |= 0x10000;
            }
        }
        return this.nullableRepeatedData;
    }

    public RDD<SQLTestData.StringData> nullableRepeatedData() {
        if ((this.bitmap$0 & 0x10000) == 0) {
            return this.nullableRepeatedData$lzycompute();
        }
        return this.nullableRepeatedData;
    }

    private Dataset<Row> nullInts$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 0x20000) == 0) {
                this.nullInts = SQLTestData.nullInts$((SQLTestData)this);
                this.bitmap$0 |= 0x20000;
            }
        }
        return this.nullInts;
    }

    public Dataset<Row> nullInts() {
        if ((this.bitmap$0 & 0x20000) == 0) {
            return this.nullInts$lzycompute();
        }
        return this.nullInts;
    }

    private Dataset<Row> allNulls$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 0x40000) == 0) {
                this.allNulls = SQLTestData.allNulls$((SQLTestData)this);
                this.bitmap$0 |= 0x40000;
            }
        }
        return this.allNulls;
    }

    public Dataset<Row> allNulls() {
        if ((this.bitmap$0 & 0x40000) == 0) {
            return this.allNulls$lzycompute();
        }
        return this.allNulls;
    }

    private Dataset<Row> nullStrings$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 0x80000) == 0) {
                this.nullStrings = SQLTestData.nullStrings$((SQLTestData)this);
                this.bitmap$0 |= 0x80000;
            }
        }
        return this.nullStrings;
    }

    public Dataset<Row> nullStrings() {
        if ((this.bitmap$0 & 0x80000) == 0) {
            return this.nullStrings$lzycompute();
        }
        return this.nullStrings;
    }

    private Dataset<Row> tableName$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 0x100000) == 0) {
                this.tableName = SQLTestData.tableName$((SQLTestData)this);
                this.bitmap$0 |= 0x100000;
            }
        }
        return this.tableName;
    }

    public Dataset<Row> tableName() {
        if ((this.bitmap$0 & 0x100000) == 0) {
            return this.tableName$lzycompute();
        }
        return this.tableName;
    }

    private RDD<String> unparsedStrings$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 0x200000) == 0) {
                this.unparsedStrings = SQLTestData.unparsedStrings$((SQLTestData)this);
                this.bitmap$0 |= 0x200000;
            }
        }
        return this.unparsedStrings;
    }

    public RDD<String> unparsedStrings() {
        if ((this.bitmap$0 & 0x200000) == 0) {
            return this.unparsedStrings$lzycompute();
        }
        return this.unparsedStrings;
    }

    private RDD<SQLTestData.IntField> withEmptyParts$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 0x400000) == 0) {
                this.withEmptyParts = SQLTestData.withEmptyParts$((SQLTestData)this);
                this.bitmap$0 |= 0x400000;
            }
        }
        return this.withEmptyParts;
    }

    public RDD<SQLTestData.IntField> withEmptyParts() {
        if ((this.bitmap$0 & 0x400000) == 0) {
            return this.withEmptyParts$lzycompute();
        }
        return this.withEmptyParts;
    }

    private Dataset<Row> person$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 0x800000) == 0) {
                this.person = SQLTestData.person$((SQLTestData)this);
                this.bitmap$0 |= 0x800000;
            }
        }
        return this.person;
    }

    public Dataset<Row> person() {
        if ((this.bitmap$0 & 0x800000) == 0) {
            return this.person$lzycompute();
        }
        return this.person;
    }

    private Dataset<Row> salary$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 0x1000000) == 0) {
                this.salary = SQLTestData.salary$((SQLTestData)this);
                this.bitmap$0 |= 0x1000000;
            }
        }
        return this.salary;
    }

    public Dataset<Row> salary() {
        if ((this.bitmap$0 & 0x1000000) == 0) {
            return this.salary$lzycompute();
        }
        return this.salary;
    }

    private Dataset<Row> complexData$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 0x2000000) == 0) {
                this.complexData = SQLTestData.complexData$((SQLTestData)this);
                this.bitmap$0 |= 0x2000000;
            }
        }
        return this.complexData;
    }

    public Dataset<Row> complexData() {
        if ((this.bitmap$0 & 0x2000000) == 0) {
            return this.complexData$lzycompute();
        }
        return this.complexData;
    }

    private Dataset<Row> courseSales$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 0x4000000) == 0) {
                this.courseSales = SQLTestData.courseSales$((SQLTestData)this);
                this.bitmap$0 |= 0x4000000;
            }
        }
        return this.courseSales;
    }

    public Dataset<Row> courseSales() {
        if ((this.bitmap$0 & 0x4000000) == 0) {
            return this.courseSales$lzycompute();
        }
        return this.courseSales;
    }

    private Dataset<Row> trainingSales$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 0x8000000) == 0) {
                this.trainingSales = SQLTestData.trainingSales$((SQLTestData)this);
                this.bitmap$0 |= 0x8000000;
            }
        }
        return this.trainingSales;
    }

    public Dataset<Row> trainingSales() {
        if ((this.bitmap$0 & 0x8000000) == 0) {
            return this.trainingSales$lzycompute();
        }
        return this.trainingSales;
    }

    private Dataset<Row> intervalData$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 0x10000000) == 0) {
                this.intervalData = SQLTestData.intervalData$((SQLTestData)this);
                this.bitmap$0 |= 0x10000000;
            }
        }
        return this.intervalData;
    }

    public Dataset<Row> intervalData() {
        if ((this.bitmap$0 & 0x10000000) == 0) {
            return this.intervalData$lzycompute();
        }
        return this.intervalData;
    }

    public AbstractPatienceConfiguration.PatienceConfig org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig() {
        return this.org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig;
    }

    public final void org$scalatest$concurrent$PatienceConfiguration$_setter_$org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig_$eq(AbstractPatienceConfiguration.PatienceConfig x$1) {
        this.org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig = x$1;
    }

    public AbstractPatienceConfiguration$PatienceConfig$ PatienceConfig() {
        if (this.PatienceConfig$module == null) {
            this.PatienceConfig$lzycompute$1();
        }
        return this.PatienceConfig$module;
    }

    public int rddIdOf(String tableName) {
        SparkPlan plan = this.hiveContext().table(tableName).queryExecution().sparkPlan();
        return BoxesRunTime.unboxToInt((Object)plan.collect((PartialFunction)new scala.Serializable(this, tableName, plan){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CachedTableSuite $outer;
            private final String tableName$1;
            private final SparkPlan plan$1;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof InMemoryTableScanExec) {
                    InMemoryTableScanExec inMemoryTableScanExec = (InMemoryTableScanExec)A1;
                    InMemoryRelation relation = inMemoryTableScanExec.relation();
                    return (B1)BoxesRunTime.boxToInteger((int)relation.cacheBuilder().cachedColumnBuffers().id());
                }
                throw this.$outer.fail(new StringBuilder(21).append("Table ").append(this.tableName$1).append(" is not cached\n").append(this.plan$1).toString(), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 43));
            }

            public final boolean isDefinedAt(SparkPlan x1) {
                SparkPlan sparkPlan = x1;
                if (sparkPlan instanceof InMemoryTableScanExec) {
                    return true;
                }
                return true;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.tableName$1 = tableName$1;
                this.plan$1 = plan$1;
            }
        }).head());
    }

    public boolean isMaterialized(int rddId) {
        Option maybeBlock = this.sparkContext().env().blockManager().get((BlockId)new RDDBlockId(rddId, 0), ClassTag$.MODULE$.Nothing());
        maybeBlock.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            CachedTableSuite.$anonfun$isMaterialized$1(this, rddId, x$1);
            return BoxedUnit.UNIT;
        });
        return maybeBlock.nonEmpty();
    }

    private String getPartitionLocation(String t, String partition) {
        String information = ((Row)((Dataset)this.sql().apply((Object)new StringBuilder(40).append("SHOW TABLE EXTENDED LIKE '").append(t).append("' PARTITION (").append(partition).append(")").toString())).select("information", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).first()).getString(0);
        return ((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])information.split("\\r?\\n"))).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.startsWith("Location:"))))).head()).replace("Location: file:", "");
    }

    private final void testImplicits$lzycompute$1() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new SQLTestUtilsBase.testImplicits$((SQLTestUtilsBase)this);
            }
        }
    }

    private final void org$apache$spark$sql$test$SQLTestData$$internalImplicits$lzycompute$1() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if (this.internalImplicits$module == null) {
                this.internalImplicits$module = new SQLTestData$internalImplicits$((SQLTestData)this);
            }
        }
    }

    private final void PatienceConfig$lzycompute$1() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if (this.PatienceConfig$module == null) {
                this.PatienceConfig$module = new AbstractPatienceConfiguration$PatienceConfig$((AbstractPatienceConfiguration)this);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$isMaterialized$1(CachedTableSuite $this, int rddId$1, BlockResult x$1) {
        BlockManager qual$1 = $this.sparkContext().env().blockManager();
        RDDBlockId x$12 = new RDDBlockId(rddId$1, 0);
        Option x$2 = qual$1.releaseLock$default$2();
        qual$1.releaseLock((BlockId)x$12, x$2);
    }

    public static final /* synthetic */ boolean $anonfun$new$45(CatalogTable tableMeta$1, StructField f) {
        return tableMeta$1.partitionColumnNames().contains((Object)f.name());
    }

    public CachedTableSuite() {
        ScaledTimeSpans.$init$((ScaledTimeSpans)this);
        AbstractPatienceConfiguration.$init$((AbstractPatienceConfiguration)this);
        PatienceConfiguration.$init$((PatienceConfiguration)this);
        Eventually.$init$((Eventually)this);
        SQLTestData.$init$((SQLTestData)this);
        SQLTestUtilsBase.$init$((SQLTestUtilsBase)this);
        SQLTestUtils.$init$((SQLTestUtils)this);
        TestHiveSingleton.$init$(this);
        this.test("cache table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Seq preCacheResults = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((Dataset)this.sql().apply((Object)"SELECT * FROM src")).collect())).toSeq();
            this.hiveContext().cacheTable("src");
            this.assertCached((Dataset)this.sql().apply((Object)"SELECT * FROM src"), this.assertCached$default$2());
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT * FROM src"), preCacheResults);
            this.assertCached((Dataset)this.sql().apply((Object)"SELECT * FROM src s"), this.assertCached$default$2());
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT * FROM src s"), preCacheResults);
            this.uncacheTable("src");
            this.assertCached((Dataset)this.sql().apply((Object)"SELECT * FROM src"), 0);
        }, new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
        this.test("cache invalidation", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)"CREATE TABLE cachedTable(key INT, value STRING)");
            this.sql().apply((Object)"INSERT INTO TABLE cachedTable SELECT * FROM src");
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT * FROM cachedTable"), new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.hiveContext().table("src").collect())).toSeq());
            this.hiveContext().cacheTable("cachedTable");
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT * FROM cachedTable"), new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.hiveContext().table("src").collect())).toSeq());
            this.sql().apply((Object)"INSERT INTO TABLE cachedTable SELECT * FROM src");
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT * FROM cachedTable"), (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.hiveContext().table("src").collect())).toSeq().$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.hiveContext().table("src").collect())).toSeq(), Seq$.MODULE$.canBuildFrom()));
            return (Dataset)this.sql().apply((Object)"DROP TABLE cachedTable");
        }, new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
        this.test("Drop cached table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)"CREATE TABLE cachedTableTest(a INT)");
            this.hiveContext().cacheTable("cachedTableTest");
            ((Dataset)this.sql().apply((Object)"SELECT * FROM cachedTableTest")).collect();
            this.sql().apply((Object)"DROP TABLE cachedTableTest");
            return (AnalysisException)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Row[])((Dataset)this.sql().apply((Object)"SELECT * FROM cachedTableTest")).collect(), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
        }, new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
        this.test("DROP nonexistent table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"DROP TABLE IF EXISTS nonexistentTable"), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
        this.test("uncache of nonexistent tables", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            String e;
            String expectedErrorMsg = "Table or view not found:";
            String $org_scalatest_assert_macro_left = e = ((AnalysisException)this.intercept((Function0 & Serializable & scala.Serializable)() -> this.spark().table("nonexistentTable"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107))).getMessage();
            String $org_scalatest_assert_macro_right = new StringBuilder(17).append(expectedErrorMsg).append(" nonexistentTable").toString();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108));
            String $org_scalatest_assert_macro_left2 = e = ((AnalysisException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.uncacheTable("nonexistentTable"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109))).getMessage();
            String $org_scalatest_assert_macro_right2 = expectedErrorMsg;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
            String $org_scalatest_assert_macro_left3 = e = ((AnalysisException)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"UNCACHE TABLE nonexistentTable"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113))).getMessage();
            String $org_scalatest_assert_macro_right3 = "Table or view not found: nonexistentTable";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 116));
            return (Dataset)this.sql().apply((Object)"UNCACHE TABLE IF EXISTS nonexistentTable");
        }, new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
        this.test("no error on uncache of non-cached table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String tableName = "newTable";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tableName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(20).append("CREATE TABLE ").append(tableName).append("(a INT)").toString());
                this.uncacheTable(tableName);
                this.sql().apply((Object)"UNCACHE TABLE newTable");
                this.hiveContext().sparkSession().table(tableName).unpersist(true);
            });
        }, new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
        this.test("'CACHE TABLE' and 'UNCACHE TABLE' HiveQL statement", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)"CACHE TABLE src");
            this.assertCached(this.hiveContext().table("src"), this.assertCached$default$2());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.spark().catalog().isCached("src"), "CachedTableSuite.this.spark.catalog.isCached(\"src\")", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Table 'src' should be cached", Prettifier$.MODULE$.default(), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 134));
            this.sql().apply((Object)"UNCACHE TABLE src");
            this.assertCached(this.hiveContext().table("src"), 0);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.spark().catalog().isCached("src"), "CachedTableSuite.this.spark.catalog.isCached(\"src\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"Table 'src' should not be cached", Prettifier$.MODULE$.default(), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 138));
        }, new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 131));
        this.test("CACHE TABLE tableName AS SELECT * FROM anotherTable", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"testCacheTable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)"CACHE TABLE testCacheTable AS SELECT * FROM src");
            this.assertCached(this.hiveContext().table("testCacheTable"), this.assertCached$default$2());
            int rddId = this.rddIdOf("testCacheTable");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.isMaterialized(rddId), "CachedTableSuite.this.isMaterialized(rddId)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Eagerly cached in-memory table should have already been materialized", Prettifier$.MODULE$.default(), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 147));
            this.uncacheTable("testCacheTable");
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.isMaterialized(rddId), "CachedTableSuite.this.isMaterialized(rddId)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"Uncached in-memory table should have been unpersisted", Prettifier$.MODULE$.default(), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 152));
        }), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 141));
        this.test("CACHE TABLE tableName AS SELECT ...", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"testCacheTable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)"CACHE TABLE testCacheTable AS SELECT key FROM src LIMIT 10");
            this.assertCached(this.hiveContext().table("testCacheTable"), this.assertCached$default$2());
            int rddId = this.rddIdOf("testCacheTable");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.isMaterialized(rddId), "CachedTableSuite.this.isMaterialized(rddId)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Eagerly cached in-memory table should have already been materialized", Prettifier$.MODULE$.default(), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
            this.uncacheTable("testCacheTable");
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.isMaterialized(rddId), "CachedTableSuite.this.isMaterialized(rddId)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"Uncached in-memory table should have been unpersisted", Prettifier$.MODULE$.default(), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 167));
        }), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 156));
        this.test("CACHE LAZY TABLE tableName", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)"CACHE LAZY TABLE src");
            this.assertCached(this.hiveContext().table("src"), this.assertCached$default$2());
            int rddId = this.rddIdOf("src");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.isMaterialized(rddId), "CachedTableSuite.this.isMaterialized(rddId)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Lazily cached in-memory table shouldn't be materialized eagerly", Prettifier$.MODULE$.default(), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 176));
            ((Dataset)this.sql().apply((Object)"SELECT COUNT(*) FROM src")).collect();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(this.isMaterialized(rddId), "CachedTableSuite.this.isMaterialized(rddId)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"Lazily cached in-memory table should have been materialized", Prettifier$.MODULE$.default(), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 181));
            this.uncacheTable("src");
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.isMaterialized(rddId), "CachedTableSuite.this.isMaterialized(rddId)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"Uncached in-memory table should have been unpersisted", Prettifier$.MODULE$.default(), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 186));
        }, new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 171));
        this.test("CACHE TABLE with Hive UDF", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"udfTest"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)"CACHE TABLE udfTest AS SELECT * FROM src WHERE floor(key) = 1");
            this.assertCached(this.hiveContext().table("udfTest"), this.assertCached$default$2());
            this.uncacheTable("udfTest");
        }), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 189));
        this.test("REFRESH TABLE also needs to recache the data (data source tables)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            File tempPath = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
            tempPath.delete();
            this.hiveContext().table("src").write().mode(SaveMode.Overwrite).parquet(tempPath.toString());
            this.sql().apply((Object)"DROP TABLE IF EXISTS refreshTable");
            this.hiveContext().sparkSession().catalog().createTable("refreshTable", tempPath.toString(), "parquet");
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.hiveContext().table("refreshTable"), this.hiveContext().table("src"));
            this.sql().apply((Object)"CACHE TABLE refreshTable");
            this.assertCached(this.hiveContext().table("refreshTable"), this.assertCached$default$2());
            this.hiveContext().table("src").write().mode(SaveMode.Append).parquet(tempPath.toString());
            this.assertCached(this.hiveContext().table("refreshTable"), this.assertCached$default$2());
            this.assertCached(this.hiveContext().table("refreshTable"), this.assertCached$default$2());
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.hiveContext().table("refreshTable"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])this.hiveContext().table("src").union(this.hiveContext().table("src")).collect()));
            this.sql().apply((Object)"DROP TABLE refreshTable");
            this.hiveContext().sparkSession().catalog().createTable("refreshTable", tempPath.toString(), "parquet");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.hiveContext().isCached("refreshTable"), "CachedTableSuite.this.hiveContext.isCached(\"refreshTable\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"refreshTable should not be cached.", Prettifier$.MODULE$.default(), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 221));
            this.sql().apply((Object)"REFRESH TABLE refreshTable");
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.hiveContext().table("refreshTable"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])this.hiveContext().table("src").union(this.hiveContext().table("src")).collect()));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.hiveContext().isCached("refreshTable"), "CachedTableSuite.this.hiveContext.isCached(\"refreshTable\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"refreshTable should not be cached.", Prettifier$.MODULE$.default(), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 229));
            this.sql().apply((Object)"DROP TABLE refreshTable");
            Utils$.MODULE$.deleteRecursively(tempPath);
        }, new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 197));
        this.test("SPARK-15678: REFRESH PATH", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            File tempPath = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
            tempPath.delete();
            this.hiveContext().table("src").write().mode(SaveMode.Overwrite).parquet(tempPath.toString());
            this.sql().apply((Object)"DROP TABLE IF EXISTS refreshTable");
            this.hiveContext().sparkSession().catalog().createTable("refreshTable", tempPath.toString(), "parquet");
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.hiveContext().table("refreshTable"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])this.hiveContext().table("src").collect()));
            this.sql().apply((Object)"CACHE TABLE refreshTable");
            this.assertCached(this.hiveContext().table("refreshTable"), this.assertCached$default$2());
            this.hiveContext().table("src").write().mode(SaveMode.Append).parquet(tempPath.toString());
            this.assertCached(this.hiveContext().table("refreshTable"), this.assertCached$default$2());
            this.assertCached(this.hiveContext().table("refreshTable"), this.assertCached$default$2());
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.hiveContext().table("refreshTable"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])this.hiveContext().table("src").union(this.hiveContext().table("src")).collect()));
            this.sql().apply((Object)"DROP TABLE refreshTable");
            this.hiveContext().sparkSession().catalog().createTable("refreshTable", tempPath.toString(), "parquet");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.hiveContext().isCached("refreshTable"), "CachedTableSuite.this.hiveContext.isCached(\"refreshTable\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"refreshTable should not be cached.", Prettifier$.MODULE$.default(), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 261));
            this.sql().apply((Object)new StringBuilder(8).append("REFRESH ").append(tempPath.toString()).toString());
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.hiveContext().table("refreshTable"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])this.hiveContext().table("src").union(this.hiveContext().table("src")).collect()));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.hiveContext().isCached("refreshTable"), "CachedTableSuite.this.hiveContext.isCached(\"refreshTable\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"refreshTable should not be cached.", Prettifier$.MODULE$.default(), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 269));
            this.sql().apply((Object)"DROP TABLE refreshTable");
            Utils$.MODULE$.deleteRecursively(tempPath);
        }, new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 235));
        this.test("Cache/Uncache Qualified Tables", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDatabase((Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)db -> {
            this.withTempView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cachedTable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(55).append("CREATE TABLE ").append(db).append(".cachedTable STORED AS PARQUET AS SELECT 1").toString());
                $this.sql().apply((Object)new StringBuilder(24).append("CACHE TABLE ").append(db).append(".cachedTable").toString());
                $this.assertCached($this.spark().table(new StringBuilder(12).append(db).append(".cachedTable").toString()), $this.assertCached$default$2());
                $this.activateDatabase(db, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    $this.assertCached($this.spark().table("cachedTable"), $this.assertCached$default$2());
                    $this.sql().apply((Object)"UNCACHE TABLE cachedTable");
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool($this.spark().catalog().isCached("cachedTable"), "CachedTableSuite.this.spark.catalog.isCached(\"cachedTable\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Table 'cachedTable' should not be cached", Prettifier$.MODULE$.default(), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 285));
                    $this.sql().apply((Object)"CACHE TABLE cachedTable");
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool($this.spark().catalog().isCached("cachedTable"), "CachedTableSuite.this.spark.catalog.isCached(\"cachedTable\")", Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"Table 'cachedTable' should be cached", Prettifier$.MODULE$.default(), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 287));
                });
                $this.sql().apply((Object)new StringBuilder(26).append("UNCACHE TABLE ").append(db).append(".cachedTable").toString());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool($this.spark().catalog().isCached(new StringBuilder(12).append(db).append(".cachedTable").toString()), "CachedTableSuite.this.spark.catalog.isCached(scala.StringContext.apply(\"\", \".cachedTable\").s(db))", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Table 'cachedTable' should not be cached", Prettifier$.MODULE$.default(), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 291));
            });
            return BoxedUnit.UNIT;
        }), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 275));
        this.test("Cache Table As Select - having database name", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDatabase((Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)db -> {
            this.withTempView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cachedTable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Bool bool;
                String $org_scalatest_assert_macro_right;
                String e = ((ParseException)$this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(36).append("CACHE TABLE ").append(db).append(".cachedTable AS SELECT 1").toString()), ClassTag$.MODULE$.apply(ParseException.class), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 300))).getMessage();
                String $org_scalatest_assert_macro_left = e;
                Bool $org_scalatest_assert_macro_left2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)($org_scalatest_assert_macro_right = "It is not allowed to add catalog/namespace prefix "), $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                if ($org_scalatest_assert_macro_left2.value()) {
                    String $org_scalatest_assert_macro_left3 = e;
                    String $org_scalatest_assert_macro_right2 = "to the table name in CACHE TABLE AS SELECT";
                    bool = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                } else {
                    bool = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
                }
                Bool $org_scalatest_assert_macro_right3 = bool;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "&&", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left2.$amp$amp((Function0 & Serializable & scala.Serializable)() -> $org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 303));
            });
            return BoxedUnit.UNIT;
        }), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 297));
        this.test("SPARK-11246 cache parquet table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)"CREATE TABLE cachedTable STORED AS PARQUET AS SELECT 1");
            this.hiveContext().cacheTable("cachedTable");
            SparkPlan sparkPlan = ((Dataset)this.sql().apply((Object)"SELECT * FROM cachedTable")).queryExecution().sparkPlan();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)sparkPlan.collect((PartialFunction)new scala.Serializable(null){
                public static final long serialVersionUID = 0L;

                public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 instanceof InMemoryTableScanExec) {
                        InMemoryTableScanExec inMemoryTableScanExec = (InMemoryTableScanExec)A1;
                        return (B1)inMemoryTableScanExec;
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(SparkPlan x1) {
                    SparkPlan sparkPlan = x1;
                    return sparkPlan instanceof InMemoryTableScanExec;
                }
            }).size()));
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 314));
            return (Dataset)this.sql().apply((Object)"DROP TABLE cachedTable");
        }, new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 309));
        this.test("cache a table using CatalogFileIndex", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)"CREATE TABLE test(i int) PARTITIONED BY (p int) STORED AS parquet");
            CatalogTable tableMeta = this.spark().sharedState().externalCatalog().getTable("default", "test");
            CatalogFileIndex catalogFileIndex = new CatalogFileIndex(this.spark(), tableMeta, 0L);
            StructType dataSchema = StructType$.MODULE$.apply((Seq)tableMeta.schema().filterNot((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)CachedTableSuite.$anonfun$new$45(tableMeta, f))));
            HadoopFsRelation relation = new HadoopFsRelation((FileIndex)catalogFileIndex, tableMeta.partitionSchema(), dataSchema, (Option)None$.MODULE$, (FileFormat)new ParquetFileFormat(), Predef$.MODULE$.Map().empty(), this.spark());
            LogicalRelation plan = LogicalRelation$.MODULE$.apply((BaseRelation)relation, tableMeta);
            this.spark().sharedState().cacheManager().cacheQuery(Dataset$.MODULE$.ofRows(this.spark(), (LogicalPlan)plan), this.spark().sharedState().cacheManager().cacheQuery$default$2(), this.spark().sharedState().cacheManager().cacheQuery$default$3());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.spark().sharedState().cacheManager().lookupCachedData((LogicalPlan)plan).isDefined(), "CachedTableSuite.this.spark.sharedState.cacheManager.lookupCachedData(plan).isDefined", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 339));
            CatalogFileIndex sameCatalog = new CatalogFileIndex(this.spark(), tableMeta, 0L);
            HadoopFsRelation sameRelation = new HadoopFsRelation((FileIndex)sameCatalog, tableMeta.partitionSchema(), dataSchema, (Option)None$.MODULE$, (FileFormat)new ParquetFileFormat(), Predef$.MODULE$.Map().empty(), this.spark());
            LogicalRelation samePlan = LogicalRelation$.MODULE$.apply((BaseRelation)sameRelation, tableMeta);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(this.spark().sharedState().cacheManager().lookupCachedData((LogicalPlan)samePlan).isDefined(), "CachedTableSuite.this.spark.sharedState.cacheManager.lookupCachedData(samePlan).isDefined", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 351));
        }), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 319));
        this.test("SPARK-27248 refreshTable should recreate cache with same cache name and storage level", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.withTempDatabase((Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)db -> {
                this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(12).append(db).append(".cachedTable").toString()}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withCache((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(12).append(db).append(".cachedTable").toString()}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    $this.sql().apply((Object)new StringBuilder(44).append("CREATE TABLE ").append(db).append(".cachedTable AS SELECT 1 AS key").toString());
                    $this.sql().apply((Object)new StringBuilder(62).append("CACHE TABLE ").append(db).append(".cachedTable OPTIONS('storageLevel' 'MEMORY_ONLY')").toString());
                    $this.assertCached((Dataset)$this.sql().apply((Object)new StringBuilder(26).append("SELECT * FROM ").append(db).append(".cachedTable").toString()), new StringBuilder(12).append(db).append(".cachedTable").toString(), StorageLevel$.MODULE$.MEMORY_ONLY());
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool($this.spark().catalog().isCached(new StringBuilder(12).append(db).append(".cachedTable").toString()), "CachedTableSuite.this.spark.catalog.isCached(scala.StringContext.apply(\"\", \".cachedTable\").s(db))", Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(38).append("Table '").append(db).append(".cachedTable' should be cached.").toString(), Prettifier$.MODULE$.default(), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 368));
                    $this.sql().apply((Object)new StringBuilder(26).append("REFRESH TABLE ").append(db).append(".cachedTable").toString());
                    $this.assertCached((Dataset)$this.sql().apply((Object)new StringBuilder(26).append("select * from ").append(db).append(".cachedTable").toString()), new StringBuilder(12).append(db).append(".cachedTable").toString(), StorageLevel$.MODULE$.MEMORY_ONLY());
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool($this.spark().catalog().isCached(new StringBuilder(12).append(db).append(".cachedTable").toString()), "CachedTableSuite.this.spark.catalog.isCached(scala.StringContext.apply(\"\", \".cachedTable\").s(db))", Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)new StringBuilder(79).append("Table '").append(db).append(".cachedTable' should be cached after refreshing with its qualified name.").toString(), Prettifier$.MODULE$.default(), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 375));
                    $this.activateDatabase(db, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                        $this.sql().apply((Object)"REFRESH TABLE cachedTable");
                        $this.assertCached((Dataset)$this.sql().apply((Object)"SELECT * FROM cachedTable"), new StringBuilder(12).append(db).append(".cachedTable").toString(), StorageLevel$.MODULE$.MEMORY_ONLY());
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool($this.spark().catalog().isCached("cachedTable"), "CachedTableSuite.this.spark.catalog.isCached(\"cachedTable\")", Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(81).append("Table '").append(db).append(".cachedTable' should be cached after refreshing with its ").append("unqualified name.").toString(), Prettifier$.MODULE$.default(), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 386));
                    });
                }));
                return BoxedUnit.UNIT;
            });
            this.withTempDatabase((Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)db -> {
                this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cachedTable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withCache((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cachedTable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    $this.sql().apply((Object)"CREATE TABLE cachedTable AS SELECT 1 AS key");
                    $this.sql().apply((Object)"CACHE TABLE cachedTable OPTIONS('storageLevel' 'DISK_ONLY')");
                    $this.assertCached((Dataset)$this.sql().apply((Object)"SELECT * FROM cachedTable"), "cachedTable", StorageLevel$.MODULE$.DISK_ONLY());
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool($this.spark().catalog().isCached("cachedTable"), "CachedTableSuite.this.spark.catalog.isCached(\"cachedTable\")", Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Table 'cachedTable' should be cached.", Prettifier$.MODULE$.default(), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 407));
                    $this.sql().apply((Object)"REFRESH TABLE cachedTable");
                    $this.assertCached((Dataset)$this.sql().apply((Object)"SELECT * FROM cachedTable"), "cachedTable", StorageLevel$.MODULE$.DISK_ONLY());
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool($this.spark().catalog().isCached("cachedTable"), "CachedTableSuite.this.spark.catalog.isCached(\"cachedTable\")", Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"Table 'cachedTable' should be cached after refreshing with its unqualified name.", Prettifier$.MODULE$.default(), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 413));
                    $this.activateDatabase(db, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                        $this.sql().apply((Object)"REFRESH TABLE default.cachedTable");
                        $this.assertCached((Dataset)$this.sql().apply((Object)"SELECT * FROM default.cachedTable"), "cachedTable", StorageLevel$.MODULE$.DISK_ONLY());
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool($this.spark().catalog().isCached("default.cachedTable"), "CachedTableSuite.this.spark.catalog.isCached(\"default.cachedTable\")", Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Table 'cachedTable' should be cached after refreshing with its qualified name.", Prettifier$.MODULE$.default(), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 425));
                    });
                }));
                return BoxedUnit.UNIT;
            });
        }, new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 355));
        this.test("SPARK-33963: do not use table stats while looking in table cache", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = "table_on_test";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(23).append("CREATE TABLE ").append(t).append(" (col int)").toString());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.spark().catalog().isCached(t), "CachedTableSuite.this.spark.catalog.isCached(t)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 437));
                this.sql().apply((Object)new StringBuilder(12).append("CACHE TABLE ").append(t).toString());
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(this.spark().catalog().isCached(t), "CachedTableSuite.this.spark.catalog.isCached(t)", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 439));
            });
        }, new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 433));
        this.test("SPARK-33965: cache table in spark_catalog", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withNamespace((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"spark_catalog.ns"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)"CREATE NAMESPACE spark_catalog.ns");
            String t = "spark_catalog.ns.tbl";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(23).append("CREATE TABLE ").append(t).append(" (col int)").toString());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.spark().catalog().isCached(t), "CachedTableSuite.this.spark.catalog.isCached(t)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 449));
                this.sql().apply((Object)new StringBuilder(12).append("CACHE TABLE ").append(t).toString());
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(this.spark().catalog().isCached(t), "CachedTableSuite.this.spark.catalog.isCached(t)", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 451));
            });
        }), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 443));
        this.test("SPARK-34076: should be able to drop temp view with cached tables", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = "cachedTable";
            String v = "tempView";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{v}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(54).append("CREATE TEMPORARY VIEW ").append(v).append(" AS SELECT key FROM src LIMIT 10").toString());
                this.sql().apply((Object)new StringBuilder(34).append("CREATE TABLE ").append(t).append(" AS SELECT * FROM src").toString());
                this.sql().apply((Object)new StringBuilder(12).append("CACHE TABLE ").append(t).toString());
            }));
        }, new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 456));
        this.test("SPARK-34076: should be able to drop global temp view with cached tables", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = "cachedTable";
            String v = "globalTempView";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withGlobalTempView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{v}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(61).append("CREATE GLOBAL TEMPORARY VIEW ").append(v).append(" AS SELECT key FROM src LIMIT 10").toString());
                this.sql().apply((Object)new StringBuilder(34).append("CREATE TABLE ").append(t).append(" AS SELECT * FROM src").toString());
                this.sql().apply((Object)new StringBuilder(12).append("CACHE TABLE ").append(t).toString());
            }));
        }, new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 468));
        this.test("SPARK-34213: LOAD DATA refreshes cached table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"src_tbl"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dst_tbl"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)"CREATE TABLE src_tbl (c0 int, part int) USING hive PARTITIONED BY (part)");
            this.sql().apply((Object)"INSERT INTO src_tbl PARTITION (part=0) SELECT 0");
            this.sql().apply((Object)"CREATE TABLE dst_tbl (c0 int, part int) USING hive PARTITIONED BY (part)");
            this.sql().apply((Object)"INSERT INTO dst_tbl PARTITION (part=1) SELECT 1");
            this.sql().apply((Object)"CACHE TABLE dst_tbl");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.spark().catalog().isCached("dst_tbl"), "CachedTableSuite.this.spark.catalog.isCached(\"dst_tbl\")", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 499));
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT * FROM dst_tbl"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)})));
            String location = this.getPartitionLocation("src_tbl", "part=0");
            this.sql().apply((Object)new StringBuilder(63).append("LOAD DATA LOCAL INPATH '").append(location).append("' INTO TABLE dst_tbl PARTITION (part=0)").toString());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(this.spark().catalog().isCached("dst_tbl"), "CachedTableSuite.this.spark.catalog.isCached(\"dst_tbl\")", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 503));
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT * FROM dst_tbl"), (Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)0)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)})), (List)Nil$.MODULE$)));
        })), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 491));
        this.test("SPARK-34262: ALTER TABLE .. SET LOCATION refreshes cached table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"src_tbl"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dst_tbl"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)"CREATE TABLE src_tbl (c0 int, part int) USING hive PARTITIONED BY (part)");
            this.sql().apply((Object)"INSERT INTO src_tbl PARTITION (part=0) SELECT 0");
            this.sql().apply((Object)"CREATE TABLE dst_tbl (c0 int, part int) USING hive PARTITIONED BY (part)");
            this.sql().apply((Object)"ALTER TABLE dst_tbl ADD PARTITION (part=0)");
            this.sql().apply((Object)"INSERT INTO dst_tbl PARTITION (part=1) SELECT 1");
            this.sql().apply((Object)"CACHE TABLE dst_tbl");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.spark().catalog().isCached("dst_tbl"), "CachedTableSuite.this.spark.catalog.isCached(\"dst_tbl\")", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 518));
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT * FROM dst_tbl"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)})));
            String location = this.getPartitionLocation("src_tbl", "part=0");
            this.sql().apply((Object)new StringBuilder(54).append("ALTER TABLE dst_tbl PARTITION (part=0) SET LOCATION '").append(location).append("'").toString());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(this.spark().catalog().isCached("dst_tbl"), "CachedTableSuite.this.spark.catalog.isCached(\"dst_tbl\")", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 522));
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT * FROM dst_tbl"), (Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)0)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)})), (List)Nil$.MODULE$)));
        })), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 509));
    }
}

