/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.impl.filter;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hive.ql.io.sarg.ExpressionTree;
import org.apache.hadoop.hive.ql.io.sarg.PredicateLeaf;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.orc.OrcFile;
import org.apache.orc.Reader;
import org.apache.orc.TypeDescription;
import org.apache.orc.filter.BatchFilter;
import org.apache.orc.impl.filter.AndFilter;
import org.apache.orc.impl.filter.BatchFilterFactory;
import org.apache.orc.impl.filter.OrFilter;
import org.apache.orc.impl.filter.VectorFilter;
import org.apache.orc.impl.filter.leaf.LeafFilterFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterFactory {
    private static final Logger LOG = LoggerFactory.getLogger(FilterFactory.class);

    public static BatchFilter createBatchFilter(Reader.Options opts, TypeDescription readSchema2, boolean isSchemaCaseAware, OrcFile.Version version, boolean normalize) {
        ArrayList<BatchFilter> filters = new ArrayList<BatchFilter>(2);
        if (opts.isAllowSARGToFilter() && opts.getSearchArgument() != null) {
            SearchArgument sArg = opts.getSearchArgument();
            HashSet<String> colNames = new HashSet<String>();
            try {
                ExpressionTree exprTree = normalize ? sArg.getExpression() : sArg.getCompactExpression();
                LOG.debug("normalize={}, using expressionTree={}", (Object)normalize, (Object)exprTree);
                filters.add(BatchFilterFactory.create(FilterFactory.createSArgFilter(exprTree, colNames, sArg.getLeaves(), readSchema2, isSchemaCaseAware, version), colNames.toArray(new String[0])));
            }
            catch (UnSupportedSArgException e) {
                LOG.warn("SArg: {} is not supported\n{}", (Object)sArg, (Object)e.getMessage());
            }
        }
        if (opts.getFilterCallback() != null) {
            filters.add(BatchFilterFactory.create(opts.getFilterCallback(), opts.getPreFilterColumnNames()));
        }
        return BatchFilterFactory.create(filters);
    }

    public static VectorFilter createSArgFilter(ExpressionTree expr, Set<String> colIds, List<PredicateLeaf> leaves, TypeDescription readSchema2, boolean isSchemaCaseAware, OrcFile.Version version) throws UnSupportedSArgException {
        VectorFilter result;
        switch (expr.getOperator()) {
            case OR: {
                VectorFilter[] orFilters = new VectorFilter[expr.getChildren().size()];
                for (int i = 0; i < expr.getChildren().size(); ++i) {
                    orFilters[i] = FilterFactory.createSArgFilter((ExpressionTree)expr.getChildren().get(i), colIds, leaves, readSchema2, isSchemaCaseAware, version);
                }
                result = new OrFilter(orFilters);
                break;
            }
            case AND: {
                VectorFilter[] andFilters = new VectorFilter[expr.getChildren().size()];
                for (int i = 0; i < expr.getChildren().size(); ++i) {
                    andFilters[i] = FilterFactory.createSArgFilter((ExpressionTree)expr.getChildren().get(i), colIds, leaves, readSchema2, isSchemaCaseAware, version);
                }
                result = new AndFilter(andFilters);
                break;
            }
            case NOT: {
                ExpressionTree leaf = (ExpressionTree)expr.getChildren().get(0);
                assert (leaf.getOperator() == ExpressionTree.Operator.LEAF);
                result = LeafFilterFactory.createLeafVectorFilter(leaves.get(leaf.getLeaf()), colIds, readSchema2, isSchemaCaseAware, version, true);
                break;
            }
            case LEAF: {
                result = LeafFilterFactory.createLeafVectorFilter(leaves.get(expr.getLeaf()), colIds, readSchema2, isSchemaCaseAware, version, false);
                break;
            }
            default: {
                throw new UnSupportedSArgException(String.format("SArg expression: %s is not supported", expr));
            }
        }
        return result;
    }

    public static class UnSupportedSArgException
    extends Exception {
        public UnSupportedSArgException(String message) {
            super(message);
        }
    }
}

