/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.sources;

import java.io.File;
import java.io.Serializable;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.expressions.BitwiseAnd;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.HiveHash;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Pmod;
import org.apache.spark.sql.catalyst.expressions.Pmod$;
import org.apache.spark.sql.hive.HiveUtils$;
import org.apache.spark.sql.hive.client.HiveClient;
import org.apache.spark.sql.hive.test.TestHive$;
import org.apache.spark.sql.hive.test.TestHiveContext;
import org.apache.spark.sql.hive.test.TestHiveSingleton;
import org.apache.spark.sql.internal.StaticSQLConf$;
import org.apache.spark.sql.sources.BucketedWriteSuite;
import org.apache.spark.sql.sources.BucketedWriteWithHiveSupportSuite$;
import org.apache.spark.sql.test.SQLTestUtils;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001y2A\u0001B\u0003\u0001!!)Q\u0004\u0001C\u0001=!)\u0001\u0005\u0001C)C!)\u0001\u0006\u0001C)S\t\t#)^2lKR,Gm\u0016:ji\u0016<\u0016\u000e\u001e5ISZ,7+\u001e9q_J$8+^5uK*\u0011aaB\u0001\bg>,(oY3t\u0015\tA\u0011\"A\u0002tc2T!AC\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u00051i\u0011AB1qC\u000eDWMC\u0001\u000f\u0003\ry'oZ\u0002\u0001'\r\u0001\u0011#\u0006\t\u0003%Mi\u0011!B\u0005\u0003)\u0015\u0011!CQ;dW\u0016$X\rZ,sSR,7+^5uKB\u0011acG\u0007\u0002/)\u0011\u0001$G\u0001\u0005i\u0016\u001cHO\u0003\u0002\u001b\u000f\u0005!\u0001.\u001b<f\u0013\tarCA\tUKN$\b*\u001b<f'&tw\r\\3u_:\fa\u0001P5oSRtD#A\u0010\u0011\u0005I\u0001\u0011!\u00032fM>\u0014X-\u00117m)\u0005\u0011\u0003CA\u0012'\u001b\u0005!#\"A\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u001d\"#\u0001B+oSR\f\u0011CZ5mK\u001a{'/\\1ugR{G+Z:u+\u0005Q\u0003cA\u00164m9\u0011A&\r\b\u0003[Aj\u0011A\f\u0006\u0003_=\ta\u0001\u0010:p_Rt\u0014\"A\u0013\n\u0005I\"\u0013a\u00029bG.\fw-Z\u0005\u0003iU\u00121aU3r\u0015\t\u0011D\u0005\u0005\u00028w9\u0011\u0001(\u000f\t\u0003[\u0011J!A\u000f\u0013\u0002\rA\u0013X\rZ3g\u0013\taTH\u0001\u0004TiJLgn\u001a\u0006\u0003u\u0011\u0002")
public class BucketedWriteWithHiveSupportSuite
extends BucketedWriteSuite
implements TestHiveSingleton {
    private final boolean enableAutoThreadAudit;
    private final SparkSession spark;
    private final TestHiveContext hiveContext;
    private final HiveClient hiveClient;

    @Override
    public /* synthetic */ void org$apache$spark$sql$hive$test$TestHiveSingleton$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public void afterAll() {
        TestHiveSingleton.afterAll$(this);
    }

    @Override
    public boolean enableAutoThreadAudit() {
        return this.enableAutoThreadAudit;
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public TestHiveContext hiveContext() {
        return this.hiveContext;
    }

    @Override
    public HiveClient hiveClient() {
        return this.hiveClient;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$enableAutoThreadAudit_$eq(boolean x$1) {
        this.enableAutoThreadAudit = x$1;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$hiveContext_$eq(TestHiveContext x$1) {
        this.hiveContext = x$1;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$hiveClient_$eq(HiveClient x$1) {
        this.hiveClient = x$1;
    }

    public void beforeAll() {
        SQLTestUtils.beforeAll$((SQLTestUtils)this);
        String $org_scalatest_assert_macro_left = (String)this.spark().sparkContext().conf().get(StaticSQLConf$.MODULE$.CATALOG_IMPLEMENTATION());
        String $org_scalatest_assert_macro_right = "hive";
        String string = $org_scalatest_assert_macro_left;
        String string2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BucketedWriteWithHiveSupportSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 32));
    }

    public Seq<String> fileFormatsToTest() {
        return (Seq)new .colon.colon((Object)"parquet", (List)new .colon.colon((Object)"orc", (List)Nil$.MODULE$));
    }

    private static final Expression bucketIdExpression$1(Seq expressions, int numBuckets) {
        return new Pmod((Expression)new BitwiseAnd((Expression)new HiveHash(expressions), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE))), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)8)), Pmod$.MODULE$.apply$default$3());
    }

    private static final Option getBucketIdFromFileName$1(String fileName) {
        None$ none$;
        String string;
        Regex hiveBucketedFileName = new StringOps(Predef$.MODULE$.augmentString("^(\\d+)_0_.*$")).r();
        Option option = hiveBucketedFileName.unapplySeq((CharSequence)(string = fileName));
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
            String bucketId = (String)((LinearSeqOptimized)option.get()).apply(0);
            none$ = new Some((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(bucketId)).toInt()));
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public static final /* synthetic */ Tuple3 $anonfun$new$6(int i) {
        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)(i % 13)), (Object)Integer.toString(i), (Object)BoxesRunTime.boxToInteger((int)(i % 5)));
    }

    public static final /* synthetic */ void $anonfun$new$2(BucketedWriteWithHiveSupportSuite $this, String table$1, String format) {
        ((IterableLike)new .colon.colon((Object)"true", (List)new .colon.colon((Object)"false", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)enableConvertMetastore -> {
            $this.withSQLConf((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveUtils$.MODULE$.CONVERT_METASTORE_PARQUET().key()), (Object)enableConvertMetastore), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveUtils$.MODULE$.CONVERT_METASTORE_ORC().key()), (Object)enableConvertMetastore)}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.withTable((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{table$1}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(219).append("\n                 |CREATE TABLE IF NOT EXISTS ").append(table$1).append(" (i int, j string)\n                 |PARTITIONED BY(k string)\n                 |CLUSTERED BY (i, j) SORTED BY (i) INTO 8 BUCKETS\n                 |STORED AS ").append(format$1).append("\n               ").toString())).stripMargin());
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(BucketedWriteWithHiveSupportSuite.class.getClassLoader());
                public final class $typecreator6$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                    }

                    public $typecreator6$1(BucketedWriteWithHiveSupportSuite $outer) {
                    }
                }
                Dataset df = TestHive$.MODULE$.implicits().localSeqToDatasetHolder((Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 50).map((Function1 & Serializable & scala.Serializable)i -> BucketedWriteWithHiveSupportSuite.$anonfun$new$6(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom()), TestHive$.MODULE$.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new $typecreator6$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"i", "j", "k"}));
                $this.withSQLConf((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hive.exec.dynamic.partition.mode"), (Object)"nonstrict")}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> df.write().mode(SaveMode.Overwrite).insertInto(table$1));
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)k -> $this.testBucketing(new File($this.tableDir(table$1), new StringBuilder(2).append("k=").append(k).toString()), format$1, 8, (Seq)new .colon.colon((Object)"i", (List)new .colon.colon((Object)"j", (List)Nil$.MODULE$)), (Seq)new .colon.colon((Object)"i", (List)Nil$.MODULE$), df, (Function2 & Serializable & scala.Serializable)(expressions, numBuckets) -> BucketedWriteWithHiveSupportSuite.bucketIdExpression$1(expressions, BoxesRunTime.unboxToInt((Object)numBuckets)), (Function1 & Serializable & scala.Serializable)fileName -> BucketedWriteWithHiveSupportSuite.getBucketIdFromFileName$1(fileName)));
            }));
            return BoxedUnit.UNIT;
        });
    }

    public BucketedWriteWithHiveSupportSuite() {
        TestHiveSingleton.$init$(this);
        this.test("write hive bucketed table", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String table = "hive_bucketed_table";
            this.fileFormatsToTest().foreach((Function1 & Serializable & scala.Serializable)format -> {
                BucketedWriteWithHiveSupportSuite.$anonfun$new$2(this, table, format);
                return BoxedUnit.UNIT;
            });
        }, new Position("BucketedWriteWithHiveSupportSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 37));
    }
}

