/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.client;

import java.io.File;
import java.io.Serializable;
import java.sql.Date;
import java.time.ZoneId;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTable$;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition$;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.ExternalCatalogUtils$;
import org.apache.spark.sql.catalyst.dsl.package;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.Concat;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.In;
import org.apache.spark.sql.catalyst.expressions.InSet;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Not;
import org.apache.spark.sql.catalyst.expressions.Substring;
import org.apache.spark.sql.catalyst.expressions.Year;
import org.apache.spark.sql.catalyst.expressions.package$;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.hive.client.HiveClient;
import org.apache.spark.sql.hive.client.HiveVersionSuite;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005Mg\u0001B\u0012%\u0001EB\u0001\u0002\u0012\u0001\u0003\u0002\u0003\u0006I!\u0012\u0005\u0006%\u0002!\ta\u0015\u0005\b-\u0002\u0011\r\u0011\"\u0003X\u0011\u0019y\u0006\u0001)A\u00051\"9\u0001\r\u0001b\u0001\n\u0013\t\u0007B\u00022\u0001A\u0003%Q\tC\u0004d\u0001\t\u0007I\u0011B1\t\r\u0011\u0004\u0001\u0015!\u0003F\u0011\u001d)\u0007A1A\u0005\n\u0019Daa\u001b\u0001!\u0002\u00139\u0007b\u00027\u0001\u0005\u0004%I!\u001c\u0005\u0007u\u0002\u0001\u000b\u0011\u00028\t\u000fm\u0004!\u0019!C\u0005[\"1A\u0010\u0001Q\u0001\n9Dq! \u0001C\u0002\u0013%a\u0010C\u0004\u0002\b\u0001\u0001\u000b\u0011B@\t\u0011\u0005%\u0001A1A\u0005\nyDq!a\u0003\u0001A\u0003%q\u0010\u0003\u0005\u0002\u000e\u0001\u0011\r\u0011\"\u0003\u007f\u0011\u001d\ty\u0001\u0001Q\u0001\n}D\u0011\"!\u0005\u0001\u0005\u0004%I!a\u0005\t\u0011\u0005m\u0001\u0001)A\u0005\u0003+A\u0011\"!\b\u0001\u0005\u0004%I!a\b\t\u0011\u00055\u0002\u0001)A\u0005\u0003CA1\"a\f\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u00022!Y\u0011\u0011\b\u0001A\u0002\u0003\u0007I\u0011BA\u001e\u0011-\t9\u0005\u0001a\u0001\u0002\u0003\u0006K!a\r\t\u000f\u0005%\u0003\u0001\"\u0003\u0002L!9\u0011q\u000b\u0001\u0005\n\u0005e\u0003bBA6\u0001\u0011\u0005\u0013Q\u000e\u0005\b\u0003_\u0002A\u0011BA9\u0011\u001d\ty\u0007\u0001C\u0005\u0003GCq!a\u001c\u0001\t\u0013\tY\fC\u0004\u0002p\u0001!I!a3\u00037!Kg/\u001a)beRLG/[8o\r&dG/\u001a:j]\u001e\u001cV/\u001b;f\u0015\t)c%\u0001\u0004dY&,g\u000e\u001e\u0006\u0003O!\nA\u0001[5wK*\u0011\u0011FK\u0001\u0004gFd'BA\u0016-\u0003\u0015\u0019\b/\u0019:l\u0015\tic&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002_\u0005\u0019qN]4\u0004\u0001M!\u0001A\r\u001c=!\t\u0019D'D\u0001%\u0013\t)DE\u0001\tISZ,g+\u001a:tS>t7+^5uKB\u0011qGO\u0007\u0002q)\u0011\u0011HL\u0001\ng\u000e\fG.\u0019;fgRL!a\u000f\u001d\u0003#\t+gm\u001c:f\u0003:$\u0017I\u001a;fe\u0006cG\u000e\u0005\u0002>\u00056\taH\u0003\u0002@\u0001\u0006)\u0001\u000f\\1og*\u0011\u0011\tK\u0001\tG\u0006$\u0018\r\\=ti&\u00111I\u0010\u0002\n'Fc\u0005*\u001a7qKJ\fqA^3sg&|g\u000e\u0005\u0002G\u001f:\u0011q)\u0014\t\u0003\u0011.k\u0011!\u0013\u0006\u0003\u0015B\na\u0001\u0010:p_Rt$\"\u0001'\u0002\u000bM\u001c\u0017\r\\1\n\u00059[\u0015A\u0002)sK\u0012,g-\u0003\u0002Q#\n11\u000b\u001e:j]\u001eT!AT&\u0002\rqJg.\u001b;?)\t!V\u000b\u0005\u00024\u0001!)AI\u0001a\u0001\u000b\u0006yAO]=ESJ,7\r^*rY.+\u00170F\u0001Y!\tIf,D\u0001[\u0015\tYF,\u0001\u0003mC:<'\"A/\u0002\t)\fg/Y\u0005\u0003!j\u000b\u0001\u0003\u001e:z\t&\u0014Xm\u0019;Tc2\\U-\u001f\u0011\u0002\u0017\u0019\fG\u000e\u001c2bG.\\U-_\u000b\u0002\u000b\u0006aa-\u00197mE\u0006\u001c7nS3zA\u0005\u0019\u0002O];oS:<g)Y:u\r\u0006dGNY1dW\u0006!\u0002O];oS:<g)Y:u\r\u0006dGNY1dW\u0002\n\u0001\u0003Z3gCVdG\u000fU1si&$\u0018n\u001c8\u0016\u0003\u001d\u00042\u0001[5Y\u001b\u0005Y\u0015B\u00016L\u0005\u0019y\u0005\u000f^5p]\u0006\tB-\u001a4bk2$\b+\u0019:uSRLwN\u001c\u0011\u0002\u000f\u0011\u001ch+\u00197vKV\ta\u000e\u0005\u0002po:\u0011\u0001/^\u0007\u0002c*\u0011!o]\u0001\nS6lW\u000f^1cY\u0016T!\u0001^&\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002wc\u0006)!+\u00198hK&\u0011\u00010\u001f\u0002\n\u0013:\u001cG.^:jm\u0016T!A^9\u0002\u0011\u0011\u001ch+\u00197vK\u0002\na\u0001\u001b,bYV,\u0017a\u00025WC2,X\rI\u0001\u000bG\",hn\u001b,bYV,W#A@\u0011\u000b\u0005\u0005\u00111\u0001-\u000e\u0003ML1!!\u0002t\u0005\r\u0019V-]\u0001\fG\",hn\u001b,bYV,\u0007%A\u0005eCR,g+\u00197vK\u0006QA-\u0019;f-\u0006dW/\u001a\u0011\u0002\u0019\u0011\fG/Z*ueZ\u000bG.^3\u0002\u001b\u0011\fG/Z*ueZ\u000bG.^3!\u0003I!Xm\u001d;QCJ$\u0018\u000e^5p]\u000e{WO\u001c;\u0016\u0005\u0005U\u0001c\u00015\u0002\u0018%\u0019\u0011\u0011D&\u0003\u0007%sG/A\nuKN$\b+\u0019:uSRLwN\\\"pk:$\b%A\u0007ti>\u0014\u0018mZ3G_Jl\u0017\r^\u000b\u0003\u0003C\u0001B!a\t\u0002*5\u0011\u0011Q\u0005\u0006\u0004\u0003O\u0001\u0015aB2bi\u0006dwnZ\u0005\u0005\u0003W\t)C\u0001\u000bDCR\fGn\\4Ti>\u0014\u0018mZ3G_Jl\u0017\r^\u0001\u000fgR|'/Y4f\r>\u0014X.\u0019;!\u0003Y\u0019G.[3oi^KG\u000f[8vi\u0012K'/Z2u'FdWCAA\u001a!\r\u0019\u0014QG\u0005\u0004\u0003o!#A\u0003%jm\u0016\u001cE.[3oi\u0006Q2\r\\5f]R<\u0016\u000e\u001e5pkR$\u0015N]3diN\u000bHn\u0018\u0013fcR!\u0011QHA\"!\rA\u0017qH\u0005\u0004\u0003\u0003Z%\u0001B+oSRD\u0011\"!\u0012\u001b\u0003\u0003\u0005\r!a\r\u0002\u0007a$\u0013'A\fdY&,g\u000e^,ji\"|W\u000f\u001e#je\u0016\u001cGoU9mA\u0005!\u0011N\\5u)\u0011\t\u0019$!\u0014\t\u000f\u0005=C\u00041\u0001\u0002R\u0005aAO]=ESJ,7\r^*rYB\u0019\u0001.a\u0015\n\u0007\u0005U3JA\u0004C_>dW-\u00198\u0002\t\u0005$HO\u001d\u000b\u0005\u00037\n9\u0007\u0005\u0003\u0002^\u0005\rTBAA0\u0015\r\t\t\u0007Q\u0001\fKb\u0004(/Z:tS>t7/\u0003\u0003\u0002f\u0005}#!C!uiJL'-\u001e;f\u0011\u0019\tI'\ba\u0001\u000b\u0006!a.Y7f\u0003%\u0011WMZ8sK\u0006cG\u000e\u0006\u0002\u0002>\u0005yB/Z:u\u001b\u0016$\u0018m\u001d;pe\u0016\u0004\u0016M\u001d;ji&|gNR5mi\u0016\u0014\u0018N\\4\u0015\u001d\u0005u\u00121OA?\u0003#\u000b)*a'\u0002 \"9\u0011QO\u0010A\u0002\u0005]\u0014A\u00034jYR,'/\u0012=qeB!\u0011QLA=\u0013\u0011\tY(a\u0018\u0003\u0015\u0015C\bO]3tg&|g\u000eC\u0004\u0002\u0000}\u0001\r!!!\u0002\u0015\u0015D\b/Z2uK\u0012$5\u000f\u0005\u0004\u0002\u0004\u00065\u0015Q\u0003\b\u0005\u0003\u000b\u000bIID\u0002I\u0003\u000fK\u0011\u0001T\u0005\u0004\u0003\u0017[\u0015a\u00029bG.\fw-Z\u0005\u0005\u0003\u000b\tyIC\u0002\u0002\f.Cq!a% \u0001\u0004\t\t)A\u0005fqB,7\r^3e\u0011\"9\u0011qS\u0010A\u0002\u0005e\u0015AD3ya\u0016\u001cG/\u001a3DQVt7n\u001d\t\u0006\u0003\u0007\u000bi)\u0012\u0005\b\u0003;{\u0002\u0019AAM\u0003%)\u0007\u0010]3di\u0016$G\tC\u0004\u0002\"~\u0001\r!!'\u0002\u001f\u0015D\b/Z2uK\u0012$\u0015\r^3tiJ$\u0002#!\u0010\u0002&\u0006\u001d\u0016\u0011VAV\u0003[\u000by+!-\t\u000f\u0005U\u0004\u00051\u0001\u0002x!9\u0011q\u0010\u0011A\u0002\u0005\u0005\u0005bBAJA\u0001\u0007\u0011\u0011\u0011\u0005\b\u0003/\u0003\u0003\u0019AAM\u0011\u001d\ti\n\ta\u0001\u00033Cq!!)!\u0001\u0004\tI\nC\u0004\u00024\u0002\u0002\r!!.\u0002\u0013Q\u0014\u0018M\\:g_Jl\u0007c\u00025\u00028\u0006]\u0014qO\u0005\u0004\u0003s[%!\u0003$v]\u000e$\u0018n\u001c82)\u0019\ti$!0\u0002@\"9\u0011QO\u0011A\u0002\u0005]\u0004bBAaC\u0001\u0007\u00111Y\u0001\u0017Kb\u0004Xm\u0019;fIB\u000b'\u000f^5uS>t7)\u001e2fgB1\u00111QAG\u0003\u000b\u0004R\u0002[Ad\u0003\u0003\u000b\t)!'\u0002\u001a\u0006e\u0015bAAe\u0017\n1A+\u001e9mKV\"\u0002\"!\u0010\u0002N\u0006=\u0017\u0011\u001b\u0005\b\u0003k\u0012\u0003\u0019AA<\u0011\u001d\t\tM\ta\u0001\u0003\u0007Dq!a-#\u0001\u0004\t)\f")
public class HivePartitionFilteringSuite
extends HiveVersionSuite
implements SQLHelper {
    private final String tryDirectSqlKey;
    private final String fallbackKey;
    private final String pruningFastFallback;
    private final Option<String> defaultPartition;
    private final Range.Inclusive dsValue;
    private final Range.Inclusive hValue;
    private final Seq<String> chunkValue;
    private final Seq<String> dateValue;
    private final Seq<String> dateStrValue;
    private final int testPartitionCount;
    private final CatalogStorageFormat storageFormat;
    private HiveClient clientWithoutDirectSql;
    private String sparkHome;
    private volatile boolean bitmap$0;

    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$((SQLHelper)this, pairs, f);
    }

    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$((SQLHelper)this, f);
    }

    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$((SQLHelper)this, test);
    }

    private String sparkHome$lzycompute() {
        HivePartitionFilteringSuite hivePartitionFilteringSuite = this;
        synchronized (hivePartitionFilteringSuite) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$((SQLHelper)this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    public String sparkHome() {
        return !this.bitmap$0 ? this.sparkHome$lzycompute() : this.sparkHome;
    }

    private String tryDirectSqlKey() {
        return this.tryDirectSqlKey;
    }

    private String fallbackKey() {
        return this.fallbackKey;
    }

    private String pruningFastFallback() {
        return this.pruningFastFallback;
    }

    private Option<String> defaultPartition() {
        return this.defaultPartition;
    }

    private Range.Inclusive dsValue() {
        return this.dsValue;
    }

    private Range.Inclusive hValue() {
        return this.hValue;
    }

    private Seq<String> chunkValue() {
        return this.chunkValue;
    }

    private Seq<String> dateValue() {
        return this.dateValue;
    }

    private Seq<String> dateStrValue() {
        return this.dateStrValue;
    }

    private int testPartitionCount() {
        return this.testPartitionCount;
    }

    private CatalogStorageFormat storageFormat() {
        return this.storageFormat;
    }

    private HiveClient clientWithoutDirectSql() {
        return this.clientWithoutDirectSql;
    }

    private void clientWithoutDirectSql_$eq(HiveClient x$1) {
        this.clientWithoutDirectSql = x$1;
    }

    /*
     * WARNING - void declaration
     */
    private HiveClient init(boolean tryDirectSql) {
        void var3_3;
        IndexedSeq partitions;
        Configuration hadoopConf = new Configuration();
        hadoopConf.setBoolean(this.tryDirectSqlKey(), tryDirectSql);
        hadoopConf.set("hive.metastore.warehouse.dir", Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()).toURI().toString());
        HiveClient client = this.buildClient(hadoopConf);
        StructType tableSchema = new StructType().add("value", "int").add("ds", "int").add("h", "int").add("chunk", "string").add("d", "date").add("datestr", "string");
        TableIdentifier x$1 = new TableIdentifier("test", (Option)new Some((Object)"default"));
        CatalogTableType x$2 = CatalogTableType$.MODULE$.MANAGED();
        StructType x$3 = tableSchema;
        Seq x$4 = (Seq)new .colon.colon((Object)"ds", (List)new .colon.colon((Object)"h", (List)new .colon.colon((Object)"chunk", (List)new .colon.colon((Object)"d", (List)new .colon.colon((Object)"datestr", (List)Nil$.MODULE$)))));
        CatalogStorageFormat x$5 = this.storageFormat();
        Option x$6 = CatalogTable$.MODULE$.apply$default$5();
        Option x$7 = CatalogTable$.MODULE$.apply$default$7();
        String x$8 = CatalogTable$.MODULE$.apply$default$8();
        long x$9 = CatalogTable$.MODULE$.apply$default$9();
        long x$10 = CatalogTable$.MODULE$.apply$default$10();
        String x$11 = CatalogTable$.MODULE$.apply$default$11();
        Map x$12 = CatalogTable$.MODULE$.apply$default$12();
        Option x$13 = CatalogTable$.MODULE$.apply$default$13();
        Option x$14 = CatalogTable$.MODULE$.apply$default$14();
        Option x$15 = CatalogTable$.MODULE$.apply$default$15();
        Seq x$16 = CatalogTable$.MODULE$.apply$default$16();
        boolean x$17 = CatalogTable$.MODULE$.apply$default$17();
        boolean x$18 = CatalogTable$.MODULE$.apply$default$18();
        Map x$19 = CatalogTable$.MODULE$.apply$default$19();
        Option x$20 = CatalogTable$.MODULE$.apply$default$20();
        CatalogTable table = new CatalogTable(x$1, x$2, x$5, x$3, x$6, x$4, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        client.createTable(table, false);
        IndexedSeq $org_scalatest_assert_macro_left = partitions = (IndexedSeq)this.dsValue().flatMap((Function1 & Serializable & scala.Serializable)ds -> HivePartitionFilteringSuite.$anonfun$init$1(this, BoxesRunTime.unboxToInt((Object)ds)), IndexedSeq$.MODULE$.canBuildFrom());
        int $org_scalatest_assert_macro_right = this.testPartitionCount();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
        client.createPartitions("default", "test", (Seq)partitions, false);
        return var3_3;
    }

    private Attribute attr(String name) {
        Option option = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.client().getTable("default", "test").partitionSchema().fields())).find((Function1 & Serializable & scala.Serializable)field -> BoxesRunTime.boxToBoolean((boolean)HivePartitionFilteringSuite.$anonfun$attr$1(name, field)));
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw this.fail(new StringBuilder(37).append("Illegal name of partition attribute: ").append(name).toString(), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111));
            }
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        StructField field2 = (StructField)some.value();
        String x$1 = field2.name();
        DataType x$2 = field2.dataType();
        boolean x$3 = AttributeReference$.MODULE$.apply$default$3();
        Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$5 = AttributeReference$.MODULE$.apply$default$5(x$1, x$2, x$3, x$4);
        Seq x$6 = AttributeReference$.MODULE$.apply$default$6(x$1, x$2, x$3, x$4);
        AttributeReference attributeReference = new AttributeReference(x$1, x$2, x$3, x$4, x$5, x$6);
        return attributeReference;
    }

    public void beforeAll() {
        super.beforeAll();
        this.client_$eq(this.init(true));
        this.clientWithoutDirectSql_$eq(this.init(false));
    }

    private void testMetastorePartitionFiltering(Expression filterExpr, Seq<Object> expectedDs, Seq<Object> expectedH, Seq<String> expectedChunks, Seq<String> expectedD, Seq<String> expectedDatestr) {
        Tuple5 tuple5 = new Tuple5(expectedDs, expectedH, expectedChunks, expectedD, expectedDatestr);
        this.testMetastorePartitionFiltering(filterExpr, (Seq<Tuple5<Seq<Object>, Seq<Object>, Seq<String>, Seq<String>, Seq<String>>>)Nil$.MODULE$.$colon$colon((Object)tuple5), (Function1<Expression, Expression>)(Function1 & Serializable & scala.Serializable)x -> (Expression)Predef$.MODULE$.identity(x));
    }

    private void testMetastorePartitionFiltering(Expression filterExpr, Seq<Object> expectedDs, Seq<Object> expectedH, Seq<String> expectedChunks, Seq<String> expectedD, Seq<String> expectedDatestr, Function1<Expression, Expression> transform) {
        Tuple5 tuple5 = new Tuple5(expectedDs, expectedH, expectedChunks, expectedD, expectedDatestr);
        this.testMetastorePartitionFiltering(filterExpr, (Seq<Tuple5<Seq<Object>, Seq<Object>, Seq<String>, Seq<String>, Seq<String>>>)Nil$.MODULE$.$colon$colon((Object)tuple5), transform);
    }

    private void testMetastorePartitionFiltering(Expression filterExpr, Seq<Tuple5<Seq<Object>, Seq<Object>, Seq<String>, Seq<String>, Seq<String>>> expectedPartitionCubes) {
        this.testMetastorePartitionFiltering(filterExpr, expectedPartitionCubes, (Function1<Expression, Expression>)(Function1 & Serializable & scala.Serializable)x -> (Expression)Predef$.MODULE$.identity(x));
    }

    private void testMetastorePartitionFiltering(Expression filterExpr, Seq<Tuple5<Seq<Object>, Seq<Object>, Seq<String>, Seq<String>, Seq<String>>> expectedPartitionCubes, Function1<Expression, Expression> transform) {
        int actualFilteredPartitionCount;
        Seq filteredPartitions = this.client().getPartitionsByFilter(this.client().getTable("default", "test"), (Seq)new .colon.colon((Object)((Expression)transform.apply((Object)filterExpr)), (List)Nil$.MODULE$));
        int expectedPartitionCount = BoxesRunTime.unboxToInt((Object)((TraversableOnce)expectedPartitionCubes.map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)HivePartitionFilteringSuite.$anonfun$testMetastorePartitionFiltering$3(x0$1)), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Seq expectedPartitions = (Seq)((TraversableOnce)expectedPartitionCubes.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple5 tuple5 = x0$2;
            if (tuple5 == null) {
                throw new MatchError((Object)tuple5);
            }
            Seq expectedDs = (Seq)tuple5._1();
            Seq expectedH = (Seq)tuple5._2();
            Seq expectedChunks = (Seq)tuple5._3();
            Seq expectedD = (Seq)tuple5._4();
            Seq expectedDatestr = (Seq)tuple5._5();
            Seq seq = (Seq)expectedDs.flatMap((Function1 & Serializable & scala.Serializable)ds -> HivePartitionFilteringSuite.$anonfun$testMetastorePartitionFiltering$5(expectedH, expectedChunks, expectedD, expectedDatestr, BoxesRunTime.unboxToInt((Object)ds)), Seq$.MODULE$.canBuildFrom());
            return seq;
        }, Seq$.MODULE$.canBuildFrom())).reduce((Function2 & Serializable & scala.Serializable)(x$18, x$19) -> (Seq)x$18.$plus$plus((GenTraversableOnce)x$19, Seq$.MODULE$.canBuildFrom()));
        int $org_scalatest_assert_macro_left = actualFilteredPartitionCount = filteredPartitions.size();
        int $org_scalatest_assert_macro_right = expectedPartitionCount;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(29).append("Expected ").append(expectedPartitionCount).append(" partitions but got ").append(actualFilteredPartitionCount).toString(), Prettifier$.MODULE$.default(), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 738));
        Set $org_scalatest_assert_macro_left2 = ((TraversableOnce)filteredPartitions.map((Function1 & Serializable & scala.Serializable)x$20 -> x$20.spec().toSet(), Seq$.MODULE$.canBuildFrom())).toSet();
        Set $org_scalatest_assert_macro_right2 = expectedPartitions.toSet();
        Set set = $org_scalatest_assert_macro_left2;
        Set set2 = $org_scalatest_assert_macro_right2;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 740));
    }

    public static final /* synthetic */ Seq $anonfun$init$2(HivePartitionFilteringSuite $this, int ds$1, int h) {
        return (Seq)$this.chunkValue().flatMap((Function1 & Serializable & scala.Serializable)chunk -> (Seq)$this.dateValue().flatMap((Function1 & Serializable & scala.Serializable)date -> (Seq)$this.dateStrValue().map((Function1 & Serializable & scala.Serializable)dateStr -> new CatalogTablePartition((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ds"), (Object)Integer.toString(ds$1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"h"), (Object)Integer.toString(h)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"chunk"), chunk), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"d"), date), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"datestr"), dateStr)})), $this.storageFormat(), CatalogTablePartition$.MODULE$.apply$default$3(), CatalogTablePartition$.MODULE$.apply$default$4(), CatalogTablePartition$.MODULE$.apply$default$5(), CatalogTablePartition$.MODULE$.apply$default$6()), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ IndexedSeq $anonfun$init$1(HivePartitionFilteringSuite $this, int ds) {
        return (IndexedSeq)$this.hValue().flatMap((Function1 & Serializable & scala.Serializable)h -> HivePartitionFilteringSuite.$anonfun$init$2($this, ds, BoxesRunTime.unboxToInt((Object)h)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ boolean $anonfun$attr$1(String name$1, StructField field) {
        return field.name().equals(name$1);
    }

    private final void check$1(Expression condition, Seq result) {
        this.testMetastorePartitionFiltering(condition, (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), (Seq<String>)result, this.dateValue(), this.dateStrValue());
    }

    private final void check$2(Expression condition, Seq result) {
        this.testMetastorePartitionFiltering(condition, (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), this.chunkValue(), (Seq<String>)result, this.dateStrValue());
    }

    public static final /* synthetic */ void $anonfun$new$66(HivePartitionFilteringSuite $this, Tuple2 x0$4) {
        Tuple2 tuple2 = x0$4;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String pruningFastFallbackEnabled = (String)tuple2._1();
        Seq prunedPartition = (Seq)tuple2._2();
        $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.pruningFastFallback()), (Object)pruningFastFallbackEnabled)}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression((Expression)$this.attr("datestr")).cast((DataType)IntegerType$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(20200104)), (Seq<Object>)$this.dsValue(), (Seq<Object>)$this.hValue(), $this.chunkValue(), $this.dateValue(), (Seq<String>)prunedPartition));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ int $anonfun$testMetastorePartitionFiltering$3(Tuple5 x0$1) {
        Tuple5 tuple5 = x0$1;
        if (tuple5 == null) {
            throw new MatchError((Object)tuple5);
        }
        Seq expectedDs = (Seq)tuple5._1();
        Seq expectedH = (Seq)tuple5._2();
        Seq expectedChunks = (Seq)tuple5._3();
        Seq expectedD = (Seq)tuple5._4();
        Seq expectedDatestr = (Seq)tuple5._5();
        int n = expectedDs.size() * expectedH.size() * expectedChunks.size() * expectedD.size() * expectedDatestr.size();
        return n;
    }

    public static final /* synthetic */ Seq $anonfun$testMetastorePartitionFiltering$6(Seq expectedChunks$1, Seq expectedD$1, Seq expectedDatestr$1, int ds$2, int h) {
        return (Seq)expectedChunks$1.flatMap((Function1 & Serializable & scala.Serializable)chunk -> (Seq)expectedD$1.flatMap((Function1 & Serializable & scala.Serializable)d -> (Seq)expectedDatestr$1.map((Function1 & Serializable & scala.Serializable)datestr -> (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ds"), (Object)Integer.toString(ds$2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"h"), (Object)Integer.toString(h)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"chunk"), chunk), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"d"), d), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"datestr"), datestr)})), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ Seq $anonfun$testMetastorePartitionFiltering$5(Seq expectedH$1, Seq expectedChunks$1, Seq expectedD$1, Seq expectedDatestr$1, int ds) {
        return (Seq)expectedH$1.flatMap((Function1 & Serializable & scala.Serializable)h -> HivePartitionFilteringSuite.$anonfun$testMetastorePartitionFiltering$6(expectedChunks$1, expectedD$1, expectedDatestr$1, ds, BoxesRunTime.unboxToInt((Object)h)), Seq$.MODULE$.canBuildFrom());
    }

    public HivePartitionFilteringSuite(String version) {
        super(version);
        SQLHelper.$init$((SQLHelper)this);
        this.tryDirectSqlKey = HiveConf.ConfVars.METASTORE_TRY_DIRECT_SQL.varname;
        this.fallbackKey = SQLConf$.MODULE$.HIVE_METASTORE_PARTITION_PRUNING_FALLBACK_ON_EXCEPTION().key();
        this.pruningFastFallback = SQLConf$.MODULE$.HIVE_METASTORE_PARTITION_PRUNING_FAST_FALLBACK().key();
        this.defaultPartition = new StringOps(Predef$.MODULE$.augmentString(version)).$greater$eq((Object)"2.0") ? new Some((Object)ExternalCatalogUtils$.MODULE$.DEFAULT_PARTITION_NAME()) : None$.MODULE$;
        this.dsValue = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(20170101), 20170103);
        this.hValue = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 4);
        this.chunkValue = (Seq)new .colon.colon((Object)"aa", (List)new .colon.colon((Object)"ab", (List)new .colon.colon((Object)"ba", (List)new .colon.colon((Object)"bb", (List)Nil$.MODULE$))));
        this.dateValue = (Seq)((TraversableLike)new .colon.colon((Object)"2019-01-01", (List)new .colon.colon((Object)"2019-01-02", (List)new .colon.colon((Object)"2019-01-03", (List)Nil$.MODULE$)))).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(this.defaultPartition()), Seq$.MODULE$.canBuildFrom());
        this.dateStrValue = (Seq)new .colon.colon((Object)"2020-01-01", (List)new .colon.colon((Object)"2020-01-02", (List)new .colon.colon((Object)"2020-01-03", (List)new .colon.colon((Object)"20200104", (List)new .colon.colon((Object)"20200105", (List)Nil$.MODULE$)))));
        this.testPartitionCount = this.dsValue().size() * this.hValue().size() * this.chunkValue().size() * this.dateValue().size() * this.dateStrValue().size();
        this.storageFormat = new CatalogStorageFormat((Option)None$.MODULE$, (Option)new Some((Object)TextInputFormat.class.getName()), (Option)new Some((Object)HiveIgnoreKeyTextOutputFormat.class.getName()), (Option)new Some((Object)LazySimpleSerDe.class.getName()), false, Predef$.MODULE$.Map().empty());
        this.test(new StringBuilder(55).append("getPartitionsByFilter returns all partitions when ").append(this.fallbackKey()).append("=true").toString(), (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.fallbackKey()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Seq filteredPartitions;
            Seq $org_scalatest_assert_macro_left = filteredPartitions = this.clientWithoutDirectSql().getPartitionsByFilter(this.clientWithoutDirectSql().getTable("default", "test"), (Seq)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(20170101)), (List)Nil$.MODULE$));
            int $org_scalatest_assert_macro_right = this.testPartitionCount();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
        }), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 121));
        this.test(new StringBuilder(45).append("getPartitionsByFilter should fail when ").append(this.fallbackKey()).append("=false").toString(), (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.fallbackKey()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            RuntimeException e = (RuntimeException)this.intercept((Function0 & Serializable & scala.Serializable)() -> this.clientWithoutDirectSql().getPartitionsByFilter(this.clientWithoutDirectSql().getTable("default", "test"), (Seq)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(20170101)), (List)Nil$.MODULE$)), ClassTag$.MODULE$.apply(RuntimeException.class), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133));
            String $org_scalatest_assert_macro_left = e.getMessage();
            String $org_scalatest_assert_macro_right = "Caught Hive MetaException";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137));
        }), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 131));
        this.test("getPartitionsByFilter: ds<=>20170101", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$less$eq$greater((Expression)package.expressions$.MODULE$.intToLiteral(20170101)), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), this.chunkValue(), this.dateValue(), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 141));
        this.test("getPartitionsByFilter: ds=20170101", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(20170101)), (Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(20170101), 20170101), (Seq<Object>)this.hValue(), this.chunkValue(), this.dateValue(), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 152));
        this.test("getPartitionsByFilter: ds=(20170101 + 1) and h=0", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$eq$eq$eq(package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)20170101))).$plus((Expression)package.expressions$.MODULE$.intToLiteral(1)))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("h")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(0))), (Seq<Object>)this.dsValue(), (Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 0), this.chunkValue(), this.dateValue(), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
        this.test("getPartitionsByFilter: chunk='aa'", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String string = "aa";
            this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("chunk")).$eq$eq$eq((Expression)package.expressions$.MODULE$.stringToLiteral("aa")), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), (Seq<String>)Nil$.MODULE$.$colon$colon((Object)string), this.dateValue(), this.dateStrValue());
        }, new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 174));
        this.test("getPartitionsByFilter: cast(chunk as int)=1 (not a valid partition predicate)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression((Expression)this.attr("chunk")).cast((DataType)IntegerType$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1)), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), this.chunkValue(), this.dateValue(), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 184));
        this.test("getPartitionsByFilter: cast(chunk as boolean)=true (not a valid partition predicate)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression((Expression)this.attr("chunk")).cast((DataType)BooleanType$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.booleanToLiteral(true)), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), this.chunkValue(), this.dateValue(), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 194));
        this.test("getPartitionsByFilter: 20170101=ds", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)20170101))).$eq$eq$eq((Expression)this.attr("ds")), (Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(20170101), 20170101), (Seq<Object>)this.hValue(), this.chunkValue(), this.dateValue(), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 204));
        this.test("getPartitionsByFilter: ds=20170101 and h=2", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(20170101))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("h")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(2))), (Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(20170101), 20170101), (Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(2), 2), this.chunkValue(), this.dateValue(), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 214));
        this.test("getPartitionsByFilter: cast(ds as long)=20170101L and h=2", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).cast((DataType)LongType$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.longToLiteral(20170101L))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("h")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(2))), (Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(20170101), 20170101), (Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(2), 2), this.chunkValue(), this.dateValue(), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 224));
        this.test("getPartitionsByFilter: ds=20170101 or ds=20170102", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(20170101))).$bar$bar((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(20170102))), (Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(20170101), 20170102), (Seq<Object>)this.hValue(), this.chunkValue(), this.dateValue(), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 234));
        this.test("getPartitionsByFilter: ds in (20170102, 20170103) (using IN expression)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering(package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).in((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.intToLiteral(20170102), package.expressions$.MODULE$.intToLiteral(20170103)})), (Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(20170102), 20170103), (Seq<Object>)this.hValue(), this.chunkValue(), this.dateValue(), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 244));
        this.test("getPartitionsByFilter: cast(ds as long) in (20170102L, 20170103L) (using IN expression)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering(package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).cast((DataType)LongType$.MODULE$)).in((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.longToLiteral(20170102L), package.expressions$.MODULE$.longToLiteral(20170103L)})), (Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(20170102), 20170103), (Seq<Object>)this.hValue(), this.chunkValue(), this.dateValue(), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 254));
        this.test("getPartitionsByFilter: ds in (20170102, 20170103) (using INSET expression)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering(package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).in((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.intToLiteral(20170102), package.expressions$.MODULE$.intToLiteral(20170103)})), (Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(20170102), 20170103), (Seq<Object>)this.hValue(), this.chunkValue(), this.dateValue(), this.dateStrValue(), (Function1<Expression, Expression>)(Function1 & Serializable & scala.Serializable)x0$1 -> {
            Seq list;
            Expression v;
            block3: {
                Expression expression;
                block2: {
                    expression = x0$1;
                    if (!(expression instanceof In)) break block2;
                    In in = (In)expression;
                    v = in.value();
                    list = in.list();
                    if (in.inSetConvertible()) break block3;
                }
                throw new MatchError((Object)expression);
            }
            InSet inSet = new InSet(v, ((TraversableOnce)list.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.eval(package$.MODULE$.EmptyRow()), Seq$.MODULE$.canBuildFrom())).toSet());
            return inSet;
        }), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 264));
        this.test("getPartitionsByFilter: cast(ds as long) in (20170102L, 20170103L) (using INSET expression)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering(package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).cast((DataType)LongType$.MODULE$)).in((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.longToLiteral(20170102L), package.expressions$.MODULE$.longToLiteral(20170103L)})), (Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(20170102), 20170103), (Seq<Object>)this.hValue(), this.chunkValue(), this.dateValue(), this.dateStrValue(), (Function1<Expression, Expression>)(Function1 & Serializable & scala.Serializable)x0$2 -> {
            Seq list;
            Expression v;
            block3: {
                Expression expression;
                block2: {
                    expression = x0$2;
                    if (!(expression instanceof In)) break block2;
                    In in = (In)expression;
                    v = in.value();
                    list = in.list();
                    if (in.inSetConvertible()) break block3;
                }
                throw new MatchError((Object)expression);
            }
            InSet inSet = new InSet(v, ((TraversableOnce)list.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.eval(package$.MODULE$.EmptyRow()), Seq$.MODULE$.canBuildFrom())).toSet());
            return inSet;
        }), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 278));
        this.test("getPartitionsByFilter: chunk in ('ab', 'ba') (using IN expression)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String string = "ab";
            String string2 = "ba";
            this.testMetastorePartitionFiltering(package.expressions$.MODULE$.DslExpression((Expression)this.attr("chunk")).in((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.stringToLiteral("ab"), package.expressions$.MODULE$.stringToLiteral("ba")})), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), (Seq<String>)Nil$.MODULE$.$colon$colon((Object)string2).$colon$colon((Object)string), this.dateValue(), this.dateStrValue());
        }, new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 291));
        this.test("getPartitionsByFilter: chunk in ('ab', 'ba') (using INSET expression)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String string = "ab";
            String string2 = "ba";
            this.testMetastorePartitionFiltering(package.expressions$.MODULE$.DslExpression((Expression)this.attr("chunk")).in((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.stringToLiteral("ab"), package.expressions$.MODULE$.stringToLiteral("ba")})), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), (Seq<String>)Nil$.MODULE$.$colon$colon((Object)string2).$colon$colon((Object)string), this.dateValue(), this.dateStrValue(), (Function1<Expression, Expression>)(Function1 & Serializable & scala.Serializable)x0$3 -> {
                Seq list;
                Expression v;
                block3: {
                    Expression expression;
                    block2: {
                        expression = x0$3;
                        if (!(expression instanceof In)) break block2;
                        In in = (In)expression;
                        v = in.value();
                        list = in.list();
                        if (in.inSetConvertible()) break block3;
                    }
                    throw new MatchError((Object)expression);
                }
                InSet inSet = new InSet(v, ((TraversableOnce)list.map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.eval(package$.MODULE$.EmptyRow()), Seq$.MODULE$.canBuildFrom())).toSet());
                return inSet;
            });
        }, new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 301));
        this.test("getPartitionsByFilter: (ds=20170101 and h>=2) or (ds=20170102 and h<2)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Tuple5 day1 = new Tuple5((Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(20170101), 20170101), (Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(2), 4), this.chunkValue(), this.dateValue(), this.dateStrValue());
            Tuple5 day2 = new Tuple5((Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(20170102), 20170102), (Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 1), this.chunkValue(), this.dateValue(), this.dateStrValue());
            Tuple5 tuple5 = day1;
            Tuple5 tuple52 = day2;
            this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(20170101))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("h")).$greater$eq((Expression)package.expressions$.MODULE$.intToLiteral(2)))).$bar$bar((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(20170102))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("h")).$less((Expression)package.expressions$.MODULE$.intToLiteral(2)))), (Seq<Tuple5<Seq<Object>, Seq<Object>, Seq<String>, Seq<String>, Seq<String>>>)Nil$.MODULE$.$colon$colon((Object)tuple52).$colon$colon((Object)tuple5));
        }, new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 314));
        this.test("getPartitionsByFilter: (ds=20170101 and h>=2) or (ds=20170102 and h<(1+1))", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Tuple5 day1 = new Tuple5((Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(20170101), 20170101), (Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(2), 4), this.chunkValue(), this.dateValue(), this.dateStrValue());
            Tuple5 day2 = new Tuple5((Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(20170102), 20170102), (Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 4), this.chunkValue(), this.dateValue(), this.dateStrValue());
            Tuple5 tuple5 = day1;
            Tuple5 tuple52 = day2;
            this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(20170101))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("h")).$greater$eq((Expression)package.expressions$.MODULE$.intToLiteral(2)))).$bar$bar((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(20170102))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("h")).$less(package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))).$plus((Expression)package.expressions$.MODULE$.intToLiteral(1))))), (Seq<Tuple5<Seq<Object>, Seq<Object>, Seq<String>, Seq<String>, Seq<String>>>)Nil$.MODULE$.$colon$colon((Object)tuple52).$colon$colon((Object)tuple5));
        }, new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 321));
        this.test("getPartitionsByFilter: chunk in ('ab', 'ba') and ((ds=20170101 and h>=2) or (ds=20170102 and h<2))", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Tuple5 day1 = new Tuple5((Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(20170101), 20170101), (Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(2), 4), (Object)new .colon.colon((Object)"ab", (List)new .colon.colon((Object)"ba", (List)Nil$.MODULE$)), this.dateValue(), this.dateStrValue());
            Tuple5 day2 = new Tuple5((Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(20170102), 20170102), (Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 1), (Object)new .colon.colon((Object)"ab", (List)new .colon.colon((Object)"ba", (List)Nil$.MODULE$)), this.dateValue(), this.dateStrValue());
            Tuple5 tuple5 = day1;
            Tuple5 tuple52 = day2;
            this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression((Expression)this.attr("chunk")).in((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.stringToLiteral("ab"), package.expressions$.MODULE$.stringToLiteral("ba")}))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(20170101))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("h")).$greater$eq((Expression)package.expressions$.MODULE$.intToLiteral(2)))).$bar$bar((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(20170102))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("h")).$less((Expression)package.expressions$.MODULE$.intToLiteral(2))))), (Seq<Tuple5<Seq<Object>, Seq<Object>, Seq<String>, Seq<String>, Seq<String>>>)Nil$.MODULE$.$colon$colon((Object)tuple52).$colon$colon((Object)tuple5));
        }, new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 330));
        this.test("getPartitionsByFilter: chunk contains bb", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering(package.expressions$.MODULE$.DslExpression((Expression)this.attr("chunk")).contains((Expression)package.expressions$.MODULE$.stringToLiteral("bb")), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), (Seq<String>)((Seq)new .colon.colon((Object)"bb", (List)Nil$.MODULE$)), this.dateValue(), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 338));
        this.test("getPartitionsByFilter: chunk startsWith b", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering(package.expressions$.MODULE$.DslExpression((Expression)this.attr("chunk")).startsWith((Expression)package.expressions$.MODULE$.stringToLiteral("b")), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), (Seq<String>)((Seq)new .colon.colon((Object)"ba", (List)new .colon.colon((Object)"bb", (List)Nil$.MODULE$))), this.dateValue(), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 348));
        this.test("getPartitionsByFilter: chunk endsWith b", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering(package.expressions$.MODULE$.DslExpression((Expression)this.attr("chunk")).endsWith((Expression)package.expressions$.MODULE$.stringToLiteral("b")), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), (Seq<String>)((Seq)new .colon.colon((Object)"ab", (List)new .colon.colon((Object)"bb", (List)Nil$.MODULE$))), this.dateValue(), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 358));
        this.test("getPartitionsByFilter: chunk in ('ab', 'ba') and ((cast(ds as string)>'20170102')", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression((Expression)this.attr("chunk")).in((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.stringToLiteral("ab"), package.expressions$.MODULE$.stringToLiteral("ba")}))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).cast((DataType)StringType$.MODULE$)).$greater((Expression)package.expressions$.MODULE$.stringToLiteral("20170102"))), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), (Seq<String>)((Seq)new .colon.colon((Object)"ab", (List)new .colon.colon((Object)"ba", (List)Nil$.MODULE$))), this.dateValue(), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 368));
        this.test("getPartitionsByFilter: ds<>20170101", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$eq$bang$eq((Expression)package.expressions$.MODULE$.intToLiteral(20170101)), (Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(20170102), 20170103), (Seq<Object>)this.hValue(), this.chunkValue(), this.dateValue(), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 378));
        this.test("getPartitionsByFilter: h<>0 and chunk<>ab and d<>2019-01-01", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("h")).$eq$bang$eq((Expression)package.expressions$.MODULE$.intToLiteral(0))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("chunk")).$eq$bang$eq((Expression)package.expressions$.MODULE$.stringToLiteral("ab")))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("d")).$eq$bang$eq((Expression)package.expressions$.MODULE$.dateToLiteral(Date.valueOf("2019-01-01")))), (Seq<Object>)this.dsValue(), (Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 4), (Seq<String>)((Seq)new .colon.colon((Object)"aa", (List)new .colon.colon((Object)"ba", (List)new .colon.colon((Object)"bb", (List)Nil$.MODULE$)))), (Seq<String>)((Seq)new .colon.colon((Object)"2019-01-02", (List)new .colon.colon((Object)"2019-01-03", (List)Nil$.MODULE$))), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 388));
        this.test("getPartitionsByFilter: d=2019-01-01", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("d")).$eq$eq$eq((Expression)package.expressions$.MODULE$.dateToLiteral(Date.valueOf("2019-01-01"))), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), this.chunkValue(), (Seq<String>)((Seq)new .colon.colon((Object)"2019-01-01", (List)Nil$.MODULE$)), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 398));
        this.test("getPartitionsByFilter: d>2019-01-02", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("d")).$greater((Expression)package.expressions$.MODULE$.dateToLiteral(Date.valueOf("2019-01-02"))), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), this.chunkValue(), (Seq<String>)((Seq)new .colon.colon((Object)"2019-01-03", (List)Nil$.MODULE$)), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 408));
        this.test("getPartitionsByFilter: In(d, 2019-01-01, 2019-01-02)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering((Expression)new In((Expression)this.attr("d"), (Seq)((TraversableLike)new .colon.colon((Object)"2019-01-01", (List)new .colon.colon((Object)"2019-01-02", (List)Nil$.MODULE$))).map((Function1 & Serializable & scala.Serializable)d -> Literal$.MODULE$.apply((Object)Date.valueOf(d)), Seq$.MODULE$.canBuildFrom())), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), this.chunkValue(), (Seq<String>)((Seq)new .colon.colon((Object)"2019-01-01", (List)new .colon.colon((Object)"2019-01-02", (List)Nil$.MODULE$))), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 418));
        this.test("getPartitionsByFilter: InSet(d, 2019-01-01, 2019-01-02)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering((Expression)new InSet((Expression)this.attr("d"), (Set)((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2019-01-01", "2019-01-02"}))).map((Function1 & Serializable & scala.Serializable)d -> Literal$.MODULE$.apply((Object)Date.valueOf(d)).eval(package$.MODULE$.EmptyRow()), Set$.MODULE$.canBuildFrom())), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), this.chunkValue(), (Seq<String>)((Seq)new .colon.colon((Object)"2019-01-01", (List)new .colon.colon((Object)"2019-01-02", (List)Nil$.MODULE$))), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 429));
        this.test("getPartitionsByFilter: not in/inset string type", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.check$1((Expression)new Not((Expression)new In((Expression)this.attr("chunk"), (Seq)new .colon.colon((Object)Literal$.MODULE$.apply((Object)"aa"), (List)new .colon.colon((Object)Literal$.MODULE$.apply((Object)"ab"), (List)Nil$.MODULE$)))), (Seq)new .colon.colon((Object)"ba", (List)new .colon.colon((Object)"bb", (List)Nil$.MODULE$)));
            this.check$1((Expression)new Not((Expression)new In((Expression)this.attr("chunk"), (Seq)new .colon.colon((Object)Literal$.MODULE$.apply((Object)"aa"), (List)new .colon.colon((Object)Literal$.MODULE$.apply((Object)"ab"), (List)new .colon.colon((Object)Literal$.MODULE$.apply(null), (List)Nil$.MODULE$))))), this.chunkValue());
            Object[] objectArray = new Object[2];
            Literal qual$1 = Literal$.MODULE$.apply((Object)"aa");
            InternalRow x$1 = qual$1.eval$default$1();
            objectArray[0] = qual$1.eval(x$1);
            Literal qual$2 = Literal$.MODULE$.apply((Object)"ab");
            InternalRow x$2 = qual$2.eval$default$1();
            objectArray[1] = qual$2.eval(x$2);
            this.check$1((Expression)new Not((Expression)new InSet((Expression)this.attr("chunk"), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.genericWrapArray((Object)objectArray)))), (Seq)new .colon.colon((Object)"ba", (List)new .colon.colon((Object)"bb", (List)Nil$.MODULE$)));
            this.check$1((Expression)new Not((Expression)new InSet((Expression)this.attr("chunk"), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"aa", "ab", null})))), this.chunkValue());
        }, new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 440));
        this.test("getPartitionsByFilter: not in/inset date type", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.check$2((Expression)new Not((Expression)new In((Expression)this.attr("d"), (Seq)new .colon.colon((Object)Literal$.MODULE$.apply((Object)Date.valueOf("2019-01-01")), (List)new .colon.colon((Object)Literal$.MODULE$.apply((Object)Date.valueOf("2019-01-02")), (List)Nil$.MODULE$)))), (Seq)new .colon.colon((Object)"2019-01-03", (List)Nil$.MODULE$));
            this.check$2((Expression)new Not((Expression)new In((Expression)this.attr("d"), (Seq)new .colon.colon((Object)Literal$.MODULE$.apply((Object)Date.valueOf("2019-01-01")), (List)new .colon.colon((Object)Literal$.MODULE$.apply((Object)Date.valueOf("2019-01-02")), (List)new .colon.colon((Object)Literal$.MODULE$.apply(null), (List)Nil$.MODULE$))))), this.dateValue());
            Object[] objectArray = new Object[2];
            Literal qual$3 = Literal$.MODULE$.apply((Object)Date.valueOf("2019-01-01"));
            InternalRow x$3 = qual$3.eval$default$1();
            objectArray[0] = qual$3.eval(x$3);
            Literal qual$4 = Literal$.MODULE$.apply((Object)Date.valueOf("2019-01-02"));
            InternalRow x$4 = qual$4.eval$default$1();
            objectArray[1] = qual$4.eval(x$4);
            this.check$2((Expression)new Not((Expression)new InSet((Expression)this.attr("d"), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.genericWrapArray((Object)objectArray)))), (Seq)new .colon.colon((Object)"2019-01-03", (List)Nil$.MODULE$));
            Object[] objectArray2 = new Object[3];
            Literal qual$5 = Literal$.MODULE$.apply((Object)Date.valueOf("2019-01-01"));
            InternalRow x$5 = qual$5.eval$default$1();
            objectArray2[0] = qual$5.eval(x$5);
            Literal qual$6 = Literal$.MODULE$.apply((Object)Date.valueOf("2019-01-02"));
            InternalRow x$6 = qual$6.eval$default$1();
            objectArray2[1] = qual$6.eval(x$6);
            objectArray2[2] = null;
            this.check$2((Expression)new Not((Expression)new InSet((Expression)this.attr("d"), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.genericWrapArray((Object)objectArray2)))), this.dateValue());
        }, new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 471));
        this.test("getPartitionsByFilter: cast(datestr as date)= 2020-01-01", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression((Expression)this.attr("datestr")).cast((DataType)DateType$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.dateToLiteral(Date.valueOf("2020-01-01"))), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), this.chunkValue(), this.dateValue(), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 510));
        this.test("getPartitionsByFilter: IS NULL / IS NOT NULL", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression((Expression)this.attr("d")).isNull(), (List)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression((Expression)this.attr("d")).isNotNull(), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)filterExpr -> {
            this.testMetastorePartitionFiltering((Expression)filterExpr, (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), this.chunkValue(), this.dateValue(), this.dateStrValue());
            return BoxedUnit.UNIT;
        }), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 520));
        this.test("getPartitionsByFilter: IS NULL / IS NOT NULL with other filter", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression((Expression)this.attr("d")).isNull(), (List)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression((Expression)this.attr("d")).isNotNull(), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)filterExpr -> {
            this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)filterExpr).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("d")).$eq$eq$eq((Expression)package.expressions$.MODULE$.dateToLiteral(Date.valueOf("2019-01-01")))), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), this.chunkValue(), (Seq<String>)((Seq)new .colon.colon((Object)"2019-01-01", (List)Nil$.MODULE$)), this.dateStrValue());
            return BoxedUnit.UNIT;
        }), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 533));
        this.test("getPartitionsByFilter: d =!= 2019-01-01", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("d")).$eq$bang$eq((Expression)package.expressions$.MODULE$.dateToLiteral(Date.valueOf("2019-01-01"))), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), this.chunkValue(), (Seq<String>)((Seq)new .colon.colon((Object)"2019-01-02", (List)new .colon.colon((Object)"2019-01-03", (List)Nil$.MODULE$))), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 545));
        this.test("getPartitionsByFilter: d =!= 2019-01-01 || IS NULL", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("d")).$eq$bang$eq((Expression)package.expressions$.MODULE$.dateToLiteral(Date.valueOf("2019-01-01")))).$bar$bar((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("d")).isNull()), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), this.chunkValue(), this.dateValue(), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 555));
        this.test("getPartitionsByFilter: d <=> 2019-01-01", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("d")).$less$eq$greater((Expression)package.expressions$.MODULE$.dateToLiteral(Date.valueOf("2019-01-01"))), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), this.chunkValue(), this.dateValue(), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 565));
        this.test("getPartitionsByFilter: d <=> null", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("d")).$less$eq$greater((Expression)new Literal(null, (DataType)DateType$.MODULE$)), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), this.chunkValue(), this.dateValue(), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 575));
        this.test("SPARK-35437: getPartitionsByFilter: substr(chunk,0,1)=a", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"true"), (Object)new .colon.colon((Object)"aa", (List)new .colon.colon((Object)"ab", (List)Nil$.MODULE$))), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"false"), this.chunkValue()), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)t -> {
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pruningFastFallback()), t._1())}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)new Substring((Expression)this.attr("chunk"), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)))).$eq$eq$eq((Expression)package.expressions$.MODULE$.stringToLiteral("a")), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), (Seq<String>)((Seq)t._2()), this.dateValue(), this.dateStrValue()));
            return BoxedUnit.UNIT;
        }), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 585));
        this.test("SPARK-35437: getPartitionsByFilter: year(d)=2019", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"true"), (Object)new .colon.colon((Object)"2019-01-01", (List)new .colon.colon((Object)"2019-01-02", (List)new .colon.colon((Object)"2019-01-03", (List)Nil$.MODULE$)))), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"false"), this.dateValue()), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)t -> {
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pruningFastFallback()), t._1())}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)new Year((Expression)this.attr("d"))).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(2019)), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), this.chunkValue(), (Seq<String>)((Seq)t._2()), this.dateStrValue()));
            return BoxedUnit.UNIT;
        }), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 599));
        this.test("SPARK-35437: getPartitionsByFilter: datestr=concat(2020-,01-,01)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"true"), (Object)new .colon.colon((Object)"2020-01-01", (List)Nil$.MODULE$)), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"false"), this.dateStrValue()), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)t -> {
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pruningFastFallback()), t._1())}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("datestr")).$eq$eq$eq((Expression)new Concat((Seq)new .colon.colon((Object)package.expressions$.MODULE$.stringToLiteral("2020-"), (List)new .colon.colon((Object)package.expressions$.MODULE$.stringToLiteral("01-"), (List)new .colon.colon((Object)package.expressions$.MODULE$.stringToLiteral("01"), (List)Nil$.MODULE$))))), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), this.chunkValue(), this.dateValue(), (Seq<String>)((Seq)t._2())));
            return BoxedUnit.UNIT;
        }), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 614));
        this.test(new StringBuilder(58).append("SPARK-35437: getPartitionsByFilter: ds=20170101 when ").append(this.fallbackKey()).append("=true").toString(), (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.fallbackKey()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pruningFastFallback()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Seq filteredPartitions;
            Seq $org_scalatest_assert_macro_left = filteredPartitions = this.clientWithoutDirectSql().getPartitionsByFilter(this.clientWithoutDirectSql().getTable("default", "test"), (Seq)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(20170101)), (List)Nil$.MODULE$));
            int $org_scalatest_assert_macro_right = 1 * this.hValue().size() * this.chunkValue().size() * this.dateValue().size() * this.dateStrValue().size();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 634));
        }), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 628));
        this.test("SPARK-35437: getPartitionsByFilter: relax cast if does not need timezone", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            if (!SQLConf$.MODULE$.get().ansiEnabled()) {
                String string = "20200104";
                ((IterableLike)new .colon.colon((Object)new Tuple2((Object)"true", (Object)Nil$.MODULE$.$colon$colon((Object)string)), (List)new .colon.colon((Object)new Tuple2((Object)"false", this.dateStrValue()), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)x0$4 -> {
                    HivePartitionFilteringSuite.$anonfun$new$66(this, x0$4);
                    return BoxedUnit.UNIT;
                });
                ((IterableLike)new .colon.colon((Object)"true", (List)new .colon.colon((Object)"false", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)pruningFastFallbackEnabled -> {
                    this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pruningFastFallback()), (Object)pruningFastFallbackEnabled)}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression((Expression)this.attr("datestr")).cast((DataType)DateType$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.dateToLiteral(Date.valueOf("2020-01-01"))), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), this.chunkValue(), this.dateValue(), this.dateStrValue()));
                    return BoxedUnit.UNIT;
                });
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        }, new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 639));
    }
}

