/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.QueryTest$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.hive.HiveSessionCatalog;
import org.apache.spark.sql.hive.test.TestHive$;
import org.apache.spark.util.Utils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class JavaMetastoreDataSourcesSuite {
    private transient JavaSparkContext sc;
    private transient SQLContext sqlContext;
    File path;
    Path hiveManagedPath;
    FileSystem fs;
    Dataset<Row> df;

    @Before
    public void setUp() throws IOException {
        this.sqlContext = TestHive$.MODULE$;
        this.sc = new JavaSparkContext(this.sqlContext.sparkContext());
        this.path = Utils.createTempDir((String)System.getProperty("java.io.tmpdir"), (String)"datasource").getCanonicalFile();
        if (this.path.exists()) {
            this.path.delete();
        }
        HiveSessionCatalog catalog = (HiveSessionCatalog)this.sqlContext.sessionState().catalog();
        this.hiveManagedPath = new Path(catalog.defaultTablePath(new TableIdentifier("javaSavedTable")));
        this.fs = this.hiveManagedPath.getFileSystem(this.sc.hadoopConfiguration());
        this.fs.delete(this.hiveManagedPath, true);
        ArrayList<String> jsonObjects = new ArrayList<String>(10);
        for (int i = 0; i < 10; ++i) {
            jsonObjects.add("{\"a\":" + i + ", \"b\":\"str" + i + "\"}");
        }
        Dataset ds = this.sqlContext.createDataset(jsonObjects, Encoders.STRING());
        this.df = this.sqlContext.read().json(ds);
        this.df.createOrReplaceTempView("jsonTable");
    }

    @After
    public void tearDown() throws IOException {
        if (this.sqlContext != null) {
            this.sqlContext.sql("DROP TABLE IF EXISTS javaSavedTable");
            this.sqlContext.sql("DROP TABLE IF EXISTS externalTable");
        }
    }

    @Test
    public void saveTableAndQueryIt() {
        HashMap options = new HashMap();
        this.df.write().format("org.apache.spark.sql.json").mode(SaveMode.Append).options(options).saveAsTable("javaSavedTable");
        QueryTest$.MODULE$.checkAnswer(this.sqlContext.sql("SELECT * FROM javaSavedTable"), this.df.collectAsList());
    }
}

