/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive;

import java.io.Serializable;
import java.lang.reflect.Type;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.apache.hadoop.hive.ql.udf.UDAFPercentile;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StandardListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.TestUserClassUDT;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData$;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.hive.HiveInspectors;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005}a\u0001\u0002\b\u0010\u0001iAQa\t\u0001\u0005\u0002\u0011BQA\n\u0001\u0005\u0002\u001dBqa\f\u0001C\u0002\u0013\u0005Q\b\u0003\u0004O\u0001\u0001\u0006IA\u0010\u0005\b\u001f\u0002\u0011\r\u0011\"\u0001Q\u0011\u0019\u0011\u0006\u0001)A\u0005#\"91\u000b\u0001b\u0001\n\u0003!\u0006B\u0002/\u0001A\u0003%Q\u000bC\u0003^\u0001\u0011\u0005a\fC\u0003b\u0001\u0011\u0005!\rC\u0003w\u0001\u0011\u0005q\u000fC\u0003w\u0001\u0011\u0005Q\u0010C\u0004\u0002\u0014\u0001!\t!!\u0006\u0003%!Kg/Z%ogB,7\r^8s'VLG/\u001a\u0006\u0003!E\tA\u0001[5wK*\u0011!cE\u0001\u0004gFd'B\u0001\u000b\u0016\u0003\u0015\u0019\b/\u0019:l\u0015\t1r#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00021\u0005\u0019qN]4\u0004\u0001M\u0019\u0001aG\u0010\u0011\u0005qiR\"A\n\n\u0005y\u0019\"!D*qCJ\\g)\u001e8Tk&$X\r\u0005\u0002!C5\tq\"\u0003\u0002#\u001f\tq\u0001*\u001b<f\u0013:\u001c\b/Z2u_J\u001c\u0018A\u0002\u001fj]&$h\bF\u0001&!\t\u0001\u0003!\u0001\u0004v]^\u0014\u0018\r\u001d\u000b\u0004Q9\u0002\u0004CA\u0015-\u001b\u0005Q#\"A\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00055R#aA!os\")qF\u0001a\u0001Q\u0005!A-\u0019;b\u0011\u0015\t$\u00011\u00013\u0003\ty\u0017\u000e\u0005\u00024w5\tAG\u0003\u00026m\u0005yqN\u00196fGRLgn\u001d9fGR|'O\u0003\u00028q\u000511/\u001a:eKJR!\u0001E\u001d\u000b\u0005i*\u0012A\u00025bI>|\u0007/\u0003\u0002=i\tyqJ\u00196fGRLen\u001d9fGR|'/F\u0001?!\ryDIR\u0007\u0002\u0001*\u0011\u0011IQ\u0001\nS6lW\u000f^1cY\u0016T!a\u0011\u0016\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002F\u0001\n!A*[:u!\t9E*D\u0001I\u0015\tI%*A\u0006fqB\u0014Xm]:j_:\u001c(BA&\u0012\u0003!\u0019\u0017\r^1msN$\u0018BA'I\u0005\u001da\u0015\u000e^3sC2\fQ\u0001Z1uC\u0002\n1A]8x+\u0005\t\u0006cA EQ\u0005!!o\\<!\u0003%!\u0017\r^1UsB,7/F\u0001V!\ryDI\u0016\t\u0003/jk\u0011\u0001\u0017\u0006\u00033F\tQ\u0001^=qKNL!a\u0017-\u0003\u0011\u0011\u000bG/\u0019+za\u0016\f!\u0002Z1uCRK\b/Z:!\u0003M!xn\u0016:ji\u0006\u0014G.Z%ogB,7\r^8s)\t\u0011t\fC\u0003a\u0013\u0001\u0007a+\u0001\u0005eCR\fG+\u001f9f\u00035\u0019\u0007.Z2l\t\u0006$\u0018\rV=qKR\u00191M\u001a;\u0011\u0005%\"\u0017BA3+\u0005\u0011)f.\u001b;\t\u000b\u001dT\u0001\u0019\u00015\u0002\u0007\u0011$\u0018\u0007E\u0002jcZs!A[8\u000f\u0005-tW\"\u00017\u000b\u00055L\u0012A\u0002\u001fs_>$h(C\u0001,\u0013\t\u0001(&A\u0004qC\u000e\\\u0017mZ3\n\u0005I\u001c(aA*fc*\u0011\u0001O\u000b\u0005\u0006k*\u0001\r\u0001[\u0001\u0004IR\u0014\u0014aC2iK\u000e\\g+\u00197vKN$2a\u0019=|\u0011\u0015I8\u00021\u0001{\u0003\u0011\u0011xn^\u0019\u0011\u0007%\f\b\u0006C\u0003}\u0017\u0001\u0007!0\u0001\u0003s_^\u0014D#B2\u007f\u007f\u0006%\u0001\"B=\r\u0001\u0004Q\bB\u0002?\r\u0001\u0004\t\t\u0001\u0005\u0003\u0002\u0004\u0005\u0015Q\"\u0001&\n\u0007\u0005\u001d!JA\u0006J]R,'O\\1m%><\bbBA\u0006\u0019\u0001\u0007\u0011QB\u0001\u000be><(gU2iK6\f\u0007cA,\u0002\u0010%\u0019\u0011\u0011\u0003-\u0003\u0015M#(/^2u)f\u0004X-\u0001\u0006dQ\u0016\u001c7NV1mk\u0016$RaYA\f\u00037Aa!!\u0007\u000e\u0001\u0004A\u0013A\u0001<2\u0011\u0019\ti\"\u0004a\u0001Q\u0005\u0011aO\r")
public class HiveInspectorSuite
extends SparkFunSuite
implements HiveInspectors {
    private final List<Literal> data;
    private final List<Object> row;
    private final List<DataType> dataTypes;

    public DataType javaTypeToDataType(Type clz) {
        return HiveInspectors.javaTypeToDataType$((HiveInspectors)this, (Type)clz);
    }

    public Function1<Object, Object> wrapperFor(ObjectInspector oi, DataType dataType) {
        return HiveInspectors.wrapperFor$((HiveInspectors)this, (ObjectInspector)oi, (DataType)dataType);
    }

    public Function1<Object, Object> unwrapperFor(ObjectInspector objectInspector) {
        return HiveInspectors.unwrapperFor$((HiveInspectors)this, (ObjectInspector)objectInspector);
    }

    public Function3<Object, InternalRow, Object, BoxedUnit> unwrapperFor(org.apache.hadoop.hive.serde2.objectinspector.StructField field) {
        return HiveInspectors.unwrapperFor$((HiveInspectors)this, (org.apache.hadoop.hive.serde2.objectinspector.StructField)field);
    }

    public Object wrap(Object a, ObjectInspector oi, DataType dataType) {
        return HiveInspectors.wrap$((HiveInspectors)this, (Object)a, (ObjectInspector)oi, (DataType)dataType);
    }

    public Object[] wrap(InternalRow row, Function1<Object, Object>[] wrappers, Object[] cache, DataType[] dataTypes) {
        return HiveInspectors.wrap$((HiveInspectors)this, (InternalRow)row, wrappers, (Object[])cache, (DataType[])dataTypes);
    }

    public Object[] wrap(Seq<Object> row, Function1<Object, Object>[] wrappers, Object[] cache, DataType[] dataTypes) {
        return HiveInspectors.wrap$((HiveInspectors)this, row, wrappers, (Object[])cache, (DataType[])dataTypes);
    }

    public ObjectInspector toInspector(DataType dataType) {
        return HiveInspectors.toInspector$((HiveInspectors)this, (DataType)dataType);
    }

    public ObjectInspector toInspector(Expression expr) {
        return HiveInspectors.toInspector$((HiveInspectors)this, (Expression)expr);
    }

    public DataType inspectorToDataType(ObjectInspector inspector) {
        return HiveInspectors.inspectorToDataType$((HiveInspectors)this, (ObjectInspector)inspector);
    }

    public HiveInspectors.typeInfoConversions typeInfoConversions(DataType dt) {
        return HiveInspectors.typeInfoConversions$((HiveInspectors)this, (DataType)dt);
    }

    public Object unwrap(Object data, ObjectInspector oi) {
        Function1<Object, Object> unwrapper = this.unwrapperFor(oi);
        return unwrapper.apply(data);
    }

    public List<Literal> data() {
        return this.data;
    }

    public List<Object> row() {
        return this.row;
    }

    public List<DataType> dataTypes() {
        return this.dataTypes;
    }

    public ObjectInspector toWritableInspector(DataType dataType) {
        StandardListObjectInspector standardListObjectInspector;
        DataType dataType2 = dataType;
        if (dataType2 instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType2;
            DataType tpe = arrayType.elementType();
            standardListObjectInspector = ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)this.toWritableInspector(tpe));
        } else if (dataType2 instanceof MapType) {
            MapType mapType = (MapType)dataType2;
            DataType keyType = mapType.keyType();
            DataType valueType = mapType.valueType();
            standardListObjectInspector = ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)this.toWritableInspector(keyType), (ObjectInspector)this.toWritableInspector(valueType));
        } else if (StringType$.MODULE$.equals(dataType2)) {
            standardListObjectInspector = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        } else if (IntegerType$.MODULE$.equals(dataType2)) {
            standardListObjectInspector = PrimitiveObjectInspectorFactory.writableIntObjectInspector;
        } else if (DoubleType$.MODULE$.equals(dataType2)) {
            standardListObjectInspector = PrimitiveObjectInspectorFactory.writableDoubleObjectInspector;
        } else if (BooleanType$.MODULE$.equals(dataType2)) {
            standardListObjectInspector = PrimitiveObjectInspectorFactory.writableBooleanObjectInspector;
        } else if (LongType$.MODULE$.equals(dataType2)) {
            standardListObjectInspector = PrimitiveObjectInspectorFactory.writableLongObjectInspector;
        } else if (FloatType$.MODULE$.equals(dataType2)) {
            standardListObjectInspector = PrimitiveObjectInspectorFactory.writableFloatObjectInspector;
        } else if (ShortType$.MODULE$.equals(dataType2)) {
            standardListObjectInspector = PrimitiveObjectInspectorFactory.writableShortObjectInspector;
        } else if (ByteType$.MODULE$.equals(dataType2)) {
            standardListObjectInspector = PrimitiveObjectInspectorFactory.writableByteObjectInspector;
        } else if (NullType$.MODULE$.equals(dataType2)) {
            standardListObjectInspector = PrimitiveObjectInspectorFactory.writableVoidObjectInspector;
        } else if (BinaryType$.MODULE$.equals(dataType2)) {
            standardListObjectInspector = PrimitiveObjectInspectorFactory.writableBinaryObjectInspector;
        } else if (DateType$.MODULE$.equals(dataType2)) {
            standardListObjectInspector = PrimitiveObjectInspectorFactory.writableDateObjectInspector;
        } else if (TimestampType$.MODULE$.equals(dataType2)) {
            standardListObjectInspector = PrimitiveObjectInspectorFactory.writableTimestampObjectInspector;
        } else if (DecimalType$.MODULE$.unapply(dataType2)) {
            standardListObjectInspector = PrimitiveObjectInspectorFactory.writableHiveDecimalObjectInspector;
        } else if (dataType2 instanceof StructType) {
            StructType structType = (StructType)dataType2;
            StructField[] fields = structType.fields();
            standardListObjectInspector = ObjectInspectorFactory.getStandardStructObjectInspector(Arrays.asList((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).map((Function1 & Serializable & scala.Serializable)f -> f.name(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))), Arrays.asList((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).map((Function1 & Serializable & scala.Serializable)f -> this.toWritableInspector(f.dataType()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ObjectInspector.class)))));
        } else {
            throw new MatchError((Object)dataType2);
        }
        return standardListObjectInspector;
    }

    public void checkDataType(Seq<DataType> dt1, Seq<DataType> dt2) {
        ((IterableLike)dt1.zip(dt2, Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            DataType dd1 = (DataType)tuple2._1();
            DataType dd2 = (DataType)tuple2._2();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(dd1.getClass());
            Class $org_scalatest_assert_macro_right = dd2.getClass();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertion assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveInspectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 128));
            return assertion;
        });
    }

    public void checkValues(Seq<Object> row1, Seq<Object> row2) {
        ((IterableLike)row1.zip(row2, Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            HiveInspectorSuite.$anonfun$checkValues$1(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public void checkValues(Seq<Object> row1, InternalRow row2, StructType row2Schema) {
        ((IterableLike)row1.zip((GenIterable)row2.toSeq(row2Schema), Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            HiveInspectorSuite.$anonfun$checkValues$2(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    public void checkValue(Object v1, Object v2) {
        Tuple2 tuple2 = new Tuple2(v1, v2);
        if (tuple2 != null) {
            Object r1 = tuple2._1();
            Object r2 = tuple2._2();
            if (r1 instanceof Decimal) {
                Decimal decimal = (Decimal)r1;
                if (r2 instanceof Decimal) {
                    Decimal decimal2 = (Decimal)r2;
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)decimal.compare(decimal2)));
                    int $org_scalatest_assert_macro_right = 0;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveInspectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
            }
        }
        if (tuple2 != null) {
            Object r1 = tuple2._1();
            Object r2 = tuple2._2();
            if (r1 instanceof byte[]) {
                byte[] byArray = (byte[])r1;
                if (r2 instanceof byte[]) {
                    byte[] byArray2 = (byte[])r2;
                    if (byArray != null && byArray2 != null && byArray.length == byArray2.length) {
                        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(byArray)).zip((GenIterable)Predef$.MODULE$.wrapByteArray(byArray2), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                            Tuple2 tuple2 = x0$1;
                            if (tuple2 == null) {
                                throw new MatchError((Object)tuple2);
                            }
                            byte b1 = BoxesRunTime.unboxToByte((Object)tuple2._1());
                            byte b2 = BoxesRunTime.unboxToByte((Object)tuple2._2());
                            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToByte((byte)b1));
                            byte $org_scalatest_assert_macro_right = b2;
                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToByte((byte)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToByte((byte)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                            Assertion assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveInspectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 151));
                            return assertion;
                        });
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                }
            }
        }
        if (tuple2 != null) {
            Object r1 = tuple2._1();
            Object r2 = tuple2._2();
            if (r1 instanceof MapData && r2 instanceof MapData) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Object r1 = tuple2._1();
        Object r2 = tuple2._2();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(r1);
        Object $org_scalatest_assert_macro_right = r2;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveInspectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$checkValues$1(HiveInspectorSuite $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Object r1 = tuple2._1();
        Object r2 = tuple2._2();
        $this.checkValue(r1, r2);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$checkValues$2(HiveInspectorSuite $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Object r1 = tuple2._1();
        Object r2 = tuple2._2();
        $this.checkValue(r1, r2);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$new$11(Literal x$22) {
        return !(x$22.dataType() instanceof StructType);
    }

    public HiveInspectorSuite() {
        HiveInspectors.$init$((HiveInspectors)this);
        this.test("Test wrap SettableStructObjectInspector", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            UDAFPercentile.PercentileLongEvaluator udaf = new UDAFPercentile.PercentileLongEvaluator();
            udaf.init();
            udaf.iterate(new LongWritable(1L), Predef$.MODULE$.double2Double(0.1));
            udaf.iterate(new LongWritable(1L), Predef$.MODULE$.double2Double(0.1));
            UDAFPercentile.State state = udaf.terminatePartial();
            StructObjectInspector soi = (StructObjectInspector)ObjectInspectorFactory.getReflectionObjectInspector(UDAFPercentile.State.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            InternalRow a = (InternalRow)this.unwrap(state, (ObjectInspector)soi);
            StructType dt = new StructType().add("counts", (DataType)MapType$.MODULE$.apply((DataType)LongType$.MODULE$, (DataType)LongType$.MODULE$)).add("percentiles", (DataType)ArrayType$.MODULE$.apply((DataType)DoubleType$.MODULE$));
            UDAFPercentile.State b = (UDAFPercentile.State)this.wrap(a, (ObjectInspector)soi, (DataType)dt);
            org.apache.hadoop.hive.serde2.objectinspector.StructField sfCounts = soi.getStructFieldRef("counts");
            org.apache.hadoop.hive.serde2.objectinspector.StructField sfPercentiles = soi.getStructFieldRef("percentiles");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)2));
            long $org_scalatest_assert_macro_right = ((LongWritable)((Map)soi.getStructFieldData((Object)b, sfCounts)).get(new LongWritable(1L))).get();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveInspectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)0.1));
            double $org_scalatest_assert_macro_right2 = ((DoubleWritable)((ArrayList)soi.getStructFieldData((Object)b, sfPercentiles)).get(0)).get();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveInspectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
        }, new Position("HiveInspectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 43));
        Literal literal = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Literal literal2 = Literal$.MODULE$.apply(null);
        Literal literal3 = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToByte((byte)((byte)0)));
        Literal literal4 = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToShort((short)((short)0)));
        Literal literal5 = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0));
        Literal literal6 = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)0));
        Literal literal7 = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToFloat((float)0.0f));
        Literal literal8 = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)0.0));
        Literal literal9 = Literal$.MODULE$.apply((Object)"0");
        Literal literal10 = Literal$.MODULE$.apply((Object)Date.valueOf("2014-09-23"));
        Literal literal11 = Literal$.MODULE$.apply((Object)Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply("123.123")));
        Literal literal12 = Literal$.MODULE$.apply((Object)new Timestamp(123123L));
        Literal literal13 = Literal$.MODULE$.apply(Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{1, 2, 3}), ClassTag$.MODULE$.Byte()));
        Literal literal14 = Literal$.MODULE$.create((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (DataType)ArrayType$.MODULE$.apply((DataType)IntegerType$.MODULE$));
        Literal literal15 = Literal$.MODULE$.create((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToInteger((int)1))})), (DataType)MapType$.MODULE$.apply((DataType)IntegerType$.MODULE$, (DataType)IntegerType$.MODULE$));
        StructField structField = new StructField("c1", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        StructField structField2 = new StructField("c2", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        StructField structField3 = new StructField("c3", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        Literal literal16 = Literal$.MODULE$.create((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)2.0), BoxesRunTime.boxToFloat((float)3.0f)})), (DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField3).$colon$colon((Object)structField2).$colon$colon((Object)structField)));
        this.data = Nil$.MODULE$.$colon$colon((Object)literal16).$colon$colon((Object)literal15).$colon$colon((Object)literal14).$colon$colon((Object)literal13).$colon$colon((Object)literal12).$colon$colon((Object)literal11).$colon$colon((Object)literal10).$colon$colon((Object)literal9).$colon$colon((Object)literal8).$colon$colon((Object)literal7).$colon$colon((Object)literal6).$colon$colon((Object)literal5).$colon$colon((Object)literal4).$colon$colon((Object)literal3).$colon$colon((Object)literal2).$colon$colon((Object)literal);
        this.row = (List)this.data().map((Function1 & Serializable & scala.Serializable)x$20 -> x$20.eval(null), List$.MODULE$.canBuildFrom());
        this.dataTypes = (List)this.data().map((Function1 & Serializable & scala.Serializable)x$21 -> x$21.dataType(), List$.MODULE$.canBuildFrom());
        this.test("oi => datatype => oi", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            List ois = (List)this.dataTypes().map((Function1 & Serializable & scala.Serializable)dataType -> this.toInspector((DataType)dataType), List$.MODULE$.canBuildFrom());
            this.checkDataType((Seq<DataType>)((Seq)ois.map((Function1 & Serializable & scala.Serializable)inspector -> this.inspectorToDataType((ObjectInspector)inspector), List$.MODULE$.canBuildFrom())), (Seq<DataType>)this.dataTypes());
            this.checkDataType((Seq<DataType>)((Seq)((List)this.dataTypes().map((Function1 & Serializable & scala.Serializable)dataType -> this.toWritableInspector((DataType)dataType), List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)inspector -> this.inspectorToDataType((ObjectInspector)inspector), List$.MODULE$.canBuildFrom())), (Seq<DataType>)this.dataTypes());
        }, new Position("HiveInspectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 158));
        this.test("wrap / unwrap null, constant null and writables", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            List writableOIs = (List)this.dataTypes().map((Function1 & Serializable & scala.Serializable)dataType -> this.toWritableInspector((DataType)dataType), List$.MODULE$.canBuildFrom());
            List nullRow = (List)this.data().map((Function1 & Serializable & scala.Serializable)d -> null, List$.MODULE$.canBuildFrom());
            this.checkValues((Seq<Object>)nullRow, (Seq<Object>)((Seq)((List)((IterableLike)nullRow.zip((GenIterable)writableOIs, List$.MODULE$.canBuildFrom())).zip(this.dataTypes(), List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                DataType dt;
                Tuple2 tuple2;
                block3: {
                    Tuple2 tuple22;
                    block2: {
                        tuple22 = x0$1;
                        if (tuple22 == null) break block2;
                        tuple2 = (Tuple2)tuple22._1();
                        dt = (DataType)tuple22._2();
                        if (tuple2 != null) break block3;
                    }
                    throw new MatchError((Object)tuple22);
                }
                Null$ d = (Null$)tuple2._1();
                ObjectInspector oi = (ObjectInspector)tuple2._2();
                Object object = this.unwrap(this.wrap(null, oi, dt), oi);
                return object;
            }, List$.MODULE$.canBuildFrom())));
            List constantExprs = (List)this.data().filter((Function1 & Serializable & scala.Serializable)x$22 -> BoxesRunTime.boxToBoolean((boolean)HiveInspectorSuite.$anonfun$new$11(x$22)));
            List constantTypes = (List)constantExprs.map((Function1 & Serializable & scala.Serializable)x$23 -> x$23.dataType(), List$.MODULE$.canBuildFrom());
            List constantData = (List)constantExprs.map((Function1 & Serializable & scala.Serializable)x$24 -> x$24.eval(x$24.eval$default$1()), List$.MODULE$.canBuildFrom());
            List constantNullData = (List)constantData.map((Function1 & Serializable & scala.Serializable)x$25 -> null, List$.MODULE$.canBuildFrom());
            List constantWritableOIs = (List)constantExprs.map((Function1 & Serializable & scala.Serializable)e -> this.toWritableInspector(e.dataType()), List$.MODULE$.canBuildFrom());
            List constantNullWritableOIs = (List)constantExprs.map((Function1 & Serializable & scala.Serializable)e -> this.toInspector((Expression)Literal$.MODULE$.create(null, e.dataType())), List$.MODULE$.canBuildFrom());
            this.checkValues((Seq<Object>)constantData, (Seq<Object>)((Seq)((List)((IterableLike)constantData.zip((GenIterable)constantWritableOIs, List$.MODULE$.canBuildFrom())).zip((GenIterable)constantTypes, List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                DataType dt;
                Tuple2 tuple2;
                block3: {
                    Tuple2 tuple22;
                    block2: {
                        tuple22 = x0$2;
                        if (tuple22 == null) break block2;
                        tuple2 = (Tuple2)tuple22._1();
                        dt = (DataType)tuple22._2();
                        if (tuple2 != null) break block3;
                    }
                    throw new MatchError((Object)tuple22);
                }
                Object d = tuple2._1();
                ObjectInspector oi = (ObjectInspector)tuple2._2();
                Object object = this.unwrap(this.wrap(d, oi, dt), oi);
                return object;
            }, List$.MODULE$.canBuildFrom())));
            this.checkValues((Seq<Object>)constantNullData, (Seq<Object>)((Seq)((List)((IterableLike)constantData.zip((GenIterable)constantNullWritableOIs, List$.MODULE$.canBuildFrom())).zip((GenIterable)constantTypes, List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                DataType dt;
                Tuple2 tuple2;
                block3: {
                    Tuple2 tuple22;
                    block2: {
                        tuple22 = x0$3;
                        if (tuple22 == null) break block2;
                        tuple2 = (Tuple2)tuple22._1();
                        dt = (DataType)tuple22._2();
                        if (tuple2 != null) break block3;
                    }
                    throw new MatchError((Object)tuple22);
                }
                Object d = tuple2._1();
                ObjectInspector oi = (ObjectInspector)tuple2._2();
                Object object = this.unwrap(this.wrap(d, oi, dt), oi);
                return object;
            }, List$.MODULE$.canBuildFrom())));
            this.checkValues((Seq<Object>)constantNullData, (Seq<Object>)((Seq)((List)((IterableLike)constantNullData.zip((GenIterable)constantWritableOIs, List$.MODULE$.canBuildFrom())).zip((GenIterable)constantTypes, List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$4 -> {
                DataType dt;
                Tuple2 tuple2;
                block3: {
                    Tuple2 tuple22;
                    block2: {
                        tuple22 = x0$4;
                        if (tuple22 == null) break block2;
                        tuple2 = (Tuple2)tuple22._1();
                        dt = (DataType)tuple22._2();
                        if (tuple2 != null) break block3;
                    }
                    throw new MatchError((Object)tuple22);
                }
                Null$ d = (Null$)tuple2._1();
                ObjectInspector oi = (ObjectInspector)tuple2._2();
                Object object = this.unwrap(this.wrap(null, oi, dt), oi);
                return object;
            }, List$.MODULE$.canBuildFrom())));
        }, new Position("HiveInspectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 165));
        this.test("wrap / unwrap primitive writable object inspector", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            List writableOIs = (List)this.dataTypes().map((Function1 & Serializable & scala.Serializable)dataType -> this.toWritableInspector((DataType)dataType), List$.MODULE$.canBuildFrom());
            this.checkValues((Seq<Object>)this.row(), (Seq<Object>)((Seq)((List)((IterableLike)this.row().zip((GenIterable)writableOIs, List$.MODULE$.canBuildFrom())).zip(this.dataTypes(), List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$5 -> {
                DataType dt;
                Tuple2 tuple2;
                block3: {
                    Tuple2 tuple22;
                    block2: {
                        tuple22 = x0$5;
                        if (tuple22 == null) break block2;
                        tuple2 = (Tuple2)tuple22._1();
                        dt = (DataType)tuple22._2();
                        if (tuple2 != null) break block3;
                    }
                    throw new MatchError((Object)tuple22);
                }
                Object data = tuple2._1();
                ObjectInspector oi = (ObjectInspector)tuple2._2();
                Object object = this.unwrap(this.wrap(data, oi, dt), oi);
                return object;
            }, List$.MODULE$.canBuildFrom())));
        }, new Position("HiveInspectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 195));
        this.test("wrap / unwrap primitive java object inspector", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            List ois = (List)this.dataTypes().map((Function1 & Serializable & scala.Serializable)dataType -> this.toInspector((DataType)dataType), List$.MODULE$.canBuildFrom());
            this.checkValues((Seq<Object>)this.row(), (Seq<Object>)((Seq)((List)((IterableLike)this.row().zip((GenIterable)ois, List$.MODULE$.canBuildFrom())).zip(this.dataTypes(), List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$6 -> {
                DataType dt;
                Tuple2 tuple2;
                block3: {
                    Tuple2 tuple22;
                    block2: {
                        tuple22 = x0$6;
                        if (tuple22 == null) break block2;
                        tuple2 = (Tuple2)tuple22._1();
                        dt = (DataType)tuple22._2();
                        if (tuple2 != null) break block3;
                    }
                    throw new MatchError((Object)tuple22);
                }
                Object data = tuple2._1();
                ObjectInspector oi = (ObjectInspector)tuple2._2();
                Object object = this.unwrap(this.wrap(data, oi, dt), oi);
                return object;
            }, List$.MODULE$.canBuildFrom())));
        }, new Position("HiveInspectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 203));
        this.test("wrap / unwrap UDT Type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TestUserClassUDT dt = new TestUserClassUDT();
            this.checkValue(BoxesRunTime.boxToInteger((int)1), this.unwrap(this.wrap(BoxesRunTime.boxToInteger((int)1), this.toInspector((DataType)dt), (DataType)dt), this.toInspector((DataType)dt)));
            this.checkValue(null, this.unwrap(this.wrap(null, this.toInspector((DataType)dt), (DataType)dt), this.toInspector((DataType)dt)));
        }, new Position("HiveInspectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 211));
        this.test("wrap / unwrap Struct Type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            StructType dt = StructType$.MODULE$.apply((Seq)((List)this.dataTypes().zipWithIndex(List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$7 -> {
                Tuple2 tuple2 = x0$7;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                DataType t = (DataType)tuple2._1();
                int idx = tuple2._2$mcI$sp();
                StructField structField = new StructField(new StringBuilder(2).append("c_").append(idx).toString(), t, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                return structField;
            }, List$.MODULE$.canBuildFrom()));
            ObjectInspector inspector = this.toInspector((DataType)dt);
            this.checkValues((Seq<Object>)this.row(), (InternalRow)this.unwrap(this.wrap(InternalRow$.MODULE$.fromSeq(this.row()), inspector, (DataType)dt), inspector), dt);
            this.checkValue(null, this.unwrap(this.wrap(null, this.toInspector((DataType)dt), (DataType)dt), this.toInspector((DataType)dt)));
        }, new Position("HiveInspectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 217));
        this.test("wrap / unwrap Array Type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ArrayType dt = ArrayType$.MODULE$.apply((DataType)this.dataTypes().apply(0));
            GenericArrayData d = new GenericArrayData(new Object[]{this.row().apply(0), this.row().apply(0)});
            this.checkValue(d, this.unwrap(this.wrap(d, this.toInspector((DataType)dt), (DataType)dt), this.toInspector((DataType)dt)));
            this.checkValue(null, this.unwrap(this.wrap(null, this.toInspector((DataType)dt), (DataType)dt), this.toInspector((DataType)dt)));
            this.checkValue(d, this.unwrap(this.wrap(d, this.toInspector((Expression)Literal$.MODULE$.create((Object)d, (DataType)dt)), (DataType)dt), this.toInspector((Expression)Literal$.MODULE$.create((Object)d, (DataType)dt))));
            this.checkValue(d, this.unwrap(this.wrap(null, this.toInspector((Expression)Literal$.MODULE$.create((Object)d, (DataType)dt)), (DataType)dt), this.toInspector((Expression)Literal$.MODULE$.create((Object)d, (DataType)dt))));
        }, new Position("HiveInspectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 229));
        this.test("wrap / unwrap Map Type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            MapType dt = MapType$.MODULE$.apply((DataType)this.dataTypes().apply(0), (DataType)this.dataTypes().apply(1));
            ArrayBasedMapData d = ArrayBasedMapData$.MODULE$.apply((Object)new Object[]{this.row().apply(0)}, (Object)new Object[]{this.row().apply(1)});
            this.checkValue(d, this.unwrap(this.wrap(d, this.toInspector((DataType)dt), (DataType)dt), this.toInspector((DataType)dt)));
            this.checkValue(null, this.unwrap(this.wrap(null, this.toInspector((DataType)dt), (DataType)dt), this.toInspector((DataType)dt)));
            this.checkValue(d, this.unwrap(this.wrap(d, this.toInspector((Expression)Literal$.MODULE$.create((Object)d, (DataType)dt)), (DataType)dt), this.toInspector((Expression)Literal$.MODULE$.create((Object)d, (DataType)dt))));
            this.checkValue(d, this.unwrap(this.wrap(null, this.toInspector((Expression)Literal$.MODULE$.create((Object)d, (DataType)dt)), (DataType)dt), this.toInspector((Expression)Literal$.MODULE$.create((Object)d, (DataType)dt))));
        }, new Position("HiveInspectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 242));
    }
}

