/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive;

import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Locale;
import java.util.Map;
import org.apache.spark.metrics.source.HiveCatalogMetrics$;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.StatisticsCollectionTestBase;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier$;
import org.apache.spark.sql.catalyst.analysis.NoSuchPartitionException;
import org.apache.spark.sql.catalyst.catalog.CatalogColumnStat;
import org.apache.spark.sql.catalyst.catalog.CatalogColumnStat$;
import org.apache.spark.sql.catalyst.catalog.CatalogStatistics;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.HiveTableRelation;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.plans.logical.Histogram;
import org.apache.spark.sql.catalyst.plans.logical.HistogramBin;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.StringUtils$;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.command.AnalyzeColumnCommand;
import org.apache.spark.sql.execution.command.CommandUtils$;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.joins.BroadcastHashJoinExec;
import org.apache.spark.sql.execution.joins.SortMergeJoinExec;
import org.apache.spark.sql.hive.HiveExternalCatalog$;
import org.apache.spark.sql.hive.HiveSessionCatalog;
import org.apache.spark.sql.hive.HiveUtils$;
import org.apache.spark.sql.hive.StatisticsSuite$;
import org.apache.spark.sql.hive.client.HiveClient;
import org.apache.spark.sql.hive.test.TestHiveContext;
import org.apache.spark.sql.hive.test.TestHiveSingleton;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product13;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.LinkedHashMap;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\u0005%a\u0001\u0002\u0006\f\u0001YAQ!\t\u0001\u0005\u0002\tBQ!\n\u0001\u0005\n\u0019Bq!\u0011\u0001\u0012\u0002\u0013%!\tC\u0004N\u0001E\u0005I\u0011\u0002\"\t\u000b9\u0003A\u0011B(\t\u000b\r\u0004A\u0011\u00023\t\u000b!\u0004A\u0011B5\t\u000b=\u0004A\u0011\u00029\t\u000bU\u0004A\u0011\u0002<\u0003\u001fM#\u0018\r^5ti&\u001c7oU;ji\u0016T!\u0001D\u0007\u0002\t!Lg/\u001a\u0006\u0003\u001d=\t1a]9m\u0015\t\u0001\u0012#A\u0003ta\u0006\u00148N\u0003\u0002\u0013'\u00051\u0011\r]1dQ\u0016T\u0011\u0001F\u0001\u0004_J<7\u0001A\n\u0004\u0001]Y\u0002C\u0001\r\u001a\u001b\u0005i\u0011B\u0001\u000e\u000e\u0005q\u0019F/\u0019;jgRL7m]\"pY2,7\r^5p]R+7\u000f\u001e\"bg\u0016\u0004\"\u0001H\u0010\u000e\u0003uQ!AH\u0006\u0002\tQ,7\u000f^\u0005\u0003Au\u0011\u0011\u0003V3ti\"Kg/Z*j]\u001edW\r^8o\u0003\u0019a\u0014N\\5u}Q\t1\u0005\u0005\u0002%\u00015\t1\"A\rde\u0016\fG/\u001a(p]B\u000b'\u000f^5uS>tW\r\u001a+bE2,G\u0003B\u0014.u}\u0002\"\u0001K\u0016\u000e\u0003%R\u0011AK\u0001\u0006g\u000e\fG.Y\u0005\u0003Y%\u0012A!\u00168ji\")aF\u0001a\u0001_\u00059A/\u00192OC6,\u0007C\u0001\u00198\u001d\t\tT\u0007\u0005\u00023S5\t1G\u0003\u00025+\u00051AH]8pizJ!AN\u0015\u0002\rA\u0013X\rZ3g\u0013\tA\u0014H\u0001\u0004TiJLgn\u001a\u0006\u0003m%Bqa\u000f\u0002\u0011\u0002\u0003\u0007A(A\bb]\u0006d\u0017P_3e\u0005f\u001c\u0006/\u0019:l!\tAS(\u0003\u0002?S\t9!i\\8mK\u0006t\u0007b\u0002!\u0003!\u0003\u0005\r\u0001P\u0001\u000fC:\fG.\u001f>fI\nK\b*\u001b<f\u0003\r\u001a'/Z1uK:{g\u000eU1si&$\u0018n\u001c8fIR\u000b'\r\\3%I\u00164\u0017-\u001e7uII*\u0012a\u0011\u0016\u0003y\u0011[\u0013!\u0012\t\u0003\r.k\u0011a\u0012\u0006\u0003\u0011&\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005)K\u0013AC1o]>$\u0018\r^5p]&\u0011Aj\u0012\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017aI2sK\u0006$XMT8o!\u0006\u0014H/\u001b;j_:,G\rV1cY\u0016$C-\u001a4bk2$HeM\u0001\u0017Kb$(/Y2u'R\fGo\u001d)s_B4\u0016\r\\;fgR\u0019\u0001\u000bX1\u0011\u0007!\n6+\u0003\u0002SS\t1q\n\u001d;j_:\u0004\"\u0001V-\u000f\u0005U;fB\u0001\u001aW\u0013\u0005Q\u0013B\u0001-*\u0003\u001d\u0001\u0018mY6bO\u0016L!AW.\u0003\r\tKw-\u00138u\u0015\tA\u0016\u0006C\u0003^\u000b\u0001\u0007a,\u0001\u0006eKN\u001cw*\u001e;qkR\u00042\u0001V00\u0013\t\u00017LA\u0002TKFDQAY\u0003A\u0002=\nq\u0001\u001d:pa.+\u00170\u0001\ruKN$\u0018\t\u001c;feR\u000b'\r\\3Qe>\u0004XM\u001d;jKN$2aJ3g\u0011\u0015qc\u00011\u00010\u0011\u00159g\u00011\u00010\u0003E\tG\u000e^3s)\u0006\u0014G.\u001a)s_B\u001cU\u000eZ\u0001\u0013O\u0016$8\u000b^1ugB\u0013x\u000e]3si&,7\u000f\u0006\u0002k[B!\u0001g[\u00180\u0013\ta\u0017HA\u0002NCBDQA\\\u0004A\u0002=\n\u0011\u0002^1cY\u0016t\u0015-\\3\u0002-Q,7\u000f^+qI\u0006$\u0018N\\4UC\ndWm\u0015;biN$2aJ9t\u0011\u0015\u0011\b\u00021\u00010\u0003A!\u0018M\u00197f\t\u0016\u001c8M]5qi&|g\u000eC\u0003u\u0011\u0001\u0007q&\u0001\bde\u0016\fG/\u001a+bE2,7)\u001c3\u00023\u001d,Go\u0015;biN\u0014UMZ8sK\u00063G/\u001a:Va\u0012\fG/\u001a\u000b\u0004o\u0006\u0015\u0001\u0003\u0002\u0015yujL!!_\u0015\u0003\rQ+\b\u000f\\33!\rY\u0018\u0011A\u0007\u0002y*\u0011QP`\u0001\bG\u0006$\u0018\r\\8h\u0015\tyX\"\u0001\u0005dCR\fG._:u\u0013\r\t\u0019\u0001 \u0002\u0012\u0007\u0006$\u0018\r\\8h'R\fG/[:uS\u000e\u001c\bBBA\u0004\u0013\u0001\u0007A(\u0001\tjg\u0006s\u0017\r\\={K\u000e{G.^7og\u0002")
public class StatisticsSuite
extends StatisticsCollectionTestBase
implements TestHiveSingleton {
    private final boolean enableAutoThreadAudit;
    private final SparkSession spark;
    private final TestHiveContext hiveContext;
    private final HiveClient hiveClient;

    @Override
    public /* synthetic */ void org$apache$spark$sql$hive$test$TestHiveSingleton$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public void afterAll() {
        TestHiveSingleton.afterAll$(this);
    }

    @Override
    public boolean enableAutoThreadAudit() {
        return this.enableAutoThreadAudit;
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public TestHiveContext hiveContext() {
        return this.hiveContext;
    }

    @Override
    public HiveClient hiveClient() {
        return this.hiveClient;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$enableAutoThreadAudit_$eq(boolean x$1) {
        this.enableAutoThreadAudit = x$1;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$hiveContext_$eq(TestHiveContext x$1) {
        this.hiveContext = x$1;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$hiveClient_$eq(HiveClient x$1) {
        this.hiveClient = x$1;
    }

    private void createNonPartitionedTable(String tabName, boolean analyzedBySpark, boolean analyzedByHive) {
        this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(149).append("\n         |CREATE TABLE ").append(tabName).append(" (key STRING, value STRING)\n         |STORED AS TEXTFILE\n         |TBLPROPERTIES ('prop1' = 'val1', 'prop2' = 'val2')\n       ").toString())).stripMargin());
        this.sql().apply((Object)new StringBuilder(36).append("INSERT INTO TABLE ").append(tabName).append(" SELECT * FROM src").toString());
        Object object = analyzedBySpark ? this.sql().apply((Object)new StringBuilder(33).append("ANALYZE TABLE ").append(tabName).append(" COMPUTE STATISTICS").toString()) : BoxedUnit.UNIT;
        Object object2 = analyzedByHive ? this.hiveClient().runSqlHive(new StringBuilder(33).append("ANALYZE TABLE ").append(tabName).append(" COMPUTE STATISTICS").toString()) : BoxedUnit.UNIT;
        Seq describeResult1 = this.hiveClient().runSqlHive(new StringBuilder(19).append("DESCRIBE FORMATTED ").append(tabName).toString());
        scala.collection.immutable.Map tableMetadata = this.getCatalogTable(tabName).properties();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(((IterableLike)new .colon.colon((Object)"COLUMN_STATS_ACCURATE", (List)new .colon.colon((Object)"numFiles", (List)new .colon.colon((Object)"numPartitions", (List)new .colon.colon((Object)"numRows", (List)new .colon.colon((Object)"rawDataSize", (List)new .colon.colon((Object)"totalSize", (List)Nil$.MODULE$))))))).forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)StatisticsSuite.$anonfun$createNonPartitionedTable$1(tableMetadata, x$1))), "scala.collection.Seq.apply[String](\"COLUMN_STATS_ACCURATE\", \"numFiles\", \"numPartitions\", \"numRows\", \"rawDataSize\", \"totalSize\").forall(((x$1: String) => tableMetadata.contains(x$1).unary_!))", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 769));
        if (analyzedByHive) {
            Seq $org_scalatest_assert_macro_left = StringUtils$.MODULE$.filterPattern(describeResult1, "*numRows\\s+500*");
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "nonEmpty", $org_scalatest_assert_macro_left.nonEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 777));
        } else {
            Seq $org_scalatest_assert_macro_left = StringUtils$.MODULE$.filterPattern(describeResult1, "*numRows\\s+500*");
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 779));
        }
    }

    private boolean createNonPartitionedTable$default$2() {
        return true;
    }

    private boolean createNonPartitionedTable$default$3() {
        return true;
    }

    private Option<BigInt> extractStatsPropValues(Seq<String> descOutput, String propKey) {
        None$ none$;
        Seq str = (Seq)((TraversableLike)descOutput.filterNot((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.contains(HiveExternalCatalog$.MODULE$.STATISTICS_PREFIX())))).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.contains(propKey)));
        if (str.isEmpty()) {
            none$ = None$.MODULE$;
        } else {
            String value;
            Seq $org_scalatest_assert_macro_left = str;
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"found more than one matches", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 792));
            Regex pattern = new Regex(new StringBuilder(10).append(propKey).append("\\s+(-?\\d+)").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
            String string = ((String)str.head()).trim();
            Option option = pattern.unapplySeq((CharSequence)string);
            if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(1) != 0) {
                throw new MatchError((Object)string);
            }
            String string2 = value = (String)((LinearSeqOptimized)option.get()).apply(0);
            String value2 = string2;
            none$ = Option$.MODULE$.apply((Object)scala.package$.MODULE$.BigInt().apply(value2));
        }
        return none$;
    }

    private void testAlterTableProperties(String tabName, String alterTablePropCmd) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, false}))).foreach((Function1 & Serializable & scala.Serializable)analyzedBySpark -> {
            this.withTable((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tabName}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Bool bool;
                Bool bool2;
                Bool bool3;
                String x$1 = tabName$2;
                boolean x$2 = true;
                boolean x$3 = analyzedBySpark;
                $this.createNonPartitionedTable(x$1, x$3, x$2);
                $this.checkTableStats(tabName$2, true, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)500)));
                $this.sql().apply((Object)alterTablePropCmd$1);
                Seq describeResult = $this.hiveClient().runSqlHive(new StringBuilder(19).append("DESCRIBE FORMATTED ").append(tabName$2).toString());
                Option<BigInt> totalSize = $this.extractStatsPropValues((Seq<String>)describeResult, "totalSize");
                Bool $org_scalatest_assert_macro_left = Bool$.MODULE$.simpleMacroBool(totalSize.isDefined(), "totalSize.isDefined", Prettifier$.MODULE$.default());
                if ($org_scalatest_assert_macro_left.value()) {
                    BigInt $org_scalatest_assert_macro_left2 = (BigInt)totalSize.get();
                    BigInt $org_scalatest_assert_macro_right = BigInt$.MODULE$.int2bigInt(0);
                    bool3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, ">", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left2.$greater((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                } else {
                    bool3 = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
                }
                Bool $org_scalatest_assert_macro_right = bool3;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "&&", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$amp$amp((Function0 & Serializable & scala.Serializable)() -> $org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"totalSize is lost", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 850));
                Option<BigInt> numRows = $this.extractStatsPropValues((Seq<String>)describeResult, "numRows");
                Bool $org_scalatest_assert_macro_left3 = Bool$.MODULE$.simpleMacroBool(numRows.isDefined(), "numRows.isDefined", Prettifier$.MODULE$.default());
                if ($org_scalatest_assert_macro_left3.value()) {
                    BigInt $org_scalatest_assert_macro_left4 = (BigInt)numRows.get();
                    int $org_scalatest_assert_macro_right2 = 500;
                    bool2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), BoxesRunTime.equalsNumObject((Number)$org_scalatest_assert_macro_left4, (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2)), Prettifier$.MODULE$.default());
                } else {
                    bool2 = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
                }
                Bool $org_scalatest_assert_macro_right3 = bool2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "&&", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$amp$amp((Function0 & Serializable & scala.Serializable)() -> $org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 853));
                Option<BigInt> rawDataSize = $this.extractStatsPropValues((Seq<String>)describeResult, "rawDataSize");
                Bool $org_scalatest_assert_macro_left5 = Bool$.MODULE$.simpleMacroBool(rawDataSize.isDefined(), "rawDataSize.isDefined", Prettifier$.MODULE$.default());
                if ($org_scalatest_assert_macro_left5.value()) {
                    BigInt $org_scalatest_assert_macro_left6 = (BigInt)rawDataSize.get();
                    int $org_scalatest_assert_macro_right4 = 5312;
                    bool = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), BoxesRunTime.equalsNumObject((Number)$org_scalatest_assert_macro_left6, (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4)), Prettifier$.MODULE$.default());
                } else {
                    bool = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
                }
                Bool $org_scalatest_assert_macro_right5 = bool;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "&&", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$amp$amp((Function0 & Serializable & scala.Serializable)() -> $org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 855));
                $this.checkTableStats(tabName$2, true, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)500)));
            });
            return BoxedUnit.UNIT;
        });
    }

    private scala.collection.immutable.Map<String, String> getStatsProperties(String tableName) {
        CatalogTable hTable = this.hiveClient().getTable(this.spark().sessionState().catalog().getCurrentDatabase(), tableName);
        return hTable.properties().filterKeys((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.startsWith(HiveExternalCatalog$.MODULE$.STATISTICS_PREFIX()))).toMap(Predef$.MODULE$.$conforms());
    }

    private void testUpdatingTableStats(String tableDescription, String createTableCmd) {
        this.test(new StringBuilder(32).append("test table-level statistics for ").append(tableDescription).toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String parquetTable = "parquetTable";
            this.withTable((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{parquetTable}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)createTableCmd);
                CatalogTable catalogTable = this.getCatalogTable(parquetTable);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(DDLUtils$.MODULE$.isDatasourceTable(catalogTable), "org.apache.spark.sql.execution.command.DDLUtils.isDatasourceTable(catalogTable)", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1193));
                this.sql().apply((Object)new StringBuilder(51).append("INSERT INTO TABLE ").append(parquetTable).append(" SELECT * FROM src WHERE key < 10").toString());
                this.checkTableStats(parquetTable, false, (Option)None$.MODULE$);
                this.sql().apply((Object)new StringBuilder(40).append("ANALYZE TABLE ").append(parquetTable).append(" COMPUTE STATISTICS noscan").toString());
                Option fetchedStats1 = this.checkTableStats(parquetTable, true, (Option)None$.MODULE$);
                this.sql().apply((Object)new StringBuilder(51).append("INSERT INTO TABLE ").append(parquetTable).append(" SELECT * FROM src WHERE key < 10").toString());
                this.sql().apply((Object)new StringBuilder(40).append("ANALYZE TABLE ").append(parquetTable).append(" COMPUTE STATISTICS noscan").toString());
                Option fetchedStats2 = this.checkTableStats(parquetTable, true, (Option)None$.MODULE$);
                BigInt $org_scalatest_assert_macro_left = ((CatalogStatistics)fetchedStats2.get()).sizeInBytes();
                BigInt $org_scalatest_assert_macro_right = ((CatalogStatistics)fetchedStats1.get()).sizeInBytes();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, ">", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$greater((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1208));
                this.sql().apply((Object)new StringBuilder(33).append("ANALYZE TABLE ").append(parquetTable).append(" COMPUTE STATISTICS").toString());
                Option fetchedStats3 = this.checkTableStats(parquetTable, true, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)20)));
                BigInt $org_scalatest_assert_macro_left2 = ((CatalogStatistics)fetchedStats3.get()).sizeInBytes();
                BigInt $org_scalatest_assert_macro_right2 = ((CatalogStatistics)fetchedStats2.get()).sizeInBytes();
                BigInt bigInt = $org_scalatest_assert_macro_left2;
                BigInt bigInt2 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(bigInt != null ? !bigInt.equals(bigInt2) : bigInt2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1214));
            });
        }, new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1188));
    }

    private Tuple2<CatalogStatistics, CatalogStatistics> getStatsBeforeAfterUpdate(boolean isAnalyzeColumns) {
        String tableName = "tbl";
        ObjectRef statsBeforeUpdate = ObjectRef.create(null);
        ObjectRef statsAfterUpdate = ObjectRef.create(null);
        this.withTable((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tableName}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TableIdentifier tableIndent = new TableIdentifier(tableName, (Option)new Some((Object)"default"));
            HiveSessionCatalog catalog = (HiveSessionCatalog)this.spark().sessionState().catalog();
            this.sql().apply((Object)new StringBuilder(37).append("CREATE TABLE ").append(tableName).append(" (key int) USING PARQUET").toString());
            this.sql().apply((Object)new StringBuilder(21).append("INSERT INTO ").append(tableName).append(" SELECT 1").toString());
            Object object = isAnalyzeColumns ? this.sql().apply((Object)new StringBuilder(49).append("ANALYZE TABLE ").append(tableName).append(" COMPUTE STATISTICS FOR COLUMNS key").toString()) : this.sql().apply((Object)new StringBuilder(33).append("ANALYZE TABLE ").append(tableName).append(" COMPUTE STATISTICS").toString());
            this.spark().table(tableIndent);
            statsBeforeUpdate$1.elem = (CatalogStatistics)((CatalogTable)((LogicalRelation)catalog.metastoreCatalog().getCachedDataSourceTable(tableIndent)).catalogTable().get()).stats().get();
            this.sql().apply((Object)new StringBuilder(21).append("INSERT INTO ").append(tableName).append(" SELECT 2").toString());
            Object object2 = isAnalyzeColumns ? this.sql().apply((Object)new StringBuilder(49).append("ANALYZE TABLE ").append(tableName).append(" COMPUTE STATISTICS FOR COLUMNS key").toString()) : this.sql().apply((Object)new StringBuilder(33).append("ANALYZE TABLE ").append(tableName).append(" COMPUTE STATISTICS").toString());
            this.spark().table(tableIndent);
            statsAfterUpdate$1.elem = (CatalogStatistics)((CatalogTable)((LogicalRelation)catalog.metastoreCatalog().getCachedDataSourceTable(tableIndent)).catalogTable().get()).stats().get();
        });
        return new Tuple2((Object)((CatalogStatistics)statsBeforeUpdate.elem), (Object)((CatalogStatistics)statsAfterUpdate.elem));
    }

    public static final /* synthetic */ void $anonfun$new$3(StatisticsSuite $this, String tbl) {
        $this.sql().apply((Object)new StringBuilder(33).append("ANALYZE TABLE ").append(tbl).append(" COMPUTE STATISTICS").toString());
        CatalogStatistics catalogStats = $this.getTableStats(tbl);
        $this.withSQLConf((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.CBO_ENABLED().key()), (Object)"false")}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Statistics relationStats = $this.spark().table(tbl).queryExecution().optimizedPlan().stats();
            BigInt $org_scalatest_assert_macro_left = relationStats.sizeInBytes();
            BigInt $org_scalatest_assert_macro_right = catalogStats.sizeInBytes();
            BigInt bigInt = $org_scalatest_assert_macro_left;
            BigInt bigInt2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(bigInt != null ? !bigInt.equals(bigInt2) : bigInt2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
            Option $org_scalatest_assert_macro_left2 = relationStats.rowCount();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
        });
        $this.spark().sessionState().catalog().refreshTable(TableIdentifier$.MODULE$.apply(tbl));
        $this.withSQLConf((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.CBO_ENABLED().key()), (Object)"true")}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Statistics relationStats = $this.spark().table(tbl).queryExecution().optimizedPlan().stats();
            BigInt $org_scalatest_assert_macro_left = catalogStats.sizeInBytes();
            BigInt $org_scalatest_assert_macro_right = relationStats.sizeInBytes();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "<", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$less((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
            Option $org_scalatest_assert_macro_left2 = catalogStats.rowCount();
            Option $org_scalatest_assert_macro_right2 = relationStats.rowCount();
            Option option = $org_scalatest_assert_macro_left2;
            Option option2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(option != null ? !option.equals(option2) : option2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
        });
    }

    public static final /* synthetic */ void $anonfun$new$9(StatisticsSuite $this, File tempDir) {
        File file1 = new File(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)tempDir), "/data1"));
        Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> new PrintWriter(file1), (Function1 & Serializable & scala.Serializable)writer -> {
            writer.write("1,2");
            return BoxedUnit.UNIT;
        });
        File file2 = new File(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)tempDir), "/data2"));
        Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> new PrintWriter(file2), (Function1 & Serializable & scala.Serializable)writer -> {
            writer.write("1,2");
            return BoxedUnit.UNIT;
        });
        $this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(342).append("\n               |CREATE EXTERNAL TABLE csv_table(page_id INT, impressions INT)\n               |ROW FORMAT SERDE 'org.apache.hadoop.hive.serde2.OpenCSVSerde'\n               |WITH SERDEPROPERTIES (\n               |\"separatorChar\" = \",\",\n               |\"quoteChar\"     = \"\\\"\",\n               |\"escapeChar\"    = \"\\\\\")\n               |LOCATION '").append(tempDir.toURI()).append("'").toString())).stripMargin());
        HiveTableRelation relation = (HiveTableRelation)$this.spark().table("csv_table").queryExecution().analyzed().children().head();
        scala.collection.immutable.Map properties = relation.tableMeta().ignoredProperties();
        long $org_scalatest_assert_macro_left = new StringOps(Predef$.MODULE$.augmentString((String)properties.apply((Object)"totalSize"))).toLong();
        int $org_scalatest_assert_macro_right = 6;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
        Option $org_scalatest_assert_macro_left2 = properties.get((Object)"rawDataSize");
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
        BigInt sizeInBytes = relation.stats().sizeInBytes();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = $this.convertToEqualizer(sizeInBytes);
        BigInt $org_scalatest_assert_macro_right2 = scala.package$.MODULE$.BigInt().apply(file1.length() + file2.length());
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
    }

    private final BigInt queryTotalSize$1(String tableName) {
        return this.spark().table(tableName).queryExecution().analyzed().stats().sizeInBytes();
    }

    public static final /* synthetic */ void $anonfun$new$34(StatisticsSuite $this, String tableName$2, File path) {
        $this.sql().apply((Object)new StringBuilder(78).append("CREATE TABLE ").append(tableName$2).append(" (key STRING, value STRING) USING hive ").append("PARTITIONED BY (ds STRING)").toString());
        .colon.colon partitionDates = new .colon.colon((Object)"2010-01-01", (List)new .colon.colon((Object)"2010-01-02", (List)new .colon.colon((Object)"2010-01-03", (List)Nil$.MODULE$)));
        partitionDates.foreach((Function1 & Serializable & scala.Serializable)ds -> (Dataset)$this.sql().apply((Object)new StringBuilder(54).append("INSERT INTO TABLE ").append(tableName$2).append(" PARTITION (ds='").append((String)ds).append("') SELECT * FROM src").toString()));
        $this.sql().apply((Object)new StringBuilder(28).append("ALTER TABLE ").append(tableName$2).append(" SET LOCATION '").append(path.toURI()).append("'").toString());
        $this.sql().apply((Object)new StringBuilder(40).append("ANALYZE TABLE ").append(tableName$2).append(" COMPUTE STATISTICS noscan").toString());
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer($this.getTableStats(tableName$2).sizeInBytes());
        BigInt $org_scalatest_assert_macro_right = scala.package$.MODULE$.BigInt().apply(17436);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 314));
    }

    public static final /* synthetic */ void $anonfun$new$38(StatisticsSuite $this, String sourceTableName$1, String tableName$3, File path) {
        $this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(169).append("\n               |CREATE TABLE ").append(sourceTableName$1).append(" (key STRING, value STRING)\n               |USING hive\n               |PARTITIONED BY (ds STRING)\n               |LOCATION '").append(path.toURI()).append("'\n             ").toString())).stripMargin());
        .colon.colon partitionDates = new .colon.colon((Object)"2010-01-01", (List)new .colon.colon((Object)"2010-01-02", (List)new .colon.colon((Object)"2010-01-03", (List)Nil$.MODULE$)));
        partitionDates.foreach((Function1 & Serializable & scala.Serializable)ds -> (Dataset)$this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(113).append("\n                   |INSERT INTO TABLE ").append(sourceTableName$1).append(" PARTITION (ds='").append((String)ds).append("')\n                   |SELECT * FROM src\n                 ").toString())).stripMargin()));
        $this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(169).append("\n               |CREATE TABLE ").append(tableName$3).append(" (key STRING, value STRING)\n               |USING hive\n               |PARTITIONED BY (ds STRING)\n               |LOCATION '").append(path.toURI()).append("'\n             ").toString())).stripMargin());
        String ds2 = (String)partitionDates.head();
        $this.sql().apply((Object)new StringBuilder(34).append("ALTER TABLE ").append(tableName$3).append(" ADD PARTITION (ds='").append(ds2).append("')").toString());
        $this.sql().apply((Object)new StringBuilder(40).append("ANALYZE TABLE ").append(sourceTableName$1).append(" COMPUTE STATISTICS noscan").toString());
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer($this.getTableStats(sourceTableName$1).sizeInBytes());
        BigInt $org_scalatest_assert_macro_right = scala.package$.MODULE$.BigInt().apply(17436);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 357));
        $this.sql().apply((Object)new StringBuilder(40).append("ANALYZE TABLE ").append(tableName$3).append(" COMPUTE STATISTICS noscan").toString());
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer($this.getTableStats(tableName$3).sizeInBytes());
        BigInt $org_scalatest_assert_macro_right2 = scala.package$.MODULE$.BigInt().apply(5812);
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 361));
    }

    private final CatalogStatistics queryStats$1(String ds, String tableName$4) {
        CatalogTablePartition partition = this.spark().sessionState().catalog().getPartition(TableIdentifier$.MODULE$.apply(tableName$4), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ds"), (Object)ds)})));
        return (CatalogStatistics)partition.stats().get();
    }

    private final void createPartition$1(String ds, String query, String tableName$4) {
        this.sql().apply((Object)new StringBuilder(37).append("INSERT INTO TABLE ").append(tableName$4).append(" PARTITION (ds='").append(ds).append("') ").append(query).toString());
    }

    private final Option queryStats$2(String ds, String hr, String tableName$5) {
        TableIdentifier tableId = TableIdentifier$.MODULE$.apply(tableName$5);
        CatalogTablePartition partition = this.spark().sessionState().catalog().getPartition(tableId, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ds"), (Object)ds), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hr"), (Object)hr)})));
        return partition.stats();
    }

    private final void assertPartitionStats$1(String ds, String hr, Option rowCount, BigInt sizeInBytes, String tableName$5) {
        CatalogStatistics stats = (CatalogStatistics)this.queryStats$2(ds, hr, tableName$5).get();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(stats.rowCount());
        Option $org_scalatest_assert_macro_right = rowCount;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 425));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(stats.sizeInBytes());
        BigInt $org_scalatest_assert_macro_right2 = sizeInBytes;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 426));
    }

    private final void createPartition$2(String ds, int hr, String query, String tableName$5) {
        this.sql().apply((Object)new StringBuilder(42).append("INSERT INTO TABLE ").append(tableName$5).append(" PARTITION (ds='").append(ds).append("', hr=").append(hr).append(") ").append(query).toString());
    }

    private final void assertPartitionStats$2(String ds, String hr, Option rowCount, BigInt sizeInBytes, String tableName$6) {
        CatalogStatistics stats = (CatalogStatistics)this.spark().sessionState().catalog().getPartition(TableIdentifier$.MODULE$.apply(tableName$6), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ds"), (Object)ds), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hr"), (Object)hr)}))).stats().get();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(stats.rowCount());
        Option $org_scalatest_assert_macro_right = rowCount;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 474));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(stats.sizeInBytes());
        BigInt $org_scalatest_assert_macro_right2 = sizeInBytes;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 475));
    }

    private final void createPartition$3(String ds, int hr, String query, String tableName$6) {
        this.sql().apply((Object)new StringBuilder(42).append("INSERT INTO TABLE ").append(tableName$6).append(" PARTITION (ds='").append(ds).append("', hr=").append(hr).append(") ").append(query).toString());
    }

    private final void assertAnalysisException$1(String partitionSpec, String tableName$9) {
        String message;
        String $org_scalatest_assert_macro_left = message = ((AnalysisException)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(34).append("ANALYZE TABLE ").append(tableName$9).append(" ").append(partitionSpec).append(" COMPUTE STATISTICS").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 549))).getMessage();
        String $org_scalatest_assert_macro_right = new StringBuilder(180).append("The list of partition columns with values ").append("in partition specification for table '").append(tableName$9.toLowerCase(Locale.ROOT)).append("' in ").append("database 'default' is not a prefix of the list of partition columns defined in ").append("the table schema").toString();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 552));
    }

    private final void assertAnalysisException$2(String analyzeCommand, String errorMessage) {
        String message;
        String $org_scalatest_assert_macro_left = message = ((AnalysisException)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)analyzeCommand), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 587))).getMessage();
        String $org_scalatest_assert_macro_right = errorMessage;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 590));
    }

    public static final /* synthetic */ boolean $anonfun$createNonPartitionedTable$1(scala.collection.immutable.Map tableMetadata$1, String x$1) {
        return !tableMetadata$1.contains((Object)x$1);
    }

    public static final /* synthetic */ void $anonfun$new$86(StatisticsSuite $this, String table$7, boolean autoUpdate$2, File loadPath) {
        File file = new File(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)loadPath), "/data"));
        Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> new PrintWriter(file), (Function1 & Serializable & scala.Serializable)writer -> {
            writer.write("2,xyz");
            return BoxedUnit.UNIT;
        });
        $this.sql().apply((Object)new StringBuilder(31).append("LOAD DATA INPATH '").append(loadPath.toURI().toString()).append("' INTO TABLE ").append(table$7).toString());
        if (autoUpdate$2) {
            Option fetched2 = $this.checkTableStats(table$7, true, (Option)None$.MODULE$);
            BigInt $org_scalatest_assert_macro_left = ((CatalogStatistics)fetched2.get()).sizeInBytes();
            BigInt $org_scalatest_assert_macro_right = BigInt$.MODULE$.int2bigInt(0);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, ">", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$greater((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 929));
            scala.collection.immutable.Map $org_scalatest_assert_macro_left2 = ((CatalogStatistics)fetched2.get()).colStats();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 930));
            scala.collection.immutable.Map<String, String> statsProp = $this.getStatsProperties(table$7);
            long $org_scalatest_assert_macro_left3 = new StringOps(Predef$.MODULE$.augmentString((String)statsProp.apply((Object)HiveExternalCatalog$.MODULE$.STATISTICS_TOTAL_SIZE()))).toLong();
            BigInt $org_scalatest_assert_macro_right2 = ((CatalogStatistics)fetched2.get()).sizeInBytes();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left3), "==", (Object)$org_scalatest_assert_macro_right2, BoxesRunTime.equals((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left3), (Object)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 932));
        } else {
            scala.collection.immutable.Map<String, String> $org_scalatest_assert_macro_left = $this.getStatsProperties(table$7);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 934));
        }
    }

    public static final /* synthetic */ void $anonfun$new$93(StatisticsSuite $this, String table$8, String ds) {
        ((IterableLike)new .colon.colon((Object)"11", (List)new .colon.colon((Object)"12", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)hr -> (Dataset)$this.sql().apply((Object)new StringBuilder(61).append("INSERT OVERWRITE TABLE ").append(table$8).append(" PARTITION (ds='").append(ds).append("',hr='").append((String)hr).append("') SELECT 1, 'a'").toString()));
    }

    public static final /* synthetic */ void $anonfun$new$95(StatisticsSuite $this, String table$8, boolean autoUpdate$3, Option fetched1$1, Seq x0$1) {
        BoxedUnit boxedUnit;
        Seq seq = x0$1;
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
            Assertion assertion;
            File dir1 = (File)((SeqLike)some.get()).apply(0);
            File dir2 = (File)((SeqLike)some.get()).apply(1);
            File partDir1 = new File(new File(dir1, "ds=2008-04-09"), "hr=11");
            File file1 = new File(partDir1, "data");
            file1.getParentFile().mkdirs();
            Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> new PrintWriter(file1), (Function1 & Serializable & scala.Serializable)writer -> {
                writer.write("1,a");
                return BoxedUnit.UNIT;
            });
            File partDir2 = new File(new File(dir2, "ds=2008-04-09"), "hr=12");
            File file2 = new File(partDir2, "data");
            file2.getParentFile().mkdirs();
            Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> new PrintWriter(file2), (Function1 & Serializable & scala.Serializable)writer -> {
                writer.write("1,a");
                return BoxedUnit.UNIT;
            });
            $this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(182).append("\n                 |ALTER TABLE ").append(table$8).append(" ADD\n                 |PARTITION (ds='2008-04-09', hr='11') LOCATION '").append(partDir1.toURI().toString()).append("'\n                 |PARTITION (ds='2008-04-09', hr='12') LOCATION '").append(partDir1.toURI().toString()).append("'\n            ").toString())).stripMargin());
            if (autoUpdate$3) {
                Option fetched2 = $this.checkTableStats(table$8, true, (Option)None$.MODULE$);
                BigInt $org_scalatest_assert_macro_left = ((CatalogStatistics)fetched2.get()).sizeInBytes();
                BigInt $org_scalatest_assert_macro_right = ((CatalogStatistics)fetched1$1.get()).sizeInBytes();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, ">", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$greater((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 983));
                scala.collection.immutable.Map $org_scalatest_assert_macro_left2 = ((CatalogStatistics)fetched2.get()).colStats();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 984));
                scala.collection.immutable.Map<String, String> statsProp = $this.getStatsProperties(table$8);
                long $org_scalatest_assert_macro_left3 = new StringOps(Predef$.MODULE$.augmentString((String)statsProp.apply((Object)HiveExternalCatalog$.MODULE$.STATISTICS_TOTAL_SIZE()))).toLong();
                BigInt $org_scalatest_assert_macro_right2 = ((CatalogStatistics)fetched2.get()).sizeInBytes();
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left3), "==", (Object)$org_scalatest_assert_macro_right2, BoxesRunTime.equals((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left3), (Object)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 986));
            } else {
                scala.collection.immutable.Map<String, String> $org_scalatest_assert_macro_left = $this.getStatsProperties(table$8);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
                assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 988));
            }
            $this.sql().apply((Object)new StringBuilder(50).append("ANALYZE TABLE ").append(table$8).append(" COMPUTE STATISTICS FOR COLUMNS i, j").toString());
            Option fetched3 = $this.checkTableStats(table$8, true, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)4)));
            BigInt $org_scalatest_assert_macro_left = ((CatalogStatistics)fetched3.get()).sizeInBytes();
            BigInt $org_scalatest_assert_macro_right = BigInt$.MODULE$.int2bigInt(0);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, ">", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$greater((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 995));
            scala.collection.immutable.Map $org_scalatest_assert_macro_left4 = ((CatalogStatistics)fetched3.get()).colStats();
            int $org_scalatest_assert_macro_right3 = 2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 996));
            $this.sql().apply((Object)new StringBuilder(66).append("ALTER TABLE ").append(table$8).append(" DROP PARTITION (ds='2008-04-08'), PARTITION (hr='12')").toString());
            Set $org_scalatest_assert_macro_left5 = ((TraversableOnce)$this.spark().sessionState().catalog().listPartitions(TableIdentifier$.MODULE$.apply(table$8), $this.spark().sessionState().catalog().listPartitions$default$2()).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.spec(), Seq$.MODULE$.canBuildFrom())).toSet();
            Set $org_scalatest_assert_macro_right4 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.collection.immutable.Map[]{(scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ds"), (Object)"2008-04-09"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hr"), (Object)"11")}))}));
            Set set = $org_scalatest_assert_macro_left5;
            Set set2 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right4, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1000));
            if (autoUpdate$3) {
                Option fetched4 = $this.checkTableStats(table$8, true, (Option)None$.MODULE$);
                BigInt $org_scalatest_assert_macro_left6 = ((CatalogStatistics)fetched4.get()).sizeInBytes();
                BigInt $org_scalatest_assert_macro_right5 = ((CatalogStatistics)fetched1$1.get()).sizeInBytes();
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "<", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left6.$less((Object)$org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1005));
                scala.collection.immutable.Map $org_scalatest_assert_macro_left7 = ((CatalogStatistics)fetched4.get()).colStats();
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left7, "isEmpty", $org_scalatest_assert_macro_left7.isEmpty(), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1006));
                scala.collection.immutable.Map<String, String> statsProp = $this.getStatsProperties(table$8);
                long $org_scalatest_assert_macro_left8 = new StringOps(Predef$.MODULE$.augmentString((String)statsProp.apply((Object)HiveExternalCatalog$.MODULE$.STATISTICS_TOTAL_SIZE()))).toLong();
                BigInt $org_scalatest_assert_macro_right6 = ((CatalogStatistics)fetched4.get()).sizeInBytes();
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left8), "==", (Object)$org_scalatest_assert_macro_right6, BoxesRunTime.equals((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left8), (Object)$org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1008));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                scala.collection.immutable.Map<String, String> $org_scalatest_assert_macro_left9 = $this.getStatsProperties(table$8);
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left9, "isEmpty", $org_scalatest_assert_macro_left9.isEmpty(), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1010));
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)seq);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ void $anonfun$new$103(StatisticsSuite $this, String managedTable$1, String ds) {
        ((IterableLike)new .colon.colon((Object)"11", (List)new .colon.colon((Object)"12", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)hr -> (Dataset)$this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(116).append("\n             |INSERT OVERWRITE TABLE ").append(managedTable$1).append("\n             |partition (ds='").append(ds).append("',hr='").append((String)hr).append("')\n             |SELECT 1, 'a'\n           ").toString())).stripMargin()));
    }

    public static final /* synthetic */ void $anonfun$new$107(StatisticsSuite $this, String format) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, false}))).foreach((Function1 & Serializable & scala.Serializable)isConverted -> {
            $this.withSQLConf((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveUtils$.MODULE$.CONVERT_METASTORE_ORC().key()), (Object)String.valueOf(BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)isConverted)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveUtils$.MODULE$.CONVERT_METASTORE_PARQUET().key()), (Object)String.valueOf(BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)isConverted))))}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.withTable((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{format}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(51).append("CREATE TABLE ").append(format$1).append(" (key STRING, value STRING) STORED AS ").append(format$1).toString());
                $this.sql().apply((Object)new StringBuilder(36).append("INSERT INTO TABLE ").append(format$1).append(" SELECT * FROM src").toString());
                $this.checkTableStats(format$1, !isConverted, (Option)None$.MODULE$);
                $this.sql().apply((Object)new StringBuilder(33).append("ANALYZE TABLE ").append(format$1).append(" COMPUTE STATISTICS").toString());
                $this.checkTableStats(format$1, true, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)500)));
            }));
            return BoxedUnit.UNIT;
        });
    }

    private final void checkColStatsProps$1(scala.collection.immutable.Map expected, String tableName$11) {
        scala.collection.immutable.Map props;
        this.sql().apply((Object)new StringBuilder(46).append("ANALYZE TABLE ").append(tableName$11).append(" COMPUTE STATISTICS FOR COLUMNS ").append(this.stats().keys().mkString(", ")).toString());
        CatalogTable table = this.hiveClient().getTable("default", tableName$11);
        scala.collection.immutable.Map $org_scalatest_assert_macro_left = props = table.properties().filterKeys((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.startsWith("spark.sql.statistics.colStats"))).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map $org_scalatest_assert_macro_right = expected;
        scala.collection.immutable.Map map = $org_scalatest_assert_macro_left;
        scala.collection.immutable.Map map2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(map != null ? !map.equals(map2) : map2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1101));
    }

    public static final /* synthetic */ Object $anonfun$new$118(HistogramBin[] bins$1, int i) {
        BoxedUnit boxedUnit;
        HistogramBin b = bins$1[i];
        double $org_scalatest_assert_macro_left = b.lo();
        double $org_scalatest_assert_macro_right = b.hi();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "<=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left <= $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1147));
        if (i > 0) {
            HistogramBin pre = bins$1[i - 1];
            double $org_scalatest_assert_macro_left2 = pre.hi();
            double $org_scalatest_assert_macro_right2 = b.lo();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left2), "<=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 <= $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            boxedUnit = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1150));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return boxedUnit;
    }

    private static final void checkBinsOrder$1(HistogramBin[] bins) {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])bins)).indices().foreach((Function1 & Serializable & scala.Serializable)i -> StatisticsSuite.$anonfun$new$118(bins, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ Tuple2 $anonfun$new$119(long startTimestamp$1, int i) {
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)i), (Object)DateTimeUtils$.MODULE$.toJavaTimestamp(startTimestamp$1 + (long)i));
    }

    private final void mkTest$1(Function0 before, Function0 after, String query, Seq expectedAnswer, ClassTag ct) {
        Bool bool;
        Bool bool2;
        before.apply$mcV$sp();
        ObjectRef df = ObjectRef.create((Object)((Dataset)this.sql().apply((Object)query)));
        Seq sizes = ((Dataset)df.elem).queryExecution().analyzed().collect((PartialFunction)new scala.Serializable(null, ct){
            public static final long serialVersionUID = 0L;
            private final ClassTag ct$1;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = this.ct$1.runtimeClass().isAssignableFrom(A1.getClass()) ? A1.stats().sizeInBytes() : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan = x1;
                boolean bl = this.ct$1.runtimeClass().isAssignableFrom(logicalPlan.getClass());
                return bl;
            }
            {
                this.ct$1 = ct$1;
            }
        });
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)sizes.size()));
        int $org_scalatest_assert_macro_right = 2;
        Bool $org_scalatest_assert_macro_left2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        if ($org_scalatest_assert_macro_left2.value()) {
            BigInt $org_scalatest_assert_macro_left3 = (BigInt)sizes.apply(0);
            BigInt $org_scalatest_assert_macro_right2 = BigInt$.MODULE$.long2bigInt(this.spark().sessionState().conf().autoBroadcastJoinThreshold());
            bool2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "<=", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left3.$less$eq((Object)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
        } else {
            bool2 = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
        }
        Bool $org_scalatest_assert_macro_right3 = bool2;
        Bool $org_scalatest_assert_macro_left4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "&&", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left2.$amp$amp((Function0 & Serializable & scala.Serializable)() -> $org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
        if ($org_scalatest_assert_macro_left4.value()) {
            BigInt $org_scalatest_assert_macro_left5 = (BigInt)sizes.apply(1);
            BigInt $org_scalatest_assert_macro_right4 = BigInt$.MODULE$.long2bigInt(this.spark().sessionState().conf().autoBroadcastJoinThreshold());
            bool = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "<=", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left5.$less$eq((Object)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
        } else {
            bool = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
        }
        Bool $org_scalatest_assert_macro_right5 = bool;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "&&", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left4.$amp$amp((Function0 & Serializable & scala.Serializable)() -> $org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"query should contain two relations, each of which has size smaller than autoConvertSize", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1296));
        Seq bhj = ((Dataset)df.elem).queryExecution().sparkPlan().collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                BroadcastHashJoinExec broadcastHashJoinExec;
                A1 A1 = x2;
                Object object = A1 instanceof BroadcastHashJoinExec ? (broadcastHashJoinExec = (BroadcastHashJoinExec)A1) : function1.apply(x2);
                return (B1)object;
            }

            public final boolean isDefinedAt(SparkPlan x2) {
                SparkPlan sparkPlan = x2;
                boolean bl = sparkPlan instanceof BroadcastHashJoinExec;
                return bl;
            }
        });
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)bhj.size()));
        int $org_scalatest_assert_macro_right6 = 1;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)new StringBuilder(50).append("actual query plans do not contain broadcast join: ").append(((Dataset)df.elem).queryExecution()).toString(), Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1303));
        this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)df$4.elem, expectedAnswer);
        Map map = this.spark().sessionState().conf().settings();
        synchronized (map) {
            long tmp = this.spark().sessionState().conf().autoBroadcastJoinThreshold();
            this.sql().apply((Object)new StringBuilder(7).append("SET ").append(SQLConf$.MODULE$.AUTO_BROADCASTJOIN_THRESHOLD().key()).append("=-1").toString());
            df.elem = (Dataset)this.sql().apply((Object)query);
            Seq $org_scalatest_assert_macro_left7 = bhj = ((Dataset)df.elem).queryExecution().sparkPlan().collect((PartialFunction)new scala.Serializable(null){
                public static final long serialVersionUID = 0L;

                public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                    BroadcastHashJoinExec broadcastHashJoinExec;
                    A1 A1 = x3;
                    Object object = A1 instanceof BroadcastHashJoinExec ? (broadcastHashJoinExec = (BroadcastHashJoinExec)A1) : function1.apply(x3);
                    return (B1)object;
                }

                public final boolean isDefinedAt(SparkPlan x3) {
                    SparkPlan sparkPlan = x3;
                    boolean bl = sparkPlan instanceof BroadcastHashJoinExec;
                    return bl;
                }
            });
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left7, "isEmpty", $org_scalatest_assert_macro_left7.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"BroadcastHashJoin still planned even though it is switched off", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1314));
            Seq shj = ((Dataset)df.elem).queryExecution().sparkPlan().collect((PartialFunction)new scala.Serializable(null){
                public static final long serialVersionUID = 0L;

                public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                    SortMergeJoinExec sortMergeJoinExec;
                    A1 A1 = x4;
                    Object object = A1 instanceof SortMergeJoinExec ? (sortMergeJoinExec = (SortMergeJoinExec)A1) : function1.apply(x4);
                    return (B1)object;
                }

                public final boolean isDefinedAt(SparkPlan x4) {
                    SparkPlan sparkPlan = x4;
                    boolean bl = sparkPlan instanceof SortMergeJoinExec;
                    return bl;
                }
            });
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)shj.size()));
            int $org_scalatest_assert_macro_right7 = 1;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"SortMergeJoin should be planned when BroadcastHashJoin is turned off", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1317));
            Dataset cfr_ignored_0 = (Dataset)this.sql().apply((Object)new StringBuilder(5).append("SET ").append(SQLConf$.MODULE$.AUTO_BROADCASTJOIN_THRESHOLD().key()).append("=").append(tmp).toString());
        }
        after.apply$mcV$sp();
    }

    public static final /* synthetic */ void $anonfun$new$140(StatisticsSuite $this, String tableName$15, boolean isConverted) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{false, true}))).foreach((Function1 & Serializable & scala.Serializable)updateEnabled -> {
            $this.withSQLConf((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.AUTO_SIZE_UPDATE_ENABLED().key()), (Object)Boolean.toString(BoxesRunTime.unboxToBoolean((Object)updateEnabled))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveUtils$.MODULE$.CONVERT_METASTORE_PARQUET().key()), (Object)Boolean.toString(isConverted))}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.withTable((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tableName$15}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(50).append("CREATE TABLE ").append(tableName$15).append(" STORED AS parquet AS SELECT 'a', 'b'").toString());
                CatalogTable catalogTable = $this.getCatalogTable(tableName$15);
                if (!isConverted$2 || updateEnabled) {
                    Option $org_scalatest_assert_macro_left = catalogTable.stats();
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "nonEmpty", $org_scalatest_assert_macro_left.nonEmpty(), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1415));
                } else {
                    Option $org_scalatest_assert_macro_left = catalogTable.stats();
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1417));
                }
            }));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$153(StatisticsSuite $this, File dir) {
        File tableDir = new File(dir, "table");
        File partitionDir = new File(dir, "partition");
        $this.withTable((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"spark_28876"}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(179).append("\n                 |CREATE TABLE spark_28876(id bigint)\n                 |PARTITIONED BY (ds STRING)\n                 |STORED AS PARQUET\n                 |LOCATION '").append(tableDir.toURI()).append("'\n             ").toString())).stripMargin());
            $this.spark().range(5L).write().mode(SaveMode.Overwrite).parquet(partitionDir.getCanonicalPath());
            $this.sql().apply((Object)new StringBuilder(59).append("ALTER TABLE spark_28876 ADD PARTITION (ds='p1') LOCATION '").append(partitionDir).append("'").toString());
            Option $org_scalatest_assert_macro_left = $this.getCatalogTable("spark_28876").stats();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1476));
            BigInt sizeInBytes = ((HiveTableRelation)$this.spark().table("spark_28876").queryExecution().analyzed().children().head()).stats().sizeInBytes();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(sizeInBytes);
            long $org_scalatest_assert_macro_right = $this.conf().defaultSizeInBytes();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1479));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = $this.convertToEqualizer(BoxesRunTime.boxToLong((long)$this.spark().table("spark_28876").count()));
            int $org_scalatest_assert_macro_right2 = 5;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1480));
        });
    }

    public StatisticsSuite() {
        TestHiveSingleton.$init$(this);
        this.test("size estimation for relations is based on row size * number of rows", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String dsTbl = "rel_est_ds_table";
            String hiveTbl = "rel_est_hive_table";
            this.withTable((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{dsTbl, hiveTbl}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.spark().range(1000L).write().format("parquet").saveAsTable(dsTbl);
                this.spark().range(1000L).write().format("hive").saveAsTable(hiveTbl);
                ((IterableLike)new .colon.colon((Object)dsTbl, (List)new .colon.colon((Object)hiveTbl, (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)tbl -> {
                    StatisticsSuite.$anonfun$new$3(this, tbl);
                    return BoxedUnit.UNIT;
                });
            });
        }, new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 48));
        this.test("Hive serde tables should fallback to HDFS for size estimation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ENABLE_FALL_BACK_TO_HDFS_FOR_STATS().key()), (Object)"true")}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"csv_table"}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1 & Serializable & scala.Serializable)tempDir -> {
            StatisticsSuite.$anonfun$new$9(this, tempDir);
            return BoxedUnit.UNIT;
        }))), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
        this.test("Hive serde table with incorrect statistics", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1 & Serializable & scala.Serializable)tempDir -> {
            this.withTable((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1"}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.spark().range(5L).write().mode(SaveMode.Overwrite).parquet(tempDir.getCanonicalPath());
                long dataSize = $this.getDataSize(tempDir);
                $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(554).append("\n             |CREATE EXTERNAL TABLE t1(id BIGINT)\n             |ROW FORMAT SERDE 'org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe'\n             |STORED AS\n             |  INPUTFORMAT 'org.apache.hadoop.hive.ql.io.parquet.MapredParquetInputFormat'\n             |  OUTPUTFORMAT 'org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat'\n             |LOCATION '").append(tempDir.getCanonicalPath()).append("'\n             |TBLPROPERTIES (\n             |'rawDataSize'='-1', 'numFiles'='0', 'totalSize'='0',\n             |'COLUMN_STATS_ACCURATE'='false', 'numRows'='-1'\n             |)").toString())).stripMargin());
                $this.spark().sql("REFRESH TABLE t1");
                LogicalPlan relation1 = (LogicalPlan)$this.spark().table("t1").queryExecution().analyzed().children().head();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(relation1.stats().sizeInBytes());
                long $org_scalatest_assert_macro_right = dataSize;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
                $this.spark().sql("REFRESH TABLE t1");
                $this.withSQLConf((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ENABLE_FALL_BACK_TO_HDFS_FOR_STATS().key()), (Object)"true")}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    LogicalPlan relation2 = (LogicalPlan)$this.spark().table("t1").queryExecution().analyzed().children().head();
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(relation2.stats().sizeInBytes());
                    long $org_scalatest_assert_macro_right = dataSize;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143));
                });
            });
            return BoxedUnit.UNIT;
        }), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
        this.test("analyze Hive serde tables", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String nonPartTable = "non_part_table";
            this.withTable((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{nonPartTable}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(51).append("CREATE TABLE ").append(nonPartTable).append(" (key STRING, value STRING) USING hive").toString());
                this.sql().apply((Object)new StringBuilder(36).append("INSERT INTO TABLE ").append(nonPartTable).append(" SELECT * FROM src").toString());
                this.sql().apply((Object)new StringBuilder(36).append("INSERT INTO TABLE ").append(nonPartTable).append(" SELECT * FROM src").toString());
                this.sql().apply((Object)new StringBuilder(40).append("ANALYZE TABLE ").append(nonPartTable).append(" COMPUTE STATISTICS noscan").toString());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.queryTotalSize$1(nonPartTable));
                BigInt $org_scalatest_assert_macro_right = scala.package$.MODULE$.BigInt().apply(11624);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
            });
            String partTable = "part_table";
            this.withTable((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{partTable}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(78).append("CREATE TABLE ").append(partTable).append(" (key STRING, value STRING) USING hive ").append("PARTITIONED BY (ds STRING)").toString());
                this.sql().apply((Object)new StringBuilder(64).append("INSERT INTO TABLE ").append(partTable).append(" PARTITION (ds='2010-01-01') SELECT * FROM src").toString());
                this.sql().apply((Object)new StringBuilder(64).append("INSERT INTO TABLE ").append(partTable).append(" PARTITION (ds='2010-01-02') SELECT * FROM src").toString());
                this.sql().apply((Object)new StringBuilder(64).append("INSERT INTO TABLE ").append(partTable).append(" PARTITION (ds='2010-01-03') SELECT * FROM src").toString());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.queryTotalSize$1(partTable));
                long $org_scalatest_assert_macro_right = this.spark().sessionState().conf().defaultSizeInBytes();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 174));
                this.sql().apply((Object)new StringBuilder(40).append("ANALYZE TABLE ").append(partTable).append(" COMPUTE STATISTICS noscan").toString());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(this.queryTotalSize$1(partTable));
                BigInt $org_scalatest_assert_macro_right2 = scala.package$.MODULE$.BigInt().apply(17436);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 178));
            });
            this.withView((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tempTable"}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                ((Dataset)this.sql().apply((Object)"SELECT * FROM src")).createOrReplaceTempView("tempTable");
                this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"ANALYZE TABLE tempTable COMPUTE STATISTICS"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 184));
            });
        }, new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149));
        this.test("SPARK-24626 parallel file listing in Stats computation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PARALLEL_PARTITION_DISCOVERY_THRESHOLD().key()), (Object)"2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PARALLEL_FILE_LISTING_IN_STATS_COMPUTATION().key()), (Object)"True")}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String checkSizeTable = "checkSizeTable";
            this.withTable((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{checkSizeTable}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(78).append("CREATE TABLE ").append(checkSizeTable).append(" (key STRING, value STRING) USING hive ").append("PARTITIONED BY (ds STRING)").toString());
                this.sql().apply((Object)new StringBuilder(64).append("INSERT INTO TABLE ").append(checkSizeTable).append(" PARTITION (ds='2010-01-01') SELECT * FROM src").toString());
                this.sql().apply((Object)new StringBuilder(64).append("INSERT INTO TABLE ").append(checkSizeTable).append(" PARTITION (ds='2010-01-02') SELECT * FROM src").toString());
                this.sql().apply((Object)new StringBuilder(64).append("INSERT INTO TABLE ").append(checkSizeTable).append(" PARTITION (ds='2010-01-03') SELECT * FROM src").toString());
                CatalogTable tableMeta = this.spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply(checkSizeTable));
                HiveCatalogMetrics$.MODULE$.reset();
                long $org_scalatest_assert_macro_left = HiveCatalogMetrics$.MODULE$.METRIC_PARALLEL_LISTING_JOB_COUNT().getCount();
                int $org_scalatest_assert_macro_right = 0;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 203));
                BigInt size = CommandUtils$.MODULE$.calculateTotalSize(this.spark(), tableMeta);
                long $org_scalatest_assert_macro_left2 = HiveCatalogMetrics$.MODULE$.METRIC_PARALLEL_LISTING_JOB_COUNT().getCount();
                int $org_scalatest_assert_macro_right2 = 1;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == (long)$org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 205));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(size);
                BigInt $org_scalatest_assert_macro_right3 = scala.package$.MODULE$.BigInt().apply(17436);
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 206));
            });
        }), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 190));
        this.test("analyze non hive compatible datasource tables", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String table = "parquet_tab";
            this.withTable((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{table}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(117).append("\n          |CREATE TABLE ").append(table).append(" (a int, b int)\n          |USING parquet\n          |OPTIONS (skipHiveMetadata true)\n        ").toString())).stripMargin());
                StructType rawSchema = this.hiveClient().getTable("default", table).schema();
                Metadata metadata = new MetadataBuilder().putString("comment", "from deserializer").build();
                StructType expectedRawSchema = new StructType().add("col", "array<string>", true, metadata);
                StructType $org_scalatest_assert_macro_left = rawSchema;
                StructType $org_scalatest_assert_macro_right = expectedRawSchema;
                StructType structType = $org_scalatest_assert_macro_left;
                StructType structType2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 226));
                StructType actualSchema = this.spark().sharedState().externalCatalog().getTable("default", table).schema();
                StructType expectedActualSchema = new StructType().add("a", "int").add("b", "int");
                StructType $org_scalatest_assert_macro_left2 = actualSchema;
                StructType $org_scalatest_assert_macro_right2 = expectedActualSchema;
                StructType structType3 = $org_scalatest_assert_macro_left2;
                StructType structType4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType3 != null ? !structType3.equals(structType4) : structType4 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 232));
                this.sql().apply((Object)new StringBuilder(26).append("INSERT INTO ").append(table).append(" VALUES (1, 1)").toString());
                this.sql().apply((Object)new StringBuilder(26).append("INSERT INTO ").append(table).append(" VALUES (2, 1)").toString());
                this.sql().apply((Object)new StringBuilder(50).append("ANALYZE TABLE ").append(table).append(" COMPUTE STATISTICS FOR COLUMNS a, b").toString());
                Option fetchedStats0 = this.checkTableStats(table, true, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)2)));
                scala.collection.immutable.Map $org_scalatest_assert_macro_left3 = ((CatalogStatistics)fetchedStats0.get()).colStats();
                scala.collection.immutable.Map $org_scalatest_assert_macro_right3 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)new CatalogColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(2)), (Option)new Some((Object)"1"), (Option)new Some((Object)"2"), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), CatalogColumnStat$.MODULE$.apply$default$7(), CatalogColumnStat$.MODULE$.apply$default$8())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)new CatalogColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(1)), (Option)new Some((Object)"1"), (Option)new Some((Object)"1"), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), CatalogColumnStat$.MODULE$.apply$default$7(), CatalogColumnStat$.MODULE$.apply$default$8()))}));
                scala.collection.immutable.Map map = $org_scalatest_assert_macro_left3;
                scala.collection.immutable.Map map2 = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(map != null ? !map.equals(map2) : map2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 239));
            });
        }, new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 211));
        this.test("Analyze hive serde tables when schema is not same as schema in table properties", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String table = "hive_serde";
            this.withTable((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{table}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(44).append("CREATE TABLE ").append(table).append(" (C1 INT, C2 STRING, C3 DOUBLE)").toString());
                StructType rawSchema = this.hiveClient().getTable("default", table).schema();
                StructType expectedRawSchema = new StructType().add("c1", "int").add("c2", "string").add("c3", "double");
                StructType $org_scalatest_assert_macro_left = rawSchema;
                StructType $org_scalatest_assert_macro_right = expectedRawSchema;
                StructType structType = $org_scalatest_assert_macro_left;
                StructType structType2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 257));
                StructType actualSchema = this.spark().sharedState().externalCatalog().getTable("default", table).schema();
                StructType expectedActualSchema = new StructType().add("C1", "int").add("C2", "string").add("C3", "double");
                StructType $org_scalatest_assert_macro_left2 = actualSchema;
                StructType $org_scalatest_assert_macro_right2 = expectedActualSchema;
                StructType structType3 = $org_scalatest_assert_macro_left2;
                StructType structType4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType3 != null ? !structType3.equals(structType4) : structType4 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 264));
                this.sql().apply((Object)new StringBuilder(38).append("INSERT INTO TABLE ").append(table).append(" SELECT 1, 'a', 10.0").toString());
                this.sql().apply((Object)new StringBuilder(48).append("ANALYZE TABLE ").append(table).append(" COMPUTE STATISTICS FOR COLUMNS C1").toString());
                CatalogStatistics fetchedStats1 = (CatalogStatistics)this.checkTableStats(table, true, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)1))).get();
                scala.collection.immutable.Map $org_scalatest_assert_macro_left3 = fetchedStats1.colStats();
                scala.collection.immutable.Map $org_scalatest_assert_macro_right3 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C1"), (Object)new CatalogColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(1)), (Option)new Some((Object)"1"), (Option)new Some((Object)"1"), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), CatalogColumnStat$.MODULE$.apply$default$7(), CatalogColumnStat$.MODULE$.apply$default$8()))}));
                scala.collection.immutable.Map map = $org_scalatest_assert_macro_left3;
                scala.collection.immutable.Map map2 = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(map != null ? !map.equals(map2) : map2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 270));
            });
        }, new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 245));
        this.test("SPARK-22745 - read Hive's statistics for partition", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String tableName = "hive_stats_part_table";
            this.withTable((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tableName}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(78).append("CREATE TABLE ").append(tableName).append(" (key STRING, value STRING) USING hive ").append("PARTITIONED BY (ds STRING)").toString());
                this.sql().apply((Object)new StringBuilder(64).append("INSERT INTO TABLE ").append(tableName).append(" PARTITION (ds='2017-01-01') SELECT * FROM src").toString());
                CatalogTablePartition partition = this.spark().sessionState().catalog().getPartition(TableIdentifier$.MODULE$.apply(tableName), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ds"), (Object)"2017-01-01")})));
                BigInt $org_scalatest_assert_macro_left = ((CatalogStatistics)partition.stats().get()).sizeInBytes();
                int $org_scalatest_assert_macro_right = 5812;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), BoxesRunTime.equalsNumObject((Number)$org_scalatest_assert_macro_left, (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 285));
                Option $org_scalatest_assert_macro_left2 = ((CatalogStatistics)partition.stats().get()).rowCount();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 286));
                this.hiveClient().runSqlHive(new StringBuilder(61).append("ANALYZE TABLE ").append(tableName).append(" PARTITION (ds='2017-01-01') COMPUTE STATISTICS").toString());
                partition = this.spark().sessionState().catalog().getPartition(TableIdentifier$.MODULE$.apply(tableName), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ds"), (Object)"2017-01-01")})));
                BigInt $org_scalatest_assert_macro_left3 = ((CatalogStatistics)partition.stats().get()).sizeInBytes();
                int $org_scalatest_assert_macro_right2 = 5812;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), BoxesRunTime.equalsNumObject((Number)$org_scalatest_assert_macro_left3, (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2)), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 293));
                Option $org_scalatest_assert_macro_left4 = ((CatalogStatistics)partition.stats().get()).rowCount();
                Some $org_scalatest_assert_macro_right3 = new Some((Object)BoxesRunTime.boxToInteger((int)500));
                Option option = $org_scalatest_assert_macro_left4;
                Some some = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right3, !(option != null ? !option.equals(some) : some != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 294));
            });
        }, new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 276));
        this.test("SPARK-21079 - analyze table with location different than that of individual partitions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String tableName = "analyzeTable_part";
            this.withTable((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tableName}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempPath((Function1 & Serializable & scala.Serializable)path -> {
                StatisticsSuite.$anonfun$new$34(this, tableName, path);
                return BoxedUnit.UNIT;
            }));
        }, new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 298));
        this.test("SPARK-21079 - analyze partitioned table with only a subset of partitions visible", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String sourceTableName = "analyzeTable_part";
            String tableName = "analyzeTable_part_vis";
            this.withTable((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{sourceTableName, tableName}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempPath((Function1 & Serializable & scala.Serializable)path -> {
                StatisticsSuite.$anonfun$new$38(this, sourceTableName, tableName, path);
                return BoxedUnit.UNIT;
            }));
        }, new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 319));
        this.test("analyze single partition", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String tableName = "analyzeTable_part";
            this.withTable((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tableName}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(78).append("CREATE TABLE ").append(tableName).append(" (key STRING, value STRING) USING hive ").append("PARTITIONED BY (ds STRING)").toString());
                this.createPartition$1("2010-01-01", "SELECT '1', 'A' from src", tableName);
                this.createPartition$1("2010-01-02", "SELECT '1', 'A' from src UNION ALL SELECT '1', 'A' from src", tableName);
                this.createPartition$1("2010-01-03", "SELECT '1', 'A' from src", tableName);
                this.sql().apply((Object)new StringBuilder(68).append("ANALYZE TABLE ").append(tableName).append(" PARTITION (ds='2010-01-01') COMPUTE STATISTICS NOSCAN").toString());
                this.sql().apply((Object)new StringBuilder(68).append("ANALYZE TABLE ").append(tableName).append(" PARTITION (ds='2010-01-02') COMPUTE STATISTICS NOSCAN").toString());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.queryStats$1("2010-01-01", tableName).rowCount());
                None$ $org_scalatest_assert_macro_right = None$.MODULE$;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 391));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(this.queryStats$1("2010-01-01", tableName).sizeInBytes());
                int $org_scalatest_assert_macro_right2 = 2000;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 392));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(this.queryStats$1("2010-01-02", tableName).rowCount());
                None$ $org_scalatest_assert_macro_right3 = None$.MODULE$;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 394));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(this.queryStats$1("2010-01-02", tableName).sizeInBytes());
                int $org_scalatest_assert_macro_right4 = 4000;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 395));
                this.sql().apply((Object)new StringBuilder(61).append("ANALYZE TABLE ").append(tableName).append(" PARTITION (ds='2010-01-01') COMPUTE STATISTICS").toString());
                this.sql().apply((Object)new StringBuilder(61).append("ANALYZE TABLE ").append(tableName).append(" PARTITION (ds='2010-01-02') COMPUTE STATISTICS").toString());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(this.queryStats$1("2010-01-01", tableName).rowCount().get());
                int $org_scalatest_assert_macro_right5 = 500;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 401));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(this.queryStats$1("2010-01-01", tableName).sizeInBytes());
                int $org_scalatest_assert_macro_right6 = 2000;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 402));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(this.queryStats$1("2010-01-02", tableName).rowCount().get());
                int $org_scalatest_assert_macro_right7 = 1000;
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 404));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(this.queryStats$1("2010-01-02", tableName).sizeInBytes());
                int $org_scalatest_assert_macro_right8 = 4000;
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 405));
            });
        }, new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 366));
        this.test("analyze a set of partitions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String tableName = "analyzeTable_part";
            this.withTable((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tableName}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(86).append("CREATE TABLE ").append(tableName).append(" (key STRING, value STRING) USING hive ").append("PARTITIONED BY (ds STRING, hr INT)").toString());
                this.createPartition$2("2010-01-01", 10, "SELECT '1', 'A' from src", tableName);
                this.createPartition$2("2010-01-01", 11, "SELECT '1', 'A' from src", tableName);
                this.createPartition$2("2010-01-02", 10, "SELECT '1', 'A' from src", tableName);
                this.createPartition$2("2010-01-02", 11, "SELECT '1', 'A' from src UNION ALL SELECT '1', 'A' from src", tableName);
                this.assertPartitionStats$1("2010-01-01", "10", (Option)None$.MODULE$, BigInt$.MODULE$.int2bigInt(2000), tableName);
                this.assertPartitionStats$1("2010-01-01", "11", (Option)None$.MODULE$, BigInt$.MODULE$.int2bigInt(2000), tableName);
                this.assertPartitionStats$1("2010-01-02", "10", (Option)None$.MODULE$, BigInt$.MODULE$.int2bigInt(2000), tableName);
                this.assertPartitionStats$1("2010-01-02", "11", (Option)None$.MODULE$, BigInt$.MODULE$.int2bigInt(4000), tableName);
                this.sql().apply((Object)new StringBuilder(61).append("ANALYZE TABLE ").append(tableName).append(" PARTITION (ds='2010-01-01') COMPUTE STATISTICS").toString());
                this.assertPartitionStats$1("2010-01-01", "10", (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(500)), BigInt$.MODULE$.int2bigInt(2000), tableName);
                this.assertPartitionStats$1("2010-01-01", "11", (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(500)), BigInt$.MODULE$.int2bigInt(2000), tableName);
                this.assertPartitionStats$1("2010-01-02", "10", (Option)None$.MODULE$, BigInt$.MODULE$.int2bigInt(2000), tableName);
                this.assertPartitionStats$1("2010-01-02", "11", (Option)None$.MODULE$, BigInt$.MODULE$.int2bigInt(4000), tableName);
                this.sql().apply((Object)new StringBuilder(61).append("ANALYZE TABLE ").append(tableName).append(" PARTITION (ds='2010-01-02') COMPUTE STATISTICS").toString());
                this.assertPartitionStats$1("2010-01-01", "10", (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(500)), BigInt$.MODULE$.int2bigInt(2000), tableName);
                this.assertPartitionStats$1("2010-01-01", "11", (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(500)), BigInt$.MODULE$.int2bigInt(2000), tableName);
                this.assertPartitionStats$1("2010-01-02", "10", (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(500)), BigInt$.MODULE$.int2bigInt(2000), tableName);
                this.assertPartitionStats$1("2010-01-02", "11", (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(1000)), BigInt$.MODULE$.int2bigInt(4000), tableName);
            });
        }, new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 409));
        this.test("analyze all partitions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String tableName = "analyzeTable_part";
            this.withTable((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tableName}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(86).append("CREATE TABLE ").append(tableName).append(" (key STRING, value STRING) USING hive ").append("PARTITIONED BY (ds STRING, hr INT)").toString());
                this.createPartition$3("2010-01-01", 10, "SELECT '1', 'A' from src", tableName);
                this.createPartition$3("2010-01-01", 11, "SELECT '1', 'A' from src", tableName);
                this.createPartition$3("2010-01-02", 10, "SELECT '1', 'A' from src", tableName);
                this.createPartition$3("2010-01-02", 11, "SELECT '1', 'A' from src UNION ALL SELECT '1', 'A' from src", tableName);
                this.sql().apply((Object)new StringBuilder(59).append("ANALYZE TABLE ").append(tableName).append(" PARTITION (ds, hr) COMPUTE STATISTICS NOSCAN").toString());
                this.assertPartitionStats$2("2010-01-01", "10", (Option)None$.MODULE$, BigInt$.MODULE$.int2bigInt(2000), tableName);
                this.assertPartitionStats$2("2010-01-01", "11", (Option)None$.MODULE$, BigInt$.MODULE$.int2bigInt(2000), tableName);
                this.assertPartitionStats$2("2010-01-01", "11", (Option)None$.MODULE$, BigInt$.MODULE$.int2bigInt(2000), tableName);
                this.assertPartitionStats$2("2010-01-02", "11", (Option)None$.MODULE$, BigInt$.MODULE$.int2bigInt(4000), tableName);
                this.sql().apply((Object)new StringBuilder(52).append("ANALYZE TABLE ").append(tableName).append(" PARTITION (ds, hr) COMPUTE STATISTICS").toString());
                this.assertPartitionStats$2("2010-01-01", "10", (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(500)), BigInt$.MODULE$.int2bigInt(2000), tableName);
                this.assertPartitionStats$2("2010-01-01", "11", (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(500)), BigInt$.MODULE$.int2bigInt(2000), tableName);
                this.assertPartitionStats$2("2010-01-01", "11", (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(500)), BigInt$.MODULE$.int2bigInt(2000), tableName);
                this.assertPartitionStats$2("2010-01-02", "11", (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(1000)), BigInt$.MODULE$.int2bigInt(4000), tableName);
            });
        }, new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 464));
        this.test("analyze partitions for an empty table", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String tableName = "analyzeTable_part";
            this.withTable((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tableName}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(67).append("CREATE TABLE ").append(tableName).append(" (key STRING, value STRING) PARTITIONED BY (ds STRING)").toString());
                this.sql().apply((Object)new StringBuilder(55).append("ANALYZE TABLE ").append(tableName).append(" PARTITION (ds) COMPUTE STATISTICS NOSCAN").toString());
                this.sql().apply((Object)new StringBuilder(48).append("ANALYZE TABLE ").append(tableName).append(" PARTITION (ds) COMPUTE STATISTICS").toString());
            });
        }, new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 508));
        this.test("analyze partitions case sensitivity", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String tableName = "analyzeTable_part";
            this.withTable((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tableName}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(67).append("CREATE TABLE ").append(tableName).append(" (key STRING, value STRING) PARTITIONED BY (ds STRING)").toString());
                this.sql().apply((Object)new StringBuilder(64).append("INSERT INTO TABLE ").append(tableName).append(" PARTITION (ds='2010-01-01') SELECT * FROM src").toString());
                this.withSQLConf((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.CASE_SENSITIVE().key()), (Object)"false")}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.sql().apply((Object)new StringBuilder(61).append("ANALYZE TABLE ").append(tableName).append(" PARTITION (DS='2010-01-01') COMPUTE STATISTICS").toString()));
                this.withSQLConf((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.CASE_SENSITIVE().key()), (Object)"true")}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    String message;
                    String $org_scalatest_assert_macro_left = message = ((AnalysisException)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(61).append("ANALYZE TABLE ").append(tableName).append(" PARTITION (DS='2010-01-01') COMPUTE STATISTICS").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 534))).getMessage();
                    String $org_scalatest_assert_macro_right = new StringBuilder(56).append("DS is not a valid partition column in table ").append("`default`.`").append(tableName.toLowerCase(Locale.ROOT)).append("`").toString();
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 537));
                });
            });
        }, new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 522));
        this.test("analyze partial partition specifications", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String tableName = "analyzeTable_part";
            this.withTable((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tableName}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(118).append("\n           |CREATE TABLE ").append(tableName).append(" (key STRING, value STRING)\n           |PARTITIONED BY (a STRING, b INT, c STRING)\n         ").toString())).stripMargin());
                this.sql().apply((Object)new StringBuilder(69).append("INSERT INTO TABLE ").append(tableName).append(" PARTITION (a='a1', b=10, c='c1') SELECT * FROM src").toString());
                this.sql().apply((Object)new StringBuilder(52).append("ANALYZE TABLE ").append(tableName).append(" PARTITION (a='a1') COMPUTE STATISTICS").toString());
                this.sql().apply((Object)new StringBuilder(58).append("ANALYZE TABLE ").append(tableName).append(" PARTITION (a='a1', b=10) COMPUTE STATISTICS").toString());
                this.sql().apply((Object)new StringBuilder(58).append("ANALYZE TABLE ").append(tableName).append(" PARTITION (A='a1', b=10) COMPUTE STATISTICS").toString());
                this.sql().apply((Object)new StringBuilder(58).append("ANALYZE TABLE ").append(tableName).append(" PARTITION (b=10, a='a1') COMPUTE STATISTICS").toString());
                this.sql().apply((Object)new StringBuilder(58).append("ANALYZE TABLE ").append(tableName).append(" PARTITION (b=10, A='a1') COMPUTE STATISTICS").toString());
                this.assertAnalysisException$1("PARTITION (b=10)", tableName);
                this.assertAnalysisException$1("PARTITION (a, b=10)", tableName);
                this.assertAnalysisException$1("PARTITION (b=10, c='c1')", tableName);
                this.assertAnalysisException$1("PARTITION (a, b=10, c='c1')", tableName);
                this.assertAnalysisException$1("PARTITION (c='c1')", tableName);
                this.assertAnalysisException$1("PARTITION (a, b, c='c1')", tableName);
                this.assertAnalysisException$1("PARTITION (a='a1', c='c1')", tableName);
                this.assertAnalysisException$1("PARTITION (a='a1', b, c='c1')", tableName);
            });
        }, new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 544));
        this.test("analyze non-existent partition", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String tableName = "analyzeTable_part";
            this.withTable((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tableName}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(67).append("CREATE TABLE ").append(tableName).append(" (key STRING, value STRING) PARTITIONED BY (ds STRING)").toString());
                this.sql().apply((Object)new StringBuilder(64).append("INSERT INTO TABLE ").append(tableName).append(" PARTITION (ds='2010-01-01') SELECT * FROM src").toString());
                this.assertAnalysisException$2(new StringBuilder(53).append("ANALYZE TABLE ").append(tableName).append(" PARTITION (hour=20) COMPUTE STATISTICS").toString(), new StringBuilder(58).append("hour is not a valid partition column in table ").append("`default`.`").append(tableName.toLowerCase(Locale.ROOT)).append("`").toString());
                this.assertAnalysisException$2(new StringBuilder(50).append("ANALYZE TABLE ").append(tableName).append(" PARTITION (hour) COMPUTE STATISTICS").toString(), new StringBuilder(58).append("hour is not a valid partition column in table ").append("`default`.`").append(tableName.toLowerCase(Locale.ROOT)).append("`").toString());
                this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(61).append("ANALYZE TABLE ").append(tableName).append(" PARTITION (ds='2011-02-30') COMPUTE STATISTICS").toString()), ClassTag$.MODULE$.apply(NoSuchPartitionException.class), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 611));
            });
        }, new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 584));
        this.test("test table-level statistics for hive tables created in HiveExternalCatalog", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String textTable = "textTable";
            this.withTable((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{textTable}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(59).append("CREATE TABLE ").append(textTable).append(" (key STRING, value STRING) STORED AS TEXTFILE").toString());
                this.checkTableStats(textTable, false, (Option)None$.MODULE$);
                this.sql().apply((Object)new StringBuilder(36).append("INSERT INTO TABLE ").append(textTable).append(" SELECT * FROM src").toString());
                this.checkTableStats(textTable, true, (Option)None$.MODULE$);
                this.sql().apply((Object)new StringBuilder(40).append("ANALYZE TABLE ").append(textTable).append(" COMPUTE STATISTICS noscan").toString());
                Option fetchedStats1 = this.checkTableStats(textTable, true, (Option)None$.MODULE$);
                this.sql().apply((Object)new StringBuilder(33).append("ANALYZE TABLE ").append(textTable).append(" COMPUTE STATISTICS").toString());
                Option fetchedStats2 = this.checkTableStats(textTable, true, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)500)));
                BigInt $org_scalatest_assert_macro_left = ((CatalogStatistics)fetchedStats1.get()).sizeInBytes();
                BigInt $org_scalatest_assert_macro_right = ((CatalogStatistics)fetchedStats2.get()).sizeInBytes();
                BigInt bigInt = $org_scalatest_assert_macro_left;
                BigInt bigInt2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(bigInt != null ? !bigInt.equals(bigInt2) : bigInt2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 642));
            });
        }, new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 617));
        this.test("keep existing row count in stats with noscan if table is not changed", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String textTable = "textTable";
            this.withTable((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{textTable}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(40).append("CREATE TABLE ").append(textTable).append(" (key STRING, value STRING)").toString());
                this.sql().apply((Object)new StringBuilder(36).append("INSERT INTO TABLE ").append(textTable).append(" SELECT * FROM src").toString());
                this.sql().apply((Object)new StringBuilder(33).append("ANALYZE TABLE ").append(textTable).append(" COMPUTE STATISTICS").toString());
                Option fetchedStats1 = this.checkTableStats(textTable, true, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)500)));
                this.sql().apply((Object)new StringBuilder(40).append("ANALYZE TABLE ").append(textTable).append(" COMPUTE STATISTICS noscan").toString());
                Option fetchedStats2 = this.checkTableStats(textTable, true, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)500)));
                Option $org_scalatest_assert_macro_left = fetchedStats1;
                Option $org_scalatest_assert_macro_right = fetchedStats2;
                Option option = $org_scalatest_assert_macro_left;
                Option option2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(option != null ? !option.equals(option2) : option2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 659));
            });
        }, new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 646));
        this.test("keep existing column stats if table is not changed", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String table = "update_col_stats_table";
            this.withTable((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{table}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(44).append("CREATE TABLE ").append(table).append(" (c1 INT, c2 STRING, c3 DOUBLE)").toString());
                this.sql().apply((Object)new StringBuilder(48).append("ANALYZE TABLE ").append(table).append(" COMPUTE STATISTICS FOR COLUMNS c1").toString());
                Option fetchedStats0 = this.checkTableStats(table, true, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)0)));
                scala.collection.immutable.Map $org_scalatest_assert_macro_left = ((CatalogStatistics)fetchedStats0.get()).colStats();
                scala.collection.immutable.Map $org_scalatest_assert_macro_right = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c1"), (Object)new CatalogColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), CatalogColumnStat$.MODULE$.apply$default$7(), CatalogColumnStat$.MODULE$.apply$default$8()))}));
                scala.collection.immutable.Map map = $org_scalatest_assert_macro_left;
                scala.collection.immutable.Map map2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(map != null ? !map.equals(map2) : map2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 670));
                this.sql().apply((Object)new StringBuilder(38).append("INSERT INTO TABLE ").append(table).append(" SELECT 1, 'a', 10.0").toString());
                this.sql().apply((Object)new StringBuilder(48).append("ANALYZE TABLE ").append(table).append(" COMPUTE STATISTICS FOR COLUMNS c1").toString());
                CatalogStatistics fetchedStats1 = (CatalogStatistics)this.checkTableStats(table, true, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)1))).get();
                scala.collection.immutable.Map $org_scalatest_assert_macro_left2 = fetchedStats1.colStats();
                scala.collection.immutable.Map $org_scalatest_assert_macro_right2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c1"), (Object)new CatalogColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(1)), (Option)new Some((Object)"1"), (Option)new Some((Object)"1"), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), CatalogColumnStat$.MODULE$.apply$default$7(), CatalogColumnStat$.MODULE$.apply$default$8()))}));
                scala.collection.immutable.Map map3 = $org_scalatest_assert_macro_left2;
                scala.collection.immutable.Map map4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(map3 != null ? !map3.equals(map4) : map4 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 678));
                this.sql().apply((Object)new StringBuilder(48).append("ANALYZE TABLE ").append(table).append(" COMPUTE STATISTICS FOR COLUMNS c2").toString());
                CatalogStatistics fetchedStats2 = (CatalogStatistics)this.checkTableStats(table, true, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)1))).get();
                scala.collection.immutable.Map $org_scalatest_assert_macro_left3 = fetchedStats2.colStats();
                scala.collection.immutable.Map $org_scalatest_assert_macro_right3 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c1"), (Object)new CatalogColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(1)), (Option)new Some((Object)"1"), (Option)new Some((Object)"1"), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), CatalogColumnStat$.MODULE$.apply$default$7(), CatalogColumnStat$.MODULE$.apply$default$8())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c2"), (Object)new CatalogColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(1)), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)1L)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)1L)), CatalogColumnStat$.MODULE$.apply$default$7(), CatalogColumnStat$.MODULE$.apply$default$8()))}));
                scala.collection.immutable.Map map5 = $org_scalatest_assert_macro_left3;
                scala.collection.immutable.Map map6 = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(map5 != null ? !map5.equals(map6) : map6 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 686));
                this.sql().apply((Object)new StringBuilder(38).append("INSERT INTO TABLE ").append(table).append(" SELECT 2, 'b', 20.0").toString());
                this.sql().apply((Object)new StringBuilder(52).append("ANALYZE TABLE ").append(table).append(" COMPUTE STATISTICS FOR COLUMNS c1, c3").toString());
                CatalogStatistics fetchedStats3 = (CatalogStatistics)this.checkTableStats(table, true, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)2))).get();
                scala.collection.immutable.Map $org_scalatest_assert_macro_left4 = fetchedStats3.colStats();
                scala.collection.immutable.Map $org_scalatest_assert_macro_right4 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c1"), (Object)new CatalogColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(2)), (Option)new Some((Object)"1"), (Option)new Some((Object)"2"), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), CatalogColumnStat$.MODULE$.apply$default$7(), CatalogColumnStat$.MODULE$.apply$default$8())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c3"), (Object)new CatalogColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(2)), (Option)new Some((Object)"10.0"), (Option)new Some((Object)"20.0"), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)8L)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)8L)), CatalogColumnStat$.MODULE$.apply$default$7(), CatalogColumnStat$.MODULE$.apply$default$8()))}));
                scala.collection.immutable.Map map7 = $org_scalatest_assert_macro_left4;
                scala.collection.immutable.Map map8 = $org_scalatest_assert_macro_right4;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(map7 != null ? !map7.equals(map8) : map8 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 698));
            });
        }, new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 663));
        this.test("collecting statistics for all columns", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String table = "update_col_stats_table";
            this.withTable((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{table}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(44).append("CREATE TABLE ").append(table).append(" (c1 INT, c2 STRING, c3 DOUBLE)").toString());
                this.sql().apply((Object)new StringBuilder(49).append("ANALYZE TABLE ").append(table).append(" COMPUTE STATISTICS FOR ALL COLUMNS").toString());
                Option fetchedStats0 = this.checkTableStats(table, true, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)0)));
                scala.collection.immutable.Map $org_scalatest_assert_macro_left = ((CatalogStatistics)fetchedStats0.get()).colStats();
                scala.collection.immutable.Map $org_scalatest_assert_macro_right = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c1"), (Object)new CatalogColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), CatalogColumnStat$.MODULE$.apply$default$7(), CatalogColumnStat$.MODULE$.apply$default$8())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c3"), (Object)new CatalogColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)8L)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)8L)), CatalogColumnStat$.MODULE$.apply$default$7(), CatalogColumnStat$.MODULE$.apply$default$8())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c2"), (Object)new CatalogColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)20L)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)20L)), CatalogColumnStat$.MODULE$.apply$default$7(), CatalogColumnStat$.MODULE$.apply$default$8()))}));
                scala.collection.immutable.Map map = $org_scalatest_assert_macro_left;
                scala.collection.immutable.Map map2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(map != null ? !map.equals(map2) : map2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 713));
                this.sql().apply((Object)new StringBuilder(38).append("INSERT INTO TABLE ").append(table).append(" SELECT 1, 'a', 10.0").toString());
                this.sql().apply((Object)new StringBuilder(38).append("INSERT INTO TABLE ").append(table).append(" SELECT 1, 'b', null").toString());
                this.sql().apply((Object)new StringBuilder(49).append("ANALYZE TABLE ").append(table).append(" COMPUTE STATISTICS FOR ALL COLUMNS").toString());
                Option fetchedStats1 = this.checkTableStats(table, true, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)2)));
                scala.collection.immutable.Map $org_scalatest_assert_macro_left2 = ((CatalogStatistics)fetchedStats1.get()).colStats();
                scala.collection.immutable.Map $org_scalatest_assert_macro_right2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c1"), (Object)new CatalogColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(1)), (Option)new Some((Object)"1"), (Option)new Some((Object)"1"), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), CatalogColumnStat$.MODULE$.apply$default$7(), CatalogColumnStat$.MODULE$.apply$default$8())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c3"), (Object)new CatalogColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(1)), (Option)new Some((Object)"10.0"), (Option)new Some((Object)"10.0"), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(1)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)8L)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)8L)), CatalogColumnStat$.MODULE$.apply$default$7(), CatalogColumnStat$.MODULE$.apply$default$8())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c2"), (Object)new CatalogColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(2)), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)1L)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)1L)), CatalogColumnStat$.MODULE$.apply$default$7(), CatalogColumnStat$.MODULE$.apply$default$8()))}));
                scala.collection.immutable.Map map3 = $org_scalatest_assert_macro_left2;
                scala.collection.immutable.Map map4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(map3 != null ? !map3.equals(map4) : map4 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 728));
            });
        }, new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 706));
        this.test("analyze column command parameters validation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            IllegalArgumentException e1 = (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> new AnalyzeColumnCommand(TableIdentifier$.MODULE$.apply("test"), Option$.MODULE$.apply((Object)new .colon.colon((Object)"c1", (List)Nil$.MODULE$)), true).run(this.spark()), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 739));
            String $org_scalatest_assert_macro_left = e1.getMessage();
            String $org_scalatest_assert_macro_right = "Parameter `columnNames` or `allColumns` are mutually exclusive";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 742));
            IllegalArgumentException e2 = (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> new AnalyzeColumnCommand(TableIdentifier$.MODULE$.apply("test"), (Option)None$.MODULE$, false).run(this.spark()), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 744));
            String $org_scalatest_assert_macro_left2 = e1.getMessage();
            String $org_scalatest_assert_macro_right2 = "Parameter `columnNames` or `allColumns` are mutually exclusive";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 747));
        }, new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 738));
        this.test("get statistics when not analyzed in Hive or Spark", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String tabName = "tab1";
            this.withTable((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tabName}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Bool bool;
                String x$1 = tabName;
                boolean x$2 = false;
                boolean x$3 = false;
                this.createNonPartitionedTable(x$1, x$3, x$2);
                this.checkTableStats(tabName, true, (Option)None$.MODULE$);
                Seq describeResult = this.hiveClient().runSqlHive(new StringBuilder(19).append("DESCRIBE FORMATTED ").append(tabName).toString());
                Option<BigInt> rawDataSize = this.extractStatsPropValues((Seq<String>)describeResult, "rawDataSize");
                Option<BigInt> numRows = this.extractStatsPropValues((Seq<String>)describeResult, "numRows");
                Option<BigInt> totalSize = this.extractStatsPropValues((Seq<String>)describeResult, "totalSize");
                Option<BigInt> $org_scalatest_assert_macro_left = rawDataSize;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"rawDataSize should not be shown without table analysis", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 812));
                Option<BigInt> $org_scalatest_assert_macro_left2 = numRows;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"numRows should not be shown without table analysis", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 813));
                Bool $org_scalatest_assert_macro_left3 = Bool$.MODULE$.simpleMacroBool(totalSize.isDefined(), "totalSize.isDefined", Prettifier$.MODULE$.default());
                if ($org_scalatest_assert_macro_left3.value()) {
                    BigInt $org_scalatest_assert_macro_left4 = (BigInt)totalSize.get();
                    BigInt $org_scalatest_assert_macro_right = BigInt$.MODULE$.int2bigInt(0);
                    bool = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, ">", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left4.$greater((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                } else {
                    bool = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
                }
                Bool $org_scalatest_assert_macro_right = bool;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "&&", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left3.$amp$amp((Function0 & Serializable & scala.Serializable)() -> $org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"totalSize is lost", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 814));
            });
        }, new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 799));
        this.test("alter table should not have the side effect to store statistics in Spark side", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String table = "alter_table_side_effect";
            this.withTable((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{table}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                BigInt hiveSize2;
                this.sql().apply((Object)new StringBuilder(45).append("CREATE TABLE ").append(table).append(" (i string, j string) USING hive").toString());
                this.sql().apply((Object)new StringBuilder(34).append("INSERT INTO TABLE ").append(table).append(" SELECT 'a', 'b'").toString());
                CatalogTable catalogTable1 = this.getCatalogTable(table);
                BigInt hiveSize1 = scala.package$.MODULE$.BigInt().apply((String)catalogTable1.ignoredProperties().apply((Object)"totalSize"));
                this.sql().apply((Object)new StringBuilder(46).append("ALTER TABLE ").append(table).append(" SET TBLPROPERTIES ('prop1' = 'a')").toString());
                this.sql().apply((Object)new StringBuilder(34).append("INSERT INTO TABLE ").append(table).append(" SELECT 'c', 'd'").toString());
                CatalogTable catalogTable2 = this.getCatalogTable(table);
                BigInt $org_scalatest_assert_macro_left = hiveSize2 = scala.package$.MODULE$.BigInt().apply((String)catalogTable2.ignoredProperties().apply((Object)"totalSize"));
                BigInt $org_scalatest_assert_macro_right = hiveSize1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, ">", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$greater((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 832));
                BigInt $org_scalatest_assert_macro_left2 = ((CatalogStatistics)catalogTable2.stats().get()).sizeInBytes();
                BigInt $org_scalatest_assert_macro_right2 = hiveSize2;
                BigInt bigInt = $org_scalatest_assert_macro_left2;
                BigInt bigInt2 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(bigInt != null ? !bigInt.equals(bigInt2) : bigInt2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 834));
            });
        }, new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 818));
        this.test("alter table SET TBLPROPERTIES after analyze table", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testAlterTableProperties("set_prop_table", "ALTER TABLE set_prop_table SET TBLPROPERTIES ('foo' = 'a')"), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 861));
        this.test("alter table UNSET TBLPROPERTIES after analyze table", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testAlterTableProperties("unset_prop_table", "ALTER TABLE unset_prop_table UNSET TBLPROPERTIES ('prop1')"), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 866));
        this.test("change stats after insert command for hive table", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String table = "change_stats_insert_hive_table";
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{false, true}))).foreach((Function1 & Serializable & scala.Serializable)autoUpdate -> {
                this.withSQLConf((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.AUTO_SIZE_UPDATE_ENABLED().key()), (Object)Boolean.toString(BoxesRunTime.unboxToBoolean((Object)autoUpdate)))}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{table}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    $this.sql().apply((Object)new StringBuilder(31).append("CREATE TABLE ").append(table$6).append(" (i int, j string)").toString());
                    $this.sql().apply((Object)new StringBuilder(50).append("ANALYZE TABLE ").append(table$6).append(" COMPUTE STATISTICS FOR COLUMNS i, j").toString());
                    Option fetched1 = $this.checkTableStats(table$6, true, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)0)));
                    BigInt $org_scalatest_assert_macro_left = ((CatalogStatistics)fetched1.get()).sizeInBytes();
                    int $org_scalatest_assert_macro_right = 0;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), BoxesRunTime.equalsNumObject((Number)$org_scalatest_assert_macro_left, (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 889));
                    scala.collection.immutable.Map $org_scalatest_assert_macro_left2 = ((CatalogStatistics)fetched1.get()).colStats();
                    int $org_scalatest_assert_macro_right2 = 2;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 890));
                    $this.sql().apply((Object)new StringBuilder(34).append("INSERT INTO TABLE ").append(table$6).append(" SELECT 1, 'abc'").toString());
                    if (autoUpdate) {
                        Option fetched2 = $this.checkTableStats(table$6, true, (Option)None$.MODULE$);
                        BigInt $org_scalatest_assert_macro_left3 = ((CatalogStatistics)fetched2.get()).sizeInBytes();
                        BigInt $org_scalatest_assert_macro_right3 = BigInt$.MODULE$.int2bigInt(0);
                        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, ">", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$greater((Object)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 896));
                        scala.collection.immutable.Map $org_scalatest_assert_macro_left4 = ((CatalogStatistics)fetched2.get()).colStats();
                        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left4, "isEmpty", $org_scalatest_assert_macro_left4.isEmpty(), Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 897));
                        scala.collection.immutable.Map<String, String> statsProp = $this.getStatsProperties(table$6);
                        long $org_scalatest_assert_macro_left5 = new StringOps(Predef$.MODULE$.augmentString((String)statsProp.apply((Object)HiveExternalCatalog$.MODULE$.STATISTICS_TOTAL_SIZE()))).toLong();
                        BigInt $org_scalatest_assert_macro_right4 = ((CatalogStatistics)fetched2.get()).sizeInBytes();
                        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left5), "==", (Object)$org_scalatest_assert_macro_right4, BoxesRunTime.equals((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left5), (Object)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 899));
                    } else {
                        scala.collection.immutable.Map<String, String> $org_scalatest_assert_macro_left6 = $this.getStatsProperties(table$6);
                        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left6, "isEmpty", $org_scalatest_assert_macro_left6.isEmpty(), Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 901));
                    }
                }));
                return BoxedUnit.UNIT;
            });
        }, new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 880));
        this.test("change stats after load data command", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String table = "change_stats_load_table";
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{false, true}))).foreach((Function1 & Serializable & scala.Serializable)autoUpdate -> {
                this.withSQLConf((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.AUTO_SIZE_UPDATE_ENABLED().key()), (Object)Boolean.toString(BoxesRunTime.unboxToBoolean((Object)autoUpdate)))}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{table}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    $this.sql().apply((Object)new StringBuilder(49).append("CREATE TABLE ").append(table$7).append(" (i INT, j STRING) STORED AS PARQUET").toString());
                    $this.sql().apply((Object)new StringBuilder(50).append("ANALYZE TABLE ").append(table$7).append(" COMPUTE STATISTICS FOR COLUMNS i, j").toString());
                    Option fetched1 = $this.checkTableStats(table$7, true, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)0)));
                    BigInt $org_scalatest_assert_macro_left = ((CatalogStatistics)fetched1.get()).sizeInBytes();
                    int $org_scalatest_assert_macro_right = 0;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), BoxesRunTime.equalsNumObject((Number)$org_scalatest_assert_macro_left, (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 917));
                    scala.collection.immutable.Map $org_scalatest_assert_macro_left2 = ((CatalogStatistics)fetched1.get()).colStats();
                    int $org_scalatest_assert_macro_right2 = 2;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 918));
                    $this.withTempDir((Function1 & Serializable & scala.Serializable)loadPath -> {
                        StatisticsSuite.$anonfun$new$86($this, table$7, autoUpdate, loadPath);
                        return BoxedUnit.UNIT;
                    });
                }));
                return BoxedUnit.UNIT;
            });
        }, new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 908));
        this.test("change stats after add/drop partition command", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String table = "change_stats_part_table";
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{false, true}))).foreach((Function1 & Serializable & scala.Serializable)autoUpdate -> {
                this.withSQLConf((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.AUTO_SIZE_UPDATE_ENABLED().key()), (Object)Boolean.toString(BoxesRunTime.unboxToBoolean((Object)autoUpdate)))}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{table}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    $this.sql().apply((Object)new StringBuilder(80).append("CREATE TABLE ").append(table$8).append(" (i INT, j STRING) USING hive ").append("PARTITIONED BY (ds STRING, hr STRING)").toString());
                    ((IterableLike)new .colon.colon((Object)"2008-04-08", (List)Nil$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)ds -> {
                        StatisticsSuite.$anonfun$new$93($this, table$8, ds);
                        return BoxedUnit.UNIT;
                    });
                    $this.sql().apply((Object)new StringBuilder(50).append("ANALYZE TABLE ").append(table$8).append(" COMPUTE STATISTICS FOR COLUMNS i, j").toString());
                    Option fetched1 = $this.checkTableStats(table$8, true, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)2)));
                    BigInt $org_scalatest_assert_macro_left = ((CatalogStatistics)fetched1.get()).sizeInBytes();
                    BigInt $org_scalatest_assert_macro_right = BigInt$.MODULE$.int2bigInt(0);
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, ">", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$greater((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 956));
                    scala.collection.immutable.Map $org_scalatest_assert_macro_left2 = ((CatalogStatistics)fetched1.get()).colStats();
                    int $org_scalatest_assert_macro_right2 = 2;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 957));
                    $this.withTempPaths(2, (Function1 & Serializable & scala.Serializable)x0$1 -> {
                        StatisticsSuite.$anonfun$new$95($this, table$8, autoUpdate, fetched1, x0$1);
                        return BoxedUnit.UNIT;
                    });
                }));
                return BoxedUnit.UNIT;
            });
        }, new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 942));
        this.test("add/drop partitions - managed table", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SessionCatalog catalog = this.spark().sessionState().catalog();
            String managedTable = "partitionedTable";
            this.withTable((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{managedTable}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(133).append("\n           |CREATE TABLE ").append(managedTable).append(" (key INT, value STRING)\n           |USING hive\n           |PARTITIONED BY (ds STRING, hr STRING)\n         ").toString())).stripMargin());
                ((IterableLike)new .colon.colon((Object)"2008-04-08", (List)new .colon.colon((Object)"2008-04-09", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)ds -> {
                    StatisticsSuite.$anonfun$new$103(this, managedTable, ds);
                    return BoxedUnit.UNIT;
                });
                this.checkTableStats(managedTable, false, (Option)None$.MODULE$);
                this.sql().apply((Object)new StringBuilder(33).append("ANALYZE TABLE ").append(managedTable).append(" COMPUTE STATISTICS").toString());
                Option stats1 = this.checkTableStats(managedTable, true, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)4)));
                this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(100).append("\n           |ALTER TABLE ").append(managedTable).append(" DROP PARTITION (ds='2008-04-08'),\n           |PARTITION (hr='12')\n        ").toString())).stripMargin());
                Set $org_scalatest_assert_macro_left = ((TraversableOnce)catalog.listPartitions(TableIdentifier$.MODULE$.apply(managedTable), catalog.listPartitions$default$2()).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.spec(), Seq$.MODULE$.canBuildFrom())).toSet();
                Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.collection.immutable.Map[]{(scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ds"), (Object)"2008-04-09"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hr"), (Object)"11")}))}));
                Set set = $org_scalatest_assert_macro_left;
                Set set2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1051));
                this.sql().apply((Object)new StringBuilder(33).append("ANALYZE TABLE ").append(managedTable).append(" COMPUTE STATISTICS").toString());
                Option stats2 = this.checkTableStats(managedTable, true, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)1)));
                BigInt $org_scalatest_assert_macro_left2 = ((CatalogStatistics)stats1.get()).sizeInBytes();
                BigInt $org_scalatest_assert_macro_right2 = ((CatalogStatistics)stats2.get()).sizeInBytes();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, ">", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$greater((Object)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1058));
                this.sql().apply((Object)new StringBuilder(53).append("ALTER TABLE ").append(managedTable).append(" ADD PARTITION (ds='2008-04-08', hr='12')").toString());
                this.sql().apply((Object)new StringBuilder(33).append("ANALYZE TABLE ").append(managedTable).append(" COMPUTE STATISTICS").toString());
                Option stats4 = this.checkTableStats(managedTable, true, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)1)));
                BigInt $org_scalatest_assert_macro_left3 = ((CatalogStatistics)stats1.get()).sizeInBytes();
                BigInt $org_scalatest_assert_macro_right3 = ((CatalogStatistics)stats4.get()).sizeInBytes();
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, ">", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$greater((Object)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1065));
                BigInt $org_scalatest_assert_macro_left4 = ((CatalogStatistics)stats4.get()).sizeInBytes();
                BigInt $org_scalatest_assert_macro_right4 = ((CatalogStatistics)stats2.get()).sizeInBytes();
                BigInt bigInt = $org_scalatest_assert_macro_left4;
                BigInt bigInt2 = $org_scalatest_assert_macro_right4;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(bigInt != null ? !bigInt.equals(bigInt2) : bigInt2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1066));
            });
        }, new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1018));
        this.test("test statistics of LogicalRelation converted from Hive serde tables", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)"orc", (List)new .colon.colon((Object)"parquet", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)format -> {
            StatisticsSuite.$anonfun$new$107(this, format);
            return BoxedUnit.UNIT;
        }), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1070));
        this.test("verify serialized column stats after analyzing columns", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String tableName = "column_stats_test_ser";
            LinkedHashMap $org_scalatest_assert_macro_left = this.stats();
            int $org_scalatest_assert_macro_right = ((Product13)this.data().head()).productArity() - 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1094));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(StatisticsSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_hive_StatisticsSuite$$typecreator6$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple13"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$m.staticClass("java.lang.Boolean").asType().toTypeConstructor(), $m.staticClass("java.lang.Byte").asType().toTypeConstructor(), $m.staticClass("java.lang.Short").asType().toTypeConstructor(), $m.staticClass("java.lang.Integer").asType().toTypeConstructor(), $m.staticClass("java.lang.Long").asType().toTypeConstructor(), $m.staticClass("java.lang.Double").asType().toTypeConstructor(), $m.staticClass("java.lang.Float").asType().toTypeConstructor(), $m.staticClass("java.math.BigDecimal").asType().toTypeConstructor(), $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Byte").asType().toTypeConstructor(), (List)Nil$.MODULE$)), $m.staticClass("java.sql.Date").asType().toTypeConstructor(), $m.staticClass("java.sql.Timestamp").asType().toTypeConstructor(), $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().thisPrefix((Symbols.SymbolApi)$m.RootClass()), (Symbols.SymbolApi)$m.staticPackage("scala")), (Symbols.SymbolApi)$m.staticModule("scala.package")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.package").asModule().moduleClass(), "Seq"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$))})));
                }

                public Org_apache_spark_sql_hive_StatisticsSuite$$typecreator6$1(StatisticsSuite $outer) {
                }
            }
            Dataset df = this.testImplicits().localSeqToDatasetHolder(this.data(), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_hive_StatisticsSuite$$typecreator6$1(null)))).toDF((Seq)this.stats().keys().toSeq().$colon$plus((Object)"carray", Seq$.MODULE$.canBuildFrom()));
            this.withTable((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tableName}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                df.write().saveAsTable(tableName);
                this.checkColStatsProps$1(this.expectedSerializedColStats(), tableName);
                this.withSQLConf((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.HISTOGRAM_ENABLED().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.HISTOGRAM_NUM_BINS().key()), (Object)"2")}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkColStatsProps$1(this.expectedSerializedColStats().$plus$plus((GenTraversableOnce)this.expectedSerializedHistograms()), tableName));
            });
        }, new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1089));
        this.test("verify column stats can be deserialized from tblproperties", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String tableName = "column_stats_test_de";
            LinkedHashMap $org_scalatest_assert_macro_left = this.stats();
            int $org_scalatest_assert_macro_right = ((Product13)this.data().head()).productArity() - 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1123));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(StatisticsSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_hive_StatisticsSuite$$typecreator16$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple13"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$m.staticClass("java.lang.Boolean").asType().toTypeConstructor(), $m.staticClass("java.lang.Byte").asType().toTypeConstructor(), $m.staticClass("java.lang.Short").asType().toTypeConstructor(), $m.staticClass("java.lang.Integer").asType().toTypeConstructor(), $m.staticClass("java.lang.Long").asType().toTypeConstructor(), $m.staticClass("java.lang.Double").asType().toTypeConstructor(), $m.staticClass("java.lang.Float").asType().toTypeConstructor(), $m.staticClass("java.math.BigDecimal").asType().toTypeConstructor(), $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Byte").asType().toTypeConstructor(), (List)Nil$.MODULE$)), $m.staticClass("java.sql.Date").asType().toTypeConstructor(), $m.staticClass("java.sql.Timestamp").asType().toTypeConstructor(), $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().thisPrefix((Symbols.SymbolApi)$m.RootClass()), (Symbols.SymbolApi)$m.staticPackage("scala")), (Symbols.SymbolApi)$m.staticModule("scala.package")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.package").asModule().moduleClass(), "Seq"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$))})));
                }

                public Org_apache_spark_sql_hive_StatisticsSuite$$typecreator16$1(StatisticsSuite $outer) {
                }
            }
            Dataset df = this.testImplicits().localSeqToDatasetHolder(this.data(), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_hive_StatisticsSuite$$typecreator16$1(null)))).toDF((Seq)this.stats().keys().toSeq().$colon$plus((Object)"carray", Seq$.MODULE$.canBuildFrom()));
            this.withTable((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tableName}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                df.write().saveAsTable(tableName);
                CatalogTable table = this.getCatalogTable(tableName);
                scala.collection.immutable.Map x$4 = table.properties().$plus$plus((GenTraversableOnce)this.expectedSerializedColStats()).$plus$plus((GenTraversableOnce)this.expectedSerializedHistograms()).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.sql.statistics.totalSize"), (Object)"1"));
                TableIdentifier x$5 = table.copy$default$1();
                CatalogTableType x$6 = table.copy$default$2();
                CatalogStorageFormat x$7 = table.copy$default$3();
                StructType x$8 = table.copy$default$4();
                Option x$9 = table.copy$default$5();
                Seq x$10 = table.copy$default$6();
                Option x$11 = table.copy$default$7();
                String x$12 = table.copy$default$8();
                long x$13 = table.copy$default$9();
                long x$14 = table.copy$default$10();
                String x$15 = table.copy$default$11();
                Option x$16 = table.copy$default$13();
                Option x$17 = table.copy$default$14();
                Option x$18 = table.copy$default$15();
                Seq x$19 = table.copy$default$16();
                boolean x$20 = table.copy$default$17();
                boolean x$21 = table.copy$default$18();
                scala.collection.immutable.Map x$22 = table.copy$default$19();
                Option x$23 = table.copy$default$20();
                CatalogTable newTable = table.copy(x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$4, x$16, x$17, x$18, x$19, x$20, x$21, x$22, x$23);
                this.hiveClient().alterTable(newTable);
                this.validateColStats(tableName, this.statsWithHgms());
            });
        }, new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1118));
        this.test("serialization and deserialization of histograms to/from hive metastore", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            long startTimestamp = DateTimeUtils$.MODULE$.fromJavaTimestamp(Timestamp.valueOf("2016-05-08 00:00:01"));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(StatisticsSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_hive_StatisticsSuite$$typecreator26$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.sql.Timestamp").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_hive_StatisticsSuite$$typecreator26$1(StatisticsSuite $outer) {
                }
            }
            Dataset df = this.testImplicits().localSeqToDatasetHolder((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 5000).map((Function1 & Serializable & scala.Serializable)i -> StatisticsSuite.$anonfun$new$119(startTimestamp, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom()), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_hive_StatisticsSuite$$typecreator26$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cint", "ctimestamp"}));
            String tableName = "histogram_serde_test";
            this.withTable((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tableName}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                df.write().saveAsTable(tableName);
                this.withSQLConf((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.HISTOGRAM_ENABLED().key()), (Object)"true")}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    scala.collection.immutable.Map tsHistogramProps;
                    scala.collection.immutable.Map intHistogramProps;
                    this.sql().apply((Object)new StringBuilder(62).append("ANALYZE TABLE ").append(tableName).append(" COMPUTE STATISTICS FOR COLUMNS cint, ctimestamp").toString());
                    CatalogTable table = this.hiveClient().getTable("default", tableName);
                    scala.collection.immutable.Map $org_scalatest_assert_macro_left = intHistogramProps = table.properties().filterKeys((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.startsWith("spark.sql.statistics.colStats.cint.histogram")));
                    int $org_scalatest_assert_macro_right = 1;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1169));
                    scala.collection.immutable.Map $org_scalatest_assert_macro_left2 = tsHistogramProps = table.properties().filterKeys((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)x$9.startsWith("spark.sql.statistics.colStats.ctimestamp.histogram")));
                    int $org_scalatest_assert_macro_right2 = 1;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1173));
                    scala.collection.immutable.Map cs = this.getTableStats(tableName).colStats();
                    Histogram intHistogram = (Histogram)((CatalogColumnStat)cs.apply((Object)"cint")).histogram().get();
                    Histogram tsHistogram = (Histogram)((CatalogColumnStat)cs.apply((Object)"ctimestamp")).histogram().get();
                    HistogramBin[] $org_scalatest_assert_macro_left3 = intHistogram.bins();
                    int $org_scalatest_assert_macro_right3 = this.spark().sessionState().conf().histogramNumBins();
                    Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1179));
                    StatisticsSuite.checkBinsOrder$1(intHistogram.bins());
                    HistogramBin[] $org_scalatest_assert_macro_left4 = tsHistogram.bins();
                    int $org_scalatest_assert_macro_right4 = this.spark().sessionState().conf().histogramNumBins();
                    Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1181));
                    StatisticsSuite.checkBinsOrder$1(tsHistogram.bins());
                });
            });
        }, new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1141));
        this.testUpdatingTableStats("data source table created in HiveExternalCatalog", "CREATE TABLE parquetTable (key STRING, value STRING) USING PARQUET");
        this.testUpdatingTableStats("partitioned data source table", "CREATE TABLE parquetTable (key STRING, value STRING) USING PARQUET PARTITIONED BY (key)");
        this.test("test refreshing table stats of cached data source table by `ANALYZE TABLE` statement", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Tuple2<CatalogStatistics, CatalogStatistics> tuple2 = this.getStatsBeforeAfterUpdate(false);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            CatalogStatistics statsBeforeUpdate = (CatalogStatistics)tuple2._1();
            CatalogStatistics statsAfterUpdate = (CatalogStatistics)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)statsBeforeUpdate, (Object)statsAfterUpdate);
            Tuple2 tuple23 = tuple22;
            CatalogStatistics statsBeforeUpdate2 = (CatalogStatistics)tuple23._1();
            CatalogStatistics statsAfterUpdate2 = (CatalogStatistics)tuple23._2();
            BigInt $org_scalatest_assert_macro_left = statsBeforeUpdate2.sizeInBytes();
            BigInt $org_scalatest_assert_macro_right = BigInt$.MODULE$.int2bigInt(0);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, ">", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$greater((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1264));
            Option $org_scalatest_assert_macro_left2 = statsBeforeUpdate2.rowCount();
            Some $org_scalatest_assert_macro_right2 = new Some((Object)BoxesRunTime.boxToInteger((int)1));
            Option option = $org_scalatest_assert_macro_left2;
            Some some = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(option != null ? !option.equals(some) : some != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1265));
            BigInt $org_scalatest_assert_macro_left3 = statsAfterUpdate2.sizeInBytes();
            BigInt $org_scalatest_assert_macro_right3 = statsBeforeUpdate2.sizeInBytes();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, ">", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$greater((Object)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1267));
            Option $org_scalatest_assert_macro_left4 = statsAfterUpdate2.rowCount();
            Some $org_scalatest_assert_macro_right4 = new Some((Object)BoxesRunTime.boxToInteger((int)2));
            Option option2 = $org_scalatest_assert_macro_left4;
            Some some2 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(option2 != null ? !option2.equals(some2) : some2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1268));
        }, new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1261));
        this.test("estimates the size of a test Hive serde tables", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Dataset df = (Dataset)this.sql().apply((Object)"SELECT * FROM src");
            Seq sizes = df.queryExecution().analyzed().collect((PartialFunction)new scala.Serializable(null){
                public static final long serialVersionUID = 0L;

                public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 instanceof HiveTableRelation) {
                        HiveTableRelation hiveTableRelation = (HiveTableRelation)A1;
                        object = hiveTableRelation.stats().sizeInBytes();
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(LogicalPlan x1) {
                    LogicalPlan logicalPlan = x1;
                    boolean bl = logicalPlan instanceof HiveTableRelation;
                    return bl;
                }
            });
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)sizes.size()));
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(17).append("Size wrong for:\n ").append(df.queryExecution()).toString(), Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1276));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(((BigInt)sizes.apply(0)).equals(scala.package$.MODULE$.BigInt().apply(5812)), "sizes.apply(0).equals(scala.`package`.BigInt.apply(5812))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)new StringBuilder(52).append("expected exact size 5812 for test table 'src', got: ").append(sizes.apply(0)).toString(), Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1277));
        }, new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1271));
        this.test("auto converts to broadcast hash join, by size estimate of a relation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String metastoreQuery = "SELECT * FROM src a JOIN src b ON a.key = 238 AND a.key = b.key";
            Seq metastoreAnswer = (Seq)Seq$.MODULE$.fill(4, (Function0 & Serializable & scala.Serializable)() -> Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)238), "val_238", BoxesRunTime.boxToInteger((int)238), "val_238"})));
            this.mkTest$1((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {}, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {}, metastoreQuery, metastoreAnswer, (ClassTag)Predef$.MODULE$.implicitly((Object)ClassTag$.MODULE$.apply(HiveTableRelation.class)));
        }, new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1281));
        this.test("auto converts to broadcast left semi join, by size estimate of a relation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Dataset dataset;
            Bool bool;
            Bool bool2;
            int $org_scalatest_assert_macro_right;
            String leftSemiJoinQuery = new StringOps(Predef$.MODULE$.augmentString("SELECT * FROM src a\n        |left semi JOIN src b ON a.key=86 and a.key = b.key")).stripMargin();
            Row answer = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)86), "val_86"}));
            ObjectRef df = ObjectRef.create((Object)((Dataset)this.sql().apply((Object)leftSemiJoinQuery)));
            Seq sizes = ((Dataset)df.elem).queryExecution().analyzed().collect((PartialFunction)new scala.Serializable(null){
                public static final long serialVersionUID = 0L;

                public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x2;
                    if (A1 instanceof HiveTableRelation) {
                        HiveTableRelation hiveTableRelation = (HiveTableRelation)A1;
                        object = hiveTableRelation.stats().sizeInBytes();
                    } else {
                        object = function1.apply(x2);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(LogicalPlan x2) {
                    LogicalPlan logicalPlan = x2;
                    boolean bl = logicalPlan instanceof HiveTableRelation;
                    return bl;
                }
            });
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)sizes.size()));
            Bool $org_scalatest_assert_macro_left2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)($org_scalatest_assert_macro_right = 2)), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            if ($org_scalatest_assert_macro_left2.value()) {
                BigInt $org_scalatest_assert_macro_left3 = (BigInt)sizes.apply(1);
                BigInt $org_scalatest_assert_macro_right2 = BigInt$.MODULE$.long2bigInt(this.spark().sessionState().conf().autoBroadcastJoinThreshold());
                bool2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "<=", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left3.$less$eq((Object)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            } else {
                bool2 = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
            }
            Bool $org_scalatest_assert_macro_right3 = bool2;
            Bool $org_scalatest_assert_macro_left4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "&&", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left2.$amp$amp((Function0 & Serializable & scala.Serializable)() -> $org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            if ($org_scalatest_assert_macro_left4.value()) {
                BigInt $org_scalatest_assert_macro_left5 = (BigInt)sizes.apply(0);
                BigInt $org_scalatest_assert_macro_right4 = BigInt$.MODULE$.long2bigInt(this.spark().sessionState().conf().autoBroadcastJoinThreshold());
                bool = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "<=", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left5.$less$eq((Object)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            } else {
                bool = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
            }
            Bool $org_scalatest_assert_macro_right5 = bool;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "&&", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left4.$amp$amp((Function0 & Serializable & scala.Serializable)() -> $org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"query should contain two relations, each of which has size smaller than autoConvertSize", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1350));
            Seq bhj = ((Dataset)df.elem).queryExecution().sparkPlan().collect((PartialFunction)new scala.Serializable(null){
                public static final long serialVersionUID = 0L;

                public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                    BroadcastHashJoinExec broadcastHashJoinExec;
                    A1 A1 = x3;
                    Object object = A1 instanceof BroadcastHashJoinExec ? (broadcastHashJoinExec = (BroadcastHashJoinExec)A1) : function1.apply(x3);
                    return (B1)object;
                }

                public final boolean isDefinedAt(SparkPlan x3) {
                    SparkPlan sparkPlan = x3;
                    boolean bl = sparkPlan instanceof BroadcastHashJoinExec;
                    return bl;
                }
            });
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)bhj.size()));
            int $org_scalatest_assert_macro_right6 = 1;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)new StringBuilder(50).append("actual query plans do not contain broadcast join: ").append(((Dataset)df.elem).queryExecution()).toString(), Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1359));
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)df$5.elem, answer);
            Map map = this.spark().sessionState().conf().settings();
            synchronized (map) {
                long tmp = this.spark().sessionState().conf().autoBroadcastJoinThreshold();
                this.sql().apply((Object)new StringBuilder(7).append("SET ").append(SQLConf$.MODULE$.AUTO_BROADCASTJOIN_THRESHOLD().key()).append("=-1").toString());
                df.elem = (Dataset)this.sql().apply((Object)leftSemiJoinQuery);
                Seq $org_scalatest_assert_macro_left7 = bhj = ((Dataset)df.elem).queryExecution().sparkPlan().collect((PartialFunction)new scala.Serializable(null){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                        BroadcastHashJoinExec broadcastHashJoinExec;
                        A1 A1 = x4;
                        Object object = A1 instanceof BroadcastHashJoinExec ? (broadcastHashJoinExec = (BroadcastHashJoinExec)A1) : function1.apply(x4);
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(SparkPlan x4) {
                        SparkPlan sparkPlan = x4;
                        boolean bl = sparkPlan instanceof BroadcastHashJoinExec;
                        return bl;
                    }
                });
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left7, "isEmpty", $org_scalatest_assert_macro_left7.isEmpty(), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"BroadcastHashJoin still planned even though it is switched off", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1372));
                Seq shj = ((Dataset)df.elem).queryExecution().sparkPlan().collect((PartialFunction)new scala.Serializable(null){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x5, Function1<A1, B1> function1) {
                        SortMergeJoinExec sortMergeJoinExec;
                        A1 A1 = x5;
                        Object object = A1 instanceof SortMergeJoinExec ? (sortMergeJoinExec = (SortMergeJoinExec)A1) : function1.apply(x5);
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(SparkPlan x5) {
                        SparkPlan sparkPlan = x5;
                        boolean bl = sparkPlan instanceof SortMergeJoinExec;
                        return bl;
                    }
                });
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)shj.size()));
                int $org_scalatest_assert_macro_right7 = 1;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"SortMergeJoinExec should be planned when BroadcastHashJoin is turned off", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1377));
                dataset = (Dataset)this.sql().apply((Object)new StringBuilder(5).append("SET ").append(SQLConf$.MODULE$.AUTO_BROADCASTJOIN_THRESHOLD().key()).append("=").append(tmp).toString());
            }
            return dataset;
        }, new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1338));
        this.test("Deals with wrong Hive's statistics (zero rowCount)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"maybe_big"}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)"CREATE TABLE maybe_big (c1 bigint)TBLPROPERTIES ('numRows'='0', 'rawDataSize'='60000000000', 'totalSize'='8000000000000')");
            CatalogTable catalogTable = this.getCatalogTable("maybe_big");
            scala.collection.immutable.Map properties = catalogTable.ignoredProperties();
            long $org_scalatest_assert_macro_left = new StringOps(Predef$.MODULE$.augmentString((String)properties.apply((Object)"totalSize"))).toLong();
            int $org_scalatest_assert_macro_right = 0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left > (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1393));
            long $org_scalatest_assert_macro_left2 = new StringOps(Predef$.MODULE$.augmentString((String)properties.apply((Object)"rawDataSize"))).toLong();
            int $org_scalatest_assert_macro_right2 = 0;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left2), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 > (long)$org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1394));
            long $org_scalatest_assert_macro_left3 = new StringOps(Predef$.MODULE$.augmentString((String)properties.apply((Object)"numRows"))).toLong();
            int $org_scalatest_assert_macro_right3 = 0;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == (long)$org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1395));
            CatalogStatistics catalogStats = (CatalogStatistics)catalogTable.stats().get();
            BigInt $org_scalatest_assert_macro_left4 = catalogStats.sizeInBytes();
            BigInt $org_scalatest_assert_macro_right4 = BigInt$.MODULE$.int2bigInt(0);
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, ">", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$greater((Object)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1398));
            Option $org_scalatest_assert_macro_left5 = catalogStats.rowCount();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left5, "isEmpty", $org_scalatest_assert_macro_left5.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1399));
        }), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1385));
        this.test(new StringBuilder(44).append("CTAS should update statistics if ").append(SQLConf$.MODULE$.AUTO_SIZE_UPDATE_ENABLED().key()).append(" is enabled").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String tableName = "SPARK_23263";
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{false, true}))).foreach((Function1 & Serializable & scala.Serializable)isConverted -> {
                StatisticsSuite.$anonfun$new$140(this, tableName, BoxesRunTime.unboxToBoolean((Object)isConverted));
                return BoxedUnit.UNIT;
            });
        }, new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1403));
        this.test("SPARK-28518 fix getDataSize refer to ChecksumFileSystem#isChecksumFile", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1 & Serializable & scala.Serializable)tempDir -> {
            this.withTable((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1"}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.spark().range(5L).write().mode(SaveMode.Overwrite).parquet(tempDir.getCanonicalPath());
                Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> new PrintWriter(new File(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)tempDir), "/temp.crc"))), (Function1 & Serializable & scala.Serializable)writer -> {
                    writer.write("1,2");
                    return BoxedUnit.UNIT;
                });
                $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(283).append("\n             |CREATE EXTERNAL TABLE t1(id BIGINT)\n             |STORED AS parquet\n             |LOCATION '").append(tempDir.getCanonicalPath()).append("'\n             |TBLPROPERTIES (\n             |'rawDataSize'='-1', 'numFiles'='0', 'totalSize'='0',\n             |'COLUMN_STATS_ACCURATE'='false', 'numRows'='-1'\n             |)").toString())).stripMargin());
                $this.spark().sql("REFRESH TABLE t1");
                LogicalPlan relation1 = (LogicalPlan)$this.spark().table("t1").queryExecution().analyzed().children().head();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(relation1.stats().sizeInBytes());
                long $org_scalatest_assert_macro_right = $this.getDataSize(tempDir);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1446));
                $this.spark().sql("REFRESH TABLE t1");
                $this.withSQLConf((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ENABLE_FALL_BACK_TO_HDFS_FOR_STATS().key()), (Object)"true")}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    LogicalPlan relation2 = (LogicalPlan)$this.spark().table("t1").queryExecution().analyzed().children().head();
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(relation2.stats().sizeInBytes());
                    long $org_scalatest_assert_macro_right = $this.getDataSize(tempDir);
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1451));
                });
            });
            return BoxedUnit.UNIT;
        }), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1425));
        this.test("fallBackToHdfs should not support Hive partitioned table", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, false}))).foreach((Function1 & Serializable & scala.Serializable)fallBackToHdfs -> {
            this.withSQLConf((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ENABLE_FALL_BACK_TO_HDFS_FOR_STATS().key()), (Object)String.valueOf(BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)fallBackToHdfs)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveUtils$.MODULE$.CONVERT_METASTORE_PARQUET().key()), (Object)"false")}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1 & Serializable & scala.Serializable)dir -> {
                StatisticsSuite.$anonfun$new$153($this, dir);
                return BoxedUnit.UNIT;
            }));
            return BoxedUnit.UNIT;
        }), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1457));
        this.test("SPARK-30269 failed to update partition stats if it's equal to table's old stats", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String tbl = "SPARK_30269";
            String ext_tbl = "SPARK_30269_external";
            this.withTempDir((Function1 & Serializable & scala.Serializable)dir -> {
                this.withTable((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tbl, ext_tbl}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    $this.sql().apply((Object)new StringBuilder(81).append("CREATE TABLE ").append(tbl$2).append(" (key INT, value STRING, ds STRING)").append("USING parquet PARTITIONED BY (ds)").toString());
                    $this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(167).append("\n             | CREATE TABLE ").append(ext_tbl$1).append(" (key INT, value STRING, ds STRING)\n             | USING PARQUET\n             | PARTITIONED BY (ds)\n             | LOCATION '").append(dir.toURI()).append("'\n           ").toString())).stripMargin());
                    ((IterableLike)new .colon.colon((Object)tbl$2, (List)new .colon.colon((Object)ext_tbl$1, (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)tblName -> {
                        $this.sql().apply((Object)new StringBuilder(42).append("INSERT INTO ").append((String)tblName).append(" VALUES (1, 'a', '2019-12-13')").toString());
                        int expectedSize = 657;
                        $this.sql().apply((Object)new StringBuilder(40).append("ANALYZE TABLE ").append((String)tblName).append(" COMPUTE STATISTICS NOSCAN").toString());
                        CatalogStatistics tableStats = $this.getTableStats((String)tblName);
                        BigInt $org_scalatest_assert_macro_left = tableStats.sizeInBytes();
                        int $org_scalatest_assert_macro_right = expectedSize;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), BoxesRunTime.equalsNumObject((Number)$org_scalatest_assert_macro_left, (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1509));
                        Option $org_scalatest_assert_macro_left2 = tableStats.rowCount();
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1510));
                        $this.sql().apply((Object)new StringBuilder(33).append("ANALYZE TABLE ").append((String)tblName).append(" COMPUTE STATISTICS").toString());
                        tableStats = $this.getTableStats((String)tblName);
                        BigInt $org_scalatest_assert_macro_left3 = tableStats.sizeInBytes();
                        int $org_scalatest_assert_macro_right2 = expectedSize;
                        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), BoxesRunTime.equalsNumObject((Number)$org_scalatest_assert_macro_left3, (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2)), Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1514));
                        BigInt $org_scalatest_assert_macro_left4 = (BigInt)tableStats.rowCount().get();
                        int $org_scalatest_assert_macro_right3 = 1;
                        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), BoxesRunTime.equalsNumObject((Number)$org_scalatest_assert_macro_left4, (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3)), Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1515));
                        $this.sql().apply((Object)new StringBuilder(68).append("ANALYZE TABLE ").append((String)tblName).append(" PARTITION (ds='2019-12-13') COMPUTE STATISTICS NOSCAN").toString());
                        CatalogStatistics partStats = $this.getPartitionStats((String)tblName, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ds"), (Object)"2019-12-13")})));
                        BigInt $org_scalatest_assert_macro_left5 = partStats.sizeInBytes();
                        int $org_scalatest_assert_macro_right4 = expectedSize;
                        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), BoxesRunTime.equalsNumObject((Number)$org_scalatest_assert_macro_left5, (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4)), Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1520));
                        Option $org_scalatest_assert_macro_left6 = partStats.rowCount();
                        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left6, "isEmpty", $org_scalatest_assert_macro_left6.isEmpty(), Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1521));
                        $this.sql().apply((Object)new StringBuilder(61).append("ANALYZE TABLE ").append((String)tblName).append(" PARTITION (ds='2019-12-13') COMPUTE STATISTICS").toString());
                        partStats = $this.getPartitionStats((String)tblName, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ds"), (Object)"2019-12-13")})));
                        BigInt $org_scalatest_assert_macro_left7 = partStats.sizeInBytes();
                        int $org_scalatest_assert_macro_right5 = expectedSize;
                        Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), BoxesRunTime.equalsNumObject((Number)$org_scalatest_assert_macro_left7, (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5)), Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1525));
                        BigInt $org_scalatest_assert_macro_left8 = (BigInt)partStats.rowCount().get();
                        int $org_scalatest_assert_macro_right6 = 1;
                        Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), BoxesRunTime.equalsNumObject((Number)$org_scalatest_assert_macro_left8, (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6)), Prettifier$.MODULE$.default());
                        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1526));
                    });
                });
                return BoxedUnit.UNIT;
            });
        }, new Position("StatisticsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1487));
    }
}

