/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.client;

import java.io.Serializable;
import java.sql.Date;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTable$;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition$;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.ExternalCatalogUtils$;
import org.apache.spark.sql.catalyst.dsl.package;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.In;
import org.apache.spark.sql.catalyst.expressions.InSet;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Not;
import org.apache.spark.sql.catalyst.expressions.package$;
import org.apache.spark.sql.hive.client.HiveClient;
import org.apache.spark.sql.hive.client.HiveVersionSuite;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005f\u0001\u0002\u000f\u001e\u0001)B\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\u0006\u0007\u0002!\t\u0001\u0012\u0005\b\u000f\u0002\u0011\r\u0011\"\u0003I\u0011\u0019\u0001\u0006\u0001)A\u0005\u0013\"9\u0011\u000b\u0001b\u0001\n\u0013\u0011\u0006BB,\u0001A\u0003%1\u000bC\u0004Y\u0001\t\u0007I\u0011B-\t\r\u0019\u0004\u0001\u0015!\u0003[\u0011\u001d9\u0007A1A\u0005\neCa\u0001\u001b\u0001!\u0002\u0013Q\u0006bB5\u0001\u0005\u0004%IA\u001b\u0005\u0007_\u0002\u0001\u000b\u0011B6\t\u000fA\u0004!\u0019!C\u0005U\"1\u0011\u000f\u0001Q\u0001\n-DqA\u001d\u0001C\u0002\u0013%!\u000e\u0003\u0004t\u0001\u0001\u0006Ia\u001b\u0005\bi\u0002\u0011\r\u0011\"\u0003v\u0011\u0019I\b\u0001)A\u0005m\"9!\u0010\u0001b\u0001\n\u0013Y\bbBA\u0005\u0001\u0001\u0006I\u0001 \u0005\b\u0003\u0017\u0001A\u0011BA\u0007\u0011\u001d\ty\u0002\u0001C\u0005\u0003CAq!a\r\u0001\t\u0003\n)\u0004C\u0004\u0002>\u0001!I!a\u0010\t\u000f\u0005u\u0002\u0001\"\u0003\u0002r!9\u0011Q\b\u0001\u0005\n\u0005%\u0005bBA\u001f\u0001\u0011%\u0011\u0011\u0014\u0002\u001c\u0011&4X\rU1si&$\u0018n\u001c8GS2$XM]5oON+\u0018\u000e^3\u000b\u0005yy\u0012AB2mS\u0016tGO\u0003\u0002!C\u0005!\u0001.\u001b<f\u0015\t\u00113%A\u0002tc2T!\u0001J\u0013\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u0019:\u0013AB1qC\u000eDWMC\u0001)\u0003\ry'oZ\u0002\u0001'\r\u00011f\f\t\u0003Y5j\u0011!H\u0005\u0003]u\u0011\u0001\u0003S5wKZ+'o]5p]N+\u0018\u000e^3\u0011\u0005A\u001aT\"A\u0019\u000b\u0005I:\u0013!C:dC2\fG/Z:u\u0013\t!\u0014GA\tCK\u001a|'/Z!oI\u00063G/\u001a:BY2\fqA^3sg&|g\u000e\u0005\u00028\u0001:\u0011\u0001H\u0010\t\u0003sqj\u0011A\u000f\u0006\u0003w%\na\u0001\u0010:p_Rt$\"A\u001f\u0002\u000bM\u001c\u0017\r\\1\n\u0005}b\u0014A\u0002)sK\u0012,g-\u0003\u0002B\u0005\n11\u000b\u001e:j]\u001eT!a\u0010\u001f\u0002\rqJg.\u001b;?)\t)e\t\u0005\u0002-\u0001!)QG\u0001a\u0001m\u0005yAO]=ESJ,7\r^*rY.+\u00170F\u0001J!\tQu*D\u0001L\u0015\taU*\u0001\u0003mC:<'\"\u0001(\u0002\t)\fg/Y\u0005\u0003\u0003.\u000b\u0001\u0003\u001e:z\t&\u0014Xm\u0019;Tc2\\U-\u001f\u0011\u0002!\u0011,g-Y;miB\u000b'\u000f^5uS>tW#A*\u0011\u0007Q+\u0016*D\u0001=\u0013\t1FH\u0001\u0004PaRLwN\\\u0001\u0012I\u00164\u0017-\u001e7u!\u0006\u0014H/\u001b;j_:\u0004\u0013a\u00023t-\u0006dW/Z\u000b\u00025B\u00111l\u0019\b\u00039\u0006l\u0011!\u0018\u0006\u0003=~\u000b\u0011\"[7nkR\f'\r\\3\u000b\u0005\u0001d\u0014AC2pY2,7\r^5p]&\u0011!-X\u0001\u0006%\u0006tw-Z\u0005\u0003I\u0016\u0014\u0011\"\u00138dYV\u001c\u0018N^3\u000b\u0005\tl\u0016\u0001\u00033t-\u0006dW/\u001a\u0011\u0002\r!4\u0016\r\\;f\u0003\u001dAg+\u00197vK\u0002\n!b\u00195v].4\u0016\r\\;f+\u0005Y\u0007c\u00017n\u00136\tq,\u0003\u0002o?\n\u00191+Z9\u0002\u0017\rDWO\\6WC2,X\rI\u0001\nI\u0006$XMV1mk\u0016\f!\u0002Z1uKZ\u000bG.^3!\u00031!\u0017\r^3TiJ4\u0016\r\\;f\u00035!\u0017\r^3TiJ4\u0016\r\\;fA\u0005\u0011B/Z:u!\u0006\u0014H/\u001b;j_:\u001cu.\u001e8u+\u00051\bC\u0001+x\u0013\tAHHA\u0002J]R\f1\u0003^3tiB\u000b'\u000f^5uS>t7i\\;oi\u0002\nQb\u001d;pe\u0006<WMR8s[\u0006$X#\u0001?\u0011\u0007u\f)!D\u0001\u007f\u0015\ry\u0018\u0011A\u0001\bG\u0006$\u0018\r\\8h\u0015\r\t\u0019!I\u0001\tG\u0006$\u0018\r\\=ti&\u0019\u0011q\u0001@\u0003)\r\u000bG/\u00197pON#xN]1hK\u001a{'/\\1u\u00039\u0019Ho\u001c:bO\u00164uN]7bi\u0002\nA!\u001b8jiR!\u0011qBA\u000b!\ra\u0013\u0011C\u0005\u0004\u0003'i\"A\u0003%jm\u0016\u001cE.[3oi\"9\u0011qC\u000bA\u0002\u0005e\u0011\u0001\u0004;ss\u0012K'/Z2u'Fd\u0007c\u0001+\u0002\u001c%\u0019\u0011Q\u0004\u001f\u0003\u000f\t{w\u000e\\3b]\u0006!\u0011\r\u001e;s)\u0011\t\u0019#a\f\u0011\t\u0005\u0015\u00121F\u0007\u0003\u0003OQA!!\u000b\u0002\u0002\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0013\u0011\ti#a\n\u0003\u0013\u0005#HO]5ckR,\u0007BBA\u0019-\u0001\u0007a'\u0001\u0003oC6,\u0017!\u00032fM>\u0014X-\u00117m)\t\t9\u0004E\u0002U\u0003sI1!a\u000f=\u0005\u0011)f.\u001b;\u0002?Q,7\u000f^'fi\u0006\u001cHo\u001c:f!\u0006\u0014H/\u001b;j_:4\u0015\u000e\u001c;fe&tw\r\u0006\b\u00028\u0005\u0005\u00131JA0\u0003G\nI'!\u001c\t\u000f\u0005\r\u0003\u00041\u0001\u0002F\u0005Qa-\u001b7uKJ,\u0005\u0010\u001d:\u0011\t\u0005\u0015\u0012qI\u0005\u0005\u0003\u0013\n9C\u0001\u0006FqB\u0014Xm]:j_:Dq!!\u0014\u0019\u0001\u0004\ty%\u0001\u0006fqB,7\r^3e\tN\u0004R!!\u0015\u0002\\YtA!a\u0015\u0002X9\u0019\u0011(!\u0016\n\u0003uJ1!!\u0017=\u0003\u001d\u0001\u0018mY6bO\u0016L1A\\A/\u0015\r\tI\u0006\u0010\u0005\b\u0003CB\u0002\u0019AA(\u0003%)\u0007\u0010]3di\u0016$\u0007\nC\u0004\u0002fa\u0001\r!a\u001a\u0002\u001d\u0015D\b/Z2uK\u0012\u001c\u0005.\u001e8lgB)\u0011\u0011KA.m!9\u00111\u000e\rA\u0002\u0005\u001d\u0014!C3ya\u0016\u001cG/\u001a3E\u0011\u001d\ty\u0007\u0007a\u0001\u0003O\nq\"\u001a=qK\u000e$X\r\u001a#bi\u0016\u001cHO\u001d\u000b\u0011\u0003o\t\u0019(!\u001e\u0002x\u0005e\u00141PA?\u0003\u007fBq!a\u0011\u001a\u0001\u0004\t)\u0005C\u0004\u0002Ne\u0001\r!a\u0014\t\u000f\u0005\u0005\u0014\u00041\u0001\u0002P!9\u0011QM\rA\u0002\u0005\u001d\u0004bBA63\u0001\u0007\u0011q\r\u0005\b\u0003_J\u0002\u0019AA4\u0011\u001d\t\t)\u0007a\u0001\u0003\u0007\u000b\u0011\u0002\u001e:b]N4wN]7\u0011\u000fQ\u000b))!\u0012\u0002F%\u0019\u0011q\u0011\u001f\u0003\u0013\u0019+hn\u0019;j_:\fDCBA\u001c\u0003\u0017\u000bi\tC\u0004\u0002Di\u0001\r!!\u0012\t\u000f\u0005=%\u00041\u0001\u0002\u0012\u00061R\r\u001f9fGR,G\rU1si&$\u0018n\u001c8Dk\n,7\u000f\u0005\u0004\u0002R\u0005m\u00131\u0013\t\u000e)\u0006U\u0015qJA(\u0003O\n9'a\u001a\n\u0007\u0005]EH\u0001\u0004UkBdW-\u000e\u000b\t\u0003o\tY*!(\u0002 \"9\u00111I\u000eA\u0002\u0005\u0015\u0003bBAH7\u0001\u0007\u0011\u0011\u0013\u0005\b\u0003\u0003[\u0002\u0019AAB\u0001")
public class HivePartitionFilteringSuite
extends HiveVersionSuite {
    private final String tryDirectSqlKey;
    private final Option<String> defaultPartition;
    private final Range.Inclusive dsValue;
    private final Range.Inclusive hValue;
    private final Seq<String> chunkValue;
    private final Seq<String> dateValue;
    private final Seq<String> dateStrValue;
    private final int testPartitionCount;
    private final CatalogStorageFormat storageFormat;

    private String tryDirectSqlKey() {
        return this.tryDirectSqlKey;
    }

    private Option<String> defaultPartition() {
        return this.defaultPartition;
    }

    private Range.Inclusive dsValue() {
        return this.dsValue;
    }

    private Range.Inclusive hValue() {
        return this.hValue;
    }

    private Seq<String> chunkValue() {
        return this.chunkValue;
    }

    private Seq<String> dateValue() {
        return this.dateValue;
    }

    private Seq<String> dateStrValue() {
        return this.dateStrValue;
    }

    private int testPartitionCount() {
        return this.testPartitionCount;
    }

    private CatalogStorageFormat storageFormat() {
        return this.storageFormat;
    }

    /*
     * WARNING - void declaration
     */
    private HiveClient init(boolean tryDirectSql) {
        void var3_3;
        IndexedSeq partitions;
        Configuration hadoopConf = new Configuration();
        hadoopConf.setBoolean(this.tryDirectSqlKey(), tryDirectSql);
        hadoopConf.set("hive.metastore.warehouse.dir", Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()).toURI().toString());
        HiveClient client = this.buildClient(hadoopConf);
        StructType tableSchema = new StructType().add("value", "int").add("ds", "int").add("h", "int").add("chunk", "string").add("d", "date").add("datestr", "string");
        TableIdentifier x$1 = new TableIdentifier("test", (Option)new Some((Object)"default"));
        CatalogTableType x$2 = CatalogTableType$.MODULE$.MANAGED();
        StructType x$3 = tableSchema;
        Seq x$4 = (Seq)new .colon.colon((Object)"ds", (List)new .colon.colon((Object)"h", (List)new .colon.colon((Object)"chunk", (List)new .colon.colon((Object)"d", (List)new .colon.colon((Object)"datestr", (List)Nil$.MODULE$)))));
        CatalogStorageFormat x$5 = this.storageFormat();
        Option x$6 = CatalogTable$.MODULE$.apply$default$5();
        Option x$7 = CatalogTable$.MODULE$.apply$default$7();
        String x$8 = CatalogTable$.MODULE$.apply$default$8();
        long x$9 = CatalogTable$.MODULE$.apply$default$9();
        long x$10 = CatalogTable$.MODULE$.apply$default$10();
        String x$11 = CatalogTable$.MODULE$.apply$default$11();
        Map x$12 = CatalogTable$.MODULE$.apply$default$12();
        Option x$13 = CatalogTable$.MODULE$.apply$default$13();
        Option x$14 = CatalogTable$.MODULE$.apply$default$14();
        Option x$15 = CatalogTable$.MODULE$.apply$default$15();
        Seq x$16 = CatalogTable$.MODULE$.apply$default$16();
        boolean x$17 = CatalogTable$.MODULE$.apply$default$17();
        boolean x$18 = CatalogTable$.MODULE$.apply$default$18();
        Map x$19 = CatalogTable$.MODULE$.apply$default$19();
        Option x$20 = CatalogTable$.MODULE$.apply$default$20();
        CatalogTable table = new CatalogTable(x$1, x$2, x$5, x$3, x$6, x$4, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        client.createTable(table, false);
        IndexedSeq $org_scalatest_assert_macro_left = partitions = (IndexedSeq)this.dsValue().flatMap((Function1 & Serializable & scala.Serializable)ds -> HivePartitionFilteringSuite.$anonfun$init$1(this, BoxesRunTime.unboxToInt((Object)ds)), IndexedSeq$.MODULE$.canBuildFrom());
        int $org_scalatest_assert_macro_right = this.testPartitionCount();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92));
        client.createPartitions("default", "test", (Seq)partitions, false);
        return var3_3;
    }

    private Attribute attr(String name) {
        Option option = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.client().getTable("default", "test").partitionSchema().fields())).find((Function1 & Serializable & scala.Serializable)field -> BoxesRunTime.boxToBoolean((boolean)HivePartitionFilteringSuite.$anonfun$attr$1(name, field)));
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw this.fail(new StringBuilder(37).append("Illegal name of partition attribute: ").append(name).toString(), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
            }
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        StructField field2 = (StructField)some.value();
        String x$1 = field2.name();
        DataType x$2 = field2.dataType();
        boolean x$3 = AttributeReference$.MODULE$.apply$default$3();
        Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$5 = AttributeReference$.MODULE$.apply$default$5(x$1, x$2, x$3, x$4);
        Seq x$6 = AttributeReference$.MODULE$.apply$default$6(x$1, x$2, x$3, x$4);
        AttributeReference attributeReference = new AttributeReference(x$1, x$2, x$3, x$4, x$5, x$6);
        return attributeReference;
    }

    public void beforeAll() {
        super.beforeAll();
        this.client_$eq(this.init(true));
    }

    private void testMetastorePartitionFiltering(Expression filterExpr, Seq<Object> expectedDs, Seq<Object> expectedH, Seq<String> expectedChunks, Seq<String> expectedD, Seq<String> expectedDatestr) {
        Tuple5 tuple5 = new Tuple5(expectedDs, expectedH, expectedChunks, expectedD, expectedDatestr);
        this.testMetastorePartitionFiltering(filterExpr, (Seq<Tuple5<Seq<Object>, Seq<Object>, Seq<String>, Seq<String>, Seq<String>>>)Nil$.MODULE$.$colon$colon((Object)tuple5), (Function1<Expression, Expression>)(Function1 & Serializable & scala.Serializable)x -> (Expression)Predef$.MODULE$.identity(x));
    }

    private void testMetastorePartitionFiltering(Expression filterExpr, Seq<Object> expectedDs, Seq<Object> expectedH, Seq<String> expectedChunks, Seq<String> expectedD, Seq<String> expectedDatestr, Function1<Expression, Expression> transform) {
        Tuple5 tuple5 = new Tuple5(expectedDs, expectedH, expectedChunks, expectedD, expectedDatestr);
        this.testMetastorePartitionFiltering(filterExpr, (Seq<Tuple5<Seq<Object>, Seq<Object>, Seq<String>, Seq<String>, Seq<String>>>)Nil$.MODULE$.$colon$colon((Object)tuple5), transform);
    }

    private void testMetastorePartitionFiltering(Expression filterExpr, Seq<Tuple5<Seq<Object>, Seq<Object>, Seq<String>, Seq<String>, Seq<String>>> expectedPartitionCubes) {
        this.testMetastorePartitionFiltering(filterExpr, expectedPartitionCubes, (Function1<Expression, Expression>)(Function1 & Serializable & scala.Serializable)x -> (Expression)Predef$.MODULE$.identity(x));
    }

    private void testMetastorePartitionFiltering(Expression filterExpr, Seq<Tuple5<Seq<Object>, Seq<Object>, Seq<String>, Seq<String>, Seq<String>>> expectedPartitionCubes, Function1<Expression, Expression> transform) {
        int actualFilteredPartitionCount;
        Seq filteredPartitions = this.client().getPartitionsByFilter(this.client().getTable("default", "test"), (Seq)new .colon.colon((Object)((Expression)transform.apply((Object)filterExpr)), (List)Nil$.MODULE$));
        int expectedPartitionCount = BoxesRunTime.unboxToInt((Object)((TraversableOnce)expectedPartitionCubes.map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)HivePartitionFilteringSuite.$anonfun$testMetastorePartitionFiltering$3(x0$1)), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Seq expectedPartitions = (Seq)((TraversableOnce)expectedPartitionCubes.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple5 tuple5 = x0$2;
            if (tuple5 == null) {
                throw new MatchError((Object)tuple5);
            }
            Seq expectedDs = (Seq)tuple5._1();
            Seq expectedH = (Seq)tuple5._2();
            Seq expectedChunks = (Seq)tuple5._3();
            Seq expectedD = (Seq)tuple5._4();
            Seq expectedDatestr = (Seq)tuple5._5();
            Seq seq = (Seq)expectedDs.flatMap((Function1 & Serializable & scala.Serializable)ds -> HivePartitionFilteringSuite.$anonfun$testMetastorePartitionFiltering$5(expectedH, expectedChunks, expectedD, expectedDatestr, BoxesRunTime.unboxToInt((Object)ds)), Seq$.MODULE$.canBuildFrom());
            return seq;
        }, Seq$.MODULE$.canBuildFrom())).reduce((Function2 & Serializable & scala.Serializable)(x$17, x$18) -> (Seq)x$17.$plus$plus((GenTraversableOnce)x$18, Seq$.MODULE$.canBuildFrom()));
        int $org_scalatest_assert_macro_left = actualFilteredPartitionCount = filteredPartitions.size();
        int $org_scalatest_assert_macro_right = expectedPartitionCount;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(29).append("Expected ").append(expectedPartitionCount).append(" partitions but got ").append(actualFilteredPartitionCount).toString(), Prettifier$.MODULE$.default(), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 633));
        Set $org_scalatest_assert_macro_left2 = ((TraversableOnce)filteredPartitions.map((Function1 & Serializable & scala.Serializable)x$19 -> x$19.spec().toSet(), Seq$.MODULE$.canBuildFrom())).toSet();
        Set $org_scalatest_assert_macro_right2 = expectedPartitions.toSet();
        Set set = $org_scalatest_assert_macro_left2;
        Set set2 = $org_scalatest_assert_macro_right2;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 635));
    }

    public static final /* synthetic */ Seq $anonfun$init$2(HivePartitionFilteringSuite $this, int ds$1, int h) {
        return (Seq)$this.chunkValue().flatMap((Function1 & Serializable & scala.Serializable)chunk -> (Seq)$this.dateValue().flatMap((Function1 & Serializable & scala.Serializable)date -> (Seq)$this.dateStrValue().map((Function1 & Serializable & scala.Serializable)dateStr -> new CatalogTablePartition((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ds"), (Object)Integer.toString(ds$1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"h"), (Object)Integer.toString(h)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"chunk"), chunk), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"d"), date), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"datestr"), dateStr)})), $this.storageFormat(), CatalogTablePartition$.MODULE$.apply$default$3(), CatalogTablePartition$.MODULE$.apply$default$4(), CatalogTablePartition$.MODULE$.apply$default$5(), CatalogTablePartition$.MODULE$.apply$default$6()), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ IndexedSeq $anonfun$init$1(HivePartitionFilteringSuite $this, int ds) {
        return (IndexedSeq)$this.hValue().flatMap((Function1 & Serializable & scala.Serializable)h -> HivePartitionFilteringSuite.$anonfun$init$2($this, ds, BoxesRunTime.unboxToInt((Object)h)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ boolean $anonfun$attr$1(String name$1, StructField field) {
        return field.name().equals(name$1);
    }

    private final void check$1(Expression condition, Seq result) {
        this.testMetastorePartitionFiltering(condition, (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), (Seq<String>)result, this.dateValue(), this.dateStrValue());
    }

    private final void check$2(Expression condition, Seq result) {
        this.testMetastorePartitionFiltering(condition, (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), this.chunkValue(), (Seq<String>)result, this.dateStrValue());
    }

    public static final /* synthetic */ int $anonfun$testMetastorePartitionFiltering$3(Tuple5 x0$1) {
        Tuple5 tuple5 = x0$1;
        if (tuple5 == null) {
            throw new MatchError((Object)tuple5);
        }
        Seq expectedDs = (Seq)tuple5._1();
        Seq expectedH = (Seq)tuple5._2();
        Seq expectedChunks = (Seq)tuple5._3();
        Seq expectedD = (Seq)tuple5._4();
        Seq expectedDatestr = (Seq)tuple5._5();
        int n = expectedDs.size() * expectedH.size() * expectedChunks.size() * expectedD.size() * expectedDatestr.size();
        return n;
    }

    public static final /* synthetic */ Seq $anonfun$testMetastorePartitionFiltering$6(Seq expectedChunks$1, Seq expectedD$1, Seq expectedDatestr$1, int ds$2, int h) {
        return (Seq)expectedChunks$1.flatMap((Function1 & Serializable & scala.Serializable)chunk -> (Seq)expectedD$1.flatMap((Function1 & Serializable & scala.Serializable)d -> (Seq)expectedDatestr$1.map((Function1 & Serializable & scala.Serializable)datestr -> (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ds"), (Object)Integer.toString(ds$2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"h"), (Object)Integer.toString(h)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"chunk"), chunk), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"d"), d), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"datestr"), datestr)})), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ Seq $anonfun$testMetastorePartitionFiltering$5(Seq expectedH$1, Seq expectedChunks$1, Seq expectedD$1, Seq expectedDatestr$1, int ds) {
        return (Seq)expectedH$1.flatMap((Function1 & Serializable & scala.Serializable)h -> HivePartitionFilteringSuite.$anonfun$testMetastorePartitionFiltering$6(expectedChunks$1, expectedD$1, expectedDatestr$1, ds, BoxesRunTime.unboxToInt((Object)h)), Seq$.MODULE$.canBuildFrom());
    }

    public HivePartitionFilteringSuite(String version) {
        super(version);
        this.tryDirectSqlKey = HiveConf.ConfVars.METASTORE_TRY_DIRECT_SQL.varname;
        this.defaultPartition = new StringOps(Predef$.MODULE$.augmentString(version)).$greater$eq((Object)"2.0") ? new Some((Object)ExternalCatalogUtils$.MODULE$.DEFAULT_PARTITION_NAME()) : None$.MODULE$;
        this.dsValue = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(20170101), 20170103);
        this.hValue = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 4);
        this.chunkValue = (Seq)new .colon.colon((Object)"aa", (List)new .colon.colon((Object)"ab", (List)new .colon.colon((Object)"ba", (List)new .colon.colon((Object)"bb", (List)Nil$.MODULE$))));
        this.dateValue = (Seq)((TraversableLike)new .colon.colon((Object)"2019-01-01", (List)new .colon.colon((Object)"2019-01-02", (List)new .colon.colon((Object)"2019-01-03", (List)Nil$.MODULE$)))).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(this.defaultPartition()), Seq$.MODULE$.canBuildFrom());
        this.dateStrValue = (Seq)new .colon.colon((Object)"2020-01-01", (List)new .colon.colon((Object)"2020-01-02", (List)new .colon.colon((Object)"2020-01-03", (List)Nil$.MODULE$)));
        this.testPartitionCount = this.dsValue().size() * this.hValue().size() * this.chunkValue().size() * this.dateValue().size() * this.dateStrValue().size();
        this.storageFormat = new CatalogStorageFormat((Option)None$.MODULE$, (Option)new Some((Object)TextInputFormat.class.getName()), (Option)new Some((Object)HiveIgnoreKeyTextOutputFormat.class.getName()), (Option)new Some((Object)LazySimpleSerDe.class.getName()), false, Predef$.MODULE$.Map().empty());
        this.test(new StringBuilder(56).append("getPartitionsByFilter returns all partitions when ").append(this.tryDirectSqlKey()).append("=false").toString(), (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            Seq filteredPartitions;
            HiveClient client = this.init(false);
            Seq $org_scalatest_assert_macro_left = filteredPartitions = client.getPartitionsByFilter(client.getTable("default", "test"), (Seq)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(20170101)), (List)Nil$.MODULE$));
            int $org_scalatest_assert_macro_right = this.testPartitionCount();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
        }, new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113));
        this.test("getPartitionsByFilter: ds<=>20170101", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$less$eq$greater((Expression)package.expressions$.MODULE$.intToLiteral(20170101)), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), this.chunkValue(), this.dateValue(), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 121));
        this.test("getPartitionsByFilter: ds=20170101", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(20170101)), (Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(20170101), 20170101), (Seq<Object>)this.hValue(), this.chunkValue(), this.dateValue(), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132));
        this.test("getPartitionsByFilter: ds=(20170101 + 1) and h=0", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$eq$eq$eq(package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)20170101))).$plus((Expression)package.expressions$.MODULE$.intToLiteral(1)))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("h")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(0))), (Seq<Object>)this.dsValue(), (Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 0), this.chunkValue(), this.dateValue(), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 142));
        this.test("getPartitionsByFilter: chunk='aa'", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String string = "aa";
            this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("chunk")).$eq$eq$eq((Expression)package.expressions$.MODULE$.stringToLiteral("aa")), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), (Seq<String>)Nil$.MODULE$.$colon$colon((Object)string), this.dateValue(), this.dateStrValue());
        }, new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154));
        this.test("getPartitionsByFilter: cast(chunk as int)=1 (not a valid partition predicate)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression((Expression)this.attr("chunk")).cast((DataType)IntegerType$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1)), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), this.chunkValue(), this.dateValue(), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 164));
        this.test("getPartitionsByFilter: cast(chunk as boolean)=true (not a valid partition predicate)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression((Expression)this.attr("chunk")).cast((DataType)BooleanType$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.booleanToLiteral(true)), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), this.chunkValue(), this.dateValue(), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 174));
        this.test("getPartitionsByFilter: 20170101=ds", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)20170101))).$eq$eq$eq((Expression)this.attr("ds")), (Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(20170101), 20170101), (Seq<Object>)this.hValue(), this.chunkValue(), this.dateValue(), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 184));
        this.test("getPartitionsByFilter: ds=20170101 and h=2", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(20170101))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("h")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(2))), (Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(20170101), 20170101), (Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(2), 2), this.chunkValue(), this.dateValue(), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 194));
        this.test("getPartitionsByFilter: cast(ds as long)=20170101L and h=2", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).cast((DataType)LongType$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.longToLiteral(20170101L))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("h")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(2))), (Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(20170101), 20170101), (Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(2), 2), this.chunkValue(), this.dateValue(), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 204));
        this.test("getPartitionsByFilter: ds=20170101 or ds=20170102", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(20170101))).$bar$bar((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(20170102))), (Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(20170101), 20170102), (Seq<Object>)this.hValue(), this.chunkValue(), this.dateValue(), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 214));
        this.test("getPartitionsByFilter: ds in (20170102, 20170103) (using IN expression)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering(package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).in((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.intToLiteral(20170102), package.expressions$.MODULE$.intToLiteral(20170103)})), (Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(20170102), 20170103), (Seq<Object>)this.hValue(), this.chunkValue(), this.dateValue(), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 224));
        this.test("getPartitionsByFilter: cast(ds as long) in (20170102L, 20170103L) (using IN expression)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering(package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).cast((DataType)LongType$.MODULE$)).in((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.longToLiteral(20170102L), package.expressions$.MODULE$.longToLiteral(20170103L)})), (Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(20170102), 20170103), (Seq<Object>)this.hValue(), this.chunkValue(), this.dateValue(), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 234));
        this.test("getPartitionsByFilter: ds in (20170102, 20170103) (using INSET expression)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering(package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).in((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.intToLiteral(20170102), package.expressions$.MODULE$.intToLiteral(20170103)})), (Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(20170102), 20170103), (Seq<Object>)this.hValue(), this.chunkValue(), this.dateValue(), this.dateStrValue(), (Function1<Expression, Expression>)(Function1 & Serializable & scala.Serializable)x0$1 -> {
            Seq list;
            Expression v;
            block3: {
                Expression expression;
                block2: {
                    expression = x0$1;
                    if (!(expression instanceof In)) break block2;
                    In in = (In)expression;
                    v = in.value();
                    list = in.list();
                    if (in.inSetConvertible()) break block3;
                }
                throw new MatchError((Object)expression);
            }
            InSet inSet = new InSet(v, ((TraversableOnce)list.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.eval(package$.MODULE$.EmptyRow()), Seq$.MODULE$.canBuildFrom())).toSet());
            return inSet;
        }), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 244));
        this.test("getPartitionsByFilter: cast(ds as long) in (20170102L, 20170103L) (using INSET expression)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering(package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).cast((DataType)LongType$.MODULE$)).in((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.longToLiteral(20170102L), package.expressions$.MODULE$.longToLiteral(20170103L)})), (Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(20170102), 20170103), (Seq<Object>)this.hValue(), this.chunkValue(), this.dateValue(), this.dateStrValue(), (Function1<Expression, Expression>)(Function1 & Serializable & scala.Serializable)x0$2 -> {
            Seq list;
            Expression v;
            block3: {
                Expression expression;
                block2: {
                    expression = x0$2;
                    if (!(expression instanceof In)) break block2;
                    In in = (In)expression;
                    v = in.value();
                    list = in.list();
                    if (in.inSetConvertible()) break block3;
                }
                throw new MatchError((Object)expression);
            }
            InSet inSet = new InSet(v, ((TraversableOnce)list.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.eval(package$.MODULE$.EmptyRow()), Seq$.MODULE$.canBuildFrom())).toSet());
            return inSet;
        }), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 258));
        this.test("getPartitionsByFilter: chunk in ('ab', 'ba') (using IN expression)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String string = "ab";
            String string2 = "ba";
            this.testMetastorePartitionFiltering(package.expressions$.MODULE$.DslExpression((Expression)this.attr("chunk")).in((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.stringToLiteral("ab"), package.expressions$.MODULE$.stringToLiteral("ba")})), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), (Seq<String>)Nil$.MODULE$.$colon$colon((Object)string2).$colon$colon((Object)string), this.dateValue(), this.dateStrValue());
        }, new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 271));
        this.test("getPartitionsByFilter: chunk in ('ab', 'ba') (using INSET expression)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String string = "ab";
            String string2 = "ba";
            this.testMetastorePartitionFiltering(package.expressions$.MODULE$.DslExpression((Expression)this.attr("chunk")).in((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.stringToLiteral("ab"), package.expressions$.MODULE$.stringToLiteral("ba")})), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), (Seq<String>)Nil$.MODULE$.$colon$colon((Object)string2).$colon$colon((Object)string), this.dateValue(), this.dateStrValue(), (Function1<Expression, Expression>)(Function1 & Serializable & scala.Serializable)x0$3 -> {
                Seq list;
                Expression v;
                block3: {
                    Expression expression;
                    block2: {
                        expression = x0$3;
                        if (!(expression instanceof In)) break block2;
                        In in = (In)expression;
                        v = in.value();
                        list = in.list();
                        if (in.inSetConvertible()) break block3;
                    }
                    throw new MatchError((Object)expression);
                }
                InSet inSet = new InSet(v, ((TraversableOnce)list.map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.eval(package$.MODULE$.EmptyRow()), Seq$.MODULE$.canBuildFrom())).toSet());
                return inSet;
            });
        }, new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 281));
        this.test("getPartitionsByFilter: (ds=20170101 and h>=2) or (ds=20170102 and h<2)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Tuple5 day1 = new Tuple5((Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(20170101), 20170101), (Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(2), 4), this.chunkValue(), this.dateValue(), this.dateStrValue());
            Tuple5 day2 = new Tuple5((Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(20170102), 20170102), (Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 1), this.chunkValue(), this.dateValue(), this.dateStrValue());
            Tuple5 tuple5 = day1;
            Tuple5 tuple52 = day2;
            this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(20170101))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("h")).$greater$eq((Expression)package.expressions$.MODULE$.intToLiteral(2)))).$bar$bar((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(20170102))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("h")).$less((Expression)package.expressions$.MODULE$.intToLiteral(2)))), (Seq<Tuple5<Seq<Object>, Seq<Object>, Seq<String>, Seq<String>, Seq<String>>>)Nil$.MODULE$.$colon$colon((Object)tuple52).$colon$colon((Object)tuple5));
        }, new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 294));
        this.test("getPartitionsByFilter: (ds=20170101 and h>=2) or (ds=20170102 and h<(1+1))", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Tuple5 day1 = new Tuple5((Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(20170101), 20170101), (Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(2), 4), this.chunkValue(), this.dateValue(), this.dateStrValue());
            Tuple5 day2 = new Tuple5((Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(20170102), 20170102), (Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 4), this.chunkValue(), this.dateValue(), this.dateStrValue());
            Tuple5 tuple5 = day1;
            Tuple5 tuple52 = day2;
            this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(20170101))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("h")).$greater$eq((Expression)package.expressions$.MODULE$.intToLiteral(2)))).$bar$bar((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(20170102))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("h")).$less(package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))).$plus((Expression)package.expressions$.MODULE$.intToLiteral(1))))), (Seq<Tuple5<Seq<Object>, Seq<Object>, Seq<String>, Seq<String>, Seq<String>>>)Nil$.MODULE$.$colon$colon((Object)tuple52).$colon$colon((Object)tuple5));
        }, new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 301));
        this.test("getPartitionsByFilter: chunk in ('ab', 'ba') and ((ds=20170101 and h>=2) or (ds=20170102 and h<2))", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Tuple5 day1 = new Tuple5((Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(20170101), 20170101), (Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(2), 4), (Object)new .colon.colon((Object)"ab", (List)new .colon.colon((Object)"ba", (List)Nil$.MODULE$)), this.dateValue(), this.dateStrValue());
            Tuple5 day2 = new Tuple5((Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(20170102), 20170102), (Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 1), (Object)new .colon.colon((Object)"ab", (List)new .colon.colon((Object)"ba", (List)Nil$.MODULE$)), this.dateValue(), this.dateStrValue());
            Tuple5 tuple5 = day1;
            Tuple5 tuple52 = day2;
            this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression((Expression)this.attr("chunk")).in((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.stringToLiteral("ab"), package.expressions$.MODULE$.stringToLiteral("ba")}))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(20170101))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("h")).$greater$eq((Expression)package.expressions$.MODULE$.intToLiteral(2)))).$bar$bar((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(20170102))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("h")).$less((Expression)package.expressions$.MODULE$.intToLiteral(2))))), (Seq<Tuple5<Seq<Object>, Seq<Object>, Seq<String>, Seq<String>, Seq<String>>>)Nil$.MODULE$.$colon$colon((Object)tuple52).$colon$colon((Object)tuple5));
        }, new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 310));
        this.test("getPartitionsByFilter: chunk contains bb", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering(package.expressions$.MODULE$.DslExpression((Expression)this.attr("chunk")).contains((Expression)package.expressions$.MODULE$.stringToLiteral("bb")), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), (Seq<String>)((Seq)new .colon.colon((Object)"bb", (List)Nil$.MODULE$)), this.dateValue(), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 318));
        this.test("getPartitionsByFilter: chunk startsWith b", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering(package.expressions$.MODULE$.DslExpression((Expression)this.attr("chunk")).startsWith((Expression)package.expressions$.MODULE$.stringToLiteral("b")), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), (Seq<String>)((Seq)new .colon.colon((Object)"ba", (List)new .colon.colon((Object)"bb", (List)Nil$.MODULE$))), this.dateValue(), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 328));
        this.test("getPartitionsByFilter: chunk endsWith b", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering(package.expressions$.MODULE$.DslExpression((Expression)this.attr("chunk")).endsWith((Expression)package.expressions$.MODULE$.stringToLiteral("b")), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), (Seq<String>)((Seq)new .colon.colon((Object)"ab", (List)new .colon.colon((Object)"bb", (List)Nil$.MODULE$))), this.dateValue(), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 338));
        this.test("getPartitionsByFilter: chunk in ('ab', 'ba') and ((cast(ds as string)>'20170102')", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression((Expression)this.attr("chunk")).in((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.stringToLiteral("ab"), package.expressions$.MODULE$.stringToLiteral("ba")}))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).cast((DataType)StringType$.MODULE$)).$greater((Expression)package.expressions$.MODULE$.stringToLiteral("20170102"))), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), (Seq<String>)((Seq)new .colon.colon((Object)"ab", (List)new .colon.colon((Object)"ba", (List)Nil$.MODULE$))), this.dateValue(), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 348));
        this.test("getPartitionsByFilter: ds<>20170101", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$eq$bang$eq((Expression)package.expressions$.MODULE$.intToLiteral(20170101)), (Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(20170102), 20170103), (Seq<Object>)this.hValue(), this.chunkValue(), this.dateValue(), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 358));
        this.test("getPartitionsByFilter: h<>0 and chunk<>ab and d<>2019-01-01", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("h")).$eq$bang$eq((Expression)package.expressions$.MODULE$.intToLiteral(0))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("chunk")).$eq$bang$eq((Expression)package.expressions$.MODULE$.stringToLiteral("ab")))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("d")).$eq$bang$eq((Expression)package.expressions$.MODULE$.dateToLiteral(Date.valueOf("2019-01-01")))), (Seq<Object>)this.dsValue(), (Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 4), (Seq<String>)((Seq)new .colon.colon((Object)"aa", (List)new .colon.colon((Object)"ba", (List)new .colon.colon((Object)"bb", (List)Nil$.MODULE$)))), (Seq<String>)((Seq)new .colon.colon((Object)"2019-01-02", (List)new .colon.colon((Object)"2019-01-03", (List)Nil$.MODULE$))), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 368));
        this.test("getPartitionsByFilter: d=2019-01-01", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("d")).$eq$eq$eq((Expression)package.expressions$.MODULE$.dateToLiteral(Date.valueOf("2019-01-01"))), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), this.chunkValue(), (Seq<String>)((Seq)new .colon.colon((Object)"2019-01-01", (List)Nil$.MODULE$)), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 378));
        this.test("getPartitionsByFilter: d>2019-01-02", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("d")).$greater((Expression)package.expressions$.MODULE$.dateToLiteral(Date.valueOf("2019-01-02"))), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), this.chunkValue(), (Seq<String>)((Seq)new .colon.colon((Object)"2019-01-03", (List)Nil$.MODULE$)), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 388));
        this.test("getPartitionsByFilter: In(d, 2019-01-01, 2019-01-02)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering((Expression)new In((Expression)this.attr("d"), (Seq)((TraversableLike)new .colon.colon((Object)"2019-01-01", (List)new .colon.colon((Object)"2019-01-02", (List)Nil$.MODULE$))).map((Function1 & Serializable & scala.Serializable)d -> Literal$.MODULE$.apply((Object)Date.valueOf(d)), Seq$.MODULE$.canBuildFrom())), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), this.chunkValue(), (Seq<String>)((Seq)new .colon.colon((Object)"2019-01-01", (List)new .colon.colon((Object)"2019-01-02", (List)Nil$.MODULE$))), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 398));
        this.test("getPartitionsByFilter: InSet(d, 2019-01-01, 2019-01-02)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering((Expression)new InSet((Expression)this.attr("d"), (Set)((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2019-01-01", "2019-01-02"}))).map((Function1 & Serializable & scala.Serializable)d -> Literal$.MODULE$.apply((Object)Date.valueOf(d)).eval(package$.MODULE$.EmptyRow()), Set$.MODULE$.canBuildFrom())), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), this.chunkValue(), (Seq<String>)((Seq)new .colon.colon((Object)"2019-01-01", (List)new .colon.colon((Object)"2019-01-02", (List)Nil$.MODULE$))), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 409));
        this.test("getPartitionsByFilter: not in/inset string type", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.check$1((Expression)new Not((Expression)new In((Expression)this.attr("chunk"), (Seq)new .colon.colon((Object)Literal$.MODULE$.apply((Object)"aa"), (List)new .colon.colon((Object)Literal$.MODULE$.apply((Object)"ab"), (List)Nil$.MODULE$)))), (Seq)new .colon.colon((Object)"ba", (List)new .colon.colon((Object)"bb", (List)Nil$.MODULE$)));
            this.check$1((Expression)new Not((Expression)new In((Expression)this.attr("chunk"), (Seq)new .colon.colon((Object)Literal$.MODULE$.apply((Object)"aa"), (List)new .colon.colon((Object)Literal$.MODULE$.apply((Object)"ab"), (List)new .colon.colon((Object)Literal$.MODULE$.apply(null), (List)Nil$.MODULE$))))), this.chunkValue());
            Object[] objectArray = new Object[2];
            Literal qual$1 = Literal$.MODULE$.apply((Object)"aa");
            InternalRow x$1 = qual$1.eval$default$1();
            objectArray[0] = qual$1.eval(x$1);
            Literal qual$2 = Literal$.MODULE$.apply((Object)"ab");
            InternalRow x$2 = qual$2.eval$default$1();
            objectArray[1] = qual$2.eval(x$2);
            this.check$1((Expression)new Not((Expression)new InSet((Expression)this.attr("chunk"), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.genericWrapArray((Object)objectArray)))), (Seq)new .colon.colon((Object)"ba", (List)new .colon.colon((Object)"bb", (List)Nil$.MODULE$)));
            this.check$1((Expression)new Not((Expression)new InSet((Expression)this.attr("chunk"), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"aa", "ab", null})))), this.chunkValue());
        }, new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 420));
        this.test("getPartitionsByFilter: not in/inset date type", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.check$2((Expression)new Not((Expression)new In((Expression)this.attr("d"), (Seq)new .colon.colon((Object)Literal$.MODULE$.apply((Object)Date.valueOf("2019-01-01")), (List)new .colon.colon((Object)Literal$.MODULE$.apply((Object)Date.valueOf("2019-01-02")), (List)Nil$.MODULE$)))), (Seq)new .colon.colon((Object)"2019-01-03", (List)Nil$.MODULE$));
            this.check$2((Expression)new Not((Expression)new In((Expression)this.attr("d"), (Seq)new .colon.colon((Object)Literal$.MODULE$.apply((Object)Date.valueOf("2019-01-01")), (List)new .colon.colon((Object)Literal$.MODULE$.apply((Object)Date.valueOf("2019-01-02")), (List)new .colon.colon((Object)Literal$.MODULE$.apply(null), (List)Nil$.MODULE$))))), this.dateValue());
            Object[] objectArray = new Object[2];
            Literal qual$3 = Literal$.MODULE$.apply((Object)Date.valueOf("2019-01-01"));
            InternalRow x$3 = qual$3.eval$default$1();
            objectArray[0] = qual$3.eval(x$3);
            Literal qual$4 = Literal$.MODULE$.apply((Object)Date.valueOf("2019-01-02"));
            InternalRow x$4 = qual$4.eval$default$1();
            objectArray[1] = qual$4.eval(x$4);
            this.check$2((Expression)new Not((Expression)new InSet((Expression)this.attr("d"), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.genericWrapArray((Object)objectArray)))), (Seq)new .colon.colon((Object)"2019-01-03", (List)Nil$.MODULE$));
            Object[] objectArray2 = new Object[3];
            Literal qual$5 = Literal$.MODULE$.apply((Object)Date.valueOf("2019-01-01"));
            InternalRow x$5 = qual$5.eval$default$1();
            objectArray2[0] = qual$5.eval(x$5);
            Literal qual$6 = Literal$.MODULE$.apply((Object)Date.valueOf("2019-01-02"));
            InternalRow x$6 = qual$6.eval$default$1();
            objectArray2[1] = qual$6.eval(x$6);
            objectArray2[2] = null;
            this.check$2((Expression)new Not((Expression)new InSet((Expression)this.attr("d"), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.genericWrapArray((Object)objectArray2)))), this.dateValue());
        }, new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 451));
        this.test("getPartitionsByFilter: cast(datestr as date)= 2020-01-01", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression((Expression)this.attr("datestr")).cast((DataType)DateType$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.dateToLiteral(Date.valueOf("2020-01-01"))), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), this.chunkValue(), this.dateValue(), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 490));
        this.test("getPartitionsByFilter: IS NULL / IS NOT NULL", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression((Expression)this.attr("d")).isNull(), (List)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression((Expression)this.attr("d")).isNotNull(), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)filterExpr -> {
            this.testMetastorePartitionFiltering((Expression)filterExpr, (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), this.chunkValue(), this.dateValue(), this.dateStrValue());
            return BoxedUnit.UNIT;
        }), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 500));
        this.test("getPartitionsByFilter: IS NULL / IS NOT NULL with other filter", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression((Expression)this.attr("d")).isNull(), (List)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression((Expression)this.attr("d")).isNotNull(), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)filterExpr -> {
            this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)filterExpr).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("d")).$eq$eq$eq((Expression)package.expressions$.MODULE$.dateToLiteral(Date.valueOf("2019-01-01")))), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), this.chunkValue(), (Seq<String>)((Seq)new .colon.colon((Object)"2019-01-01", (List)Nil$.MODULE$)), this.dateStrValue());
            return BoxedUnit.UNIT;
        }), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 513));
        this.test("getPartitionsByFilter: d =!= 2019-01-01", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("d")).$eq$bang$eq((Expression)package.expressions$.MODULE$.dateToLiteral(Date.valueOf("2019-01-01"))), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), this.chunkValue(), (Seq<String>)((Seq)new .colon.colon((Object)"2019-01-02", (List)new .colon.colon((Object)"2019-01-03", (List)Nil$.MODULE$))), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 525));
        this.test("getPartitionsByFilter: d =!= 2019-01-01 || IS NULL", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("d")).$eq$bang$eq((Expression)package.expressions$.MODULE$.dateToLiteral(Date.valueOf("2019-01-01")))).$bar$bar((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("d")).isNull()), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), this.chunkValue(), this.dateValue(), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 535));
        this.test("getPartitionsByFilter: d <=> 2019-01-01", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("d")).$less$eq$greater((Expression)package.expressions$.MODULE$.dateToLiteral(Date.valueOf("2019-01-01"))), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), this.chunkValue(), this.dateValue(), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 545));
        this.test("getPartitionsByFilter: d <=> null", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("d")).$less$eq$greater((Expression)new Literal(null, (DataType)DateType$.MODULE$)), (Seq<Object>)this.dsValue(), (Seq<Object>)this.hValue(), this.chunkValue(), this.dateValue(), this.dateStrValue()), new Position("HivePartitionFilteringSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 555));
    }
}

