/*
 * Decompiled with CFR 0.152.
 */
package org.eep_custom.orc.impl.reader;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eep_custom.orc.EncryptionAlgorithm;
import org.eep_custom.orc.EncryptionKey;
import org.eep_custom.orc.OrcProto;
import org.eep_custom.orc.impl.HadoopShims;
import org.eep_custom.orc.impl.reader.ReaderEncryptionVariant;
import org.jetbrains.annotations.NotNull;

public class ReaderEncryptionKey
implements EncryptionKey {
    private final String name;
    private final int version;
    private final EncryptionAlgorithm algorithm;
    private final List<ReaderEncryptionVariant> roots = new ArrayList<ReaderEncryptionVariant>();
    private State state = State.UNTRIED;

    public ReaderEncryptionKey(OrcProto.EncryptionKey key) {
        this.name = key.getKeyName();
        this.version = key.getKeyVersion();
        this.algorithm = EncryptionAlgorithm.fromSerialization(key.getAlgorithm().getNumber());
    }

    @Override
    public String getKeyName() {
        return this.name;
    }

    @Override
    public int getKeyVersion() {
        return this.version;
    }

    @Override
    public EncryptionAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public ReaderEncryptionVariant[] getEncryptionRoots() {
        return this.roots.toArray(new ReaderEncryptionVariant[this.roots.size()]);
    }

    public HadoopShims.KeyMetadata getMetadata() {
        return new HadoopShims.KeyMetadata(this.name, this.version, this.algorithm);
    }

    public State getState() {
        return this.state;
    }

    public void setFailure() {
        this.state = State.FAILURE;
    }

    public void setSuccess() {
        if (this.state == State.FAILURE) {
            throw new IllegalStateException("Key " + this.name + " had already failed.");
        }
        this.state = State.SUCCESS;
    }

    void addVariant(ReaderEncryptionVariant newVariant) {
        this.roots.add(newVariant);
    }

    public boolean equals(Object other) {
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        if (other == this) {
            return true;
        }
        return this.compareTo((EncryptionKey)other) == 0;
    }

    public int hashCode() {
        return this.name.hashCode() * 127 + this.version * 7 + this.algorithm.hashCode();
    }

    @Override
    public int compareTo(@NotNull EncryptionKey other) {
        int result = this.name.compareTo(other.getKeyName());
        if (result == 0) {
            result = Integer.compare(this.version, other.getKeyVersion());
        }
        return result;
    }

    public String toString() {
        return this.name + "@" + this.version + " w/ " + (Object)((Object)this.algorithm);
    }

    @Override
    public boolean isAvailable() {
        if (this.getState() == State.SUCCESS) {
            return true;
        }
        if (this.getState() == State.UNTRIED && this.roots.size() > 0) {
            try {
                return this.roots.get(0).getFileFooterKey() != null;
            }
            catch (IOException ioe) {
                this.setFailure();
            }
        }
        return false;
    }

    public static enum State {
        UNTRIED,
        FAILURE,
        SUCCESS;

    }
}

