/*
 * Decompiled with CFR 0.152.
 */
package org.eep_custom.orc.impl.mask;

import org.eep_custom.orc.DataMask;
import org.eep_custom.orc.DataMaskDescription;
import org.eep_custom.orc.TypeDescription;
import org.eep_custom.orc.impl.mask.NullifyMask;
import org.eep_custom.orc.impl.mask.RedactMaskFactory;
import org.eep_custom.orc.impl.mask.SHA256MaskFactory;

public class MaskProvider
implements DataMask.Provider {
    @Override
    public DataMask build(DataMaskDescription description, TypeDescription schema, DataMask.MaskOverrides overrides) {
        String name = description.getName();
        if (name.equals(DataMask.Standard.NULLIFY.getName())) {
            return new NullifyMask();
        }
        if (name.equals(DataMask.Standard.REDACT.getName())) {
            return new RedactMaskFactory(description.getParameters()).build(schema, overrides);
        }
        if (name.equals(DataMask.Standard.SHA256.getName())) {
            return new SHA256MaskFactory().build(schema, overrides);
        }
        return null;
    }
}

