/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive;

import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.hive.serde2.avro.AvroSerdeException;
import org.apache.hadoop.hive.serde2.avro.InstanceCache;
import org.junit.Assert;
import org.junit.Test;

public class JavaTableReaderSuite {
    private static InstanceCache<String, Wrapper<String>> instanceCache = new InstanceCache<String, Wrapper<String>>(){

        protected Wrapper<String> makeInstance(String hv, Set<String> seenSchemas) {
            return new Wrapper<String>(hv);
        }
    };
    private static volatile Wrapper<String> cachedInstance;
    private static volatile String key;
    private static AtomicBoolean failed;
    private static AtomicBoolean succeed;

    @Test
    public void instanceCacheMustBeThreadSafe() throws Exception {
        new Thread(() -> {
            long valueGetterThreadStarted = System.currentTimeMillis();
            while (!failed.get() && !succeed.get()) {
                Wrapper retrievedInstance = null;
                try {
                    retrievedInstance = (Wrapper)instanceCache.retrieve((Object)key, null);
                }
                catch (AvroSerdeException e) {
                    e.printStackTrace();
                }
                if (cachedInstance != null) {
                    if (cachedInstance != retrievedInstance) {
                        failed.set(true);
                    } else {
                        key = String.valueOf(System.currentTimeMillis());
                        cachedInstance = null;
                    }
                }
                if (System.currentTimeMillis() - valueGetterThreadStarted < 3000L) continue;
                succeed.set(true);
            }
        }).start();
        while (!failed.get() && !succeed.get()) {
            if (cachedInstance != null) continue;
            cachedInstance = (Wrapper)instanceCache.retrieve((Object)key, null);
        }
        if (failed.get()) {
            Assert.fail((String)"InstanceCache is not thread safe");
        }
    }

    static {
        key = "key1";
        failed = new AtomicBoolean(false);
        succeed = new AtomicBoolean(false);
    }

    private static class Wrapper<T> {
        final T wrapped;

        private Wrapper(T wrapped) {
            this.wrapped = wrapped;
        }
    }
}

