/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.QueryTest;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.hive.client.HiveClient;
import org.apache.spark.sql.hive.test.TestHiveContext;
import org.apache.spark.sql.hive.test.TestHiveSingleton;
import org.apache.spark.sql.test.SQLTestData;
import org.apache.spark.sql.test.SQLTestData$internalImplicits$;
import org.apache.spark.sql.test.SQLTestUtils;
import org.apache.spark.sql.test.SQLTestUtilsBase;
import org.apache.spark.sql.test.SQLTestUtilsBase$testImplicits$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import org.scalatest.concurrent.AbstractPatienceConfiguration;
import org.scalatest.concurrent.AbstractPatienceConfiguration$PatienceConfig$;
import org.scalatest.concurrent.Eventually;
import org.scalatest.concurrent.PatienceConfiguration;
import org.scalatest.concurrent.ScaledTimeSpans;
import org.scalatest.enablers.Retrying;
import org.scalatest.funsuite.AnyFunSuiteLike;
import org.scalatest.time.Span;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001m3AAB\u0004\u0001%!)!\u0005\u0001C\u0001G!Aa\u0005\u0001EC\u0002\u0013%q\u0005C\u00030\u0001\u0011%\u0001\u0007C\u0003G\u0001\u0011%q\tC\u0004P\u0001E\u0005I\u0011\u0002)\u0003%5+H\u000e^5ECR\f'-Y:f'VLG/\u001a\u0006\u0003\u0011%\tA\u0001[5wK*\u0011!bC\u0001\u0004gFd'B\u0001\u0007\u000e\u0003\u0015\u0019\b/\u0019:l\u0015\tqq\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002!\u0005\u0019qN]4\u0004\u0001M!\u0001aE\f\u001e!\t!R#D\u0001\n\u0013\t1\u0012BA\u0005Rk\u0016\u0014\u0018\u0010V3tiB\u0011\u0001dG\u0007\u00023)\u0011!$C\u0001\u0005i\u0016\u001cH/\u0003\u0002\u001d3\ta1+\u0015'UKN$X\u000b^5mgB\u0011a\u0004I\u0007\u0002?)\u0011!dB\u0005\u0003C}\u0011\u0011\u0003V3ti\"Kg/Z*j]\u001edW\r^8o\u0003\u0019a\u0014N\\5u}Q\tA\u0005\u0005\u0002&\u00015\tq!\u0001\u0002eMV\t\u0001\u0006\u0005\u0002*Y9\u0011ACK\u0005\u0003W%\tq\u0001]1dW\u0006<W-\u0003\u0002.]\tIA)\u0019;b\rJ\fW.\u001a\u0006\u0003W%\tab\u00195fG.$\u0016M\u00197f!\u0006$\b\u000eF\u00022o\u0011\u0003\"AM\u001b\u000e\u0003MR\u0011\u0001N\u0001\u0006g\u000e\fG.Y\u0005\u0003mM\u0012A!\u00168ji\")\u0001h\u0001a\u0001s\u00051AM\u0019(b[\u0016\u0004\"AO!\u000f\u0005mz\u0004C\u0001\u001f4\u001b\u0005i$B\u0001 \u0012\u0003\u0019a$o\\8u}%\u0011\u0001iM\u0001\u0007!J,G-\u001a4\n\u0005\t\u001b%AB*ue&twM\u0003\u0002Ag!)Qi\u0001a\u0001s\u0005IA/\u00192mK:\u000bW.Z\u0001\u000eO\u0016$H+\u00192mK:\u000bW.Z:\u0015\u0005![\u0005c\u0001\u001aJs%\u0011!j\r\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\bq\u0011\u0001\n\u00111\u0001M!\r\u0011T*O\u0005\u0003\u001dN\u0012aa\u00149uS>t\u0017aF4fiR\u000b'\r\\3OC6,7\u000f\n3fM\u0006,H\u000e\u001e\u00132+\u0005\t&F\u0001'SW\u0005\u0019\u0006C\u0001+Z\u001b\u0005)&B\u0001,X\u0003%)hn\u00195fG.,GM\u0003\u0002Yg\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005i+&!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class MultiDatabaseSuite
extends QueryTest
implements SQLTestUtils,
TestHiveSingleton {
    private Dataset<Row> df;
    private final boolean enableAutoThreadAudit;
    private final SparkSession spark;
    private final TestHiveContext hiveContext;
    private final HiveClient hiveClient;
    private boolean org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests;
    private Function1<String, Dataset<Row>> sql;
    private volatile SQLTestUtilsBase$testImplicits$ testImplicits$module;
    private volatile SQLTestData$internalImplicits$ internalImplicits$module;
    private Dataset<Row> emptyTestData;
    private Dataset<Row> testData;
    private Dataset<Row> testData2;
    private Dataset<Row> testData3;
    private Dataset<Row> negativeData;
    private Dataset<Row> largeAndSmallInts;
    private Dataset<Row> decimalData;
    private Dataset<Row> binaryData;
    private Dataset<Row> upperCaseData;
    private Dataset<Row> lowerCaseData;
    private Dataset<Row> lowerCaseDataWithDuplicates;
    private RDD<SQLTestData.ArrayData> arrayData;
    private RDD<SQLTestData.MapData> mapData;
    private RDD<SQLTestData.IntervalData> calendarIntervalData;
    private RDD<SQLTestData.StringData> repeatedData;
    private RDD<SQLTestData.StringData> nullableRepeatedData;
    private Dataset<Row> nullInts;
    private Dataset<Row> allNulls;
    private Dataset<Row> nullStrings;
    private Dataset<Row> tableName;
    private RDD<String> unparsedStrings;
    private RDD<SQLTestData.IntField> withEmptyParts;
    private Dataset<Row> person;
    private Dataset<Row> salary;
    private Dataset<Row> complexData;
    private Dataset<Row> courseSales;
    private Dataset<Row> trainingSales;
    private Dataset<Row> intervalData;
    private final AbstractPatienceConfiguration.PatienceConfig org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig;
    private volatile AbstractPatienceConfiguration$PatienceConfig$ PatienceConfig$module;
    private volatile int bitmap$0;

    @Override
    public /* synthetic */ void org$apache$spark$sql$hive$test$TestHiveSingleton$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public void afterAll() {
        TestHiveSingleton.afterAll$(this);
    }

    public /* synthetic */ void org$apache$spark$sql$test$SQLTestUtils$$super$beforeAll() {
        super.beforeAll();
    }

    public /* synthetic */ void org$apache$spark$sql$test$SQLTestUtils$$super$withTempDir(Function1 f) {
        super.withTempDir(f);
    }

    public /* synthetic */ void org$apache$spark$sql$test$SQLTestUtils$$super$test(String testName, Seq testTags, Function0 testFun, Position pos) {
        AnyFunSuiteLike.test$((AnyFunSuiteLike)this, (String)testName, (Seq)testTags, (Function0)testFun, (Position)pos);
    }

    public void beforeAll() {
        SQLTestUtils.beforeAll$((SQLTestUtils)this);
    }

    public void withTempDir(Function1<File, BoxedUnit> f) {
        SQLTestUtils.withTempDir$((SQLTestUtils)this, f);
    }

    public void testWithWholeStageCodegenOnAndOff(String testName, Function1<String, BoxedUnit> f) {
        SQLTestUtils.testWithWholeStageCodegenOnAndOff$((SQLTestUtils)this, (String)testName, f);
    }

    public void setupTestData() {
        SQLTestUtils.setupTestData$((SQLTestUtils)this);
    }

    public void testQuietly(String name, Function0<BoxedUnit> f) {
        SQLTestUtils.testQuietly$((SQLTestUtils)this, (String)name, f);
    }

    public void test(String testName, Seq<Tag> testTags, Function0<Object> testFun, Position pos) {
        SQLTestUtils.test$((SQLTestUtils)this, (String)testName, testTags, testFun, (Position)pos);
    }

    public void testWithUninterruptibleThread(String name, boolean quietly, Function0<BoxedUnit> body) {
        SQLTestUtils.testWithUninterruptibleThread$((SQLTestUtils)this, (String)name, (boolean)quietly, body);
    }

    public boolean testWithUninterruptibleThread$default$2() {
        return SQLTestUtils.testWithUninterruptibleThread$default$2$((SQLTestUtils)this);
    }

    public void withResourceTempPath(String resourcePath, Function1<File, BoxedUnit> f) {
        SQLTestUtils.withResourceTempPath$((SQLTestUtils)this, (String)resourcePath, f);
    }

    public void waitForTasksToFinish() {
        SQLTestUtils.waitForTasksToFinish$((SQLTestUtils)this);
    }

    public void withTempPaths(int numPaths, Function1<Seq<File>, BoxedUnit> f) {
        SQLTestUtils.withTempPaths$((SQLTestUtils)this, (int)numPaths, f);
    }

    public /* synthetic */ void org$apache$spark$sql$test$SQLTestUtilsBase$$super$withSQLConf(Seq pairs, Function0 f) {
        SQLHelper.withSQLConf$((SQLHelper)this, (Seq)pairs, (Function0)f);
    }

    public SparkContext sparkContext() {
        return SQLTestUtilsBase.sparkContext$((SQLTestUtilsBase)this);
    }

    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withSQLConf$((SQLTestUtilsBase)this, pairs, f);
    }

    public void withUserDefinedFunction(Seq<Tuple2<String, Object>> functions, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withUserDefinedFunction$((SQLTestUtilsBase)this, functions, f);
    }

    public void withTempView(Seq<String> viewNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withTempView$((SQLTestUtilsBase)this, viewNames, f);
    }

    public void withGlobalTempView(Seq<String> viewNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withGlobalTempView$((SQLTestUtilsBase)this, viewNames, f);
    }

    public void withTable(Seq<String> tableNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withTable$((SQLTestUtilsBase)this, tableNames, f);
    }

    public void withView(Seq<String> viewNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withView$((SQLTestUtilsBase)this, viewNames, f);
    }

    public void withCache(Seq<String> cacheNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withCache$((SQLTestUtilsBase)this, cacheNames, f);
    }

    public void uncacheTable(String tableName) {
        SQLTestUtilsBase.uncacheTable$((SQLTestUtilsBase)this, (String)tableName);
    }

    public void withTempDatabase(Function1<String, BoxedUnit> f) {
        SQLTestUtilsBase.withTempDatabase$((SQLTestUtilsBase)this, f);
    }

    public void withDatabase(Seq<String> dbNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withDatabase$((SQLTestUtilsBase)this, dbNames, f);
    }

    public void withNamespace(Seq<String> namespaces, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withNamespace$((SQLTestUtilsBase)this, namespaces, f);
    }

    public void withLocale(String language, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withLocale$((SQLTestUtilsBase)this, (String)language, f);
    }

    public void activateDatabase(String db, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.activateDatabase$((SQLTestUtilsBase)this, (String)db, f);
    }

    public Dataset<Row> stripSparkFilter(Dataset<Row> df) {
        return SQLTestUtilsBase.stripSparkFilter$((SQLTestUtilsBase)this, df);
    }

    public Dataset<Row> logicalPlanToSparkQuery(LogicalPlan plan) {
        return SQLTestUtilsBase.logicalPlanToSparkQuery$((SQLTestUtilsBase)this, (LogicalPlan)plan);
    }

    public URI makeQualifiedPath(String path) {
        return SQLTestUtilsBase.makeQualifiedPath$((SQLTestUtilsBase)this, (String)path);
    }

    public String testFile(String fileName) {
        return SQLTestUtilsBase.testFile$((SQLTestUtilsBase)this, (String)fileName);
    }

    public long getLocalDirSize(File file) {
        return SQLTestUtilsBase.getLocalDirSize$((SQLTestUtilsBase)this, (File)file);
    }

    public void loadTestData() {
        SQLTestData.loadTestData$((SQLTestData)this);
    }

    public <T> T eventually(PatienceConfiguration.Timeout timeout, PatienceConfiguration.Interval interval, Function0<T> fun, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Timeout)timeout, (PatienceConfiguration.Interval)interval, fun, retrying, (Position)pos);
    }

    public <T> T eventually(PatienceConfiguration.Timeout timeout, Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Timeout)timeout, fun, (AbstractPatienceConfiguration.PatienceConfig)config, retrying, (Position)pos);
    }

    public <T> T eventually(PatienceConfiguration.Interval interval, Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Interval)interval, fun, (AbstractPatienceConfiguration.PatienceConfig)config, retrying, (Position)pos);
    }

    public <T> T eventually(Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, fun, (AbstractPatienceConfiguration.PatienceConfig)config, retrying, (Position)pos);
    }

    public AbstractPatienceConfiguration.PatienceConfig patienceConfig() {
        return PatienceConfiguration.patienceConfig$((PatienceConfiguration)this);
    }

    public PatienceConfiguration.Timeout timeout(Span value) {
        return PatienceConfiguration.timeout$((PatienceConfiguration)this, (Span)value);
    }

    public PatienceConfiguration.Interval interval(Span value) {
        return PatienceConfiguration.interval$((PatienceConfiguration)this, (Span)value);
    }

    public final Span scaled(Span span) {
        return ScaledTimeSpans.scaled$((ScaledTimeSpans)this, (Span)span);
    }

    public double spanScaleFactor() {
        return ScaledTimeSpans.spanScaleFactor$((ScaledTimeSpans)this);
    }

    @Override
    public boolean enableAutoThreadAudit() {
        return this.enableAutoThreadAudit;
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public TestHiveContext hiveContext() {
        return this.hiveContext;
    }

    @Override
    public HiveClient hiveClient() {
        return this.hiveClient;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$enableAutoThreadAudit_$eq(boolean x$1) {
        this.enableAutoThreadAudit = x$1;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$hiveContext_$eq(TestHiveContext x$1) {
        this.hiveContext = x$1;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$hiveClient_$eq(HiveClient x$1) {
        this.hiveClient = x$1;
    }

    public boolean org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests() {
        return this.org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests;
    }

    public void org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests_$eq(boolean x$1) {
        this.org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests = x$1;
    }

    private Function1<String, Dataset<Row>> sql$lzycompute() {
        MultiDatabaseSuite multiDatabaseSuite = this;
        synchronized (multiDatabaseSuite) {
            if ((this.bitmap$0 & 2) == 0) {
                this.sql = SQLTestUtilsBase.sql$((SQLTestUtilsBase)this);
                this.bitmap$0 |= 2;
            }
        }
        return this.sql;
    }

    public Function1<String, Dataset<Row>> sql() {
        return (this.bitmap$0 & 2) == 0 ? this.sql$lzycompute() : this.sql;
    }

    public SQLTestUtilsBase$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    public SQLTestData$internalImplicits$ org$apache$spark$sql$test$SQLTestData$$internalImplicits() {
        if (this.internalImplicits$module == null) {
            this.org$apache$spark$sql$test$SQLTestData$$internalImplicits$lzycompute$1();
        }
        return this.internalImplicits$module;
    }

    private Dataset<Row> emptyTestData$lzycompute() {
        MultiDatabaseSuite multiDatabaseSuite = this;
        synchronized (multiDatabaseSuite) {
            if ((this.bitmap$0 & 4) == 0) {
                this.emptyTestData = SQLTestData.emptyTestData$((SQLTestData)this);
                this.bitmap$0 |= 4;
            }
        }
        return this.emptyTestData;
    }

    public Dataset<Row> emptyTestData() {
        return (this.bitmap$0 & 4) == 0 ? this.emptyTestData$lzycompute() : this.emptyTestData;
    }

    private Dataset<Row> testData$lzycompute() {
        MultiDatabaseSuite multiDatabaseSuite = this;
        synchronized (multiDatabaseSuite) {
            if ((this.bitmap$0 & 8) == 0) {
                this.testData = SQLTestData.testData$((SQLTestData)this);
                this.bitmap$0 |= 8;
            }
        }
        return this.testData;
    }

    public Dataset<Row> testData() {
        return (this.bitmap$0 & 8) == 0 ? this.testData$lzycompute() : this.testData;
    }

    private Dataset<Row> testData2$lzycompute() {
        MultiDatabaseSuite multiDatabaseSuite = this;
        synchronized (multiDatabaseSuite) {
            if ((this.bitmap$0 & 0x10) == 0) {
                this.testData2 = SQLTestData.testData2$((SQLTestData)this);
                this.bitmap$0 |= 0x10;
            }
        }
        return this.testData2;
    }

    public Dataset<Row> testData2() {
        return (this.bitmap$0 & 0x10) == 0 ? this.testData2$lzycompute() : this.testData2;
    }

    private Dataset<Row> testData3$lzycompute() {
        MultiDatabaseSuite multiDatabaseSuite = this;
        synchronized (multiDatabaseSuite) {
            if ((this.bitmap$0 & 0x20) == 0) {
                this.testData3 = SQLTestData.testData3$((SQLTestData)this);
                this.bitmap$0 |= 0x20;
            }
        }
        return this.testData3;
    }

    public Dataset<Row> testData3() {
        return (this.bitmap$0 & 0x20) == 0 ? this.testData3$lzycompute() : this.testData3;
    }

    private Dataset<Row> negativeData$lzycompute() {
        MultiDatabaseSuite multiDatabaseSuite = this;
        synchronized (multiDatabaseSuite) {
            if ((this.bitmap$0 & 0x40) == 0) {
                this.negativeData = SQLTestData.negativeData$((SQLTestData)this);
                this.bitmap$0 |= 0x40;
            }
        }
        return this.negativeData;
    }

    public Dataset<Row> negativeData() {
        return (this.bitmap$0 & 0x40) == 0 ? this.negativeData$lzycompute() : this.negativeData;
    }

    private Dataset<Row> largeAndSmallInts$lzycompute() {
        MultiDatabaseSuite multiDatabaseSuite = this;
        synchronized (multiDatabaseSuite) {
            if ((this.bitmap$0 & 0x80) == 0) {
                this.largeAndSmallInts = SQLTestData.largeAndSmallInts$((SQLTestData)this);
                this.bitmap$0 |= 0x80;
            }
        }
        return this.largeAndSmallInts;
    }

    public Dataset<Row> largeAndSmallInts() {
        return (this.bitmap$0 & 0x80) == 0 ? this.largeAndSmallInts$lzycompute() : this.largeAndSmallInts;
    }

    private Dataset<Row> decimalData$lzycompute() {
        MultiDatabaseSuite multiDatabaseSuite = this;
        synchronized (multiDatabaseSuite) {
            if ((this.bitmap$0 & 0x100) == 0) {
                this.decimalData = SQLTestData.decimalData$((SQLTestData)this);
                this.bitmap$0 |= 0x100;
            }
        }
        return this.decimalData;
    }

    public Dataset<Row> decimalData() {
        return (this.bitmap$0 & 0x100) == 0 ? this.decimalData$lzycompute() : this.decimalData;
    }

    private Dataset<Row> binaryData$lzycompute() {
        MultiDatabaseSuite multiDatabaseSuite = this;
        synchronized (multiDatabaseSuite) {
            if ((this.bitmap$0 & 0x200) == 0) {
                this.binaryData = SQLTestData.binaryData$((SQLTestData)this);
                this.bitmap$0 |= 0x200;
            }
        }
        return this.binaryData;
    }

    public Dataset<Row> binaryData() {
        return (this.bitmap$0 & 0x200) == 0 ? this.binaryData$lzycompute() : this.binaryData;
    }

    private Dataset<Row> upperCaseData$lzycompute() {
        MultiDatabaseSuite multiDatabaseSuite = this;
        synchronized (multiDatabaseSuite) {
            if ((this.bitmap$0 & 0x400) == 0) {
                this.upperCaseData = SQLTestData.upperCaseData$((SQLTestData)this);
                this.bitmap$0 |= 0x400;
            }
        }
        return this.upperCaseData;
    }

    public Dataset<Row> upperCaseData() {
        return (this.bitmap$0 & 0x400) == 0 ? this.upperCaseData$lzycompute() : this.upperCaseData;
    }

    private Dataset<Row> lowerCaseData$lzycompute() {
        MultiDatabaseSuite multiDatabaseSuite = this;
        synchronized (multiDatabaseSuite) {
            if ((this.bitmap$0 & 0x800) == 0) {
                this.lowerCaseData = SQLTestData.lowerCaseData$((SQLTestData)this);
                this.bitmap$0 |= 0x800;
            }
        }
        return this.lowerCaseData;
    }

    public Dataset<Row> lowerCaseData() {
        return (this.bitmap$0 & 0x800) == 0 ? this.lowerCaseData$lzycompute() : this.lowerCaseData;
    }

    private Dataset<Row> lowerCaseDataWithDuplicates$lzycompute() {
        MultiDatabaseSuite multiDatabaseSuite = this;
        synchronized (multiDatabaseSuite) {
            if ((this.bitmap$0 & 0x1000) == 0) {
                this.lowerCaseDataWithDuplicates = SQLTestData.lowerCaseDataWithDuplicates$((SQLTestData)this);
                this.bitmap$0 |= 0x1000;
            }
        }
        return this.lowerCaseDataWithDuplicates;
    }

    public Dataset<Row> lowerCaseDataWithDuplicates() {
        return (this.bitmap$0 & 0x1000) == 0 ? this.lowerCaseDataWithDuplicates$lzycompute() : this.lowerCaseDataWithDuplicates;
    }

    private RDD<SQLTestData.ArrayData> arrayData$lzycompute() {
        MultiDatabaseSuite multiDatabaseSuite = this;
        synchronized (multiDatabaseSuite) {
            if ((this.bitmap$0 & 0x2000) == 0) {
                this.arrayData = SQLTestData.arrayData$((SQLTestData)this);
                this.bitmap$0 |= 0x2000;
            }
        }
        return this.arrayData;
    }

    public RDD<SQLTestData.ArrayData> arrayData() {
        return (this.bitmap$0 & 0x2000) == 0 ? this.arrayData$lzycompute() : this.arrayData;
    }

    private RDD<SQLTestData.MapData> mapData$lzycompute() {
        MultiDatabaseSuite multiDatabaseSuite = this;
        synchronized (multiDatabaseSuite) {
            if ((this.bitmap$0 & 0x4000) == 0) {
                this.mapData = SQLTestData.mapData$((SQLTestData)this);
                this.bitmap$0 |= 0x4000;
            }
        }
        return this.mapData;
    }

    public RDD<SQLTestData.MapData> mapData() {
        return (this.bitmap$0 & 0x4000) == 0 ? this.mapData$lzycompute() : this.mapData;
    }

    private RDD<SQLTestData.IntervalData> calendarIntervalData$lzycompute() {
        MultiDatabaseSuite multiDatabaseSuite = this;
        synchronized (multiDatabaseSuite) {
            if ((this.bitmap$0 & 0x8000) == 0) {
                this.calendarIntervalData = SQLTestData.calendarIntervalData$((SQLTestData)this);
                this.bitmap$0 |= 0x8000;
            }
        }
        return this.calendarIntervalData;
    }

    public RDD<SQLTestData.IntervalData> calendarIntervalData() {
        return (this.bitmap$0 & 0x8000) == 0 ? this.calendarIntervalData$lzycompute() : this.calendarIntervalData;
    }

    private RDD<SQLTestData.StringData> repeatedData$lzycompute() {
        MultiDatabaseSuite multiDatabaseSuite = this;
        synchronized (multiDatabaseSuite) {
            if ((this.bitmap$0 & 0x10000) == 0) {
                this.repeatedData = SQLTestData.repeatedData$((SQLTestData)this);
                this.bitmap$0 |= 0x10000;
            }
        }
        return this.repeatedData;
    }

    public RDD<SQLTestData.StringData> repeatedData() {
        return (this.bitmap$0 & 0x10000) == 0 ? this.repeatedData$lzycompute() : this.repeatedData;
    }

    private RDD<SQLTestData.StringData> nullableRepeatedData$lzycompute() {
        MultiDatabaseSuite multiDatabaseSuite = this;
        synchronized (multiDatabaseSuite) {
            if ((this.bitmap$0 & 0x20000) == 0) {
                this.nullableRepeatedData = SQLTestData.nullableRepeatedData$((SQLTestData)this);
                this.bitmap$0 |= 0x20000;
            }
        }
        return this.nullableRepeatedData;
    }

    public RDD<SQLTestData.StringData> nullableRepeatedData() {
        return (this.bitmap$0 & 0x20000) == 0 ? this.nullableRepeatedData$lzycompute() : this.nullableRepeatedData;
    }

    private Dataset<Row> nullInts$lzycompute() {
        MultiDatabaseSuite multiDatabaseSuite = this;
        synchronized (multiDatabaseSuite) {
            if ((this.bitmap$0 & 0x40000) == 0) {
                this.nullInts = SQLTestData.nullInts$((SQLTestData)this);
                this.bitmap$0 |= 0x40000;
            }
        }
        return this.nullInts;
    }

    public Dataset<Row> nullInts() {
        return (this.bitmap$0 & 0x40000) == 0 ? this.nullInts$lzycompute() : this.nullInts;
    }

    private Dataset<Row> allNulls$lzycompute() {
        MultiDatabaseSuite multiDatabaseSuite = this;
        synchronized (multiDatabaseSuite) {
            if ((this.bitmap$0 & 0x80000) == 0) {
                this.allNulls = SQLTestData.allNulls$((SQLTestData)this);
                this.bitmap$0 |= 0x80000;
            }
        }
        return this.allNulls;
    }

    public Dataset<Row> allNulls() {
        return (this.bitmap$0 & 0x80000) == 0 ? this.allNulls$lzycompute() : this.allNulls;
    }

    private Dataset<Row> nullStrings$lzycompute() {
        MultiDatabaseSuite multiDatabaseSuite = this;
        synchronized (multiDatabaseSuite) {
            if ((this.bitmap$0 & 0x100000) == 0) {
                this.nullStrings = SQLTestData.nullStrings$((SQLTestData)this);
                this.bitmap$0 |= 0x100000;
            }
        }
        return this.nullStrings;
    }

    public Dataset<Row> nullStrings() {
        return (this.bitmap$0 & 0x100000) == 0 ? this.nullStrings$lzycompute() : this.nullStrings;
    }

    private Dataset<Row> tableName$lzycompute() {
        MultiDatabaseSuite multiDatabaseSuite = this;
        synchronized (multiDatabaseSuite) {
            if ((this.bitmap$0 & 0x200000) == 0) {
                this.tableName = SQLTestData.tableName$((SQLTestData)this);
                this.bitmap$0 |= 0x200000;
            }
        }
        return this.tableName;
    }

    public Dataset<Row> tableName() {
        return (this.bitmap$0 & 0x200000) == 0 ? this.tableName$lzycompute() : this.tableName;
    }

    private RDD<String> unparsedStrings$lzycompute() {
        MultiDatabaseSuite multiDatabaseSuite = this;
        synchronized (multiDatabaseSuite) {
            if ((this.bitmap$0 & 0x400000) == 0) {
                this.unparsedStrings = SQLTestData.unparsedStrings$((SQLTestData)this);
                this.bitmap$0 |= 0x400000;
            }
        }
        return this.unparsedStrings;
    }

    public RDD<String> unparsedStrings() {
        return (this.bitmap$0 & 0x400000) == 0 ? this.unparsedStrings$lzycompute() : this.unparsedStrings;
    }

    private RDD<SQLTestData.IntField> withEmptyParts$lzycompute() {
        MultiDatabaseSuite multiDatabaseSuite = this;
        synchronized (multiDatabaseSuite) {
            if ((this.bitmap$0 & 0x800000) == 0) {
                this.withEmptyParts = SQLTestData.withEmptyParts$((SQLTestData)this);
                this.bitmap$0 |= 0x800000;
            }
        }
        return this.withEmptyParts;
    }

    public RDD<SQLTestData.IntField> withEmptyParts() {
        return (this.bitmap$0 & 0x800000) == 0 ? this.withEmptyParts$lzycompute() : this.withEmptyParts;
    }

    private Dataset<Row> person$lzycompute() {
        MultiDatabaseSuite multiDatabaseSuite = this;
        synchronized (multiDatabaseSuite) {
            if ((this.bitmap$0 & 0x1000000) == 0) {
                this.person = SQLTestData.person$((SQLTestData)this);
                this.bitmap$0 |= 0x1000000;
            }
        }
        return this.person;
    }

    public Dataset<Row> person() {
        return (this.bitmap$0 & 0x1000000) == 0 ? this.person$lzycompute() : this.person;
    }

    private Dataset<Row> salary$lzycompute() {
        MultiDatabaseSuite multiDatabaseSuite = this;
        synchronized (multiDatabaseSuite) {
            if ((this.bitmap$0 & 0x2000000) == 0) {
                this.salary = SQLTestData.salary$((SQLTestData)this);
                this.bitmap$0 |= 0x2000000;
            }
        }
        return this.salary;
    }

    public Dataset<Row> salary() {
        return (this.bitmap$0 & 0x2000000) == 0 ? this.salary$lzycompute() : this.salary;
    }

    private Dataset<Row> complexData$lzycompute() {
        MultiDatabaseSuite multiDatabaseSuite = this;
        synchronized (multiDatabaseSuite) {
            if ((this.bitmap$0 & 0x4000000) == 0) {
                this.complexData = SQLTestData.complexData$((SQLTestData)this);
                this.bitmap$0 |= 0x4000000;
            }
        }
        return this.complexData;
    }

    public Dataset<Row> complexData() {
        return (this.bitmap$0 & 0x4000000) == 0 ? this.complexData$lzycompute() : this.complexData;
    }

    private Dataset<Row> courseSales$lzycompute() {
        MultiDatabaseSuite multiDatabaseSuite = this;
        synchronized (multiDatabaseSuite) {
            if ((this.bitmap$0 & 0x8000000) == 0) {
                this.courseSales = SQLTestData.courseSales$((SQLTestData)this);
                this.bitmap$0 |= 0x8000000;
            }
        }
        return this.courseSales;
    }

    public Dataset<Row> courseSales() {
        return (this.bitmap$0 & 0x8000000) == 0 ? this.courseSales$lzycompute() : this.courseSales;
    }

    private Dataset<Row> trainingSales$lzycompute() {
        MultiDatabaseSuite multiDatabaseSuite = this;
        synchronized (multiDatabaseSuite) {
            if ((this.bitmap$0 & 0x10000000) == 0) {
                this.trainingSales = SQLTestData.trainingSales$((SQLTestData)this);
                this.bitmap$0 |= 0x10000000;
            }
        }
        return this.trainingSales;
    }

    public Dataset<Row> trainingSales() {
        return (this.bitmap$0 & 0x10000000) == 0 ? this.trainingSales$lzycompute() : this.trainingSales;
    }

    private Dataset<Row> intervalData$lzycompute() {
        MultiDatabaseSuite multiDatabaseSuite = this;
        synchronized (multiDatabaseSuite) {
            if ((this.bitmap$0 & 0x20000000) == 0) {
                this.intervalData = SQLTestData.intervalData$((SQLTestData)this);
                this.bitmap$0 |= 0x20000000;
            }
        }
        return this.intervalData;
    }

    public Dataset<Row> intervalData() {
        return (this.bitmap$0 & 0x20000000) == 0 ? this.intervalData$lzycompute() : this.intervalData;
    }

    public AbstractPatienceConfiguration.PatienceConfig org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig() {
        return this.org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig;
    }

    public final void org$scalatest$concurrent$PatienceConfiguration$_setter_$org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig_$eq(AbstractPatienceConfiguration.PatienceConfig x$1) {
        this.org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig = x$1;
    }

    public AbstractPatienceConfiguration$PatienceConfig$ PatienceConfig() {
        if (this.PatienceConfig$module == null) {
            this.PatienceConfig$lzycompute$1();
        }
        return this.PatienceConfig$module;
    }

    private Dataset<Row> df$lzycompute() {
        MultiDatabaseSuite multiDatabaseSuite = this;
        synchronized (multiDatabaseSuite) {
            if ((this.bitmap$0 & 1) == 0) {
                this.df = this.spark().range(10L).coalesce(1).toDF();
                this.bitmap$0 |= 1;
            }
        }
        return this.df;
    }

    private Dataset<Row> df() {
        return (this.bitmap$0 & 1) == 0 ? this.df$lzycompute() : this.df;
    }

    private void checkTablePath(String dbName, String tableName) {
        CatalogTable metastoreTable = this.spark().sharedState().externalCatalog().getTable(dbName, tableName);
        URI expectedPath = new Path(new Path(this.spark().sharedState().externalCatalog().getDatabase(dbName).locationUri()), tableName).toUri();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(metastoreTable.location());
        URI $org_scalatest_assert_macro_right = expectedPath;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MultiDatabaseSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 34));
    }

    private String[] getTableNames(Option<String> dbName) {
        String[] stringArray;
        Option<String> option = dbName;
        if (option instanceof Some) {
            Some some = (Some)option;
            String db = (String)some.value();
            stringArray = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.spark().catalog().listTables(db).collect())).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.name(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        } else if (None$.MODULE$.equals(option)) {
            stringArray = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.spark().catalog().listTables().collect())).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.name(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        } else {
            throw new MatchError(option);
        }
        return stringArray;
    }

    private Option<String> getTableNames$default$1() {
        return None$.MODULE$;
    }

    private final void testImplicits$lzycompute$1() {
        MultiDatabaseSuite multiDatabaseSuite = this;
        synchronized (multiDatabaseSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new SQLTestUtilsBase$testImplicits$((SQLTestUtilsBase)this);
            }
        }
    }

    private final void org$apache$spark$sql$test$SQLTestData$$internalImplicits$lzycompute$1() {
        MultiDatabaseSuite multiDatabaseSuite = this;
        synchronized (multiDatabaseSuite) {
            if (this.internalImplicits$module == null) {
                this.internalImplicits$module = new SQLTestData$internalImplicits$((SQLTestData)this);
            }
        }
    }

    private final void PatienceConfig$lzycompute$1() {
        MultiDatabaseSuite multiDatabaseSuite = this;
        synchronized (multiDatabaseSuite) {
            if (this.PatienceConfig$module == null) {
                this.PatienceConfig$module = new AbstractPatienceConfiguration$PatienceConfig$((AbstractPatienceConfiguration)this);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$new$2(MultiDatabaseSuite $this, String db) {
        $this.activateDatabase(db, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.df().write().mode(SaveMode.Overwrite).saveAsTable("t");
            Object[] $org_scalatest_assert_macro_left = Predef$.MODULE$.refArrayOps((Object[])$this.getTableNames($this.getTableNames$default$1()));
            String $org_scalatest_assert_macro_right = "t";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left), "contains", (Object)$org_scalatest_assert_macro_right, new ArrayOps.ofRef($org_scalatest_assert_macro_left).contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MultiDatabaseSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 48));
            $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> $this.spark().table("t"), $this.df());
        });
        Object[] $org_scalatest_assert_macro_left = Predef$.MODULE$.refArrayOps((Object[])$this.getTableNames((Option<String>)Option$.MODULE$.apply((Object)db)));
        String $org_scalatest_assert_macro_right = "t";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left), "contains", (Object)$org_scalatest_assert_macro_right, new ArrayOps.ofRef($org_scalatest_assert_macro_left).contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MultiDatabaseSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 52));
        $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> $this.spark().table(new StringBuilder(2).append(db).append(".t").toString()), $this.df());
        $this.checkTablePath(db, "t");
    }

    public static final /* synthetic */ void $anonfun$new$7(MultiDatabaseSuite $this, String db) {
        $this.df().write().mode(SaveMode.Overwrite).saveAsTable(new StringBuilder(2).append(db).append(".t").toString());
        Object[] $org_scalatest_assert_macro_left = Predef$.MODULE$.refArrayOps((Object[])$this.getTableNames((Option<String>)Option$.MODULE$.apply((Object)db)));
        String $org_scalatest_assert_macro_right = "t";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left), "contains", (Object)$org_scalatest_assert_macro_right, new ArrayOps.ofRef($org_scalatest_assert_macro_left).contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MultiDatabaseSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
        $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> $this.spark().table(new StringBuilder(2).append(db).append(".t").toString()), $this.df());
        $this.checkTablePath(db, "t");
    }

    public static final /* synthetic */ void $anonfun$new$12(MultiDatabaseSuite $this, String db$3, File dir) {
        String path = dir.getCanonicalPath();
        $this.df().write().format("parquet").mode(SaveMode.Overwrite).save(path);
        $this.spark().catalog().createTable("t", path, "parquet");
        Object[] $org_scalatest_assert_macro_left = Predef$.MODULE$.refArrayOps((Object[])$this.getTableNames((Option<String>)Option$.MODULE$.apply((Object)db$3)));
        String $org_scalatest_assert_macro_right = "t";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left), "contains", (Object)$org_scalatest_assert_macro_right, new ArrayOps.ofRef($org_scalatest_assert_macro_left).contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MultiDatabaseSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
        $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> $this.spark().table("t"), $this.df());
        $this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(140).append("\n              |CREATE TABLE t1\n              |USING parquet\n              |OPTIONS (\n              |  path '").append(dir.toURI()).append("'\n              |)\n            ").toString())).stripMargin());
        Object[] $org_scalatest_assert_macro_left2 = Predef$.MODULE$.refArrayOps((Object[])$this.getTableNames((Option<String>)Option$.MODULE$.apply((Object)db$3)));
        String $org_scalatest_assert_macro_right2 = "t1";
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left2), "contains", (Object)$org_scalatest_assert_macro_right2, new ArrayOps.ofRef($org_scalatest_assert_macro_left2).contains((Object)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MultiDatabaseSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88));
        $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> $this.spark().table("t1"), $this.df());
    }

    public static final /* synthetic */ void $anonfun$new$17(MultiDatabaseSuite $this, String db$4, File dir) {
        String path = dir.getCanonicalPath();
        $this.df().write().format("parquet").mode(SaveMode.Overwrite).save(path);
        $this.spark().catalog().createTable(new StringBuilder(2).append(db$4).append(".t").toString(), path, "parquet");
        Object[] $org_scalatest_assert_macro_left = Predef$.MODULE$.refArrayOps((Object[])$this.getTableNames((Option<String>)Option$.MODULE$.apply((Object)db$4)));
        String $org_scalatest_assert_macro_right = "t";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left), "contains", (Object)$org_scalatest_assert_macro_right, new ArrayOps.ofRef($org_scalatest_assert_macro_left).contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MultiDatabaseSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
        $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> $this.spark().table(new StringBuilder(2).append(db$4).append(".t").toString()), $this.df());
        $this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(141).append("\n              |CREATE TABLE ").append(db$4).append(".t1\n              |USING parquet\n              |OPTIONS (\n              |  path '").append(dir.toURI()).append("'\n              |)\n            ").toString())).stripMargin());
        Object[] $org_scalatest_assert_macro_left2 = Predef$.MODULE$.refArrayOps((Object[])$this.getTableNames((Option<String>)Option$.MODULE$.apply((Object)db$4)));
        String $org_scalatest_assert_macro_right2 = "t1";
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left2), "contains", (Object)$org_scalatest_assert_macro_right2, new ArrayOps.ofRef($org_scalatest_assert_macro_left2).contains((Object)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MultiDatabaseSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113));
        $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> $this.spark().table(new StringBuilder(3).append(db$4).append(".t1").toString()), $this.df());
    }

    public static final /* synthetic */ void $anonfun$new$21(MultiDatabaseSuite $this, String db) {
        $this.activateDatabase(db, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.df().write().mode(SaveMode.Overwrite).saveAsTable("t");
            $this.df().write().mode(SaveMode.Append).saveAsTable("t");
            Object[] $org_scalatest_assert_macro_left = Predef$.MODULE$.refArrayOps((Object[])$this.getTableNames($this.getTableNames$default$1()));
            String $org_scalatest_assert_macro_right = "t";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left), "contains", (Object)$org_scalatest_assert_macro_right, new ArrayOps.ofRef($org_scalatest_assert_macro_left).contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MultiDatabaseSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
            $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> $this.spark().table("t"), $this.df().union($this.df()));
        });
        Object[] $org_scalatest_assert_macro_left = Predef$.MODULE$.refArrayOps((Object[])$this.getTableNames((Option<String>)Option$.MODULE$.apply((Object)db)));
        String $org_scalatest_assert_macro_right = "t";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left), "contains", (Object)$org_scalatest_assert_macro_right, new ArrayOps.ofRef($org_scalatest_assert_macro_left).contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MultiDatabaseSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 128));
        $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> $this.spark().table(new StringBuilder(2).append(db).append(".t").toString()), $this.df().union($this.df()));
        $this.checkTablePath(db, "t");
    }

    public static final /* synthetic */ void $anonfun$new$26(MultiDatabaseSuite $this, String db) {
        $this.df().write().mode(SaveMode.Overwrite).saveAsTable(new StringBuilder(2).append(db).append(".t").toString());
        $this.df().write().mode(SaveMode.Append).saveAsTable(new StringBuilder(2).append(db).append(".t").toString());
        Object[] $org_scalatest_assert_macro_left = Predef$.MODULE$.refArrayOps((Object[])$this.getTableNames((Option<String>)Option$.MODULE$.apply((Object)db)));
        String $org_scalatest_assert_macro_right = "t";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left), "contains", (Object)$org_scalatest_assert_macro_right, new ArrayOps.ofRef($org_scalatest_assert_macro_left).contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MultiDatabaseSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139));
        $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> $this.spark().table(new StringBuilder(2).append(db).append(".t").toString()), $this.df().union($this.df()));
        $this.checkTablePath(db, "t");
    }

    public static final /* synthetic */ void $anonfun$new$33(MultiDatabaseSuite $this, String db) {
        $this.activateDatabase(db, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.df().write().mode(SaveMode.Overwrite).saveAsTable("t");
            Object[] $org_scalatest_assert_macro_left = Predef$.MODULE$.refArrayOps((Object[])$this.getTableNames($this.getTableNames$default$1()));
            String $org_scalatest_assert_macro_right = "t";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left), "contains", (Object)$org_scalatest_assert_macro_right, new ArrayOps.ofRef($org_scalatest_assert_macro_left).contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MultiDatabaseSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
        });
        Object[] $org_scalatest_assert_macro_left = Predef$.MODULE$.refArrayOps((Object[])$this.getTableNames((Option<String>)Option$.MODULE$.apply((Object)db)));
        String $org_scalatest_assert_macro_right = "t";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left), "contains", (Object)$org_scalatest_assert_macro_right, new ArrayOps.ofRef($org_scalatest_assert_macro_left).contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MultiDatabaseSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 165));
        $this.df().write().insertInto(new StringBuilder(2).append(db).append(".t").toString());
        $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> $this.spark().table(new StringBuilder(2).append(db).append(".t").toString()), $this.df().union($this.df()));
    }

    public static final /* synthetic */ void $anonfun$new$37(MultiDatabaseSuite $this, String db) {
        $this.activateDatabase(db, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.sql().apply((Object)"CREATE TABLE t (key INT)");
            $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> $this.spark().table("t"), $this.spark().emptyDataFrame());
        });
        $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> $this.spark().table(new StringBuilder(2).append(db).append(".t").toString()), $this.spark().emptyDataFrame());
    }

    public static final /* synthetic */ void $anonfun$new$42(MultiDatabaseSuite $this, String db) {
        $this.activateDatabase(db, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.sql().apply((Object)"CREATE TABLE t (key INT)");
            Object[] $org_scalatest_assert_macro_left = Predef$.MODULE$.refArrayOps((Object[])$this.getTableNames($this.getTableNames$default$1()));
            String $org_scalatest_assert_macro_right = "t";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left), "contains", (Object)$org_scalatest_assert_macro_right, new ArrayOps.ofRef($org_scalatest_assert_macro_left).contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MultiDatabaseSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 187));
            Object[] $org_scalatest_assert_macro_left2 = Predef$.MODULE$.refArrayOps((Object[])$this.getTableNames((Option<String>)Option$.MODULE$.apply((Object)"default")));
            String $org_scalatest_assert_macro_right2 = "t";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left2), "contains", (Object)$org_scalatest_assert_macro_right2, new ArrayOps.ofRef($org_scalatest_assert_macro_left2).contains((Object)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MultiDatabaseSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 188));
        });
        Object[] $org_scalatest_assert_macro_left = Predef$.MODULE$.refArrayOps((Object[])$this.getTableNames($this.getTableNames$default$1()));
        String $org_scalatest_assert_macro_right = "t";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left), "contains", (Object)$org_scalatest_assert_macro_right, new ArrayOps.ofRef($org_scalatest_assert_macro_left).contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MultiDatabaseSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 191));
        Object[] $org_scalatest_assert_macro_left2 = Predef$.MODULE$.refArrayOps((Object[])$this.getTableNames((Option<String>)Option$.MODULE$.apply((Object)db)));
        String $org_scalatest_assert_macro_right2 = "t";
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left2), "contains", (Object)$org_scalatest_assert_macro_right2, new ArrayOps.ofRef($org_scalatest_assert_macro_left2).contains((Object)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MultiDatabaseSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 192));
        $this.activateDatabase(db, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.sql().apply((Object)"DROP TABLE t");
            Object[] $org_scalatest_assert_macro_left = Predef$.MODULE$.refArrayOps((Object[])$this.getTableNames($this.getTableNames$default$1()));
            String $org_scalatest_assert_macro_right = "t";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left), "contains", (Object)$org_scalatest_assert_macro_right, new ArrayOps.ofRef($org_scalatest_assert_macro_left).contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MultiDatabaseSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 196));
            Object[] $org_scalatest_assert_macro_left2 = Predef$.MODULE$.refArrayOps((Object[])$this.getTableNames((Option<String>)Option$.MODULE$.apply((Object)"default")));
            String $org_scalatest_assert_macro_right2 = "t";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left2), "contains", (Object)$org_scalatest_assert_macro_right2, new ArrayOps.ofRef($org_scalatest_assert_macro_left2).contains((Object)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MultiDatabaseSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 197));
        });
        Object[] $org_scalatest_assert_macro_left3 = Predef$.MODULE$.refArrayOps((Object[])$this.getTableNames($this.getTableNames$default$1()));
        String $org_scalatest_assert_macro_right3 = "t";
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left3), "contains", (Object)$org_scalatest_assert_macro_right3, new ArrayOps.ofRef($org_scalatest_assert_macro_left3).contains((Object)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("MultiDatabaseSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 200));
        Object[] $org_scalatest_assert_macro_left4 = Predef$.MODULE$.refArrayOps((Object[])$this.getTableNames((Option<String>)Option$.MODULE$.apply((Object)db)));
        String $org_scalatest_assert_macro_right4 = "t";
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left4), "contains", (Object)$org_scalatest_assert_macro_right4, new ArrayOps.ofRef($org_scalatest_assert_macro_left4).contains((Object)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("MultiDatabaseSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 201));
    }

    public static final /* synthetic */ void $anonfun$new$47(MultiDatabaseSuite $this, String db$10, File dir) {
        String path = dir.getCanonicalPath();
        $this.activateDatabase(db$10, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(150).append("CREATE EXTERNAL TABLE t (id BIGINT)\n               |PARTITIONED BY (p INT)\n               |STORED AS PARQUET\n               |LOCATION '").append(dir.toURI()).append("'\n             ").toString())).stripMargin());
            $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> $this.spark().table("t"), $this.spark().emptyDataFrame());
            $this.df().write().parquet(new StringBuilder(4).append(path).append("/p=1").toString());
            $this.sql().apply((Object)"ALTER TABLE t ADD PARTITION (p=1)");
            $this.sql().apply((Object)"REFRESH TABLE t");
            $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> $this.spark().table("t"), $this.df().withColumn("p", functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)1))));
            $this.df().write().parquet(new StringBuilder(4).append(path).append("/p=2").toString());
            $this.sql().apply((Object)"ALTER TABLE t ADD PARTITION (p=2)");
            $this.spark().catalog().refreshTable("t");
            $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> $this.spark().table("t"), $this.df().withColumn("p", functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)1))).union($this.df().withColumn("p", functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)2)))));
        });
    }

    public static final /* synthetic */ void $anonfun$new$54(MultiDatabaseSuite $this, String db$11, File dir) {
        String path = dir.getCanonicalPath();
        $this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(151).append("CREATE EXTERNAL TABLE ").append(db$11).append(".t (id BIGINT)\n               |PARTITIONED BY (p INT)\n               |STORED AS PARQUET\n               |LOCATION '").append(dir.toURI()).append("'\n             ").toString())).stripMargin());
        $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> $this.spark().table(new StringBuilder(2).append(db$11).append(".t").toString()), $this.spark().emptyDataFrame());
        $this.df().write().parquet(new StringBuilder(4).append(path).append("/p=1").toString());
        $this.sql().apply((Object)new StringBuilder(34).append("ALTER TABLE ").append(db$11).append(".t ADD PARTITION (p=1)").toString());
        $this.sql().apply((Object)new StringBuilder(16).append("REFRESH TABLE ").append(db$11).append(".t").toString());
        $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> $this.spark().table(new StringBuilder(2).append(db$11).append(".t").toString()), $this.df().withColumn("p", functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)1))));
        $this.df().write().parquet(new StringBuilder(4).append(path).append("/p=2").toString());
        $this.sql().apply((Object)new StringBuilder(34).append("ALTER TABLE ").append(db$11).append(".t ADD PARTITION (p=2)").toString());
        $this.spark().catalog().refreshTable(new StringBuilder(2).append(db$11).append(".t").toString());
        $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> $this.spark().table(new StringBuilder(2).append(db$11).append(".t").toString()), $this.df().withColumn("p", functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)1))).union($this.df().withColumn("p", functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)2)))));
    }

    public static final /* synthetic */ void $anonfun$new$61(MultiDatabaseSuite $this, File dir) {
        String message;
        String message2;
        String $org_scalatest_assert_macro_left = message2 = ((AnalysisException)$this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(147).append("\n            |CREATE TABLE `d:b`.`t:a` (a int)\n            |USING parquet\n            |OPTIONS (\n            |  path '").append(dir.toURI()).append("'\n            |)\n            ").toString())).stripMargin()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("MultiDatabaseSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 286))).getMessage();
        String $org_scalatest_assert_macro_right = "`t:a` is not a valid name for tables/databases. Valid names only contain alphabet characters, numbers and _.";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MultiDatabaseSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 296));
        String $org_scalatest_assert_macro_left2 = message = ((AnalysisException)$this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(161).append("\n              |CREATE TABLE `d:b`.`table` (a int)\n              |USING parquet\n              |OPTIONS (\n              |  path '").append(dir.toURI()).append("'\n              |)\n              ").toString())).stripMargin()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("MultiDatabaseSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 301))).getMessage();
        String $org_scalatest_assert_macro_right2 = "Database 'd:b' not found";
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MultiDatabaseSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 311));
    }

    public MultiDatabaseSuite() {
        ScaledTimeSpans.$init$((ScaledTimeSpans)this);
        AbstractPatienceConfiguration.$init$((AbstractPatienceConfiguration)this);
        PatienceConfiguration.$init$((PatienceConfiguration)this);
        Eventually.$init$((Eventually)this);
        SQLTestData.$init$((SQLTestData)this);
        SQLTestUtilsBase.$init$((SQLTestUtilsBase)this);
        SQLTestUtils.$init$((SQLTestUtils)this);
        TestHiveSingleton.$init$(this);
        this.test("saveAsTable() to non-default database - with USE - Overwrite", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDatabase((Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)db -> {
            MultiDatabaseSuite.$anonfun$new$2(this, db);
            return BoxedUnit.UNIT;
        }), new Position("MultiDatabaseSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 44));
        this.test("saveAsTable() to non-default database - without USE - Overwrite", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDatabase((Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)db -> {
            MultiDatabaseSuite.$anonfun$new$7(this, db);
            return BoxedUnit.UNIT;
        }), new Position("MultiDatabaseSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59));
        this.test("createTable() to non-default database - with USE", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDatabase((Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)db -> {
            this.activateDatabase(db, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempPath((Function1 & Serializable & scala.Serializable)dir -> {
                MultiDatabaseSuite.$anonfun$new$12($this, db, dir);
                return BoxedUnit.UNIT;
            }));
            return BoxedUnit.UNIT;
        }), new Position("MultiDatabaseSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
        this.test("createTable() to non-default database - without USE", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDatabase((Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)db -> {
            this.withTempPath((Function1 & Serializable & scala.Serializable)dir -> {
                MultiDatabaseSuite.$anonfun$new$17($this, db, dir);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        }), new Position("MultiDatabaseSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
        this.test("saveAsTable() to non-default database - with USE - Append", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDatabase((Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)db -> {
            MultiDatabaseSuite.$anonfun$new$21(this, db);
            return BoxedUnit.UNIT;
        }), new Position("MultiDatabaseSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 119));
        this.test("saveAsTable() to non-default database - without USE - Append", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDatabase((Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)db -> {
            MultiDatabaseSuite.$anonfun$new$26(this, db);
            return BoxedUnit.UNIT;
        }), new Position("MultiDatabaseSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135));
        this.test("insertInto() non-default database - with USE", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDatabase((Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)db -> {
            this.activateDatabase(db, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.df().write().mode(SaveMode.Overwrite).saveAsTable("t");
                Object[] $org_scalatest_assert_macro_left = Predef$.MODULE$.refArrayOps((Object[])$this.getTableNames($this.getTableNames$default$1()));
                String $org_scalatest_assert_macro_right = "t";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left), "contains", (Object)$org_scalatest_assert_macro_right, new ArrayOps.ofRef($org_scalatest_assert_macro_left).contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MultiDatabaseSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 150));
                $this.df().write().insertInto(new StringBuilder(2).append(db).append(".t").toString());
                $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> $this.spark().table(new StringBuilder(2).append(db).append(".t").toString()), $this.df().union($this.df()));
            });
            return BoxedUnit.UNIT;
        }), new Position("MultiDatabaseSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 146));
        this.test("insertInto() non-default database - without USE", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDatabase((Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)db -> {
            MultiDatabaseSuite.$anonfun$new$33(this, db);
            return BoxedUnit.UNIT;
        }), new Position("MultiDatabaseSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 158));
        this.test("Looks up tables in non-default database", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDatabase((Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)db -> {
            MultiDatabaseSuite.$anonfun$new$37(this, db);
            return BoxedUnit.UNIT;
        }), new Position("MultiDatabaseSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 172));
        this.test("Drops a table in a non-default database", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDatabase((Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)db -> {
            MultiDatabaseSuite.$anonfun$new$42(this, db);
            return BoxedUnit.UNIT;
        }), new Position("MultiDatabaseSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 183));
        this.test("Refreshes a table in a non-default database - with USE", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDatabase((Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)db -> {
            this.withTempPath((Function1 & Serializable & scala.Serializable)dir -> {
                MultiDatabaseSuite.$anonfun$new$47($this, db, dir);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        }), new Position("MultiDatabaseSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 205));
        this.test("Refreshes a table in a non-default database - without USE", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDatabase((Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)db -> {
            this.withTempPath((Function1 & Serializable & scala.Serializable)dir -> {
                MultiDatabaseSuite.$anonfun$new$54($this, db, dir);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        }), new Position("MultiDatabaseSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 238));
        this.test("invalid database name and table names", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String message;
            String message2;
            String $org_scalatest_assert_macro_left = message2 = ((AnalysisException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.df().write().format("parquet").saveAsTable("`d:b`.`t:a`"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("MultiDatabaseSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 271))).getMessage();
            String $org_scalatest_assert_macro_right = "Database 'd:b' not found";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MultiDatabaseSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 274));
            String $org_scalatest_assert_macro_left2 = message = ((AnalysisException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.df().write().format("parquet").saveAsTable("`d:b`.`table`"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("MultiDatabaseSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 278))).getMessage();
            String $org_scalatest_assert_macro_right2 = "Database 'd:b' not found";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MultiDatabaseSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 281));
            this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
                MultiDatabaseSuite.$anonfun$new$61(this, dir);
                return BoxedUnit.UNIT;
            });
        }, new Position("MultiDatabaseSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 269));
    }
}

