/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.execution;

import java.io.Serializable;
import org.apache.spark.metrics.source.HiveCatalogMetrics$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.QueryTest$;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.plans.logical.ColumnStat;
import org.apache.spark.sql.catalyst.plans.logical.ColumnStat$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.statsEstimation.LogicalPlanStats;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.datasources.PrunePartitionSuiteBase;
import org.apache.spark.sql.hive.client.HiveClient;
import org.apache.spark.sql.hive.execution.HiveTableScanExec;
import org.apache.spark.sql.hive.execution.PruneHiveTablePartitionsSuite$Optimize$;
import org.apache.spark.sql.hive.test.TestHiveContext;
import org.apache.spark.sql.hive.test.TestHiveSingleton;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.LongType$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001y4AAC\u0006\u00011!)a\u0005\u0001C\u0001O!)!\u0006\u0001C!W\u001d)\u0011\b\u0001E\u0001u\u0019)A\b\u0001E\u0001{!)a\u0005\u0002C\u0001\u001d\"9q\n\u0002b\u0001\n\u0003\u0001\u0006BB/\u0005A\u0003%\u0011\u000bC\u0003_\u0001\u0011Eq\fC\u0003x\u0001\u0011\u0005\u0003PA\u000fQeVtW\rS5wKR\u000b'\r\\3QCJ$\u0018\u000e^5p]N\u001cV/\u001b;f\u0015\taQ\"A\u0005fq\u0016\u001cW\u000f^5p]*\u0011abD\u0001\u0005Q&4XM\u0003\u0002\u0011#\u0005\u00191/\u001d7\u000b\u0005I\u0019\u0012!B:qCJ\\'B\u0001\u000b\u0016\u0003\u0019\t\u0007/Y2iK*\ta#A\u0002pe\u001e\u001c\u0001aE\u0002\u00013\u0001\u0002\"A\u0007\u0010\u000e\u0003mQ!\u0001H\u000f\u0002\u0017\u0011\fG/Y:pkJ\u001cWm\u001d\u0006\u0003\u0019=I!aH\u000e\u0003/A\u0013XO\\3QCJ$\u0018\u000e^5p]N+\u0018\u000e^3CCN,\u0007CA\u0011%\u001b\u0005\u0011#BA\u0012\u000e\u0003\u0011!Xm\u001d;\n\u0005\u0015\u0012#!\u0005+fgRD\u0015N^3TS:<G.\u001a;p]\u00061A(\u001b8jiz\"\u0012\u0001\u000b\t\u0003S\u0001i\u0011aC\u0001\u0007M>\u0014X.\u0019;\u0015\u00031\u0002\"!\f\u001c\u000f\u00059\"\u0004CA\u00183\u001b\u0005\u0001$BA\u0019\u0018\u0003\u0019a$o\\8u})\t1'A\u0003tG\u0006d\u0017-\u0003\u00026e\u00051\u0001K]3eK\u001aL!a\u000e\u001d\u0003\rM#(/\u001b8h\u0015\t)$'\u0001\u0005PaRLW.\u001b>f!\tYD!D\u0001\u0001\u0005!y\u0005\u000f^5nSj,7C\u0001\u0003?!\ryDIR\u0007\u0002\u0001*\u0011\u0011IQ\u0001\u0006eVdWm\u001d\u0006\u0003\u0007>\t\u0001bY1uC2L8\u000f^\u0005\u0003\u000b\u0002\u0013ABU;mK\u0016CXmY;u_J\u0004\"a\u0012'\u000e\u0003!S!!\u0013&\u0002\u000f1|w-[2bY*\u00111JQ\u0001\u0006a2\fgn]\u0005\u0003\u001b\"\u00131\u0002T8hS\u000e\fG\u000e\u00157b]R\t!(A\u0004cCR\u001c\u0007.Z:\u0016\u0003E\u00032AU,Z\u001b\u0005\u0019&B\u0001+V\u0003%IW.\\;uC\ndWM\u0003\u0002We\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005a\u001b&\u0001\u0002'jgR\u0004\"AW.\u000e\u0003\u0011I!\u0001\u0018#\u0003\u000b\t\u000bGo\u00195\u0002\u0011\t\fGo\u00195fg\u0002\n\u0011dY8mY\u0016\u001cG\u000fU1si&$\u0018n\u001c8GS2$XM]:G]R\t\u0001\r\u0005\u0003bE\u0012DW\"\u0001\u001a\n\u0005\r\u0014$a\u0004)beRL\u0017\r\u001c$v]\u000e$\u0018n\u001c8\u0011\u0005\u00154W\"A\u000f\n\u0005\u001dl\"!C*qCJ\\\u0007\u000b\\1o!\rIg.\u001d\b\u0003U2t!aL6\n\u0003MJ!!\u001c\u001a\u0002\u000fA\f7m[1hK&\u0011q\u000e\u001d\u0002\u0004'\u0016\f(BA73!\t\u0011X/D\u0001t\u0015\t!()A\u0006fqB\u0014Xm]:j_:\u001c\u0018B\u0001<t\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\u0019O\u0016$8kY1o\u000bb,7\rU1si&$\u0018n\u001c8TSj,GCA=}!\t\t'0\u0003\u0002|e\t!Aj\u001c8h\u0011\u0015i\u0018\u00021\u0001e\u0003\u0011\u0001H.\u00198")
public class PruneHiveTablePartitionsSuite
extends PrunePartitionSuiteBase
implements TestHiveSingleton {
    private volatile PruneHiveTablePartitionsSuite$Optimize$ Optimize$module;
    private final boolean enableAutoThreadAudit;
    private final SparkSession spark;
    private final TestHiveContext hiveContext;
    private final HiveClient hiveClient;

    @Override
    public /* synthetic */ void org$apache$spark$sql$hive$test$TestHiveSingleton$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public void afterAll() {
        TestHiveSingleton.afterAll$(this);
    }

    public PruneHiveTablePartitionsSuite$Optimize$ Optimize() {
        if (this.Optimize$module == null) {
            this.Optimize$lzycompute$1();
        }
        return this.Optimize$module;
    }

    @Override
    public boolean enableAutoThreadAudit() {
        return this.enableAutoThreadAudit;
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public TestHiveContext hiveContext() {
        return this.hiveContext;
    }

    @Override
    public HiveClient hiveClient() {
        return this.hiveClient;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$enableAutoThreadAudit_$eq(boolean x$1) {
        this.enableAutoThreadAudit = x$1;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$hiveContext_$eq(TestHiveContext x$1) {
        this.hiveContext = x$1;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$hiveClient_$eq(HiveClient x$1) {
        this.hiveClient = x$1;
    }

    public String format() {
        return "hive";
    }

    public PartialFunction<SparkPlan, Seq<Expression>> collectPartitionFiltersFn() {
        return new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof HiveTableScanExec) {
                    HiveTableScanExec hiveTableScanExec = (HiveTableScanExec)A1;
                    object = hiveTableScanExec.partitionPruningPred();
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(SparkPlan x1) {
                SparkPlan sparkPlan = x1;
                boolean bl = sparkPlan instanceof HiveTableScanExec;
                return bl;
            }
        };
    }

    public long getScanExecPartitionSize(SparkPlan plan) {
        return ((HiveTableScanExec)plan.collectFirst((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                HiveTableScanExec hiveTableScanExec;
                A1 A1 = x1;
                Object object = A1 instanceof HiveTableScanExec ? (hiveTableScanExec = (HiveTableScanExec)A1) : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(SparkPlan x1) {
                SparkPlan sparkPlan = x1;
                boolean bl = sparkPlan instanceof HiveTableScanExec;
                return bl;
            }
        }).get()).prunedPartitions().size();
    }

    private final void Optimize$lzycompute$1() {
        PruneHiveTablePartitionsSuite pruneHiveTablePartitionsSuite = this;
        synchronized (pruneHiveTablePartitionsSuite) {
            if (this.Optimize$module == null) {
                this.Optimize$module = new PruneHiveTablePartitionsSuite$Optimize$(this);
            }
        }
    }

    public static final /* synthetic */ Dataset $anonfun$new$3(PruneHiveTablePartitionsSuite $this, int part) {
        return (Dataset)$this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(92).append("\n            |INSERT OVERWRITE TABLE test PARTITION (p='").append(part).append("')\n            |select col from temp").toString())).stripMargin());
    }

    public static final /* synthetic */ Dataset $anonfun$new$7(PruneHiveTablePartitionsSuite $this, int part) {
        return (Dataset)$this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(103).append("\n               |INSERT OVERWRITE TABLE t PARTITION (p0='").append(part).append("', p1='").append(part).append("')\n               |SELECT col FROM temp").toString())).stripMargin());
    }

    public static final /* synthetic */ String $anonfun$new$8(int i) {
        return new StringBuilder(21).append("(p0 = '").append(i).append("' AND p1 = '").append(i).append("')").toString();
    }

    public PruneHiveTablePartitionsSuite() {
        TestHiveSingleton.$init$(this);
        this.test("SPARK-15616: statistics pruned after going through PruneHiveTablePartitions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test", "temp"}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString("\n          |CREATE TABLE test(i int)\n          |PARTITIONED BY (p int)\n          |STORED AS textfile")).stripMargin());
            this.spark().range(0L, 1000L, 1L).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id as col"})).createOrReplaceTempView("temp");
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4}))).foreach((Function1 & Serializable & scala.Serializable)part -> PruneHiveTablePartitionsSuite.$anonfun$new$3(this, BoxesRunTime.unboxToInt((Object)part)));
            LogicalPlan analyzed1 = ((Dataset)this.sql().apply((Object)"select i from test where p > 0")).queryExecution().analyzed();
            LogicalPlan analyzed2 = ((Dataset)this.sql().apply((Object)"select i from test where p = 1")).queryExecution().analyzed();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(((LogicalPlanStats)this.Optimize().execute((TreeNode)analyzed1)).stats().sizeInBytes().$div(BigInt$.MODULE$.int2bigInt(4)));
            BigInt $org_scalatest_assert_macro_right = ((LogicalPlanStats)this.Optimize().execute((TreeNode)analyzed2)).stats().sizeInBytes();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PruneHiveTablePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
        }), new Position("PruneHiveTablePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 42));
        this.test("Avoid generating too many predicates in partition pruning", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempView((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"temp"}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(111).append("\n             |CREATE TABLE t(i INT, p0 INT, p1 INT)\n             |USING ").append(this.format()).append("\n             |PARTITIONED BY (p0, p1)").toString())).stripMargin());
            this.spark().range(0L, 10L, 1L).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id as col"})).createOrReplaceTempView("temp");
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 25).foreach((Function1 & Serializable & scala.Serializable)part -> PruneHiveTablePartitionsSuite.$anonfun$new$7(this, BoxesRunTime.unboxToInt((Object)part)));
            int scale = 20;
            String predicate = ((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), scale).map((Function1 & Serializable & scala.Serializable)i -> PruneHiveTablePartitionsSuite.$anonfun$new$8(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).mkString(" OR ");
            String expectedStr = "(((((((p0 = 1) && (p1 = 1)) || ((p0 = 2) && (p1 = 2))) || ((p0 = 3) && (p1 = 3))) || (((p0 = 4) && (p1 = 4)) || ((p0 = 5) && (p1 = 5)))) || (((((p0 = 6) && (p1 = 6)) || ((p0 = 7) && (p1 = 7))) || ((p0 = 8) && (p1 = 8))) || (((p0 = 9) && (p1 = 9)) || ((p0 = 10) && (p1 = 10))))) || ((((((p0 = 11) && (p1 = 11)) || ((p0 = 12) && (p1 = 12))) || ((p0 = 13) && (p1 = 13))) || (((p0 = 14) && (p1 = 14)) || ((p0 = 15) && (p1 = 15)))) || (((((p0 = 16) && (p1 = 16)) || ((p0 = 17) && (p1 = 17))) || ((p0 = 18) && (p1 = 18))) || (((p0 = 19) && (p1 = 19)) || ((p0 = 20) && (p1 = 20))))))";
            this.assertPrunedPartitions(new StringBuilder(22).append("SELECT * FROM t WHERE ").append(predicate).toString(), scale, expectedStr);
        })), new Position("PruneHiveTablePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
        this.test("SPARK-34119: Keep necessary stats after PruneHiveTablePartitions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SPARK_34119"}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.CBO_ENABLED().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hive.exec.dynamic.partition.mode"), (Object)"nonstrict")}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)new StringBuilder(121).append("CREATE TABLE SPARK_34119 PARTITIONED BY (p) STORED AS textfile AS ").append("(SELECT id, CAST(id % 5 AS STRING) AS p FROM range(20))").toString());
            this.sql().apply((Object)"ANALYZE TABLE SPARK_34119 COMPUTE STATISTICS FOR ALL COLUMNS");
            this.checkOptimizedPlanStats((Dataset)this.sql().apply((Object)"SELECT id FROM SPARK_34119"), BigInt$.MODULE$.long2bigInt(320L), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(20)), (Seq)new .colon.colon((Object)new ColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(20)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)19)), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)LongType$.MODULE$.defaultSize())), (Option)new Some((Object)BoxesRunTime.boxToLong((long)LongType$.MODULE$.defaultSize())), ColumnStat$.MODULE$.apply$default$7(), ColumnStat$.MODULE$.apply$default$8()), (List)Nil$.MODULE$));
            this.checkOptimizedPlanStats((Dataset)this.sql().apply((Object)"SELECT id FROM SPARK_34119 WHERE p = '2'"), BigInt$.MODULE$.long2bigInt(64L), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(4)), (Seq)new .colon.colon((Object)new ColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(4)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)19)), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)LongType$.MODULE$.defaultSize())), (Option)new Some((Object)BoxesRunTime.boxToLong((long)LongType$.MODULE$.defaultSize())), ColumnStat$.MODULE$.apply$default$7(), ColumnStat$.MODULE$.apply$default$8()), (List)Nil$.MODULE$));
        })), new Position("PruneHiveTablePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
        this.test("SPARK-36128: spark.sql.hive.metastorePartitionPruning should work for file data sources", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, false}))).foreach((Function1 & Serializable & scala.Serializable)enablePruning -> {
            this.withTable((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tbl"}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.HIVE_METASTORE_PARTITION_PRUNING().key()), (Object)Boolean.toString(BoxesRunTime.unboxToBoolean((Object)enablePruning)))}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.spark().range(10L).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "id % 3 as p"})).write().partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"p"})).saveAsTable("tbl");
                HiveCatalogMetrics$.MODULE$.reset();
                QueryTest$.MODULE$.checkAnswer((Dataset)$this.sql().apply((Object)"SELECT id FROM tbl WHERE p = 1"), (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 4, 7}))).map((Function1 & Serializable & scala.Serializable)x$2 -> Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)x$2))})), Seq$.MODULE$.canBuildFrom()), false);
                int expectedCount = enablePruning ? 1 : 3;
                long $org_scalatest_assert_macro_left = HiveCatalogMetrics$.MODULE$.METRIC_PARTITIONS_FETCHED().getCount();
                int $org_scalatest_assert_macro_right = expectedCount;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PruneHiveTablePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148));
            }));
            return BoxedUnit.UNIT;
        }), new Position("PruneHiveTablePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139));
    }
}

