/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.orc;

import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.io.orc.OrcSerde;
import org.apache.hadoop.hive.ql.io.orc.OrcStruct;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.SettableStructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.Writable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.hive.HiveInspectors;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001Y4QAC\u0006\u0001\u0017]A\u0001B\t\u0001\u0003\u0002\u0003\u0006I\u0001\n\u0005\tU\u0001\u0011\t\u0011)A\u0005W!)!\u0007\u0001C\u0001g!)\u0001\b\u0001C\u0001s!1\u0001\n\u0001Q\u0001\n%CaA\u0015\u0001!\u0002\u0013\u0019\u0006BB.\u0001A\u0003%A\f\u0003\u0004`\u0001\u0001\u0006I\u0001\u0019\u0005\u0007Y\u0002\u0001K\u0011B7\u0003\u001b=\u00138mU3sS\u0006d\u0017N_3s\u0015\taQ\"A\u0002pe\u000eT!AD\b\u0002\t!Lg/\u001a\u0006\u0003!E\t1a]9m\u0015\t\u00112#A\u0003ta\u0006\u00148N\u0003\u0002\u0015+\u00051\u0011\r]1dQ\u0016T\u0011AF\u0001\u0004_J<7c\u0001\u0001\u0019=A\u0011\u0011\u0004H\u0007\u00025)\t1$A\u0003tG\u0006d\u0017-\u0003\u0002\u001e5\t1\u0011I\\=SK\u001a\u0004\"a\b\u0011\u000e\u00035I!!I\u0007\u0003\u001d!Kg/Z%ogB,7\r^8sg\u0006QA-\u0019;b'\u000eDW-\\1\u0004\u0001A\u0011Q\u0005K\u0007\u0002M)\u0011qeD\u0001\u0006if\u0004Xm]\u0005\u0003S\u0019\u0012!b\u0015;sk\u000e$H+\u001f9f\u0003\u0011\u0019wN\u001c4\u0011\u00051\u0002T\"A\u0017\u000b\u0005)r#BA\u0018\u0014\u0003\u0019A\u0017\rZ8pa&\u0011\u0011'\f\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0002\rqJg.\u001b;?)\r!dg\u000e\t\u0003k\u0001i\u0011a\u0003\u0005\u0006E\r\u0001\r\u0001\n\u0005\u0006U\r\u0001\raK\u0001\ng\u0016\u0014\u0018.\u00197ju\u0016$\"A\u000f!\u0011\u0005mrT\"\u0001\u001f\u000b\u0005ur\u0013AA5p\u0013\tyDH\u0001\u0005Xe&$\u0018M\u00197f\u0011\u0015\tE\u00011\u0001C\u0003\r\u0011xn\u001e\t\u0003\u0007\u001ak\u0011\u0001\u0012\u0006\u0003\u000b>\t\u0001bY1uC2L8\u000f^\u0005\u0003\u000f\u0012\u00131\"\u00138uKJt\u0017\r\u001c*po\u0006Q1/\u001a:jC2L'0\u001a:\u0011\u0005)\u0003V\"A&\u000b\u00051a%BA\u001fN\u0015\tqu*\u0001\u0002rY*\u0011aBL\u0005\u0003#.\u0013\u0001b\u0014:d'\u0016\u0014H-Z\u0001\tgR\u0014Xo\u0019;P\u0013B\u0011A+W\u0007\u0002+*\u0011akV\u0001\u0010_\nTWm\u0019;j]N\u0004Xm\u0019;pe*\u0011\u0001lT\u0001\u0007g\u0016\u0014H-\u001a\u001a\n\u0005i+&!H*fiR\f'\r\\3TiJ,8\r^(cU\u0016\u001cG/\u00138ta\u0016\u001cGo\u001c:\u0002\u001f\r\f7\r[3e\u001fJ\u001c7\u000b\u001e:vGR\u0004\"AS/\n\u0005y[%!C(sGN#(/^2u\u0003!9(/\u00199qKJ\u001c\bcA1eM6\t!M\u0003\u0002d5\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005\u0015\u0014'aA*fcB!\u0011dZ5j\u0013\tA'DA\u0005Gk:\u001cG/[8ocA\u0011\u0011D[\u0005\u0003Wj\u00111!\u00118z\u000359(/\u00199Pe\u000e\u001cFO];diR!a.]:v!\tIr.\u0003\u0002q5\t!QK\\5u\u0011\u0015\u0011\u0018\u00021\u0001]\u0003\u0019\u0019HO];di\")A/\u0003a\u0001'\u0006\u0011q.\u001b\u0005\u0006\u0003&\u0001\rA\u0011")
public class OrcSerializer
implements HiveInspectors {
    private final StructType dataSchema;
    private final OrcSerde serializer;
    private final SettableStructObjectInspector structOI;
    private final OrcStruct cachedOrcStruct;
    private final Seq<Function1<Object, Object>> wrappers;

    @Override
    public DataType javaTypeToDataType(Type clz) {
        return HiveInspectors.javaTypeToDataType$(this, clz);
    }

    @Override
    public Function1<Object, Object> wrapperFor(ObjectInspector oi, DataType dataType) {
        return HiveInspectors.wrapperFor$(this, oi, dataType);
    }

    @Override
    public Function1<Object, Object> unwrapperFor(ObjectInspector objectInspector) {
        return HiveInspectors.unwrapperFor$((HiveInspectors)this, objectInspector);
    }

    @Override
    public Function3<Object, InternalRow, Object, BoxedUnit> unwrapperFor(org.apache.hadoop.hive.serde2.objectinspector.StructField field) {
        return HiveInspectors.unwrapperFor$((HiveInspectors)this, field);
    }

    @Override
    public Object wrap(Object a, ObjectInspector oi, DataType dataType) {
        return HiveInspectors.wrap$(this, a, oi, dataType);
    }

    @Override
    public Object[] wrap(InternalRow row, Function1<Object, Object>[] wrappers, Object[] cache, DataType[] dataTypes) {
        return HiveInspectors.wrap$((HiveInspectors)this, row, wrappers, cache, dataTypes);
    }

    @Override
    public Object[] wrap(Seq<Object> row, Function1<Object, Object>[] wrappers, Object[] cache, DataType[] dataTypes) {
        return HiveInspectors.wrap$((HiveInspectors)this, row, wrappers, cache, dataTypes);
    }

    @Override
    public ObjectInspector toInspector(DataType dataType) {
        return HiveInspectors.toInspector$((HiveInspectors)this, dataType);
    }

    @Override
    public ObjectInspector toInspector(Expression expr) {
        return HiveInspectors.toInspector$((HiveInspectors)this, expr);
    }

    @Override
    public DataType inspectorToDataType(ObjectInspector inspector) {
        return HiveInspectors.inspectorToDataType$(this, inspector);
    }

    @Override
    public HiveInspectors.typeInfoConversions typeInfoConversions(DataType dt) {
        return HiveInspectors.typeInfoConversions$(this, dt);
    }

    public Writable serialize(InternalRow row) {
        this.wrapOrcStruct(this.cachedOrcStruct, this.structOI, row);
        return this.serializer.serialize((Object)this.cachedOrcStruct, (ObjectInspector)this.structOI);
    }

    private void wrapOrcStruct(OrcStruct struct, SettableStructObjectInspector oi, InternalRow row) {
        List fieldRefs = oi.getAllStructFieldRefs();
        int size = fieldRefs.size();
        for (int i = 0; i < size; ++i) {
            oi.setStructFieldData((Object)struct, (org.apache.hadoop.hive.serde2.objectinspector.StructField)fieldRefs.get(i), ((Function1)this.wrappers.apply(i)).apply(row.get(i, this.dataSchema.apply(i).dataType())));
        }
    }

    public OrcSerializer(StructType dataSchema, Configuration conf) {
        this.dataSchema = dataSchema;
        HiveInspectors.$init$(this);
        Properties table = new Properties();
        table.setProperty("columns", new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dataSchema.fieldNames())).mkString(","));
        table.setProperty("columns.types", ((TraversableOnce)dataSchema.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.dataType().catalogString(), Seq$.MODULE$.canBuildFrom())).mkString(":"));
        OrcSerde serde = new OrcSerde();
        serde.initialize(conf, table);
        this.serializer = serde;
        TypeInfo typeInfo = TypeInfoUtils.getTypeInfoFromTypeString((String)dataSchema.catalogString());
        this.structOI = (SettableStructObjectInspector)OrcStruct.createObjectInspector((TypeInfo)((StructTypeInfo)typeInfo));
        this.cachedOrcStruct = (OrcStruct)this.structOI.create();
        this.wrappers = (Seq)((TraversableLike)dataSchema.zip((GenIterable)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.structOI.getAllStructFieldRefs()).asScala()).toSeq(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            StructField f = (StructField)tuple2._1();
            org.apache.hadoop.hive.serde2.objectinspector.StructField i = (org.apache.hadoop.hive.serde2.objectinspector.StructField)tuple2._2();
            Function1<Object, Object> function1 = this.wrapperFor(i.getFieldObjectInspector(), f.dataType());
            return function1;
        }, Seq$.MODULE$.canBuildFrom());
    }
}

