/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.execution;

import java.io.File;
import java.io.Serializable;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.catalyst.TableIdentifier$;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute;
import org.apache.spark.sql.catalyst.catalog.CatalogStatistics;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.dsl.package;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.plans.logical.Filter;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.plans.logical.statsEstimation.LogicalPlanStats;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.execution.FileSourceScanExec;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.datasources.CatalogFileIndex;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.FileIndex;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.datasources.LogicalRelation$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat;
import org.apache.spark.sql.execution.joins.BroadcastHashJoinExec;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.hive.execution.PruneFileSourcePartitionsSuite$Optimize$;
import org.apache.spark.sql.hive.execution.PrunePartitionSuiteBase;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import org.scalatest.enablers.Size$;
import org.scalatest.matchers.should.Matchers$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u00014A!\u0003\u0006\u0001/!)A\u0004\u0001C\u0001;!)q\u0004\u0001C!A\u001d)a\u0006\u0001E\u0001_\u0019)\u0011\u0007\u0001E\u0001e!)A\u0004\u0002C\u0001\u0007\"9A\t\u0002b\u0001\n\u0003)\u0005B\u0002*\u0005A\u0003%a\tC\u0003T\u0001\u0011\u0005CK\u0001\u0010QeVtWMR5mKN{WO]2f!\u0006\u0014H/\u001b;j_:\u001c8+^5uK*\u00111\u0002D\u0001\nKb,7-\u001e;j_:T!!\u0004\b\u0002\t!Lg/\u001a\u0006\u0003\u001fA\t1a]9m\u0015\t\t\"#A\u0003ta\u0006\u00148N\u0003\u0002\u0014)\u00051\u0011\r]1dQ\u0016T\u0011!F\u0001\u0004_J<7\u0001A\n\u0003\u0001a\u0001\"!\u0007\u000e\u000e\u0003)I!a\u0007\u0006\u0003/A\u0013XO\\3QCJ$\u0018\u000e^5p]N+\u0018\u000e^3CCN,\u0017A\u0002\u001fj]&$h\bF\u0001\u001f!\tI\u0002!\u0001\u0004g_Jl\u0017\r^\u000b\u0002CA\u0011!e\u000b\b\u0003G%\u0002\"\u0001J\u0014\u000e\u0003\u0015R!A\n\f\u0002\rq\u0012xn\u001c;?\u0015\u0005A\u0013!B:dC2\f\u0017B\u0001\u0016(\u0003\u0019\u0001&/\u001a3fM&\u0011A&\f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005):\u0013\u0001C(qi&l\u0017N_3\u0011\u0005A\"Q\"\u0001\u0001\u0003\u0011=\u0003H/[7ju\u0016\u001c\"\u0001B\u001a\u0011\u0007QJ4(D\u00016\u0015\t1t'A\u0003sk2,7O\u0003\u00029\u001d\u0005A1-\u0019;bYf\u001cH/\u0003\u0002;k\ta!+\u001e7f\u000bb,7-\u001e;peB\u0011A(Q\u0007\u0002{)\u0011ahP\u0001\bY><\u0017nY1m\u0015\t\u0001u'A\u0003qY\u0006t7/\u0003\u0002C{\tYAj\\4jG\u0006d\u0007\u000b\\1o)\u0005y\u0013a\u00022bi\u000eDWm]\u000b\u0002\rB\u0019q\t\u0014(\u000e\u0003!S!!\u0013&\u0002\u0013%lW.\u001e;bE2,'BA&(\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003\u001b\"\u0013A\u0001T5tiB\u0011q\nU\u0007\u0002\t%\u0011\u0011+\u000f\u0002\u0006\u0005\u0006$8\r[\u0001\tE\u0006$8\r[3tA\u0005Ar-\u001a;TG\u0006tW\t_3d!\u0006\u0014H/\u001b;j_:\u001c\u0016N_3\u0015\u0005UK\u0006C\u0001,X\u001b\u00059\u0013B\u0001-(\u0005\u0011auN\\4\t\u000biC\u0001\u0019A.\u0002\tAd\u0017M\u001c\t\u00039zk\u0011!\u0018\u0006\u0003\u00179I!aX/\u0003\u0013M\u0003\u0018M]6QY\u0006t\u0007")
public class PruneFileSourcePartitionsSuite
extends PrunePartitionSuiteBase {
    private volatile PruneFileSourcePartitionsSuite$Optimize$ Optimize$module;

    public PruneFileSourcePartitionsSuite$Optimize$ Optimize() {
        if (this.Optimize$module == null) {
            this.Optimize$lzycompute$1();
        }
        return this.Optimize$module;
    }

    @Override
    public String format() {
        return "parquet";
    }

    @Override
    public long getScanExecPartitionSize(SparkPlan plan) {
        return ((FileSourceScanExec)plan.collectFirst((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                FileSourceScanExec fileSourceScanExec;
                A1 A1 = x1;
                Object object = A1 instanceof FileSourceScanExec ? (fileSourceScanExec = (FileSourceScanExec)A1) : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(SparkPlan x1) {
                SparkPlan sparkPlan = x1;
                boolean bl = sparkPlan instanceof FileSourceScanExec;
                return bl;
            }
        }).get()).selectedPartitions().length;
    }

    private final void Optimize$lzycompute$1() {
        PruneFileSourcePartitionsSuite pruneFileSourcePartitionsSuite = this;
        synchronized (pruneFileSourcePartitionsSuite) {
            if (this.Optimize$module == null) {
                this.Optimize$module = new PruneFileSourcePartitionsSuite$Optimize$(this);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$new$4(CatalogTable tableMeta$1, StructField f) {
        return tableMeta$1.partitionColumnNames().contains((Object)f.name());
    }

    public static final /* synthetic */ void $anonfun$new$3(PruneFileSourcePartitionsSuite $this, File dir) {
        $this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(139).append("\n            |CREATE EXTERNAL TABLE test(i int)\n            |PARTITIONED BY (p int)\n            |STORED AS parquet\n            |LOCATION '").append(dir.toURI()).append("'").toString())).stripMargin());
        CatalogTable tableMeta = $this.spark().sharedState().externalCatalog().getTable("default", "test");
        CatalogFileIndex catalogFileIndex = new CatalogFileIndex($this.spark(), tableMeta, 0L);
        StructType dataSchema = StructType$.MODULE$.apply((Seq)tableMeta.schema().filterNot((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)PruneFileSourcePartitionsSuite.$anonfun$new$4(tableMeta, f))));
        HadoopFsRelation relation = new HadoopFsRelation((FileIndex)catalogFileIndex, tableMeta.partitionSchema(), dataSchema, (Option)None$.MODULE$, (FileFormat)new ParquetFileFormat(), Predef$.MODULE$.Map().empty(), $this.spark());
        LogicalRelation logicalRelation = LogicalRelation$.MODULE$.apply((BaseRelation)relation, tableMeta);
        LogicalPlan query = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new Project((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "i")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "p"))})), (LogicalPlan)new Filter((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "p")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1)), (LogicalPlan)logicalRelation))).analyze();
        LogicalPlan optimized = (LogicalPlan)$this.Optimize().execute((TreeNode)query);
        AttributeSet $org_scalatest_assert_macro_left = optimized.missingInput();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PruneFileSourcePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
    }

    public PruneFileSourcePartitionsSuite() {
        this.test("PruneFileSourcePartitions should not change the output of LogicalRelation", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            PruneFileSourcePartitionsSuite.$anonfun$new$3(this, dir);
            return BoxedUnit.UNIT;
        })), new Position("PruneFileSourcePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 43));
        this.test("SPARK-20986 Reset table's statistics after PruneFileSourcePartitions rule", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tbl"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            BigInt size2;
            Bool bool;
            this.spark().range(10L).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "id % 3 as p"})).write().partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"p"})).saveAsTable("tbl");
            this.sql().apply((Object)"ANALYZE TABLE tbl COMPUTE STATISTICS");
            Option tableStats = this.spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply("tbl")).stats();
            Bool $org_scalatest_assert_macro_left = Bool$.MODULE$.simpleMacroBool(tableStats.isDefined(), "tableStats.isDefined", Prettifier$.MODULE$.default());
            if ($org_scalatest_assert_macro_left.value()) {
                BigInt $org_scalatest_assert_macro_left2 = ((CatalogStatistics)tableStats.get()).sizeInBytes();
                BigInt $org_scalatest_assert_macro_right = BigInt$.MODULE$.int2bigInt(0);
                bool = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, ">", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left2.$greater((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            } else {
                bool = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
            }
            Bool $org_scalatest_assert_macro_right = bool;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "&&", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$amp$amp((Function0 & Serializable & scala.Serializable)() -> $org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"tableStats is lost", Prettifier$.MODULE$.default(), new Position("PruneFileSourcePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
            Dataset df = (Dataset)this.sql().apply((Object)"SELECT * FROM tbl WHERE p = 1");
            Seq sizes1 = df.queryExecution().analyzed().collect((PartialFunction)new scala.Serializable(null){
                public static final long serialVersionUID = 0L;

                public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 instanceof LogicalRelation) {
                        LogicalRelation logicalRelation = (LogicalRelation)A1;
                        object = ((CatalogStatistics)((CatalogTable)logicalRelation.catalogTable().get()).stats().get()).sizeInBytes();
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(LogicalPlan x1) {
                    LogicalPlan logicalPlan = x1;
                    boolean bl = logicalPlan instanceof LogicalRelation;
                    return bl;
                }
            });
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)sizes1.size()));
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)new StringBuilder(17).append("Size wrong for:\n ").append(df.queryExecution()).toString(), Prettifier$.MODULE$.default(), new Position("PruneFileSourcePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88));
            BigInt $org_scalatest_assert_macro_left4 = (BigInt)sizes1.apply(0);
            BigInt $org_scalatest_assert_macro_right3 = ((CatalogStatistics)tableStats.get()).sizeInBytes();
            BigInt bigInt = $org_scalatest_assert_macro_left4;
            BigInt bigInt2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right3, !(bigInt != null ? !bigInt.equals(bigInt2) : bigInt2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("PruneFileSourcePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
            Seq relations = df.queryExecution().optimizedPlan().collect((PartialFunction)new scala.Serializable(null){
                public static final long serialVersionUID = 0L;

                public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    LogicalRelation logicalRelation;
                    A1 A1 = x2;
                    Object object = A1 instanceof LogicalRelation ? (logicalRelation = (LogicalRelation)A1) : function1.apply(x2);
                    return (B1)object;
                }

                public final boolean isDefinedAt(LogicalPlan x2) {
                    LogicalPlan logicalPlan = x2;
                    boolean bl = logicalPlan instanceof LogicalRelation;
                    return bl;
                }
            });
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)relations.size()));
            int $org_scalatest_assert_macro_right4 = 1;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)new StringBuilder(17).append("Size wrong for:\n ").append(df.queryExecution()).toString(), Prettifier$.MODULE$.default(), new Position("PruneFileSourcePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94));
            BigInt $org_scalatest_assert_macro_left6 = size2 = ((LogicalPlanStats)relations.apply(0)).stats().sizeInBytes();
            BigInt $org_scalatest_assert_macro_right5 = ((CatalogStatistics)((CatalogTable)((LogicalRelation)relations.apply(0)).catalogTable().get()).stats().get()).sizeInBytes();
            BigInt bigInt3 = $org_scalatest_assert_macro_left6;
            BigInt bigInt4 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right5, !(bigInt3 != null ? !bigInt3.equals(bigInt4) : bigInt4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("PruneFileSourcePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
            BigInt $org_scalatest_assert_macro_left7 = size2;
            BigInt $org_scalatest_assert_macro_right6 = ((CatalogStatistics)tableStats.get()).sizeInBytes();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "<", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left7.$less((Object)$org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("PruneFileSourcePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
        }), new Position("PruneFileSourcePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
        this.test("SPARK-26576 Broadcast hint not applied to partitioned table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tbl"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.AUTO_BROADCASTJOIN_THRESHOLD().key()), (Object)"-1")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().range(10L).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "id % 3 as p"})).write().partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"p"})).saveAsTable("tbl");
            Dataset df = this.spark().table("tbl");
            QueryExecution qe = df.join(functions$.MODULE$.broadcast(df), "p").queryExecution();
            Matchers$.MODULE$.convertToAnyShouldWrapper((Object)qe.sparkPlan().collect((PartialFunction)new scala.Serializable(null){
                public static final long serialVersionUID = 0L;

                public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                    BroadcastHashJoinExec broadcastHashJoinExec;
                    A1 A1 = x3;
                    Object object = A1 instanceof BroadcastHashJoinExec ? (broadcastHashJoinExec = (BroadcastHashJoinExec)A1) : function1.apply(x3);
                    return (B1)object;
                }

                public final boolean isDefinedAt(SparkPlan x3) {
                    SparkPlan sparkPlan = x3;
                    boolean bl = sparkPlan instanceof BroadcastHashJoinExec;
                    return bl;
                }
            }), new Position("PruneFileSourcePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107), Prettifier$.MODULE$.default()).should(Matchers$.MODULE$.have()).size(1L, Size$.MODULE$.sizeOfGenTraversable());
        })), new Position("PruneFileSourcePartitionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101));
    }
}

