/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.client;

import java.io.File;
import java.io.Serializable;
import java.sql.Date;
import java.time.ZoneId;
import java.util.Collections;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.dsl.package;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.AliasHelper;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.InSet;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.Predicate;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.plans.PlanTest;
import org.apache.spark.sql.catalyst.plans.PlanTestBase;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.hive.client.Shim_v0_13;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005%a\u0001\u0002\u0006\f\u0001aAQa\u000b\u0001\u0005\u00021Bqa\f\u0001C\u0002\u0013%\u0001\u0007\u0003\u00045\u0001\u0001\u0006I!\r\u0005\bk\u0001\u0011\r\u0011\"\u00037\u0011\u0019\u0011\u0005\u0001)A\u0005o!91\t\u0001b\u0001\n\u0013!\u0005BB'\u0001A\u0003%Q\tC\u0003O\u0001\u0011%q\nC\u0003w\u0001\u0011%qO\u0001\u0007GS2$XM]:Tk&$XM\u0003\u0002\r\u001b\u000511\r\\5f]RT!AD\b\u0002\t!Lg/\u001a\u0006\u0003!E\t1a]9m\u0015\t\u00112#A\u0003ta\u0006\u00148N\u0003\u0002\u0015+\u00051\u0011\r]1dQ\u0016T\u0011AF\u0001\u0004_J<7\u0001A\n\u0005\u0001ei2\u0005\u0005\u0002\u001b75\t\u0011#\u0003\u0002\u001d#\ti1\u000b]1sW\u001a+hnU;ji\u0016\u0004\"AH\u0011\u000e\u0003}Q!\u0001I\t\u0002\u0011%tG/\u001a:oC2L!AI\u0010\u0003\u000f1{wmZ5oOB\u0011A%K\u0007\u0002K)\u0011aeJ\u0001\u0006a2\fgn\u001d\u0006\u0003Q=\t\u0001bY1uC2L8\u000f^\u0005\u0003U\u0015\u0012\u0001\u0002\u00157b]R+7\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00035\u0002\"A\f\u0001\u000e\u0003-\tAa\u001d5j[V\t\u0011\u0007\u0005\u0002/e%\u00111g\u0003\u0002\u000b'\"LWn\u0018<1?F\u001a\u0014!B:iS6\u0004\u0013!\u0003;fgR$\u0016M\u00197f+\u00059\u0004C\u0001\u001dA\u001b\u0005I$B\u0001\u001e<\u0003!iW\r^1eCR\f'B\u0001\u001f>\u0003\t\tHN\u0003\u0002\u000f})\u0011qhE\u0001\u0007Q\u0006$wn\u001c9\n\u0005\u0005K$!\u0002+bE2,\u0017A\u0003;fgR$\u0016M\u00197fA\u0005Qa/\u0019:DQ\u0006\u00148i\u001c7\u0016\u0003\u0015\u0003\"AR&\u000e\u0003\u001dS!\u0001S%\u0002\u0007\u0005\u0004\u0018N\u0003\u0002K{\u0005IQ.\u001a;bgR|'/Z\u0005\u0003\u0019\u001e\u00131BR5fY\u0012\u001c6\r[3nC\u0006Ya/\u0019:DQ\u0006\u00148i\u001c7!\u0003)1\u0017\u000e\u001c;feR+7\u000f\u001e\u000b\u0005!Z\u001bG\u000f\u0005\u0002R)6\t!KC\u0001T\u0003\u0015\u00198-\u00197b\u0013\t)&K\u0001\u0003V]&$\b\"B,\t\u0001\u0004A\u0016\u0001\u00028b[\u0016\u0004\"!\u00171\u000f\u0005is\u0006CA.S\u001b\u0005a&BA/\u0018\u0003\u0019a$o\\8u}%\u0011qLU\u0001\u0007!J,G-\u001a4\n\u0005\u0005\u0014'AB*ue&twM\u0003\u0002`%\")A\r\u0003a\u0001K\u00069a-\u001b7uKJ\u001c\bc\u00014l]:\u0011q-\u001b\b\u00037\"L\u0011aU\u0005\u0003UJ\u000bq\u0001]1dW\u0006<W-\u0003\u0002m[\n\u00191+Z9\u000b\u0005)\u0014\u0006CA8s\u001b\u0005\u0001(BA9(\u0003-)\u0007\u0010\u001d:fgNLwN\\:\n\u0005M\u0004(AC#yaJ,7o]5p]\")Q\u000f\u0003a\u00011\u00061!/Z:vYR\f\u0011!\u0019\u000b\u0004qnd\bCA8z\u0013\tQ\bO\u0001\nBiR\u0014\u0018NY;uKJ+g-\u001a:f]\u000e,\u0007\"B,\n\u0001\u0004A\u0006\"B?\n\u0001\u0004q\u0018\u0001\u00033bi\u0006$\u0016\u0010]3\u0011\u0007}\f)!\u0004\u0002\u0002\u0002)\u0019\u00111A\b\u0002\u000bQL\b/Z:\n\t\u0005\u001d\u0011\u0011\u0001\u0002\t\t\u0006$\u0018\rV=qK\u0002")
public class FiltersSuite
extends SparkFunSuite
implements PlanTest {
    private final Shim_v0_13 shim;
    private final Table testTable;
    private final FieldSchema varCharCol;
    private String sparkHome;
    private volatile boolean bitmap$0;

    public LogicalPlan normalizeExprIds(LogicalPlan plan) {
        return PlanTestBase.normalizeExprIds$((PlanTestBase)this, (LogicalPlan)plan);
    }

    public LogicalPlan rewriteNameFromAttrNullability(LogicalPlan plan) {
        return PlanTestBase.rewriteNameFromAttrNullability$((PlanTestBase)this, (LogicalPlan)plan);
    }

    public LogicalPlan normalizePlan(LogicalPlan plan) {
        return PlanTestBase.normalizePlan$((PlanTestBase)this, (LogicalPlan)plan);
    }

    public void comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        PlanTestBase.comparePlans$((PlanTestBase)this, (LogicalPlan)plan1, (LogicalPlan)plan2, (boolean)checkAnalysis);
    }

    public boolean comparePlans$default$3() {
        return PlanTestBase.comparePlans$default$3$((PlanTestBase)this);
    }

    public void compareExpressions(Expression e1, Expression e2) {
        PlanTestBase.compareExpressions$((PlanTestBase)this, (Expression)e1, (Expression)e2);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$((SQLHelper)this, pairs, f);
    }

    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$((SQLHelper)this, f);
    }

    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$((SQLHelper)this, test);
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Option<Tuple2<Expression, LogicalPlan>> findExpressionAndTrackLineageDown(Expression exp, LogicalPlan plan) {
        return PredicateHelper.findExpressionAndTrackLineageDown$((PredicateHelper)this, (Expression)exp, (LogicalPlan)plan);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.canEvaluate$((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$((PredicateHelper)this, (Expression)expr);
    }

    public Option<Expression> extractPredicatesWithinOutputSet(Expression condition, AttributeSet outputSet) {
        return PredicateHelper.extractPredicatesWithinOutputSet$((PredicateHelper)this, (Expression)condition, (AttributeSet)outputSet);
    }

    public AttributeMap<Alias> getAliasMap(Project plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Project)plan);
    }

    public AttributeMap<Alias> getAliasMap(Aggregate plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Aggregate)plan);
    }

    public AttributeMap<Alias> getAliasMap(Seq<NamedExpression> exprs) {
        return AliasHelper.getAliasMap$((AliasHelper)this, exprs);
    }

    public Expression replaceAlias(Expression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAlias$((AliasHelper)this, (Expression)expr, aliasMap);
    }

    public NamedExpression replaceAliasButKeepName(NamedExpression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAliasButKeepName$((AliasHelper)this, (NamedExpression)expr, aliasMap);
    }

    public Expression trimAliases(Expression e) {
        return AliasHelper.trimAliases$((AliasHelper)this, (Expression)e);
    }

    public <T extends Expression> T trimNonTopLevelAliases(T e) {
        return (T)AliasHelper.trimNonTopLevelAliases$((AliasHelper)this, e);
    }

    private String sparkHome$lzycompute() {
        FiltersSuite filtersSuite = this;
        synchronized (filtersSuite) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$((SQLHelper)this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    public String sparkHome() {
        return !this.bitmap$0 ? this.sparkHome$lzycompute() : this.sparkHome;
    }

    private Shim_v0_13 shim() {
        return this.shim;
    }

    private Table testTable() {
        return this.testTable;
    }

    private FieldSchema varCharCol() {
        return this.varCharCol;
    }

    private void filterTest(String name, Seq<Expression> filters, String result) {
        this.test(name, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ADVANCED_PARTITION_PREDICATE_PUSHDOWN().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String converted;
            String string = converted = this.shim().convertFilters(this.testTable(), filters, this.conf().sessionLocalTimeZone());
            String string2 = result;
            if (string == null ? string2 != null : !string.equals(string2)) {
                throw this.fail(new StringBuilder(37).append("Expected ").append(filters.mkString(",")).append(" to convert to '").append(result).append("' but got '").append(converted).append("'").toString(), new Position("FiltersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 126));
            }
        }), new Position("FiltersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 122));
    }

    private AttributeReference a(String name, DataType dataType) {
        String x$1 = name;
        DataType x$2 = dataType;
        boolean x$3 = AttributeReference$.MODULE$.apply$default$3();
        Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$5 = AttributeReference$.MODULE$.apply$default$5(x$1, x$2, x$3, x$4);
        Seq x$6 = AttributeReference$.MODULE$.apply$default$6(x$1, x$2, x$3, x$4);
        return new AttributeReference(x$1, x$2, x$3, x$4, x$5, x$6);
    }

    private final void checkConverted$1(InSet inSet, String result) {
        InSet inSet2 = inSet;
        String $org_scalatest_assert_macro_left = this.shim().convertFilters(this.testTable(), (Seq)Nil$.MODULE$.$colon$colon((Object)inSet2), this.conf().sessionLocalTimeZone());
        String $org_scalatest_assert_macro_right = result;
        String string = $org_scalatest_assert_macro_left;
        String string2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FiltersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 151));
    }

    public static final /* synthetic */ Object $anonfun$new$7(int s) {
        return Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)s)).eval(org.apache.spark.sql.catalyst.expressions.package$.MODULE$.EmptyRow());
    }

    public static final /* synthetic */ Object $anonfun$new$8(int s) {
        return Literal$.MODULE$.apply((Object)((Object)BoxesRunTime.boxToInteger((int)s)).toString()).eval(org.apache.spark.sql.catalyst.expressions.package$.MODULE$.EmptyRow());
    }

    public static final /* synthetic */ Object $anonfun$new$9(int s) {
        return Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)s)).eval(org.apache.spark.sql.catalyst.expressions.package$.MODULE$.EmptyRow());
    }

    public static final /* synthetic */ Object $anonfun$new$10(int s) {
        return Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)s)).eval(org.apache.spark.sql.catalyst.expressions.package$.MODULE$.EmptyRow());
    }

    public static final /* synthetic */ Object $anonfun$new$11(int d) {
        return new Literal((Object)BoxesRunTime.boxToInteger((int)d), (DataType)DateType$.MODULE$).eval(org.apache.spark.sql.catalyst.expressions.package$.MODULE$.EmptyRow());
    }

    public FiltersSuite() {
        AliasHelper.$init$((AliasHelper)this);
        PredicateHelper.$init$((PredicateHelper)this);
        SQLHelper.$init$((SQLHelper)this);
        SQLConfHelper.$init$((SQLConfHelper)this);
        PlanTestBase.$init$((PlanTestBase)this);
        this.shim = new Shim_v0_13();
        this.testTable = new Table("default", "test");
        this.varCharCol = new FieldSchema();
        this.varCharCol().setName("varchar");
        this.varCharCol().setType("varchar");
        this.testTable().setPartCols(Collections.singletonList(this.varCharCol()));
        Predicate predicate = package.expressions$.MODULE$.DslExpression((Expression)this.a("stringcol", (DataType)StringType$.MODULE$)).$greater((Expression)Literal$.MODULE$.apply((Object)"test"));
        this.filterTest("string filter", (Seq<Expression>)Nil$.MODULE$.$colon$colon((Object)predicate), "stringcol > \"test\"");
        Predicate predicate2 = package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)"test")).$greater((Expression)this.a("stringcol", (DataType)StringType$.MODULE$));
        this.filterTest("string filter backwards", (Seq<Expression>)Nil$.MODULE$.$colon$colon((Object)predicate2), "\"test\" > stringcol");
        Predicate predicate3 = package.expressions$.MODULE$.DslExpression((Expression)this.a("intcol", (DataType)IntegerType$.MODULE$)).$eq$eq$eq((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)));
        this.filterTest("int filter", (Seq<Expression>)Nil$.MODULE$.$colon$colon((Object)predicate3), "intcol = 1");
        Predicate predicate4 = package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))).$eq$eq$eq((Expression)this.a("intcol", (DataType)IntegerType$.MODULE$));
        this.filterTest("int filter backwards", (Seq<Expression>)Nil$.MODULE$.$colon$colon((Object)predicate4), "1 = intcol");
        Predicate predicate5 = package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))).$eq$eq$eq((Expression)this.a("intcol", (DataType)IntegerType$.MODULE$));
        Predicate predicate6 = package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)"a")).$eq$eq$eq((Expression)this.a("strcol", (DataType)IntegerType$.MODULE$));
        this.filterTest("int and string filter", (Seq<Expression>)Nil$.MODULE$.$colon$colon((Object)predicate6).$colon$colon((Object)predicate5), "1 = intcol and \"a\" = strcol");
        Predicate predicate7 = package.expressions$.MODULE$.DslExpression((Expression)this.a("datecol", (DataType)DateType$.MODULE$)).$eq$eq$eq((Expression)Literal$.MODULE$.apply((Object)Date.valueOf("2019-01-01")));
        this.filterTest("date filter", (Seq<Expression>)Nil$.MODULE$.$colon$colon((Object)predicate7), "datecol = 2019-01-01");
        Expression expression = package.expressions$.MODULE$.DslExpression((Expression)this.a("datecol", (DataType)DateType$.MODULE$)).in((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{Literal$.MODULE$.apply((Object)Date.valueOf("2019-01-01")), Literal$.MODULE$.apply((Object)Date.valueOf("2019-01-07"))}));
        this.filterTest("date filter with IN predicate", (Seq<Expression>)Nil$.MODULE$.$colon$colon((Object)expression), "(datecol = 2019-01-01 or datecol = 2019-01-07)");
        Predicate predicate8 = package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)Date.valueOf("2019-01-01"))).$eq$eq$eq((Expression)this.a("datecol", (DataType)DateType$.MODULE$));
        Predicate predicate9 = package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)"a")).$eq$eq$eq((Expression)this.a("strcol", (DataType)IntegerType$.MODULE$));
        this.filterTest("date and string filter", (Seq<Expression>)Nil$.MODULE$.$colon$colon((Object)predicate9).$colon$colon((Object)predicate8), "2019-01-01 = datecol and \"a\" = strcol");
        Predicate predicate10 = package.expressions$.MODULE$.DslExpression((Expression)this.a("datecol", (DataType)DateType$.MODULE$)).$eq$eq$eq((Expression)Literal$.MODULE$.apply(null));
        this.filterTest("date filter with null", (Seq<Expression>)Nil$.MODULE$.$colon$colon((Object)predicate10), "");
        InSet inSet = new InSet((Expression)this.a("strcol", (DataType)StringType$.MODULE$), (Set)((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1", "2"}))).map((Function1 & Serializable & scala.Serializable)s -> UTF8String.fromString((String)s), Set$.MODULE$.canBuildFrom()));
        this.filterTest("string filter with InSet predicate", (Seq<Expression>)Nil$.MODULE$.$colon$colon((Object)inSet), "(strcol = \"1\" or strcol = \"2\")");
        Predicate predicate11 = package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)"")).$eq$eq$eq((Expression)this.a("varchar", (DataType)StringType$.MODULE$));
        this.filterTest("skip varchar", (Seq<Expression>)Nil$.MODULE$.$colon$colon((Object)predicate11), "");
        Predicate predicate12 = package.expressions$.MODULE$.DslExpression((Expression)this.a("stringcol", (DataType)StringType$.MODULE$)).$eq$eq$eq((Expression)Literal$.MODULE$.apply((Object)"p1\" and q=\"q1"));
        Predicate predicate13 = package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)"p2\" and q=\"q2")).$eq$eq$eq((Expression)this.a("stringcol", (DataType)StringType$.MODULE$));
        this.filterTest("SPARK-19912 String literals should be escaped for Hive metastore partition pruning", (Seq<Expression>)Nil$.MODULE$.$colon$colon((Object)predicate13).$colon$colon((Object)predicate12), "stringcol = 'p1\" and q=\"q1' and 'p2\" and q=\"q2' = stringcol");
        Expression expression2 = package.expressions$.MODULE$.DslExpression((Expression)this.a("intcol", (DataType)IntegerType$.MODULE$)).in((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)), Literal$.MODULE$.apply(null)}));
        this.filterTest("SPARK-24879 null literals should be ignored for IN constructs", (Seq<Expression>)Nil$.MODULE$.$colon$colon((Object)expression2), "(intcol = 1)");
        Predicate predicate14 = package.expressions$.MODULE$.DslExpression((Expression)this.a("intcol", (DataType)IntegerType$.MODULE$)).$eq$bang$eq((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)));
        Predicate predicate15 = package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)"a")).$eq$bang$eq((Expression)this.a("strcol", (DataType)IntegerType$.MODULE$));
        this.filterTest("NOT: int and string filters", (Seq<Expression>)Nil$.MODULE$.$colon$colon((Object)predicate15).$colon$colon((Object)predicate14), "intcol != 1 and \"a\" != strcol");
        Predicate predicate16 = package.expressions$.MODULE$.DslExpression((Expression)this.a("datecol", (DataType)DateType$.MODULE$)).$eq$bang$eq((Expression)Literal$.MODULE$.apply((Object)Date.valueOf("2019-01-01")));
        this.filterTest("NOT: date filter", (Seq<Expression>)Nil$.MODULE$.$colon$colon((Object)predicate16), "datecol != 2019-01-01");
        Expression expression3 = package.expressions$.MODULE$.DslExpression((Expression)this.a("intcol", (DataType)IntegerType$.MODULE$)).in((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{Literal$.MODULE$.apply(null)}));
        this.filterTest("SPARK-24879 IN predicates with only NULLs will not cause a NPE", (Seq<Expression>)Nil$.MODULE$.$colon$colon((Object)expression3), "");
        Predicate predicate17 = package.expressions$.MODULE$.DslExpression((Expression)this.a("intcol", (DataType)IntegerType$.MODULE$)).$eq$eq$eq((Expression)new Literal(null, (DataType)IntegerType$.MODULE$));
        this.filterTest("typecast null literals should not be pushed down in simple predicates", (Seq<Expression>)Nil$.MODULE$.$colon$colon((Object)predicate17), "");
        this.test("turn on/off ADVANCED_PARTITION_PREDICATE_PUSHDOWN", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, false}))).foreach((Function1 & Serializable & scala.Serializable)enabled -> {
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ADVANCED_PARTITION_PREDICATE_PUSHDOWN().key()), (Object)((Object)BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)enabled))).toString())}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Predicate predicate = package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))).$eq$eq$eq((Expression)$this.a("intcol", (DataType)IntegerType$.MODULE$))).$bar$bar((Expression)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2))).$eq$eq$eq((Expression)$this.a("intcol", (DataType)IntegerType$.MODULE$)));
                List filters = Nil$.MODULE$.$colon$colon((Object)predicate);
                String converted = $this.shim().convertFilters($this.testTable(), (Seq)filters, $this.conf().sessionLocalTimeZone());
                if (enabled) {
                    String $org_scalatest_assert_macro_left = converted;
                    String $org_scalatest_assert_macro_right = "(1 = intcol or 2 = intcol)";
                    String string = $org_scalatest_assert_macro_left;
                    String string2 = $org_scalatest_assert_macro_right;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FiltersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 141));
                } else {
                    String $org_scalatest_assert_macro_left = converted;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FiltersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143));
                }
            });
            return BoxedUnit.UNIT;
        }), new Position("FiltersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132));
        this.test("SPARK-33416: Avoid Hive metastore stack overflow when InSet predicate have many values", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.HIVE_METASTORE_PARTITION_PRUNING_INSET_THRESHOLD().key()), (Object)"15")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkConverted$1(new InSet((Expression)this.a("intcol", (DataType)IntegerType$.MODULE$), ((TraversableOnce)package$.MODULE$.Range().apply(1, 20).map((Function1 & Serializable & scala.Serializable)s -> FiltersSuite.$anonfun$new$7(BoxesRunTime.unboxToInt((Object)s)), IndexedSeq$.MODULE$.canBuildFrom())).toSet()), "(intcol >= 1 and intcol <= 19)");
            this.checkConverted$1(new InSet((Expression)this.a("stringcol", (DataType)StringType$.MODULE$), ((TraversableOnce)package$.MODULE$.Range().apply(1, 20).map((Function1 & Serializable & scala.Serializable)s -> FiltersSuite.$anonfun$new$8(BoxesRunTime.unboxToInt((Object)s)), IndexedSeq$.MODULE$.canBuildFrom())).toSet()), "(stringcol >= \"1\" and stringcol <= \"9\")");
            this.checkConverted$1(new InSet(package.expressions$.MODULE$.DslExpression((Expression)this.a("intcol", (DataType)IntegerType$.MODULE$)).cast((DataType)LongType$.MODULE$), ((TraversableOnce)package$.MODULE$.Range().apply(1, 20).map((Function1 & Serializable & scala.Serializable)s -> FiltersSuite.$anonfun$new$9(BoxesRunTime.unboxToInt((Object)s)), IndexedSeq$.MODULE$.canBuildFrom())).toSet()), "(intcol >= 1 and intcol <= 19)");
            this.checkConverted$1(new InSet((Expression)this.a("doublecol", (DataType)DoubleType$.MODULE$), ((TraversableOnce)package$.MODULE$.Range().apply(1, 20).map((Function1 & Serializable & scala.Serializable)s -> FiltersSuite.$anonfun$new$10(BoxesRunTime.unboxToInt((Object)s)), IndexedSeq$.MODULE$.canBuildFrom())).toSet()), "");
            this.checkConverted$1(new InSet((Expression)this.a("datecol", (DataType)DateType$.MODULE$), ((TraversableOnce)package$.MODULE$.Range().apply(1, 20).map((Function1 & Serializable & scala.Serializable)d -> FiltersSuite.$anonfun$new$11(BoxesRunTime.unboxToInt((Object)d)), IndexedSeq$.MODULE$.canBuildFrom())).toSet()), "(datecol >= 1970-01-02 and datecol <= 1970-01-20)");
        }), new Position("FiltersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149));
        this.test("SPARK-34515: Fix NPE if InSet contains null value during getPartitionsByFilter", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.HIVE_METASTORE_PARTITION_PRUNING_INSET_THRESHOLD().key()), (Object)"2")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String converted;
            InSet filter = new InSet((Expression)this.a("p", (DataType)IntegerType$.MODULE$), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2)})));
            String $org_scalatest_assert_macro_left = converted = this.shim().convertFilters(this.testTable(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InSet[]{filter})), this.conf().sessionLocalTimeZone());
            String $org_scalatest_assert_macro_right = "(p >= 1 and p <= 2)";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FiltersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 186));
        }), new Position("FiltersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 182));
        this.test("SPARK-34538: Skip InSet null value during push filter to Hive metastore", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.HIVE_METASTORE_PARTITION_PRUNING_INSET_THRESHOLD().key()), (Object)"3")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                String intConverted;
                InSet intFilter = new InSet((Expression)this.a("p", (DataType)IntegerType$.MODULE$), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2)})));
                String $org_scalatest_assert_macro_left = intConverted = this.shim().convertFilters(this.testTable(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InSet[]{intFilter})), this.conf().sessionLocalTimeZone());
                String $org_scalatest_assert_macro_right = "(p = 1 or p = 2)";
                String string = $org_scalatest_assert_macro_left;
                String string2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FiltersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 194));
            });
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.HIVE_METASTORE_PARTITION_PRUNING_INSET_THRESHOLD().key()), (Object)"3")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                String dateConverted;
                Object[] objectArray = new Object[3];
                objectArray[0] = null;
                Literal qual$1 = Literal$.MODULE$.apply((Object)Date.valueOf("2020-01-01"));
                InternalRow x$1 = qual$1.eval$default$1();
                objectArray[1] = qual$1.eval(x$1);
                Literal qual$2 = Literal$.MODULE$.apply((Object)Date.valueOf("2021-01-01"));
                InternalRow x$2 = qual$2.eval$default$1();
                objectArray[2] = qual$2.eval(x$2);
                InSet dateFilter = new InSet((Expression)this.a("p", (DataType)DateType$.MODULE$), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.genericWrapArray((Object)objectArray)));
                String $org_scalatest_assert_macro_left = dateConverted = this.shim().convertFilters(this.testTable(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InSet[]{dateFilter})), this.conf().sessionLocalTimeZone());
                String $org_scalatest_assert_macro_right = "(p = 2020-01-01 or p = 2021-01-01)";
                String string = $org_scalatest_assert_macro_left;
                String string2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FiltersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 201));
            });
        }, new Position("FiltersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 190));
    }
}

