/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive;

import java.io.Serializable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.ShowCreateTableSuite;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.hive.HiveExternalCatalog;
import org.apache.spark.sql.hive.client.HiveClient;
import org.apache.spark.sql.hive.test.TestHiveContext;
import org.apache.spark.sql.hive.test.TestHiveSingleton;
import org.apache.spark.sql.internal.HiveSerDe$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.test.SQLTestUtils;
import org.apache.spark.sql.types.StructType;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001e3AAC\u0006\u0001-!)\u0011\u0005\u0001C\u0001E!9Q\u0005\u0001a\u0001\n\u00131\u0003bB\u0017\u0001\u0001\u0004%IA\f\u0005\u0007i\u0001\u0001\u000b\u0015B\u0014\t\u000bU\u0002A\u0011\u000b\u001c\t\u000b]\u0002A\u0011\u000b\u001c\t\u000ba\u0002A\u0011B\u001d\t\u000b\u001d\u0003A\u0011\u0002%\t\u000b-\u0003A\u0011\u0002'\u00031!Kg/Z*i_^\u001c%/Z1uKR\u000b'\r\\3Tk&$XM\u0003\u0002\r\u001b\u0005!\u0001.\u001b<f\u0015\tqq\"A\u0002tc2T!\u0001E\t\u0002\u000bM\u0004\u0018M]6\u000b\u0005I\u0019\u0012AB1qC\u000eDWMC\u0001\u0015\u0003\ry'oZ\u0002\u0001'\r\u0001qc\u0007\t\u00031ei\u0011!D\u0005\u000355\u0011Ac\u00155po\u000e\u0013X-\u0019;f)\u0006\u0014G.Z*vSR,\u0007C\u0001\u000f \u001b\u0005i\"B\u0001\u0010\f\u0003\u0011!Xm\u001d;\n\u0005\u0001j\"!\u0005+fgRD\u0015N^3TS:<G.\u001a;p]\u00061A(\u001b8jiz\"\u0012a\t\t\u0003I\u0001i\u0011aC\u0001\u001a_JLwm\u0011:fCR,\u0007*\u001b<f)\u0006\u0014G.Z\"p]\u001aLw-F\u0001(!\tA3&D\u0001*\u0015\u0005Q\u0013!B:dC2\f\u0017B\u0001\u0017*\u0005\u001d\u0011un\u001c7fC:\fQd\u001c:jO\u000e\u0013X-\u0019;f\u0011&4X\rV1cY\u0016\u001cuN\u001c4jO~#S-\u001d\u000b\u0003_I\u0002\"\u0001\u000b\u0019\n\u0005EJ#\u0001B+oSRDqaM\u0002\u0002\u0002\u0003\u0007q%A\u0002yIE\n!d\u001c:jO\u000e\u0013X-\u0019;f\u0011&4X\rV1cY\u0016\u001cuN\u001c4jO\u0002\n\u0011BY3g_J,\u0017\t\u001c7\u0015\u0003=\n\u0001\"\u00194uKJ\fE\u000e\\\u0001\u0013GJ,\u0017\r^3SC^D\u0015N^3UC\ndW\r\u0006\u00020u!)1h\u0002a\u0001y\u0005\u0019A\r\u001a7\u0011\u0005u\"eB\u0001 C!\ty\u0014&D\u0001A\u0015\t\tU#\u0001\u0004=e>|GOP\u0005\u0003\u0007&\na\u0001\u0015:fI\u00164\u0017BA#G\u0005\u0019\u0019FO]5oO*\u00111)K\u0001\u001cG\",7m[\"sK\u0006$Xm\u00159be.$\u0016M\u00197f\u0003ND\u0015N^3\u0015\u0005=J\u0005\"\u0002&\t\u0001\u0004a\u0014!\u0003;bE2,g*Y7f\u0003Y\u0019\u0007.Z2l\u0011&4XmQ1uC2|w\rV1cY\u0016\u001cHcA\u0018N/\")a*\u0003a\u0001\u001f\u0006I\u0001.\u001b<f)\u0006\u0014G.\u001a\t\u0003!Vk\u0011!\u0015\u0006\u0003%N\u000bqaY1uC2|wM\u0003\u0002U\u001b\u0005A1-\u0019;bYf\u001cH/\u0003\u0002W#\na1)\u0019;bY><G+\u00192mK\")\u0001,\u0003a\u0001\u001f\u0006Q1\u000f]1sWR\u000b'\r\\3")
public class HiveShowCreateTableSuite
extends ShowCreateTableSuite
implements TestHiveSingleton {
    private boolean origCreateHiveTableConfig;
    private final boolean enableAutoThreadAudit;
    private final SparkSession spark;
    private final TestHiveContext hiveContext;
    private final HiveClient hiveClient;

    @Override
    public /* synthetic */ void org$apache$spark$sql$hive$test$TestHiveSingleton$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public boolean enableAutoThreadAudit() {
        return this.enableAutoThreadAudit;
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public TestHiveContext hiveContext() {
        return this.hiveContext;
    }

    @Override
    public HiveClient hiveClient() {
        return this.hiveClient;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$enableAutoThreadAudit_$eq(boolean x$1) {
        this.enableAutoThreadAudit = x$1;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$hiveContext_$eq(TestHiveContext x$1) {
        this.hiveContext = x$1;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$hiveClient_$eq(HiveClient x$1) {
        this.hiveClient = x$1;
    }

    private boolean origCreateHiveTableConfig() {
        return this.origCreateHiveTableConfig;
    }

    private void origCreateHiveTableConfig_$eq(boolean x$1) {
        this.origCreateHiveTableConfig = x$1;
    }

    public void beforeAll() {
        SQLTestUtils.beforeAll$((SQLTestUtils)this);
        this.origCreateHiveTableConfig_$eq(BoxesRunTime.unboxToBoolean((Object)this.spark().conf().get(SQLConf$.MODULE$.LEGACY_CREATE_HIVE_TABLE_BY_DEFAULT())));
        this.spark().conf().set(SQLConf$.MODULE$.LEGACY_CREATE_HIVE_TABLE_BY_DEFAULT().key(), true);
    }

    @Override
    public void afterAll() {
        this.spark().conf().set(SQLConf$.MODULE$.LEGACY_CREATE_HIVE_TABLE_BY_DEFAULT().key(), this.origCreateHiveTableConfig());
        TestHiveSingleton.afterAll$(this);
    }

    private void createRawHiveTable(String ddl) {
        ((HiveExternalCatalog)this.hiveContext().sharedState().externalCatalog().unwrapped()).client().runSqlHive(ddl);
    }

    private void checkCreateSparkTableAsHive(String tableName) {
        TableIdentifier table = new TableIdentifier(tableName, (Option)new Some((Object)"default"));
        String db = (String)table.database().get();
        CatalogTable hiveTable = this.spark().sharedState().externalCatalog().getTable(db, table.table());
        String sparkDDL = ((Row)((Dataset)this.sql().apply((Object)new StringBuilder(18).append("SHOW CREATE TABLE ").append(table.quotedString()).toString())).head()).getString(0);
        this.sql().apply((Object)new StringBuilder(11).append("DROP TABLE ").append(table.quotedString()).toString());
        try {
            this.sql().apply((Object)sparkDDL);
            CatalogTable sparkTable = this.spark().sharedState().externalCatalog().getTable(db, table.table());
            this.checkHiveCatalogTables(hiveTable, sparkTable);
        }
        finally {
            this.sql().apply((Object)new StringBuilder(21).append("DROP TABLE IF EXISTS ").append(table.table()).toString());
        }
    }

    private void checkHiveCatalogTables(CatalogTable hiveTable, CatalogTable sparkTable) {
        CatalogTable $org_scalatest_assert_macro_left = HiveShowCreateTableSuite.normalize$1(HiveShowCreateTableSuite.fillSerdeFromProvider$1(sparkTable));
        CatalogTable $org_scalatest_assert_macro_right = HiveShowCreateTableSuite.normalize$1(hiveTable);
        CatalogTable catalogTable = $org_scalatest_assert_macro_left;
        CatalogTable catalogTable2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(catalogTable != null ? !catalogTable.equals(catalogTable2) : catalogTable2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveShowCreateTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 318));
    }

    public static final /* synthetic */ boolean $anonfun$checkHiveCatalogTables$1(Set nondeterministicProps$1, String x$1) {
        return !nondeterministicProps$1.contains((Object)x$1);
    }

    private static final CatalogTable normalize$1(CatalogTable table) {
        Set nondeterministicProps = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CreateTime", "transient_lastDdlTime", "grantTime", "lastUpdateTime", "last_modified_by", "last_modified_time", "Owner:", "totalNumberFiles", "maxFileSize", "minFileSize"}));
        long x$7 = 0L;
        long x$8 = 0L;
        Map x$9 = table.properties().filterKeys((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)HiveShowCreateTableSuite.$anonfun$checkHiveCatalogTables$1(nondeterministicProps, x$1))).toMap(Predef$.MODULE$.$conforms());
        None$ x$10 = None$.MODULE$;
        Map x$11 = Predef$.MODULE$.Map().empty();
        Map x$12 = Predef$.MODULE$.Map().empty();
        Option x$2 = table.storage().copy$default$1();
        Option x$3 = table.storage().copy$default$2();
        Option x$4 = table.storage().copy$default$3();
        Option x$5 = table.storage().copy$default$4();
        boolean x$6 = table.storage().copy$default$5();
        CatalogStorageFormat x$122 = table.storage().copy(x$2, x$3, x$4, x$5, x$6, x$12);
        None$ x$13 = None$.MODULE$;
        boolean x$14 = false;
        TableIdentifier x$15 = table.copy$default$1();
        CatalogTableType x$16 = table.copy$default$2();
        StructType x$17 = table.copy$default$4();
        Seq x$18 = table.copy$default$6();
        Option x$19 = table.copy$default$7();
        String x$20 = table.copy$default$8();
        String x$21 = table.copy$default$11();
        Option x$22 = table.copy$default$14();
        Option x$23 = table.copy$default$15();
        Seq x$24 = table.copy$default$16();
        boolean x$25 = table.copy$default$18();
        Option x$26 = table.copy$default$20();
        return table.copy(x$15, x$16, x$122, x$17, (Option)x$13, x$18, x$19, x$20, x$7, x$8, x$21, x$9, (Option)x$10, x$22, x$23, x$24, x$14, x$25, x$11, x$26);
    }

    private static final CatalogTable fillSerdeFromProvider$1(CatalogTable table) {
        return (CatalogTable)table.provider().flatMap((Function1 & Serializable & scala.Serializable)x$2 -> HiveSerDe$.MODULE$.sourceToSerDe(x$2)).map((Function1 & Serializable & scala.Serializable)hiveSerde -> {
            CatalogStorageFormat newStorage;
            Option x$1 = hiveSerde.inputFormat();
            Option x$2 = hiveSerde.outputFormat();
            Option x$3 = hiveSerde.serde();
            Option x$4 = table.storage().copy$default$1();
            boolean x$5 = table.storage().copy$default$5();
            Map x$6 = table.storage().copy$default$6();
            CatalogStorageFormat x$7 = newStorage = table.storage().copy(x$4, x$1, x$2, x$3, x$5, x$6);
            TableIdentifier x$8 = table.copy$default$1();
            CatalogTableType x$9 = table.copy$default$2();
            StructType x$10 = table.copy$default$4();
            Option x$11 = table.copy$default$5();
            Seq x$12 = table.copy$default$6();
            Option x$13 = table.copy$default$7();
            String x$14 = table.copy$default$8();
            long x$15 = table.copy$default$9();
            long x$16 = table.copy$default$10();
            String x$17 = table.copy$default$11();
            Map x$18 = table.copy$default$12();
            Option x$19 = table.copy$default$13();
            Option x$20 = table.copy$default$14();
            Option x$21 = table.copy$default$15();
            Seq x$22 = table.copy$default$16();
            boolean x$23 = table.copy$default$17();
            boolean x$24 = table.copy$default$18();
            Map x$25 = table.copy$default$19();
            Option x$26 = table.copy$default$20();
            return table.copy(x$8, x$9, x$7, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$22, x$23, x$24, x$25, x$26);
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> table);
    }

    public HiveShowCreateTableSuite() {
        TestHiveSingleton.$init$(this);
        this.origCreateHiveTableConfig = false;
        this.test("view", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, false}))).foreach((Function1 & Serializable & scala.Serializable)serde -> {
            this.withView((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"v1"}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)"CREATE VIEW v1 AS SELECT 1 AS a");
                $this.checkCreateView("v1", serde);
            });
            return BoxedUnit.UNIT;
        }), new Position("HiveShowCreateTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 44));
        this.test("view with output columns", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, false}))).foreach((Function1 & Serializable & scala.Serializable)serde -> {
            this.withView((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"v1"}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)"CREATE VIEW v1 (a, b COMMENT 'b column') AS SELECT 1 AS a, 2 AS b");
                $this.checkCreateView("v1", serde);
            });
            return BoxedUnit.UNIT;
        }), new Position("HiveShowCreateTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
        this.test("view with table comment and properties", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, false}))).foreach((Function1 & Serializable & scala.Serializable)serde -> {
            this.withView((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"v1"}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString("\n             |CREATE VIEW v1 (\n             |  c1 COMMENT 'bla',\n             |  c2\n             |)\n             |COMMENT 'table comment'\n             |TBLPROPERTIES (\n             |  'prop1' = 'value1',\n             |  'prop2' = 'value2'\n             |)\n             |AS SELECT 1 AS c1, '2' AS c2\n         ")).stripMargin());
                $this.checkCreateView("v1", serde);
            });
            return BoxedUnit.UNIT;
        }), new Position("HiveShowCreateTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
        this.test("simple hive table", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1"}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString("CREATE TABLE t1 (\n           |  c1 INT COMMENT 'bla',\n           |  c2 STRING\n           |)\n           |TBLPROPERTIES (\n           |  'prop1' = 'value1',\n           |  'prop2' = 'value2'\n           |)\n         ")).stripMargin());
            this.checkCreateTable("t1", true);
        }), new Position("HiveShowCreateTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
        this.test("simple external hive table", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1 & Serializable & scala.Serializable)dir -> {
            this.withTable((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1"}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(252).append("CREATE TABLE t1 (\n             |  c1 INT COMMENT 'bla',\n             |  c2 STRING\n             |)\n             |LOCATION '").append(dir.toURI()).append("'\n             |TBLPROPERTIES (\n             |  'prop1' = 'value1',\n             |  'prop2' = 'value2'\n             |)\n           ").toString())).stripMargin());
                $this.checkCreateTable("t1", true);
            });
            return BoxedUnit.UNIT;
        }), new Position("HiveShowCreateTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
        this.test("partitioned hive table", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1"}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString("CREATE TABLE t1 (\n           |  c1 INT COMMENT 'bla',\n           |  c2 STRING\n           |)\n           |COMMENT 'bla'\n           |PARTITIONED BY (\n           |  p1 BIGINT COMMENT 'bla',\n           |  p2 STRING\n           |)\n         ")).stripMargin());
            this.checkCreateTable("t1", true);
        }), new Position("HiveShowCreateTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
        this.test("hive table with explicit storage info", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1"}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString("CREATE TABLE t1 (\n           |  c1 INT COMMENT 'bla',\n           |  c2 STRING\n           |)\n           |ROW FORMAT DELIMITED FIELDS TERMINATED BY ','\n           |COLLECTION ITEMS TERMINATED BY '@'\n           |MAP KEYS TERMINATED BY '#'\n           |NULL DEFINED AS 'NaN'\n         ")).stripMargin());
            this.checkCreateTable("t1", true);
        }), new Position("HiveShowCreateTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143));
        this.test("hive table with STORED AS clause", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1"}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString("CREATE TABLE t1 (\n           |  c1 INT COMMENT 'bla',\n           |  c2 STRING\n           |)\n           |STORED AS PARQUET\n         ")).stripMargin());
            this.checkCreateTable("t1", true);
        }), new Position("HiveShowCreateTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 161));
        this.test("hive table with serde info", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1"}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString("CREATE TABLE t1 (\n           |  c1 INT COMMENT 'bla',\n           |  c2 STRING\n           |)\n           |ROW FORMAT SERDE 'org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe'\n           |WITH SERDEPROPERTIES (\n           |  'mapkey.delim' = ',',\n           |  'field.delim' = ','\n           |)\n           |STORED AS\n           |  INPUTFORMAT 'org.apache.hadoop.hive.ql.io.parquet.MapredParquetInputFormat'\n           |  OUTPUTFORMAT 'org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat'\n         ")).stripMargin());
            this.checkCreateTable("t1", true);
        }), new Position("HiveShowCreateTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 176));
        this.test("hive bucketing is supported", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1"}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString("CREATE TABLE t1 (a INT, b STRING)\n           |CLUSTERED BY (a)\n           |SORTED BY (b)\n           |INTO 2 BUCKETS\n         ")).stripMargin());
            this.checkCreateTable("t1", true);
        }), new Position("HiveShowCreateTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 198));
        this.test("hive partitioned view is not supported", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1"}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withView((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"v1"}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString("\n             |CREATE TABLE t1 (c1 INT, c2 STRING)\n             |PARTITIONED BY (\n             |  p1 BIGINT COMMENT 'bla',\n             |  p2 STRING )\n           ")).stripMargin());
            this.createRawHiveTable(new StringOps(Predef$.MODULE$.augmentString("\n             |CREATE VIEW v1\n             |PARTITIONED ON (p1, p2)\n             |AS SELECT * from t1\n           ")).stripMargin());
            AnalysisException cause = (AnalysisException)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SHOW CREATE TABLE v1"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("HiveShowCreateTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 230));
            String $org_scalatest_assert_macro_left = cause.getMessage();
            String $org_scalatest_assert_macro_right = " - partitioned view";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveShowCreateTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 234));
            AnalysisException causeForSpark = (AnalysisException)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SHOW CREATE TABLE v1 AS SERDE"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("HiveShowCreateTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 236));
            String $org_scalatest_assert_macro_left2 = causeForSpark.getMessage();
            String $org_scalatest_assert_macro_right2 = " - partitioned view";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveShowCreateTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 240));
        })), new Position("HiveShowCreateTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 211));
        this.test("SPARK-24911: keep quotes for nested fields in hive", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1"}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String shownDDL;
            String createTable = "CREATE TABLE `t1` (`a` STRUCT<`b`: STRING>) USING hive";
            this.sql().apply((Object)createTable);
            String $org_scalatest_assert_macro_left = shownDDL = this.getShowDDL("SHOW CREATE TABLE t1");
            String $org_scalatest_assert_macro_right = "CREATE TABLE `default`.`t1` (`a` STRUCT<`b`: STRING>)";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveShowCreateTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 250));
            this.checkCreateTable("t1", true);
        }), new Position("HiveShowCreateTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 245));
        this.test("simple hive table in Spark DDL", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1"}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString("\n           |CREATE TABLE t1 (\n           |  c1 STRING COMMENT 'bla',\n           |  c2 STRING\n           |)\n           |TBLPROPERTIES (\n           |  'prop1' = 'value1',\n           |  'prop2' = 'value2'\n           |)\n           |STORED AS orc\n         ")).stripMargin());
            this.checkCreateSparkTableAsHive("t1");
        }), new Position("HiveShowCreateTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 321));
        this.test("show create table as serde can't work on data source table", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1"}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString("\n           |CREATE TABLE t1 (\n           |  c1 STRING COMMENT 'bla',\n           |  c2 STRING\n           |)\n           |USING orc\n         ")).stripMargin());
            AnalysisException cause = (AnalysisException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkCreateTable("t1", true), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("HiveShowCreateTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 353));
            String $org_scalatest_assert_macro_left = cause.getMessage();
            String $org_scalatest_assert_macro_right = "Use `SHOW CREATE TABLE` without `AS SERDE` instead";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveShowCreateTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 357));
        }), new Position("HiveShowCreateTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 341));
        this.test("simple external hive table in Spark DDL", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1 & Serializable & scala.Serializable)dir -> {
            this.withTable((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1"}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(298).append("\n             |CREATE TABLE t1 (\n             |  c1 STRING COMMENT 'bla',\n             |  c2 STRING\n             |)\n             |LOCATION '").append(dir.toURI()).append("'\n             |TBLPROPERTIES (\n             |  'prop1' = 'value1',\n             |  'prop2' = 'value2'\n             |)\n             |STORED AS orc\n           ").toString())).stripMargin());
                $this.checkCreateSparkTableAsHive("t1");
            });
            return BoxedUnit.UNIT;
        }), new Position("HiveShowCreateTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 361));
        this.test("hive table with STORED AS clause in Spark DDL", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1"}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString("\n           |CREATE TABLE t1 (\n           |  c1 INT COMMENT 'bla',\n           |  c2 STRING\n           |)\n           |STORED AS PARQUET\n         ")).stripMargin());
            this.checkCreateSparkTableAsHive("t1");
        }), new Position("HiveShowCreateTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 384));
        this.test("hive table with nested fields with STORED AS clause in Spark DDL", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1"}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString("\n           |CREATE TABLE t1 (\n           |  c1 INT COMMENT 'bla',\n           |  c2 STRING,\n           |  c3 STRUCT <s1: INT, s2: STRING>\n           |)\n           |STORED AS PARQUET\n         ")).stripMargin());
            this.checkCreateSparkTableAsHive("t1");
        }), new Position("HiveShowCreateTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 400));
        this.test("hive table with unsupported fileformat in Spark DDL", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1"}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString("\n           |CREATE TABLE t1 (\n           |  c1 INT COMMENT 'bla',\n           |  c2 STRING\n           |)\n           |STORED AS RCFILE\n         ")).stripMargin());
            AnalysisException cause = (AnalysisException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkCreateSparkTableAsHive("t1"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("HiveShowCreateTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 429));
            String $org_scalatest_assert_macro_left = cause.getMessage();
            String $org_scalatest_assert_macro_right = "unsupported serde configuration";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveShowCreateTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 433));
        }), new Position("HiveShowCreateTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 417));
        this.test("hive table with serde info in Spark DDL", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1"}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString("\n           |CREATE TABLE t1 (\n           |  c1 INT COMMENT 'bla',\n           |  c2 STRING\n           |)\n           |ROW FORMAT SERDE 'org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe'\n           |STORED AS\n           |  INPUTFORMAT 'org.apache.hadoop.hive.ql.io.parquet.MapredParquetInputFormat'\n           |  OUTPUTFORMAT 'org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat'\n         ")).stripMargin());
            this.checkCreateSparkTableAsHive("t1");
        }), new Position("HiveShowCreateTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 437));
        this.test("partitioned, bucketed hive table in Spark DDL", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1"}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString("\n           |CREATE TABLE t1 (\n           |  emp_id INT COMMENT 'employee id', emp_name STRING,\n           |  emp_dob STRING COMMENT 'employee date of birth', emp_sex STRING COMMENT 'M/F'\n           |)\n           |COMMENT 'employee table'\n           |PARTITIONED BY (\n           |  emp_country STRING COMMENT '2-char code', emp_state STRING COMMENT '2-char code'\n           |)\n           |CLUSTERED BY (emp_sex) SORTED BY (emp_id ASC) INTO 10 BUCKETS\n           |STORED AS ORC\n         ")).stripMargin());
            this.checkCreateSparkTableAsHive("t1");
        }), new Position("HiveShowCreateTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 456));
        this.test("show create table for transactional hive table", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1"}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString("\n           |CREATE TABLE t1 (\n           |  c1 STRING COMMENT 'bla',\n           |  c2 STRING\n           |)\n           |TBLPROPERTIES (\n           |  'transactional' = 'true',\n           |  'prop1' = 'value1',\n           |  'prop2' = 'value2'\n           |)\n           |CLUSTERED BY (c1) INTO 10 BUCKETS\n           |STORED AS ORC\n         ")).stripMargin());
            AnalysisException cause = (AnalysisException)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SHOW CREATE TABLE t1"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("HiveShowCreateTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 496));
            String $org_scalatest_assert_macro_left = cause.getMessage();
            String $org_scalatest_assert_macro_right = "SHOW CREATE TABLE doesn't support transactional Hive table";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveShowCreateTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 500));
        }), new Position("HiveShowCreateTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 477));
    }
}

