/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.SystemUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.SecurityManager;
import org.apache.spark.SecurityManager$;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.TestUtils$;
import org.apache.spark.internal.config.UI$;
import org.apache.spark.internal.config.package$;
import org.apache.spark.sql.hive.HiveExternalCatalogVersionsSuite$;
import org.apache.spark.sql.hive.HiveUtils$;
import org.apache.spark.sql.hive.PROCESS_TABLES$;
import org.apache.spark.sql.hive.SparkSubmitTestUtils;
import org.apache.spark.sql.internal.StaticSQLConf$;
import org.apache.spark.tags.ExtendedHiveTest;
import org.apache.spark.tags.SlowHiveTest;
import org.apache.spark.util.Utils$;
import org.scalactic.Prettifier;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import org.scalatest.concurrent.Signaler;
import org.scalatest.concurrent.TimeLimits;
import org.scalatest.enablers.Timed;
import org.scalatest.exceptions.StackDepthException;
import org.scalatest.time.Span;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;

@SlowHiveTest
@ExtendedHiveTest
@ScalaSignature(bytes="\u0006\u0001\u0005-b\u0001\u0002\r\u001a\u0001\u0011BQ!\f\u0001\u0005\u00029Bq\u0001\r\u0001C\u0002\u0013%\u0011\u0007\u0003\u0004;\u0001\u0001\u0006IA\r\u0005\bw\u0001\u0011\r\u0011\"\u00032\u0011\u0019a\u0004\u0001)A\u0005e!9Q\b\u0001b\u0001\n\u0013\t\u0004B\u0002 \u0001A\u0003%!\u0007C\u0004@\u0001\t\u0007I\u0011\u0002!\t\r\u001d\u0003\u0001\u0015!\u0003B\u0011\u001dA\u0005A1A\u0005\u0002%Ca\u0001\u0015\u0001!\u0002\u0013Q\u0005\"B)\u0001\t\u0003\u0012\u0006\"B-\u0001\t\u0013Q\u0006\"B5\u0001\t\u0013Q\u0007\"B7\u0001\t\u0013q\u0007\"B;\u0001\t\u00131\b\"\u0002=\u0001\t\u0003\u0012vaBA\u00053!\u0005\u00111\u0002\u0004\u00071eA\t!!\u0004\t\r5\u001aB\u0011AA\u000e\u0011!\tib\u0005b\u0001\n\u0013I\u0005bBA\u0010'\u0001\u0006IA\u0013\u0005\n\u0003C\u0019\u0012\u0011!C\u0005\u0003G\u0011\u0001\u0005S5wK\u0016CH/\u001a:oC2\u001c\u0015\r^1m_\u001e4VM]:j_:\u001c8+^5uK*\u0011!dG\u0001\u0005Q&4XM\u0003\u0002\u001d;\u0005\u00191/\u001d7\u000b\u0005yy\u0012!B:qCJ\\'B\u0001\u0011\"\u0003\u0019\t\u0007/Y2iK*\t!%A\u0002pe\u001e\u001c\u0001aE\u0002\u0001K%\u0002\"AJ\u0014\u000e\u0003uI!\u0001K\u000f\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f!\tQ3&D\u0001\u001a\u0013\ta\u0013D\u0001\u000bTa\u0006\u00148nU;c[&$H+Z:u+RLGn]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003=\u0002\"A\u000b\u0001\u0002\u001b]\f'/\u001a%pkN,\u0007+\u0019;i+\u0005\u0011\u0004CA\u001a9\u001b\u0005!$BA\u001b7\u0003\tIwNC\u00018\u0003\u0011Q\u0017M^1\n\u0005e\"$\u0001\u0002$jY\u0016\fab^1sK\"{Wo]3QCRD\u0007%\u0001\u0006u[B$\u0015\r^1ESJ\f1\u0002^7q\t\u0006$\u0018\rR5sA\u0005y1\u000f]1sWR+7\u000f^5oO\u0012K'/\u0001\tta\u0006\u00148\u000eV3ti&tw\rR5sA\u0005IQO\\;tK\u0012T\u0015M]\u000b\u0002\u0003B\u0011!)R\u0007\u0002\u0007*\u0011AIN\u0001\u0004]\u0016$\u0018B\u0001$D\u0005\r)&\u000bT\u0001\u000bk:,8/\u001a3KCJ\u0004\u0013a\u00035jm\u00164VM]:j_:,\u0012A\u0013\t\u0003\u0017:k\u0011\u0001\u0014\u0006\u0003\u001bZ\nA\u0001\\1oO&\u0011q\n\u0014\u0002\u0007'R\u0014\u0018N\\4\u0002\u0019!Lg/\u001a,feNLwN\u001c\u0011\u0002\u0011\u00054G/\u001a:BY2$\u0012a\u0015\t\u0003)^k\u0011!\u0016\u0006\u0002-\u0006)1oY1mC&\u0011\u0001,\u0016\u0002\u0005+:LG/\u0001\tuef$un\u001e8m_\u0006$7\u000b]1sWR\u00191kW4\t\u000bqk\u0001\u0019A/\u0002\u000fY,'o]5p]B\u0011a,\u001a\b\u0003?\u000e\u0004\"\u0001Y+\u000e\u0003\u0005T!AY\u0012\u0002\rq\u0012xn\u001c;?\u0013\t!W+\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u001f\u001aT!\u0001Z+\t\u000b!l\u0001\u0019A/\u0002\tA\fG\u000f[\u0001\u000bO\u0016tG)\u0019;b\t&\u0014HCA/l\u0011\u0015ag\u00021\u0001^\u0003\u0011q\u0017-\\3\u0002\u001d\u001d,GOR5mK\u001a\u0013x.\\+sYR!1k\\9t\u0011\u0015\u0001x\u00021\u0001^\u0003%)(\u000f\\*ue&tw\rC\u0003s\u001f\u0001\u0007Q,A\u0005uCJ<W\r\u001e#je\")Ao\u0004a\u0001;\u0006Aa-\u001b7f]\u0006lW-\u0001\thKR\u001cFO]5oO\u001a\u0013x.\\+sYR\u0011Ql\u001e\u0005\u0006aB\u0001\r!X\u0001\nE\u00164wN]3BY2D#\u0001\u0001>\u0011\u0005mtX\"\u0001?\u000b\u0005ul\u0012\u0001\u0002;bONL!a ?\u0003!\u0015CH/\u001a8eK\u0012D\u0015N^3UKN$\bf\u0001\u0001\u0002\u0004A\u001910!\u0002\n\u0007\u0005\u001dAP\u0001\u0007TY><\b*\u001b<f)\u0016\u001cH/\u0001\u0011ISZ,W\t\u001f;fe:\fGnQ1uC2|wMV3sg&|gn]*vSR,\u0007C\u0001\u0016\u0014'\u0015\u0019\u0012qBA\u000b!\r!\u0016\u0011C\u0005\u0004\u0003')&AB!osJ+g\rE\u0002U\u0003/I1!!\u0007V\u00051\u0019VM]5bY&T\u0018M\u00197f)\t\tY!\u0001\u0013T!\u0006\u00136j\u0018+F'R{6)Q\"I\u000b~#\u0015JU0T3N#V)T0Q%>\u0003VI\u0015+Z\u0003\u0015\u001a\u0006+\u0011*L?R+5\u000bV0D\u0003\u000eCUi\u0018#J%~\u001b\u0016l\u0015+F\u001b~\u0003&k\u0014)F%RK\u0006%A\u0006sK\u0006$'+Z:pYZ,GCAA\u0013!\rY\u0015qE\u0005\u0004\u0003Sa%AB(cU\u0016\u001cG\u000f")
public class HiveExternalCatalogVersionsSuite
extends SparkFunSuite
implements SparkSubmitTestUtils {
    private final File wareHousePath;
    private final File tmpDataDir;
    private final File sparkTestingDir;
    private final URL unusedJar;
    private final String hiveVersion;
    private final Signaler defaultSignaler;

    @Override
    public void runSparkSubmit(Seq<String> args, Option<String> sparkHomeOpt, boolean isSparkTesting) {
        SparkSubmitTestUtils.runSparkSubmit$(this, args, sparkHomeOpt, isSparkTesting);
    }

    @Override
    public Option<String> runSparkSubmit$default$2() {
        return SparkSubmitTestUtils.runSparkSubmit$default$2$(this);
    }

    @Override
    public boolean runSparkSubmit$default$3() {
        return SparkSubmitTestUtils.runSparkSubmit$default$3$(this);
    }

    public <T> T failAfter(Span timeout, Function0<T> fun, Signaler signaler, Prettifier prettifier, Position pos, Timed<T> timed) {
        return (T)TimeLimits.failAfter$((TimeLimits)this, (Span)timeout, fun, (Signaler)signaler, (Prettifier)prettifier, (Position)pos, timed);
    }

    public <T> Prettifier failAfter$default$4(Span timeout, Function0<T> fun) {
        return TimeLimits.failAfter$default$4$((TimeLimits)this, (Span)timeout, fun);
    }

    public <T> Position failAfter$default$5(Span timeout, Function0<T> fun) {
        return TimeLimits.failAfter$default$5$((TimeLimits)this, (Span)timeout, fun);
    }

    public <T> Timed<T> failAfter$default$6(Span timeout, Function0<T> fun) {
        return TimeLimits.failAfter$default$6$((TimeLimits)this, (Span)timeout, fun);
    }

    public <T> T failAfterImpl(Span timeout, Signaler signaler, Prettifier prettifier, Option<Position> pos, Function1<StackDepthException, Object> stackDepthFun, Function0<T> fun, Timed<T> timed) {
        return (T)TimeLimits.failAfterImpl$((TimeLimits)this, (Span)timeout, (Signaler)signaler, (Prettifier)prettifier, pos, stackDepthFun, fun, timed);
    }

    public <T> T cancelAfter(Span timeout, Function0<T> fun, Signaler signaler, Prettifier prettifier, Position pos, Timed<T> timed) {
        return (T)TimeLimits.cancelAfter$((TimeLimits)this, (Span)timeout, fun, (Signaler)signaler, (Prettifier)prettifier, (Position)pos, timed);
    }

    public <T> Prettifier cancelAfter$default$4(Span timeout, Function0<T> fun) {
        return TimeLimits.cancelAfter$default$4$((TimeLimits)this, (Span)timeout, fun);
    }

    public <T> Position cancelAfter$default$5(Span timeout, Function0<T> fun) {
        return TimeLimits.cancelAfter$default$5$((TimeLimits)this, (Span)timeout, fun);
    }

    public <T> Timed<T> cancelAfter$default$6(Span timeout, Function0<T> fun) {
        return TimeLimits.cancelAfter$default$6$((TimeLimits)this, (Span)timeout, fun);
    }

    public <T> T cancelAfterImpl(Span timeout, Signaler signaler, Prettifier prettifier, Option<Position> pos, Function1<StackDepthException, Object> stackDepthFun, Function0<T> fun, Timed<T> timed) {
        return (T)TimeLimits.cancelAfterImpl$((TimeLimits)this, (Span)timeout, (Signaler)signaler, (Prettifier)prettifier, pos, stackDepthFun, fun, timed);
    }

    @Override
    public Signaler defaultSignaler() {
        return this.defaultSignaler;
    }

    @Override
    public void org$apache$spark$sql$hive$SparkSubmitTestUtils$_setter_$defaultSignaler_$eq(Signaler x$1) {
        this.defaultSignaler = x$1;
    }

    private File wareHousePath() {
        return this.wareHousePath;
    }

    private File tmpDataDir() {
        return this.tmpDataDir;
    }

    private File sparkTestingDir() {
        return this.sparkTestingDir;
    }

    private URL unusedJar() {
        return this.unusedJar;
    }

    public String hiveVersion() {
        return this.hiveVersion;
    }

    public void afterAll() {
        try {
            Utils$.MODULE$.deleteRecursively(this.wareHousePath());
            Utils$.MODULE$.deleteRecursively(this.tmpDataDir());
            if (Option$.MODULE$.apply((Object)System.getProperty(HiveExternalCatalogVersionsSuite$.MODULE$.org$apache$spark$sql$hive$HiveExternalCatalogVersionsSuite$$SPARK_TEST_CACHE_DIR_SYSTEM_PROPERTY())).isEmpty()) {
                Utils$.MODULE$.deleteRecursively(this.sparkTestingDir());
            }
        }
        finally {
            super.afterAll();
        }
    }

    private void tryDownloadSpark(String version, String path) {
        Object object = new Object();
        try {
            IndexedSeq mirrors = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 2).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> HiveExternalCatalogVersionsSuite.$anonfun$tryDownloadSpark$1(this, BoxesRunTime.unboxToInt((Object)x$2)), IndexedSeq$.MODULE$.canBuildFrom());
            IndexedSeq sites = (IndexedSeq)((SeqLike)((SeqLike)mirrors.distinct()).$colon$plus((Object)"https://archive.apache.org/dist", IndexedSeq$.MODULE$.canBuildFrom())).$colon$plus((Object)PROCESS_TABLES$.MODULE$.releaseMirror(), IndexedSeq$.MODULE$.canBuildFrom());
            this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Trying to download Spark ").append(version).append(" from ").append(sites).toString());
            sites.foreach((Function1 & Serializable & scala.Serializable)site -> {
                Object object;
                String filename = new StringBuilder(24).append("spark-").append(version).append("-bin-hadoop2.7.tgz").toString();
                String url = new StringBuilder(14).append((String)site).append("/spark/spark-").append(version).append("/").append(filename).toString();
                this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Downloading Spark ").append(version).append(" from ").append(url).toString());
                try {
                    this.getFileFromUrl(url, path, filename);
                    String downloaded = new File(this.sparkTestingDir(), filename).getCanonicalPath();
                    String targetDir = new File(this.sparkTestingDir(), new StringBuilder(6).append("spark-").append(version).toString()).getCanonicalPath();
                    scala.sys.process.package$.MODULE$.stringSeqToProcess((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mkdir", targetDir}))).$bang();
                    int exitCode = scala.sys.process.package$.MODULE$.stringSeqToProcess((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tar", "-xzf", downloaded, "-C", targetDir, "--strip-components=1"}))).$bang();
                    scala.sys.process.package$.MODULE$.stringSeqToProcess((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rm", downloaded}))).$bang();
                    File sparkSubmit = new File(this.sparkTestingDir(), new StringBuilder(23).append("spark-").append(version).append("/bin/spark-submit").toString());
                    if (exitCode == 0 && sparkSubmit.exists()) {
                        throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
                    }
                    object = BoxesRunTime.boxToInteger((int)scala.sys.process.package$.MODULE$.stringSeqToProcess((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rm", "-rf", targetDir}))).$bang());
                }
                catch (Exception ex) {
                    this.logWarning((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Failed to download Spark ").append(version).append(" from ").append(url).append(": ").append(ex.getMessage()).toString());
                    object = BoxedUnit.UNIT;
                }
                return object;
            });
            throw this.fail(new StringBuilder(25).append("Unable to download Spark ").append(version).toString(), new Position("HiveExternalCatalogVersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 121));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() != object) {
                throw ex;
            }
            ex.value$mcV$sp();
            return;
        }
    }

    private String genDataDir(String name) {
        return new File(this.tmpDataDir(), name).getCanonicalPath();
    }

    private void getFileFromUrl(String urlString, String targetDir, String filename) {
        SparkConf conf = new SparkConf();
        conf.set("spark.files.overwrite", "true");
        SecurityManager securityManager = new SecurityManager(conf, SecurityManager$.MODULE$.$lessinit$greater$default$2(), SecurityManager$.MODULE$.$lessinit$greater$default$3());
        Configuration hadoopConf = new Configuration();
        File outDir = new File(targetDir);
        Object object = !outDir.exists() ? BoxesRunTime.boxToBoolean((boolean)outDir.mkdirs()) : BoxedUnit.UNIT;
        Utils$.MODULE$.doFetchFile(urlString, outDir, filename, conf, securityManager, hadoopConf);
    }

    private String getStringFromUrl(String urlString) {
        File contentFile = File.createTempFile("string-", ".txt");
        contentFile.deleteOnExit();
        this.getFileFromUrl(urlString, contentFile.getParent(), contentFile.getName());
        Path contentPath = Paths.get(contentFile.toURI());
        return new String(Files.readAllBytes(contentPath), StandardCharsets.UTF_8);
    }

    public void beforeAll() {
        super.beforeAll();
        File tempPyFile = File.createTempFile("test", ".py");
        Files.write(tempPyFile.toPath(), new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(1729).append("\n        |from pyspark.sql import SparkSession\n        |import os\n        |\n        |spark = SparkSession.builder.enableHiveSupport().getOrCreate()\n        |version_index = spark.conf.get(\"spark.sql.test.version.index\", None)\n        |\n        |spark.sql(\"create table data_source_tbl_{} using json as select 1 i\".format(version_index))\n        |\n        |spark.sql(\"create table hive_compatible_data_source_tbl_{} using parquet as select 1 i\".format(version_index))\n        |\n        |json_file = \"").append(this.genDataDir("json_")).append("\" + str(version_index)\n        |spark.range(1, 2).selectExpr(\"cast(id as int) as i\").write.json(json_file)\n        |spark.sql(\"create table external_data_source_tbl_{}(i int) using json options (path '{}')\".format(version_index, json_file))\n        |\n        |parquet_file = \"").append(this.genDataDir("parquet_")).append("\" + str(version_index)\n        |spark.range(1, 2).selectExpr(\"cast(id as int) as i\").write.parquet(parquet_file)\n        |spark.sql(\"create table hive_compatible_external_data_source_tbl_{}(i int) using parquet options (path '{}')\".format(version_index, parquet_file))\n        |\n        |json_file2 = \"").append(this.genDataDir("json2_")).append("\" + str(version_index)\n        |spark.range(1, 2).selectExpr(\"cast(id as int) as i\").write.json(json_file2)\n        |spark.sql(\"create table external_table_without_schema_{} using json options (path '{}')\".format(version_index, json_file2))\n        |\n        |parquet_file2 = \"").append(this.genDataDir("parquet2_")).append("\" + str(version_index)\n        |spark.range(1, 3).selectExpr(\"1 as i\", \"cast(id as int) as p\", \"1 as j\").write.parquet(os.path.join(parquet_file2, \"p=1\"))\n        |spark.sql(\"create table tbl_with_col_overlap_{} using parquet options(path '{}')\".format(version_index, parquet_file2))\n        |\n        |spark.sql(\"create view v_{} as select 1 i\".format(version_index))\n      ").toString())).stripMargin().getBytes("utf8"), new OpenOption[0]);
        if (PROCESS_TABLES$.MODULE$.testingVersions().isEmpty()) {
            this.logError((Function0 & Serializable & scala.Serializable)() -> "Fail to get the latest Spark versions to test.");
        }
        ((IterableLike)PROCESS_TABLES$.MODULE$.testingVersions().zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            HiveExternalCatalogVersionsSuite.$anonfun$beforeAll$2(this, tempPyFile, x0$1);
            return BoxedUnit.UNIT;
        });
        tempPyFile.delete();
    }

    public static final /* synthetic */ Iterable $anonfun$tryDownloadSpark$1(HiveExternalCatalogVersionsSuite $this, int x$2) {
        Iterable iterable;
        try {
            iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)$this.getStringFromUrl("https://www.apache.org/dyn/closer.lua?preferred=true")));
        }
        catch (Exception exception) {
            iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
        }
        return iterable;
    }

    public static final /* synthetic */ void $anonfun$beforeAll$2(HiveExternalCatalogVersionsSuite $this, File tempPyFile$1, Tuple2 x0$1) {
        File sparkHome;
        int index;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String version = (String)tuple2._1();
            index = tuple2._2$mcI$sp();
            sparkHome = new File($this.sparkTestingDir(), new StringBuilder(6).append("spark-").append(version).toString());
            if (!sparkHome.exists()) {
                $this.tryDownloadSpark(version, $this.sparkTestingDir().getCanonicalPath());
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        Seq args = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--name", "prepare testing tables", "--master", "local[2]", "--conf", new StringBuilder(6).append(UI$.MODULE$.UI_ENABLED().key()).append("=false").toString(), "--conf", new StringBuilder(6).append(package$.MODULE$.MASTER_REST_SERVER_ENABLED().key()).append("=false").toString(), "--conf", new StringBuilder(1).append(HiveUtils$.MODULE$.HIVE_METASTORE_VERSION().key()).append("=").append($this.hiveVersion()).toString(), "--conf", new StringBuilder(6).append(HiveUtils$.MODULE$.HIVE_METASTORE_JARS().key()).append("=maven").toString(), "--conf", new StringBuilder(1).append(StaticSQLConf$.MODULE$.WAREHOUSE_PATH().key()).append("=").append($this.wareHousePath().getCanonicalPath()).toString(), "--conf", new StringBuilder(29).append("spark.sql.test.version.index=").append(index).toString(), "--driver-java-options", new StringBuilder(20).append("-Dderby.system.home=").append($this.wareHousePath().getCanonicalPath()).toString(), tempPyFile$1.getCanonicalPath()}));
        $this.runSparkSubmit((Seq<String>)args, (Option<String>)new Some((Object)sparkHome.getCanonicalPath()), false);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public HiveExternalCatalogVersionsSuite() {
        TimeLimits.$init$((TimeLimits)this);
        SparkSubmitTestUtils.$init$(this);
        String x$12 = "warehouse";
        String x$2 = Utils$.MODULE$.createTempDir$default$1();
        this.wareHousePath = Utils$.MODULE$.createTempDir(x$2, x$12);
        String x$3 = "test-data";
        String x$4 = Utils$.MODULE$.createTempDir$default$1();
        this.tmpDataDir = Utils$.MODULE$.createTempDir(x$4, x$3);
        this.sparkTestingDir = (File)Option$.MODULE$.apply((Object)System.getProperty(HiveExternalCatalogVersionsSuite$.MODULE$.org$apache$spark$sql$hive$HiveExternalCatalogVersionsSuite$$SPARK_TEST_CACHE_DIR_SYSTEM_PROPERTY())).map((Function1 & Serializable & scala.Serializable)x$1 -> new File((String)x$1)).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            String x$5 = "test-spark";
            String x$6 = Utils$.MODULE$.createTempDir$default$1();
            return Utils$.MODULE$.createTempDir(x$6, x$5);
        });
        this.unusedJar = TestUtils$.MODULE$.createJarWithClasses((Seq)Seq$.MODULE$.empty(), TestUtils$.MODULE$.createJarWithClasses$default$2(), TestUtils$.MODULE$.createJarWithClasses$default$3(), TestUtils$.MODULE$.createJarWithClasses$default$4());
        this.hiveVersion = SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_9) ? "2.3.7" : "1.2.1";
        this.test("backward compatibility", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            Seq args = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--class", new StringOps(Predef$.MODULE$.augmentString(PROCESS_TABLES$.MODULE$.getClass().getName())).stripSuffix("$"), "--name", "HiveExternalCatalog backward compatibility test", "--master", "local[2]", "--conf", new StringBuilder(6).append(UI$.MODULE$.UI_ENABLED().key()).append("=false").toString(), "--conf", new StringBuilder(6).append(package$.MODULE$.MASTER_REST_SERVER_ENABLED().key()).append("=false").toString(), "--conf", new StringBuilder(1).append(HiveUtils$.MODULE$.HIVE_METASTORE_VERSION().key()).append("=").append(this.hiveVersion()).toString(), "--conf", new StringBuilder(6).append(HiveUtils$.MODULE$.HIVE_METASTORE_JARS().key()).append("=maven").toString(), "--conf", new StringBuilder(1).append(StaticSQLConf$.MODULE$.WAREHOUSE_PATH().key()).append("=").append(this.wareHousePath().getCanonicalPath()).toString(), "--driver-java-options", new StringBuilder(20).append("-Dderby.system.home=").append(this.wareHousePath().getCanonicalPath()).toString(), this.unusedJar().toString()}));
            if (PROCESS_TABLES$.MODULE$.testingVersions().nonEmpty()) {
                this.runSparkSubmit((Seq<String>)args, this.runSparkSubmit$default$2(), this.runSparkSubmit$default$3());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        }, new Position("HiveExternalCatalogVersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 220));
    }
}

