/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.client;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.net.URL;
import java.util.LinkedHashMap;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.SystemUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.FunctionIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier$;
import org.apache.spark.sql.catalyst.analysis.NoSuchDatabaseException;
import org.apache.spark.sql.catalyst.analysis.NoSuchPermanentFunctionException;
import org.apache.spark.sql.catalyst.analysis.PartitionsAlreadyExistException;
import org.apache.spark.sql.catalyst.catalog.CatalogDatabase;
import org.apache.spark.sql.catalyst.catalog.CatalogFunction;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTable$;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition$;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.EqualTo;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.util.package$;
import org.apache.spark.sql.hive.HiveExternalCatalog;
import org.apache.spark.sql.hive.HiveUtils$;
import org.apache.spark.sql.hive.client.HiveClient;
import org.apache.spark.sql.hive.client.HiveClientBuilder$;
import org.apache.spark.sql.hive.test.TestHiveVersion;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.tags.ExtendedHiveTest;
import org.apache.spark.tags.SlowHiveTest;
import org.apache.spark.util.MutableURLClassLoader;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@SlowHiveTest
@ExtendedHiveTest
@ScalaSignature(bytes="\u0006\u0001\u0005\rb\u0001\u0002\t\u0012\u0001yAQ!\u000b\u0001\u0005\u0002)Bq!\f\u0001C\u0002\u0013Ec\u0006\u0003\u00046\u0001\u0001\u0006Ia\f\u0005\u0006m\u0001!\tb\u000e\u0005\u0006#\u0002!IA\u0015\u0005\b=\u0002\u0011\r\u0011\"\u0003`\u0011\u00199\u0007\u0001)A\u0005A\"9\u0001\u000e\u0001b\u0001\n\u0013I\u0007B\u00029\u0001A\u0003%!\u000eC\u0004\u0013\u0001\u0001\u0007I\u0011B9\t\u000fU\u0004\u0001\u0019!C\u0005m\"1\u0011\u0010\u0001Q!\nIDqA\u001f\u0001A\u0002\u0013%1\u0010C\u0005\u0002\u0006\u0001\u0001\r\u0011\"\u0003\u0002\b!9\u00111\u0002\u0001!B\u0013a(!\u0004,feNLwN\\:Tk&$XM\u0003\u0002\u0013'\u000511\r\\5f]RT!\u0001F\u000b\u0002\t!Lg/\u001a\u0006\u0003-]\t1a]9m\u0015\tA\u0012$A\u0003ta\u0006\u00148N\u0003\u0002\u001b7\u00051\u0011\r]1dQ\u0016T\u0011\u0001H\u0001\u0004_J<7\u0001A\n\u0004\u0001}\u0019\u0003C\u0001\u0011\"\u001b\u00059\u0012B\u0001\u0012\u0018\u00055\u0019\u0006/\u0019:l\rVt7+^5uKB\u0011AeJ\u0007\u0002K)\u0011aeF\u0001\tS:$XM\u001d8bY&\u0011\u0001&\n\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\t1\u0006\u0005\u0002-\u00015\t\u0011#A\u000bf]\u0006\u0014G.Z!vi>$\u0006N]3bI\u0006+H-\u001b;\u0016\u0003=\u0002\"\u0001M\u001a\u000e\u0003ER\u0011AM\u0001\u0006g\u000e\fG.Y\u0005\u0003iE\u0012qAQ8pY\u0016\fg.\u0001\ff]\u0006\u0014G.Z!vi>$\u0006N]3bI\u0006+H-\u001b;!\u0003%9\u0018\u000e\u001e5UC\ndW\r\u0006\u00029\u0003R\u0011\u0011\b\u0010\t\u0003aiJ!aO\u0019\u0003\tUs\u0017\u000e\u001e\u0005\u0007{\u0011!\t\u0019\u0001 \u0002\u0003\u0019\u00042\u0001M :\u0013\t\u0001\u0015G\u0001\u0005=Eft\u0017-\\3?\u0011\u0015\u0011E\u00011\u0001D\u0003)!\u0018M\u00197f\u001d\u0006lWm\u001d\t\u0004a\u00113\u0015BA#2\u0005)a$/\u001a9fCR,GM\u0010\t\u0003\u000f:s!\u0001\u0013'\u0011\u0005%\u000bT\"\u0001&\u000b\u0005-k\u0012A\u0002\u001fs_>$h(\u0003\u0002Nc\u00051\u0001K]3eK\u001aL!a\u0014)\u0003\rM#(/\u001b8h\u0015\ti\u0015'A\thKRtUm\u001d;fI6+7o]1hKN$\"AR*\t\u000bQ+\u0001\u0019A+\u0002\u0003\u0015\u0004\"AV.\u000f\u0005]KfBA%Y\u0013\u0005\u0011\u0014B\u0001.2\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001X/\u0003\u0013QC'o\\<bE2,'B\u0001.2\u0003!)W\u000e\u001d;z\t&\u0014X#\u00011\u0011\u0005\u00054W\"\u00012\u000b\u0005\r$\u0017\u0001\u00027b]\u001eT\u0011!Z\u0001\u0005U\u00064\u0018-\u0003\u0002PE\u0006IQ-\u001c9us\u0012K'\u000fI\u0001\tm\u0016\u00148/[8ogV\t!\u000eE\u0002l]\u0002l\u0011\u0001\u001c\u0006\u0003[F\n!bY8mY\u0016\u001cG/[8o\u0013\tyGNA\u0002TKF\f\u0011B^3sg&|gn\u001d\u0011\u0016\u0003I\u0004\"\u0001L:\n\u0005Q\f\"A\u0003%jm\u0016\u001cE.[3oi\u0006Q1\r\\5f]R|F%Z9\u0015\u0005e:\bb\u0002=\f\u0003\u0003\u0005\rA]\u0001\u0004q\u0012\n\u0014aB2mS\u0016tG\u000fI\u0001\rm\u0016\u00148/[8o'B\f'o[\u000b\u0002yB\u0019Q0!\u0001\u000e\u0003yT!a`\n\u0002\tQ,7\u000f^\u0005\u0004\u0003\u0007q(a\u0004+fgRD\u0015N^3WKJ\u001c\u0018n\u001c8\u0002!Y,'o]5p]N\u0003\u0018M]6`I\u0015\fHcA\u001d\u0002\n!9\u0001PDA\u0001\u0002\u0004a\u0018!\u0004<feNLwN\\*qCJ\\\u0007\u0005K\u0002\u0001\u0003\u001f\u0001B!!\u0005\u0002\u00185\u0011\u00111\u0003\u0006\u0004\u0003+9\u0012\u0001\u0002;bONLA!!\u0007\u0002\u0014\t\u0001R\t\u001f;f]\u0012,G\rS5wKR+7\u000f\u001e\u0015\u0004\u0001\u0005u\u0001\u0003BA\t\u0003?IA!!\t\u0002\u0014\ta1\u000b\\8x\u0011&4X\rV3ti\u0002")
public class VersionsSuite
extends SparkFunSuite {
    private final boolean enableAutoThreadAudit;
    private final String emptyDir;
    private final Seq<String> versions;
    private HiveClient client;
    private TestHiveVersion versionSpark;

    public boolean enableAutoThreadAudit() {
        return this.enableAutoThreadAudit;
    }

    public void withTable(Seq<String> tableNames, Function0<BoxedUnit> f) {
        try {
            f.apply$mcV$sp();
        }
        finally {
            tableNames.foreach((Function1 & Serializable & scala.Serializable)name -> this.versionSpark().sql(new StringBuilder(21).append("DROP TABLE IF EXISTS ").append((String)name).toString()));
        }
    }

    /*
     * WARNING - void declaration
     */
    private String getNestedMessages(Throwable e) {
        void var2_2;
        String causes = "";
        for (Throwable lastException = e; lastException != null; lastException = lastException.getCause()) {
            causes = new StringBuilder(1).append(causes).append(lastException.toString()).append("\n").toString();
        }
        return var2_2;
    }

    private String emptyDir() {
        return this.emptyDir;
    }

    private Seq<String> versions() {
        return this.versions;
    }

    private HiveClient client() {
        return this.client;
    }

    private void client_$eq(HiveClient x$1) {
        this.client = x$1;
    }

    private TestHiveVersion versionSpark() {
        return this.versionSpark;
    }

    private void versionSpark_$eq(TestHiveVersion x$1) {
        this.versionSpark = x$1;
    }

    private static final CatalogTable table$1(String database, String tableName, CatalogTableType tableType) {
        TableIdentifier x$1 = new TableIdentifier(tableName, (Option)new Some((Object)database));
        CatalogTableType x$2 = tableType;
        StructType x$3 = new StructType().add("key", "int");
        CatalogStorageFormat x$4 = new CatalogStorageFormat((Option)None$.MODULE$, (Option)new Some((Object)TextInputFormat.class.getName()), (Option)new Some((Object)HiveIgnoreKeyTextOutputFormat.class.getName()), (Option)new Some((Object)LazySimpleSerDe.class.getName()), false, Predef$.MODULE$.Map().empty());
        Option x$5 = CatalogTable$.MODULE$.apply$default$5();
        Seq x$6 = CatalogTable$.MODULE$.apply$default$6();
        Option x$7 = CatalogTable$.MODULE$.apply$default$7();
        String x$8 = CatalogTable$.MODULE$.apply$default$8();
        long x$9 = CatalogTable$.MODULE$.apply$default$9();
        long x$10 = CatalogTable$.MODULE$.apply$default$10();
        String x$11 = CatalogTable$.MODULE$.apply$default$11();
        Map x$12 = CatalogTable$.MODULE$.apply$default$12();
        Option x$13 = CatalogTable$.MODULE$.apply$default$13();
        Option x$14 = CatalogTable$.MODULE$.apply$default$14();
        Option x$15 = CatalogTable$.MODULE$.apply$default$15();
        Seq x$16 = CatalogTable$.MODULE$.apply$default$16();
        boolean x$17 = CatalogTable$.MODULE$.apply$default$17();
        boolean x$18 = CatalogTable$.MODULE$.apply$default$18();
        Map x$19 = CatalogTable$.MODULE$.apply$default$19();
        Option x$20 = CatalogTable$.MODULE$.apply$default$20();
        return new CatalogTable(x$1, x$2, x$4, x$3, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
    }

    private static final CatalogTableType table$default$3$1() {
        return CatalogTableType$.MODULE$.MANAGED();
    }

    public static final /* synthetic */ void $anonfun$new$12(VersionsSuite $this, File tmpDir) {
        CatalogDatabase dbWithNullDesc = new CatalogDatabase("dbWithNullDesc", null, tmpDir.toURI(), (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
        $this.client().createDatabase(dbWithNullDesc, true);
        String $org_scalatest_assert_macro_left = $this.client().getDatabase("dbWithNullDesc").description();
        String $org_scalatest_assert_macro_right = "";
        String string = $org_scalatest_assert_macro_left;
        String string2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 221));
    }

    public static final /* synthetic */ boolean $anonfun$new$44(String x$4) {
        String string = x$4;
        String string2 = "0.14";
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ CatalogTablePartition $anonfun$new$47(CatalogStorageFormat storageFormat$1, int key2) {
        return new CatalogTablePartition((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key1"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key2"), (Object)((Object)BoxesRunTime.boxToInteger((int)key2)).toString())})), storageFormat$1, CatalogTablePartition$.MODULE$.apply$default$3(), CatalogTablePartition$.MODULE$.apply$default$4(), CatalogTablePartition$.MODULE$.apply$default$5(), CatalogTablePartition$.MODULE$.apply$default$6());
    }

    public static final /* synthetic */ String $anonfun$new$49(int key2) {
        return new StringBuilder(12).append("key1=1/key2=").append(key2).toString();
    }

    public static final /* synthetic */ boolean $anonfun$new$61(String x$5) {
        String string = x$5;
        String string2 = "1.2";
        return string == null ? string2 != null : !string.equals(string2);
    }

    private static final CatalogFunction function$1(String name, String className) {
        return new CatalogFunction(new FunctionIdentifier(name, (Option)new Some((Object)"default")), className, (Seq)Seq$.MODULE$.empty());
    }

    public static final /* synthetic */ Bool $anonfun$new$81(Bool $org_scalatest_assert_macro_right$1) {
        return $org_scalatest_assert_macro_right$1;
    }

    public static final /* synthetic */ Row[] $anonfun$new$82(VersionsSuite $this) {
        return (Row[])$this.versionSpark().table("mv1").collect();
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ Object $anonfun$new$80(VersionsSuite $this, String version$1) {
        block4: {
            block3: {
                block2: {
                    v0 = version$1;
                    var2_2 = "2.3";
                    if (!(v0 == null ? var2_2 != null : v0.equals(var2_2) == false)) break block2;
                    v1 = version$1;
                    var3_3 = "3.0";
                    if (!(v1 == null ? var3_3 != null : v1.equals(var3_3) == false)) break block2;
                    v2 = version$1;
                    var4_4 = "3.1";
                    if (v2 != null ? v2.equals(var4_4) == false : var4_4 != null) break block3;
                }
                $org_scalatest_assert_macro_left = version$1;
                $org_scalatest_assert_macro_right = "2.3";
                v3 = $org_scalatest_assert_macro_left;
                var9_7 = $org_scalatest_assert_macro_right;
                $org_scalatest_assert_macro_left = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(v3 != null ? v3.equals(var9_7) == false : var9_7 != null), Prettifier$.MODULE$.default());
                $org_scalatest_assert_macro_right = $org_scalatest_assert_macro_left.value() != false ? Bool$.MODULE$.simpleMacroBool(true, "", Prettifier$.MODULE$.default()) : Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_9), "org.apache.commons.lang3.SystemUtils.isJavaVersionAtLeast(JAVA_9)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "||", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$bar$bar((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$new$81(org.scalactic.Bool ), ()Lorg/scalactic/Bool;)((Bool)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssume($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 738));
                v4 = version$1;
                var12_11 = "2.3";
                if (!(v4 == null ? var12_11 != null : v4.equals(var12_11) == false)) ** GOTO lbl-1000
                v5 = version$1;
                var13_12 = "3.0";
                if (!(v5 != null ? v5.equals(var13_12) == false : var13_12 != null)) lbl-1000:
                // 2 sources

                {
                    v6 = "";
                } else {
                    v6 = "DISABLE REWRITE";
                }
                disableRewrite = v6;
                $this.client().runSqlHive("CREATE TABLE materialized_view_tbl (c1 INT)");
                $this.client().runSqlHive(new StringBuilder(68).append("CREATE MATERIALIZED VIEW mv1 ").append(disableRewrite).append(" AS SELECT * FROM materialized_view_tbl").toString());
                $org_scalatest_assert_macro_left = e = ((AnalysisException)$this.intercept((Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$new$82(org.apache.spark.sql.hive.client.VersionsSuite ), ()[Lorg/apache/spark/sql/Row;)((VersionsSuite)$this), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 744))).getMessage();
                $org_scalatest_assert_macro_right = "Hive materialized view is not supported";
                $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                v7 = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 745));
                break block4;
            }
            v7 = BoxedUnit.UNIT;
        }
        return v7;
    }

    public static final /* synthetic */ long $anonfun$new$98(String x$8) {
        return new StringOps(Predef$.MODULE$.augmentString(x$8)).toLong();
    }

    public static final /* synthetic */ long $anonfun$new$99(String x$9) {
        return new StringOps(Predef$.MODULE$.augmentString(x$9)).toLong();
    }

    public static final /* synthetic */ long $anonfun$new$102(String x$10) {
        return new StringOps(Predef$.MODULE$.augmentString(x$10)).toLong();
    }

    public static final /* synthetic */ long $anonfun$new$103(String x$11) {
        return new StringOps(Predef$.MODULE$.augmentString(x$11)).toLong();
    }

    public static final /* synthetic */ Dataset $anonfun$new$109(VersionsSuite $this, int i) {
        return $this.versionSpark().sql(new StringBuilder(36).append("INSERT OVERWRITE TABLE tab SELECT '").append(i).append("'").toString());
    }

    private static final List listFiles$1(File path2) {
        File[] dir = path2.listFiles();
        List folders = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dir)).filter((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)x$12.isDirectory())))).toList();
        List filePaths = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dir)).map((Function1 & Serializable & scala.Serializable)x$13 -> x$13.getName(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toList();
        List list = (List)folders.flatMap((Function1 & Serializable & scala.Serializable)path -> VersionsSuite.listFiles$1(path), List$.MODULE$.canBuildFrom());
        return (List)filePaths.$plus$plus$colon((Traversable)list, List$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ void $anonfun$new$115(VersionsSuite $this, File dir) {
        String path = dir.toURI().toString();
        String tableName = "spark_13709";
        String tempTableName = "spark_13709_temp";
        new File(dir.getAbsolutePath(), tableName).mkdir();
        new File(dir.getAbsolutePath(), tempTableName).mkdir();
        String avroSchema = new StringOps(Predef$.MODULE$.augmentString("{\n            |  \"name\": \"test_record\",\n            |  \"type\": \"record\",\n            |  \"fields\": [ {\n            |    \"name\": \"f0\",\n            |    \"type\": \"int\"\n            |  }, {\n            |    \"name\": \"f1\",\n            |    \"type\": {\n            |      \"type\": \"record\",\n            |      \"name\": \"inner\",\n            |      \"fields\": [ {\n            |        \"name\": \"f10\",\n            |        \"type\": \"int\"\n            |      }, {\n            |        \"name\": \"f11\",\n            |        \"type\": \"double\"\n            |      } ]\n            |    }\n            |  } ]\n            |}\n          ")).stripMargin();
        $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tableName, tempTableName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.versionSpark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(455).append("CREATE EXTERNAL TABLE ").append(tableName).append("\n               |PARTITIONED BY (ds STRING)\n               |ROW FORMAT SERDE 'org.apache.hadoop.hive.serde2.avro.AvroSerDe'\n               |STORED AS\n               |  INPUTFORMAT 'org.apache.hadoop.hive.ql.io.avro.AvroContainerInputFormat'\n               |  OUTPUTFORMAT 'org.apache.hadoop.hive.ql.io.avro.AvroContainerOutputFormat'\n               |LOCATION '").append(path).append("/").append(tableName).append("'\n               |TBLPROPERTIES ('avro.schema.literal' = '").append(avroSchema).append("')\n           ").toString())).stripMargin());
            $this.versionSpark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(412).append("CREATE EXTERNAL TABLE ").append(tempTableName).append("\n               |ROW FORMAT SERDE 'org.apache.hadoop.hive.serde2.avro.AvroSerDe'\n               |STORED AS\n               |  INPUTFORMAT 'org.apache.hadoop.hive.ql.io.avro.AvroContainerInputFormat'\n               |  OUTPUTFORMAT 'org.apache.hadoop.hive.ql.io.avro.AvroContainerOutputFormat'\n               |LOCATION '").append(path).append("/").append(tempTableName).append("'\n               |TBLPROPERTIES ('avro.schema.literal' = '").append(avroSchema).append("')\n           ").toString())).stripMargin());
            $this.versionSpark().sql(new StringBuilder(48).append("INSERT OVERWRITE TABLE ").append(tempTableName).append(" SELECT 1, STRUCT(2, 2.5)").toString());
            $this.versionSpark().sql(new StringBuilder(52).append("ALTER TABLE ").append(tableName).append(" ADD PARTITION (ds = 'foo') LOCATION '").append(path).append("/").append(tempTableName).append("'").toString());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer($this.versionSpark().sql(new StringBuilder(14).append("SELECT * FROM ").append(tableName).toString()).collect());
            Row[] $org_scalatest_assert_macro_right = (Row[])((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)2.5)})), "foo"}))});
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 955));
        });
    }

    public static final /* synthetic */ void $anonfun$new$128(VersionsSuite $this, File dir) {
        String avroSchema = new StringOps(Predef$.MODULE$.augmentString("\n            |{\n            |  \"name\": \"test_record\",\n            |  \"type\": \"record\",\n            |  \"fields\": [{\n            |    \"name\": \"f0\",\n            |    \"type\": [\n            |      \"null\",\n            |      {\n            |        \"precision\": 38,\n            |        \"scale\": 2,\n            |        \"type\": \"bytes\",\n            |        \"logicalType\": \"decimal\"\n            |      }\n            |    ]\n            |  }]\n            |}\n          ")).stripMargin();
        File schemaFile = new File(dir, "avroDecimal.avsc");
        Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> new PrintWriter(schemaFile), (Function1 & Serializable & scala.Serializable)writer -> {
            writer.write(avroSchema);
            return BoxedUnit.UNIT;
        });
        String schemaPath = schemaFile.toURI().toString();
        URL url = Thread.currentThread().getContextClassLoader().getResource("avroDecimal");
        String srcLocation = new File(url.getFile()).toURI().toString();
        String destTableName = "tab1";
        String srcTableName = "tab2";
        $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{srcTableName, destTableName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.versionSpark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(493).append("\n               |CREATE EXTERNAL TABLE ").append(srcTableName).append("\n               |ROW FORMAT SERDE 'org.apache.hadoop.hive.serde2.avro.AvroSerDe'\n               |WITH SERDEPROPERTIES ('respectSparkSchema' = 'true')\n               |STORED AS\n               |  INPUTFORMAT 'org.apache.hadoop.hive.ql.io.avro.AvroContainerInputFormat'\n               |  OUTPUTFORMAT 'org.apache.hadoop.hive.ql.io.avro.AvroContainerOutputFormat'\n               |LOCATION '").append(srcLocation).append("'\n               |TBLPROPERTIES ('avro.schema.url' = '").append(schemaPath).append("')\n           ").toString())).stripMargin());
            $this.versionSpark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(456).append("\n               |CREATE TABLE ").append(destTableName).append("\n               |ROW FORMAT SERDE 'org.apache.hadoop.hive.serde2.avro.AvroSerDe'\n               |WITH SERDEPROPERTIES ('respectSparkSchema' = 'true')\n               |STORED AS\n               |  INPUTFORMAT 'org.apache.hadoop.hive.ql.io.avro.AvroContainerInputFormat'\n               |  OUTPUTFORMAT 'org.apache.hadoop.hive.ql.io.avro.AvroContainerOutputFormat'\n               |TBLPROPERTIES ('avro.schema.url' = '").append(schemaPath).append("')\n           ").toString())).stripMargin());
            $this.versionSpark().sql(new StringBuilder(38).append("INSERT OVERWRITE TABLE ").append(destTableName).append(" SELECT * FROM ").append(srcTableName).toString());
            Row[] result = (Row[])$this.versionSpark().table(srcTableName).collect();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer($this.versionSpark().table(destTableName).collect());
            Row[] $org_scalatest_assert_macro_right = result;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1139));
            $this.versionSpark().sql(new StringBuilder(33).append("INSERT INTO TABLE ").append(destTableName).append(" SELECT * FROM ").append(srcTableName).toString());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.versionSpark().table(destTableName).collect())).toSeq());
            Row[] $org_scalatest_assert_macro_right2 = (Row[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])result)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])result)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Row.class)));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1142));
        });
    }

    public static final /* synthetic */ void $anonfun$new$7(VersionsSuite $this, String version) {
        $this.test(new StringBuilder(15).append(version).append(": create client").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Configuration hadoopConf;
            block10: {
                block9: {
                    block8: {
                        block7: {
                            $this.client_$eq(null);
                            System.gc();
                            hadoopConf = new Configuration();
                            hadoopConf.set("test", "success");
                            String string = version;
                            String string2 = "2.0";
                            if (!(string == null ? string2 != null : !string.equals(string2))) break block7;
                            String string3 = version;
                            String string4 = "2.1";
                            if (!(string3 == null ? string4 != null : !string3.equals(string4))) break block7;
                            String string5 = version;
                            String string6 = "2.2";
                            if (!(string5 == null ? string6 != null : !string5.equals(string6))) break block7;
                            String string7 = version;
                            String string8 = "2.3";
                            if (!(string7 == null ? string8 != null : !string7.equals(string8))) break block7;
                            String string9 = version;
                            String string10 = "3.0";
                            if (!(string9 == null ? string10 != null : !string9.equals(string10))) break block7;
                            String string11 = version;
                            String string12 = "3.1";
                            if (string11 != null ? !string11.equals(string12) : string12 != null) break block8;
                        }
                        hadoopConf.set("datanucleus.schema.autoCreateAll", "true");
                        hadoopConf.set("hive.metastore.schema.verification", "false");
                    }
                    String string = version;
                    String string13 = "3.0";
                    if (!(string == null ? string13 != null : !string.equals(string13))) break block9;
                    String string14 = version;
                    String string15 = "3.1";
                    if (string14 != null ? !string14.equals(string15) : string15 != null) break block10;
                }
                hadoopConf.set("hive.in.test", "true");
                hadoopConf.set("hive.query.reexecution.enabled", "false");
            }
            $this.client_$eq(HiveClientBuilder$.MODULE$.buildClient(version, hadoopConf, (Map<String, String>)HiveUtils$.MODULE$.formatTimeVarsForHiveClient(hadoopConf)));
            if ($this.versionSpark() != null) {
                $this.versionSpark().reset();
            }
            $this.versionSpark_$eq(new TestHiveVersion($this.client()));
            String $org_scalatest_assert_macro_left = ((HiveExternalCatalog)$this.versionSpark().sharedState().externalCatalog().unwrapped()).client().version().fullVersion();
            String $org_scalatest_assert_macro_right = version;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "startsWith", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.startsWith($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154));
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132));
        URI tempDatabasePath = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()).toURI();
        $this.test(new StringBuilder(16).append(version).append(": createDatabase").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            CatalogDatabase defaultDB = new CatalogDatabase("default", "desc", new URI("loc"), (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
            $this.client().createDatabase(defaultDB, true);
            CatalogDatabase tempDB = new CatalogDatabase("temporary", "test create", tempDatabasePath, (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
            $this.client().createDatabase(tempDB, true);
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 180));
        $this.test(new StringBuilder(64).append(version).append(": create/get/alter database should pick right user name as owner").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            String string = version;
            String string2 = "0.12";
            if (string == null ? string2 != null : !string.equals(string2)) {
                String currentUser = UserGroupInformation.getCurrentUser().getUserName();
                String ownerName = "SPARK_29425";
                String db1 = "SPARK_29425_1";
                String db2 = "SPARK_29425_2";
                Map ownerProps = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"owner"), (Object)ownerName)}));
                CatalogDatabase dbWithOwner = new CatalogDatabase(db1, "desc", Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()).toURI(), ownerProps);
                $this.client().createDatabase(dbWithOwner, true);
                CatalogDatabase getDbWithOwner = $this.client().getDatabase(db1);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(getDbWithOwner.properties().apply((Object)"owner"));
                String $org_scalatest_assert_macro_right = ownerName;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 200));
                Map x$1 = (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
                String x$2 = getDbWithOwner.copy$default$1();
                String x$3 = getDbWithOwner.copy$default$2();
                URI x$4 = getDbWithOwner.copy$default$3();
                $this.client().alterDatabase(getDbWithOwner.copy(x$2, x$3, x$4, x$1));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer($this.client().getDatabase(db1).properties().apply((Object)"owner"));
                String $org_scalatest_assert_macro_right2 = "";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 203));
                CatalogDatabase dbWithoutOwner = new CatalogDatabase(db2, "desc", Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()).toURI(), (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
                $this.client().createDatabase(dbWithoutOwner, true);
                CatalogDatabase getDbWithoutOwner = $this.client().getDatabase(db2);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = $this.convertToEqualizer(getDbWithoutOwner.properties().apply((Object)"owner"));
                String $org_scalatest_assert_macro_right3 = currentUser;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 209));
                Map x$5 = ownerProps;
                String x$6 = getDbWithoutOwner.copy$default$1();
                String x$7 = getDbWithoutOwner.copy$default$2();
                URI x$8 = getDbWithoutOwner.copy$default$3();
                $this.client().alterDatabase(getDbWithoutOwner.copy(x$6, x$7, x$8, x$5));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = $this.convertToEqualizer($this.client().getDatabase(db2).properties().apply((Object)"owner"));
                String $org_scalatest_assert_macro_right4 = ownerName;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                boxedUnit = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 212));
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 188));
        $this.test(new StringBuilder(38).append(version).append(": createDatabase with null description").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.withTempDir((Function1 & Serializable & scala.Serializable)tmpDir -> {
            VersionsSuite.$anonfun$new$12($this, tmpDir);
            return BoxedUnit.UNIT;
        }), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 216));
        $this.test(new StringBuilder(20).append(version).append(": setCurrentDatabase").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.client().setCurrentDatabase("default"), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 225));
        $this.test(new StringBuilder(13).append(version).append(": getDatabase").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            $this.client().getDatabase("default");
            return (NoSuchDatabaseException)$this.intercept((Function0 & Serializable & scala.Serializable)() -> $this.client().getDatabase("nonexist"), ClassTag$.MODULE$.apply(NoSuchDatabaseException.class), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 232));
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 229));
        $this.test(new StringBuilder(16).append(version).append(": databaseExists").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool($this.client().databaseExists("default"), "VersionsSuite.this.client.databaseExists(\"default\")", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 236));
            boolean $org_scalatest_assert_macro_left = $this.client().databaseExists("nonexist");
            boolean $org_scalatest_assert_macro_right = false;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 237));
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 235));
        $this.test(new StringBuilder(15).append(version).append(": listDatabases").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Seq $org_scalatest_assert_macro_left = $this.client().listDatabases("defau.*");
            Seq $org_scalatest_assert_macro_right = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default"}));
            Seq seq = $org_scalatest_assert_macro_left;
            Seq seq2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(seq != null ? !seq.equals(seq2) : seq2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 241));
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 240));
        $this.test(new StringBuilder(15).append(version).append(": alterDatabase").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Assertion assertion;
            URI tempDatabasePath2;
            CatalogDatabase database;
            block3: {
                block2: {
                    CatalogDatabase qual$1 = $this.client().getDatabase("temporary");
                    Map x$9 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"flag"), (Object)"true")}));
                    String x$10 = qual$1.copy$default$1();
                    String x$11 = qual$1.copy$default$2();
                    URI x$12 = qual$1.copy$default$3();
                    database = qual$1.copy(x$10, x$11, x$12, x$9);
                    $this.client().alterDatabase(database);
                    Map $org_scalatest_assert_macro_left = $this.client().getDatabase("temporary").properties();
                    String $org_scalatest_assert_macro_right = "flag";
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 247));
                    tempDatabasePath2 = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()).toURI();
                    String string = version;
                    String string2 = "3.0";
                    if (!(string == null ? string2 != null : !string.equals(string2))) break block2;
                    String string3 = version;
                    String string4 = "3.1";
                    if (string3 != null ? !string3.equals(string4) : string4 != null) break block3;
                }
                URI x$13 = tempDatabasePath2;
                String x$14 = database.copy$default$1();
                String x$15 = database.copy$default$2();
                Map x$16 = database.copy$default$4();
                $this.client().alterDatabase(database.copy(x$14, x$15, x$13, x$16));
                URI uriInCatalog = $this.client().getDatabase("temporary").locationUri();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer("file");
                String $org_scalatest_assert_macro_right = uriInCatalog.getScheme();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 255));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(new Path(tempDatabasePath2.getPath()).toUri().getPath());
                String $org_scalatest_assert_macro_right2 = uriInCatalog.getPath();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"Failed to alter database location", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 256));
                return assertion;
            }
            AnalysisException e = (AnalysisException)$this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                URI x$17 = tempDatabasePath2;
                String x$18 = database.copy$default$1();
                String x$19 = database.copy$default$2();
                Map x$20 = database.copy$default$4();
                $this.client().alterDatabase(database.copy(x$18, x$19, x$17, x$20));
            }, ClassTag$.MODULE$.apply(AnalysisException.class), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 259));
            String $org_scalatest_assert_macro_left = e.getMessage();
            String $org_scalatest_assert_macro_right = "does not support altering database location";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 262));
            return assertion;
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 244));
        $this.test(new StringBuilder(14).append(version).append(": dropDatabase").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool($this.client().databaseExists("temporary"), "VersionsSuite.this.client.databaseExists(\"temporary\")", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 267));
            $this.client().dropDatabase("temporary", false, true);
            boolean $org_scalatest_assert_macro_left = $this.client().databaseExists("temporary");
            boolean $org_scalatest_assert_macro_right = false;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 269));
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 266));
        $this.test(new StringBuilder(13).append(version).append(": createTable").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.client().createTable(VersionsSuite.table$1("default", "src", VersionsSuite.table$default$3$1()), false);
            $this.client().createTable(VersionsSuite.table$1("default", "temporary", VersionsSuite.table$default$3$1()), false);
            $this.client().createTable(VersionsSuite.table$1("default", "view1", CatalogTableType$.MODULE$.VIEW()), false);
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 276));
        $this.test(new StringBuilder(11).append(version).append(": loadTable").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.client().loadTable($this.emptyDir(), "src", false, false), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 283));
        $this.test(new StringBuilder(13).append(version).append(": tableExists").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool($this.client().tableExists("default", "src"), "VersionsSuite.this.client.tableExists(\"default\", \"src\")", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 293));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool($this.client().tableExists("default", "nonexistent"), "VersionsSuite.this.client.tableExists(\"default\", \"nonexistent\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 294));
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 291));
        $this.test(new StringBuilder(10).append(version).append(": getTable").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> $this.client().getTable("default", "src"), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 297));
        $this.test(new StringBuilder(16).append(version).append(": getTableOption").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool($this.client().getTableOption("default", "src").isDefined(), "VersionsSuite.this.client.getTableOption(\"default\", \"src\").isDefined", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 303));
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 302));
        $this.test(new StringBuilder(17).append(version).append(": getTablesByName").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            CatalogTable $org_scalatest_assert_macro_left = (CatalogTable)$this.client().getTablesByName("default", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"src"}))).head();
            CatalogTable $org_scalatest_assert_macro_right = (CatalogTable)$this.client().getTableOption("default", "src").get();
            CatalogTable catalogTable = $org_scalatest_assert_macro_left;
            CatalogTable catalogTable2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(catalogTable != null ? !catalogTable.equals(catalogTable2) : catalogTable2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 307));
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 306));
        $this.test(new StringBuilder(38).append(version).append(": getTablesByName when multiple tables").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Seq $org_scalatest_assert_macro_left = (Seq)$this.client().getTablesByName("default", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"src", "temporary"}))).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.identifier().table(), Seq$.MODULE$.canBuildFrom());
            Seq $org_scalatest_assert_macro_right = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"src", "temporary"}));
            Seq seq = $org_scalatest_assert_macro_left;
            Seq seq2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(seq != null ? !seq.equals(seq2) : seq2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 312));
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 311));
        $this.test(new StringBuilder(47).append(version).append(": getTablesByName when some tables do not exist").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Seq $org_scalatest_assert_macro_left = (Seq)$this.client().getTablesByName("default", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"src", "notexist"}))).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.identifier().table(), Seq$.MODULE$.canBuildFrom());
            Seq $org_scalatest_assert_macro_right = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"src"}));
            Seq seq = $org_scalatest_assert_macro_left;
            Seq seq2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(seq != null ? !seq.equals(seq2) : seq2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 317));
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 316));
        $this.test(new StringBuilder(44).append(version).append(": getTablesByName when contains invalid name").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String name = "\u7816";
            Seq $org_scalatest_assert_macro_left = (Seq)$this.client().getTablesByName("default", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"src", name}))).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.identifier().table(), Seq$.MODULE$.canBuildFrom());
            Seq $org_scalatest_assert_macro_right = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"src"}));
            Seq seq = $org_scalatest_assert_macro_left;
            Seq seq2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(seq != null ? !seq.equals(seq2) : seq2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 325));
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 321));
        $this.test(new StringBuilder(28).append(version).append(": getTablesByName when empty").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Seq $org_scalatest_assert_macro_left = $this.client().getTablesByName("default", (Seq)Seq$.MODULE$.empty());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 330));
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 329));
        $this.test(new StringBuilder(33).append(version).append(": alterTable(table: CatalogTable)").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            CatalogTable qual$2 = $this.client().getTable("default", "src");
            Map x$21 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"changed"), (Object)"")}));
            TableIdentifier x$22 = qual$2.copy$default$1();
            CatalogTableType x$23 = qual$2.copy$default$2();
            CatalogStorageFormat x$24 = qual$2.copy$default$3();
            StructType x$25 = qual$2.copy$default$4();
            Option x$26 = qual$2.copy$default$5();
            Seq x$27 = qual$2.copy$default$6();
            Option x$28 = qual$2.copy$default$7();
            String x$29 = qual$2.copy$default$8();
            long x$30 = qual$2.copy$default$9();
            long x$31 = qual$2.copy$default$10();
            String x$32 = qual$2.copy$default$11();
            Option x$33 = qual$2.copy$default$13();
            Option x$34 = qual$2.copy$default$14();
            Option x$35 = qual$2.copy$default$15();
            Seq x$36 = qual$2.copy$default$16();
            boolean x$37 = qual$2.copy$default$17();
            boolean x$38 = qual$2.copy$default$18();
            Map x$39 = qual$2.copy$default$19();
            Option x$40 = qual$2.copy$default$20();
            CatalogTable newTable = qual$2.copy(x$22, x$23, x$24, x$25, x$26, x$27, x$28, x$29, x$30, x$31, x$32, x$21, x$33, x$34, x$35, x$36, x$37, x$38, x$39, x$40);
            $this.client().alterTable(newTable);
            Map $org_scalatest_assert_macro_left = $this.client().getTable("default", "src").properties();
            String $org_scalatest_assert_macro_right = "changed";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 336));
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 333));
        $this.test(new StringBuilder(69).append(version).append(": alterTable - should respect the original catalog table's owner name").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String ownerName = "SPARK-29405";
            CatalogTable originalTable = $this.client().getTable("default", "src");
            String x$41 = ownerName;
            TableIdentifier x$42 = originalTable.copy$default$1();
            CatalogTableType x$43 = originalTable.copy$default$2();
            CatalogStorageFormat x$44 = originalTable.copy$default$3();
            StructType x$45 = originalTable.copy$default$4();
            Option x$46 = originalTable.copy$default$5();
            Seq x$47 = originalTable.copy$default$6();
            Option x$48 = originalTable.copy$default$7();
            long x$49 = originalTable.copy$default$9();
            long x$50 = originalTable.copy$default$10();
            String x$51 = originalTable.copy$default$11();
            Map x$52 = originalTable.copy$default$12();
            Option x$53 = originalTable.copy$default$13();
            Option x$54 = originalTable.copy$default$14();
            Option x$55 = originalTable.copy$default$15();
            Seq x$56 = originalTable.copy$default$16();
            boolean x$57 = originalTable.copy$default$17();
            boolean x$58 = originalTable.copy$default$18();
            Map x$59 = originalTable.copy$default$19();
            Option x$60 = originalTable.copy$default$20();
            CatalogTable newTable = originalTable.copy(x$42, x$43, x$44, x$45, x$46, x$47, x$48, x$41, x$49, x$50, x$51, x$52, x$53, x$54, x$55, x$56, x$57, x$58, x$59, x$60);
            $this.client().alterTable(newTable);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer($this.client().getTable("default", "src").owner());
            String $org_scalatest_assert_macro_right = ownerName;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 345));
            String x$61 = "";
            TableIdentifier x$62 = originalTable.copy$default$1();
            CatalogTableType x$63 = originalTable.copy$default$2();
            CatalogStorageFormat x$64 = originalTable.copy$default$3();
            StructType x$65 = originalTable.copy$default$4();
            Option x$66 = originalTable.copy$default$5();
            Seq x$67 = originalTable.copy$default$6();
            Option x$68 = originalTable.copy$default$7();
            long x$69 = originalTable.copy$default$9();
            long x$70 = originalTable.copy$default$10();
            String x$71 = originalTable.copy$default$11();
            Map x$72 = originalTable.copy$default$12();
            Option x$73 = originalTable.copy$default$13();
            Option x$74 = originalTable.copy$default$14();
            Option x$75 = originalTable.copy$default$15();
            Seq x$76 = originalTable.copy$default$16();
            boolean x$77 = originalTable.copy$default$17();
            boolean x$78 = originalTable.copy$default$18();
            Map x$79 = originalTable.copy$default$19();
            Option x$80 = originalTable.copy$default$20();
            CatalogTable newTable2 = originalTable.copy(x$62, x$63, x$64, x$65, x$66, x$67, x$68, x$61, x$69, x$70, x$71, x$72, x$73, x$74, x$75, x$76, x$77, x$78, x$79, x$80);
            $this.client().alterTable(newTable2);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer($this.client().getTable("default", "src").owner());
            String $org_scalatest_assert_macro_right2 = $this.client().userName();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 349));
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 339));
        $this.test(new StringBuilder(68).append(version).append(": alterTable(dbName: String, tableName: String, table: CatalogTable)").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            CatalogTable qual$3 = $this.client().getTable("default", "src");
            Map x$81 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"changedAgain"), (Object)"")}));
            TableIdentifier x$82 = qual$3.copy$default$1();
            CatalogTableType x$83 = qual$3.copy$default$2();
            CatalogStorageFormat x$84 = qual$3.copy$default$3();
            StructType x$85 = qual$3.copy$default$4();
            Option x$86 = qual$3.copy$default$5();
            Seq x$87 = qual$3.copy$default$6();
            Option x$88 = qual$3.copy$default$7();
            String x$89 = qual$3.copy$default$8();
            long x$90 = qual$3.copy$default$9();
            long x$91 = qual$3.copy$default$10();
            String x$92 = qual$3.copy$default$11();
            Option x$93 = qual$3.copy$default$13();
            Option x$94 = qual$3.copy$default$14();
            Option x$95 = qual$3.copy$default$15();
            Seq x$96 = qual$3.copy$default$16();
            boolean x$97 = qual$3.copy$default$17();
            boolean x$98 = qual$3.copy$default$18();
            Map x$99 = qual$3.copy$default$19();
            Option x$100 = qual$3.copy$default$20();
            CatalogTable newTable = qual$3.copy(x$82, x$83, x$84, x$85, x$86, x$87, x$88, x$89, x$90, x$91, x$92, x$81, x$93, x$94, x$95, x$96, x$97, x$98, x$99, x$100);
            $this.client().alterTable("default", "src", newTable);
            Map $org_scalatest_assert_macro_left = $this.client().getTable("default", "src").properties();
            String $org_scalatest_assert_macro_right = "changedAgain";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 355));
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 352));
        $this.test(new StringBuilder(21).append(version).append(": alterTable - rename").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            CatalogTable qual$4 = $this.client().getTable("default", "src");
            TableIdentifier x$101 = new TableIdentifier("tgt", (Option)new Some((Object)"default"));
            CatalogTableType x$102 = qual$4.copy$default$2();
            CatalogStorageFormat x$103 = qual$4.copy$default$3();
            StructType x$104 = qual$4.copy$default$4();
            Option x$105 = qual$4.copy$default$5();
            Seq x$106 = qual$4.copy$default$6();
            Option x$107 = qual$4.copy$default$7();
            String x$108 = qual$4.copy$default$8();
            long x$109 = qual$4.copy$default$9();
            long x$110 = qual$4.copy$default$10();
            String x$111 = qual$4.copy$default$11();
            Map x$112 = qual$4.copy$default$12();
            Option x$113 = qual$4.copy$default$13();
            Option x$114 = qual$4.copy$default$14();
            Option x$115 = qual$4.copy$default$15();
            Seq x$116 = qual$4.copy$default$16();
            boolean x$117 = qual$4.copy$default$17();
            boolean x$118 = qual$4.copy$default$18();
            Map x$119 = qual$4.copy$default$19();
            Option x$120 = qual$4.copy$default$20();
            CatalogTable newTable = qual$4.copy(x$101, x$102, x$103, x$104, x$105, x$106, x$107, x$108, x$109, x$110, x$111, x$112, x$113, x$114, x$115, x$116, x$117, x$118, x$119, x$120);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool($this.client().tableExists("default", "tgt"), "VersionsSuite.this.client.tableExists(\"default\", \"tgt\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 361));
            $this.client().alterTable("default", "src", newTable);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool($this.client().tableExists("default", "tgt"), "VersionsSuite.this.client.tableExists(\"default\", \"tgt\")", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 365));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool($this.client().tableExists("default", "src"), "VersionsSuite.this.client.tableExists(\"default\", \"src\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 366));
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 358));
        $this.test(new StringBuilder(30).append(version).append(": alterTable - change database").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            CatalogDatabase tempDB = new CatalogDatabase("temporary", "test create", tempDatabasePath, (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
            $this.client().createDatabase(tempDB, true);
            CatalogTable qual$5 = $this.client().getTable("default", "tgt");
            TableIdentifier x$121 = new TableIdentifier("tgt", (Option)new Some((Object)"temporary"));
            CatalogTableType x$122 = qual$5.copy$default$2();
            CatalogStorageFormat x$123 = qual$5.copy$default$3();
            StructType x$124 = qual$5.copy$default$4();
            Option x$125 = qual$5.copy$default$5();
            Seq x$126 = qual$5.copy$default$6();
            Option x$127 = qual$5.copy$default$7();
            String x$128 = qual$5.copy$default$8();
            long x$129 = qual$5.copy$default$9();
            long x$130 = qual$5.copy$default$10();
            String x$131 = qual$5.copy$default$11();
            Map x$132 = qual$5.copy$default$12();
            Option x$133 = qual$5.copy$default$13();
            Option x$134 = qual$5.copy$default$14();
            Option x$135 = qual$5.copy$default$15();
            Seq x$136 = qual$5.copy$default$16();
            boolean x$137 = qual$5.copy$default$17();
            boolean x$138 = qual$5.copy$default$18();
            Map x$139 = qual$5.copy$default$19();
            Option x$140 = qual$5.copy$default$20();
            CatalogTable newTable = qual$5.copy(x$121, x$122, x$123, x$124, x$125, x$126, x$127, x$128, x$129, x$130, x$131, x$132, x$133, x$134, x$135, x$136, x$137, x$138, x$139, x$140);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool($this.client().tableExists("temporary", "tgt"), "VersionsSuite.this.client.tableExists(\"temporary\", \"tgt\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 376));
            $this.client().alterTable("default", "tgt", newTable);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool($this.client().tableExists("temporary", "tgt"), "VersionsSuite.this.client.tableExists(\"temporary\", \"tgt\")", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 380));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool($this.client().tableExists("default", "tgt"), "VersionsSuite.this.client.tableExists(\"default\", \"tgt\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 381));
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 369));
        $this.test(new StringBuilder(46).append(version).append(": alterTable - change database and table names").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            CatalogTable qual$6 = $this.client().getTable("temporary", "tgt");
            TableIdentifier x$141 = new TableIdentifier("src", (Option)new Some((Object)"default"));
            CatalogTableType x$142 = qual$6.copy$default$2();
            CatalogStorageFormat x$143 = qual$6.copy$default$3();
            StructType x$144 = qual$6.copy$default$4();
            Option x$145 = qual$6.copy$default$5();
            Seq x$146 = qual$6.copy$default$6();
            Option x$147 = qual$6.copy$default$7();
            String x$148 = qual$6.copy$default$8();
            long x$149 = qual$6.copy$default$9();
            long x$150 = qual$6.copy$default$10();
            String x$151 = qual$6.copy$default$11();
            Map x$152 = qual$6.copy$default$12();
            Option x$153 = qual$6.copy$default$13();
            Option x$154 = qual$6.copy$default$14();
            Option x$155 = qual$6.copy$default$15();
            Seq x$156 = qual$6.copy$default$16();
            boolean x$157 = qual$6.copy$default$17();
            boolean x$158 = qual$6.copy$default$18();
            Map x$159 = qual$6.copy$default$19();
            Option x$160 = qual$6.copy$default$20();
            CatalogTable newTable = qual$6.copy(x$141, x$142, x$143, x$144, x$145, x$146, x$147, x$148, x$149, x$150, x$151, x$152, x$153, x$154, x$155, x$156, x$157, x$158, x$159, x$160);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool($this.client().tableExists("default", "src"), "VersionsSuite.this.client.tableExists(\"default\", \"src\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 387));
            $this.client().alterTable("temporary", "tgt", newTable);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool($this.client().tableExists("default", "src"), "VersionsSuite.this.client.tableExists(\"default\", \"src\")", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 391));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool($this.client().tableExists("temporary", "tgt"), "VersionsSuite.this.client.tableExists(\"temporary\", \"tgt\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 392));
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 384));
        $this.test(new StringBuilder(22).append(version).append(": listTables(database)").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer($this.client().listTables("default"));
            Seq $org_scalatest_assert_macro_right = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"src", "temporary", "view1"}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 396));
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 395));
        $this.test(new StringBuilder(31).append(version).append(": listTables(database, pattern)").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer($this.client().listTables("default", "src"));
            Seq $org_scalatest_assert_macro_right = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"src"}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 400));
            Seq $org_scalatest_assert_macro_left2 = $this.client().listTables("default", "nonexist");
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 401));
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 399));
        $this.test(new StringBuilder(48).append(version).append(": listTablesByType(database, pattern, tableType)").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer($this.client().listTablesByType("default", "view1", CatalogTableType$.MODULE$.VIEW()));
            Seq $org_scalatest_assert_macro_right = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"view1"}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 405));
            Seq $org_scalatest_assert_macro_left2 = $this.client().listTablesByType("default", "nonexist", CatalogTableType$.MODULE$.VIEW());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 407));
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 404));
        $this.test(new StringBuilder(11).append(version).append(": dropTable").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            Assertion assertion;
            Nil$ versionsWithoutPurge = $this.versions().contains((Object)"0.14") ? (Seq)$this.versions().takeWhile((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)VersionsSuite.$anonfun$new$44(x$4))) : Nil$.MODULE$;
            try {
                $this.client().dropTable("default", "temporary", false, true);
                Nil$ $org_scalatest_assert_macro_left = versionsWithoutPurge;
                String $org_scalatest_assert_macro_right = version;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 419));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                Nil$ $org_scalatest_assert_macro_left = versionsWithoutPurge;
                String $org_scalatest_assert_macro_right = version;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 422));
                $this.client().dropTable("default", "temporary", false, false);
                assertion = BoxedUnit.UNIT;
            }
            try {
                $this.client().dropTable("default", "view1", false, true);
                Nil$ $org_scalatest_assert_macro_left = versionsWithoutPurge;
                String $org_scalatest_assert_macro_right = version;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                boxedUnit = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 430));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                $this.client().dropTable("default", "view1", false, false);
                boxedUnit = BoxedUnit.UNIT;
            }
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer($this.client().listTables("default"));
            Seq $org_scalatest_assert_macro_right = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"src"}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 436));
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 411));
        CatalogStorageFormat storageFormat = new CatalogStorageFormat((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, false, Predef$.MODULE$.Map().empty());
        $this.test(new StringBuilder(30).append(version).append(": sql create partitioned table").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TableIdentifier x$161 = new TableIdentifier("src_part", (Option)new Some((Object)"default"));
            CatalogTableType x$162 = CatalogTableType$.MODULE$.MANAGED();
            StructType x$163 = new StructType().add("value", "int").add("key1", "int").add("key2", "int");
            Seq x$164 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key1", "key2"}));
            CatalogStorageFormat x$165 = new CatalogStorageFormat((Option)None$.MODULE$, (Option)new Some((Object)TextInputFormat.class.getName()), (Option)new Some((Object)HiveIgnoreKeyTextOutputFormat.class.getName()), (Option)new Some((Object)LazySimpleSerDe.class.getName()), false, Predef$.MODULE$.Map().empty());
            Option x$166 = CatalogTable$.MODULE$.apply$default$5();
            Option x$167 = CatalogTable$.MODULE$.apply$default$7();
            String x$168 = CatalogTable$.MODULE$.apply$default$8();
            long x$169 = CatalogTable$.MODULE$.apply$default$9();
            long x$170 = CatalogTable$.MODULE$.apply$default$10();
            String x$171 = CatalogTable$.MODULE$.apply$default$11();
            Map x$172 = CatalogTable$.MODULE$.apply$default$12();
            Option x$173 = CatalogTable$.MODULE$.apply$default$13();
            Option x$174 = CatalogTable$.MODULE$.apply$default$14();
            Option x$175 = CatalogTable$.MODULE$.apply$default$15();
            Seq x$176 = CatalogTable$.MODULE$.apply$default$16();
            boolean x$177 = CatalogTable$.MODULE$.apply$default$17();
            boolean x$178 = CatalogTable$.MODULE$.apply$default$18();
            Map x$179 = CatalogTable$.MODULE$.apply$default$19();
            Option x$180 = CatalogTable$.MODULE$.apply$default$20();
            CatalogTable table = new CatalogTable(x$161, x$162, x$165, x$163, x$166, x$164, x$167, x$168, x$169, x$170, x$171, x$172, x$173, x$174, x$175, x$176, x$177, x$178, x$179, x$180);
            $this.client().createTable(table, false);
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 451));
        int testPartitionCount = 2;
        $this.test(new StringBuilder(18).append(version).append(": createPartitions").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            IndexedSeq partitions = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), testPartitionCount).map((Function1 & Serializable & scala.Serializable)key2 -> VersionsSuite.$anonfun$new$47(storageFormat, BoxesRunTime.unboxToInt((Object)key2)), IndexedSeq$.MODULE$.canBuildFrom());
            $this.client().createPartitions("default", "src_part", (Seq)partitions, true);
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 470));
        $this.test(new StringBuilder(33).append(version).append(": getPartitionNames(catalogTable)").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            IndexedSeq partitionNames;
            IndexedSeq $org_scalatest_assert_macro_left = partitionNames = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), testPartitionCount).map((Function1 & Serializable & scala.Serializable)key2 -> VersionsSuite.$anonfun$new$49(BoxesRunTime.unboxToInt((Object)key2)), IndexedSeq$.MODULE$.canBuildFrom());
            HiveClient qual$7 = $this.client();
            CatalogTable x$181 = $this.client().getTable("default", "src_part");
            Option x$182 = qual$7.getPartitionNames$default$2();
            Seq $org_scalatest_assert_macro_right = qual$7.getPartitionNames(x$181, x$182);
            IndexedSeq indexedSeq = $org_scalatest_assert_macro_left;
            Seq seq = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(indexedSeq != null ? !indexedSeq.equals(seq) : seq != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 480));
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 478));
        $this.test(new StringBuilder(29).append(version).append(": getPartitions(catalogTable)").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            int $org_scalatest_assert_macro_left = testPartitionCount;
            HiveClient qual$8 = $this.client();
            CatalogTable x$183 = $this.client().getTable("default", "src_part");
            Option x$184 = qual$8.getPartitions$default$2();
            int $org_scalatest_assert_macro_right = qual$8.getPartitions(x$183, x$184).size();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 484));
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 483));
        $this.test(new StringBuilder(23).append(version).append(": getPartitionsByFilter").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Assertion assertion;
            EqualTo[] equalToArray = new EqualTo[1];
            String x$185 = "key2";
            IntegerType$ x$186 = IntegerType$.MODULE$;
            boolean x$187 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$188 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$189 = AttributeReference$.MODULE$.apply$default$5(x$185, (DataType)x$186, x$187, x$188);
            Seq x$190 = AttributeReference$.MODULE$.apply$default$6(x$185, (DataType)x$186, x$187, x$188);
            equalToArray[0] = new EqualTo((Expression)new AttributeReference(x$185, (DataType)x$186, x$187, x$188, x$189, x$190), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)));
            Seq result = $this.client().getPartitionsByFilter($this.client().getTable("default", "src_part"), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])equalToArray)), $this.versionSpark().conf().sessionLocalTimeZone());
            String string = version;
            String string2 = "0.12";
            if (string == null ? string2 != null : !string.equals(string2)) {
                Seq $org_scalatest_assert_macro_left = result;
                int $org_scalatest_assert_macro_right = 1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 496));
            } else {
                Seq $org_scalatest_assert_macro_left = result;
                int $org_scalatest_assert_macro_right = testPartitionCount;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 498));
            }
            return assertion;
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 488));
        $this.test(new StringBuilder(14).append(version).append(": getPartition").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> $this.client().getPartition("default", "src_part", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key1"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key2"), (Object)"2")}))), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 502));
        $this.test(new StringBuilder(73).append(version).append(": getPartitionOption(db: String, table: String, spec: TablePartitionSpec)").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Option partition = $this.client().getPartitionOption("default", "src_part", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key1"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key2"), (Object)"2")})));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(partition.isDefined(), "partition.isDefined", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 510));
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 507));
        $this.test(new StringBuilder(67).append(version).append(": getPartitionOption(table: CatalogTable, spec: TablePartitionSpec)").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Option partition = $this.client().getPartitionOption($this.client().getTable("default", "src_part"), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key1"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key2"), (Object)"2")})));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(partition.isDefined(), "partition.isDefined", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 516));
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 513));
        $this.test(new StringBuilder(42).append(version).append(": getPartitions(db: String, table: String)").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            int $org_scalatest_assert_macro_left = testPartitionCount;
            int $org_scalatest_assert_macro_right = $this.client().getPartitions("default", "src_part", (Option)None$.MODULE$).size();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 520));
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 519));
        $this.test(new StringBuilder(15).append(version).append(": loadPartition").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LinkedHashMap<String, String> partSpec = new LinkedHashMap<String, String>();
            partSpec.put("key1", "1");
            partSpec.put("key2", "2");
            $this.client().loadPartition($this.emptyDir(), "default", "src_part", partSpec, false, false, false);
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 523));
        $this.test(new StringBuilder(23).append(version).append(": loadDynamicPartitions").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LinkedHashMap<String, String> partSpec = new LinkedHashMap<String, String>();
            partSpec.put("key1", "1");
            partSpec.put("key2", "");
            $this.client().loadDynamicPartitions($this.emptyDir(), "default", "src_part", partSpec, false, 1);
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 538));
        $this.test(new StringBuilder(18).append(version).append(": renamePartitions").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Map oldSpec = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key1"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key2"), (Object)"1")}));
            Map newSpec = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key1"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key2"), (Object)"3")}));
            $this.client().renamePartitions("default", "src_part", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{oldSpec})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{newSpec})));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool($this.client().getPartitionOption("default", "src_part", newSpec).isDefined(), "VersionsSuite.this.client.getPartitionOption(\"default\", \"src_part\", newSpec).isDefined", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 558));
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 552));
        $this.test(new StringBuilder(17).append(version).append(": alterPartitions").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Map spec = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key1"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key2"), (Object)"2")}));
            Map parameters = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"totalSize"), (Object)"0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numFiles"), (Object)"1")}));
            URI newLocation = new URI(new StringOps(Predef$.MODULE$.augmentString(Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()).toURI().toString())).stripSuffix("/"));
            Some x$191 = new Some((Object)newLocation);
            Some x$192 = new Some((Object)"org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe");
            Option x$193 = storageFormat.copy$default$2();
            Option x$194 = storageFormat.copy$default$3();
            boolean x$195 = storageFormat.copy$default$5();
            Map x$196 = storageFormat.copy$default$6();
            CatalogStorageFormat storage = storageFormat.copy((Option)x$191, x$193, x$194, (Option)x$192, x$195, x$196);
            CatalogTablePartition partition = new CatalogTablePartition(spec, storage, parameters, CatalogTablePartition$.MODULE$.apply$default$4(), CatalogTablePartition$.MODULE$.apply$default$5(), CatalogTablePartition$.MODULE$.apply$default$6());
            $this.client().alterPartitions("default", "src_part", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{partition})));
            Option $org_scalatest_assert_macro_left = $this.client().getPartition("default", "src_part", spec).storage().locationUri();
            Some $org_scalatest_assert_macro_right = new Some((Object)newLocation);
            Option option = $org_scalatest_assert_macro_left;
            Some some = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(option != null ? !option.equals(some) : some != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 571));
            Option $org_scalatest_assert_macro_left2 = $this.client().getPartition("default", "src_part", spec).parameters().get((Object)"totalSize");
            Some $org_scalatest_assert_macro_right2 = new Some((Object)"0");
            Option option2 = $org_scalatest_assert_macro_left2;
            Some some2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(option2 != null ? !option2.equals(some2) : some2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 573));
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 561));
        $this.test(new StringBuilder(16).append(version).append(": dropPartitions").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Assertion assertion;
            Map spec = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key1"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key2"), (Object)"3")}));
            Nil$ versionsWithoutPurge = $this.versions().contains((Object)"1.2") ? (Seq)$this.versions().takeWhile((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)VersionsSuite.$anonfun$new$61(x$5))) : Nil$.MODULE$;
            try {
                $this.client().dropPartitions("default", "src_part", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{spec})), true, true, false);
                Nil$ $org_scalatest_assert_macro_left = versionsWithoutPurge;
                String $org_scalatest_assert_macro_right = version;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 586));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                Nil$ $org_scalatest_assert_macro_left = versionsWithoutPurge;
                String $org_scalatest_assert_macro_right = version;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 589));
                $this.client().dropPartitions("default", "src_part", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{spec})), true, false, false);
                assertion = BoxedUnit.UNIT;
            }
            Option $org_scalatest_assert_macro_left = $this.client().getPartitionOption("default", "src_part", spec);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 594));
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 577));
        $this.test(new StringBuilder(36).append(version).append(": createPartitions if already exists").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Assertion assertion;
            Seq partitions = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{new CatalogTablePartition((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key1"), (Object)"101"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key2"), (Object)"102")})), storageFormat, CatalogTablePartition$.MODULE$.apply$default$3(), CatalogTablePartition$.MODULE$.apply$default$4(), CatalogTablePartition$.MODULE$.apply$default$5(), CatalogTablePartition$.MODULE$.apply$default$6())}));
            try {
                String errMsg;
                $this.client().createPartitions("default", "src_part", partitions, false);
                String $org_scalatest_assert_macro_left = errMsg = ((AnalysisException)$this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.client().createPartitions("default", "src_part", partitions, false), ClassTag$.MODULE$.apply(PartitionsAlreadyExistException.class), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 603))).getMessage();
                String $org_scalatest_assert_macro_right = "partitions already exists";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 606));
            }
            finally {
                $this.client().dropPartitions("default", "src_part", (Seq)partitions.map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.spec(), Seq$.MODULE$.canBuildFrom()), true, false, false);
            }
            return assertion;
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 597));
        $this.test(new StringBuilder(16).append(version).append(": createFunction").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Object object;
            String functionClass = "org.apache.spark.MyFunc1";
            String string = version;
            String string2 = "0.12";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                object = $this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.client().createFunction("default", VersionsSuite.function$1("func1", functionClass)), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 631));
            } else {
                $this.client().createFunction("default", VersionsSuite.function$1("func1", functionClass));
                object = BoxedUnit.UNIT;
            }
            return object;
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 627));
        $this.test(new StringBuilder(16).append(version).append(": functionExists").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Assertion assertion;
            String string = version;
            String string2 = "0.12";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                boolean $org_scalatest_assert_macro_left = $this.client().functionExists("default", "func1");
                boolean $org_scalatest_assert_macro_right = false;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 642));
            } else {
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool($this.client().functionExists("default", "func1"), "VersionsSuite.this.client.functionExists(\"default\", \"func1\")", Prettifier$.MODULE$.default());
                assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 644));
            }
            return assertion;
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 639));
        $this.test(new StringBuilder(16).append(version).append(": renameFunction").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Object object;
            String string = version;
            String string2 = "0.12";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                object = $this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.client().renameFunction("default", "func1", "func2"), ClassTag$.MODULE$.apply(NoSuchPermanentFunctionException.class), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 651));
            } else {
                $this.client().renameFunction("default", "func1", "func2");
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool($this.client().functionExists("default", "func2"), "VersionsSuite.this.client.functionExists(\"default\", \"func2\")", Prettifier$.MODULE$.default());
                object = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 656));
            }
            return object;
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 648));
        $this.test(new StringBuilder(15).append(version).append(": alterFunction").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Object object;
            String functionClass = "org.apache.spark.MyFunc2";
            String string = version;
            String string2 = "0.12";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                object = $this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.client().alterFunction("default", VersionsSuite.function$1("func2", functionClass)), ClassTag$.MODULE$.apply(NoSuchPermanentFunctionException.class), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 664));
            } else {
                $this.client().alterFunction("default", VersionsSuite.function$1("func2", functionClass));
                object = BoxedUnit.UNIT;
            }
            return object;
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 660));
        $this.test(new StringBuilder(13).append(version).append(": getFunction").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Object object;
            String string = version;
            String string2 = "0.12";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                object = $this.intercept((Function0 & Serializable & scala.Serializable)() -> $this.client().getFunction("default", "func2"), ClassTag$.MODULE$.apply(NoSuchPermanentFunctionException.class), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 675));
            } else {
                CatalogFunction func = $this.client().getFunction("default", "func2");
                String $org_scalatest_assert_macro_left = func.className();
                String $org_scalatest_assert_macro_right = "org.apache.spark.MyFunc2";
                String string3 = $org_scalatest_assert_macro_left;
                String string4 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
                object = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 681));
            }
            return object;
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 672));
        $this.test(new StringBuilder(19).append(version).append(": getFunctionOption").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Assertion assertion;
            String string = version;
            String string2 = "0.12";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                Option $org_scalatest_assert_macro_left = $this.client().getFunctionOption("default", "func2");
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
                assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 688));
            } else {
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool($this.client().getFunctionOption("default", "func2").isDefined(), "VersionsSuite.this.client.getFunctionOption(\"default\", \"func2\").isDefined", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 690));
                Option $org_scalatest_assert_macro_left = $this.client().getFunctionOption("default", "the_func_not_exists");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
                assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 691));
            }
            return assertion;
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 685));
        $this.test(new StringBuilder(15).append(version).append(": listFunctions").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Assertion assertion;
            String string = version;
            String string2 = "0.12";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                Seq $org_scalatest_assert_macro_left = $this.client().listFunctions("default", "fun.*");
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
                assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 698));
            } else {
                Seq $org_scalatest_assert_macro_left = $this.client().listFunctions("default", "fun.*");
                int $org_scalatest_assert_macro_right = 1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 700));
            }
            return assertion;
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 695));
        $this.test(new StringBuilder(14).append(version).append(": dropFunction").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Object object;
            String string = version;
            String string2 = "0.12";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                object = $this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.client().dropFunction("default", "func2"), ClassTag$.MODULE$.apply(NoSuchPermanentFunctionException.class), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 707));
            } else {
                $this.client().dropFunction("default", "func2");
                Seq $org_scalatest_assert_macro_left = $this.client().listFunctions("default", "fun.*");
                int $org_scalatest_assert_macro_right = 0;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                object = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 713));
            }
            return object;
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 704));
        $this.test(new StringBuilder(17).append(version).append(": sql set command").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> $this.client().runSqlHive("SET spark.sql.test.key=1"), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 721));
        $this.test(new StringBuilder(28).append(version).append(": sql create index and reset").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            String string = version;
            String string2 = "3.0";
            if (string == null ? string2 != null : !string.equals(string2)) {
                String string3 = version;
                String string4 = "3.1";
                if (string3 == null ? string4 != null : !string3.equals(string4)) {
                    $this.client().runSqlHive("CREATE TABLE indexed_table (key INT)");
                    boxedUnit = $this.client().runSqlHive("CREATE INDEX index_1 ON TABLE indexed_table(key) as 'COMPACT' WITH DEFERRED REBUILD");
                    return boxedUnit;
                }
            }
            boxedUnit = BoxedUnit.UNIT;
            return boxedUnit;
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 725));
        $this.test(new StringBuilder(33).append(version).append(": sql read hive materialized view").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), () -> VersionsSuite.$anonfun$new$80($this, version), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 734));
        $this.test(new StringBuilder(9).append(version).append(": version").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String $org_scalatest_assert_macro_left = $this.client().version().fullVersion();
            String $org_scalatest_assert_macro_right = version;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "startsWith", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.startsWith($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 754));
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 753));
        $this.test(new StringBuilder(9).append(version).append(": getConf").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer("success");
            String $org_scalatest_assert_macro_right = $this.client().getConf("test", null);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 758));
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 757));
        $this.test(new StringBuilder(8).append(version).append(": setOut").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.client().setOut(new PrintStream(new ByteArrayOutputStream())), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 761));
        $this.test(new StringBuilder(9).append(version).append(": setInfo").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.client().setInfo(new PrintStream(new ByteArrayOutputStream())), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 765));
        $this.test(new StringBuilder(10).append(version).append(": setError").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.client().setError(new PrintStream(new ByteArrayOutputStream())), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 769));
        $this.test(new StringBuilder(12).append(version).append(": newSession").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            HiveClient newClient;
            HiveClient $org_scalatest_assert_macro_left = newClient = $this.client().newSession();
            Object $org_scalatest_assert_macro_right = null;
            HiveClient hiveClient = $org_scalatest_assert_macro_left;
            Object var5_4 = null;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", null, hiveClient == null ? var5_4 != null : !hiveClient.equals(var5_4), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 775));
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 773));
        $this.test(new StringBuilder(26).append(version).append(": withHiveState and addJar").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            String newClassPath = ".";
            $this.client().addJar(newClassPath);
            return BoxesRunTime.unboxToBoolean((Object)$this.client().withHiveState((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                MutableURLClassLoader classLoader = (MutableURLClassLoader)Thread.currentThread().getContextClassLoader();
                URL[] urls = classLoader.getURLs();
                return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])urls)).contains((Object)new File(newClassPath).toURI().toURL());
            }));
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 778));
        $this.test(new StringBuilder(7).append(version).append(": reset").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            $this.client().reset();
            Seq $org_scalatest_assert_macro_left = $this.client().listTables("default");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 795));
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 792));
        $this.test(new StringBuilder(24).append(version).append(": CREATE TABLE AS SELECT").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tbl"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.versionSpark().sql("CREATE TABLE tbl AS SELECT 1 AS a");
            Seq $org_scalatest_assert_macro_left = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.versionSpark().table("tbl").collect())).toSeq();
            Seq $org_scalatest_assert_macro_right = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)}))}));
            Seq seq = $org_scalatest_assert_macro_left;
            Seq seq2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(seq != null ? !seq.equals(seq2) : seq2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 805));
            CatalogTable tableMeta = $this.versionSpark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply("tbl"));
            Option totalSize = tableMeta.stats().map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.sizeInBytes());
            String string = version;
            String string2 = "0.12";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                Option $org_scalatest_assert_macro_left2 = totalSize;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 810));
            } else {
                Bool bool;
                Option $org_scalatest_assert_macro_left3 = totalSize;
                Bool $org_scalatest_assert_macro_left4 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "nonEmpty", $org_scalatest_assert_macro_left3.nonEmpty(), Prettifier$.MODULE$.default());
                if ($org_scalatest_assert_macro_left4.value()) {
                    BigInt $org_scalatest_assert_macro_left5 = (BigInt)totalSize.get();
                    BigInt $org_scalatest_assert_macro_right2 = BigInt$.MODULE$.int2bigInt(0);
                    bool = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, ">", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left5.$greater((Object)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                } else {
                    bool = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
                }
                Bool $org_scalatest_assert_macro_right3 = bool;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "&&", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left4.$amp$amp((Function0 & Serializable & scala.Serializable)() -> $org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 812));
            }
        }), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 802));
        $this.test(new StringBuilder(36).append(version).append(": CREATE Partitioned TABLE AS SELECT").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tbl"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Assertion assertion;
            $this.versionSpark().sql(new StringOps(Predef$.MODULE$.augmentString("\n            |CREATE TABLE tbl(c1 string)\n            |USING hive\n            |PARTITIONED BY (ds STRING)\n          ")).stripMargin());
            $this.versionSpark().sql("INSERT OVERWRITE TABLE tbl partition (ds='2') SELECT '1'");
            Seq $org_scalatest_assert_macro_left = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.versionSpark().table("tbl").collect())).toSeq();
            Seq $org_scalatest_assert_macro_right = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1", "2"}))}));
            Seq seq = $org_scalatest_assert_macro_left;
            Seq seq2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(seq != null ? !seq.equals(seq2) : seq2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 827));
            Map partMeta = $this.versionSpark().sessionState().catalog().getPartition(TableIdentifier$.MODULE$.apply("tbl"), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ds"), (Object)"2")}))).parameters();
            Option totalSize = partMeta.get((Object)"totalSize").map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToLong((long)VersionsSuite.$anonfun$new$98(x$8)));
            Option numFiles = partMeta.get((Object)"numFiles").map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToLong((long)VersionsSuite.$anonfun$new$99(x$9)));
            String string = version;
            String string2 = "0.12";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                Bool bool;
                Option $org_scalatest_assert_macro_left2 = totalSize;
                Bool $org_scalatest_assert_macro_left3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
                if ($org_scalatest_assert_macro_left3.value()) {
                    Option $org_scalatest_assert_macro_left4 = numFiles;
                    bool = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left4, "isEmpty", $org_scalatest_assert_macro_left4.isEmpty(), Prettifier$.MODULE$.default());
                } else {
                    bool = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
                }
                Bool $org_scalatest_assert_macro_right2 = bool;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "&&", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left3.$amp$amp((Function0 & Serializable & scala.Serializable)() -> $org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 834));
            } else {
                Bool bool;
                Option $org_scalatest_assert_macro_left5 = totalSize;
                Bool $org_scalatest_assert_macro_left6 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left5, "nonEmpty", $org_scalatest_assert_macro_left5.nonEmpty(), Prettifier$.MODULE$.default());
                if ($org_scalatest_assert_macro_left6.value()) {
                    Option $org_scalatest_assert_macro_left7 = numFiles;
                    bool = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left7, "nonEmpty", $org_scalatest_assert_macro_left7.nonEmpty(), Prettifier$.MODULE$.default());
                } else {
                    bool = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
                }
                Bool $org_scalatest_assert_macro_right3 = bool;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "&&", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left6.$amp$amp((Function0 & Serializable & scala.Serializable)() -> $org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
                assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 836));
            }
            $this.versionSpark().sql(new StringOps(Predef$.MODULE$.augmentString("\n            |ALTER TABLE tbl PARTITION (ds='2')\n            |SET SERDEPROPERTIES ('newKey' = 'vvv')\n          ")).stripMargin());
            Map newPartMeta = $this.versionSpark().sessionState().catalog().getPartition(TableIdentifier$.MODULE$.apply("tbl"), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ds"), (Object)"2")}))).parameters();
            Option newTotalSize = newPartMeta.get((Object)"totalSize").map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToLong((long)VersionsSuite.$anonfun$new$102(x$10)));
            Option newNumFiles = newPartMeta.get((Object)"numFiles").map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToLong((long)VersionsSuite.$anonfun$new$103(x$11)));
            String string3 = version;
            String string4 = "0.12";
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                Bool bool;
                Option $org_scalatest_assert_macro_left8 = newTotalSize;
                Bool $org_scalatest_assert_macro_left9 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left8, "isEmpty", $org_scalatest_assert_macro_left8.isEmpty(), Prettifier$.MODULE$.default());
                if ($org_scalatest_assert_macro_left9.value()) {
                    Option $org_scalatest_assert_macro_left10 = newNumFiles;
                    bool = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left10, "isEmpty", $org_scalatest_assert_macro_left10.isEmpty(), Prettifier$.MODULE$.default());
                } else {
                    bool = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
                }
                Bool $org_scalatest_assert_macro_right4 = bool;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "&&", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left9.$amp$amp((Function0 & Serializable & scala.Serializable)() -> $org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 851));
            } else {
                Bool bool;
                Option $org_scalatest_assert_macro_left11 = newTotalSize;
                Bool $org_scalatest_assert_macro_left12 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left11, "nonEmpty", $org_scalatest_assert_macro_left11.nonEmpty(), Prettifier$.MODULE$.default());
                if ($org_scalatest_assert_macro_left12.value()) {
                    Option $org_scalatest_assert_macro_left13 = newNumFiles;
                    bool = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left13, "nonEmpty", $org_scalatest_assert_macro_left13.nonEmpty(), Prettifier$.MODULE$.default());
                } else {
                    bool = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
                }
                Bool $org_scalatest_assert_macro_right5 = bool;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "&&", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left12.$amp$amp((Function0 & Serializable & scala.Serializable)() -> $org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 853));
            }
        }), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 817));
        $this.test(new StringBuilder(68).append(version).append(": Delete the temporary staging directory and files after each insert").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.withTempDir((Function1 & Serializable & scala.Serializable)tmpDir -> {
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tab"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.versionSpark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(86).append("\n               |CREATE TABLE tab(c1 string)\n               |location '").append(tmpDir.toURI().toString()).append("'\n             ").toString())).stripMargin());
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 3).map((Function1 & Serializable & scala.Serializable)i -> VersionsSuite.$anonfun$new$109($this, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
                Seq metadataFiles = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"._SUCCESS.crc", "_SUCCESS"}));
                List $org_scalatest_assert_macro_left = (List)VersionsSuite.listFiles$1(tmpDir).filterNot((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)metadataFiles.contains(elem)));
                int $org_scalatest_assert_macro_right = 2;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 879));
            });
            return BoxedUnit.UNIT;
        }), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 858));
        $this.test(new StringBuilder(64).append(version).append(": SPARK-13709: reading partitioned Avro table with nested schema").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.withTempDir((Function1 & Serializable & scala.Serializable)dir -> {
            VersionsSuite.$anonfun$new$115($this, dir);
            return BoxedUnit.UNIT;
        }), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 884));
        $this.test(new StringBuilder(37).append(version).append(": CTAS for managed data source tables").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t", "t1"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.versionSpark().range(1L).write().saveAsTable("t");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer($this.versionSpark().table("t").collect());
            Row[] $org_scalatest_assert_macro_right = (Row[])((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0)}))});
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 964));
            $this.versionSpark().sql("create table t1 using parquet as select 2 as a");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer($this.versionSpark().table("t1").collect());
            Row[] $org_scalatest_assert_macro_right2 = (Row[])((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2)}))});
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 966));
        }), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 961));
        $this.test(new StringBuilder(36).append(version).append(": Decimal support of Avro Hive serde").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String tableName = "tab1";
            String avroSchema = new StringOps(Predef$.MODULE$.augmentString("{\n          |  \"name\": \"test_record\",\n          |  \"type\": \"record\",\n          |  \"fields\": [ {\n          |    \"name\": \"f0\",\n          |    \"type\": [\n          |      \"null\",\n          |      {\n          |        \"precision\": 38,\n          |        \"scale\": 2,\n          |        \"type\": \"bytes\",\n          |        \"logicalType\": \"decimal\"\n          |      }\n          |    ]\n          |  } ]\n          |}\n        ")).stripMargin();
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, false}))).foreach((Function1 & Serializable & scala.Serializable)isPartitioned -> {
                $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tableName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    String insertStmt;
                    block8: {
                        String e;
                        String errorMsg;
                        block7: {
                            block4: {
                                String insertStmt2;
                                block6: {
                                    String e2;
                                    block5: {
                                        String partitionClause = isPartitioned ? "PARTITIONED BY (ds STRING)" : "";
                                        $this.versionSpark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(408).append("\n               |CREATE TABLE ").append(tableName$2).append("\n               |").append(partitionClause).append("\n               |ROW FORMAT SERDE 'org.apache.hadoop.hive.serde2.avro.AvroSerDe'\n               |STORED AS\n               |  INPUTFORMAT 'org.apache.hadoop.hive.ql.io.avro.AvroContainerInputFormat'\n               |  OUTPUTFORMAT 'org.apache.hadoop.hive.ql.io.avro.AvroContainerOutputFormat'\n               |TBLPROPERTIES ('avro.schema.literal' = '").append(avroSchema$2).append("')\n           ").toString())).stripMargin());
                                        errorMsg = "Cannot safely cast 'f0': decimal(2,1) to binary";
                                        if (!isPartitioned) break block4;
                                        insertStmt2 = new StringBuilder(53).append("INSERT OVERWRITE TABLE ").append(tableName$2).append(" partition (ds='a') SELECT 1.3").toString();
                                        String string = version$1;
                                        String string2 = "0.12";
                                        if (!(string == null ? string2 != null : !string.equals(string2))) break block5;
                                        String string3 = version$1;
                                        String string4 = "0.13";
                                        if (string3 != null ? !string3.equals(string4) : string4 != null) break block6;
                                    }
                                    String $org_scalatest_assert_macro_left = e2 = ((AnalysisException)$this.intercept((Function0 & Serializable & scala.Serializable)() -> $this.versionSpark().sql(insertStmt2), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1014))).getMessage();
                                    String $org_scalatest_assert_macro_right = errorMsg;
                                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1015));
                                    return;
                                }
                                $this.versionSpark().sql(insertStmt2);
                                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer($this.versionSpark().table(tableName$2).collect());
                                Row[] $org_scalatest_assert_macro_right = (Row[])$this.versionSpark().sql("SELECT 1.30, 'a'").collect();
                                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1018));
                                return;
                            }
                            insertStmt = new StringBuilder(34).append("INSERT OVERWRITE TABLE ").append(tableName$2).append(" SELECT 1.3").toString();
                            String string = version$1;
                            String string5 = "0.12";
                            if (!(string == null ? string5 != null : !string.equals(string5))) break block7;
                            String string6 = version$1;
                            String string7 = "0.13";
                            if (string6 != null ? !string6.equals(string7) : string7 != null) break block8;
                        }
                        String $org_scalatest_assert_macro_left = e = ((AnalysisException)$this.intercept((Function0 & Serializable & scala.Serializable)() -> $this.versionSpark().sql(insertStmt), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1024))).getMessage();
                        String $org_scalatest_assert_macro_right = errorMsg;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1025));
                        return;
                    }
                    $this.versionSpark().sql(insertStmt);
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer($this.versionSpark().table(tableName$2).collect());
                    Row[] $org_scalatest_assert_macro_right = (Row[])$this.versionSpark().sql("SELECT 1.30").collect();
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1028));
                });
                return BoxedUnit.UNIT;
            });
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 970));
        $this.test(new StringBuilder(35).append(version).append(": read avro file containing decimal").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            URL url = Thread.currentThread().getContextClassLoader().getResource("avroDecimal");
            String location = new File(url.getFile()).toURI().toString();
            String tableName = "tab1";
            String avroSchema = new StringOps(Predef$.MODULE$.augmentString("{\n          |  \"name\": \"test_record\",\n          |  \"type\": \"record\",\n          |  \"fields\": [ {\n          |    \"name\": \"f0\",\n          |    \"type\": [\n          |      \"null\",\n          |      {\n          |        \"precision\": 38,\n          |        \"scale\": 2,\n          |        \"type\": \"bytes\",\n          |        \"logicalType\": \"decimal\"\n          |      }\n          |    ]\n          |  } ]\n          |}\n        ")).stripMargin();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tableName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.versionSpark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(472).append("\n             |CREATE TABLE ").append(tableName).append("\n             |ROW FORMAT SERDE 'org.apache.hadoop.hive.serde2.avro.AvroSerDe'\n             |WITH SERDEPROPERTIES ('respectSparkSchema' = 'true')\n             |STORED AS\n             |  INPUTFORMAT 'org.apache.hadoop.hive.ql.io.avro.AvroContainerInputFormat'\n             |  OUTPUTFORMAT 'org.apache.hadoop.hive.ql.io.avro.AvroContainerOutputFormat'\n             |LOCATION '").append(location).append("'\n             |TBLPROPERTIES ('avro.schema.literal' = '").append(avroSchema).append("')\n           ").toString())).stripMargin());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer($this.versionSpark().table(tableName).collect());
                Row[] $org_scalatest_assert_macro_right = (Row[])$this.versionSpark().sql("SELECT 1.30").collect();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1072));
            });
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1036));
        $this.test(new StringBuilder(47).append(version).append(": SPARK-17920: Insert into/overwrite avro table").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Bool bool;
            Bool $org_scalatest_assert_macro_left = Bool$.MODULE$.simpleMacroBool(Utils$.MODULE$.isWindows(), "org.apache.spark.util.Utils.isWindows", Prettifier$.MODULE$.default());
            if ($org_scalatest_assert_macro_left.value()) {
                String $org_scalatest_assert_macro_left2 = version;
                String $org_scalatest_assert_macro_right = "0.12";
                String string = $org_scalatest_assert_macro_left2;
                String string2 = $org_scalatest_assert_macro_right;
                bool = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            } else {
                bool = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
            }
            Bool $org_scalatest_assert_macro_right = bool;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "&&", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$amp$amp((Function0 & Serializable & scala.Serializable)() -> $org_scalatest_assert_macro_right), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssume($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1079));
            $this.withTempDir((Function1 & Serializable & scala.Serializable)dir -> {
                VersionsSuite.$anonfun$new$128($this, dir);
                return BoxedUnit.UNIT;
            });
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1077));
    }

    public VersionsSuite() {
        this.enableAutoThreadAudit = false;
        this.test("success sanity check", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            HiveClient badClient = HiveClientBuilder$.MODULE$.buildClient(HiveUtils$.MODULE$.builtinHiveVersion(), new Configuration(), HiveClientBuilder$.MODULE$.buildClient$default$3());
            CatalogDatabase db = new CatalogDatabase("default", "desc", new URI("loc"), (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
            badClient.createDatabase(db, true);
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
        this.test("hadoop configuration preserved", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Configuration hadoopConf = new Configuration();
            hadoopConf.set("test", "success");
            HiveClient client = HiveClientBuilder$.MODULE$.buildClient(HiveUtils$.MODULE$.builtinHiveVersion(), hadoopConf, HiveClientBuilder$.MODULE$.buildClient$default$3());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer("success");
            String $org_scalatest_assert_macro_right = client.getConf("test", null);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
        this.test("override useless and side-effect hive configurations ", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Configuration hadoopConf = new Configuration();
            hadoopConf.setBoolean("hive.cbo.enable", true);
            hadoopConf.setBoolean("hive.session.history.enabled", true);
            hadoopConf.set("hive.execution.engine", "tez");
            HiveClient client = HiveClientBuilder$.MODULE$.buildClient(HiveUtils$.MODULE$.builtinHiveVersion(), hadoopConf, HiveClientBuilder$.MODULE$.buildClient$default$3());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(new StringOps(Predef$.MODULE$.augmentString(client.getConf("hive.cbo.enable", "true"))).toBoolean(), "scala.Predef.augmentString(client.getConf(\"hive.cbo.enable\", \"true\")).toBoolean", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(new StringOps(Predef$.MODULE$.augmentString(client.getConf("hive.session.history.enabled", "true"))).toBoolean(), "scala.Predef.augmentString(client.getConf(\"hive.session.history.enabled\", \"true\")).toBoolean", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(client.getConf("hive.execution.engine", "tez"));
            String $org_scalatest_assert_macro_right = "mr";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
        this.emptyDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()).getCanonicalPath();
        this.ignore("failure sanity check", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Throwable e = (Throwable)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                HiveClient hiveClient = (HiveClient)package$.MODULE$.quietly((Function0 & Serializable & scala.Serializable)() -> HiveClientBuilder$.MODULE$.buildClient("13", new Configuration(), HiveClientBuilder$.MODULE$.buildClient$default$3()));
            }, ClassTag$.MODULE$.apply(Throwable.class), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
            String $org_scalatest_assert_macro_left = this.getNestedMessages(e);
            String $org_scalatest_assert_macro_right = "Unknown column 'A0.OWNER_NAME' in 'field list'";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114));
        this.versions = SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_9) ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2.0", "2.1", "2.2", "2.3", "3.0", "3.1"})) : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0.12", "0.13", "0.14", "1.0", "1.1", "1.2", "2.0", "2.1", "2.2", "2.3", "3.0", "3.1"}));
        this.client = null;
        this.versionSpark = null;
        this.versions().foreach((Function1 & Serializable & scala.Serializable)version -> {
            VersionsSuite.$anonfun$new$7(this, version);
            return BoxedUnit.UNIT;
        });
    }
}

