/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.client;

import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition$;
import org.apache.spark.sql.catalyst.dsl.package;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.In;
import org.apache.spark.sql.catalyst.expressions.InSet;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Predicate;
import org.apache.spark.sql.catalyst.expressions.package$;
import org.apache.spark.sql.hive.client.HiveClient;
import org.apache.spark.sql.hive.client.HiveVersionSuite;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015b\u0001\u0002\b\u0010\u0001qA\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001\u000b\u0005\u0006k\u0001!\tA\u000e\u0005\bs\u0001\u0011\r\u0011\"\u0003;\u0011\u0019\u0011\u0005\u0001)A\u0005w!91\t\u0001b\u0001\n\u0013!\u0005BB%\u0001A\u0003%Q\tC\u0003K\u0001\u0011%1\nC\u0003U\u0001\u0011%Q\u000bC\u0003a\u0001\u0011\u0005\u0013\rC\u0003f\u0001\u0011%a\rC\u0003f\u0001\u0011%A\u0010\u0003\u0004f\u0001\u0011%\u0011Q\u0002\u0005\u0007K\u0002!I!!\b\u0003\u001f!Kg/Z\"mS\u0016tGoU;ji\u0016T!\u0001E\t\u0002\r\rd\u0017.\u001a8u\u0015\t\u00112#\u0001\u0003iSZ,'B\u0001\u000b\u0016\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003-]\tQa\u001d9be.T!\u0001G\r\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Q\u0012aA8sO\u000e\u00011c\u0001\u0001\u001eCA\u0011adH\u0007\u0002\u001f%\u0011\u0001e\u0004\u0002\u0011\u0011&4XMV3sg&|gnU;ji\u0016\u0004\"AI\u0013\u000e\u0003\rR!\u0001J\r\u0002\u0013M\u001c\u0017\r\\1uKN$\u0018B\u0001\u0014$\u0005E\u0011UMZ8sK\u0006sG-\u00114uKJ\fE\u000e\\\u0001\bm\u0016\u00148/[8o!\tI#G\u0004\u0002+aA\u00111FL\u0007\u0002Y)\u0011QfG\u0001\u0007yI|w\u000e\u001e \u000b\u0003=\nQa]2bY\u0006L!!\r\u0018\u0002\rA\u0013X\rZ3g\u0013\t\u0019DG\u0001\u0004TiJLgn\u001a\u0006\u0003c9\na\u0001P5oSRtDCA\u001c9!\tq\u0002\u0001C\u0003(\u0005\u0001\u0007\u0001&A\buef$\u0015N]3diN\u000bHnS3z+\u0005Y\u0004C\u0001\u001fB\u001b\u0005i$B\u0001 @\u0003\u0011a\u0017M\\4\u000b\u0003\u0001\u000bAA[1wC&\u00111'P\u0001\u0011iJLH)\u001b:fGR\u001c\u0016\u000f\\&fs\u0002\n!\u0003^3tiB\u000b'\u000f^5uS>t7i\\;oiV\tQ\t\u0005\u0002G\u000f6\ta&\u0003\u0002I]\t\u0019\u0011J\u001c;\u0002'Q,7\u000f\u001e)beRLG/[8o\u0007>,h\u000e\u001e\u0011\u0002\t%t\u0017\u000e\u001e\u000b\u0003\u0019>\u0003\"AH'\n\u00059{!A\u0003%jm\u0016\u001cE.[3oi\")\u0001k\u0002a\u0001#\u0006aAO]=ESJ,7\r^*rYB\u0011aIU\u0005\u0003':\u0012qAQ8pY\u0016\fg.\u0001\u0003biR\u0014HC\u0001,_!\t9F,D\u0001Y\u0015\tI&,A\u0006fqB\u0014Xm]:j_:\u001c(BA.\u0014\u0003!\u0019\u0017\r^1msN$\u0018BA/Y\u0005%\tE\u000f\u001e:jEV$X\rC\u0003`\u0011\u0001\u0007\u0001&\u0001\u0003oC6,\u0017!\u00032fM>\u0014X-\u00117m)\u0005\u0011\u0007C\u0001$d\u0013\t!gF\u0001\u0003V]&$\u0018a\b;fgRlU\r^1ti>\u0014X\rU1si&$\u0018n\u001c8GS2$XM]5oOR)!m\u001a7xs\")\u0001N\u0003a\u0001S\u0006Qa-\u001b7uKJ,\u0005\u0010\u001d:\u0011\u0005]S\u0017BA6Y\u0005))\u0005\u0010\u001d:fgNLwN\u001c\u0005\u0006[*\u0001\rA\\\u0001\u000bKb\u0004Xm\u0019;fI\u0012\u001b\bcA8u\u000b:\u0011\u0001O\u001d\b\u0003WEL\u0011aL\u0005\u0003g:\nq\u0001]1dW\u0006<W-\u0003\u0002vm\n\u00191+Z9\u000b\u0005Mt\u0003\"\u0002=\u000b\u0001\u0004q\u0017!C3ya\u0016\u001cG/\u001a3I\u0011\u0015Q(\u00021\u0001|\u00039)\u0007\u0010]3di\u0016$7\t[;oWN\u00042a\u001c;))!\u0011WP`@\u0002\u0002\u0005\r\u0001\"\u00025\f\u0001\u0004I\u0007\"B7\f\u0001\u0004q\u0007\"\u0002=\f\u0001\u0004q\u0007\"\u0002>\f\u0001\u0004Y\bbBA\u0003\u0017\u0001\u0007\u0011qA\u0001\niJ\fgn\u001d4pe6\u0004RARA\u0005S&L1!a\u0003/\u0005%1UO\\2uS>t\u0017\u0007F\u0003c\u0003\u001f\t\t\u0002C\u0003i\u0019\u0001\u0007\u0011\u000eC\u0004\u0002\u00141\u0001\r!!\u0006\u0002-\u0015D\b/Z2uK\u0012\u0004\u0016M\u001d;ji&|gnQ;cKN\u0004Ba\u001c;\u0002\u0018A1a)!\u0007o]nL1!a\u0007/\u0005\u0019!V\u000f\u001d7fgQ9!-a\b\u0002\"\u0005\r\u0002\"\u00025\u000e\u0001\u0004I\u0007bBA\n\u001b\u0001\u0007\u0011Q\u0003\u0005\b\u0003\u000bi\u0001\u0019AA\u0004\u0001")
public class HiveClientSuite
extends HiveVersionSuite {
    private final String tryDirectSqlKey;
    private final int testPartitionCount;

    private String tryDirectSqlKey() {
        return this.tryDirectSqlKey;
    }

    private int testPartitionCount() {
        return this.testPartitionCount;
    }

    private HiveClient init(boolean tryDirectSql) {
        IndexedSeq partitions;
        CatalogStorageFormat storageFormat = new CatalogStorageFormat((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, false, Predef$.MODULE$.Map().empty());
        Configuration hadoopConf = new Configuration();
        hadoopConf.setBoolean(this.tryDirectSqlKey(), tryDirectSql);
        hadoopConf.set("hive.metastore.warehouse.dir", Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()).toURI().toString());
        HiveClient client = this.buildClient(hadoopConf, this.buildClient$default$2());
        client.runSqlHive("CREATE TABLE test (value INT) PARTITIONED BY (ds INT, h INT, chunk STRING)");
        IndexedSeq $org_scalatest_assert_macro_left = partitions = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(20170101), 20170103).flatMap((Function1 & Serializable & scala.Serializable)ds -> HiveClientSuite.$anonfun$init$1(storageFormat, BoxesRunTime.unboxToInt((Object)ds)), IndexedSeq$.MODULE$.canBuildFrom());
        int $org_scalatest_assert_macro_right = this.testPartitionCount();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
        client.createPartitions("default", "test", (Seq)partitions, false);
        return client;
    }

    private Attribute attr(String name) {
        Option option = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.client().getTable("default", "test").partitionSchema().fields())).find((Function1 & Serializable & scala.Serializable)field -> BoxesRunTime.boxToBoolean((boolean)HiveClientSuite.$anonfun$attr$1(name, field)));
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw this.fail(new StringBuilder(37).append("Illegal name of partition attribute: ").append(name).toString(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
            }
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        StructField field2 = (StructField)some.value();
        String x$1 = field2.name();
        DataType x$2 = field2.dataType();
        boolean x$3 = AttributeReference$.MODULE$.apply$default$3();
        Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$5 = AttributeReference$.MODULE$.apply$default$5(x$1, x$2, x$3, x$4);
        Seq x$6 = AttributeReference$.MODULE$.apply$default$6(x$1, x$2, x$3, x$4);
        AttributeReference attributeReference = new AttributeReference(x$1, x$2, x$3, x$4, x$5, x$6);
        return attributeReference;
    }

    public void beforeAll() {
        super.beforeAll();
        this.client_$eq(this.init(true));
    }

    private void testMetastorePartitionFiltering(Expression filterExpr, Seq<Object> expectedDs, Seq<Object> expectedH, Seq<String> expectedChunks) {
        Tuple3 tuple3 = new Tuple3(expectedDs, expectedH, expectedChunks);
        this.testMetastorePartitionFiltering(filterExpr, (Seq<Tuple3<Seq<Object>, Seq<Object>, Seq<String>>>)Nil$.MODULE$.$colon$colon((Object)tuple3), (Function1<Expression, Expression>)(Function1 & Serializable & scala.Serializable)x -> (Expression)Predef$.MODULE$.identity(x));
    }

    private void testMetastorePartitionFiltering(Expression filterExpr, Seq<Object> expectedDs, Seq<Object> expectedH, Seq<String> expectedChunks, Function1<Expression, Expression> transform) {
        Tuple3 tuple3 = new Tuple3(expectedDs, expectedH, expectedChunks);
        this.testMetastorePartitionFiltering(filterExpr, (Seq<Tuple3<Seq<Object>, Seq<Object>, Seq<String>>>)Nil$.MODULE$.$colon$colon((Object)tuple3), transform);
    }

    private void testMetastorePartitionFiltering(Expression filterExpr, Seq<Tuple3<Seq<Object>, Seq<Object>, Seq<String>>> expectedPartitionCubes) {
        this.testMetastorePartitionFiltering(filterExpr, expectedPartitionCubes, (Function1<Expression, Expression>)(Function1 & Serializable & scala.Serializable)x -> (Expression)Predef$.MODULE$.identity(x));
    }

    private void testMetastorePartitionFiltering(Expression filterExpr, Seq<Tuple3<Seq<Object>, Seq<Object>, Seq<String>>> expectedPartitionCubes, Function1<Expression, Expression> transform) {
        int actualFilteredPartitionCount;
        Seq filteredPartitions = this.client().getPartitionsByFilter(this.client().getTable("default", "test"), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)transform.apply((Object)filterExpr)})));
        int expectedPartitionCount = BoxesRunTime.unboxToInt((Object)((TraversableOnce)expectedPartitionCubes.map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)HiveClientSuite.$anonfun$testMetastorePartitionFiltering$3(x0$1)), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Seq expectedPartitions = (Seq)((TraversableOnce)expectedPartitionCubes.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple3 tuple3 = x0$2;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            Seq expectedDs = (Seq)tuple3._1();
            Seq expectedH = (Seq)tuple3._2();
            Seq expectedChunks = (Seq)tuple3._3();
            Seq seq = (Seq)expectedDs.flatMap((Function1 & Serializable & scala.Serializable)ds -> HiveClientSuite.$anonfun$testMetastorePartitionFiltering$5(expectedH, expectedChunks, BoxesRunTime.unboxToInt((Object)ds)), Seq$.MODULE$.canBuildFrom());
            return seq;
        }, Seq$.MODULE$.canBuildFrom())).reduce((Function2 & Serializable & scala.Serializable)(x$70, x$71) -> (Seq)x$70.$plus$plus((GenTraversableOnce)x$71, Seq$.MODULE$.canBuildFrom()));
        int $org_scalatest_assert_macro_left = actualFilteredPartitionCount = filteredPartitions.size();
        int $org_scalatest_assert_macro_right = expectedPartitionCount;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(29).append("Expected ").append(expectedPartitionCount).append(" partitions but got ").append(actualFilteredPartitionCount).toString(), Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 326));
        Set $org_scalatest_assert_macro_left2 = ((TraversableOnce)filteredPartitions.map((Function1 & Serializable & scala.Serializable)x$72 -> x$72.spec().toSet(), Seq$.MODULE$.canBuildFrom())).toSet();
        Set $org_scalatest_assert_macro_right2 = expectedPartitions.toSet();
        Set set = $org_scalatest_assert_macro_left2;
        Set set2 = $org_scalatest_assert_macro_right2;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 328));
    }

    public static final /* synthetic */ Seq $anonfun$init$2(int ds$1, CatalogStorageFormat storageFormat$1, int h) {
        return (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"aa", "ab", "ba", "bb"}))).map((Function1 & Serializable & scala.Serializable)chunk -> new CatalogTablePartition((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ds"), (Object)((Object)BoxesRunTime.boxToInteger((int)ds$1)).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"h"), (Object)((Object)BoxesRunTime.boxToInteger((int)h)).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"chunk"), chunk)})), storageFormat$1, CatalogTablePartition$.MODULE$.apply$default$3(), CatalogTablePartition$.MODULE$.apply$default$4(), CatalogTablePartition$.MODULE$.apply$default$5(), CatalogTablePartition$.MODULE$.apply$default$6()), Seq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ IndexedSeq $anonfun$init$1(CatalogStorageFormat storageFormat$1, int ds) {
        return (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 23).flatMap((Function1 & Serializable & scala.Serializable)h -> HiveClientSuite.$anonfun$init$2(ds, storageFormat$1, BoxesRunTime.unboxToInt((Object)h)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ boolean $anonfun$attr$1(String name$1, StructField field) {
        return field.name().equals(name$1);
    }

    public static final /* synthetic */ int $anonfun$testMetastorePartitionFiltering$3(Tuple3 x0$1) {
        Tuple3 tuple3 = x0$1;
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        Seq expectedDs = (Seq)tuple3._1();
        Seq expectedH = (Seq)tuple3._2();
        Seq expectedChunks = (Seq)tuple3._3();
        int n = expectedDs.size() * expectedH.size() * expectedChunks.size();
        return n;
    }

    public static final /* synthetic */ Seq $anonfun$testMetastorePartitionFiltering$6(Seq expectedChunks$1, int ds$2, int h) {
        return (Seq)expectedChunks$1.map((Function1 & Serializable & scala.Serializable)chunk -> (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ds"), (Object)((Object)BoxesRunTime.boxToInteger((int)ds$2)).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"h"), (Object)((Object)BoxesRunTime.boxToInteger((int)h)).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"chunk"), chunk)})), Seq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ Seq $anonfun$testMetastorePartitionFiltering$5(Seq expectedH$1, Seq expectedChunks$1, int ds) {
        return (Seq)expectedH$1.flatMap((Function1 & Serializable & scala.Serializable)h -> HiveClientSuite.$anonfun$testMetastorePartitionFiltering$6(expectedChunks$1, ds, BoxesRunTime.unboxToInt((Object)h)), Seq$.MODULE$.canBuildFrom());
    }

    public HiveClientSuite(String version) {
        super(version);
        this.tryDirectSqlKey = HiveConf.ConfVars.METASTORE_TRY_DIRECT_SQL.varname;
        this.testPartitionCount = 288;
        this.test(new StringBuilder(56).append("getPartitionsByFilter returns all partitions when ").append(this.tryDirectSqlKey()).append("=false").toString(), (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            Seq filteredPartitions;
            HiveClient client = this.init(false);
            Seq $org_scalatest_assert_macro_left = filteredPartitions = client.getPartitionsByFilter(client.getTable("default", "test"), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Predicate[]{package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(20170101))})));
            int $org_scalatest_assert_macro_right = this.testPartitionCount();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
        this.test("getPartitionsByFilter: ds<=>20170101", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String string = "aa";
            String string2 = "ab";
            String string3 = "ba";
            String string4 = "bb";
            this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$less$eq$greater((Expression)package.expressions$.MODULE$.intToLiteral(20170101)), (Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(20170101), 20170103), (Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 23), (Seq<String>)Nil$.MODULE$.$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92));
        this.test("getPartitionsByFilter: ds=20170101", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String string = "aa";
            String string2 = "ab";
            String string3 = "ba";
            String string4 = "bb";
            this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(20170101)), (Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(20170101), 20170101), (Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 23), (Seq<String>)Nil$.MODULE$.$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101));
        this.test("getPartitionsByFilter: ds=(20170101 + 1) and h=0", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String string = "aa";
            String string2 = "ab";
            String string3 = "ba";
            String string4 = "bb";
            this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$eq$eq$eq(package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)20170101))).$plus((Expression)package.expressions$.MODULE$.intToLiteral(1)))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("h")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(0))), (Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(20170101), 20170103), (Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 0), (Seq<String>)Nil$.MODULE$.$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
        this.test("getPartitionsByFilter: chunk='aa'", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String string = "aa";
            this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("chunk")).$eq$eq$eq((Expression)package.expressions$.MODULE$.stringToLiteral("aa")), (Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(20170101), 20170103), (Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 23), (Seq<String>)Nil$.MODULE$.$colon$colon((Object)string));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 119));
        this.test("getPartitionsByFilter: cast(chunk as int)=1 (not a valid partition predicate)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String string = "aa";
            String string2 = "ab";
            String string3 = "ba";
            String string4 = "bb";
            this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression((Expression)this.attr("chunk")).cast((DataType)IntegerType$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1)), (Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(20170101), 20170103), (Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 23), (Seq<String>)Nil$.MODULE$.$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
        this.test("getPartitionsByFilter: cast(chunk as boolean)=true (not a valid partition predicate)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String string = "aa";
            String string2 = "ab";
            String string3 = "ba";
            String string4 = "bb";
            this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression((Expression)this.attr("chunk")).cast((DataType)BooleanType$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.booleanToLiteral(true)), (Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(20170101), 20170103), (Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 23), (Seq<String>)Nil$.MODULE$.$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135));
        this.test("getPartitionsByFilter: 20170101=ds", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String string = "aa";
            String string2 = "ab";
            String string3 = "ba";
            String string4 = "bb";
            this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)20170101))).$eq$eq$eq((Expression)this.attr("ds")), (Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(20170101), 20170101), (Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 23), (Seq<String>)Nil$.MODULE$.$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143));
        this.test("getPartitionsByFilter: ds=20170101 and h=10", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String string = "aa";
            String string2 = "ab";
            String string3 = "ba";
            String string4 = "bb";
            this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(20170101))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("h")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(10))), (Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(20170101), 20170101), (Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(10), 10), (Seq<String>)Nil$.MODULE$.$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 151));
        this.test("getPartitionsByFilter: cast(ds as long)=20170101L and h=10", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String string = "aa";
            String string2 = "ab";
            String string3 = "ba";
            String string4 = "bb";
            this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).cast((DataType)LongType$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.longToLiteral(20170101L))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("h")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(10))), (Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(20170101), 20170101), (Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(10), 10), (Seq<String>)Nil$.MODULE$.$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 159));
        this.test("getPartitionsByFilter: ds=20170101 or ds=20170102", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String string = "aa";
            String string2 = "ab";
            String string3 = "ba";
            String string4 = "bb";
            this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(20170101))).$bar$bar((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(20170102))), (Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(20170101), 20170102), (Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 23), (Seq<String>)Nil$.MODULE$.$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 167));
        this.test("getPartitionsByFilter: ds in (20170102, 20170103) (using IN expression)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String string = "aa";
            String string2 = "ab";
            String string3 = "ba";
            String string4 = "bb";
            this.testMetastorePartitionFiltering(package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).in((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.intToLiteral(20170102), package.expressions$.MODULE$.intToLiteral(20170103)})), (Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(20170102), 20170103), (Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 23), (Seq<String>)Nil$.MODULE$.$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 175));
        this.test("getPartitionsByFilter: cast(ds as long) in (20170102L, 20170103L) (using IN expression)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String string = "aa";
            String string2 = "ab";
            String string3 = "ba";
            String string4 = "bb";
            this.testMetastorePartitionFiltering(package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).cast((DataType)LongType$.MODULE$)).in((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.longToLiteral(20170102L), package.expressions$.MODULE$.longToLiteral(20170103L)})), (Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(20170102), 20170103), (Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 23), (Seq<String>)Nil$.MODULE$.$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 183));
        this.test("getPartitionsByFilter: ds in (20170102, 20170103) (using INSET expression)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String string = "aa";
            String string2 = "ab";
            String string3 = "ba";
            String string4 = "bb";
            this.testMetastorePartitionFiltering(package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).in((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.intToLiteral(20170102), package.expressions$.MODULE$.intToLiteral(20170103)})), (Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(20170102), 20170103), (Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 23), (Seq<String>)Nil$.MODULE$.$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), (Function1<Expression, Expression>)(Function1 & Serializable & scala.Serializable)x0$1 -> {
                Seq list;
                Expression v;
                block3: {
                    Expression expression;
                    block2: {
                        expression = x0$1;
                        if (!(expression instanceof In)) break block2;
                        In in = (In)expression;
                        v = in.value();
                        list = in.list();
                        if (in.inSetConvertible()) break block3;
                    }
                    throw new MatchError((Object)expression);
                }
                InSet inSet = new InSet(v, ((TraversableOnce)list.map((Function1 & Serializable & scala.Serializable)x$50 -> x$50.eval(package$.MODULE$.EmptyRow()), Seq$.MODULE$.canBuildFrom())).toSet());
                return inSet;
            });
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 191));
        this.test("getPartitionsByFilter: cast(ds as long) in (20170102L, 20170103L) (using INSET expression)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String string = "aa";
            String string2 = "ab";
            String string3 = "ba";
            String string4 = "bb";
            this.testMetastorePartitionFiltering(package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).cast((DataType)LongType$.MODULE$)).in((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.longToLiteral(20170102L), package.expressions$.MODULE$.longToLiteral(20170103L)})), (Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(20170102), 20170103), (Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 23), (Seq<String>)Nil$.MODULE$.$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), (Function1<Expression, Expression>)(Function1 & Serializable & scala.Serializable)x0$2 -> {
                Seq list;
                Expression v;
                block3: {
                    Expression expression;
                    block2: {
                        expression = x0$2;
                        if (!(expression instanceof In)) break block2;
                        In in = (In)expression;
                        v = in.value();
                        list = in.list();
                        if (in.inSetConvertible()) break block3;
                    }
                    throw new MatchError((Object)expression);
                }
                InSet inSet = new InSet(v, ((TraversableOnce)list.map((Function1 & Serializable & scala.Serializable)x$55 -> x$55.eval(package$.MODULE$.EmptyRow()), Seq$.MODULE$.canBuildFrom())).toSet());
                return inSet;
            });
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 203));
        this.test("getPartitionsByFilter: chunk in ('ab', 'ba') (using IN expression)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String string = "ab";
            String string2 = "ba";
            this.testMetastorePartitionFiltering(package.expressions$.MODULE$.DslExpression((Expression)this.attr("chunk")).in((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.stringToLiteral("ab"), package.expressions$.MODULE$.stringToLiteral("ba")})), (Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(20170101), 20170103), (Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 23), (Seq<String>)Nil$.MODULE$.$colon$colon((Object)string2).$colon$colon((Object)string));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 214));
        this.test("getPartitionsByFilter: chunk in ('ab', 'ba') (using INSET expression)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String string = "ab";
            String string2 = "ba";
            this.testMetastorePartitionFiltering(package.expressions$.MODULE$.DslExpression((Expression)this.attr("chunk")).in((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.stringToLiteral("ab"), package.expressions$.MODULE$.stringToLiteral("ba")})), (Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(20170101), 20170103), (Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 23), (Seq<String>)Nil$.MODULE$.$colon$colon((Object)string2).$colon$colon((Object)string), (Function1<Expression, Expression>)(Function1 & Serializable & scala.Serializable)x0$3 -> {
                Seq list;
                Expression v;
                block3: {
                    Expression expression;
                    block2: {
                        expression = x0$3;
                        if (!(expression instanceof In)) break block2;
                        In in = (In)expression;
                        v = in.value();
                        list = in.list();
                        if (in.inSetConvertible()) break block3;
                    }
                    throw new MatchError((Object)expression);
                }
                InSet inSet = new InSet(v, ((TraversableOnce)list.map((Function1 & Serializable & scala.Serializable)x$60 -> x$60.eval(package$.MODULE$.EmptyRow()), Seq$.MODULE$.canBuildFrom())).toSet());
                return inSet;
            });
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 222));
        this.test("getPartitionsByFilter: (ds=20170101 and h>=8) or (ds=20170102 and h<8)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Tuple3 day1 = new Tuple3((Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(20170101), 20170101), (Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(8), 23), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"aa", "ab", "ba", "bb"})));
            Tuple3 day2 = new Tuple3((Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(20170102), 20170102), (Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 7), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"aa", "ab", "ba", "bb"})));
            Tuple3 tuple3 = day1;
            Tuple3 tuple32 = day2;
            this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(20170101))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("h")).$greater$eq((Expression)package.expressions$.MODULE$.intToLiteral(8)))).$bar$bar((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(20170102))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("h")).$less((Expression)package.expressions$.MODULE$.intToLiteral(8)))), (Seq<Tuple3<Seq<Object>, Seq<Object>, Seq<String>>>)Nil$.MODULE$.$colon$colon((Object)tuple32).$colon$colon((Object)tuple3));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 233));
        this.test("getPartitionsByFilter: (ds=20170101 and h>=8) or (ds=20170102 and h<(7+1))", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Tuple3 day1 = new Tuple3((Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(20170101), 20170101), (Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(8), 23), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"aa", "ab", "ba", "bb"})));
            Tuple3 day2 = new Tuple3((Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(20170102), 20170102), (Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 23), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"aa", "ab", "ba", "bb"})));
            Tuple3 tuple3 = day1;
            Tuple3 tuple32 = day2;
            this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(20170101))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("h")).$greater$eq((Expression)package.expressions$.MODULE$.intToLiteral(8)))).$bar$bar((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(20170102))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("h")).$less(package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)7))).$plus((Expression)package.expressions$.MODULE$.intToLiteral(1))))), (Seq<Tuple3<Seq<Object>, Seq<Object>, Seq<String>>>)Nil$.MODULE$.$colon$colon((Object)tuple32).$colon$colon((Object)tuple3));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 240));
        this.test("getPartitionsByFilter: chunk in ('ab', 'ba') and ((ds=20170101 and h>=8) or (ds=20170102 and h<8))", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Tuple3 day1 = new Tuple3((Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(20170101), 20170101), (Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(8), 23), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ab", "ba"})));
            Tuple3 day2 = new Tuple3((Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(20170102), 20170102), (Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 7), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ab", "ba"})));
            Tuple3 tuple3 = day1;
            Tuple3 tuple32 = day2;
            this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression((Expression)this.attr("chunk")).in((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.stringToLiteral("ab"), package.expressions$.MODULE$.stringToLiteral("ba")}))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(20170101))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("h")).$greater$eq((Expression)package.expressions$.MODULE$.intToLiteral(8)))).$bar$bar((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(20170102))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)this.attr("h")).$less((Expression)package.expressions$.MODULE$.intToLiteral(8))))), (Seq<Tuple3<Seq<Object>, Seq<Object>, Seq<String>>>)Nil$.MODULE$.$colon$colon((Object)tuple32).$colon$colon((Object)tuple3));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 249));
        this.test("create client with sharesHadoopClasses = false", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> this.buildClient(new Configuration(), false), new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 257));
        this.test("getPartitionsByFilter: chunk in ('ab', 'ba') and ((cast(ds as string)>'20170102')", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Tuple3 day = new Tuple3((Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(20170101), 20170103), (Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 23), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ab", "ba"})));
            Tuple3 tuple3 = day;
            this.testMetastorePartitionFiltering((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression((Expression)this.attr("chunk")).in((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.stringToLiteral("ab"), package.expressions$.MODULE$.stringToLiteral("ba")}))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression((Expression)this.attr("ds")).cast((DataType)StringType$.MODULE$)).$greater((Expression)package.expressions$.MODULE$.stringToLiteral("20170102"))), (Seq<Tuple3<Seq<Object>, Seq<Object>, Seq<String>>>)Nil$.MODULE$.$colon$colon((Object)tuple3));
        }, new Position("HiveClientSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 261));
    }
}

