/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.jetty.plus.security;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.spark_project.jetty.plus.jndi.NamingEntryUtil;
import org.spark_project.jetty.security.AbstractLoginService;
import org.spark_project.jetty.security.IdentityService;
import org.spark_project.jetty.server.Server;
import org.spark_project.jetty.util.log.Log;
import org.spark_project.jetty.util.log.Logger;
import org.spark_project.jetty.util.security.Credential;

public class DataSourceLoginService
extends AbstractLoginService {
    private static final Logger LOG = Log.getLogger(DataSourceLoginService.class);
    private String _jndiName = "javax.sql.DataSource/default";
    private DataSource _datasource;
    private Server _server;
    private String _userTableName = "users";
    private String _userTableKey = "id";
    private String _userTableUserField = "username";
    private String _userTablePasswordField = "pwd";
    private String _roleTableName = "roles";
    private String _roleTableKey = "id";
    private String _roleTableRoleField = "role";
    private String _userRoleTableName = "user_roles";
    private String _userRoleTableUserKey = "user_id";
    private String _userRoleTableRoleKey = "role_id";
    private String _userSql;
    private String _roleSql;
    private boolean _createTables = false;

    public DataSourceLoginService() {
    }

    public DataSourceLoginService(String name) {
        this.setName(name);
    }

    public DataSourceLoginService(String name, IdentityService identityService) {
        this.setName(name);
        this.setIdentityService(identityService);
    }

    public void setJndiName(String jndi) {
        this._jndiName = jndi;
    }

    public String getJndiName() {
        return this._jndiName;
    }

    public void setServer(Server server) {
        this._server = server;
    }

    public Server getServer() {
        return this._server;
    }

    public void setCreateTables(boolean createTables) {
        this._createTables = createTables;
    }

    public boolean getCreateTables() {
        return this._createTables;
    }

    public void setUserTableName(String name) {
        this._userTableName = name;
    }

    public String getUserTableName() {
        return this._userTableName;
    }

    public String getUserTableKey() {
        return this._userTableKey;
    }

    public void setUserTableKey(String tableKey) {
        this._userTableKey = tableKey;
    }

    public String getUserTableUserField() {
        return this._userTableUserField;
    }

    public void setUserTableUserField(String tableUserField) {
        this._userTableUserField = tableUserField;
    }

    public String getUserTablePasswordField() {
        return this._userTablePasswordField;
    }

    public void setUserTablePasswordField(String tablePasswordField) {
        this._userTablePasswordField = tablePasswordField;
    }

    public String getRoleTableName() {
        return this._roleTableName;
    }

    public void setRoleTableName(String tableName) {
        this._roleTableName = tableName;
    }

    public String getRoleTableKey() {
        return this._roleTableKey;
    }

    public void setRoleTableKey(String tableKey) {
        this._roleTableKey = tableKey;
    }

    public String getRoleTableRoleField() {
        return this._roleTableRoleField;
    }

    public void setRoleTableRoleField(String tableRoleField) {
        this._roleTableRoleField = tableRoleField;
    }

    public String getUserRoleTableName() {
        return this._userRoleTableName;
    }

    public void setUserRoleTableName(String roleTableName) {
        this._userRoleTableName = roleTableName;
    }

    public String getUserRoleTableUserKey() {
        return this._userRoleTableUserKey;
    }

    public void setUserRoleTableUserKey(String roleTableUserKey) {
        this._userRoleTableUserKey = roleTableUserKey;
    }

    public String getUserRoleTableRoleKey() {
        return this._userRoleTableRoleKey;
    }

    public void setUserRoleTableRoleKey(String roleTableRoleKey) {
        this._userRoleTableRoleKey = roleTableRoleKey;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public AbstractLoginService.UserPrincipal loadUserInfo(String username) {
        try (Connection connection = this.getConnection();
             PreparedStatement statement1 = connection.prepareStatement(this._userSql);){
            statement1.setObject(1, username);
            try (ResultSet rs1 = statement1.executeQuery();){
                if (!rs1.next()) return null;
                int key = rs1.getInt(this._userTableKey);
                String credentials = rs1.getString(this._userTablePasswordField);
                DBUserPrincipal dBUserPrincipal = new DBUserPrincipal(username, Credential.getCredential(credentials), key);
                return dBUserPrincipal;
            }
        }
        catch (NamingException e) {
            LOG.warn("No datasource for " + this._jndiName, e);
            return null;
        }
        catch (SQLException e) {
            LOG.warn("Problem loading user info for " + username, e);
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    @Override
    public String[] loadRoleInfo(AbstractLoginService.UserPrincipal user) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void initDb() throws NamingException, SQLException {
        if (this._datasource != null) {
            return;
        }
        InitialContext ic = new InitialContext();
        assert (ic != null);
        if (this._server != null) {
            try {
                this._datasource = (DataSource)NamingEntryUtil.lookup(this._server, this._jndiName);
            }
            catch (NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
        }
        if (this._datasource == null) {
            this._datasource = (DataSource)NamingEntryUtil.lookup(null, this._jndiName);
        }
        this._userSql = "select " + this._userTableKey + "," + this._userTablePasswordField + " from " + this._userTableName + " where " + this._userTableUserField + " = ?";
        this._roleSql = "select r." + this._roleTableRoleField + " from " + this._roleTableName + " r, " + this._userRoleTableName + " u where u." + this._userRoleTableUserKey + " = ? and r." + this._roleTableKey + " = u." + this._userRoleTableRoleKey;
        this.prepareTables();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void prepareTables() throws NamingException, SQLException {
        if (!this._createTables) {
            if (!LOG.isDebugEnabled()) return;
            LOG.debug("createTables false", new Object[0]);
            return;
        }
        boolean autocommit = true;
        Connection connection = this.getConnection();
        try (Statement stmt = connection.createStatement();){
            block55: {
                ResultSet result;
                String tableName;
                DatabaseMetaData metaData;
                block54: {
                    block53: {
                        autocommit = connection.getAutoCommit();
                        connection.setAutoCommit(false);
                        metaData = connection.getMetaData();
                        tableName = metaData.storesLowerCaseIdentifiers() ? this._userTableName.toLowerCase(Locale.ENGLISH) : (metaData.storesUpperCaseIdentifiers() ? this._userTableName.toUpperCase(Locale.ENGLISH) : this._userTableName);
                        result = metaData.getTables(null, null, tableName, null);
                        try {
                            if (result.next()) break block53;
                            stmt.executeUpdate("create table " + this._userTableName + "(" + this._userTableKey + " integer," + this._userTableUserField + " varchar(100) not null unique," + this._userTablePasswordField + " varchar(20) not null, primary key(" + this._userTableKey + "))");
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("Created table " + this._userTableName, new Object[0]);
                            }
                        }
                        finally {
                            if (result != null) {
                                result.close();
                            }
                        }
                    }
                    tableName = metaData.storesLowerCaseIdentifiers() ? this._roleTableName.toLowerCase(Locale.ENGLISH) : (metaData.storesUpperCaseIdentifiers() ? this._roleTableName.toUpperCase(Locale.ENGLISH) : this._roleTableName);
                    result = metaData.getTables(null, null, tableName, null);
                    try {
                        if (result.next()) break block54;
                        String str = "create table " + this._roleTableName + " (" + this._roleTableKey + " integer, " + this._roleTableRoleField + " varchar(100) not null unique, primary key(" + this._roleTableKey + "))";
                        stmt.executeUpdate(str);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Created table " + this._roleTableName, new Object[0]);
                        }
                    }
                    finally {
                        if (result != null) {
                            result.close();
                        }
                    }
                }
                tableName = metaData.storesLowerCaseIdentifiers() ? this._userRoleTableName.toLowerCase(Locale.ENGLISH) : (metaData.storesUpperCaseIdentifiers() ? this._userRoleTableName.toUpperCase(Locale.ENGLISH) : this._userRoleTableName);
                result = metaData.getTables(null, null, tableName, null);
                try {
                    if (result.next()) break block55;
                    stmt.executeUpdate("create table " + this._userRoleTableName + " (" + this._userRoleTableUserKey + " integer, " + this._userRoleTableRoleKey + " integer, primary key (" + this._userRoleTableUserKey + ", " + this._userRoleTableRoleKey + "))");
                    stmt.executeUpdate("create index indx_user_role on " + this._userRoleTableName + "(" + this._userRoleTableUserKey + ")");
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Created table " + this._userRoleTableName + " and index", new Object[0]);
                    }
                }
                finally {
                    if (result != null) {
                        result.close();
                    }
                }
            }
            connection.commit();
            return;
        }
        finally {
            try {
                connection.setAutoCommit(autocommit);
            }
            catch (SQLException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Prepare tables", e);
                }
            }
            finally {
                block57: {
                    try {
                        connection.close();
                    }
                    catch (SQLException e) {
                        if (!LOG.isDebugEnabled()) break block57;
                        LOG.debug("Prepare tables", e);
                    }
                }
            }
        }
    }

    private Connection getConnection() throws NamingException, SQLException {
        this.initDb();
        return this._datasource.getConnection();
    }

    public class DBUserPrincipal
    extends AbstractLoginService.UserPrincipal {
        private int _key;

        public DBUserPrincipal(String name, Credential credential, int key) {
            super(name, credential);
            this._key = key;
        }

        public int getKey() {
            return this._key;
        }
    }
}

