/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.orc;

import com.google.common.io.Files;
import java.io.File;
import java.io.Serializable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.catalog.HiveTableRelation;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.datasources.orc.OrcQueryTest;
import org.apache.spark.sql.hive.HiveUtils$;
import org.apache.spark.sql.hive.client.HiveClient;
import org.apache.spark.sql.hive.orc.HiveOrcQuerySuite$;
import org.apache.spark.sql.hive.orc.OrcFileFormat;
import org.apache.spark.sql.hive.test.TestHiveContext;
import org.apache.spark.sql.hive.test.TestHiveSingleton;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.StructType;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001Y2A\u0001B\u0003\u0001%!)!\u0005\u0001C\u0001G!9a\u0005\u0001b\u0001\n\u0003:\u0003BB\u001b\u0001A\u0003%\u0001FA\tISZ,wJ]2Rk\u0016\u0014\u0018pU;ji\u0016T!AB\u0004\u0002\u0007=\u00148M\u0003\u0002\t\u0013\u0005!\u0001.\u001b<f\u0015\tQ1\"A\u0002tc2T!\u0001D\u0007\u0002\u000bM\u0004\u0018M]6\u000b\u00059y\u0011AB1qC\u000eDWMC\u0001\u0011\u0003\ry'oZ\u0002\u0001'\r\u00011\u0003\b\t\u0003)ii\u0011!\u0006\u0006\u0003\rYQ!a\u0006\r\u0002\u0017\u0011\fG/Y:pkJ\u001cWm\u001d\u0006\u00033%\t\u0011\"\u001a=fGV$\u0018n\u001c8\n\u0005m)\"\u0001D(sGF+XM]=UKN$\bCA\u000f!\u001b\u0005q\"BA\u0010\b\u0003\u0011!Xm\u001d;\n\u0005\u0005r\"!\u0005+fgRD\u0015N^3TS:<G.\u001a;p]\u00061A(\u001b8jiz\"\u0012\u0001\n\t\u0003K\u0001i\u0011!B\u0001\u0007_J\u001c\u0017*\u001c9\u0016\u0003!\u0002\"!\u000b\u001a\u000f\u0005)\u0002\u0004CA\u0016/\u001b\u0005a#BA\u0017\u0012\u0003\u0019a$o\\8u})\tq&A\u0003tG\u0006d\u0017-\u0003\u00022]\u00051\u0001K]3eK\u001aL!a\r\u001b\u0003\rM#(/\u001b8h\u0015\t\td&A\u0004pe\u000eLU\u000e\u001d\u0011")
public class HiveOrcQuerySuite
extends OrcQueryTest
implements TestHiveSingleton {
    private final String orcImp;
    private final boolean enableAutoThreadAudit;
    private final SparkSession spark;
    private final TestHiveContext hiveContext;
    private final HiveClient hiveClient;

    @Override
    public /* synthetic */ void org$apache$spark$sql$hive$test$TestHiveSingleton$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public void afterAll() {
        TestHiveSingleton.afterAll$(this);
    }

    @Override
    public boolean enableAutoThreadAudit() {
        return this.enableAutoThreadAudit;
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public TestHiveContext hiveContext() {
        return this.hiveContext;
    }

    @Override
    public HiveClient hiveClient() {
        return this.hiveClient;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$enableAutoThreadAudit_$eq(boolean x$1) {
        this.enableAutoThreadAudit = x$1;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$hiveContext_$eq(TestHiveContext x$1) {
        this.hiveContext = x$1;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$hiveClient_$eq(HiveClient x$1) {
        this.hiveClient = x$1;
    }

    public String orcImp() {
        return this.orcImp;
    }

    public static final /* synthetic */ void $anonfun$new$2(HiveOrcQuerySuite $this, File dir) {
        String path = dir.getCanonicalPath();
        $this.withTable((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"empty_orc"}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.withTempView((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"empty", "single"}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String errorMessage;
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(117).append("CREATE TABLE empty_orc(key INT, value STRING)\n               |STORED AS ORC\n               |LOCATION '").append(dir.toURI()).append("'\n             ").toString())).stripMargin());
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(HiveOrcQuerySuite.class.getClassLoader());
            public final class Org_apache_spark_sql_hive_orc_HiveOrcQuerySuite$$typecreator5$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_hive_orc_HiveOrcQuerySuite$$typecreator5$1(HiveOrcQuerySuite $outer) {
                }
            }
            Dataset emptyDF = $this.testImplicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.empty(), $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_hive_orc_HiveOrcQuerySuite$$typecreator5$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key", "value"})).coalesce(1);
            emptyDF.createOrReplaceTempView("empty");
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("INSERT INTO TABLE empty_orc\n               |SELECT key, value FROM empty\n             ")).stripMargin());
            String $org_scalatest_assert_macro_left = errorMessage = ((AnalysisException)$this.intercept((Function0 & Serializable & scala.Serializable)() -> $this.spark().read().orc(path), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("HiveOrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59))).getMessage();
            String $org_scalatest_assert_macro_right = "Unable to infer schema for ORC";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveOrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
            JavaUniverse $u2 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(HiveOrcQuerySuite.class.getClassLoader());
            public final class Org_apache_spark_sql_hive_orc_HiveOrcQuerySuite$$typecreator13$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_hive_orc_HiveOrcQuerySuite$$typecreator13$1(HiveOrcQuerySuite $outer) {
                }
            }
            Dataset singleRowDF = $this.testImplicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)0), (Object)"foo")})), $this.testImplicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_hive_orc_HiveOrcQuerySuite$$typecreator13$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key", "value"})).coalesce(1);
            singleRowDF.createOrReplaceTempView("single");
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("INSERT INTO TABLE empty_orc\n               |SELECT key, value FROM single\n             ")).stripMargin());
            Dataset df = $this.spark().read().orc(path);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(df.schema());
            StructType $org_scalatest_assert_macro_right2 = singleRowDF.schema().asNullable();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveOrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
            $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> df, singleRowDF);
        }));
    }

    public static final /* synthetic */ void $anonfun$new$12(HiveOrcQuerySuite $this, Dataset singleRowDF$1, String orcConversion$1, File dir) {
        String path = dir.getCanonicalPath();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(150).append("\n                   |CREATE TABLE dummy_orc(key INT, value STRING)\n                   |STORED AS ORC\n                   |LOCATION '").append(dir.toURI()).append("'\n                 ").toString())).stripMargin());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                   |INSERT INTO TABLE dummy_orc\n                   |SELECT key, value FROM single\n                 ")).stripMargin());
        Dataset df = $this.spark().sql("SELECT * FROM dummy_orc WHERE key=0");
        $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> df, singleRowDF$1);
        QueryExecution queryExecution = df.queryExecution();
        String string = orcConversion$1;
        String string2 = "true";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            queryExecution.analyzed().collectFirst((PartialFunction)new scala.Serializable(null){
                public static final long serialVersionUID = 0L;

                public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    Object object = A1 instanceof LogicalRelation ? BoxedUnit.UNIT : function1.apply(x1);
                    return (B1)object;
                }

                public final boolean isDefinedAt(LogicalPlan x1) {
                    LogicalPlan logicalPlan = x1;
                    boolean bl = logicalPlan instanceof LogicalRelation;
                    return bl;
                }
            }).getOrElse((Function0 & Serializable & scala.Serializable)() -> $this.fail(new StringBuilder(66).append("Expecting the query plan to convert orc to data sources, ").append("but got:\n").append(queryExecution).toString(), new Position("HiveOrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112)));
        } else {
            queryExecution.analyzed().collectFirst((PartialFunction)new scala.Serializable(null){
                public static final long serialVersionUID = 0L;

                public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    A1 A1 = x2;
                    Object object = A1 instanceof HiveTableRelation ? BoxedUnit.UNIT : function1.apply(x2);
                    return (B1)object;
                }

                public final boolean isDefinedAt(LogicalPlan x2) {
                    LogicalPlan logicalPlan = x2;
                    boolean bl = logicalPlan instanceof HiveTableRelation;
                    return bl;
                }
            }).getOrElse((Function0 & Serializable & scala.Serializable)() -> $this.fail(new StringBuilder(59).append("Expecting no conversion from orc to data sources, ").append("but got:\n").append(queryExecution).toString(), new Position("HiveOrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 119)));
        }
    }

    public static final /* synthetic */ void $anonfun$new$19(HiveOrcQuerySuite $this, File dir) {
        Dataset df = $this.spark().range(5L).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "id as valueField", "id as partitionValue"}));
        df.write().partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partitionValue"})).mode("overwrite").orc(dir.getAbsolutePath());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(173).append("\n            |create external table dummy_orc (id long, valueField long)\n            |partitioned by (partitionValue int)\n            |stored as orc\n            |location \"").append(dir.toURI()).append("\"").toString())).stripMargin());
        $this.spark().sql("msck repair table dummy_orc");
        $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> $this.spark().sql("select * from dummy_orc"), df);
    }

    public static final /* synthetic */ void $anonfun$new$22(HiveOrcQuerySuite $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String orcImpl = (String)tuple2._1();
        Class format = (Class)tuple2._2();
        $this.withSQLConf((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_IMPLEMENTATION().key()), (Object)orcImpl)}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.withTable((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"spark_20728"}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Option fileFormat;
            $this.sql().apply((Object)"CREATE TABLE spark_20728(a INT) USING ORC");
            Option $org_scalatest_assert_macro_left = fileFormat = ((Dataset)$this.sql().apply((Object)"SELECT * FROM spark_20728")).queryExecution().analyzed().collectFirst((PartialFunction)new scala.Serializable(null){
                public static final long serialVersionUID = 0L;

                public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                    Class<?> clazz;
                    A1 A1 = x3;
                    if (A1 instanceof LogicalRelation) {
                        LogicalRelation logicalRelation = (LogicalRelation)A1;
                        clazz = ((HadoopFsRelation)logicalRelation.relation()).fileFormat().getClass();
                    } else {
                        clazz = function1.apply(x3);
                    }
                    return (B1)clazz;
                }

                public final boolean isDefinedAt(LogicalPlan x3) {
                    LogicalPlan logicalPlan = x3;
                    boolean bl = logicalPlan instanceof LogicalRelation;
                    return bl;
                }
            });
            Some $org_scalatest_assert_macro_right = new Some((Object)format);
            Option option = $org_scalatest_assert_macro_left;
            Some some = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(option != null ? !option.equals(some) : some != null), Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveOrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 164));
        }));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$28(HiveOrcQuerySuite $this, File f) {
        String path = f.getCanonicalPath();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(HiveOrcQuerySuite.class.getClassLoader());
        public final class Org_apache_spark_sql_hive_orc_HiveOrcQuerySuite$$typecreator29$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_hive_orc_HiveOrcQuerySuite$$typecreator29$1(HiveOrcQuerySuite $outer) {
            }
        }
        $this.testImplicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)2))})), $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_hive_orc_HiveOrcQuerySuite$$typecreator29$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c1", "c2"})).write().orc(path);
        $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> $this.spark().read().orc(path), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2)})));
        $this.withSQLConf((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveUtils$.MODULE$.CONVERT_METASTORE_ORC().key()), (Object)"true")}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.withTable((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.sql().apply((Object)new StringBuilder(65).append("CREATE EXTERNAL TABLE t(c2 INT, c1 INT) STORED AS ORC LOCATION '").append(path).append("'").toString());
            $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> $this.spark().table("t"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)1)})));
        }));
    }

    public HiveOrcQuerySuite() {
        TestHiveSingleton.$init$(this);
        this.orcImp = "hive";
        this.test("SPARK-8501: Avoids discovery schema from empty ORC files", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempPath((Function1 & Serializable & scala.Serializable)dir -> {
            HiveOrcQuerySuite.$anonfun$new$2(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("HiveOrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 37));
        this.test("Verify the ORC conversion parameter: CONVERT_METASTORE_ORC", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempView((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"single"}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(HiveOrcQuerySuite.class.getClassLoader());
            public final class Org_apache_spark_sql_hive_orc_HiveOrcQuerySuite$$typecreator21$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_hive_orc_HiveOrcQuerySuite$$typecreator21$1(HiveOrcQuerySuite $outer) {
                }
            }
            Dataset singleRowDF = this.testImplicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)0), (Object)"foo")})), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_hive_orc_HiveOrcQuerySuite$$typecreator21$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key", "value"}));
            singleRowDF.createOrReplaceTempView("single");
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"true", "false"}))).foreach((Function1 & Serializable & scala.Serializable)orcConversion -> {
                this.withSQLConf((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveUtils$.MODULE$.CONVERT_METASTORE_ORC().key()), (Object)orcConversion)}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dummy_orc"}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempPath((Function1 & Serializable & scala.Serializable)dir -> {
                    HiveOrcQuerySuite.$anonfun$new$12($this, singleRowDF$1, orcConversion, dir);
                    return BoxedUnit.UNIT;
                })));
                return BoxedUnit.UNIT;
            });
        }), new Position("HiveOrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
        this.test("converted ORC table supports resolving mixed case field", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveUtils$.MODULE$.CONVERT_METASTORE_ORC().key()), (Object)"true")}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dummy_orc"}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempPath((Function1 & Serializable & scala.Serializable)dir -> {
            HiveOrcQuerySuite.$anonfun$new$19(this, dir);
            return BoxedUnit.UNIT;
        }))), new Position("HiveOrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
        this.test("SPARK-20728 Make ORCFileFormat configurable between sql/hive and sql/core", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"native", org.apache.spark.sql.execution.datasources.orc.OrcFileFormat.class), new Tuple2((Object)"hive", OrcFileFormat.class)}))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            HiveOrcQuerySuite.$anonfun$new$22(this, x0$1);
            return BoxedUnit.UNIT;
        }), new Position("HiveOrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 152));
        this.test("SPARK-22267 Spark SQL incorrectly reads ORC files when column order is different", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"native", "hive"}))).foreach((Function1 & Serializable & scala.Serializable)orcImpl -> {
            this.withSQLConf((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_IMPLEMENTATION().key()), (Object)orcImpl)}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempPath((Function1 & Serializable & scala.Serializable)f -> {
                HiveOrcQuerySuite.$anonfun$new$28($this, f);
                return BoxedUnit.UNIT;
            }));
            return BoxedUnit.UNIT;
        }), new Position("HiveOrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 173));
        this.test("SPARK-19809 NullPointerException on zero-size ORC file", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"native", "hive"}))).foreach((Function1 & Serializable & scala.Serializable)orcImpl -> {
            this.withSQLConf((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_IMPLEMENTATION().key()), (Object)orcImpl)}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempPath((Function1 & Serializable & scala.Serializable)dir -> {
                $this.withTable((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"spark_19809"}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    $this.sql().apply((Object)new StringBuilder(57).append("CREATE TABLE spark_19809(a int) STORED AS ORC LOCATION '").append(dir).append("'").toString());
                    Files.touch((File)new File(String.valueOf(dir.getCanonicalPath()), "zero.orc"));
                    $this.withSQLConf((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveUtils$.MODULE$.CONVERT_METASTORE_ORC().key()), (Object)"true")}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> $this.spark().table("spark_19809"), (Seq)Seq$.MODULE$.empty()));
                });
                return BoxedUnit.UNIT;
            }));
            return BoxedUnit.UNIT;
        }), new Position("HiveOrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 195));
        this.test("SPARK-23340 Empty float/double array columns raise EOFException", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveUtils$.MODULE$.CONVERT_METASTORE_ORC().key()), (Object)"false")}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"spark_23340"}), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)"CREATE TABLE spark_23340(a array<float>, b array<double>) STORED AS ORC");
            this.sql().apply((Object)"INSERT INTO spark_23340 VALUES (array(), array())");
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.spark().table("spark_23340"), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Array$.MODULE$.empty(ClassTag$.MODULE$.Float()), Array$.MODULE$.empty(ClassTag$.MODULE$.Double())}))})));
        })), new Position("HiveOrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 212));
    }
}

