/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.SecurityManager;
import org.apache.spark.SecurityManager$;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.TestUtils$;
import org.apache.spark.sql.hive.PROCESS_TABLES$;
import org.apache.spark.sql.hive.SparkSubmitTestUtils;
import org.apache.spark.util.Utils$;
import org.scalactic.Prettifier;
import org.scalactic.source.Position;
import org.scalatest.Ignore;
import org.scalatest.Tag;
import org.scalatest.concurrent.Signaler;
import org.scalatest.concurrent.TimeLimits;
import org.scalatest.enablers.Timed;
import org.scalatest.exceptions.StackDepthException;
import org.scalatest.time.Span;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.sys.process.package$;

@Ignore
@ScalaSignature(bytes="\u0006\u0001A4A\u0001E\t\u00019!)Q\u0005\u0001C\u0001M!9\u0001\u0006\u0001b\u0001\n\u0013I\u0003B\u0002\u001a\u0001A\u0003%!\u0006C\u00044\u0001\t\u0007I\u0011B\u0015\t\rQ\u0002\u0001\u0015!\u0003+\u0011\u001d)\u0004A1A\u0005\n%BaA\u000e\u0001!\u0002\u0013Q\u0003bB\u001c\u0001\u0005\u0004%I\u0001\u000f\u0005\u0007\u007f\u0001\u0001\u000b\u0011B\u001d\t\u000b\u0001\u0003A\u0011I!\t\u000b!\u0003A\u0011B%\t\u000be\u0003A\u0011\u0002.\t\u000bu\u0003A\u0011\u00020\t\u000b\u0015\u0004A\u0011\u00024\t\u000b!\u0004A\u0011I!\u0003A!Kg/Z#yi\u0016\u0014h.\u00197DCR\fGn\\4WKJ\u001c\u0018n\u001c8t'VLG/\u001a\u0006\u0003%M\tA\u0001[5wK*\u0011A#F\u0001\u0004gFd'B\u0001\f\u0018\u0003\u0015\u0019\b/\u0019:l\u0015\tA\u0012$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00025\u0005\u0019qN]4\u0004\u0001M\u0019\u0001!H\u0011\u0011\u0005yyR\"A\u000b\n\u0005\u0001*\"!D*qCJ\\g)\u001e8Tk&$X\r\u0005\u0002#G5\t\u0011#\u0003\u0002%#\t!2\u000b]1sWN+(-\\5u)\u0016\u001cH/\u0016;jYN\fa\u0001P5oSRtD#A\u0014\u0011\u0005\t\u0002\u0011!D<be\u0016Du.^:f!\u0006$\b.F\u0001+!\tY\u0003'D\u0001-\u0015\tic&\u0001\u0002j_*\tq&\u0001\u0003kCZ\f\u0017BA\u0019-\u0005\u00111\u0015\u000e\\3\u0002\u001d]\f'/\u001a%pkN,\u0007+\u0019;iA\u0005QA/\u001c9ECR\fG)\u001b:\u0002\u0017Ql\u0007\u000fR1uC\u0012K'\u000fI\u0001\u0010gB\f'o\u001b+fgRLgn\u001a#je\u0006\u00012\u000f]1sWR+7\u000f^5oO\u0012K'\u000fI\u0001\nk:,8/\u001a3KCJ,\u0012!\u000f\t\u0003uuj\u0011a\u000f\u0006\u0003y9\n1A\\3u\u0013\tq4HA\u0002V%2\u000b!\"\u001e8vg\u0016$'*\u0019:!\u0003!\tg\r^3s\u00032dG#\u0001\"\u0011\u0005\r3U\"\u0001#\u000b\u0003\u0015\u000bQa]2bY\u0006L!a\u0012#\u0003\tUs\u0017\u000e^\u0001\u0011iJLHi\\<oY>\fGm\u00159be.$2A\u0011&X\u0011\u0015Y5\u00021\u0001M\u0003\u001d1XM]:j_:\u0004\"!\u0014+\u000f\u00059\u0013\u0006CA(E\u001b\u0005\u0001&BA)\u001c\u0003\u0019a$o\\8u}%\u00111\u000bR\u0001\u0007!J,G-\u001a4\n\u0005U3&AB*ue&twM\u0003\u0002T\t\")\u0001l\u0003a\u0001\u0019\u0006!\u0001/\u0019;i\u0003)9WM\u001c#bi\u0006$\u0015N\u001d\u000b\u0003\u0019nCQ\u0001\u0018\u0007A\u00021\u000bAA\\1nK\u0006qq-\u001a;GS2,gI]8n+JdG\u0003\u0002\"`C\u000eDQ\u0001Y\u0007A\u00021\u000b\u0011\"\u001e:m'R\u0014\u0018N\\4\t\u000b\tl\u0001\u0019\u0001'\u0002\u0013Q\f'oZ3u\t&\u0014\b\"\u00023\u000e\u0001\u0004a\u0015\u0001\u00034jY\u0016t\u0017-\\3\u0002!\u001d,Go\u0015;sS:<gI]8n+JdGC\u0001'h\u0011\u0015\u0001g\u00021\u0001M\u0003%\u0011WMZ8sK\u0006cG\u000e\u000b\u0002\u0001UB\u00111N\\\u0007\u0002Y*\u0011Q.G\u0001\ng\u000e\fG.\u0019;fgRL!a\u001c7\u0003\r%;gn\u001c:f\u0001")
public class HiveExternalCatalogVersionsSuite
extends SparkFunSuite
implements SparkSubmitTestUtils {
    private final File wareHousePath;
    private final File tmpDataDir;
    private final File sparkTestingDir;
    private final URL unusedJar;
    private final Signaler defaultSignaler;

    @Override
    public void runSparkSubmit(Seq<String> args, Option<String> sparkHomeOpt, boolean isSparkTesting) {
        SparkSubmitTestUtils.runSparkSubmit$(this, args, sparkHomeOpt, isSparkTesting);
    }

    @Override
    public Option<String> runSparkSubmit$default$2() {
        return SparkSubmitTestUtils.runSparkSubmit$default$2$(this);
    }

    @Override
    public boolean runSparkSubmit$default$3() {
        return SparkSubmitTestUtils.runSparkSubmit$default$3$(this);
    }

    public <T> T failAfter(Span timeout, Function0<T> fun, Signaler signaler, Prettifier prettifier, Position pos, Timed<T> timed) {
        return (T)TimeLimits.failAfter$((TimeLimits)this, (Span)timeout, fun, (Signaler)signaler, (Prettifier)prettifier, (Position)pos, timed);
    }

    public <T> T failAfterImpl(Span timeout, Signaler signaler, Prettifier prettifier, Option<Position> pos, Function1<StackDepthException, Object> stackDepthFun, Function0<T> fun, Timed<T> timed) {
        return (T)TimeLimits.failAfterImpl$((TimeLimits)this, (Span)timeout, (Signaler)signaler, (Prettifier)prettifier, pos, stackDepthFun, fun, timed);
    }

    public <T> T cancelAfter(Span timeout, Function0<T> fun, Signaler signaler, Prettifier prettifier, Position pos, Timed<T> timed) {
        return (T)TimeLimits.cancelAfter$((TimeLimits)this, (Span)timeout, fun, (Signaler)signaler, (Prettifier)prettifier, (Position)pos, timed);
    }

    public <T> T cancelAfterImpl(Span timeout, Signaler signaler, Prettifier prettifier, Option<Position> pos, Function1<StackDepthException, Object> stackDepthFun, Function0<T> fun, Timed<T> timed) {
        return (T)TimeLimits.cancelAfterImpl$((TimeLimits)this, (Span)timeout, (Signaler)signaler, (Prettifier)prettifier, pos, stackDepthFun, fun, timed);
    }

    public <T> Prettifier failAfter$default$4(Span timeout, Function0<T> fun) {
        return TimeLimits.failAfter$default$4$((TimeLimits)this, (Span)timeout, fun);
    }

    public <T> Position failAfter$default$5(Span timeout, Function0<T> fun) {
        return TimeLimits.failAfter$default$5$((TimeLimits)this, (Span)timeout, fun);
    }

    public <T> Timed<T> failAfter$default$6(Span timeout, Function0<T> fun) {
        return TimeLimits.failAfter$default$6$((TimeLimits)this, (Span)timeout, fun);
    }

    public <T> Prettifier cancelAfter$default$4(Span timeout, Function0<T> fun) {
        return TimeLimits.cancelAfter$default$4$((TimeLimits)this, (Span)timeout, fun);
    }

    public <T> Position cancelAfter$default$5(Span timeout, Function0<T> fun) {
        return TimeLimits.cancelAfter$default$5$((TimeLimits)this, (Span)timeout, fun);
    }

    public <T> Timed<T> cancelAfter$default$6(Span timeout, Function0<T> fun) {
        return TimeLimits.cancelAfter$default$6$((TimeLimits)this, (Span)timeout, fun);
    }

    @Override
    public Signaler defaultSignaler() {
        return this.defaultSignaler;
    }

    @Override
    public void org$apache$spark$sql$hive$SparkSubmitTestUtils$_setter_$defaultSignaler_$eq(Signaler x$1) {
        this.defaultSignaler = x$1;
    }

    private File wareHousePath() {
        return this.wareHousePath;
    }

    private File tmpDataDir() {
        return this.tmpDataDir;
    }

    private File sparkTestingDir() {
        return this.sparkTestingDir;
    }

    private URL unusedJar() {
        return this.unusedJar;
    }

    public void afterAll() {
        Utils$.MODULE$.deleteRecursively(this.wareHousePath());
        Utils$.MODULE$.deleteRecursively(this.tmpDataDir());
        Utils$.MODULE$.deleteRecursively(this.sparkTestingDir());
        super.afterAll();
    }

    private void tryDownloadSpark(String version, String path) {
        Object object = new Object();
        try {
            IndexedSeq mirrors = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 2).flatMap((Function1 & Serializable & scala.Serializable)x$1 -> HiveExternalCatalogVersionsSuite.$anonfun$tryDownloadSpark$1(this, BoxesRunTime.unboxToInt((Object)x$1)), IndexedSeq$.MODULE$.canBuildFrom());
            IndexedSeq sites = (IndexedSeq)((SeqLike)mirrors.distinct()).$colon$plus((Object)"https://archive.apache.org/dist", IndexedSeq$.MODULE$.canBuildFrom());
            this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Trying to download Spark ").append(version).append(" from ").append(sites).toString());
            sites.foreach((Function1 & Serializable & scala.Serializable)site -> {
                Object object;
                String filename = new StringBuilder(24).append("spark-").append(version).append("-bin-hadoop2.7.tgz").toString();
                String url = new StringBuilder(14).append((String)site).append("/spark/spark-").append(version).append("/").append(filename).toString();
                this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Downloading Spark ").append(version).append(" from ").append(url).toString());
                try {
                    this.getFileFromUrl(url, path, filename);
                    String downloaded = new File(this.sparkTestingDir(), filename).getCanonicalPath();
                    String targetDir = new File(this.sparkTestingDir(), new StringBuilder(6).append("spark-").append(version).toString()).getCanonicalPath();
                    package$.MODULE$.stringSeqToProcess((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mkdir", targetDir}))).$bang();
                    int exitCode = package$.MODULE$.stringSeqToProcess((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tar", "-xzf", downloaded, "-C", targetDir, "--strip-components=1"}))).$bang();
                    package$.MODULE$.stringSeqToProcess((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rm", downloaded}))).$bang();
                    File sparkSubmit = new File(this.sparkTestingDir(), new StringBuilder(23).append("spark-").append(version).append("/bin/spark-submit").toString());
                    if (exitCode == 0 && sparkSubmit.exists()) {
                        throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
                    }
                    object = BoxesRunTime.boxToInteger((int)package$.MODULE$.stringSeqToProcess((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rm", "-rf", targetDir}))).$bang());
                }
                catch (Exception ex) {
                    this.logWarning((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Failed to download Spark ").append(version).append(" from ").append(url).append(": ").append(ex.getMessage()).toString());
                    object = BoxedUnit.UNIT;
                }
                return object;
            });
            throw this.fail(new StringBuilder(25).append("Unable to download Spark ").append(version).toString(), new Position("HiveExternalCatalogVersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() != object) {
                throw ex;
            }
            ex.value$mcV$sp();
            return;
        }
    }

    private String genDataDir(String name) {
        return new File(this.tmpDataDir(), name).getCanonicalPath();
    }

    private void getFileFromUrl(String urlString, String targetDir, String filename) {
        SparkConf conf = new SparkConf();
        conf.set("spark.files.overwrite", "true");
        SecurityManager securityManager = new SecurityManager(conf, SecurityManager$.MODULE$.$lessinit$greater$default$2());
        Configuration hadoopConf = new Configuration();
        File outDir = new File(targetDir);
        Object object = !outDir.exists() ? BoxesRunTime.boxToBoolean((boolean)outDir.mkdirs()) : BoxedUnit.UNIT;
        Utils$.MODULE$.doFetchFile(urlString, outDir, filename, conf, securityManager, hadoopConf);
    }

    private String getStringFromUrl(String urlString) {
        File contentFile = File.createTempFile("string-", ".txt");
        contentFile.deleteOnExit();
        this.getFileFromUrl(urlString, contentFile.getParent(), contentFile.getName());
        Path contentPath = Paths.get(contentFile.toURI());
        return new String(Files.readAllBytes(contentPath), StandardCharsets.UTF_8);
    }

    public void beforeAll() {
        super.beforeAll();
        File tempPyFile = File.createTempFile("test", ".py");
        Files.write(tempPyFile.toPath(), new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(1729).append("\n        |from pyspark.sql import SparkSession\n        |import os\n        |\n        |spark = SparkSession.builder.enableHiveSupport().getOrCreate()\n        |version_index = spark.conf.get(\"spark.sql.test.version.index\", None)\n        |\n        |spark.sql(\"create table data_source_tbl_{} using json as select 1 i\".format(version_index))\n        |\n        |spark.sql(\"create table hive_compatible_data_source_tbl_{} using parquet as select 1 i\".format(version_index))\n        |\n        |json_file = \"").append(this.genDataDir("json_")).append("\" + str(version_index)\n        |spark.range(1, 2).selectExpr(\"cast(id as int) as i\").write.json(json_file)\n        |spark.sql(\"create table external_data_source_tbl_{}(i int) using json options (path '{}')\".format(version_index, json_file))\n        |\n        |parquet_file = \"").append(this.genDataDir("parquet_")).append("\" + str(version_index)\n        |spark.range(1, 2).selectExpr(\"cast(id as int) as i\").write.parquet(parquet_file)\n        |spark.sql(\"create table hive_compatible_external_data_source_tbl_{}(i int) using parquet options (path '{}')\".format(version_index, parquet_file))\n        |\n        |json_file2 = \"").append(this.genDataDir("json2_")).append("\" + str(version_index)\n        |spark.range(1, 2).selectExpr(\"cast(id as int) as i\").write.json(json_file2)\n        |spark.sql(\"create table external_table_without_schema_{} using json options (path '{}')\".format(version_index, json_file2))\n        |\n        |parquet_file2 = \"").append(this.genDataDir("parquet2_")).append("\" + str(version_index)\n        |spark.range(1, 3).selectExpr(\"1 as i\", \"cast(id as int) as p\", \"1 as j\").write.parquet(os.path.join(parquet_file2, \"p=1\"))\n        |spark.sql(\"create table tbl_with_col_overlap_{} using parquet options(path '{}')\".format(version_index, parquet_file2))\n        |\n        |spark.sql(\"create view v_{} as select 1 i\".format(version_index))\n      ").toString())).stripMargin().getBytes("utf8"), new OpenOption[0]);
        if (PROCESS_TABLES$.MODULE$.testingVersions().isEmpty()) {
            throw this.fail("Fail to get the lates Spark versions to test.", new Position("HiveExternalCatalogVersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 174));
        }
        ((IterableLike)PROCESS_TABLES$.MODULE$.testingVersions().zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            HiveExternalCatalogVersionsSuite.$anonfun$beforeAll$1(this, tempPyFile, x0$1);
            return BoxedUnit.UNIT;
        });
        tempPyFile.delete();
    }

    public static final /* synthetic */ Iterable $anonfun$tryDownloadSpark$1(HiveExternalCatalogVersionsSuite $this, int x$1) {
        Iterable iterable;
        try {
            iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)$this.getStringFromUrl("https://www.apache.org/dyn/closer.lua?preferred=true")));
        }
        catch (Exception exception) {
            iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
        }
        return iterable;
    }

    public static final /* synthetic */ void $anonfun$beforeAll$1(HiveExternalCatalogVersionsSuite $this, File tempPyFile$1, Tuple2 x0$1) {
        File sparkHome;
        int index;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String version = (String)tuple2._1();
            index = tuple2._2$mcI$sp();
            sparkHome = new File($this.sparkTestingDir(), new StringBuilder(6).append("spark-").append(version).toString());
            if (!sparkHome.exists()) {
                $this.tryDownloadSpark(version, $this.sparkTestingDir().getCanonicalPath());
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        Seq args = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--name", "prepare testing tables", "--master", "local[2]", "--conf", "spark.ui.enabled=false", "--conf", "spark.master.rest.enabled=false", "--conf", new StringBuilder(24).append("spark.sql.warehouse.dir=").append($this.wareHousePath().getCanonicalPath()).toString(), "--conf", new StringBuilder(29).append("spark.sql.test.version.index=").append(index).toString(), "--driver-java-options", new StringBuilder(20).append("-Dderby.system.home=").append($this.wareHousePath().getCanonicalPath()).toString(), tempPyFile$1.getCanonicalPath()}));
        $this.runSparkSubmit((Seq<String>)args, (Option<String>)new Some((Object)sparkHome.getCanonicalPath()), false);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public HiveExternalCatalogVersionsSuite() {
        TimeLimits.$init$((TimeLimits)this);
        SparkSubmitTestUtils.$init$(this);
        String x$1 = "warehouse";
        String x$2 = Utils$.MODULE$.createTempDir$default$1();
        this.wareHousePath = Utils$.MODULE$.createTempDir(x$2, x$1);
        String x$3 = "test-data";
        String x$4 = Utils$.MODULE$.createTempDir$default$1();
        this.tmpDataDir = Utils$.MODULE$.createTempDir(x$4, x$3);
        this.sparkTestingDir = new File("/tmp/test-spark");
        this.unusedJar = TestUtils$.MODULE$.createJarWithClasses((Seq)Seq$.MODULE$.empty(), TestUtils$.MODULE$.createJarWithClasses$default$2(), TestUtils$.MODULE$.createJarWithClasses$default$3(), TestUtils$.MODULE$.createJarWithClasses$default$4());
        this.test("backward compatibility", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Seq args = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--class", new StringOps(Predef$.MODULE$.augmentString(PROCESS_TABLES$.MODULE$.getClass().getName())).stripSuffix("$"), "--name", "HiveExternalCatalog backward compatibility test", "--master", "local[2]", "--conf", "spark.ui.enabled=false", "--conf", "spark.master.rest.enabled=false", "--conf", new StringBuilder(24).append("spark.sql.warehouse.dir=").append(this.wareHousePath().getCanonicalPath()).toString(), "--conf", "spark.hadoop.fs.defaultFS=file:///", "--conf", "spark.hadoop.fs.default.name=file:///", "--driver-java-options", new StringBuilder(79).append("-Dderby.system.home=").append(this.wareHousePath().getCanonicalPath()).append(" ").append("-Dhive.exec.scratchdir=").append(System.getProperty("hive.exec.scratchdir")).append(" ").append("-Djava.security.auth.login.config=").append(System.getProperty("java.security.auth.login.config")).toString(), this.unusedJar().toString()}));
            this.runSparkSubmit((Seq<String>)args, this.runSparkSubmit$default$2(), this.runSparkSubmit$default$3());
        }, new Position("HiveExternalCatalogVersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 198));
    }
}

