/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.orc;

import java.io.File;
import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.hive.orc.OrcFileFormat;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.util.Benchmark;
import org.apache.spark.util.Benchmark$;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.Tuple2Zipped;
import scala.runtime.Tuple2Zipped$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random$;
import scala.util.Try$;

public final class OrcReadBenchmark$ {
    public static OrcReadBenchmark$ MODULE$;
    private final SparkConf conf;
    private final SparkSession spark;
    private final String NATIVE_ORC_FORMAT;
    private final String HIVE_ORC_FORMAT;

    static {
        new OrcReadBenchmark$();
    }

    public SparkConf conf() {
        return this.conf;
    }

    private SparkSession spark() {
        return this.spark;
    }

    public void withTempPath(Function1<File, BoxedUnit> f) {
        File path = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
        path.delete();
        try {
            f.apply((Object)path);
        }
        finally {
            Utils$.MODULE$.deleteRecursively(path);
        }
    }

    public void withTempTable(Seq<String> tableNames, Function0<BoxedUnit> f) {
        try {
            f.apply$mcV$sp();
        }
        finally {
            tableNames.foreach((Function1 & Serializable & scala.Serializable)viewName -> BoxesRunTime.boxToBoolean((boolean)OrcReadBenchmark$.$anonfun$withTempTable$1(viewName)));
        }
    }

    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        Tuple2 tuple2 = pairs.unzip((Function1)Predef$.MODULE$.$conforms());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq keys = (Seq)tuple2._1();
        Seq values = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)keys, (Object)values);
        Tuple2 tuple23 = tuple22;
        Seq keys2 = (Seq)tuple23._1();
        Seq values2 = (Seq)tuple23._2();
        Seq currentValues = (Seq)keys2.map((Function1 & Serializable & scala.Serializable)key -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> MODULE$.spark().conf().get(key)).toOption(), Seq$.MODULE$.canBuildFrom());
        Tuple2Zipped$.MODULE$.foreach$extension(Tuple2Zipped.Ops$.MODULE$.zipped$extension(Predef$.MODULE$.tuple2ToZippedOps(new Tuple2((Object)keys2, (Object)values2)), (Function1)Predef$.MODULE$.$conforms(), (Function1)Predef$.MODULE$.$conforms()), (Function2 & Serializable & scala.Serializable)(key, value) -> {
            OrcReadBenchmark$.$anonfun$withSQLConf$3(key, value);
            return BoxedUnit.UNIT;
        });
        try {
            f.apply$mcV$sp();
        }
        finally {
            ((IterableLike)keys2.zip((GenIterable)currentValues, Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                OrcReadBenchmark$.$anonfun$withSQLConf$4(x0$1);
                return BoxedUnit.UNIT;
            });
        }
    }

    private String NATIVE_ORC_FORMAT() {
        return this.NATIVE_ORC_FORMAT;
    }

    private String HIVE_ORC_FORMAT() {
        return this.HIVE_ORC_FORMAT;
    }

    private void prepareTable(File dir, Dataset<Row> df, Option<String> partition) {
        String dirORC = dir.getCanonicalPath();
        if (partition.isDefined()) {
            df.write().partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{(String)partition.get()})).orc(dirORC);
        } else {
            df.write().orc(dirORC);
        }
        this.spark().read().format(this.NATIVE_ORC_FORMAT()).load(dirORC).createOrReplaceTempView("nativeOrcTable");
        this.spark().read().format(this.HIVE_ORC_FORMAT()).load(dirORC).createOrReplaceTempView("hiveOrcTable");
    }

    private Option<String> prepareTable$default$3() {
        return None$.MODULE$;
    }

    public void numericScanBenchmark(int values, DataType dataType) {
        Benchmark benchmark = new Benchmark(new StringBuilder(23).append("SQL Single ").append(dataType.sql()).append(" Column Scan").toString(), (long)values, Benchmark$.MODULE$.$lessinit$greater$default$3(), Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
        this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            OrcReadBenchmark$.MODULE$.withTempTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "nativeOrcTable", "hiveOrcTable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                OrcReadBenchmark$.MODULE$.spark().range((long)values$1).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)Random$.MODULE$.nextLong()), OrcReadBenchmark$.MODULE$.spark().implicits().newLongEncoder()).createOrReplaceTempView("t1");
                OrcReadBenchmark$.MODULE$.prepareTable(dir, (Dataset<Row>)OrcReadBenchmark$.MODULE$.spark().sql(new StringBuilder(33).append("SELECT CAST(value as ").append(dataType$1.sql()).append(") id FROM t1").toString()), OrcReadBenchmark$.MODULE$.prepareTable$default$3());
                benchmark$1.addCase("Native ORC MR", benchmark$1.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$3 -> OrcReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> OrcReadBenchmark$.MODULE$.spark().sql("SELECT sum(id) FROM nativeOrcTable").collect()));
                benchmark$1.addCase("Native ORC Vectorized", benchmark$1.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$4 -> OrcReadBenchmark$.MODULE$.spark().sql("SELECT sum(id) FROM nativeOrcTable").collect());
                benchmark$1.addCase("Native ORC Vectorized with copy", benchmark$1.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$5 -> OrcReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_COPY_BATCH_TO_SPARK().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> OrcReadBenchmark$.MODULE$.spark().sql("SELECT sum(id) FROM nativeOrcTable").collect()));
                benchmark$1.addCase("Hive built-in ORC", benchmark$1.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$6 -> OrcReadBenchmark$.MODULE$.spark().sql("SELECT sum(id) FROM hiveOrcTable").collect());
                benchmark$1.run();
            });
            return BoxedUnit.UNIT;
        });
    }

    public void intStringScanBenchmark(int values) {
        Benchmark benchmark = new Benchmark("Int and String Scan", (long)values, Benchmark$.MODULE$.$lessinit$greater$default$3(), Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
        this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            OrcReadBenchmark$.MODULE$.withTempTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "nativeOrcTable", "hiveOrcTable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                OrcReadBenchmark$.MODULE$.spark().range((long)values$2).map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToLong((long)Random$.MODULE$.nextLong()), OrcReadBenchmark$.MODULE$.spark().implicits().newLongEncoder()).createOrReplaceTempView("t1");
                OrcReadBenchmark$.MODULE$.prepareTable(dir, (Dataset<Row>)OrcReadBenchmark$.MODULE$.spark().sql("SELECT CAST(value AS INT) AS c1, CAST(value as STRING) AS c2 FROM t1"), OrcReadBenchmark$.MODULE$.prepareTable$default$3());
                benchmark$2.addCase("Native ORC MR", benchmark$2.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$8 -> OrcReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> OrcReadBenchmark$.MODULE$.spark().sql("SELECT sum(c1), sum(length(c2)) FROM nativeOrcTable").collect()));
                benchmark$2.addCase("Native ORC Vectorized", benchmark$2.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$9 -> OrcReadBenchmark$.MODULE$.spark().sql("SELECT sum(c1), sum(length(c2)) FROM nativeOrcTable").collect());
                benchmark$2.addCase("Native ORC Vectorized with copy", benchmark$2.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$10 -> OrcReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_COPY_BATCH_TO_SPARK().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> OrcReadBenchmark$.MODULE$.spark().sql("SELECT sum(c1), sum(length(c2)) FROM nativeOrcTable").collect()));
                benchmark$2.addCase("Hive built-in ORC", benchmark$2.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$11 -> OrcReadBenchmark$.MODULE$.spark().sql("SELECT sum(c1), sum(length(c2)) FROM hiveOrcTable").collect());
                benchmark$2.run();
            });
            return BoxedUnit.UNIT;
        });
    }

    public void partitionTableScanBenchmark(int values) {
        Benchmark benchmark = new Benchmark("Partitioned Table", (long)values, Benchmark$.MODULE$.$lessinit$greater$default$3(), Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
        this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            OrcReadBenchmark$.MODULE$.withTempTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "nativeOrcTable", "hiveOrcTable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                OrcReadBenchmark$.MODULE$.spark().range((long)values$3).map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToLong((long)Random$.MODULE$.nextLong()), OrcReadBenchmark$.MODULE$.spark().implicits().newLongEncoder()).createOrReplaceTempView("t1");
                OrcReadBenchmark$.MODULE$.prepareTable(dir, (Dataset<Row>)OrcReadBenchmark$.MODULE$.spark().sql("SELECT value % 2 AS p, value AS id FROM t1"), (Option<String>)new Some((Object)"p"));
                benchmark$3.addCase("Data column - Native ORC MR", benchmark$3.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$13 -> OrcReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> OrcReadBenchmark$.MODULE$.spark().sql("SELECT sum(id) FROM nativeOrcTable").collect()));
                benchmark$3.addCase("Data column - Native ORC Vectorized", benchmark$3.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$14 -> OrcReadBenchmark$.MODULE$.spark().sql("SELECT sum(id) FROM nativeOrcTable").collect());
                benchmark$3.addCase("Data column - Native ORC Vectorized with copy", benchmark$3.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$15 -> OrcReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_COPY_BATCH_TO_SPARK().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> OrcReadBenchmark$.MODULE$.spark().sql("SELECT sum(id) FROM nativeOrcTable").collect()));
                benchmark$3.addCase("Data column - Hive built-in ORC", benchmark$3.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$16 -> OrcReadBenchmark$.MODULE$.spark().sql("SELECT sum(id) FROM hiveOrcTable").collect());
                benchmark$3.addCase("Partition column - Native ORC MR", benchmark$3.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$17 -> OrcReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> OrcReadBenchmark$.MODULE$.spark().sql("SELECT sum(p) FROM nativeOrcTable").collect()));
                benchmark$3.addCase("Partition column - Native ORC Vectorized", benchmark$3.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$18 -> OrcReadBenchmark$.MODULE$.spark().sql("SELECT sum(p) FROM nativeOrcTable").collect());
                benchmark$3.addCase("Partition column - Native ORC Vectorized with copy", benchmark$3.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$19 -> OrcReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_COPY_BATCH_TO_SPARK().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> OrcReadBenchmark$.MODULE$.spark().sql("SELECT sum(p) FROM nativeOrcTable").collect()));
                benchmark$3.addCase("Partition column - Hive built-in ORC", benchmark$3.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$20 -> OrcReadBenchmark$.MODULE$.spark().sql("SELECT sum(p) FROM hiveOrcTable").collect());
                benchmark$3.addCase("Both columns - Native ORC MR", benchmark$3.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$21 -> OrcReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> OrcReadBenchmark$.MODULE$.spark().sql("SELECT sum(p), sum(id) FROM nativeOrcTable").collect()));
                benchmark$3.addCase("Both columns - Native ORC Vectorized", benchmark$3.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$22 -> OrcReadBenchmark$.MODULE$.spark().sql("SELECT sum(p), sum(id) FROM nativeOrcTable").collect());
                benchmark$3.addCase("Both column - Native ORC Vectorized with copy", benchmark$3.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$23 -> OrcReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_COPY_BATCH_TO_SPARK().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> OrcReadBenchmark$.MODULE$.spark().sql("SELECT sum(p), sum(id) FROM nativeOrcTable").collect()));
                benchmark$3.addCase("Both columns - Hive built-in ORC", benchmark$3.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$24 -> OrcReadBenchmark$.MODULE$.spark().sql("SELECT sum(p), sum(id) FROM hiveOrcTable").collect());
                benchmark$3.run();
            });
            return BoxedUnit.UNIT;
        });
    }

    public void repeatedStringScanBenchmark(int values) {
        Benchmark benchmark = new Benchmark("Repeated String", (long)values, Benchmark$.MODULE$.$lessinit$greater$default$3(), Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
        this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            OrcReadBenchmark$.MODULE$.withTempTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "nativeOrcTable", "hiveOrcTable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                OrcReadBenchmark$.MODULE$.spark().range((long)values$4).createOrReplaceTempView("t1");
                OrcReadBenchmark$.MODULE$.prepareTable(dir, (Dataset<Row>)OrcReadBenchmark$.MODULE$.spark().sql("SELECT CAST((id % 200) + 10000 as STRING) AS c1 FROM t1"), OrcReadBenchmark$.MODULE$.prepareTable$default$3());
                benchmark$4.addCase("Native ORC MR", benchmark$4.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$25 -> OrcReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> OrcReadBenchmark$.MODULE$.spark().sql("SELECT sum(length(c1)) FROM nativeOrcTable").collect()));
                benchmark$4.addCase("Native ORC Vectorized", benchmark$4.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$26 -> OrcReadBenchmark$.MODULE$.spark().sql("SELECT sum(length(c1)) FROM nativeOrcTable").collect());
                benchmark$4.addCase("Native ORC Vectorized with copy", benchmark$4.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$27 -> OrcReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_COPY_BATCH_TO_SPARK().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> OrcReadBenchmark$.MODULE$.spark().sql("SELECT sum(length(c1)) FROM nativeOrcTable").collect()));
                benchmark$4.addCase("Hive built-in ORC", benchmark$4.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$28 -> OrcReadBenchmark$.MODULE$.spark().sql("SELECT sum(length(c1)) FROM hiveOrcTable").collect());
                benchmark$4.run();
            });
            return BoxedUnit.UNIT;
        });
    }

    public void stringWithNullsScanBenchmark(int values, double fractionOfNulls) {
        this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            OrcReadBenchmark$.MODULE$.withTempTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "nativeOrcTable", "hiveOrcTable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                OrcReadBenchmark$.MODULE$.spark().range((long)values$5).createOrReplaceTempView("t1");
                OrcReadBenchmark$.MODULE$.prepareTable(dir, (Dataset<Row>)OrcReadBenchmark$.MODULE$.spark().sql(new StringBuilder(109).append("SELECT IF(RAND(1) < ").append(fractionOfNulls$1).append(", NULL, CAST(id as STRING)) AS c1, ").append("IF(RAND(2) < ").append(fractionOfNulls$1).append(", NULL, CAST(id as STRING)) AS c2 FROM t1").toString()), OrcReadBenchmark$.MODULE$.prepareTable$default$3());
                Benchmark benchmark = new Benchmark(new StringBuilder(26).append("String with Nulls Scan (").append(fractionOfNulls$1).append("%)").toString(), (long)values$5, Benchmark$.MODULE$.$lessinit$greater$default$3(), Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
                benchmark.addCase("Native ORC MR", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$29 -> OrcReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> OrcReadBenchmark$.MODULE$.spark().sql("SELECT SUM(LENGTH(c2)) FROM nativeOrcTable WHERE c1 IS NOT NULL AND c2 IS NOT NULL").collect()));
                benchmark.addCase("Native ORC Vectorized", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$30 -> OrcReadBenchmark$.MODULE$.spark().sql("SELECT SUM(LENGTH(c2)) FROM nativeOrcTable WHERE c1 IS NOT NULL AND c2 IS NOT NULL").collect());
                benchmark.addCase("Native ORC Vectorized with copy", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$31 -> OrcReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_COPY_BATCH_TO_SPARK().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> OrcReadBenchmark$.MODULE$.spark().sql("SELECT SUM(LENGTH(c2)) FROM nativeOrcTable WHERE c1 IS NOT NULL AND c2 IS NOT NULL").collect()));
                benchmark.addCase("Hive built-in ORC", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$32 -> OrcReadBenchmark$.MODULE$.spark().sql("SELECT SUM(LENGTH(c2)) FROM hiveOrcTable WHERE c1 IS NOT NULL AND c2 IS NOT NULL").collect());
                benchmark.run();
            });
            return BoxedUnit.UNIT;
        });
    }

    public void columnsBenchmark(int values, int width) {
        Benchmark benchmark = new Benchmark(new StringBuilder(32).append("Single Column Scan from ").append(width).append(" columns").toString(), (long)values, Benchmark$.MODULE$.$lessinit$greater$default$3(), Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
        this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            OrcReadBenchmark$.MODULE$.withTempTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "nativeOrcTable", "hiveOrcTable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                int middle = width$1 / 2;
                IndexedSeq selectExpr = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), width$1).map((Function1 & Serializable & scala.Serializable)i -> OrcReadBenchmark$.$anonfun$columnsBenchmark$3(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
                OrcReadBenchmark$.MODULE$.spark().range((long)values$6).map((Function1 & Serializable & scala.Serializable)x$33 -> BoxesRunTime.boxToLong((long)Random$.MODULE$.nextLong()), OrcReadBenchmark$.MODULE$.spark().implicits().newLongEncoder()).toDF().selectExpr((Seq)selectExpr).createOrReplaceTempView("t1");
                OrcReadBenchmark$.MODULE$.prepareTable(dir, (Dataset<Row>)OrcReadBenchmark$.MODULE$.spark().sql("SELECT * FROM t1"), OrcReadBenchmark$.MODULE$.prepareTable$default$3());
                benchmark$5.addCase("Native ORC MR", benchmark$5.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$34 -> OrcReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> OrcReadBenchmark$.MODULE$.spark().sql(new StringBuilder(33).append("SELECT sum(c").append(middle).append(") FROM nativeOrcTable").toString()).collect()));
                benchmark$5.addCase("Native ORC Vectorized", benchmark$5.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$35 -> OrcReadBenchmark$.MODULE$.spark().sql(new StringBuilder(33).append("SELECT sum(c").append(middle).append(") FROM nativeOrcTable").toString()).collect());
                benchmark$5.addCase("Native ORC Vectorized with copy", benchmark$5.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$36 -> OrcReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_COPY_BATCH_TO_SPARK().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> OrcReadBenchmark$.MODULE$.spark().sql(new StringBuilder(33).append("SELECT sum(c").append(middle).append(") FROM nativeOrcTable").toString()).collect()));
                benchmark$5.addCase("Hive built-in ORC", benchmark$5.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$37 -> OrcReadBenchmark$.MODULE$.spark().sql(new StringBuilder(31).append("SELECT sum(c").append(middle).append(") FROM hiveOrcTable").toString()).collect());
                benchmark$5.run();
            });
            return BoxedUnit.UNIT;
        });
    }

    public void main(String[] args) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NumericType[]{ByteType$.MODULE$, ShortType$.MODULE$, IntegerType$.MODULE$, LongType$.MODULE$, FloatType$.MODULE$, DoubleType$.MODULE$}))).foreach((Function1 & Serializable & scala.Serializable)dataType -> {
            OrcReadBenchmark$.MODULE$.numericScanBenchmark(0xF00000, (DataType)dataType);
            return BoxedUnit.UNIT;
        });
        this.intStringScanBenchmark(0xA00000);
        this.partitionTableScanBenchmark(0xF00000);
        this.repeatedStringScanBenchmark(0xA00000);
        List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.5, 0.95})).foreach((Function1)(JFunction1.mcVD.sp & Serializable & scala.Serializable)fractionOfNulls -> MODULE$.stringWithNullsScanBenchmark(0xA00000, fractionOfNulls));
        this.columnsBenchmark(0x100000, 100);
        this.columnsBenchmark(0x100000, 200);
        this.columnsBenchmark(0x100000, 300);
    }

    public static final /* synthetic */ boolean $anonfun$withTempTable$1(String viewName) {
        return MODULE$.spark().catalog().dropTempView(viewName);
    }

    public static final /* synthetic */ void $anonfun$withSQLConf$3(String key, String value) {
        MODULE$.spark().conf().set(key, value);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final /* synthetic */ void $anonfun$withSQLConf$4(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String key = (String)tuple2._1();
            Option option = (Option)tuple2._2();
            if (option instanceof Some) {
                Some some = (Some)option;
                String value = (String)some.value();
                MODULE$.spark().conf().set(key, value);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        String key = (String)tuple2._1();
        Option option = (Option)tuple2._2();
        if (!None$.MODULE$.equals(option)) throw new MatchError((Object)tuple2);
        MODULE$.spark().conf().unset(key);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ String $anonfun$columnsBenchmark$3(int i) {
        return new StringBuilder(10).append("value as c").append(i).toString();
    }

    private OrcReadBenchmark$() {
        MODULE$ = this;
        this.conf = new SparkConf();
        this.conf().set("orc.compression", "snappy");
        this.spark = SparkSession$.MODULE$.builder().master("local[1]").appName("OrcReadBenchmark").config(this.conf()).getOrCreate();
        this.spark().conf().set(SQLConf$.MODULE$.ORC_FILTER_PUSHDOWN_ENABLED().key(), "true");
        this.NATIVE_ORC_FORMAT = org.apache.spark.sql.execution.datasources.orc.OrcFileFormat.class.getCanonicalName();
        this.HIVE_ORC_FORMAT = OrcFileFormat.class.getCanonicalName();
    }
}

