/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.execution;

import com.google.common.io.Files;
import java.io.File;
import java.io.Serializable;
import java.net.URI;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FsConstants;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.QueryTest;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier$;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat$;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTable$;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.plans.PlanTestBase;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.command.LoadDataCommand$;
import org.apache.spark.sql.hive.client.HiveClient;
import org.apache.spark.sql.hive.execution.HiveCommandSuite$;
import org.apache.spark.sql.hive.test.TestHiveContext;
import org.apache.spark.sql.hive.test.TestHiveSingleton;
import org.apache.spark.sql.test.SQLTestData;
import org.apache.spark.sql.test.SQLTestData$internalImplicits$;
import org.apache.spark.sql.test.SQLTestUtils;
import org.apache.spark.sql.test.SQLTestUtilsBase;
import org.apache.spark.sql.test.SQLTestUtilsBase$testImplicits$;
import org.apache.spark.sql.types.StructType;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import org.scalatest.concurrent.AbstractPatienceConfiguration;
import org.scalatest.concurrent.AbstractPatienceConfiguration$PatienceConfig$;
import org.scalatest.concurrent.Eventually;
import org.scalatest.concurrent.PatienceConfiguration;
import org.scalatest.concurrent.ScaledTimeSpans;
import org.scalatest.time.Span;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u00113A!\u0002\u0004\u0001'!)1\u0005\u0001C\u0001I!)q\u0005\u0001C)Q!)q\u0006\u0001C)Q!)\u0001\u0007\u0001C\u0005c\t\u0001\u0002*\u001b<f\u0007>lW.\u00198e'VLG/\u001a\u0006\u0003\u000f!\t\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005%Q\u0011\u0001\u00025jm\u0016T!a\u0003\u0007\u0002\u0007M\fHN\u0003\u0002\u000e\u001d\u0005)1\u000f]1sW*\u0011q\u0002E\u0001\u0007CB\f7\r[3\u000b\u0003E\t1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\u000b\u0019=A\u0011QCF\u0007\u0002\u0015%\u0011qC\u0003\u0002\n#V,'/\u001f+fgR\u0004\"!\u0007\u000f\u000e\u0003iQ!a\u0007\u0006\u0002\tQ,7\u000f^\u0005\u0003;i\u0011AbU)M)\u0016\u001cH/\u0016;jYN\u0004\"aH\u0011\u000e\u0003\u0001R!a\u0007\u0005\n\u0005\t\u0002#!\u0005+fgRD\u0015N^3TS:<G.\u001a;p]\u00061A(\u001b8jiz\"\u0012!\n\t\u0003M\u0001i\u0011AB\u0001\nE\u00164wN]3BY2$\u0012!\u000b\t\u0003U5j\u0011a\u000b\u0006\u0002Y\u0005)1oY1mC&\u0011af\u000b\u0002\u0005+:LG/\u0001\u0005bMR,'/\u00117m\u00031!Xm\u001d;M_\u0006$G)\u0019;b)\rI#g\u0010\u0005\u0006g\u0011\u0001\r\u0001N\u0001\nY>\fG-U;fef\u0004\"!\u000e\u001f\u000f\u0005YR\u0004CA\u001c,\u001b\u0005A$BA\u001d\u0013\u0003\u0019a$o\\8u}%\u00111hK\u0001\u0007!J,G-\u001a4\n\u0005ur$AB*ue&twM\u0003\u0002<W!)\u0001\t\u0002a\u0001\u0003\u0006)An\\2bYB\u0011!FQ\u0005\u0003\u0007.\u0012qAQ8pY\u0016\fg\u000e")
public class HiveCommandSuite
extends QueryTest
implements SQLTestUtils,
TestHiveSingleton {
    private final boolean enableAutoThreadAudit;
    private final SparkSession spark;
    private final TestHiveContext hiveContext;
    private final HiveClient hiveClient;
    private boolean org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests;
    private Function1<String, Dataset<Row>> sql;
    private volatile SQLTestUtilsBase$testImplicits$ testImplicits$module;
    private volatile SQLTestData$internalImplicits$ internalImplicits$module;
    private Dataset<Row> emptyTestData;
    private Dataset<Row> testData;
    private Dataset<Row> testData2;
    private Dataset<Row> testData3;
    private Dataset<Row> negativeData;
    private Dataset<Row> largeAndSmallInts;
    private Dataset<Row> decimalData;
    private Dataset<Row> binaryData;
    private Dataset<Row> upperCaseData;
    private Dataset<Row> lowerCaseData;
    private Dataset<Row> lowerCaseDataWithDuplicates;
    private RDD<SQLTestData.ArrayData> arrayData;
    private RDD<SQLTestData.MapData> mapData;
    private RDD<SQLTestData.StringData> repeatedData;
    private RDD<SQLTestData.StringData> nullableRepeatedData;
    private Dataset<Row> nullInts;
    private Dataset<Row> allNulls;
    private Dataset<Row> nullStrings;
    private Dataset<Row> tableName;
    private RDD<String> unparsedStrings;
    private RDD<SQLTestData.IntField> withEmptyParts;
    private Dataset<Row> person;
    private Dataset<Row> salary;
    private Dataset<Row> complexData;
    private Dataset<Row> courseSales;
    private Dataset<Row> trainingSales;
    private final AbstractPatienceConfiguration.PatienceConfig org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig;
    private volatile AbstractPatienceConfiguration$PatienceConfig$ PatienceConfig$module;
    private volatile int bitmap$0;

    @Override
    public /* synthetic */ void org$apache$spark$sql$hive$test$TestHiveSingleton$$super$afterAll() {
        super.afterAll();
    }

    public /* synthetic */ void org$apache$spark$sql$test$SQLTestUtils$$super$beforeAll() {
        super.beforeAll();
    }

    public void setupTestData() {
        SQLTestUtils.setupTestData$((SQLTestUtils)this);
    }

    public void testQuietly(String name, Function0<BoxedUnit> f) {
        SQLTestUtils.testQuietly$((SQLTestUtils)this, (String)name, f);
    }

    public void testWithUninterruptibleThread(String name, boolean quietly, Function0<BoxedUnit> body) {
        SQLTestUtils.testWithUninterruptibleThread$((SQLTestUtils)this, (String)name, (boolean)quietly, body);
    }

    public boolean testWithUninterruptibleThread$default$2() {
        return SQLTestUtils.testWithUninterruptibleThread$default$2$((SQLTestUtils)this);
    }

    public /* synthetic */ void org$apache$spark$sql$test$SQLTestUtilsBase$$super$withSQLConf(Seq pairs, Function0 f) {
        PlanTestBase.withSQLConf$((PlanTestBase)this, (Seq)pairs, (Function0)f);
    }

    public SparkContext sparkContext() {
        return SQLTestUtilsBase.sparkContext$((SQLTestUtilsBase)this);
    }

    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withSQLConf$((SQLTestUtilsBase)this, pairs, f);
    }

    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLTestUtilsBase.withTempPath$((SQLTestUtilsBase)this, f);
    }

    public void withResourceTempPath(String resourcePath, Function1<File, BoxedUnit> f) {
        SQLTestUtilsBase.withResourceTempPath$((SQLTestUtilsBase)this, (String)resourcePath, f);
    }

    public void waitForTasksToFinish() {
        SQLTestUtilsBase.waitForTasksToFinish$((SQLTestUtilsBase)this);
    }

    public void withTempDir(Function1<File, BoxedUnit> f) {
        SQLTestUtilsBase.withTempDir$((SQLTestUtilsBase)this, f);
    }

    public void withTempPaths(int numPaths, Function1<Seq<File>, BoxedUnit> f) {
        SQLTestUtilsBase.withTempPaths$((SQLTestUtilsBase)this, (int)numPaths, f);
    }

    public void withUserDefinedFunction(Seq<Tuple2<String, Object>> functions2, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withUserDefinedFunction$((SQLTestUtilsBase)this, functions2, f);
    }

    public void withTempView(Seq<String> viewNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withTempView$((SQLTestUtilsBase)this, viewNames, f);
    }

    public void withGlobalTempView(Seq<String> viewNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withGlobalTempView$((SQLTestUtilsBase)this, viewNames, f);
    }

    public void withTable(Seq<String> tableNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withTable$((SQLTestUtilsBase)this, tableNames, f);
    }

    public void withView(Seq<String> viewNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withView$((SQLTestUtilsBase)this, viewNames, f);
    }

    public void withTempDatabase(Function1<String, BoxedUnit> f) {
        SQLTestUtilsBase.withTempDatabase$((SQLTestUtilsBase)this, f);
    }

    public void withDatabase(Seq<String> dbNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withDatabase$((SQLTestUtilsBase)this, dbNames, f);
    }

    public void withLocale(String language, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withLocale$((SQLTestUtilsBase)this, (String)language, f);
    }

    public void activateDatabase(String db, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.activateDatabase$((SQLTestUtilsBase)this, (String)db, f);
    }

    public Dataset<Row> stripSparkFilter(Dataset<Row> df) {
        return SQLTestUtilsBase.stripSparkFilter$((SQLTestUtilsBase)this, df);
    }

    public Dataset<Row> logicalPlanToSparkQuery(LogicalPlan plan) {
        return SQLTestUtilsBase.logicalPlanToSparkQuery$((SQLTestUtilsBase)this, (LogicalPlan)plan);
    }

    public URI makeQualifiedPath(String path) {
        return SQLTestUtilsBase.makeQualifiedPath$((SQLTestUtilsBase)this, (String)path);
    }

    public String testFile(String fileName) {
        return SQLTestUtilsBase.testFile$((SQLTestUtilsBase)this, (String)fileName);
    }

    public void loadTestData() {
        SQLTestData.loadTestData$((SQLTestData)this);
    }

    public <T> T eventually(PatienceConfiguration.Timeout timeout, PatienceConfiguration.Interval interval, Function0<T> fun, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Timeout)timeout, (PatienceConfiguration.Interval)interval, fun, (Position)pos);
    }

    public <T> T eventually(PatienceConfiguration.Timeout timeout, Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Timeout)timeout, fun, (AbstractPatienceConfiguration.PatienceConfig)config, (Position)pos);
    }

    public <T> T eventually(PatienceConfiguration.Interval interval, Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Interval)interval, fun, (AbstractPatienceConfiguration.PatienceConfig)config, (Position)pos);
    }

    public <T> T eventually(Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, fun, (AbstractPatienceConfiguration.PatienceConfig)config, (Position)pos);
    }

    public AbstractPatienceConfiguration.PatienceConfig patienceConfig() {
        return PatienceConfiguration.patienceConfig$((PatienceConfiguration)this);
    }

    public PatienceConfiguration.Timeout timeout(Span value) {
        return PatienceConfiguration.timeout$((PatienceConfiguration)this, (Span)value);
    }

    public PatienceConfiguration.Interval interval(Span value) {
        return PatienceConfiguration.interval$((PatienceConfiguration)this, (Span)value);
    }

    public final Span scaled(Span span) {
        return ScaledTimeSpans.scaled$((ScaledTimeSpans)this, (Span)span);
    }

    public double spanScaleFactor() {
        return ScaledTimeSpans.spanScaleFactor$((ScaledTimeSpans)this);
    }

    @Override
    public boolean enableAutoThreadAudit() {
        return this.enableAutoThreadAudit;
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public TestHiveContext hiveContext() {
        return this.hiveContext;
    }

    @Override
    public HiveClient hiveClient() {
        return this.hiveClient;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$enableAutoThreadAudit_$eq(boolean x$1) {
        this.enableAutoThreadAudit = x$1;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$hiveContext_$eq(TestHiveContext x$1) {
        this.hiveContext = x$1;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$hiveClient_$eq(HiveClient x$1) {
        this.hiveClient = x$1;
    }

    public boolean org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests() {
        return this.org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests;
    }

    public void org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests_$eq(boolean x$1) {
        this.org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests = x$1;
    }

    private Function1<String, Dataset<Row>> sql$lzycompute() {
        HiveCommandSuite hiveCommandSuite = this;
        synchronized (hiveCommandSuite) {
            if ((this.bitmap$0 & 1) == 0) {
                this.sql = SQLTestUtilsBase.sql$((SQLTestUtilsBase)this);
                this.bitmap$0 |= 1;
            }
        }
        return this.sql;
    }

    public Function1<String, Dataset<Row>> sql() {
        return (this.bitmap$0 & 1) == 0 ? this.sql$lzycompute() : this.sql;
    }

    public SQLTestUtilsBase$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    public SQLTestData$internalImplicits$ org$apache$spark$sql$test$SQLTestData$$internalImplicits() {
        if (this.internalImplicits$module == null) {
            this.org$apache$spark$sql$test$SQLTestData$$internalImplicits$lzycompute$1();
        }
        return this.internalImplicits$module;
    }

    private Dataset<Row> emptyTestData$lzycompute() {
        HiveCommandSuite hiveCommandSuite = this;
        synchronized (hiveCommandSuite) {
            if ((this.bitmap$0 & 2) == 0) {
                this.emptyTestData = SQLTestData.emptyTestData$((SQLTestData)this);
                this.bitmap$0 |= 2;
            }
        }
        return this.emptyTestData;
    }

    public Dataset<Row> emptyTestData() {
        return (this.bitmap$0 & 2) == 0 ? this.emptyTestData$lzycompute() : this.emptyTestData;
    }

    private Dataset<Row> testData$lzycompute() {
        HiveCommandSuite hiveCommandSuite = this;
        synchronized (hiveCommandSuite) {
            if ((this.bitmap$0 & 4) == 0) {
                this.testData = SQLTestData.testData$((SQLTestData)this);
                this.bitmap$0 |= 4;
            }
        }
        return this.testData;
    }

    public Dataset<Row> testData() {
        return (this.bitmap$0 & 4) == 0 ? this.testData$lzycompute() : this.testData;
    }

    private Dataset<Row> testData2$lzycompute() {
        HiveCommandSuite hiveCommandSuite = this;
        synchronized (hiveCommandSuite) {
            if ((this.bitmap$0 & 8) == 0) {
                this.testData2 = SQLTestData.testData2$((SQLTestData)this);
                this.bitmap$0 |= 8;
            }
        }
        return this.testData2;
    }

    public Dataset<Row> testData2() {
        return (this.bitmap$0 & 8) == 0 ? this.testData2$lzycompute() : this.testData2;
    }

    private Dataset<Row> testData3$lzycompute() {
        HiveCommandSuite hiveCommandSuite = this;
        synchronized (hiveCommandSuite) {
            if ((this.bitmap$0 & 0x10) == 0) {
                this.testData3 = SQLTestData.testData3$((SQLTestData)this);
                this.bitmap$0 |= 0x10;
            }
        }
        return this.testData3;
    }

    public Dataset<Row> testData3() {
        return (this.bitmap$0 & 0x10) == 0 ? this.testData3$lzycompute() : this.testData3;
    }

    private Dataset<Row> negativeData$lzycompute() {
        HiveCommandSuite hiveCommandSuite = this;
        synchronized (hiveCommandSuite) {
            if ((this.bitmap$0 & 0x20) == 0) {
                this.negativeData = SQLTestData.negativeData$((SQLTestData)this);
                this.bitmap$0 |= 0x20;
            }
        }
        return this.negativeData;
    }

    public Dataset<Row> negativeData() {
        return (this.bitmap$0 & 0x20) == 0 ? this.negativeData$lzycompute() : this.negativeData;
    }

    private Dataset<Row> largeAndSmallInts$lzycompute() {
        HiveCommandSuite hiveCommandSuite = this;
        synchronized (hiveCommandSuite) {
            if ((this.bitmap$0 & 0x40) == 0) {
                this.largeAndSmallInts = SQLTestData.largeAndSmallInts$((SQLTestData)this);
                this.bitmap$0 |= 0x40;
            }
        }
        return this.largeAndSmallInts;
    }

    public Dataset<Row> largeAndSmallInts() {
        return (this.bitmap$0 & 0x40) == 0 ? this.largeAndSmallInts$lzycompute() : this.largeAndSmallInts;
    }

    private Dataset<Row> decimalData$lzycompute() {
        HiveCommandSuite hiveCommandSuite = this;
        synchronized (hiveCommandSuite) {
            if ((this.bitmap$0 & 0x80) == 0) {
                this.decimalData = SQLTestData.decimalData$((SQLTestData)this);
                this.bitmap$0 |= 0x80;
            }
        }
        return this.decimalData;
    }

    public Dataset<Row> decimalData() {
        return (this.bitmap$0 & 0x80) == 0 ? this.decimalData$lzycompute() : this.decimalData;
    }

    private Dataset<Row> binaryData$lzycompute() {
        HiveCommandSuite hiveCommandSuite = this;
        synchronized (hiveCommandSuite) {
            if ((this.bitmap$0 & 0x100) == 0) {
                this.binaryData = SQLTestData.binaryData$((SQLTestData)this);
                this.bitmap$0 |= 0x100;
            }
        }
        return this.binaryData;
    }

    public Dataset<Row> binaryData() {
        return (this.bitmap$0 & 0x100) == 0 ? this.binaryData$lzycompute() : this.binaryData;
    }

    private Dataset<Row> upperCaseData$lzycompute() {
        HiveCommandSuite hiveCommandSuite = this;
        synchronized (hiveCommandSuite) {
            if ((this.bitmap$0 & 0x200) == 0) {
                this.upperCaseData = SQLTestData.upperCaseData$((SQLTestData)this);
                this.bitmap$0 |= 0x200;
            }
        }
        return this.upperCaseData;
    }

    public Dataset<Row> upperCaseData() {
        return (this.bitmap$0 & 0x200) == 0 ? this.upperCaseData$lzycompute() : this.upperCaseData;
    }

    private Dataset<Row> lowerCaseData$lzycompute() {
        HiveCommandSuite hiveCommandSuite = this;
        synchronized (hiveCommandSuite) {
            if ((this.bitmap$0 & 0x400) == 0) {
                this.lowerCaseData = SQLTestData.lowerCaseData$((SQLTestData)this);
                this.bitmap$0 |= 0x400;
            }
        }
        return this.lowerCaseData;
    }

    public Dataset<Row> lowerCaseData() {
        return (this.bitmap$0 & 0x400) == 0 ? this.lowerCaseData$lzycompute() : this.lowerCaseData;
    }

    private Dataset<Row> lowerCaseDataWithDuplicates$lzycompute() {
        HiveCommandSuite hiveCommandSuite = this;
        synchronized (hiveCommandSuite) {
            if ((this.bitmap$0 & 0x800) == 0) {
                this.lowerCaseDataWithDuplicates = SQLTestData.lowerCaseDataWithDuplicates$((SQLTestData)this);
                this.bitmap$0 |= 0x800;
            }
        }
        return this.lowerCaseDataWithDuplicates;
    }

    public Dataset<Row> lowerCaseDataWithDuplicates() {
        return (this.bitmap$0 & 0x800) == 0 ? this.lowerCaseDataWithDuplicates$lzycompute() : this.lowerCaseDataWithDuplicates;
    }

    private RDD<SQLTestData.ArrayData> arrayData$lzycompute() {
        HiveCommandSuite hiveCommandSuite = this;
        synchronized (hiveCommandSuite) {
            if ((this.bitmap$0 & 0x1000) == 0) {
                this.arrayData = SQLTestData.arrayData$((SQLTestData)this);
                this.bitmap$0 |= 0x1000;
            }
        }
        return this.arrayData;
    }

    public RDD<SQLTestData.ArrayData> arrayData() {
        return (this.bitmap$0 & 0x1000) == 0 ? this.arrayData$lzycompute() : this.arrayData;
    }

    private RDD<SQLTestData.MapData> mapData$lzycompute() {
        HiveCommandSuite hiveCommandSuite = this;
        synchronized (hiveCommandSuite) {
            if ((this.bitmap$0 & 0x2000) == 0) {
                this.mapData = SQLTestData.mapData$((SQLTestData)this);
                this.bitmap$0 |= 0x2000;
            }
        }
        return this.mapData;
    }

    public RDD<SQLTestData.MapData> mapData() {
        return (this.bitmap$0 & 0x2000) == 0 ? this.mapData$lzycompute() : this.mapData;
    }

    private RDD<SQLTestData.StringData> repeatedData$lzycompute() {
        HiveCommandSuite hiveCommandSuite = this;
        synchronized (hiveCommandSuite) {
            if ((this.bitmap$0 & 0x4000) == 0) {
                this.repeatedData = SQLTestData.repeatedData$((SQLTestData)this);
                this.bitmap$0 |= 0x4000;
            }
        }
        return this.repeatedData;
    }

    public RDD<SQLTestData.StringData> repeatedData() {
        return (this.bitmap$0 & 0x4000) == 0 ? this.repeatedData$lzycompute() : this.repeatedData;
    }

    private RDD<SQLTestData.StringData> nullableRepeatedData$lzycompute() {
        HiveCommandSuite hiveCommandSuite = this;
        synchronized (hiveCommandSuite) {
            if ((this.bitmap$0 & 0x8000) == 0) {
                this.nullableRepeatedData = SQLTestData.nullableRepeatedData$((SQLTestData)this);
                this.bitmap$0 |= 0x8000;
            }
        }
        return this.nullableRepeatedData;
    }

    public RDD<SQLTestData.StringData> nullableRepeatedData() {
        return (this.bitmap$0 & 0x8000) == 0 ? this.nullableRepeatedData$lzycompute() : this.nullableRepeatedData;
    }

    private Dataset<Row> nullInts$lzycompute() {
        HiveCommandSuite hiveCommandSuite = this;
        synchronized (hiveCommandSuite) {
            if ((this.bitmap$0 & 0x10000) == 0) {
                this.nullInts = SQLTestData.nullInts$((SQLTestData)this);
                this.bitmap$0 |= 0x10000;
            }
        }
        return this.nullInts;
    }

    public Dataset<Row> nullInts() {
        return (this.bitmap$0 & 0x10000) == 0 ? this.nullInts$lzycompute() : this.nullInts;
    }

    private Dataset<Row> allNulls$lzycompute() {
        HiveCommandSuite hiveCommandSuite = this;
        synchronized (hiveCommandSuite) {
            if ((this.bitmap$0 & 0x20000) == 0) {
                this.allNulls = SQLTestData.allNulls$((SQLTestData)this);
                this.bitmap$0 |= 0x20000;
            }
        }
        return this.allNulls;
    }

    public Dataset<Row> allNulls() {
        return (this.bitmap$0 & 0x20000) == 0 ? this.allNulls$lzycompute() : this.allNulls;
    }

    private Dataset<Row> nullStrings$lzycompute() {
        HiveCommandSuite hiveCommandSuite = this;
        synchronized (hiveCommandSuite) {
            if ((this.bitmap$0 & 0x40000) == 0) {
                this.nullStrings = SQLTestData.nullStrings$((SQLTestData)this);
                this.bitmap$0 |= 0x40000;
            }
        }
        return this.nullStrings;
    }

    public Dataset<Row> nullStrings() {
        return (this.bitmap$0 & 0x40000) == 0 ? this.nullStrings$lzycompute() : this.nullStrings;
    }

    private Dataset<Row> tableName$lzycompute() {
        HiveCommandSuite hiveCommandSuite = this;
        synchronized (hiveCommandSuite) {
            if ((this.bitmap$0 & 0x80000) == 0) {
                this.tableName = SQLTestData.tableName$((SQLTestData)this);
                this.bitmap$0 |= 0x80000;
            }
        }
        return this.tableName;
    }

    public Dataset<Row> tableName() {
        return (this.bitmap$0 & 0x80000) == 0 ? this.tableName$lzycompute() : this.tableName;
    }

    private RDD<String> unparsedStrings$lzycompute() {
        HiveCommandSuite hiveCommandSuite = this;
        synchronized (hiveCommandSuite) {
            if ((this.bitmap$0 & 0x100000) == 0) {
                this.unparsedStrings = SQLTestData.unparsedStrings$((SQLTestData)this);
                this.bitmap$0 |= 0x100000;
            }
        }
        return this.unparsedStrings;
    }

    public RDD<String> unparsedStrings() {
        return (this.bitmap$0 & 0x100000) == 0 ? this.unparsedStrings$lzycompute() : this.unparsedStrings;
    }

    private RDD<SQLTestData.IntField> withEmptyParts$lzycompute() {
        HiveCommandSuite hiveCommandSuite = this;
        synchronized (hiveCommandSuite) {
            if ((this.bitmap$0 & 0x200000) == 0) {
                this.withEmptyParts = SQLTestData.withEmptyParts$((SQLTestData)this);
                this.bitmap$0 |= 0x200000;
            }
        }
        return this.withEmptyParts;
    }

    public RDD<SQLTestData.IntField> withEmptyParts() {
        return (this.bitmap$0 & 0x200000) == 0 ? this.withEmptyParts$lzycompute() : this.withEmptyParts;
    }

    private Dataset<Row> person$lzycompute() {
        HiveCommandSuite hiveCommandSuite = this;
        synchronized (hiveCommandSuite) {
            if ((this.bitmap$0 & 0x400000) == 0) {
                this.person = SQLTestData.person$((SQLTestData)this);
                this.bitmap$0 |= 0x400000;
            }
        }
        return this.person;
    }

    public Dataset<Row> person() {
        return (this.bitmap$0 & 0x400000) == 0 ? this.person$lzycompute() : this.person;
    }

    private Dataset<Row> salary$lzycompute() {
        HiveCommandSuite hiveCommandSuite = this;
        synchronized (hiveCommandSuite) {
            if ((this.bitmap$0 & 0x800000) == 0) {
                this.salary = SQLTestData.salary$((SQLTestData)this);
                this.bitmap$0 |= 0x800000;
            }
        }
        return this.salary;
    }

    public Dataset<Row> salary() {
        return (this.bitmap$0 & 0x800000) == 0 ? this.salary$lzycompute() : this.salary;
    }

    private Dataset<Row> complexData$lzycompute() {
        HiveCommandSuite hiveCommandSuite = this;
        synchronized (hiveCommandSuite) {
            if ((this.bitmap$0 & 0x1000000) == 0) {
                this.complexData = SQLTestData.complexData$((SQLTestData)this);
                this.bitmap$0 |= 0x1000000;
            }
        }
        return this.complexData;
    }

    public Dataset<Row> complexData() {
        return (this.bitmap$0 & 0x1000000) == 0 ? this.complexData$lzycompute() : this.complexData;
    }

    private Dataset<Row> courseSales$lzycompute() {
        HiveCommandSuite hiveCommandSuite = this;
        synchronized (hiveCommandSuite) {
            if ((this.bitmap$0 & 0x2000000) == 0) {
                this.courseSales = SQLTestData.courseSales$((SQLTestData)this);
                this.bitmap$0 |= 0x2000000;
            }
        }
        return this.courseSales;
    }

    public Dataset<Row> courseSales() {
        return (this.bitmap$0 & 0x2000000) == 0 ? this.courseSales$lzycompute() : this.courseSales;
    }

    private Dataset<Row> trainingSales$lzycompute() {
        HiveCommandSuite hiveCommandSuite = this;
        synchronized (hiveCommandSuite) {
            if ((this.bitmap$0 & 0x4000000) == 0) {
                this.trainingSales = SQLTestData.trainingSales$((SQLTestData)this);
                this.bitmap$0 |= 0x4000000;
            }
        }
        return this.trainingSales;
    }

    public Dataset<Row> trainingSales() {
        return (this.bitmap$0 & 0x4000000) == 0 ? this.trainingSales$lzycompute() : this.trainingSales;
    }

    public AbstractPatienceConfiguration.PatienceConfig org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig() {
        return this.org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig;
    }

    public final void org$scalatest$concurrent$PatienceConfiguration$_setter_$org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig_$eq(AbstractPatienceConfiguration.PatienceConfig x$1) {
        this.org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig = x$1;
    }

    public AbstractPatienceConfiguration$PatienceConfig$ PatienceConfig() {
        if (this.PatienceConfig$module == null) {
            this.PatienceConfig$lzycompute$1();
        }
        return this.PatienceConfig$module;
    }

    public void beforeAll() {
        SQLTestUtils.beforeAll$((SQLTestUtils)this);
        SessionCatalog qual$1 = this.hiveContext().sessionState().catalog();
        TableIdentifier x$1 = TableIdentifier$.MODULE$.apply("parquet_tab1");
        CatalogTableType x$2 = CatalogTableType$.MODULE$.MANAGED();
        CatalogStorageFormat x$3 = CatalogStorageFormat$.MODULE$.empty();
        StructType x$4 = new StructType().add("c1", "int").add("c2", "string");
        Some x$5 = new Some((Object)"parquet");
        Map x$6 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"my_key1"), (Object)"v1")}));
        Seq x$7 = CatalogTable$.MODULE$.apply$default$6();
        Option x$8 = CatalogTable$.MODULE$.apply$default$7();
        String x$9 = CatalogTable$.MODULE$.apply$default$8();
        long x$10 = CatalogTable$.MODULE$.apply$default$9();
        long x$11 = CatalogTable$.MODULE$.apply$default$10();
        String x$12 = CatalogTable$.MODULE$.apply$default$11();
        Option x$13 = CatalogTable$.MODULE$.apply$default$13();
        Option x$14 = CatalogTable$.MODULE$.apply$default$14();
        Option x$15 = CatalogTable$.MODULE$.apply$default$15();
        Seq x$16 = CatalogTable$.MODULE$.apply$default$16();
        boolean x$17 = CatalogTable$.MODULE$.apply$default$17();
        boolean x$18 = CatalogTable$.MODULE$.apply$default$18();
        Map x$19 = CatalogTable$.MODULE$.apply$default$19();
        CatalogTable x$20 = new CatalogTable(x$1, x$2, x$3, x$4, (Option)x$5, x$7, x$8, x$9, x$10, x$11, x$12, x$6, x$13, x$14, x$15, x$16, x$17, x$18, x$19);
        boolean x$21 = false;
        boolean x$22 = qual$1.createTable$default$3();
        qual$1.createTable(x$20, x$21, x$22);
        this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE parquet_tab2 (c1 INT, c2 STRING)\n        |STORED AS PARQUET\n        |TBLPROPERTIES('prop1Key'=\"prop1Val\", '`prop2Key`'=\"prop2Val\")\n      ")).stripMargin());
        this.sql().apply((Object)"CREATE TABLE parquet_tab3(col1 int, `col 2` int)");
        this.sql().apply((Object)"CREATE TABLE parquet_tab4 (price int, qty int) partitioned by (year int, month int)");
        this.sql().apply((Object)"INSERT INTO parquet_tab4 PARTITION(year = 2015, month = 1) SELECT 1, 1");
        this.sql().apply((Object)"INSERT INTO parquet_tab4 PARTITION(year = 2015, month = 2) SELECT 2, 2");
        this.sql().apply((Object)"INSERT INTO parquet_tab4 PARTITION(year = 2016, month = 2) SELECT 3, 3");
        this.sql().apply((Object)"INSERT INTO parquet_tab4 PARTITION(year = 2016, month = 3) SELECT 3, 3");
        this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE parquet_tab5 (price int, qty int)\n        |PARTITIONED BY (year int, month int, hour int, minute int, sec int, extra int)\n      ")).stripMargin());
        this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString("\n        |INSERT INTO parquet_tab5\n        |PARTITION(year = 2016, month = 3, hour = 10, minute = 10, sec = 10, extra = 1) SELECT 3, 3\n      ")).stripMargin());
        this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString("\n        |INSERT INTO parquet_tab5\n        |PARTITION(year = 2016, month = 4, hour = 10, minute = 10, sec = 10, extra = 1) SELECT 3, 3\n      ")).stripMargin());
        this.sql().apply((Object)"CREATE VIEW parquet_view1 as select * from parquet_tab4");
    }

    @Override
    public void afterAll() {
        try {
            this.sql().apply((Object)"DROP TABLE IF EXISTS parquet_tab1");
            this.sql().apply((Object)"DROP TABLE IF EXISTS parquet_tab2");
            this.sql().apply((Object)"DROP TABLE IF EXISTS parquet_tab3");
            this.sql().apply((Object)"DROP VIEW IF EXISTS parquet_view1");
            this.sql().apply((Object)"DROP TABLE IF EXISTS parquet_tab4");
            this.sql().apply((Object)"DROP TABLE IF EXISTS parquet_tab5");
        }
        finally {
            TestHiveSingleton.afterAll$(this);
        }
    }

    private void testLoadData(String loadQuery, boolean local) {
        File testData = this.hiveContext().getHiveFile("data/files/employee.dat").getCanonicalFile();
        this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"non_part_table", "part_table"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Object object;
            this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString("\n          |CREATE TABLE non_part_table (employeeID INT, employeeName STRING)\n          |ROW FORMAT DELIMITED\n          |FIELDS TERMINATED BY '|'\n          |LINES TERMINATED BY '\\n'\n        ")).stripMargin());
            this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(54).append(loadQuery).append(" INPATH \"").append(testData.toURI()).append("\" INTO TABLE non_part_table PARTITION(ds=\"1\")").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("HiveCommandSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 205));
            HiveCommandSuite.withInputFile$1((Function1 & Serializable & scala.Serializable)path -> {
                HiveCommandSuite.$anonfun$testLoadData$3(this, loadQuery, local, path);
                return BoxedUnit.UNIT;
            }, local, testData);
            Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)16), "john"}));
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT * FROM non_part_table WHERE employeeID = 16"), (Seq)Nil$.MODULE$.$colon$colon((Object)row));
            if (local) {
                String incorrectUri = "file://path/to/data/files/employee.dat";
                object = this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(51).append("LOAD DATA LOCAL INPATH \"").append(incorrectUri).append("\" INTO TABLE non_part_table").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("HiveCommandSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 228));
            } else {
                object = BoxedUnit.UNIT;
            }
            HiveCommandSuite.withInputFile$1((Function1 & Serializable & scala.Serializable)path -> {
                HiveCommandSuite.$anonfun$testLoadData$6(this, loadQuery, path);
                return BoxedUnit.UNIT;
            }, local, testData);
            Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)16), "john"}));
            Row row3 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)16), "john"}));
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT * FROM non_part_table WHERE employeeID = 16"), (Seq)Nil$.MODULE$.$colon$colon((Object)row3).$colon$colon((Object)row2));
            HiveCommandSuite.withInputFile$1((Function1 & Serializable & scala.Serializable)path -> {
                HiveCommandSuite.$anonfun$testLoadData$8(this, loadQuery, path);
                return BoxedUnit.UNIT;
            }, local, testData);
            Row row4 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)16), "john"}));
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT * FROM non_part_table WHERE employeeID = 16"), (Seq)Nil$.MODULE$.$colon$colon((Object)row4));
            this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString("\n          |CREATE TABLE part_table (employeeID INT, employeeName STRING)\n          |PARTITIONED BY (c STRING, d STRING)\n          |ROW FORMAT DELIMITED\n          |FIELDS TERMINATED BY '|'\n          |LINES TERMINATED BY '\\n'\n        ")).stripMargin());
            HiveCommandSuite.withInputFile$1((Function1 & Serializable & scala.Serializable)f -> {
                HiveCommandSuite.$anonfun$testLoadData$10(this, loadQuery, f);
                return BoxedUnit.UNIT;
            }, local, testData);
            HiveCommandSuite.withInputFile$1((Function1 & Serializable & scala.Serializable)f -> {
                HiveCommandSuite.$anonfun$testLoadData$15(this, loadQuery, f);
                return BoxedUnit.UNIT;
            }, local, testData);
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT employeeID, employeeName FROM part_table WHERE c = '1' AND d = '2'"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])((Dataset)this.sql().apply((Object)"SELECT * FROM non_part_table")).collect()));
            HiveCommandSuite.withInputFile$1((Function1 & Serializable & scala.Serializable)f -> {
                HiveCommandSuite.$anonfun$testLoadData$17(this, loadQuery, f);
                return BoxedUnit.UNIT;
            }, local, testData);
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT employeeID, employeeName FROM part_table WHERE c = '2' AND d = '1'"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])((Dataset)this.sql().apply((Object)"SELECT * FROM non_part_table")).collect()));
        });
    }

    private final void testImplicits$lzycompute$1() {
        HiveCommandSuite hiveCommandSuite = this;
        synchronized (hiveCommandSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new SQLTestUtilsBase$testImplicits$((SQLTestUtilsBase)this);
            }
        }
    }

    private final void org$apache$spark$sql$test$SQLTestData$$internalImplicits$lzycompute$1() {
        HiveCommandSuite hiveCommandSuite = this;
        synchronized (hiveCommandSuite) {
            if (this.internalImplicits$module == null) {
                this.internalImplicits$module = new SQLTestData$internalImplicits$((SQLTestData)this);
            }
        }
    }

    private final void PatienceConfig$lzycompute$1() {
        HiveCommandSuite hiveCommandSuite = this;
        synchronized (hiveCommandSuite) {
            if (this.PatienceConfig$module == null) {
                this.PatienceConfig$module = new AbstractPatienceConfiguration$PatienceConfig$((AbstractPatienceConfiguration)this);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$new$18(HiveCommandSuite $this, boolean local) {
        String loadQuery = local ? "LOAD DATA LOCAL" : "LOAD DATA";
        $this.test(loadQuery, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.testLoadData(loadQuery, local), new Position("HiveCommandSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 164));
    }

    private static final void withInputFile$1(Function1 fn, boolean local$2, File testData$1) {
        if (local$2) {
            fn.apply((Object)testData$1);
        } else {
            File tmp = File.createTempFile(testData$1.getName(), ".tmp");
            Files.copy((File)testData$1, (File)tmp);
            try {
                fn.apply((Object)tmp);
            }
            finally {
                tmp.delete();
            }
        }
    }

    public static final /* synthetic */ void $anonfun$testLoadData$3(HiveCommandSuite $this, String loadQuery$2, boolean local$2, File path) {
        $this.sql().apply((Object)new StringBuilder(36).append(loadQuery$2).append(" INPATH \"").append(path.toURI()).append("\" INTO TABLE non_part_table").toString());
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)local$2));
        boolean $org_scalatest_assert_macro_right = path.exists();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveCommandSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 215));
    }

    public static final /* synthetic */ void $anonfun$testLoadData$6(HiveCommandSuite $this, String loadQuery$2, File path) {
        $this.sql().apply((Object)new StringBuilder(36).append(loadQuery$2).append(" INPATH \"").append(path.toURI()).append("\" INTO TABLE non_part_table").toString());
    }

    public static final /* synthetic */ void $anonfun$testLoadData$8(HiveCommandSuite $this, String loadQuery$2, File path) {
        $this.sql().apply((Object)new StringBuilder(46).append(loadQuery$2).append(" INPATH \"").append(path.toURI()).append("\" OVERWRITE INTO TABLE non_part_table").toString());
    }

    public static final /* synthetic */ void $anonfun$testLoadData$10(HiveCommandSuite $this, String loadQuery$2, File f) {
        URI path = f.toURI();
        $this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(32).append(loadQuery$2).append(" INPATH \"").append(path).append("\" INTO TABLE part_table").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("HiveCommandSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 264));
        $this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(49).append(loadQuery$2).append(" INPATH \"").append(path).append("\" INTO TABLE part_table PARTITION(c=\"1\")").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("HiveCommandSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 268));
        $this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(49).append(loadQuery$2).append(" INPATH \"").append(path).append("\" INTO TABLE part_table PARTITION(d=\"1\")").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("HiveCommandSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 271));
        $this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(56).append(loadQuery$2).append(" INPATH \"").append(path).append("\" INTO TABLE part_table PARTITION(c=\"1\", k=\"2\")").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("HiveCommandSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 274));
    }

    public static final /* synthetic */ void $anonfun$testLoadData$15(HiveCommandSuite $this, String loadQuery$2, File f) {
        $this.sql().apply((Object)new StringBuilder(56).append(loadQuery$2).append(" INPATH \"").append(f.toURI()).append("\" INTO TABLE part_table PARTITION(c=\"1\", d=\"2\")").toString());
    }

    public static final /* synthetic */ void $anonfun$testLoadData$17(HiveCommandSuite $this, String loadQuery$2, File f) {
        $this.sql().apply((Object)new StringBuilder(56).append(loadQuery$2).append(" INPATH \"").append(f.toURI()).append("\" INTO TABLE part_table PARTITION(d=\"1\", c=\"2\")").toString());
    }

    public static final /* synthetic */ Tuple3 $anonfun$new$48(int i) {
        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)i), (Object)new StringBuilder(4).append("val_").append(i).toString(), (Object)BoxesRunTime.boxToInteger((int)(i * 2)));
    }

    public HiveCommandSuite() {
        ScaledTimeSpans.$init$((ScaledTimeSpans)this);
        AbstractPatienceConfiguration.$init$((AbstractPatienceConfiguration)this);
        PatienceConfiguration.$init$((PatienceConfiguration)this);
        Eventually.$init$((Eventually)this);
        SQLTestData.$init$((SQLTestData)this);
        SQLTestUtilsBase.$init$((SQLTestUtilsBase)this);
        SQLTestUtils.$init$((SQLTestUtils)this);
        TestHiveSingleton.$init$(this);
        this.test("show tables", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"show1a", "show2b"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)"CREATE TABLE show1a(c1 int)");
            this.sql().apply((Object)"CREATE TABLE show2b(c2 int)");
            Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"default", "show1a", BoxesRunTime.boxToBoolean((boolean)false)}));
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SHOW TABLES IN default 'show1*'"), (Seq)Nil$.MODULE$.$colon$colon((Object)row));
            Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"default", "show1a", BoxesRunTime.boxToBoolean((boolean)false)}));
            Row row3 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"default", "show2b", BoxesRunTime.boxToBoolean((boolean)false)}));
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SHOW TABLES IN default 'show1*|show2*'"), (Seq)Nil$.MODULE$.$colon$colon((Object)row3).$colon$colon((Object)row2));
            Row row4 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"default", "show1a", BoxesRunTime.boxToBoolean((boolean)false)}));
            Row row5 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"default", "show2b", BoxesRunTime.boxToBoolean((boolean)false)}));
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SHOW TABLES 'show1*|show2*'"), (Seq)Nil$.MODULE$.$colon$colon((Object)row5).$colon$colon((Object)row4));
            long $org_scalatest_assert_macro_left = ((Dataset)this.sql().apply((Object)"SHOW TABLES")).count();
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), ">=", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left >= (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveCommandSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
            long $org_scalatest_assert_macro_left2 = ((Dataset)this.sql().apply((Object)"SHOW TABLES IN default")).count();
            int $org_scalatest_assert_macro_right2 = 2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left2), ">=", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 >= (long)$org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveCommandSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114));
        }), new Position("HiveCommandSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
        this.test("show tblproperties of data source tables - basic", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"my_key1", "v1"}));
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> ((Dataset)this.sql().apply((Object)"SHOW TBLPROPERTIES parquet_tab1")).filter("key = 'my_key1'"), (Seq)Nil$.MODULE$.$colon$colon((Object)row));
            Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"v1"}));
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SHOW TBLPROPERTIES parquet_tab1('my_key1')"), (Seq)Nil$.MODULE$.$colon$colon((Object)row2));
        }, new Position("HiveCommandSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 119));
        this.test("show tblproperties for datasource table - errors", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String message1;
            String $org_scalatest_assert_macro_left = message1 = ((AnalysisException)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SHOW TBLPROPERTIES badtable"), ClassTag$.MODULE$.apply(NoSuchTableException.class), new Position("HiveCommandSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132))).getMessage();
            String $org_scalatest_assert_macro_right = "Table or view 'badtable' not found in database 'default'";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveCommandSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135));
            Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Table default.parquet_tab1 does not have property: invalid.prop.key"}));
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SHOW TBLPROPERTIES parquet_tab1('invalid.prop.key')"), (Seq)Nil$.MODULE$.$colon$colon((Object)row));
        }, new Position("HiveCommandSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 131));
        this.test("show tblproperties for hive table", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SHOW TBLPROPERTIES parquet_tab2('prop1Key')"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"prop1Val"})));
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SHOW TBLPROPERTIES parquet_tab2('`prop2Key`')"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"prop2Val"})));
        }, new Position("HiveCommandSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
        this.test("show tblproperties for spark temporary table - empty row", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"parquet_temp"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TEMPORARY VIEW parquet_temp (c1 INT, c2 STRING)\n         |USING org.apache.spark.sql.parquet.DefaultSource\n        ")).stripMargin());
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SHOW TBLPROPERTIES parquet_temp"), (Seq)Nil$.MODULE$);
        }), new Position("HiveCommandSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149));
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, false}))).foreach((Function1 & Serializable & scala.Serializable)local -> {
            HiveCommandSuite.$anonfun$new$18(this, BoxesRunTime.unboxToBoolean((Object)local));
            return BoxedUnit.UNIT;
        });
        this.test("Truncate Table", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"non_part_table", "part_table"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString("\n          |CREATE TABLE non_part_table (employeeID INT, employeeName STRING)\n          |ROW FORMAT DELIMITED\n          |FIELDS TERMINATED BY '|'\n          |LINES TERMINATED BY '\\n'\n        ")).stripMargin());
            URI testData = this.hiveContext().getHiveFile("data/files/employee.dat").toURI();
            this.sql().apply((Object)new StringBuilder(51).append("LOAD DATA LOCAL INPATH \"").append(testData).append("\" INTO TABLE non_part_table").toString());
            Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)16), "john"}));
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT * FROM non_part_table WHERE employeeID = 16"), (Seq)Nil$.MODULE$.$colon$colon((Object)row));
            Row[] testResults = (Row[])((Dataset)this.sql().apply((Object)"SELECT * FROM non_part_table")).collect();
            this.sql().apply((Object)"TRUNCATE TABLE non_part_table");
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT * FROM non_part_table"), (Seq)Seq$.MODULE$.empty());
            this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString("\n          |CREATE TABLE part_table (employeeID INT, employeeName STRING)\n          |PARTITIONED BY (c STRING, d STRING)\n          |ROW FORMAT DELIMITED\n          |FIELDS TERMINATED BY '|'\n          |LINES TERMINATED BY '\\n'\n        ")).stripMargin());
            this.sql().apply((Object)new StringBuilder(71).append("LOAD DATA LOCAL INPATH \"").append(testData).append("\" INTO TABLE part_table PARTITION(c=\"1\", d=\"1\")").toString());
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT employeeID, employeeName FROM part_table WHERE c = '1' AND d = '1'"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])testResults));
            this.sql().apply((Object)new StringBuilder(71).append("LOAD DATA LOCAL INPATH \"").append(testData).append("\" INTO TABLE part_table PARTITION(c=\"1\", d=\"2\")").toString());
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT employeeID, employeeName FROM part_table WHERE c = '1' AND d = '2'"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])testResults));
            this.sql().apply((Object)new StringBuilder(71).append("LOAD DATA LOCAL INPATH \"").append(testData).append("\" INTO TABLE part_table PARTITION(c=\"2\", d=\"2\")").toString());
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT employeeID, employeeName FROM part_table WHERE c = '2' AND d = '2'"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])testResults));
            this.sql().apply((Object)"TRUNCATE TABLE part_table PARTITION(c='1', d='1')");
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT employeeID, employeeName FROM part_table WHERE c = '1' AND d = '1'"), (Seq)Seq$.MODULE$.empty());
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT employeeID, employeeName FROM part_table WHERE c = '1' AND d = '2'"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])testResults));
            this.sql().apply((Object)"TRUNCATE TABLE part_table PARTITION(c='1')");
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT employeeID, employeeName FROM part_table WHERE c = '1'"), (Seq)Seq$.MODULE$.empty());
            this.sql().apply((Object)"TRUNCATE TABLE part_table");
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT employeeID, employeeName FROM part_table"), (Seq)Seq$.MODULE$.empty());
        }), new Position("HiveCommandSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 296));
        this.test("show partitions - show everything", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"year=2015/month=1"}));
            Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"year=2015/month=2"}));
            Row row3 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"year=2016/month=2"}));
            Row row4 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"year=2016/month=3"}));
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"show partitions parquet_tab4"), (Seq)Nil$.MODULE$.$colon$colon((Object)row4).$colon$colon((Object)row3).$colon$colon((Object)row2).$colon$colon((Object)row));
            Row row5 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"year=2015/month=1"}));
            Row row6 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"year=2015/month=2"}));
            Row row7 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"year=2016/month=2"}));
            Row row8 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"year=2016/month=3"}));
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"show partitions default.parquet_tab4"), (Seq)Nil$.MODULE$.$colon$colon((Object)row8).$colon$colon((Object)row7).$colon$colon((Object)row6).$colon$colon((Object)row5));
        }, new Position("HiveCommandSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 363));
        this.test("show partitions - show everything more than 5 part keys", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"year=2016/month=3/hour=10/minute=10/sec=10/extra=1"}));
            Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"year=2016/month=4/hour=10/minute=10/sec=10/extra=1"}));
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"show partitions parquet_tab5"), (Seq)Nil$.MODULE$.$colon$colon((Object)row2).$colon$colon((Object)row));
        }, new Position("HiveCommandSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 379));
        this.test("show partitions - filter", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"year=2015/month=1"}));
            Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"year=2015/month=2"}));
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"show partitions default.parquet_tab4 PARTITION(year=2015)"), (Seq)Nil$.MODULE$.$colon$colon((Object)row2).$colon$colon((Object)row));
            Row row3 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"year=2015/month=1"}));
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"show partitions default.parquet_tab4 PARTITION(year=2015, month=1)"), (Seq)Nil$.MODULE$.$colon$colon((Object)row3));
            Row row4 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"year=2015/month=2"}));
            Row row5 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"year=2016/month=2"}));
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"show partitions default.parquet_tab4 PARTITION(month=2)"), (Seq)Nil$.MODULE$.$colon$colon((Object)row5).$colon$colon((Object)row4));
        }, new Position("HiveCommandSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 386));
        this.test("show partitions - empty row", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"parquet_temp"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String message3;
            String message2;
            String message1;
            this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TEMPORARY VIEW parquet_temp (c1 INT, c2 STRING)\n         |USING org.apache.spark.sql.parquet.DefaultSource\n        ")).stripMargin());
            this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SHOW PARTITIONS parquet_temp"), ClassTag$.MODULE$.apply(NoSuchTableException.class), new Position("HiveCommandSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 410));
            String $org_scalatest_assert_macro_left = message1 = ((AnalysisException)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SHOW PARTITIONS parquet_tab3"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("HiveCommandSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 414))).getMessage();
            String $org_scalatest_assert_macro_right = "not allowed on a table that is not partitioned";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveCommandSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 417));
            String $org_scalatest_assert_macro_left2 = message2 = ((AnalysisException)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SHOW PARTITIONS parquet_tab4 PARTITION(abcd=2015, xyz=1)"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("HiveCommandSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 419))).getMessage();
            String $org_scalatest_assert_macro_right2 = "Non-partitioning column(s) [abcd, xyz] are specified";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveCommandSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 422));
            String $org_scalatest_assert_macro_left3 = message3 = ((AnalysisException)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SHOW PARTITIONS parquet_view1"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("HiveCommandSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 424))).getMessage();
            String $org_scalatest_assert_macro_right3 = "is not allowed on a view";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveCommandSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 427));
        }), new Position("HiveCommandSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 402));
        this.test("show partitions - datasource", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"part_datasrc"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(HiveCommandSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_hive_execution_HiveCommandSuite$$typecreator5$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                }

                public Org_apache_spark_sql_hive_execution_HiveCommandSuite$$typecreator5$1(HiveCommandSuite $outer) {
                }
            }
            Dataset df = this.testImplicits().localSeqToDatasetHolder((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 3).map((Function1 & Serializable & scala.Serializable)i -> HiveCommandSuite.$anonfun$new$48(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom()), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_hive_execution_HiveCommandSuite$$typecreator5$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"}));
            df.write().partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})).format("parquet").mode(SaveMode.Overwrite).saveAsTable("part_datasrc");
            long $org_scalatest_assert_macro_left = ((Dataset)this.sql().apply((Object)"SHOW PARTITIONS part_datasrc")).count();
            int $org_scalatest_assert_macro_right = 3;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveCommandSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 440));
        }), new Position("HiveCommandSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 431));
        this.test("SPARK-25918: LOAD DATA LOCAL INPATH should handle a relative path", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            FileContext localFS = FileContext.getLocalFSFileContext();
            Path workingDir = localFS.getWorkingDirectory();
            Path r = LoadDataCommand$.MODULE$.makeQualified(FsConstants.LOCAL_FS_URI, workingDir, new Path("kv1.txt"));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(r);
            Path $org_scalatest_assert_macro_right = new Path(new StringBuilder(8).append(workingDir).append("/kv1.txt").toString());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveCommandSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 449));
        }, new Position("HiveCommandSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 444));
    }
}

