/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive;

import java.io.File;
import java.io.Serializable;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.catalyst.catalog.HiveTableRelation;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.hive.HiveUtils$;
import org.apache.spark.sql.hive.ParquetPartitioningTest;
import org.apache.spark.sql.hive.ParquetSourceSuite$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Symbol;
import scala.Tuple1;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001}1Aa\u0001\u0003\u0001\u001f!)A\u0003\u0001C\u0001+!)q\u0003\u0001C!1\t\u0011\u0002+\u0019:rk\u0016$8k\\;sG\u0016\u001cV/\u001b;f\u0015\t)a!\u0001\u0003iSZ,'BA\u0004\t\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u0013)\tQa\u001d9be.T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sO\u000e\u00011C\u0001\u0001\u0011!\t\t\"#D\u0001\u0005\u0013\t\u0019BAA\fQCJ\fX/\u001a;QCJ$\u0018\u000e^5p]&tw\rV3ti\u00061A(\u001b8jiz\"\u0012A\u0006\t\u0003#\u0001\t\u0011BY3g_J,\u0017\t\u001c7\u0015\u0003e\u0001\"AG\u000f\u000e\u0003mQ\u0011\u0001H\u0001\u0006g\u000e\fG.Y\u0005\u0003=m\u0011A!\u00168ji\u0002")
public class ParquetSourceSuite
extends ParquetPartitioningTest {
    @Override
    public void beforeAll() {
        super.beforeAll();
        this.dropTables((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partitioned_parquet", "partitioned_parquet_with_key", "partitioned_parquet_with_complextypes", "partitioned_parquet_with_key_and_complextypes", "normal_parquet"}));
        this.sql().apply((Object)new StringBuilder(134).append("\n      CREATE TEMPORARY VIEW partitioned_parquet\n      USING org.apache.spark.sql.parquet\n      OPTIONS (\n        path '").append(this.partitionedTableDir().toURI()).append("'\n      )\n    ").toString());
        this.sql().apply((Object)new StringBuilder(143).append("\n      CREATE TEMPORARY VIEW partitioned_parquet_with_key\n      USING org.apache.spark.sql.parquet\n      OPTIONS (\n        path '").append(this.partitionedTableDirWithKey().toURI()).append("'\n      )\n    ").toString());
        this.sql().apply((Object)new StringBuilder(129).append("\n      CREATE TEMPORARY VIEW normal_parquet\n      USING org.apache.spark.sql.parquet\n      OPTIONS (\n        path '").append(new File(this.partitionedTableDir(), "p=1").toURI()).append("'\n      )\n    ").toString());
        this.sql().apply((Object)new StringBuilder(160).append("\n      CREATE TEMPORARY VIEW partitioned_parquet_with_key_and_complextypes\n      USING org.apache.spark.sql.parquet\n      OPTIONS (\n        path '").append(this.partitionedTableDirWithKeyAndComplexTypes().toURI()).append("'\n      )\n    ").toString());
        this.sql().apply((Object)new StringBuilder(152).append("\n      CREATE TEMPORARY VIEW partitioned_parquet_with_complextypes\n      USING org.apache.spark.sql.parquet\n      OPTIONS (\n        path '").append(this.partitionedTableDirWithComplexTypes().toURI()).append("'\n      )\n    ").toString());
    }

    public static final /* synthetic */ Tuple1 $anonfun$new$57(int x$9) {
        return new Tuple1.mcI.sp(x$9);
    }

    public static final /* synthetic */ Tuple1 $anonfun$new$60(int x$10) {
        return new Tuple1.mcI.sp(x$10);
    }

    public static final /* synthetic */ Tuple2 $anonfun$new$80(int i) {
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)i), (Object)((Object)BoxesRunTime.boxToInteger((int)i)).toString());
    }

    public ParquetSourceSuite() {
        this.test("SPARK-6016 make sure to use the latest footers", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)"drop table if exists spark_6016_fix");
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(ParquetSourceSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_hive_ParquetSourceSuite$$typecreator5$2
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple1"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$));
                }

                public Org_apache_spark_sql_hive_ParquetSourceSuite$$typecreator5$2(ParquetSourceSuite $outer) {
                }
            }
            Dataset df1 = this.testImplicits().localSeqToDatasetHolder((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).map((Function1 & Serializable & scala.Serializable)x$9 -> ParquetSourceSuite.$anonfun$new$57(BoxesRunTime.unboxToInt((Object)x$9)), IndexedSeq$.MODULE$.canBuildFrom()), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_hive_ParquetSourceSuite$$typecreator5$2(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})).coalesce(2);
            df1.write().mode(SaveMode.Overwrite).format("parquet").saveAsTable("spark_6016_fix");
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"select * from spark_6016_fix"), (Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).map((Function1 & Serializable & scala.Serializable)i -> Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i))})), IndexedSeq$.MODULE$.canBuildFrom()));
            JavaUniverse $u2 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(ParquetSourceSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_hive_ParquetSourceSuite$$typecreator13$2
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple1"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$));
                }

                public Org_apache_spark_sql_hive_ParquetSourceSuite$$typecreator13$2(ParquetSourceSuite $outer) {
                }
            }
            Dataset df2 = this.testImplicits().localSeqToDatasetHolder((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).map((Function1 & Serializable & scala.Serializable)x$10 -> ParquetSourceSuite.$anonfun$new$60(BoxesRunTime.unboxToInt((Object)x$10)), IndexedSeq$.MODULE$.canBuildFrom()), this.testImplicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_hive_ParquetSourceSuite$$typecreator13$2(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"})).coalesce(4);
            df2.write().mode(SaveMode.Overwrite).format("parquet").saveAsTable("spark_6016_fix");
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"select * from spark_6016_fix"), (Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).map((Function1 & Serializable & scala.Serializable)i -> Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i))})), IndexedSeq$.MODULE$.canBuildFrom()));
            return (Dataset)this.sql().apply((Object)"drop table spark_6016_fix");
        }, new Position("parquetSuites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 738));
        this.test("SPARK-8811: compatibility with array of struct in Hive", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"array_of_struct"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Seq conf = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveUtils$.MODULE$.CONVERT_METASTORE_PARQUET().key()), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PARQUET_BINARY_AS_STRING().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PARQUET_WRITE_LEGACY_FORMAT().key()), (Object)"false")}));
                $this.withSQLConf((Seq<Tuple2<String, String>>)conf, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    $this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(245).append("CREATE TABLE array_of_struct\n               |STORED AS PARQUET LOCATION '").append(dir.toURI()).append("'\n               |AS SELECT\n               |  '1st' AS a,\n               |  '2nd' AS b,\n               |  ARRAY(NAMED_STRUCT('a', 'val_a', 'b', 'val_b')) AS c\n             ").toString())).stripMargin());
                    $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> $this.spark().read().parquet(dir.getCanonicalPath()), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1st", "2nd", Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"val_a", "val_b"}))}))})));
                });
            });
            return BoxedUnit.UNIT;
        }), new Position("parquetSuites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 764));
        this.test("Verify the PARQUET conversion parameter: CONVERT_METASTORE_PARQUET", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"single"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(ParquetSourceSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_hive_ParquetSourceSuite$$typecreator21$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_hive_ParquetSourceSuite$$typecreator21$1(ParquetSourceSuite $outer) {
                }
            }
            Dataset singleRowDF = this.testImplicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)0), (Object)"foo")})), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_hive_ParquetSourceSuite$$typecreator21$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key", "value"}));
            singleRowDF.createOrReplaceTempView("single");
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"true", "false"}))).foreach((Function1 & Serializable & scala.Serializable)parquetConversion -> {
                this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveUtils$.MODULE$.CONVERT_METASTORE_PARQUET().key()), (Object)parquetConversion)}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    String tableName = "test_parquet_ctas";
                    $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tableName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                        $this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(129).append("\n                 |CREATE TABLE ").append(tableName).append(" STORED AS PARQUET\n                 |AS SELECT tmp.key, tmp.value FROM single tmp\n               ").toString())).stripMargin());
                        Dataset df = $this.spark().sql(new StringBuilder(26).append("SELECT * FROM ").append(tableName).append(" WHERE key=0").toString());
                        $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> df, singleRowDF$1);
                        QueryExecution queryExecution = df.queryExecution();
                        String string = parquetConversion;
                        String string2 = "true";
                        if (!(string != null ? !string.equals(string2) : string2 != null)) {
                            queryExecution.analyzed().collectFirst((PartialFunction)new scala.Serializable(null){
                                public static final long serialVersionUID = 0L;

                                public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                                    A1 A1 = x1;
                                    Object object = A1 instanceof LogicalRelation ? BoxedUnit.UNIT : function1.apply(x1);
                                    return (B1)object;
                                }

                                public final boolean isDefinedAt(LogicalPlan x1) {
                                    LogicalPlan logicalPlan = x1;
                                    boolean bl = logicalPlan instanceof LogicalRelation;
                                    return bl;
                                }
                            }).getOrElse((Function0 & Serializable & scala.Serializable)() -> $this.fail(new StringBuilder(70).append("Expecting the query plan to convert parquet to data sources, ").append("but got:\n").append(queryExecution).toString(), new Position("parquetSuites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 813)));
                        } else {
                            queryExecution.analyzed().collectFirst((PartialFunction)new scala.Serializable(null){
                                public static final long serialVersionUID = 0L;

                                public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                                    A1 A1 = x2;
                                    Object object = A1 instanceof HiveTableRelation ? BoxedUnit.UNIT : function1.apply(x2);
                                    return (B1)object;
                                }

                                public final boolean isDefinedAt(LogicalPlan x2) {
                                    LogicalPlan logicalPlan = x2;
                                    boolean bl = logicalPlan instanceof HiveTableRelation;
                                    return bl;
                                }
                            }).getOrElse((Function0 & Serializable & scala.Serializable)() -> $this.fail(new StringBuilder(63).append("Expecting no conversion from parquet to data sources, ").append("but got:\n").append(queryExecution).toString(), new Position("parquetSuites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 820)));
                        }
                    });
                });
                return BoxedUnit.UNIT;
            });
        }), new Position("parquetSuites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 790));
        this.test("values in arrays and maps stored in parquet are always nullable", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Tuple2 tuple2 = new Tuple2((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToInteger((int)3))})), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6})));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(ParquetSourceSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_hive_ParquetSourceSuite$$typecreator25$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala.collection.immutable").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.collection.immutable.Map"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$))), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala.collection").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.collection.Seq"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_hive_ParquetSourceSuite$$typecreator25$1(ParquetSourceSuite $outer) {
                }
            }
            Dataset df = this.spark().createDataFrame((Seq)Nil$.MODULE$.$colon$colon((Object)tuple2), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_hive_ParquetSourceSuite$$typecreator25$1(null))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"m", "a"}));
            MapType mapType1 = new MapType((DataType)IntegerType$.MODULE$, (DataType)IntegerType$.MODULE$, false);
            ArrayType arrayType1 = new ArrayType((DataType)IntegerType$.MODULE$, false);
            StructField structField = new StructField("m", (DataType)mapType1, true, StructField$.MODULE$.apply$default$4());
            StructField structField2 = new StructField("a", (DataType)arrayType1, true, StructField$.MODULE$.apply$default$4());
            StructType expectedSchema1 = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField2).$colon$colon((Object)structField));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(df.schema());
            StructType $org_scalatest_assert_macro_right = expectedSchema1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("parquetSuites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 838));
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alwaysNullable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                df.write().format("parquet").saveAsTable("alwaysNullable");
                MapType mapType2 = new MapType((DataType)IntegerType$.MODULE$, (DataType)IntegerType$.MODULE$, true);
                ArrayType arrayType2 = new ArrayType((DataType)IntegerType$.MODULE$, true);
                StructField structField = new StructField("m", (DataType)mapType2, true, StructField$.MODULE$.apply$default$4());
                StructField structField2 = new StructField("a", (DataType)arrayType2, true, StructField$.MODULE$.apply$default$4());
                StructType expectedSchema2 = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField2).$colon$colon((Object)structField));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.spark().table("alwaysNullable").schema());
                StructType $org_scalatest_assert_macro_right = expectedSchema2;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("parquetSuites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 850));
                this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT m, a FROM alwaysNullable"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToInteger((int)3))})), Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6}))})));
            });
        }, new Position("parquetSuites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 830));
        this.test("Aggregation attribute names can't contain special chars \" ,;{}()\\n\\t=\"", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            File tempDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
            String filePath = new File(tempDir, "testParquet").getCanonicalPath();
            String filePath2 = new File(tempDir, "testParquet2").getCanonicalPath();
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(ParquetSourceSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_hive_ParquetSourceSuite$$typecreator30$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_hive_ParquetSourceSuite$$typecreator30$1(ParquetSourceSuite $outer) {
                }
            }
            Dataset df = this.testImplicits().localSeqToDatasetHolder((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))).map((Function1 & Serializable & scala.Serializable)i -> ParquetSourceSuite.$anonfun$new$80(BoxesRunTime.unboxToInt((Object)i)), Seq$.MODULE$.canBuildFrom()), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_hive_ParquetSourceSuite$$typecreator30$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"int", "str"}));
            Dataset df2 = df.as((Symbol)SymbolLiteral.bootstrap("apply", "x")).join(df.as((Symbol)SymbolLiteral.bootstrap("apply", "y")), this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"x.str"}))).$((Seq)Nil$.MODULE$).$eq$eq$eq((Object)this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"y.str"}))).$((Seq)Nil$.MODULE$))).groupBy("y.str", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).max((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"y.int"}));
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> df2.write().parquet(filePath), ClassTag$.MODULE$.apply(Throwable.class), new Position("parquetSuites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 865));
            Dataset df3 = df2.toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"str", "max_int"}));
            df3.write().parquet(filePath2);
            Dataset df4 = this.spark().read().parquet(filePath2);
            Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1", BoxesRunTime.boxToInteger((int)1)}));
            Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"2", BoxesRunTime.boxToInteger((int)2)}));
            Row row3 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"3", BoxesRunTime.boxToInteger((int)3)}));
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> df4, (Seq)Nil$.MODULE$.$colon$colon((Object)row3).$colon$colon((Object)row2).$colon$colon((Object)row));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(df4.columns());
            String[] $org_scalatest_assert_macro_right = (String[])((Object[])new String[]{"str", "max_int"});
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("parquetSuites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 871));
        }, new Position("parquetSuites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 858));
    }
}

