/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.jetty.plus.webapp;

import java.util.Random;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import org.spark_project.jetty.plus.jndi.Transaction;
import org.spark_project.jetty.plus.webapp.PlusDecorator;
import org.spark_project.jetty.plus.webapp.PlusDescriptorProcessor;
import org.spark_project.jetty.util.log.Log;
import org.spark_project.jetty.util.log.Logger;
import org.spark_project.jetty.webapp.AbstractConfiguration;
import org.spark_project.jetty.webapp.DescriptorProcessor;
import org.spark_project.jetty.webapp.WebAppContext;

public class PlusConfiguration
extends AbstractConfiguration {
    private static final Logger LOG = Log.getLogger(PlusConfiguration.class);
    private Integer _key;

    public void preConfigure(WebAppContext context) throws Exception {
        context.getObjectFactory().addDecorator(new PlusDecorator(context));
    }

    public void cloneConfigure(WebAppContext template, WebAppContext context) throws Exception {
        context.getObjectFactory().addDecorator(new PlusDecorator(context));
    }

    public void configure(WebAppContext context) throws Exception {
        this.bindUserTransaction(context);
        context.getMetaData().addDescriptorProcessor((DescriptorProcessor)new PlusDescriptorProcessor());
    }

    public void postConfigure(WebAppContext context) throws Exception {
        this.lockCompEnv(context);
    }

    public void deconfigure(WebAppContext context) throws Exception {
        this.unlockCompEnv(context);
        this._key = null;
        context.setAttribute("org.spark_project.jetty.injectionCollection", null);
        context.setAttribute("org.spark_project.jetty.lifecyleCallbackCollection", null);
    }

    public void bindUserTransaction(WebAppContext context) throws Exception {
        try {
            Transaction.bindToENC();
        }
        catch (NameNotFoundException e) {
            LOG.debug("No Transaction manager found - if your webapp requires one, please configure one.", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void lockCompEnv(WebAppContext wac) throws Exception {
        ClassLoader old_loader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(wac.getClassLoader());
        try {
            Random random = new Random();
            this._key = random.nextInt();
            InitialContext context = new InitialContext();
            Context compCtx = (Context)context.lookup("java:comp");
            compCtx.addToEnvironment("org.spark_project.jetty.jndi.lock", this._key);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old_loader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unlockCompEnv(WebAppContext wac) throws Exception {
        if (this._key != null) {
            ClassLoader old_loader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(wac.getClassLoader());
            try {
                InitialContext context = new InitialContext();
                Context compCtx = (Context)context.lookup("java:comp");
                compCtx.addToEnvironment("org.spark_project.jetty.jndi.unlock", this._key);
            }
            finally {
                Thread.currentThread().setContextClassLoader(old_loader);
            }
        }
    }
}

