/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.client;

import java.io.Serializable;
import java.util.List;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.spark.SparkException;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogStatistics;
import org.apache.spark.sql.catalyst.catalog.CatalogStatistics$;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.CatalogUtils$;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser$;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.apache.spark.sql.hive.HiveExternalCatalog$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.math.Ordered;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class HiveClientImpl$ {
    public static HiveClientImpl$ MODULE$;
    private final Set<String> org$apache$spark$sql$hive$client$HiveClientImpl$$HiveStatisticsProperties;

    static {
        new HiveClientImpl$();
    }

    public FieldSchema toHiveColumn(StructField c) {
        String typeString = c.metadata().contains(org.apache.spark.sql.types.package$.MODULE$.HIVE_TYPE_STRING()) ? c.metadata().getString(org.apache.spark.sql.types.package$.MODULE$.HIVE_TYPE_STRING()) : c.dataType().catalogString();
        return new FieldSchema(c.name(), typeString, (String)c.getComment().orNull(Predef$.MODULE$.$conforms()));
    }

    private DataType getSparkSQLDataType(FieldSchema hc) {
        DataType dataType;
        try {
            dataType = CatalystSqlParser$.MODULE$.parseDataType(hc.getType());
        }
        catch (ParseException e) {
            throw new SparkException(new StringBuilder(35).append("Cannot recognize hive type string: ").append(hc.getType()).toString(), (Throwable)e);
        }
        return dataType;
    }

    public StructField fromHiveColumn(FieldSchema hc) {
        DataType columnType = this.getSparkSQLDataType(hc);
        String string = hc.getType();
        String string2 = columnType.catalogString();
        Metadata metadata = (string == null ? string2 != null : !string.equals(string2)) ? new MetadataBuilder().putString(org.apache.spark.sql.types.package$.MODULE$.HIVE_TYPE_STRING(), hc.getType()).build() : Metadata$.MODULE$.empty();
        StructField field = new StructField(hc.getName(), columnType, true, metadata);
        return (StructField)Option$.MODULE$.apply((Object)hc.getComment()).map((Function1 & Serializable & scala.Serializable)comment -> field.withComment(comment)).getOrElse((Function0 & Serializable & scala.Serializable)() -> field);
    }

    public void org$apache$spark$sql$hive$client$HiveClientImpl$$verifyColumnDataType(StructType schema) {
        schema.foreach((Function1 & Serializable & scala.Serializable)col -> MODULE$.getSparkSQLDataType(MODULE$.toHiveColumn((StructField)col)));
    }

    private Class<? extends InputFormat<?, ?>> toInputFormat(String name) {
        return Utils$.MODULE$.classForName(name);
    }

    private Class<? extends HiveOutputFormat<?, ?>> toOutputFormat(String name) {
        return Utils$.MODULE$.classForName(name);
    }

    /*
     * Enabled aggressive block sorting
     */
    public Table toHiveTable(CatalogTable table, Option<String> userName) {
        TableType tableType;
        Table hiveTable = new Table(table.database(), table.identifier().table());
        CatalogTableType catalogTableType = table.tableType();
        CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.EXTERNAL();
        CatalogTableType catalogTableType3 = catalogTableType;
        if (!(catalogTableType2 != null ? !catalogTableType2.equals(catalogTableType3) : catalogTableType3 != null)) {
            hiveTable.setProperty("EXTERNAL", "TRUE");
            tableType = TableType.EXTERNAL_TABLE;
        } else {
            CatalogTableType catalogTableType4 = CatalogTableType$.MODULE$.MANAGED();
            CatalogTableType catalogTableType5 = catalogTableType;
            if (!(catalogTableType4 != null ? !catalogTableType4.equals(catalogTableType5) : catalogTableType5 != null)) {
                tableType = TableType.MANAGED_TABLE;
            } else {
                CatalogTableType catalogTableType6 = CatalogTableType$.MODULE$.VIEW();
                CatalogTableType catalogTableType7 = catalogTableType;
                if (catalogTableType6 == null) {
                    if (catalogTableType7 != null) {
                        throw new IllegalArgumentException(new StringBuilder(44).append("Unknown table type is found at toHiveTable: ").append(catalogTableType).toString());
                    }
                } else if (!catalogTableType6.equals(catalogTableType7)) throw new IllegalArgumentException(new StringBuilder(44).append("Unknown table type is found at toHiveTable: ").append(catalogTableType).toString());
                tableType = TableType.VIRTUAL_VIEW;
            }
        }
        hiveTable.setTableType(tableType);
        Tuple2 tuple2 = ((TraversableLike)table.schema().map((Function1 & Serializable & scala.Serializable)c -> MODULE$.toHiveColumn((StructField)c), Seq$.MODULE$.canBuildFrom())).partition((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)HiveClientImpl$.$anonfun$toHiveTable$2(table, c)));
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Seq partCols = (Seq)tuple2._1();
        Seq schema = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)partCols, (Object)schema);
        Tuple2 tuple23 = tuple22;
        Seq partCols2 = (Seq)tuple23._1();
        Seq schema2 = (Seq)tuple23._2();
        hiveTable.setFields((List)JavaConverters$.MODULE$.seqAsJavaListConverter(schema2).asJava());
        hiveTable.setPartCols((List)JavaConverters$.MODULE$.seqAsJavaListConverter(partCols2).asJava());
        Option$.MODULE$.apply((Object)table.owner()).filter((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)HiveClientImpl$.$anonfun$toHiveTable$3(x$18))).orElse((Function0 & Serializable & scala.Serializable)() -> userName).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            hiveTable.setOwner(x$1);
            return BoxedUnit.UNIT;
        });
        hiveTable.setCreateTime((int)(table.createTime() / 1000L));
        hiveTable.setLastAccessTime((int)(table.lastAccessTime() / 1000L));
        table.storage().locationUri().map((Function1 & Serializable & scala.Serializable)uri -> CatalogUtils$.MODULE$.URIToString(uri)).foreach((Function1 & Serializable & scala.Serializable)loc -> {
            HiveClientImpl$.$anonfun$toHiveTable$7(hiveTable, loc);
            return BoxedUnit.UNIT;
        });
        table.storage().inputFormat().map((Function1 & Serializable & scala.Serializable)name -> MODULE$.toInputFormat((String)name)).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            hiveTable.setInputFormatClass(x$1);
            return BoxedUnit.UNIT;
        });
        table.storage().outputFormat().map((Function1 & Serializable & scala.Serializable)name -> MODULE$.toOutputFormat((String)name)).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            hiveTable.setOutputFormatClass(x$1);
            return BoxedUnit.UNIT;
        });
        hiveTable.setSerializationLib((String)table.storage().serde().getOrElse((Function0 & Serializable & scala.Serializable)() -> "org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe"));
        table.storage().properties().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            String string = hiveTable.setSerdeParam(k, v);
            return string;
        });
        table.properties().foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            HiveClientImpl$.$anonfun$toHiveTable$14(hiveTable, x0$2);
            return BoxedUnit.UNIT;
        });
        table.comment().foreach((Function1 & Serializable & scala.Serializable)c -> {
            hiveTable.setProperty("comment", c);
            return BoxedUnit.UNIT;
        });
        table.viewText().foreach((Function1 & Serializable & scala.Serializable)t -> {
            HiveClientImpl$.$anonfun$toHiveTable$16(hiveTable, t);
            return BoxedUnit.UNIT;
        });
        Option option = table.bucketSpec();
        if (option instanceof Some) {
            Some some = (Some)option;
            BucketSpec bucketSpec = (BucketSpec)some.value();
            if (!HiveExternalCatalog$.MODULE$.isDatasourceTable(table)) {
                BoxedUnit boxedUnit;
                hiveTable.setNumBuckets(bucketSpec.numBuckets());
                hiveTable.setBucketCols((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)bucketSpec.bucketColumnNames().toList()).asJava());
                if (bucketSpec.sortColumnNames().nonEmpty()) {
                    hiveTable.setSortCols((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)bucketSpec.sortColumnNames().map((Function1 & Serializable & scala.Serializable)col -> new Order(col, BaseSemanticAnalyzer.HIVE_COLUMN_ORDER_ASC), Seq$.MODULE$.canBuildFrom())).toList()).asJava());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
                return hiveTable;
            }
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        return hiveTable;
    }

    public Option<String> toHiveTable$default$2() {
        return None$.MODULE$;
    }

    public Partition toHivePartition(CatalogTablePartition p, Table ht) {
        org.apache.hadoop.hive.metastore.api.Partition tpart = new org.apache.hadoop.hive.metastore.api.Partition();
        Buffer partValues = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(ht.getPartCols()).asScala()).map((Function1 & Serializable & scala.Serializable)hc -> (String)p.spec().get((Object)hc.getName()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(49).append("Partition spec is missing a value for column '").append(hc.getName()).append("': ").append(p.spec()).toString());
        }), Buffer$.MODULE$.canBuildFrom());
        StorageDescriptor storageDesc = new StorageDescriptor();
        SerDeInfo serdeInfo = new SerDeInfo();
        p.storage().locationUri().map((Function1 & Serializable & scala.Serializable)x$19 -> CatalogUtils$.MODULE$.URIToString(x$19)).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            storageDesc.setLocation(x$1);
            return BoxedUnit.UNIT;
        });
        p.storage().inputFormat().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            storageDesc.setInputFormat(x$1);
            return BoxedUnit.UNIT;
        });
        p.storage().outputFormat().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            storageDesc.setOutputFormat(x$1);
            return BoxedUnit.UNIT;
        });
        p.storage().serde().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            serdeInfo.setSerializationLib(x$1);
            return BoxedUnit.UNIT;
        });
        serdeInfo.setParameters((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)p.storage().properties()).asJava());
        storageDesc.setSerdeInfo(serdeInfo);
        tpart.setDbName(ht.getDbName());
        tpart.setTableName(ht.getTableName());
        tpart.setValues((List)JavaConverters$.MODULE$.bufferAsJavaListConverter(partValues).asJava());
        tpart.setSd(storageDesc);
        tpart.setCreateTime((int)(p.createTime() / 1000L));
        tpart.setLastAccessTime((int)(p.lastAccessTime() / 1000L));
        tpart.setParameters((java.util.Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)Map$.MODULE$.apply(p.parameters().toSeq())).asJava());
        return new Partition(ht, tpart);
    }

    public CatalogTablePartition fromHivePartition(Partition hp) {
        org.apache.hadoop.hive.metastore.api.Partition apiPartition = hp.getTPartition();
        scala.collection.immutable.Map properties = hp.getParameters() != null ? ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(hp.getParameters()).asScala()).toMap(Predef$.MODULE$.$conforms()) : Predef$.MODULE$.Map().empty();
        scala.collection.immutable.Map x$1 = (scala.collection.immutable.Map)Option$.MODULE$.apply((Object)hp.getSpec()).map((Function1 & Serializable & scala.Serializable)x$20 -> ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)x$20).asScala()).toMap(Predef$.MODULE$.$conforms())).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty());
        CatalogStorageFormat x$2 = new CatalogStorageFormat(Option$.MODULE$.apply((Object)CatalogUtils$.MODULE$.stringToURI(apiPartition.getSd().getLocation())), Option$.MODULE$.apply((Object)apiPartition.getSd().getInputFormat()), Option$.MODULE$.apply((Object)apiPartition.getSd().getOutputFormat()), Option$.MODULE$.apply((Object)apiPartition.getSd().getSerdeInfo().getSerializationLib()), apiPartition.getSd().isCompressed(), (scala.collection.immutable.Map)Option$.MODULE$.apply((Object)apiPartition.getSd().getSerdeInfo().getParameters()).map((Function1 & Serializable & scala.Serializable)x$21 -> ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(x$21).asScala()).toMap(Predef$.MODULE$.$conforms())).orNull(Predef$.MODULE$.$conforms()));
        long x$3 = (long)apiPartition.getCreateTime() * 1000L;
        long x$4 = (long)apiPartition.getLastAccessTime() * 1000L;
        scala.collection.immutable.Map x$5 = properties;
        Option<CatalogStatistics> x$6 = this.org$apache$spark$sql$hive$client$HiveClientImpl$$readHiveStats((scala.collection.immutable.Map<String, String>)properties);
        return new CatalogTablePartition(x$1, x$2, x$5, x$3, x$4, x$6);
    }

    public Option<CatalogStatistics> org$apache$spark$sql$hive$client$HiveClientImpl$$readHiveStats(scala.collection.immutable.Map<String, String> properties) {
        Option totalSize = properties.get((Object)"totalSize").map((Function1 & Serializable & scala.Serializable)x$22 -> package$.MODULE$.BigInt().apply(x$22));
        Option rawDataSize = properties.get((Object)"rawDataSize").map((Function1 & Serializable & scala.Serializable)x$23 -> package$.MODULE$.BigInt().apply(x$23));
        Option rowCount = properties.get((Object)"numRows").map((Function1 & Serializable & scala.Serializable)x$24 -> package$.MODULE$.BigInt().apply(x$24));
        return totalSize.isDefined() && ((Ordered)totalSize.get()).$greater((Object)BigInt$.MODULE$.long2bigInt(0L)) ? new Some((Object)new CatalogStatistics((BigInt)totalSize.get(), rowCount.filter((Function1 & Serializable & scala.Serializable)x$25 -> BoxesRunTime.boxToBoolean((boolean)x$25.$greater((Object)BigInt$.MODULE$.int2bigInt(0)))), CatalogStatistics$.MODULE$.apply$default$3())) : (rawDataSize.isDefined() && ((Ordered)rawDataSize.get()).$greater((Object)BigInt$.MODULE$.int2bigInt(0)) ? new Some((Object)new CatalogStatistics((BigInt)rawDataSize.get(), rowCount.filter((Function1 & Serializable & scala.Serializable)x$26 -> BoxesRunTime.boxToBoolean((boolean)x$26.$greater((Object)BigInt$.MODULE$.int2bigInt(0)))), CatalogStatistics$.MODULE$.apply$default$3())) : None$.MODULE$);
    }

    public Set<String> org$apache$spark$sql$hive$client$HiveClientImpl$$HiveStatisticsProperties() {
        return this.org$apache$spark$sql$hive$client$HiveClientImpl$$HiveStatisticsProperties;
    }

    public static final /* synthetic */ boolean $anonfun$toHiveTable$2(CatalogTable table$11, FieldSchema c) {
        return table$11.partitionColumnNames().contains((Object)c.getName());
    }

    public static final /* synthetic */ boolean $anonfun$toHiveTable$3(String x$18) {
        return new StringOps(Predef$.MODULE$.augmentString(x$18)).nonEmpty();
    }

    public static final /* synthetic */ void $anonfun$toHiveTable$7(Table hiveTable$4, String loc) {
        hiveTable$4.getTTable().getSd().setLocation(loc);
    }

    public static final /* synthetic */ void $anonfun$toHiveTable$14(Table hiveTable$4, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String k = (String)tuple2._1();
        String v = (String)tuple2._2();
        hiveTable$4.setProperty(k, v);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$toHiveTable$16(Table hiveTable$4, String t) {
        hiveTable$4.setViewOriginalText(t);
        hiveTable$4.setViewExpandedText(t);
    }

    private HiveClientImpl$() {
        MODULE$ = this;
        this.org$apache$spark$sql$hive$client$HiveClientImpl$$HiveStatisticsProperties = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"COLUMN_STATS_ACCURATE", "numFiles", "numPartitions", "numRows", "rawDataSize", "totalSize"}));
    }
}

