/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.execution;

import java.io.Serializable;
import java.net.URI;
import org.apache.hadoop.hive.serde2.RegexSerDe;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.plans.PlanTest;
import org.apache.spark.sql.catalyst.plans.PlanTestBase;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.command.CreateTableCommand;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.datasources.CreateTable;
import org.apache.spark.sql.execution.metric.InputOutputMetricsHelper$;
import org.apache.spark.sql.hive.execution.HiveComparisonTest;
import org.apache.spark.sql.hive.test.TestHive$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.StructType;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u000193A!\u0002\u0004\u0001'!)a\u0005\u0001C\u0001O!)\u0011\u0006\u0001C!U!)\u0011\u0007\u0001C\u0005e!)1\n\u0001C\u0005\u0019\nq\u0001*\u001b<f'\u0016\u0014H)Z*vSR,'BA\u0004\t\u0003%)\u00070Z2vi&|gN\u0003\u0002\n\u0015\u0005!\u0001.\u001b<f\u0015\tYA\"A\u0002tc2T!!\u0004\b\u0002\u000bM\u0004\u0018M]6\u000b\u0005=\u0001\u0012AB1qC\u000eDWMC\u0001\u0012\u0003\ry'oZ\u0002\u0001'\u0011\u0001A\u0003\u0007\u0011\u0011\u0005U1R\"\u0001\u0004\n\u0005]1!A\u0005%jm\u0016\u001cu.\u001c9be&\u001cxN\u001c+fgR\u0004\"!\u0007\u0010\u000e\u0003iQ!a\u0007\u000f\u0002\u000bAd\u0017M\\:\u000b\u0005uQ\u0011\u0001C2bi\u0006d\u0017p\u001d;\n\u0005}Q\"\u0001\u0003)mC:$Vm\u001d;\u0011\u0005\u0005\"S\"\u0001\u0012\u000b\u0005\r\u0002\u0012!C:dC2\fG/Z:u\u0013\t)#EA\tCK\u001a|'/Z!oI\u00063G/\u001a:BY2\fa\u0001P5oSRtD#\u0001\u0015\u0011\u0005U\u0001\u0011!\u00032fM>\u0014X-\u00117m)\u0005Y\u0003C\u0001\u00170\u001b\u0005i#\"\u0001\u0018\u0002\u000bM\u001c\u0017\r\\1\n\u0005Aj#\u0001B+oSR\f\u0001#\u001a=ue\u0006\u001cG\u000fV1cY\u0016$Um]2\u0015\u0005Mz\u0004\u0003\u0002\u00175mqJ!!N\u0017\u0003\rQ+\b\u000f\\33!\t9$(D\u00019\u0015\tID$A\u0004dCR\fGn\\4\n\u0005mB$\u0001D\"bi\u0006dwn\u001a+bE2,\u0007C\u0001\u0017>\u0013\tqTFA\u0004C_>dW-\u00198\t\u000b-\u0019\u0001\u0019\u0001!\u0011\u0005\u0005CeB\u0001\"G!\t\u0019U&D\u0001E\u0015\t)%#\u0001\u0004=e>|GOP\u0005\u0003\u000f6\na\u0001\u0015:fI\u00164\u0017BA%K\u0005\u0019\u0019FO]5oO*\u0011q)L\u0001\u0013C:\fG.\u001f>f\u0007J,\u0017\r^3UC\ndW\r\u0006\u00027\u001b\")1\u0002\u0002a\u0001\u0001\u0002")
public class HiveSerDeSuite
extends HiveComparisonTest
implements PlanTest {
    public SQLConf conf() {
        return PlanTestBase.conf$((PlanTestBase)this);
    }

    public LogicalPlan normalizeExprIds(LogicalPlan plan) {
        return PlanTestBase.normalizeExprIds$((PlanTestBase)this, (LogicalPlan)plan);
    }

    public LogicalPlan normalizePlan(LogicalPlan plan) {
        return PlanTestBase.normalizePlan$((PlanTestBase)this, (LogicalPlan)plan);
    }

    public void comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        PlanTestBase.comparePlans$((PlanTestBase)this, (LogicalPlan)plan1, (LogicalPlan)plan2, (boolean)checkAnalysis);
    }

    public boolean comparePlans$default$3() {
        return PlanTestBase.comparePlans$default$3$((PlanTestBase)this);
    }

    public void compareExpressions(Expression e1, Expression e2) {
        PlanTestBase.compareExpressions$((PlanTestBase)this, (Expression)e1, (Expression)e2);
    }

    public void compareJoinOrder(LogicalPlan plan1, LogicalPlan plan2) {
        PlanTestBase.compareJoinOrder$((PlanTestBase)this, (LogicalPlan)plan1, (LogicalPlan)plan2);
    }

    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        PlanTestBase.withSQLConf$((PlanTestBase)this, pairs, f);
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Expression replaceAlias(Expression condition, AttributeMap<Expression> aliases) {
        return PredicateHelper.replaceAlias$((PredicateHelper)this, (Expression)condition, aliases);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.canEvaluate$((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$((PredicateHelper)this, (Expression)expr);
    }

    public void beforeAll() {
        super.beforeAll();
        TestHive$.MODULE$.setCacheTables(false);
        TestHive$.MODULE$.sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(157).append("CREATE TABLE IF NOT EXISTS sales (key STRING, value INT)\n       |ROW FORMAT SERDE '").append(RegexSerDe.class.getCanonicalName()).append("'\n       |WITH SERDEPROPERTIES (\"input.regex\" = \"([^ ]*)\t([^ ]*)\")\n       ").toString())).stripMargin());
        TestHive$.MODULE$.sql(new StringBuilder(42).append("LOAD DATA LOCAL INPATH '").append(TestHive$.MODULE$.getHiveFile("data/files/sales.txt").toURI()).append("' INTO TABLE sales").toString());
    }

    private Tuple2<CatalogTable, Object> extractTableDesc(String sql) {
        return (Tuple2)TestHive$.MODULE$.sessionState().sqlParser().parsePlan(sql).collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof CreateTable) {
                    SaveMode mode;
                    CreateTable createTable = (CreateTable)A1;
                    CatalogTable tableDesc = createTable.tableDesc();
                    SaveMode saveMode = mode = createTable.mode();
                    SaveMode saveMode2 = SaveMode.Ignore;
                    object = new Tuple2((Object)tableDesc, (Object)BoxesRunTime.boxToBoolean((!(saveMode != null ? !saveMode.equals(saveMode2) : saveMode2 != null) ? 1 : 0) != 0));
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan = x1;
                boolean bl = logicalPlan instanceof CreateTable;
                return bl;
            }
        }).head();
    }

    private CatalogTable analyzeCreateTable(String sql) {
        return (CatalogTable)TestHive$.MODULE$.sessionState().analyzer().execute(TestHive$.MODULE$.sessionState().sqlParser().parsePlan(sql)).collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof CreateTableCommand) {
                    CreateTableCommand createTableCommand = (CreateTableCommand)A1;
                    CatalogTable tableDesc = createTableCommand.table();
                    object = tableDesc;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan = x1;
                boolean bl = logicalPlan instanceof CreateTableCommand;
                return bl;
            }
        }).head();
    }

    public HiveSerDeSuite() {
        PredicateHelper.$init$((PredicateHelper)this);
        PlanTestBase.$init$((PlanTestBase)this);
        this.createQueryTest("Read with RegexSerDe", "SELECT * FROM sales", false, this.createQueryTest$default$4(), this.createQueryTest$default$5());
        this.createQueryTest("Read and write with LazySimpleSerDe (tab separated)", "SELECT * from serdeins", this.createQueryTest$default$3(), this.createQueryTest$default$4(), this.createQueryTest$default$5());
        this.createQueryTest("Read with AvroSerDe", "SELECT * FROM episodes", this.createQueryTest$default$3(), this.createQueryTest$default$4(), this.createQueryTest$default$5());
        this.createQueryTest("Read Partitioned with AvroSerDe", "SELECT * FROM episodes_part", this.createQueryTest$default$3(), this.createQueryTest$default$4(), this.createQueryTest$default$5());
        this.test("Checking metrics correctness", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            long episodesCnt = TestHive$.MODULE$.sql("select * from episodes").count();
            List episodesRes = InputOutputMetricsHelper$.MODULE$.run(TestHive$.MODULE$.sql("select * from episodes").toDF());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(episodesRes);
            Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToLong((long)episodesCnt), (Object)BoxesRunTime.boxToLong((long)0L), (Object)BoxesRunTime.boxToLong((long)episodesCnt));
            List $org_scalatest_assert_macro_right = Nil$.MODULE$.$colon$colon((Object)tuple3);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
            long serdeinsCnt = TestHive$.MODULE$.sql("select * from serdeins").count();
            List serdeinsRes = InputOutputMetricsHelper$.MODULE$.run(TestHive$.MODULE$.sql("select * from serdeins").toDF());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(serdeinsRes);
            Tuple3 tuple32 = new Tuple3((Object)BoxesRunTime.boxToLong((long)serdeinsCnt), (Object)BoxesRunTime.boxToLong((long)0L), (Object)BoxesRunTime.boxToLong((long)serdeinsCnt));
            List $org_scalatest_assert_macro_right2 = Nil$.MODULE$.$colon$colon((Object)tuple32);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
        }, new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
        this.test("Test the default fileformat for Hive-serde tables", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hive.default.fileformat"), (Object)"orc")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Tuple2<CatalogTable, Object> tuple2 = this.extractTableDesc("CREATE TABLE IF NOT EXISTS fileformat_test (id int)");
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                CatalogTable desc = (CatalogTable)tuple2._1();
                boolean exists = tuple2._2$mcZ$sp();
                Tuple2 tuple22 = new Tuple2((Object)desc, (Object)BoxesRunTime.boxToBoolean((boolean)exists));
                Tuple2 tuple23 = tuple22;
                CatalogTable desc2 = (CatalogTable)tuple23._1();
                boolean exists2 = tuple23._2$mcZ$sp();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(exists2, "exists", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
                Option $org_scalatest_assert_macro_left = desc2.storage().inputFormat();
                Some $org_scalatest_assert_macro_right = new Some((Object)"org.apache.hadoop.hive.ql.io.orc.OrcInputFormat");
                Option option = $org_scalatest_assert_macro_left;
                Some some = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(option != null ? !option.equals(some) : some != null), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88));
                Option $org_scalatest_assert_macro_left2 = desc2.storage().outputFormat();
                Some $org_scalatest_assert_macro_right2 = new Some((Object)"org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat");
                Option option2 = $org_scalatest_assert_macro_left2;
                Some some2 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(option2 != null ? !option2.equals(some2) : some2 != null), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
                Option $org_scalatest_assert_macro_left3 = desc2.storage().serde();
                Some $org_scalatest_assert_macro_right3 = new Some((Object)"org.apache.hadoop.hive.ql.io.orc.OrcSerde");
                Option option3 = $org_scalatest_assert_macro_left3;
                Some some3 = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(option3 != null ? !option3.equals(some3) : some3 != null), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
            });
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hive.default.fileformat"), (Object)"parquet")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Tuple2<CatalogTable, Object> tuple2 = this.extractTableDesc("CREATE TABLE IF NOT EXISTS fileformat_test (id int)");
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                CatalogTable desc = (CatalogTable)tuple2._1();
                boolean exists = tuple2._2$mcZ$sp();
                Tuple2 tuple22 = new Tuple2((Object)desc, (Object)BoxesRunTime.boxToBoolean((boolean)exists));
                Tuple2 tuple23 = tuple22;
                CatalogTable desc2 = (CatalogTable)tuple23._1();
                boolean exists2 = tuple23._2$mcZ$sp();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(exists2, "exists", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
                Option input = desc2.storage().inputFormat();
                Option output = desc2.storage().outputFormat();
                Option serde = desc2.storage().serde();
                Option $org_scalatest_assert_macro_left = input;
                Some $org_scalatest_assert_macro_right = new Some((Object)"org.apache.hadoop.hive.ql.io.parquet.MapredParquetInputFormat");
                Option option = $org_scalatest_assert_macro_left;
                Some some = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(option != null ? !option.equals(some) : some != null), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
                Option $org_scalatest_assert_macro_left2 = output;
                Some $org_scalatest_assert_macro_right2 = new Some((Object)"org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat");
                Option option2 = $org_scalatest_assert_macro_left2;
                Some some2 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(option2 != null ? !option2.equals(some2) : some2 != null), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
                Option $org_scalatest_assert_macro_left3 = serde;
                Some $org_scalatest_assert_macro_right3 = new Some((Object)"org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe");
                Option option3 = $org_scalatest_assert_macro_left3;
                Some some3 = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(option3 != null ? !option3.equals(some3) : some3 != null), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101));
            });
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hive.default.fileformat"), (Object)"orc")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Tuple2<CatalogTable, Object> tuple2 = this.extractTableDesc("CREATE TABLE IF NOT EXISTS fileformat_test (id int) STORED AS textfile");
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                CatalogTable desc = (CatalogTable)tuple2._1();
                boolean exists = tuple2._2$mcZ$sp();
                Tuple2 tuple22 = new Tuple2((Object)desc, (Object)BoxesRunTime.boxToBoolean((boolean)exists));
                Tuple2 tuple23 = tuple22;
                CatalogTable desc2 = (CatalogTable)tuple23._1();
                boolean exists2 = tuple23._2$mcZ$sp();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(exists2, "exists", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
                Option $org_scalatest_assert_macro_left = desc2.storage().inputFormat();
                Some $org_scalatest_assert_macro_right = new Some((Object)"org.apache.hadoop.mapred.TextInputFormat");
                Option option = $org_scalatest_assert_macro_left;
                Some some = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(option != null ? !option.equals(some) : some != null), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108));
                Option $org_scalatest_assert_macro_left2 = desc2.storage().outputFormat();
                Some $org_scalatest_assert_macro_right2 = new Some((Object)"org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat");
                Option option2 = $org_scalatest_assert_macro_left2;
                Some some2 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(option2 != null ? !option2.equals(some2) : some2 != null), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
                Option $org_scalatest_assert_macro_left3 = desc2.storage().serde();
                Some $org_scalatest_assert_macro_right3 = new Some((Object)"org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe");
                Option option3 = $org_scalatest_assert_macro_left3;
                Some some3 = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(option3 != null ? !option3.equals(some3) : some3 != null), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111));
            });
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hive.default.fileformat"), (Object)"orc")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Tuple2<CatalogTable, Object> tuple2 = this.extractTableDesc("CREATE TABLE IF NOT EXISTS fileformat_test (id int) STORED AS sequencefile");
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                CatalogTable desc = (CatalogTable)tuple2._1();
                boolean exists = tuple2._2$mcZ$sp();
                Tuple2 tuple22 = new Tuple2((Object)desc, (Object)BoxesRunTime.boxToBoolean((boolean)exists));
                Tuple2 tuple23 = tuple22;
                CatalogTable desc2 = (CatalogTable)tuple23._1();
                boolean exists2 = tuple23._2$mcZ$sp();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(exists2, "exists", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117));
                Option $org_scalatest_assert_macro_left = desc2.storage().inputFormat();
                Some $org_scalatest_assert_macro_right = new Some((Object)"org.apache.hadoop.mapred.SequenceFileInputFormat");
                Option option = $org_scalatest_assert_macro_left;
                Some some = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(option != null ? !option.equals(some) : some != null), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
                Option $org_scalatest_assert_macro_left2 = desc2.storage().outputFormat();
                Some $org_scalatest_assert_macro_right2 = new Some((Object)"org.apache.hadoop.mapred.SequenceFileOutputFormat");
                Option option2 = $org_scalatest_assert_macro_left2;
                Some some2 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(option2 != null ? !option2.equals(some2) : some2 != null), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 119));
                Option $org_scalatest_assert_macro_left3 = desc2.storage().serde();
                Some $org_scalatest_assert_macro_right3 = new Some((Object)"org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe");
                Option option3 = $org_scalatest_assert_macro_left3;
                Some some3 = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(option3 != null ? !option3.equals(some3) : some3 != null), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
            });
        }, new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
        this.test("create hive serde table with new syntax - basic", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE t\n        |(id int, name string COMMENT 'blabla')\n        |USING hive\n        |OPTIONS (fileFormat 'parquet', my_prop 1)\n        |LOCATION '/tmp/file'\n        |COMMENT 'BLABLA'\n      ")).stripMargin();
            CatalogTable table = this.analyzeCreateTable(sql);
            StructType $org_scalatest_assert_macro_left = table.schema();
            StructType $org_scalatest_assert_macro_right = new StructType().add("id", "int").add("name", "string", true, "blabla");
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
            Option $org_scalatest_assert_macro_left2 = table.provider();
            Some $org_scalatest_assert_macro_right2 = new Some((Object)DDLUtils$.MODULE$.HIVE_PROVIDER());
            Option option = $org_scalatest_assert_macro_left2;
            Some some = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(option != null ? !option.equals(some) : some != null), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139));
            Option $org_scalatest_assert_macro_left3 = table.storage().locationUri();
            Some $org_scalatest_assert_macro_right3 = new Some((Object)new URI("/tmp/file"));
            Option option2 = $org_scalatest_assert_macro_left3;
            Some some2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(option2 != null ? !option2.equals(some2) : some2 != null), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 140));
            Map $org_scalatest_assert_macro_left4 = table.storage().properties();
            Map $org_scalatest_assert_macro_right4 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"my_prop"), (Object)"1")}));
            Map map = $org_scalatest_assert_macro_left4;
            Map map2 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(map != null ? !map.equals(map2) : map2 != null), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 141));
            Option $org_scalatest_assert_macro_left5 = table.comment();
            Some $org_scalatest_assert_macro_right5 = new Some((Object)"BLABLA");
            Option option3 = $org_scalatest_assert_macro_left5;
            Some some3 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(option3 != null ? !option3.equals(some3) : some3 != null), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 142));
            Option $org_scalatest_assert_macro_left6 = table.storage().inputFormat();
            Some $org_scalatest_assert_macro_right6 = new Some((Object)"org.apache.hadoop.hive.ql.io.parquet.MapredParquetInputFormat");
            Option option4 = $org_scalatest_assert_macro_left6;
            Some some4 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right6, !(option4 != null ? !option4.equals(some4) : some4 != null), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
            Option $org_scalatest_assert_macro_left7 = table.storage().outputFormat();
            Some $org_scalatest_assert_macro_right7 = new Some((Object)"org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat");
            Option option5 = $org_scalatest_assert_macro_left7;
            Some some5 = $org_scalatest_assert_macro_right7;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "==", (Object)$org_scalatest_assert_macro_right7, !(option5 != null ? !option5.equals(some5) : some5 != null), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 146));
            Option $org_scalatest_assert_macro_left8 = table.storage().serde();
            Some $org_scalatest_assert_macro_right8 = new Some((Object)"org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe");
            Option option6 = $org_scalatest_assert_macro_left8;
            Some some6 = $org_scalatest_assert_macro_right8;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right8, !(option6 != null ? !option6.equals(some6) : some6 != null), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148));
        }, new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
        this.test("create hive serde table with new syntax - with partition and bucketing", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String v1 = "CREATE TABLE t (c1 int, c2 int) USING hive PARTITIONED BY (c2)";
            CatalogTable table = this.analyzeCreateTable(v1);
            StructType $org_scalatest_assert_macro_left = table.schema();
            StructType $org_scalatest_assert_macro_right = new StructType().add("c1", "int").add("c2", "int");
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 155));
            Seq $org_scalatest_assert_macro_left2 = table.partitionColumnNames();
            Seq $org_scalatest_assert_macro_right2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c2"}));
            Seq seq = $org_scalatest_assert_macro_left2;
            Seq seq2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(seq != null ? !seq.equals(seq2) : seq2 != null), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 156));
            Option $org_scalatest_assert_macro_left3 = table.storage().serde();
            Some $org_scalatest_assert_macro_right3 = new Some((Object)"org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe");
            Option option = $org_scalatest_assert_macro_left3;
            Some some = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(option != null ? !option.equals(some) : some != null), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 158));
            Option $org_scalatest_assert_macro_left4 = table.storage().inputFormat();
            Some $org_scalatest_assert_macro_right4 = new Some((Object)"org.apache.hadoop.mapred.TextInputFormat");
            Option option2 = $org_scalatest_assert_macro_left4;
            Some some2 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(option2 != null ? !option2.equals(some2) : some2 != null), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 159));
            Option $org_scalatest_assert_macro_left5 = table.storage().outputFormat();
            Some $org_scalatest_assert_macro_right5 = new Some((Object)"org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat");
            Option option3 = $org_scalatest_assert_macro_left5;
            Some some3 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(option3 != null ? !option3.equals(some3) : some3 != null), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 160));
            String v2 = "CREATE TABLE t (c1 int, c2 int) USING hive CLUSTERED BY (c2) INTO 4 BUCKETS";
            AnalysisException e2 = (AnalysisException)this.intercept((Function0 & Serializable & scala.Serializable)() -> this.analyzeCreateTable(v2), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 164));
            String $org_scalatest_assert_macro_left6 = e2.message();
            String $org_scalatest_assert_macro_right6 = "Creating bucketed Hive serde table is not supported yet";
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "contains", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.contains($org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 165));
            String v3 = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE t (c1 int, c2 int) USING hive\n        |PARTITIONED BY (c2)\n        |CLUSTERED BY (c2) INTO 4 BUCKETS")).stripMargin();
            AnalysisException e3 = (AnalysisException)this.intercept((Function0 & Serializable & scala.Serializable)() -> this.analyzeCreateTable(v3), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 172));
            String $org_scalatest_assert_macro_left7 = e3.message();
            String $org_scalatest_assert_macro_right7 = "Creating bucketed Hive serde table is not supported yet";
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "contains", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.contains($org_scalatest_assert_macro_right7), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 173));
        }, new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 152));
        this.test("create hive serde table with new syntax - Hive options error checking", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String v1 = "CREATE TABLE t (c1 int) USING hive OPTIONS (inputFormat 'abc')";
            IllegalArgumentException e1 = (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> this.analyzeCreateTable(v1), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 178));
            String $org_scalatest_assert_macro_left = e1.getMessage();
            String $org_scalatest_assert_macro_right = "Cannot specify only inputFormat or outputFormat";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 179));
            String v2 = "CREATE TABLE t (c1 int) USING hive OPTIONS (fileFormat 'x', inputFormat 'a', outputFormat 'b')";
            IllegalArgumentException e2 = (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> this.analyzeCreateTable(v2), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 183));
            String $org_scalatest_assert_macro_left2 = e2.getMessage();
            String $org_scalatest_assert_macro_right2 = "Cannot specify fileFormat and inputFormat/outputFormat together";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 184));
            String v3 = "CREATE TABLE t (c1 int) USING hive OPTIONS (fileFormat 'parquet', serde 'a')";
            IllegalArgumentException e3 = (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> this.analyzeCreateTable(v3), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 188));
            String $org_scalatest_assert_macro_left3 = e3.getMessage();
            String $org_scalatest_assert_macro_right3 = "fileFormat 'parquet' already specifies a serde";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 189));
            String v4 = "CREATE TABLE t (c1 int) USING hive OPTIONS (serde 'a', fieldDelim ' ')";
            IllegalArgumentException e4 = (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> this.analyzeCreateTable(v4), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 192));
            String $org_scalatest_assert_macro_left4 = e4.getMessage();
            String $org_scalatest_assert_macro_right4 = "Cannot specify delimiters with a custom serde";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "contains", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.contains($org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 193));
            String v5 = "CREATE TABLE t (c1 int) USING hive OPTIONS (fieldDelim ' ')";
            IllegalArgumentException e5 = (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> this.analyzeCreateTable(v5), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 196));
            String $org_scalatest_assert_macro_left5 = e5.getMessage();
            String $org_scalatest_assert_macro_right5 = "Cannot specify delimiters without fileFormat";
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "contains", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.contains($org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 197));
            String v6 = "CREATE TABLE t (c1 int) USING hive OPTIONS (fileFormat 'parquet', fieldDelim ' ')";
            IllegalArgumentException e6 = (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> this.analyzeCreateTable(v6), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 200));
            String $org_scalatest_assert_macro_left6 = e6.getMessage();
            String $org_scalatest_assert_macro_right6 = "Cannot specify delimiters as they are only compatible with fileFormat 'textfile'";
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "contains", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.contains($org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 201));
            String v7 = "CREATE TABLE t (c1 int) USING hive OPTIONS (fileFormat 'TEXTFILE', lineDelim ',')";
            IllegalArgumentException e7 = (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> this.analyzeCreateTable(v7), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 206));
            String $org_scalatest_assert_macro_left7 = e7.getMessage();
            String $org_scalatest_assert_macro_right7 = "Hive data source only support newline '\\n' as line delimiter";
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "contains", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.contains($org_scalatest_assert_macro_right7), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 207));
            String v8 = "CREATE TABLE t (c1 int) USING hive OPTIONS (fileFormat 'wrong')";
            IllegalArgumentException e8 = (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> this.analyzeCreateTable(v8), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 210));
            String $org_scalatest_assert_macro_left8 = e8.getMessage();
            String $org_scalatest_assert_macro_right8 = "invalid fileFormat: 'wrong'";
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "contains", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.contains($org_scalatest_assert_macro_right8), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 211));
        }, new Position("HiveSerDeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 176));
    }
}

