/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.client;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.util.LinkedHashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.FunctionIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier$;
import org.apache.spark.sql.catalyst.analysis.NoSuchDatabaseException;
import org.apache.spark.sql.catalyst.analysis.NoSuchPermanentFunctionException;
import org.apache.spark.sql.catalyst.catalog.CatalogDatabase;
import org.apache.spark.sql.catalyst.catalog.CatalogFunction;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTable$;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition$;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.EqualTo;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.util.package$;
import org.apache.spark.sql.hive.HiveExternalCatalog;
import org.apache.spark.sql.hive.HiveUtils$;
import org.apache.spark.sql.hive.client.HiveClient;
import org.apache.spark.sql.hive.client.HiveClientBuilder$;
import org.apache.spark.sql.hive.test.TestHiveVersion;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.tags.ExtendedHiveTest;
import org.apache.spark.util.MutableURLClassLoader;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Ignore;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ExtendedHiveTest
@Ignore
@ScalaSignature(bytes="\u0006\u0001\u0005Mb\u0001B\b\u0011\u0001uAQ\u0001\u000b\u0001\u0005\u0002%BQ\u0001\f\u0001\u0005\u00125BQ!\u0011\u0001\u0005\u0012\tCQ\u0001\u0017\u0001\u0005\neCq!\u001a\u0001C\u0002\u0013%a\r\u0003\u0004m\u0001\u0001\u0006Ia\u001a\u0005\b[\u0002\u0011\r\u0011\"\u0003o\u0011\u0019)\b\u0001)A\u0005_\"9\u0011\u0003\u0001a\u0001\n\u00131\bb\u0002>\u0001\u0001\u0004%Ia\u001f\u0005\u0007}\u0002\u0001\u000b\u0015B<\t\u0011}\u0004\u0001\u0019!C\u0005\u0003\u0003A\u0011\"a\u0004\u0001\u0001\u0004%I!!\u0005\t\u0011\u0005U\u0001\u0001)Q\u0005\u0003\u0007\u0011QBV3sg&|gn]*vSR,'BA\t\u0013\u0003\u0019\u0019G.[3oi*\u00111\u0003F\u0001\u0005Q&4XM\u0003\u0002\u0016-\u0005\u00191/\u001d7\u000b\u0005]A\u0012!B:qCJ\\'BA\r\u001b\u0003\u0019\t\u0007/Y2iK*\t1$A\u0002pe\u001e\u001c\u0001aE\u0002\u0001=\t\u0002\"a\b\u0011\u000e\u0003YI!!\t\f\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f!\t\u0019c%D\u0001%\u0015\t)c#\u0001\u0005j]R,'O\\1m\u0013\t9CEA\u0004M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?)\u0005Q\u0003CA\u0016\u0001\u001b\u0005\u0001\u0012aC<ji\"$V-\u001c9ESJ$\"A\f\u001b\u0011\u0005=\u0012T\"\u0001\u0019\u000b\u0003E\nQa]2bY\u0006L!a\r\u0019\u0003\tUs\u0017\u000e\u001e\u0005\u0006k\t\u0001\rAN\u0001\u0002MB!qfN\u001d/\u0013\tA\u0004GA\u0005Gk:\u001cG/[8ocA\u0011!hP\u0007\u0002w)\u0011A(P\u0001\u0003S>T\u0011AP\u0001\u0005U\u00064\u0018-\u0003\u0002Aw\t!a)\u001b7f\u0003%9\u0018\u000e\u001e5UC\ndW\r\u0006\u0002D\u0011R\u0011a\u0006\u0012\u0005\u0007k\r!\t\u0019A#\u0011\u0007=2e&\u0003\u0002Ha\tAAHY=oC6,g\bC\u0003J\u0007\u0001\u0007!*\u0001\u0006uC\ndWMT1nKN\u00042aL&N\u0013\ta\u0005G\u0001\u0006=e\u0016\u0004X-\u0019;fIz\u0002\"AT+\u000f\u0005=\u001b\u0006C\u0001)1\u001b\u0005\t&B\u0001*\u001d\u0003\u0019a$o\\8u}%\u0011A\u000bM\u0001\u0007!J,G-\u001a4\n\u0005Y;&AB*ue&twM\u0003\u0002Ua\u0005\tr-\u001a;OKN$X\rZ'fgN\fw-Z:\u0015\u00055S\u0006\"B.\u0005\u0001\u0004a\u0016!A3\u0011\u0005u\u0013gB\u00010a\u001d\t\u0001v,C\u00012\u0013\t\t\u0007'A\u0004qC\u000e\\\u0017mZ3\n\u0005\r$'!\u0003+ie><\u0018M\u00197f\u0015\t\t\u0007'\u0001\u0005f[B$\u0018\u0010R5s+\u00059\u0007C\u00015l\u001b\u0005I'B\u00016>\u0003\u0011a\u0017M\\4\n\u0005YK\u0017!C3naRLH)\u001b:!\u0003!1XM]:j_:\u001cX#A8\u0011\u0007A\u001cx-D\u0001r\u0015\t\u0011\b'\u0001\u0006d_2dWm\u0019;j_:L!\u0001^9\u0003\u0007M+\u0017/A\u0005wKJ\u001c\u0018n\u001c8tAU\tq\u000f\u0005\u0002,q&\u0011\u0011\u0010\u0005\u0002\u000b\u0011&4Xm\u00117jK:$\u0018AC2mS\u0016tGo\u0018\u0013fcR\u0011a\u0006 \u0005\b{*\t\t\u00111\u0001x\u0003\rAH%M\u0001\bG2LWM\u001c;!\u000311XM]:j_:\u001c\u0006/\u0019:l+\t\t\u0019\u0001\u0005\u0003\u0002\u0006\u0005-QBAA\u0004\u0015\r\tIAE\u0001\u0005i\u0016\u001cH/\u0003\u0003\u0002\u000e\u0005\u001d!a\u0004+fgRD\u0015N^3WKJ\u001c\u0018n\u001c8\u0002!Y,'o]5p]N\u0003\u0018M]6`I\u0015\fHc\u0001\u0018\u0002\u0014!AQ0DA\u0001\u0002\u0004\t\u0019!A\u0007wKJ\u001c\u0018n\u001c8Ta\u0006\u00148\u000e\t\u0015\u0004\u0001\u0005e\u0001\u0003BA\u000e\u0003Ci!!!\b\u000b\u0007\u0005}!$A\u0005tG\u0006d\u0017\r^3ti&!\u00111EA\u000f\u0005\u0019IuM\\8sK\"\u001a\u0001!a\n\u0011\t\u0005%\u0012qF\u0007\u0003\u0003WQ1!!\f\u0017\u0003\u0011!\u0018mZ:\n\t\u0005E\u00121\u0006\u0002\u0011\u000bb$XM\u001c3fI\"Kg/\u001a+fgR\u0004")
public class VersionsSuite
extends SparkFunSuite {
    private final String emptyDir;
    private final Seq<String> versions;
    private HiveClient client;
    private TestHiveVersion versionSpark;

    public void withTempDir(Function1<File, BoxedUnit> f) {
        File dir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()).getCanonicalFile();
        try {
            f.apply((Object)dir);
        }
        finally {
            Utils$.MODULE$.deleteRecursively(dir);
        }
    }

    public void withTable(Seq<String> tableNames, Function0<BoxedUnit> f) {
        try {
            f.apply$mcV$sp();
        }
        finally {
            tableNames.foreach((Function1 & Serializable & scala.Serializable)name -> this.versionSpark().sql(new StringBuilder(21).append("DROP TABLE IF EXISTS ").append((String)name).toString()));
        }
    }

    /*
     * WARNING - void declaration
     */
    private String getNestedMessages(Throwable e) {
        void var2_2;
        String causes = "";
        for (Throwable lastException = e; lastException != null; lastException = lastException.getCause()) {
            causes = new StringBuilder(1).append(causes).append(lastException.toString()).append("\n").toString();
        }
        return var2_2;
    }

    private String emptyDir() {
        return this.emptyDir;
    }

    private Seq<String> versions() {
        return this.versions;
    }

    private HiveClient client() {
        return this.client;
    }

    private void client_$eq(HiveClient x$1) {
        this.client = x$1;
    }

    private TestHiveVersion versionSpark() {
        return this.versionSpark;
    }

    private void versionSpark_$eq(TestHiveVersion x$1) {
        this.versionSpark = x$1;
    }

    private static final CatalogTable table$1(String database, String tableName) {
        TableIdentifier x$1 = new TableIdentifier(tableName, (Option)new Some((Object)database));
        CatalogTableType x$2 = CatalogTableType$.MODULE$.MANAGED();
        StructType x$3 = new StructType().add("key", "int");
        CatalogStorageFormat x$4 = new CatalogStorageFormat((Option)None$.MODULE$, (Option)new Some((Object)TextInputFormat.class.getName()), (Option)new Some((Object)HiveIgnoreKeyTextOutputFormat.class.getName()), (Option)new Some((Object)LazySimpleSerDe.class.getName()), false, Predef$.MODULE$.Map().empty());
        Option x$5 = CatalogTable$.MODULE$.apply$default$5();
        Seq x$6 = CatalogTable$.MODULE$.apply$default$6();
        Option x$7 = CatalogTable$.MODULE$.apply$default$7();
        String x$8 = CatalogTable$.MODULE$.apply$default$8();
        long x$9 = CatalogTable$.MODULE$.apply$default$9();
        long x$10 = CatalogTable$.MODULE$.apply$default$10();
        String x$11 = CatalogTable$.MODULE$.apply$default$11();
        Map x$12 = CatalogTable$.MODULE$.apply$default$12();
        Option x$13 = CatalogTable$.MODULE$.apply$default$13();
        Option x$14 = CatalogTable$.MODULE$.apply$default$14();
        Option x$15 = CatalogTable$.MODULE$.apply$default$15();
        Seq x$16 = CatalogTable$.MODULE$.apply$default$16();
        boolean x$17 = CatalogTable$.MODULE$.apply$default$17();
        boolean x$18 = CatalogTable$.MODULE$.apply$default$18();
        Map x$19 = CatalogTable$.MODULE$.apply$default$19();
        return new CatalogTable(x$1, x$2, x$4, x$3, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19);
    }

    public static final /* synthetic */ void $anonfun$new$10(VersionsSuite $this, File tmpDir) {
        CatalogDatabase dbWithNullDesc = new CatalogDatabase("dbWithNullDesc", null, tmpDir.toURI(), (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
        $this.client().createDatabase(dbWithNullDesc, true);
        String $org_scalatest_assert_macro_left = $this.client().getDatabase("dbWithNullDesc").description();
        String $org_scalatest_assert_macro_right = "";
        String string = $org_scalatest_assert_macro_left;
        String string2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 174));
    }

    public static final /* synthetic */ boolean $anonfun$new$31(String x$1) {
        String string = x$1;
        String string2 = "0.14";
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ CatalogTablePartition $anonfun$new$34(CatalogStorageFormat storageFormat$1, int key2) {
        return new CatalogTablePartition((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key1"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key2"), (Object)((Object)BoxesRunTime.boxToInteger((int)key2)).toString())})), storageFormat$1, CatalogTablePartition$.MODULE$.apply$default$3(), CatalogTablePartition$.MODULE$.apply$default$4(), CatalogTablePartition$.MODULE$.apply$default$5(), CatalogTablePartition$.MODULE$.apply$default$6());
    }

    public static final /* synthetic */ String $anonfun$new$36(int key2) {
        return new StringBuilder(12).append("key1=1/key2=").append(key2).toString();
    }

    public static final /* synthetic */ boolean $anonfun$new$48(String x$2) {
        String string = x$2;
        String string2 = "1.2";
        return string == null ? string2 != null : !string.equals(string2);
    }

    private static final CatalogFunction function$1(String name, String className) {
        return new CatalogFunction(new FunctionIdentifier(name, (Option)new Some((Object)"default")), className, (Seq)Seq$.MODULE$.empty());
    }

    public static final /* synthetic */ long $anonfun$new$80(String x$4) {
        return new StringOps(Predef$.MODULE$.augmentString(x$4)).toLong();
    }

    public static final /* synthetic */ long $anonfun$new$81(String x$5) {
        return new StringOps(Predef$.MODULE$.augmentString(x$5)).toLong();
    }

    public static final /* synthetic */ long $anonfun$new$82(String x$6) {
        return new StringOps(Predef$.MODULE$.augmentString(x$6)).toLong();
    }

    public static final /* synthetic */ long $anonfun$new$83(String x$7) {
        return new StringOps(Predef$.MODULE$.augmentString(x$7)).toLong();
    }

    public static final /* synthetic */ Dataset $anonfun$new$87(VersionsSuite $this, int i) {
        return $this.versionSpark().sql(new StringBuilder(36).append("INSERT OVERWRITE TABLE tab SELECT '").append(i).append("'").toString());
    }

    private static final List listFiles$1(File path2) {
        File[] dir = path2.listFiles();
        List folders = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dir)).filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.isDirectory())))).toList();
        List filePaths = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dir)).map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.getName(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toList();
        List list = (List)folders.flatMap((Function1 & Serializable & scala.Serializable)path -> VersionsSuite.listFiles$1(path), List$.MODULE$.canBuildFrom());
        return (List)filePaths.$plus$plus$colon((Traversable)list, List$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ void $anonfun$new$93(VersionsSuite $this, File dir) {
        String path = dir.toURI().toString();
        String tableName = "spark_13709";
        String tempTableName = "spark_13709_temp";
        new File(dir.getAbsolutePath(), tableName).mkdir();
        new File(dir.getAbsolutePath(), tempTableName).mkdir();
        String avroSchema = new StringOps(Predef$.MODULE$.augmentString("{\n            |  \"name\": \"test_record\",\n            |  \"type\": \"record\",\n            |  \"fields\": [ {\n            |    \"name\": \"f0\",\n            |    \"type\": \"int\"\n            |  }, {\n            |    \"name\": \"f1\",\n            |    \"type\": {\n            |      \"type\": \"record\",\n            |      \"name\": \"inner\",\n            |      \"fields\": [ {\n            |        \"name\": \"f10\",\n            |        \"type\": \"int\"\n            |      }, {\n            |        \"name\": \"f11\",\n            |        \"type\": \"double\"\n            |      } ]\n            |    }\n            |  } ]\n            |}\n          ")).stripMargin();
        $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tableName, tempTableName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.versionSpark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(455).append("CREATE EXTERNAL TABLE ").append(tableName).append("\n               |PARTITIONED BY (ds STRING)\n               |ROW FORMAT SERDE 'org.apache.hadoop.hive.serde2.avro.AvroSerDe'\n               |STORED AS\n               |  INPUTFORMAT 'org.apache.hadoop.hive.ql.io.avro.AvroContainerInputFormat'\n               |  OUTPUTFORMAT 'org.apache.hadoop.hive.ql.io.avro.AvroContainerOutputFormat'\n               |LOCATION '").append(path).append("/").append(tableName).append("'\n               |TBLPROPERTIES ('avro.schema.literal' = '").append(avroSchema).append("')\n           ").toString())).stripMargin());
            $this.versionSpark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(412).append("CREATE EXTERNAL TABLE ").append(tempTableName).append("\n               |ROW FORMAT SERDE 'org.apache.hadoop.hive.serde2.avro.AvroSerDe'\n               |STORED AS\n               |  INPUTFORMAT 'org.apache.hadoop.hive.ql.io.avro.AvroContainerInputFormat'\n               |  OUTPUTFORMAT 'org.apache.hadoop.hive.ql.io.avro.AvroContainerOutputFormat'\n               |LOCATION '").append(path).append("/").append(tempTableName).append("'\n               |TBLPROPERTIES ('avro.schema.literal' = '").append(avroSchema).append("')\n           ").toString())).stripMargin());
            $this.versionSpark().sql(new StringBuilder(48).append("INSERT OVERWRITE TABLE ").append(tempTableName).append(" SELECT 1, STRUCT(2, 2.5)").toString());
            $this.versionSpark().sql(new StringBuilder(52).append("ALTER TABLE ").append(tableName).append(" ADD PARTITION (ds = 'foo') LOCATION '").append(path).append("/").append(tempTableName).append("'").toString());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer($this.versionSpark().sql(new StringBuilder(14).append("SELECT * FROM ").append(tableName).toString()).collect());
            Row[] $org_scalatest_assert_macro_right = (Row[])((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToDouble((double)2.5)})), "foo"}))});
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 788));
        });
    }

    public static final /* synthetic */ void $anonfun$new$105(VersionsSuite $this, File dir) {
        String avroSchema = new StringOps(Predef$.MODULE$.augmentString("\n            |{\n            |  \"name\": \"test_record\",\n            |  \"type\": \"record\",\n            |  \"fields\": [{\n            |    \"name\": \"f0\",\n            |    \"type\": [\n            |      \"null\",\n            |      {\n            |        \"precision\": 38,\n            |        \"scale\": 2,\n            |        \"type\": \"bytes\",\n            |        \"logicalType\": \"decimal\"\n            |      }\n            |    ]\n            |  }]\n            |}\n          ")).stripMargin();
        File schemaFile = new File(dir, "avroDecimal.avsc");
        PrintWriter writer = new PrintWriter(schemaFile);
        writer.write(avroSchema);
        writer.close();
        String schemaPath = schemaFile.toURI().toString();
        URL url = Thread.currentThread().getContextClassLoader().getResource("avroDecimal");
        String srcLocation = new File(url.getFile()).toURI().toString();
        String destTableName = "tab1";
        String srcTableName = "tab2";
        $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{srcTableName, destTableName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.versionSpark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(493).append("\n               |CREATE EXTERNAL TABLE ").append(srcTableName).append("\n               |ROW FORMAT SERDE 'org.apache.hadoop.hive.serde2.avro.AvroSerDe'\n               |WITH SERDEPROPERTIES ('respectSparkSchema' = 'true')\n               |STORED AS\n               |  INPUTFORMAT 'org.apache.hadoop.hive.ql.io.avro.AvroContainerInputFormat'\n               |  OUTPUTFORMAT 'org.apache.hadoop.hive.ql.io.avro.AvroContainerOutputFormat'\n               |LOCATION '").append(srcLocation).append("'\n               |TBLPROPERTIES ('avro.schema.url' = '").append(schemaPath).append("')\n           ").toString())).stripMargin());
            $this.versionSpark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(456).append("\n               |CREATE TABLE ").append(destTableName).append("\n               |ROW FORMAT SERDE 'org.apache.hadoop.hive.serde2.avro.AvroSerDe'\n               |WITH SERDEPROPERTIES ('respectSparkSchema' = 'true')\n               |STORED AS\n               |  INPUTFORMAT 'org.apache.hadoop.hive.ql.io.avro.AvroContainerInputFormat'\n               |  OUTPUTFORMAT 'org.apache.hadoop.hive.ql.io.avro.AvroContainerOutputFormat'\n               |TBLPROPERTIES ('avro.schema.url' = '").append(schemaPath).append("')\n           ").toString())).stripMargin());
            $this.versionSpark().sql(new StringBuilder(38).append("INSERT OVERWRITE TABLE ").append(destTableName).append(" SELECT * FROM ").append(srcTableName).toString());
            Row[] result = (Row[])$this.versionSpark().table(srcTableName).collect();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer($this.versionSpark().table(destTableName).collect());
            Row[] $org_scalatest_assert_macro_right = result;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 972));
            $this.versionSpark().sql(new StringBuilder(33).append("INSERT INTO TABLE ").append(destTableName).append(" SELECT * FROM ").append(srcTableName).toString());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.versionSpark().table(destTableName).collect())).toSeq());
            Row[] $org_scalatest_assert_macro_right2 = (Row[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])result)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])result)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Row.class)));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 975));
        });
    }

    public static final /* synthetic */ void $anonfun$new$6(VersionsSuite $this, String version) {
        $this.test(new StringBuilder(15).append(version).append(": create client").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Configuration hadoopConf;
            block5: {
                block4: {
                    $this.client_$eq(null);
                    System.gc();
                    hadoopConf = new Configuration();
                    hadoopConf.set("test", "success");
                    String string = version;
                    String string2 = "2.0";
                    if (!(string == null ? string2 != null : !string.equals(string2))) break block4;
                    String string3 = version;
                    String string4 = "2.1";
                    if (!(string3 == null ? string4 != null : !string3.equals(string4))) break block4;
                    String string5 = version;
                    String string6 = "2.2";
                    if (!(string5 == null ? string6 != null : !string5.equals(string6))) break block4;
                    String string7 = version;
                    String string8 = "2.3";
                    if (string7 != null ? !string7.equals(string8) : string8 != null) break block5;
                }
                hadoopConf.set("datanucleus.schema.autoCreateAll", "true");
                hadoopConf.set("hive.metastore.schema.verification", "false");
            }
            $this.client_$eq(HiveClientBuilder$.MODULE$.buildClient(version, hadoopConf, (Map<String, String>)HiveUtils$.MODULE$.formatTimeVarsForHiveClient(hadoopConf), HiveClientBuilder$.MODULE$.buildClient$default$4()));
            if ($this.versionSpark() != null) {
                $this.versionSpark().reset();
            }
            $this.versionSpark_$eq(new TestHiveVersion($this.client()));
            String $org_scalatest_assert_macro_left = ((HiveExternalCatalog)$this.versionSpark().sharedState().externalCatalog().unwrapped()).client().version().fullVersion();
            String $org_scalatest_assert_macro_right = version;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "startsWith", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.startsWith($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 121));
        URI tempDatabasePath = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()).toURI();
        $this.test(new StringBuilder(16).append(version).append(": createDatabase").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            CatalogDatabase defaultDB = new CatalogDatabase("default", "desc", new URI("loc"), (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
            $this.client().createDatabase(defaultDB, true);
            CatalogDatabase tempDB = new CatalogDatabase("temporary", "test create", tempDatabasePath, (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
            $this.client().createDatabase(tempDB, true);
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 161));
        $this.test(new StringBuilder(38).append(version).append(": createDatabase with null description").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmpDir -> {
            VersionsSuite.$anonfun$new$10($this, tmpDir);
            return BoxedUnit.UNIT;
        }), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 169));
        $this.test(new StringBuilder(20).append(version).append(": setCurrentDatabase").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.client().setCurrentDatabase("default"), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 178));
        $this.test(new StringBuilder(13).append(version).append(": getDatabase").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            $this.client().getDatabase("default");
            return (NoSuchDatabaseException)$this.intercept((Function0 & Serializable & scala.Serializable)() -> $this.client().getDatabase("nonexist"), ClassTag$.MODULE$.apply(NoSuchDatabaseException.class), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 185));
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 182));
        $this.test(new StringBuilder(16).append(version).append(": databaseExists").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            boolean $org_scalatest_assert_macro_left = $this.client().databaseExists("default");
            boolean $org_scalatest_assert_macro_right = true;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 189));
            boolean $org_scalatest_assert_macro_left2 = $this.client().databaseExists("nonexist");
            boolean $org_scalatest_assert_macro_right2 = false;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 190));
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 188));
        $this.test(new StringBuilder(15).append(version).append(": listDatabases").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Seq $org_scalatest_assert_macro_left = $this.client().listDatabases("defau.*");
            Seq $org_scalatest_assert_macro_right = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default"}));
            Seq seq = $org_scalatest_assert_macro_left;
            Seq seq2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(seq != null ? !seq.equals(seq2) : seq2 != null), Prettifier$.MODULE$.default());
            return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 194));
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 193));
        $this.test(new StringBuilder(15).append(version).append(": alterDatabase").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            CatalogDatabase qual$1 = $this.client().getDatabase("temporary");
            Map x$1 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"flag"), (Object)"true")}));
            String x$2 = qual$1.copy$default$1();
            String x$3 = qual$1.copy$default$2();
            URI x$4 = qual$1.copy$default$3();
            CatalogDatabase database = qual$1.copy(x$2, x$3, x$4, x$1);
            $this.client().alterDatabase(database);
            Map $org_scalatest_assert_macro_left = $this.client().getDatabase("temporary").properties();
            String $org_scalatest_assert_macro_right = "flag";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 200));
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 197));
        $this.test(new StringBuilder(14).append(version).append(": dropDatabase").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            boolean $org_scalatest_assert_macro_left = $this.client().databaseExists("temporary");
            boolean $org_scalatest_assert_macro_right = true;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 204));
            $this.client().dropDatabase("temporary", false, true);
            boolean $org_scalatest_assert_macro_left2 = $this.client().databaseExists("temporary");
            boolean $org_scalatest_assert_macro_right2 = false;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 206));
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 203));
        $this.test(new StringBuilder(13).append(version).append(": createTable").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.client().createTable(VersionsSuite.table$1("default", "src"), false);
            $this.client().createTable(VersionsSuite.table$1("default", "temporary"), false);
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 213));
        $this.test(new StringBuilder(11).append(version).append(": loadTable").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.client().loadTable($this.emptyDir(), "src", false, false), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 218));
        $this.test(new StringBuilder(13).append(version).append(": tableExists").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool($this.client().tableExists("default", "src"), "VersionsSuite.this.client.tableExists(\"default\", \"src\")", Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 228));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool($this.client().tableExists("default", "nonexistent"), "VersionsSuite.this.client.tableExists(\"default\", \"nonexistent\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 229));
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 226));
        $this.test(new StringBuilder(10).append(version).append(": getTable").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> $this.client().getTable("default", "src"), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 232));
        $this.test(new StringBuilder(16).append(version).append(": getTableOption").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool($this.client().getTableOption("default", "src").isDefined(), "VersionsSuite.this.client.getTableOption(\"default\", \"src\").isDefined", Prettifier$.MODULE$.default());
            return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 238));
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 237));
        $this.test(new StringBuilder(33).append(version).append(": alterTable(table: CatalogTable)").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            CatalogTable qual$2 = $this.client().getTable("default", "src");
            Map x$5 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"changed"), (Object)"")}));
            TableIdentifier x$6 = qual$2.copy$default$1();
            CatalogTableType x$7 = qual$2.copy$default$2();
            CatalogStorageFormat x$8 = qual$2.copy$default$3();
            StructType x$9 = qual$2.copy$default$4();
            Option x$10 = qual$2.copy$default$5();
            Seq x$11 = qual$2.copy$default$6();
            Option x$12 = qual$2.copy$default$7();
            String x$13 = qual$2.copy$default$8();
            long x$14 = qual$2.copy$default$9();
            long x$15 = qual$2.copy$default$10();
            String x$16 = qual$2.copy$default$11();
            Option x$17 = qual$2.copy$default$13();
            Option x$18 = qual$2.copy$default$14();
            Option x$19 = qual$2.copy$default$15();
            Seq x$20 = qual$2.copy$default$16();
            boolean x$21 = qual$2.copy$default$17();
            boolean x$22 = qual$2.copy$default$18();
            Map x$23 = qual$2.copy$default$19();
            CatalogTable newTable = qual$2.copy(x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$5, x$17, x$18, x$19, x$20, x$21, x$22, x$23);
            $this.client().alterTable(newTable);
            Map $org_scalatest_assert_macro_left = $this.client().getTable("default", "src").properties();
            String $org_scalatest_assert_macro_right = "changed";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 244));
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 241));
        $this.test(new StringBuilder(68).append(version).append(": alterTable(dbName: String, tableName: String, table: CatalogTable)").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            CatalogTable qual$3 = $this.client().getTable("default", "src");
            Map x$24 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"changedAgain"), (Object)"")}));
            TableIdentifier x$25 = qual$3.copy$default$1();
            CatalogTableType x$26 = qual$3.copy$default$2();
            CatalogStorageFormat x$27 = qual$3.copy$default$3();
            StructType x$28 = qual$3.copy$default$4();
            Option x$29 = qual$3.copy$default$5();
            Seq x$30 = qual$3.copy$default$6();
            Option x$31 = qual$3.copy$default$7();
            String x$32 = qual$3.copy$default$8();
            long x$33 = qual$3.copy$default$9();
            long x$34 = qual$3.copy$default$10();
            String x$35 = qual$3.copy$default$11();
            Option x$36 = qual$3.copy$default$13();
            Option x$37 = qual$3.copy$default$14();
            Option x$38 = qual$3.copy$default$15();
            Seq x$39 = qual$3.copy$default$16();
            boolean x$40 = qual$3.copy$default$17();
            boolean x$41 = qual$3.copy$default$18();
            Map x$42 = qual$3.copy$default$19();
            CatalogTable newTable = qual$3.copy(x$25, x$26, x$27, x$28, x$29, x$30, x$31, x$32, x$33, x$34, x$35, x$24, x$36, x$37, x$38, x$39, x$40, x$41, x$42);
            $this.client().alterTable("default", "src", newTable);
            Map $org_scalatest_assert_macro_left = $this.client().getTable("default", "src").properties();
            String $org_scalatest_assert_macro_right = "changedAgain";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 250));
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 247));
        $this.test(new StringBuilder(21).append(version).append(": alterTable - rename").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            CatalogTable qual$4 = $this.client().getTable("default", "src");
            TableIdentifier x$43 = new TableIdentifier("tgt", (Option)new Some((Object)"default"));
            CatalogTableType x$44 = qual$4.copy$default$2();
            CatalogStorageFormat x$45 = qual$4.copy$default$3();
            StructType x$46 = qual$4.copy$default$4();
            Option x$47 = qual$4.copy$default$5();
            Seq x$48 = qual$4.copy$default$6();
            Option x$49 = qual$4.copy$default$7();
            String x$50 = qual$4.copy$default$8();
            long x$51 = qual$4.copy$default$9();
            long x$52 = qual$4.copy$default$10();
            String x$53 = qual$4.copy$default$11();
            Map x$54 = qual$4.copy$default$12();
            Option x$55 = qual$4.copy$default$13();
            Option x$56 = qual$4.copy$default$14();
            Option x$57 = qual$4.copy$default$15();
            Seq x$58 = qual$4.copy$default$16();
            boolean x$59 = qual$4.copy$default$17();
            boolean x$60 = qual$4.copy$default$18();
            Map x$61 = qual$4.copy$default$19();
            CatalogTable newTable = qual$4.copy(x$43, x$44, x$45, x$46, x$47, x$48, x$49, x$50, x$51, x$52, x$53, x$54, x$55, x$56, x$57, x$58, x$59, x$60, x$61);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool($this.client().tableExists("default", "tgt"), "VersionsSuite.this.client.tableExists(\"default\", \"tgt\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 256));
            $this.client().alterTable("default", "src", newTable);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool($this.client().tableExists("default", "tgt"), "VersionsSuite.this.client.tableExists(\"default\", \"tgt\")", Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 260));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool($this.client().tableExists("default", "src"), "VersionsSuite.this.client.tableExists(\"default\", \"src\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 261));
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 253));
        $this.test(new StringBuilder(30).append(version).append(": alterTable - change database").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            CatalogDatabase tempDB = new CatalogDatabase("temporary", "test create", tempDatabasePath, (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
            $this.client().createDatabase(tempDB, true);
            CatalogTable qual$5 = $this.client().getTable("default", "tgt");
            TableIdentifier x$62 = new TableIdentifier("tgt", (Option)new Some((Object)"temporary"));
            CatalogTableType x$63 = qual$5.copy$default$2();
            CatalogStorageFormat x$64 = qual$5.copy$default$3();
            StructType x$65 = qual$5.copy$default$4();
            Option x$66 = qual$5.copy$default$5();
            Seq x$67 = qual$5.copy$default$6();
            Option x$68 = qual$5.copy$default$7();
            String x$69 = qual$5.copy$default$8();
            long x$70 = qual$5.copy$default$9();
            long x$71 = qual$5.copy$default$10();
            String x$72 = qual$5.copy$default$11();
            Map x$73 = qual$5.copy$default$12();
            Option x$74 = qual$5.copy$default$13();
            Option x$75 = qual$5.copy$default$14();
            Option x$76 = qual$5.copy$default$15();
            Seq x$77 = qual$5.copy$default$16();
            boolean x$78 = qual$5.copy$default$17();
            boolean x$79 = qual$5.copy$default$18();
            Map x$80 = qual$5.copy$default$19();
            CatalogTable newTable = qual$5.copy(x$62, x$63, x$64, x$65, x$66, x$67, x$68, x$69, x$70, x$71, x$72, x$73, x$74, x$75, x$76, x$77, x$78, x$79, x$80);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool($this.client().tableExists("temporary", "tgt"), "VersionsSuite.this.client.tableExists(\"temporary\", \"tgt\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 271));
            $this.client().alterTable("default", "tgt", newTable);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool($this.client().tableExists("temporary", "tgt"), "VersionsSuite.this.client.tableExists(\"temporary\", \"tgt\")", Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 275));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool($this.client().tableExists("default", "tgt"), "VersionsSuite.this.client.tableExists(\"default\", \"tgt\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 276));
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 264));
        $this.test(new StringBuilder(46).append(version).append(": alterTable - change database and table names").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            CatalogTable qual$6 = $this.client().getTable("temporary", "tgt");
            TableIdentifier x$81 = new TableIdentifier("src", (Option)new Some((Object)"default"));
            CatalogTableType x$82 = qual$6.copy$default$2();
            CatalogStorageFormat x$83 = qual$6.copy$default$3();
            StructType x$84 = qual$6.copy$default$4();
            Option x$85 = qual$6.copy$default$5();
            Seq x$86 = qual$6.copy$default$6();
            Option x$87 = qual$6.copy$default$7();
            String x$88 = qual$6.copy$default$8();
            long x$89 = qual$6.copy$default$9();
            long x$90 = qual$6.copy$default$10();
            String x$91 = qual$6.copy$default$11();
            Map x$92 = qual$6.copy$default$12();
            Option x$93 = qual$6.copy$default$13();
            Option x$94 = qual$6.copy$default$14();
            Option x$95 = qual$6.copy$default$15();
            Seq x$96 = qual$6.copy$default$16();
            boolean x$97 = qual$6.copy$default$17();
            boolean x$98 = qual$6.copy$default$18();
            Map x$99 = qual$6.copy$default$19();
            CatalogTable newTable = qual$6.copy(x$81, x$82, x$83, x$84, x$85, x$86, x$87, x$88, x$89, x$90, x$91, x$92, x$93, x$94, x$95, x$96, x$97, x$98, x$99);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool($this.client().tableExists("default", "src"), "VersionsSuite.this.client.tableExists(\"default\", \"src\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 282));
            $this.client().alterTable("temporary", "tgt", newTable);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool($this.client().tableExists("default", "src"), "VersionsSuite.this.client.tableExists(\"default\", \"src\")", Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 286));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool($this.client().tableExists("temporary", "tgt"), "VersionsSuite.this.client.tableExists(\"temporary\", \"tgt\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 287));
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 279));
        $this.test(new StringBuilder(22).append(version).append(": listTables(database)").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer($this.client().listTables("default"));
            Seq $org_scalatest_assert_macro_right = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"src", "temporary"}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 291));
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 290));
        $this.test(new StringBuilder(31).append(version).append(": listTables(database, pattern)").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer($this.client().listTables("default", "src"));
            Seq $org_scalatest_assert_macro_right = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"src"}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 295));
            Seq $org_scalatest_assert_macro_left2 = $this.client().listTables("default", "nonexist");
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
            return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 296));
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 294));
        $this.test(new StringBuilder(11).append(version).append(": dropTable").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Assertion assertion;
            Seq versionsWithoutPurge = (Seq)$this.versions().takeWhile((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)VersionsSuite.$anonfun$new$31(x$1)));
            try {
                $this.client().dropTable("default", "temporary", false, true);
                Seq $org_scalatest_assert_macro_left = versionsWithoutPurge;
                String $org_scalatest_assert_macro_right = version;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                assertion = $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 306));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                Seq $org_scalatest_assert_macro_left = versionsWithoutPurge;
                String $org_scalatest_assert_macro_right = version;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 309));
                $this.client().dropTable("default", "temporary", false, false);
                assertion = BoxedUnit.UNIT;
            }
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer($this.client().listTables("default"));
            Seq $org_scalatest_assert_macro_right = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"src"}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 313));
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 299));
        CatalogStorageFormat storageFormat = new CatalogStorageFormat((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, false, Predef$.MODULE$.Map().empty());
        $this.test(new StringBuilder(30).append(version).append(": sql create partitioned table").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> $this.client().runSqlHive("CREATE TABLE src_part (value INT) PARTITIONED BY (key1 INT, key2 INT)"), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 328));
        int testPartitionCount = 2;
        $this.test(new StringBuilder(18).append(version).append(": createPartitions").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            IndexedSeq partitions = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), testPartitionCount).map((Function1 & Serializable & scala.Serializable)key2 -> VersionsSuite.$anonfun$new$34(storageFormat, BoxesRunTime.unboxToInt((Object)key2)), IndexedSeq$.MODULE$.canBuildFrom());
            $this.client().createPartitions("default", "src_part", (Seq)partitions, true);
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 334));
        $this.test(new StringBuilder(33).append(version).append(": getPartitionNames(catalogTable)").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            IndexedSeq partitionNames;
            IndexedSeq $org_scalatest_assert_macro_left = partitionNames = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), testPartitionCount).map((Function1 & Serializable & scala.Serializable)key2 -> VersionsSuite.$anonfun$new$36(BoxesRunTime.unboxToInt((Object)key2)), IndexedSeq$.MODULE$.canBuildFrom());
            HiveClient qual$7 = $this.client();
            CatalogTable x$100 = $this.client().getTable("default", "src_part");
            Option x$101 = qual$7.getPartitionNames$default$2();
            Seq $org_scalatest_assert_macro_right = qual$7.getPartitionNames(x$100, x$101);
            IndexedSeq indexedSeq = $org_scalatest_assert_macro_left;
            Seq seq = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(indexedSeq != null ? !indexedSeq.equals(seq) : seq != null), Prettifier$.MODULE$.default());
            return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 344));
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 342));
        $this.test(new StringBuilder(29).append(version).append(": getPartitions(catalogTable)").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            int $org_scalatest_assert_macro_left = testPartitionCount;
            HiveClient qual$8 = $this.client();
            CatalogTable x$102 = $this.client().getTable("default", "src_part");
            Option x$103 = qual$8.getPartitions$default$2();
            int $org_scalatest_assert_macro_right = qual$8.getPartitions(x$102, x$103).size();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 348));
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 347));
        $this.test(new StringBuilder(23).append(version).append(": getPartitionsByFilter").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Assertion assertion;
            EqualTo[] equalToArray = new EqualTo[1];
            String x$104 = "key2";
            IntegerType$ x$105 = IntegerType$.MODULE$;
            boolean x$106 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$107 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$108 = AttributeReference$.MODULE$.apply$default$5(x$104, (DataType)x$105, x$106, x$107);
            Seq x$109 = AttributeReference$.MODULE$.apply$default$6(x$104, (DataType)x$105, x$106, x$107);
            equalToArray[0] = new EqualTo((Expression)new AttributeReference(x$104, (DataType)x$105, x$106, x$107, x$108, x$109), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)));
            Seq result = $this.client().getPartitionsByFilter($this.client().getTable("default", "src_part"), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])equalToArray)));
            String string = version;
            String string2 = "0.12";
            if (string == null ? string2 != null : !string.equals(string2)) {
                Seq $org_scalatest_assert_macro_left = result;
                int $org_scalatest_assert_macro_right = 1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                assertion = $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 359));
            } else {
                Seq $org_scalatest_assert_macro_left = result;
                int $org_scalatest_assert_macro_right = testPartitionCount;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                assertion = $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 361));
            }
            return assertion;
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 352));
        $this.test(new StringBuilder(14).append(version).append(": getPartition").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> $this.client().getPartition("default", "src_part", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key1"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key2"), (Object)"2")}))), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 365));
        $this.test(new StringBuilder(73).append(version).append(": getPartitionOption(db: String, table: String, spec: TablePartitionSpec)").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Option partition = $this.client().getPartitionOption("default", "src_part", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key1"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key2"), (Object)"2")})));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(partition.isDefined(), "partition.isDefined", Prettifier$.MODULE$.default());
            return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 373));
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 370));
        $this.test(new StringBuilder(67).append(version).append(": getPartitionOption(table: CatalogTable, spec: TablePartitionSpec)").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Option partition = $this.client().getPartitionOption($this.client().getTable("default", "src_part"), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key1"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key2"), (Object)"2")})));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(partition.isDefined(), "partition.isDefined", Prettifier$.MODULE$.default());
            return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 379));
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 376));
        $this.test(new StringBuilder(42).append(version).append(": getPartitions(db: String, table: String)").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            int $org_scalatest_assert_macro_left = testPartitionCount;
            int $org_scalatest_assert_macro_right = $this.client().getPartitions("default", "src_part", (Option)None$.MODULE$).size();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 383));
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 382));
        $this.test(new StringBuilder(15).append(version).append(": loadPartition").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LinkedHashMap<String, String> partSpec = new LinkedHashMap<String, String>();
            partSpec.put("key1", "1");
            partSpec.put("key2", "2");
            $this.client().loadPartition($this.emptyDir(), "default", "src_part", partSpec, false, false, false);
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 386));
        $this.test(new StringBuilder(23).append(version).append(": loadDynamicPartitions").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LinkedHashMap<String, String> partSpec = new LinkedHashMap<String, String>();
            partSpec.put("key1", "1");
            partSpec.put("key2", "");
            $this.client().loadDynamicPartitions($this.emptyDir(), "default", "src_part", partSpec, false, 1);
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 401));
        $this.test(new StringBuilder(18).append(version).append(": renamePartitions").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Map oldSpec = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key1"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key2"), (Object)"1")}));
            Map newSpec = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key1"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key2"), (Object)"3")}));
            $this.client().renamePartitions("default", "src_part", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{oldSpec})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{newSpec})));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool($this.client().getPartitionOption("default", "src_part", newSpec).isDefined(), "VersionsSuite.this.client.getPartitionOption(\"default\", \"src_part\", newSpec).isDefined", Prettifier$.MODULE$.default());
            return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 421));
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 415));
        $this.test(new StringBuilder(17).append(version).append(": alterPartitions").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Map spec = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key1"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key2"), (Object)"2")}));
            Map parameters = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"totalSize"), (Object)"0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numFiles"), (Object)"1")}));
            URI newLocation = new URI(new StringOps(Predef$.MODULE$.augmentString(Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()).toURI().toString())).stripSuffix("/"));
            Some x$110 = new Some((Object)newLocation);
            Some x$111 = new Some((Object)"org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe");
            Option x$112 = storageFormat.copy$default$2();
            Option x$113 = storageFormat.copy$default$3();
            boolean x$114 = storageFormat.copy$default$5();
            Map x$115 = storageFormat.copy$default$6();
            CatalogStorageFormat storage = storageFormat.copy((Option)x$110, x$112, x$113, (Option)x$111, x$114, x$115);
            CatalogTablePartition partition = new CatalogTablePartition(spec, storage, parameters, CatalogTablePartition$.MODULE$.apply$default$4(), CatalogTablePartition$.MODULE$.apply$default$5(), CatalogTablePartition$.MODULE$.apply$default$6());
            $this.client().alterPartitions("default", "src_part", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{partition})));
            Option $org_scalatest_assert_macro_left = $this.client().getPartition("default", "src_part", spec).storage().locationUri();
            Some $org_scalatest_assert_macro_right = new Some((Object)newLocation);
            Option option = $org_scalatest_assert_macro_left;
            Some some = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(option != null ? !option.equals(some) : some != null), Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 434));
            Option $org_scalatest_assert_macro_left2 = $this.client().getPartition("default", "src_part", spec).parameters().get((Object)"totalSize");
            Some $org_scalatest_assert_macro_right2 = new Some((Object)"0");
            Option option2 = $org_scalatest_assert_macro_left2;
            Some some2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(option2 != null ? !option2.equals(some2) : some2 != null), Prettifier$.MODULE$.default());
            return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 436));
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 424));
        $this.test(new StringBuilder(16).append(version).append(": dropPartitions").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Assertion assertion;
            Map spec = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key1"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key2"), (Object)"3")}));
            Seq versionsWithoutPurge = (Seq)$this.versions().takeWhile((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)VersionsSuite.$anonfun$new$48(x$2)));
            try {
                $this.client().dropPartitions("default", "src_part", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{spec})), true, true, false);
                Seq $org_scalatest_assert_macro_left = versionsWithoutPurge;
                String $org_scalatest_assert_macro_right = version;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                assertion = $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 448));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                Seq $org_scalatest_assert_macro_left = versionsWithoutPurge;
                String $org_scalatest_assert_macro_right = version;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 451));
                $this.client().dropPartitions("default", "src_part", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{spec})), true, false, false);
                assertion = BoxedUnit.UNIT;
            }
            Option $org_scalatest_assert_macro_left = $this.client().getPartitionOption("default", "src_part", spec);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 456));
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 440));
        $this.test(new StringBuilder(16).append(version).append(": createFunction").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Object object;
            String functionClass = "org.apache.spark.MyFunc1";
            String string = version;
            String string2 = "0.12";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                object = $this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.client().createFunction("default", VersionsSuite.function$1("func1", functionClass)), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 472));
            } else {
                $this.client().createFunction("default", VersionsSuite.function$1("func1", functionClass));
                object = BoxedUnit.UNIT;
            }
            return object;
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 468));
        $this.test(new StringBuilder(16).append(version).append(": functionExists").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Assertion assertion;
            String string = version;
            String string2 = "0.12";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                boolean $org_scalatest_assert_macro_left = $this.client().functionExists("default", "func1");
                boolean $org_scalatest_assert_macro_right = false;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                assertion = $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 483));
            } else {
                boolean $org_scalatest_assert_macro_left = $this.client().functionExists("default", "func1");
                boolean $org_scalatest_assert_macro_right = true;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                assertion = $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 485));
            }
            return assertion;
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 480));
        $this.test(new StringBuilder(16).append(version).append(": renameFunction").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Object object;
            String string = version;
            String string2 = "0.12";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                object = $this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.client().renameFunction("default", "func1", "func2"), ClassTag$.MODULE$.apply(NoSuchPermanentFunctionException.class), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 492));
            } else {
                $this.client().renameFunction("default", "func1", "func2");
                boolean $org_scalatest_assert_macro_left = $this.client().functionExists("default", "func2");
                boolean $org_scalatest_assert_macro_right = true;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                object = $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 497));
            }
            return object;
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 489));
        $this.test(new StringBuilder(15).append(version).append(": alterFunction").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Object object;
            String functionClass = "org.apache.spark.MyFunc2";
            String string = version;
            String string2 = "0.12";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                object = $this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.client().alterFunction("default", VersionsSuite.function$1("func2", functionClass)), ClassTag$.MODULE$.apply(NoSuchPermanentFunctionException.class), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 505));
            } else {
                $this.client().alterFunction("default", VersionsSuite.function$1("func2", functionClass));
                object = BoxedUnit.UNIT;
            }
            return object;
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 501));
        $this.test(new StringBuilder(13).append(version).append(": getFunction").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Object object;
            String string = version;
            String string2 = "0.12";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                object = $this.intercept((Function0 & Serializable & scala.Serializable)() -> $this.client().getFunction("default", "func2"), ClassTag$.MODULE$.apply(NoSuchPermanentFunctionException.class), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 516));
            } else {
                CatalogFunction func = $this.client().getFunction("default", "func2");
                String $org_scalatest_assert_macro_left = func.className();
                String $org_scalatest_assert_macro_right = "org.apache.spark.MyFunc2";
                String string3 = $org_scalatest_assert_macro_left;
                String string4 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
                object = $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 522));
            }
            return object;
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 513));
        $this.test(new StringBuilder(19).append(version).append(": getFunctionOption").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Assertion assertion;
            String string = version;
            String string2 = "0.12";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                Option $org_scalatest_assert_macro_left = $this.client().getFunctionOption("default", "func2");
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
                assertion = $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 529));
            } else {
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool($this.client().getFunctionOption("default", "func2").isDefined(), "VersionsSuite.this.client.getFunctionOption(\"default\", \"func2\").isDefined", Prettifier$.MODULE$.default());
                $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 531));
                Option $org_scalatest_assert_macro_left = $this.client().getFunctionOption("default", "the_func_not_exists");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
                assertion = $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 532));
            }
            return assertion;
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 526));
        $this.test(new StringBuilder(15).append(version).append(": listFunctions").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Assertion assertion;
            String string = version;
            String string2 = "0.12";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                Seq $org_scalatest_assert_macro_left = $this.client().listFunctions("default", "fun.*");
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
                assertion = $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 539));
            } else {
                Seq $org_scalatest_assert_macro_left = $this.client().listFunctions("default", "fun.*");
                int $org_scalatest_assert_macro_right = 1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                assertion = $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 541));
            }
            return assertion;
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 536));
        $this.test(new StringBuilder(14).append(version).append(": dropFunction").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Object object;
            String string = version;
            String string2 = "0.12";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                object = $this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.client().dropFunction("default", "func2"), ClassTag$.MODULE$.apply(NoSuchPermanentFunctionException.class), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 548));
            } else {
                $this.client().dropFunction("default", "func2");
                Seq $org_scalatest_assert_macro_left = $this.client().listFunctions("default", "fun.*");
                int $org_scalatest_assert_macro_right = 0;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                object = $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 554));
            }
            return object;
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 545));
        $this.test(new StringBuilder(17).append(version).append(": sql set command").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> $this.client().runSqlHive("SET spark.sql.test.key=1"), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 562));
        $this.test(new StringBuilder(28).append(version).append(": sql create index and reset").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            $this.client().runSqlHive("CREATE TABLE indexed_table (key INT)");
            return $this.client().runSqlHive("CREATE INDEX index_1 ON TABLE indexed_table(key) as 'COMPACT' WITH DEFERRED REBUILD");
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 566));
        $this.test(new StringBuilder(33).append(version).append(": sql read hive materialized view").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            String string = version;
            String string2 = "2.3";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                String e;
                $this.client().runSqlHive("CREATE TABLE materialized_view_tbl (c1 INT)");
                $this.client().runSqlHive("CREATE MATERIALIZED VIEW mv1 AS SELECT * FROM materialized_view_tbl");
                String $org_scalatest_assert_macro_left = e = ((AnalysisException)$this.intercept((Function0 & Serializable & scala.Serializable)() -> (Row[])$this.versionSpark().table("mv1").collect(), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 578))).getMessage();
                String $org_scalatest_assert_macro_right = "Hive materialized view is not supported";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                boxedUnit = $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 579));
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 572));
        $this.test(new StringBuilder(9).append(version).append(": version").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String $org_scalatest_assert_macro_left = $this.client().version().fullVersion();
            String $org_scalatest_assert_macro_right = version;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "startsWith", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.startsWith($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 588));
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 587));
        $this.test(new StringBuilder(9).append(version).append(": getConf").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer("success");
            String $org_scalatest_assert_macro_right = $this.client().getConf("test", null);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 592));
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 591));
        $this.test(new StringBuilder(8).append(version).append(": setOut").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.client().setOut(new PrintStream(new ByteArrayOutputStream())), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 595));
        $this.test(new StringBuilder(9).append(version).append(": setInfo").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.client().setInfo(new PrintStream(new ByteArrayOutputStream())), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 599));
        $this.test(new StringBuilder(10).append(version).append(": setError").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.client().setError(new PrintStream(new ByteArrayOutputStream())), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 603));
        $this.test(new StringBuilder(12).append(version).append(": newSession").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            HiveClient newClient;
            HiveClient $org_scalatest_assert_macro_left = newClient = $this.client().newSession();
            Object $org_scalatest_assert_macro_right = null;
            HiveClient hiveClient = $org_scalatest_assert_macro_left;
            Object var5_4 = null;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", null, hiveClient == null ? var5_4 != null : !hiveClient.equals(var5_4), Prettifier$.MODULE$.default());
            return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 609));
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 607));
        $this.test(new StringBuilder(26).append(version).append(": withHiveState and addJar").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            String newClassPath = ".";
            $this.client().addJar(newClassPath);
            return BoxesRunTime.unboxToBoolean((Object)$this.client().withHiveState((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                MutableURLClassLoader classLoader = (MutableURLClassLoader)Thread.currentThread().getContextClassLoader();
                URL[] urls = classLoader.getURLs();
                return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])urls)).contains((Object)new File(newClassPath).toURI().toURL());
            }));
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 612));
        $this.test(new StringBuilder(7).append(version).append(": reset").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            $this.client().reset();
            Seq $org_scalatest_assert_macro_left = $this.client().listTables("default");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 629));
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 626));
        $this.test(new StringBuilder(24).append(version).append(": CREATE TABLE AS SELECT").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tbl"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.versionSpark().sql("CREATE TABLE tbl AS SELECT 1 AS a");
            Seq $org_scalatest_assert_macro_left = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.versionSpark().table("tbl").collect())).toSeq();
            Seq $org_scalatest_assert_macro_right = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)}))}));
            Seq seq = $org_scalatest_assert_macro_left;
            Seq seq2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(seq != null ? !seq.equals(seq2) : seq2 != null), Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 639));
            CatalogTable tableMeta = $this.versionSpark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply("tbl"));
            Option totalSize = tableMeta.stats().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.sizeInBytes());
            String string = version;
            String string2 = "0.12";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                Option $org_scalatest_assert_macro_left2 = totalSize;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
                $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 644));
            } else {
                Bool bool;
                Option $org_scalatest_assert_macro_left3 = totalSize;
                Bool $org_scalatest_assert_macro_left4 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "nonEmpty", $org_scalatest_assert_macro_left3.nonEmpty(), Prettifier$.MODULE$.default());
                if ($org_scalatest_assert_macro_left4.value()) {
                    BigInt $org_scalatest_assert_macro_left5 = (BigInt)totalSize.get();
                    BigInt $org_scalatest_assert_macro_right2 = BigInt$.MODULE$.int2bigInt(0);
                    bool = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, ">", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left5.$greater((Object)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                } else {
                    bool = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
                }
                Bool $org_scalatest_assert_macro_right3 = bool;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "&&", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left4.$amp$amp($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
                $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 646));
            }
        }), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 636));
        $this.test(new StringBuilder(36).append(version).append(": CREATE Partitioned TABLE AS SELECT").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tbl"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Assertion assertion;
            $this.versionSpark().sql(new StringOps(Predef$.MODULE$.augmentString("\n            |CREATE TABLE tbl(c1 string)\n            |PARTITIONED BY (ds STRING)\n          ")).stripMargin());
            $this.versionSpark().sql("INSERT OVERWRITE TABLE tbl partition (ds='2') SELECT '1'");
            Seq $org_scalatest_assert_macro_left = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.versionSpark().table("tbl").collect())).toSeq();
            Seq $org_scalatest_assert_macro_right = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1", "2"}))}));
            Seq seq = $org_scalatest_assert_macro_left;
            Seq seq2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(seq != null ? !seq.equals(seq2) : seq2 != null), Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 660));
            Map partMeta = $this.versionSpark().sessionState().catalog().getPartition(TableIdentifier$.MODULE$.apply("tbl"), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ds"), (Object)"2")}))).parameters();
            Option totalSize = partMeta.get((Object)"totalSize").map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)VersionsSuite.$anonfun$new$80(x$4)));
            Option numFiles = partMeta.get((Object)"numFiles").map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)VersionsSuite.$anonfun$new$81(x$5)));
            String string = version;
            String string2 = "0.12";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                Bool bool;
                Option $org_scalatest_assert_macro_left2 = totalSize;
                Bool $org_scalatest_assert_macro_left3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
                if ($org_scalatest_assert_macro_left3.value()) {
                    Option $org_scalatest_assert_macro_left4 = numFiles;
                    bool = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left4, "isEmpty", $org_scalatest_assert_macro_left4.isEmpty(), Prettifier$.MODULE$.default());
                } else {
                    bool = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
                }
                Bool $org_scalatest_assert_macro_right2 = bool;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "&&", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left3.$amp$amp($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                assertion = $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 667));
            } else {
                Bool bool;
                Option $org_scalatest_assert_macro_left5 = totalSize;
                Bool $org_scalatest_assert_macro_left6 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left5, "nonEmpty", $org_scalatest_assert_macro_left5.nonEmpty(), Prettifier$.MODULE$.default());
                if ($org_scalatest_assert_macro_left6.value()) {
                    Option $org_scalatest_assert_macro_left7 = numFiles;
                    bool = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left7, "nonEmpty", $org_scalatest_assert_macro_left7.nonEmpty(), Prettifier$.MODULE$.default());
                } else {
                    bool = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
                }
                Bool $org_scalatest_assert_macro_right3 = bool;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "&&", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left6.$amp$amp($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
                assertion = $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 669));
            }
            $this.versionSpark().sql(new StringOps(Predef$.MODULE$.augmentString("\n            |ALTER TABLE tbl PARTITION (ds='2')\n            |SET SERDEPROPERTIES ('newKey' = 'vvv')\n          ")).stripMargin());
            Map newPartMeta = $this.versionSpark().sessionState().catalog().getPartition(TableIdentifier$.MODULE$.apply("tbl"), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ds"), (Object)"2")}))).parameters();
            Option newTotalSize = newPartMeta.get((Object)"totalSize").map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)VersionsSuite.$anonfun$new$82(x$6)));
            Option newNumFiles = newPartMeta.get((Object)"numFiles").map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToLong((long)VersionsSuite.$anonfun$new$83(x$7)));
            String string3 = version;
            String string4 = "0.12";
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                Bool bool;
                Option $org_scalatest_assert_macro_left8 = newTotalSize;
                Bool $org_scalatest_assert_macro_left9 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left8, "isEmpty", $org_scalatest_assert_macro_left8.isEmpty(), Prettifier$.MODULE$.default());
                if ($org_scalatest_assert_macro_left9.value()) {
                    Option $org_scalatest_assert_macro_left10 = newNumFiles;
                    bool = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left10, "isEmpty", $org_scalatest_assert_macro_left10.isEmpty(), Prettifier$.MODULE$.default());
                } else {
                    bool = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
                }
                Bool $org_scalatest_assert_macro_right4 = bool;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "&&", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left9.$amp$amp($org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
                $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 684));
            } else {
                Bool bool;
                Option $org_scalatest_assert_macro_left11 = newTotalSize;
                Bool $org_scalatest_assert_macro_left12 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left11, "nonEmpty", $org_scalatest_assert_macro_left11.nonEmpty(), Prettifier$.MODULE$.default());
                if ($org_scalatest_assert_macro_left12.value()) {
                    Option $org_scalatest_assert_macro_left13 = newNumFiles;
                    bool = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left13, "nonEmpty", $org_scalatest_assert_macro_left13.nonEmpty(), Prettifier$.MODULE$.default());
                } else {
                    bool = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
                }
                Bool $org_scalatest_assert_macro_right5 = bool;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "&&", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left12.$amp$amp($org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
                $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 686));
            }
        }), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 651));
        $this.test(new StringBuilder(68).append(version).append(": Delete the temporary staging directory and files after each insert").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmpDir -> {
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tab"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.versionSpark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(86).append("\n               |CREATE TABLE tab(c1 string)\n               |location '").append(tmpDir.toURI().toString()).append("'\n             ").toString())).stripMargin());
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 3).map((Function1 & Serializable & scala.Serializable)i -> VersionsSuite.$anonfun$new$87($this, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
                Seq metadataFiles = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"._SUCCESS.crc", "_SUCCESS"}));
                List $org_scalatest_assert_macro_left = (List)VersionsSuite.listFiles$1(tmpDir).filterNot((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)metadataFiles.contains(elem)));
                int $org_scalatest_assert_macro_right = 2;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 712));
            });
            return BoxedUnit.UNIT;
        }), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 691));
        $this.test(new StringBuilder(64).append(version).append(": SPARK-13709: reading partitioned Avro table with nested schema").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            VersionsSuite.$anonfun$new$93($this, dir);
            return BoxedUnit.UNIT;
        }), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 717));
        $this.test(new StringBuilder(37).append(version).append(": CTAS for managed data source tables").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t", "t1"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.versionSpark().range(1L).write().saveAsTable("t");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer($this.versionSpark().table("t").collect());
            Row[] $org_scalatest_assert_macro_right = (Row[])((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0)}))});
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 797));
            $this.versionSpark().sql("create table t1 using parquet as select 2 as a");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer($this.versionSpark().table("t1").collect());
            Row[] $org_scalatest_assert_macro_right2 = (Row[])((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2)}))});
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 799));
        }), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 794));
        $this.test(new StringBuilder(36).append(version).append(": Decimal support of Avro Hive serde").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String tableName = "tab1";
            String avroSchema = new StringOps(Predef$.MODULE$.augmentString("{\n          |  \"name\": \"test_record\",\n          |  \"type\": \"record\",\n          |  \"fields\": [ {\n          |    \"name\": \"f0\",\n          |    \"type\": [\n          |      \"null\",\n          |      {\n          |        \"precision\": 38,\n          |        \"scale\": 2,\n          |        \"type\": \"bytes\",\n          |        \"logicalType\": \"decimal\"\n          |      }\n          |    ]\n          |  } ]\n          |}\n        ")).stripMargin();
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, false}))).foreach((Function1 & Serializable & scala.Serializable)isPartitioned -> {
                $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tableName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    String insertStmt;
                    block8: {
                        String e;
                        String errorMsg;
                        block7: {
                            block4: {
                                String insertStmt2;
                                block6: {
                                    String e2;
                                    block5: {
                                        String partitionClause = isPartitioned ? "PARTITIONED BY (ds STRING)" : "";
                                        $this.versionSpark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(408).append("\n               |CREATE TABLE ").append(tableName$2).append("\n               |").append(partitionClause).append("\n               |ROW FORMAT SERDE 'org.apache.hadoop.hive.serde2.avro.AvroSerDe'\n               |STORED AS\n               |  INPUTFORMAT 'org.apache.hadoop.hive.ql.io.avro.AvroContainerInputFormat'\n               |  OUTPUTFORMAT 'org.apache.hadoop.hive.ql.io.avro.AvroContainerOutputFormat'\n               |TBLPROPERTIES ('avro.schema.literal' = '").append(avroSchema$2).append("')\n           ").toString())).stripMargin());
                                        errorMsg = "data type mismatch: cannot cast decimal(2,1) to binary";
                                        if (!isPartitioned) break block4;
                                        insertStmt2 = new StringBuilder(53).append("INSERT OVERWRITE TABLE ").append(tableName$2).append(" partition (ds='a') SELECT 1.3").toString();
                                        String string = version$1;
                                        String string2 = "0.12";
                                        if (!(string == null ? string2 != null : !string.equals(string2))) break block5;
                                        String string3 = version$1;
                                        String string4 = "0.13";
                                        if (string3 != null ? !string3.equals(string4) : string4 != null) break block6;
                                    }
                                    String $org_scalatest_assert_macro_left = e2 = ((AnalysisException)$this.intercept((Function0 & Serializable & scala.Serializable)() -> $this.versionSpark().sql(insertStmt2), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847))).getMessage();
                                    String $org_scalatest_assert_macro_right = errorMsg;
                                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                                    $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 848));
                                    return;
                                }
                                $this.versionSpark().sql(insertStmt2);
                                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer($this.versionSpark().table(tableName$2).collect());
                                Row[] $org_scalatest_assert_macro_right = (Row[])$this.versionSpark().sql("SELECT 1.30, 'a'").collect();
                                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                                $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 851));
                                return;
                            }
                            insertStmt = new StringBuilder(34).append("INSERT OVERWRITE TABLE ").append(tableName$2).append(" SELECT 1.3").toString();
                            String string = version$1;
                            String string5 = "0.12";
                            if (!(string == null ? string5 != null : !string.equals(string5))) break block7;
                            String string6 = version$1;
                            String string7 = "0.13";
                            if (string6 != null ? !string6.equals(string7) : string7 != null) break block8;
                        }
                        String $org_scalatest_assert_macro_left = e = ((AnalysisException)$this.intercept((Function0 & Serializable & scala.Serializable)() -> $this.versionSpark().sql(insertStmt), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 857))).getMessage();
                        String $org_scalatest_assert_macro_right = errorMsg;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 858));
                        return;
                    }
                    $this.versionSpark().sql(insertStmt);
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer($this.versionSpark().table(tableName$2).collect());
                    Row[] $org_scalatest_assert_macro_right = (Row[])$this.versionSpark().sql("SELECT 1.30").collect();
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 861));
                });
                return BoxedUnit.UNIT;
            });
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 803));
        $this.test(new StringBuilder(35).append(version).append(": read avro file containing decimal").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            URL url = Thread.currentThread().getContextClassLoader().getResource("avroDecimal");
            String location = new File(url.getFile()).toURI().toString();
            String tableName = "tab1";
            String avroSchema = new StringOps(Predef$.MODULE$.augmentString("{\n          |  \"name\": \"test_record\",\n          |  \"type\": \"record\",\n          |  \"fields\": [ {\n          |    \"name\": \"f0\",\n          |    \"type\": [\n          |      \"null\",\n          |      {\n          |        \"precision\": 38,\n          |        \"scale\": 2,\n          |        \"type\": \"bytes\",\n          |        \"logicalType\": \"decimal\"\n          |      }\n          |    ]\n          |  } ]\n          |}\n        ")).stripMargin();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tableName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.versionSpark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(472).append("\n             |CREATE TABLE ").append(tableName).append("\n             |ROW FORMAT SERDE 'org.apache.hadoop.hive.serde2.avro.AvroSerDe'\n             |WITH SERDEPROPERTIES ('respectSparkSchema' = 'true')\n             |STORED AS\n             |  INPUTFORMAT 'org.apache.hadoop.hive.ql.io.avro.AvroContainerInputFormat'\n             |  OUTPUTFORMAT 'org.apache.hadoop.hive.ql.io.avro.AvroContainerOutputFormat'\n             |LOCATION '").append(location).append("'\n             |TBLPROPERTIES ('avro.schema.literal' = '").append(avroSchema).append("')\n           ").toString())).stripMargin());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer($this.versionSpark().table(tableName).collect());
                Row[] $org_scalatest_assert_macro_right = (Row[])$this.versionSpark().sql("SELECT 1.30").collect();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 905));
            });
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 869));
        $this.test(new StringBuilder(47).append(version).append(": SPARK-17920: Insert into/overwrite avro table").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Bool bool;
            Bool $org_scalatest_assert_macro_left = Bool$.MODULE$.simpleMacroBool(Utils$.MODULE$.isWindows(), "org.apache.spark.util.Utils.isWindows", Prettifier$.MODULE$.default());
            if ($org_scalatest_assert_macro_left.value()) {
                String $org_scalatest_assert_macro_left2 = version;
                String $org_scalatest_assert_macro_right = "0.12";
                String string = $org_scalatest_assert_macro_left2;
                String string2 = $org_scalatest_assert_macro_right;
                bool = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            } else {
                bool = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
            }
            Bool $org_scalatest_assert_macro_right = bool;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "&&", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$amp$amp($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssume($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 912));
            $this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
                VersionsSuite.$anonfun$new$105($this, dir);
                return BoxedUnit.UNIT;
            });
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 910));
    }

    public VersionsSuite() {
        this.test("success sanity check", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            HiveClient badClient = HiveClientBuilder$.MODULE$.buildClient(HiveUtils$.MODULE$.builtinHiveVersion(), new Configuration(), HiveClientBuilder$.MODULE$.buildClient$default$3(), HiveClientBuilder$.MODULE$.buildClient$default$4());
            CatalogDatabase db = new CatalogDatabase("default", "desc", new URI("loc"), (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
            badClient.createDatabase(db, true);
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
        this.test("hadoop configuration preserved", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Configuration hadoopConf = new Configuration();
            hadoopConf.set("test", "success");
            HiveClient client = HiveClientBuilder$.MODULE$.buildClient(HiveUtils$.MODULE$.builtinHiveVersion(), hadoopConf, HiveClientBuilder$.MODULE$.buildClient$default$3(), HiveClientBuilder$.MODULE$.buildClient$default$4());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer("success");
            String $org_scalatest_assert_macro_right = client.getConf("test", null);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
        this.emptyDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()).getCanonicalPath();
        this.ignore("failure sanity check", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Throwable e = (Throwable)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                HiveClient hiveClient = (HiveClient)package$.MODULE$.quietly((Function0 & Serializable & scala.Serializable)() -> HiveClientBuilder$.MODULE$.buildClient("13", new Configuration(), HiveClientBuilder$.MODULE$.buildClient$default$3(), HiveClientBuilder$.MODULE$.buildClient$default$4()));
            }, ClassTag$.MODULE$.apply(Throwable.class), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
            String $org_scalatest_assert_macro_left = this.getNestedMessages(e);
            String $org_scalatest_assert_macro_right = "Unknown column 'A0.OWNER_NAME' in 'field list'";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110));
        }, new Position("VersionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
        this.versions = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0.12", "0.13", "0.14", "1.0", "1.1", "1.2", "2.0", "2.1", "2.2", "2.3"}));
        this.client = null;
        this.versionSpark = null;
        this.versions().foreach((Function1 & Serializable & scala.Serializable)version -> {
            VersionsSuite.$anonfun$new$6(this, version);
            return BoxedUnit.UNIT;
        });
    }
}

