/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.jetty.plus.jndi;

import javax.naming.InitialContext;
import org.spark_project.jetty.util.StringUtil;
import org.spark_project.jetty.util.component.Dumpable;

public class NamingDump
implements Dumpable {
    private final ClassLoader _loader;
    private final String _name;

    public NamingDump() {
        this(null, "");
    }

    public NamingDump(ClassLoader loader, String name) {
        this._loader = loader;
        this._name = name;
    }

    @Override
    public void dump(Appendable out, String indent) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            Object context;
            if (!StringUtil.isBlank(this._name)) {
                out.append(this._name).append(" ");
            }
            if (this._loader != null) {
                Thread.currentThread().setContextClassLoader(this._loader);
            }
            if ((context = new InitialContext().lookup(this._name)) instanceof Dumpable) {
                ((Dumpable)context).dump(out, indent);
            } else {
                Dumpable.dumpObjects(out, indent, context, new Object[0]);
            }
        }
        catch (Throwable cause) {
            throw new RuntimeException(cause);
        }
        finally {
            if (this._loader != null) {
                Thread.currentThread().setContextClassLoader(loader);
            }
        }
    }
}

