/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.execution;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.spark.sql.catalyst.catalog.HiveTableRelation;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.hive.execution.HiveComparisonTest;
import org.apache.spark.sql.hive.execution.HiveTableScanExec;
import org.apache.spark.sql.hive.test.TestHive$;
import org.apache.spark.sql.hive.test.TestHiveQueryExecution;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfter;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0001!3A\u0001B\u0003\u0001%!)Q\u0004\u0001C\u0001=!)\u0001\u0005\u0001C!C!)\u0001\u0006\u0001C\u0001S\ta\u0001K];oS:<7+^5uK*\u0011aaB\u0001\nKb,7-\u001e;j_:T!\u0001C\u0005\u0002\t!Lg/\u001a\u0006\u0003\u0015-\t1a]9m\u0015\taQ\"A\u0003ta\u0006\u00148N\u0003\u0002\u000f\u001f\u00051\u0011\r]1dQ\u0016T\u0011\u0001E\u0001\u0004_J<7\u0001A\n\u0004\u0001M9\u0002C\u0001\u000b\u0016\u001b\u0005)\u0011B\u0001\f\u0006\u0005IA\u0015N^3D_6\u0004\u0018M]5t_:$Vm\u001d;\u0011\u0005aYR\"A\r\u000b\u0005iy\u0011!C:dC2\fG/Z:u\u0013\ta\u0012D\u0001\bCK\u001a|'/Z!oI\u00063G/\u001a:\u0002\rqJg.\u001b;?)\u0005y\u0002C\u0001\u000b\u0001\u0003%\u0011WMZ8sK\u0006cG\u000eF\u0001#!\t\u0019c%D\u0001%\u0015\u0005)\u0013!B:dC2\f\u0017BA\u0014%\u0005\u0011)f.\u001b;\u0002#\r\u0014X-\u0019;f!J,h.\u001b8h)\u0016\u001cH\u000f\u0006\u0004#U]B4)\u0012\u0005\u0006W\r\u0001\r\u0001L\u0001\ri\u0016\u001cHoQ1tK:\u000bW.\u001a\t\u0003[Qr!A\f\u001a\u0011\u0005=\"S\"\u0001\u0019\u000b\u0005E\n\u0012A\u0002\u001fs_>$h(\u0003\u00024I\u00051\u0001K]3eK\u001aL!!\u000e\u001c\u0003\rM#(/\u001b8h\u0015\t\u0019D\u0005C\u0003\u000b\u0007\u0001\u0007A\u0006C\u0003:\u0007\u0001\u0007!(A\u000bfqB,7\r^3e\u001fV$\b/\u001e;D_2,XN\\:\u0011\u0007m\u0002EF\u0004\u0002=}9\u0011q&P\u0005\u0002K%\u0011q\bJ\u0001\ba\u0006\u001c7.Y4f\u0013\t\t%IA\u0002TKFT!a\u0010\u0013\t\u000b\u0011\u001b\u0001\u0019\u0001\u001e\u0002-\u0015D\b/Z2uK\u0012\u001c6-\u00198oK\u0012\u001cu\u000e\\;n]NDQAR\u0002A\u0002\u001d\u000b!#\u001a=qK\u000e$X\r\u001a)beR4\u0016\r\\;fgB\u00191\b\u0011\u001e")
public class PruningSuite
extends HiveComparisonTest
implements BeforeAndAfter {
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return FunSuiteLike.runTest$((FunSuiteLike)this, (String)testName, (Args)args);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return BeforeAndAfterAll.run$((BeforeAndAfterAll)this, (Option)testName, (Args)args);
    }

    public void before(Function0<Object> fun, Position pos) {
        BeforeAndAfter.before$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public void after(Function0<Object> fun, Position pos) {
        BeforeAndAfter.after$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.runTest$((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.run$((BeforeAndAfter)this, testName, (Args)args);
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    public void beforeAll() {
        super.beforeAll();
        TestHive$.MODULE$.setCacheTables(false);
        TestHive$.MODULE$.reset();
    }

    public void createPruningTest(String testCaseName, String sql, Seq<String> expectedOutputColumns, Seq<String> expectedScannedColumns, Seq<Seq<String>> expectedPartValues) {
        this.test(new StringBuilder(15).append(testCaseName).append(" - pruning test").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparkPlan plan = new TestHiveQueryExecution(sql).sparkPlan();
            Seq actualOutputColumns = (Seq)plan.output().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.name(), Seq$.MODULE$.canBuildFrom());
            Tuple2 tuple2 = (Tuple2)plan.collect((PartialFunction)new scala.Serializable(null){
                public static final long serialVersionUID = 0L;

                public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 instanceof HiveTableScanExec) {
                        HiveTableScanExec hiveTableScanExec = (HiveTableScanExec)A1;
                        Seq columns = hiveTableScanExec.requestedAttributes();
                        HiveTableRelation relation = hiveTableScanExec.relation();
                        Seq columnNames = (Seq)columns.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.name(), Seq$.MODULE$.canBuildFrom());
                        Seq partValues = relation.isPartitioned() ? (Seq)hiveTableScanExec.prunePartitions(hiveTableScanExec.rawPartitions()).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getValues(), Seq$.MODULE$.canBuildFrom()) : (Seq)Seq$.MODULE$.empty();
                        object = new Tuple2((Object)columnNames, (Object)partValues);
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(SparkPlan x1) {
                    SparkPlan sparkPlan = x1;
                    boolean bl = sparkPlan instanceof HiveTableScanExec;
                    return bl;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.apache.spark.sql.catalyst.expressions.Attribute ), $anonfun$applyOrElse$2(org.apache.hadoop.hive.ql.metadata.Partition )}, serializedLambda);
                }
            }).head();
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Seq actualScannedColumns = (Seq)tuple2._1();
            Seq actualPartValues = (Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)actualScannedColumns, (Object)actualPartValues);
            Tuple2 tuple23 = tuple22;
            Seq actualScannedColumns2 = (Seq)tuple23._1();
            Seq actualPartValues2 = (Seq)tuple23._2();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(actualOutputColumns);
            Seq $org_scalatest_assert_macro_right = expectedOutputColumns;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Output columns mismatch", Prettifier$.MODULE$.default(), new Position("PruningSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 164));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(actualScannedColumns2.sorted((Ordering)Ordering.String$.MODULE$));
            Seq $org_scalatest_assert_macro_right2 = (Seq)expectedScannedColumns.sorted((Ordering)Ordering.String$.MODULE$);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"Scanned columns mismatch", Prettifier$.MODULE$.default(), new Position("PruningSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 169));
            Seq actualPartitions = (Seq)((SeqLike)actualPartValues2.map((Function1 & Serializable & scala.Serializable)x$5 -> ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(x$5).asScala()).mkString(","), Seq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.String$.MODULE$);
            Seq expectedPartitions = (Seq)((SeqLike)expectedPartValues.map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.mkString(","), Seq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.String$.MODULE$);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(actualPartitions);
            Seq $org_scalatest_assert_macro_right3 = expectedPartitions;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"Partitions selected do not match", Prettifier$.MODULE$.default(), new Position("PruningSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 175));
        }, new Position("PruningSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 150));
        this.createQueryTest(new StringBuilder(13).append(testCaseName).append(" - query test").toString(), sql, this.createQueryTest$default$3(), this.createQueryTest$default$4(), this.createQueryTest$default$5());
    }

    public PruningSuite() {
        BeforeAndAfter.$init$((BeforeAndAfter)this);
        this.createPruningTest("Column pruning - with partitioned table", "SELECT key FROM srcpart WHERE ds = '2008-04-08' LIMIT 3", (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key"}))), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key"}))), (Seq<Seq<String>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2008-04-08", "11"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2008-04-08", "12"}))}))));
        this.createPruningTest("Column pruning - with non-partitioned table", "SELECT key FROM src WHERE key > 10 LIMIT 3", (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key"}))), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key"}))), (Seq<Seq<String>>)((Seq)Seq$.MODULE$.empty()));
        this.createPruningTest("Column pruning - with multiple projects", "SELECT c1 FROM (SELECT key AS c1 FROM src WHERE key > 10) t1 LIMIT 3", (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c1"}))), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key"}))), (Seq<Seq<String>>)((Seq)Seq$.MODULE$.empty()));
        this.createPruningTest("Column pruning - projects alias substituting", "SELECT c1 AS c2 FROM (SELECT key AS c1 FROM src WHERE key > 10) t1 LIMIT 3", (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c2"}))), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key"}))), (Seq<Seq<String>>)((Seq)Seq$.MODULE$.empty()));
        this.createPruningTest("Column pruning - filter alias in-lining", "SELECT c1 FROM (SELECT key AS c1 FROM src WHERE key > 10) t1 WHERE c1 < 100 LIMIT 3", (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c1"}))), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key"}))), (Seq<Seq<String>>)((Seq)Seq$.MODULE$.empty()));
        this.createPruningTest("Column pruning - without filters", "SELECT c1 FROM (SELECT key AS c1 FROM src) t1 LIMIT 3", (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c1"}))), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key"}))), (Seq<Seq<String>>)((Seq)Seq$.MODULE$.empty()));
        this.createPruningTest("Column pruning - simple top project without aliases", "SELECT key FROM (SELECT key FROM src WHERE key > 10) t1 WHERE key < 100 LIMIT 3", (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key"}))), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key"}))), (Seq<Seq<String>>)((Seq)Seq$.MODULE$.empty()));
        this.createPruningTest("Column pruning - non-trivial top project with aliases", "SELECT c1 * 2 AS dbl FROM (SELECT key AS c1 FROM src WHERE key > 10) t1 LIMIT 3", (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dbl"}))), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key"}))), (Seq<Seq<String>>)((Seq)Seq$.MODULE$.empty()));
        this.createPruningTest("Partition pruning - non-partitioned, non-trivial project", "SELECT key * 2 AS dbl FROM src WHERE value IS NOT NULL", (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dbl"}))), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key", "value"}))), (Seq<Seq<String>>)((Seq)Seq$.MODULE$.empty()));
        this.createPruningTest("Partition pruning - non-partitioned table", "SELECT value FROM src WHERE key IS NOT NULL", (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value", "key"}))), (Seq<Seq<String>>)((Seq)Seq$.MODULE$.empty()));
        this.createPruningTest("Partition pruning - with filter on string partition key", "SELECT value, hr FROM srcpart1 WHERE ds = '2008-04-08'", (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value", "hr"}))), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value", "hr"}))), (Seq<Seq<String>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2008-04-08", "11"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2008-04-08", "12"}))}))));
        this.createPruningTest("Partition pruning - with filter on int partition key", "SELECT value, hr FROM srcpart1 WHERE hr < 12", (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value", "hr"}))), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value", "hr"}))), (Seq<Seq<String>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2008-04-08", "11"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2008-04-09", "11"}))}))));
        this.createPruningTest("Partition pruning - left only 1 partition", "SELECT value, hr FROM srcpart1 WHERE ds = '2008-04-08' AND hr < 12", (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value", "hr"}))), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value", "hr"}))), (Seq<Seq<String>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2008-04-08", "11"}))}))));
        this.createPruningTest("Partition pruning - all partitions pruned", "SELECT value, hr FROM srcpart1 WHERE ds = '2014-01-27' AND hr = 11", (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value", "hr"}))), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value", "hr"}))), (Seq<Seq<String>>)((Seq)Seq$.MODULE$.empty()));
        this.createPruningTest("Partition pruning - pruning with both column key and partition key", "SELECT value, hr FROM srcpart1 WHERE value IS NOT NULL AND hr < 12", (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value", "hr"}))), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value", "hr"}))), (Seq<Seq<String>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2008-04-08", "11"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2008-04-09", "11"}))}))));
    }
}

