/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.execution;

import java.io.File;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.hive.HiveExternalCatalog;
import org.apache.spark.sql.hive.HiveUtils$;
import org.apache.spark.sql.hive.client.HiveClient;
import org.apache.spark.sql.hive.test.TestHiveContext;
import org.apache.spark.sql.hive.test.TestHiveSingleton;
import org.apache.spark.sql.internal.StaticSQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.tags.ExtendedHiveTest;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ExtendedHiveTest
@ScalaSignature(bytes="\u0006\u0001Q4A!\u0003\u0006\u0001/!)1\u0006\u0001C\u0001Y!9q\u0006\u0001a\u0001\n\u0013\u0001\u0004bB\u001b\u0001\u0001\u0004%IA\u000e\u0005\u0007\u007f\u0001\u0001\u000b\u0015B\u0019\t\u000b\u0001\u0003A\u0011I!\t\u000b\t\u0003A\u0011I!\t\u000b\r\u0003A\u0011\u0002#\t\u000f\u0005\u0004\u0011\u0013!C\u0005E\n\t\u0002*\u001b<f?Jz\u0016g\u0018#E\u0019N+\u0018\u000e^3\u000b\u0005-a\u0011!C3yK\u000e,H/[8o\u0015\tia\"\u0001\u0003iSZ,'BA\b\u0011\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003#I\tQa\u001d9be.T!a\u0005\u000b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005)\u0012aA8sO\u000e\u00011#\u0002\u0001\u00199\tB\u0003CA\r\u001b\u001b\u0005\u0001\u0012BA\u000e\u0011\u00055\u0019\u0006/\u0019:l\rVt7+^5uKB\u0011Q\u0004I\u0007\u0002=)\u0011q\u0004D\u0001\u0005i\u0016\u001cH/\u0003\u0002\"=\t\tB+Z:u\u0011&4XmU5oO2,Go\u001c8\u0011\u0005\r2S\"\u0001\u0013\u000b\u0005\u0015\"\u0012!C:dC2\fG/Z:u\u0013\t9CE\u0001\nCK\u001a|'/Z!oI\u00063G/\u001a:FC\u000eD\u0007CA\u0012*\u0013\tQCEA\tCK\u001a|'/Z!oI\u00063G/\u001a:BY2\fa\u0001P5oSRtD#A\u0017\u0011\u00059\u0002Q\"\u0001\u0006\u0002\u000f\r\fG/\u00197pOV\t\u0011\u0007\u0005\u00023g5\tA\"\u0003\u00025\u0019\t\u0019\u0002*\u001b<f\u000bb$XM\u001d8bY\u000e\u000bG/\u00197pO\u0006Y1-\u0019;bY><w\fJ3r)\t9T\b\u0005\u00029w5\t\u0011HC\u0001;\u0003\u0015\u00198-\u00197b\u0013\ta\u0014H\u0001\u0003V]&$\bb\u0002 \u0004\u0003\u0003\u0005\r!M\u0001\u0004q\u0012\n\u0014\u0001C2bi\u0006dwn\u001a\u0011\u0002\u0013\u00054G/\u001a:FC\u000eDG#A\u001c\u0002\u0011\u00054G/\u001a:BY2\fa\u0002^3ti\u0006cG/\u001a:UC\ndW\rF\u00038\u000bJ#F\fC\u0003G\u000f\u0001\u0007q)A\u0005uC\ndWMT1nKB\u0011\u0001j\u0014\b\u0003\u00136\u0003\"AS\u001d\u000e\u0003-S!\u0001\u0014\f\u0002\rq\u0012xn\u001c;?\u0013\tq\u0015(\u0001\u0004Qe\u0016$WMZ\u0005\u0003!F\u0013aa\u0015;sS:<'B\u0001(:\u0011\u0015\u0019v\u00011\u0001H\u0003=\u0019'/Z1uKR\u000b'\r\\3Ti6$\b\"B+\b\u0001\u00041\u0016!D;qI\u0006$X\rZ*dQ\u0016l\u0017\r\u0005\u0002X56\t\u0001L\u0003\u0002Z\u001d\u0005)A/\u001f9fg&\u00111\f\u0017\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007bB/\b!\u0003\u0005\rAX\u0001\u000fQ&4XmQ8na\u0006$\u0018N\u00197f!\tAt,\u0003\u0002as\t9!i\\8mK\u0006t\u0017\u0001\u0007;fgR\fE\u000e^3s)\u0006\u0014G.\u001a\u0013eK\u001a\fW\u000f\u001c;%iU\t1M\u000b\u0002_I.\nQ\r\u0005\u0002gW6\tqM\u0003\u0002iS\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003Uf\n!\"\u00198o_R\fG/[8o\u0013\tawMA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D#\u0001\u00018\u0011\u0005=\u0014X\"\u00019\u000b\u0005E\u0004\u0012\u0001\u0002;bONL!a\u001d9\u0003!\u0015CH/\u001a8eK\u0012D\u0015N^3UKN$\b")
public class Hive_2_1_DDLSuite
extends SparkFunSuite
implements TestHiveSingleton,
BeforeAndAfterEach {
    private HiveExternalCatalog catalog;
    private final boolean enableAutoThreadAudit;
    private final SparkSession spark;
    private final TestHiveContext hiveContext;
    private final HiveClient hiveClient;

    public /* synthetic */ Status org$scalatest$BeforeAndAfterEach$$super$runTest(String testName, Args args) {
        return FunSuiteLike.runTest$((FunSuiteLike)this, (String)testName, (Args)args);
    }

    public void beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfterEach.runTest$((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$hive$test$TestHiveSingleton$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public boolean enableAutoThreadAudit() {
        return this.enableAutoThreadAudit;
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public TestHiveContext hiveContext() {
        return this.hiveContext;
    }

    @Override
    public HiveClient hiveClient() {
        return this.hiveClient;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$enableAutoThreadAudit_$eq(boolean x$1) {
        this.enableAutoThreadAudit = x$1;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$hiveContext_$eq(TestHiveContext x$1) {
        this.hiveContext = x$1;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$hiveClient_$eq(HiveClient x$1) {
        this.hiveClient = x$1;
    }

    private HiveExternalCatalog catalog() {
        return this.catalog;
    }

    private void catalog_$eq(HiveExternalCatalog x$1) {
        this.catalog = x$1;
    }

    public void afterEach() {
        this.catalog().listTables("default").foreach((Function1 & Serializable & scala.Serializable)t -> {
            Hive_2_1_DDLSuite.$anonfun$afterEach$1(this, t);
            return BoxedUnit.UNIT;
        });
        this.spark().sessionState().catalog().reset();
    }

    @Override
    public void afterAll() {
        try {
            this.catalog_$eq(null);
        }
        finally {
            TestHiveSingleton.afterAll$(this);
        }
    }

    private void testAlterTable(String tableName, String createTableStmt, StructType updatedSchema, boolean hiveCompatible) {
        this.spark().sql(createTableStmt);
        CatalogTable oldTable = this.spark().sessionState().catalog().externalCatalog().getTable("default", tableName);
        this.catalog().createTable(oldTable, true);
        this.catalog().alterTableDataSchema("default", tableName, updatedSchema);
        CatalogTable updatedTable = this.catalog().getTable("default", tableName);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(updatedTable.schema().fieldNames());
        String[] $org_scalatest_assert_macro_right = updatedSchema.fieldNames();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("Hive_2_1_DDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
    }

    private boolean testAlterTable$default$4() {
        return true;
    }

    public static final /* synthetic */ void $anonfun$afterEach$1(Hive_2_1_DDLSuite $this, String t) {
        $this.catalog().dropTable("default", t, true, false);
    }

    public Hive_2_1_DDLSuite() {
        TestHiveSingleton.$init$(this);
        BeforeAndAfterEach.$init$((BeforeAndAfterEach)this);
        File warehouse = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
        File metastore = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
        metastore.delete();
        SparkConf sparkConf = new SparkConf().set("spark.master", "local").set(StaticSQLConf$.MODULE$.WAREHOUSE_PATH().key(), warehouse.toURI().toString()).set(StaticSQLConf$.MODULE$.CATALOG_IMPLEMENTATION().key(), "hive").set(HiveUtils$.MODULE$.HIVE_METASTORE_VERSION().key(), "2.1").set(HiveUtils$.MODULE$.HIVE_METASTORE_JARS().key(), "maven");
        Configuration hadoopConf = new Configuration();
        hadoopConf.set("hive.metastore.warehouse.dir", warehouse.toURI().toString());
        hadoopConf.set("javax.jdo.option.ConnectionURL", new StringBuilder(37).append("jdbc:derby:;databaseName=").append(metastore.getAbsolutePath()).append(";create=true").toString());
        hadoopConf.set("datanucleus.schema.autoCreateAll", "true");
        hadoopConf.set("hive.metastore.schema.verification", "false");
        this.catalog = new HiveExternalCatalog(sparkConf, hadoopConf);
        this.test("SPARK-21617: ALTER TABLE for non-compatible DataSource tables", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testAlterTable("t1", "CREATE TABLE t1 (c1 int) USING json", new StructType((StructField[])((Object[])new StructField[]{new StructField("c1", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("c2", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})), false), new Position("Hive_2_1_DDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
        this.test("SPARK-21617: ALTER TABLE for Hive-compatible DataSource tables", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testAlterTable("t1", "CREATE TABLE t1 (c1 int) USING parquet", new StructType((StructField[])((Object[])new StructField[]{new StructField("c1", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("c2", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})), this.testAlterTable$default$4()), new Position("Hive_2_1_DDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92));
        this.test("SPARK-21617: ALTER TABLE for Hive tables", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testAlterTable("t1", "CREATE TABLE t1 (c1 int) STORED AS parquet", new StructType((StructField[])((Object[])new StructField[]{new StructField("c1", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("c2", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})), this.testAlterTable$default$4()), new Position("Hive_2_1_DDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
        this.test("SPARK-21617: ALTER TABLE with incompatible schema on Hive-compatible table", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            AnalysisException exception = (AnalysisException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testAlterTable("t1", "CREATE TABLE t1 (c1 string) USING parquet", new StructType((StructField[])((Object[])new StructField[]{new StructField("c2", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})), this.testAlterTable$default$4()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("Hive_2_1_DDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
            String $org_scalatest_assert_macro_left = exception.getMessage();
            String $org_scalatest_assert_macro_right = "types incompatible with the existing columns";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("Hive_2_1_DDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113));
        }, new Position("Hive_2_1_DDLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
    }
}

